<?php

namespace App\PodUploads;

use App\PodUploads\Constants\DocumentType;

trait CheckSignatureAndPodTrait
{
    /**
     * @param array $d
     * @return array
     */
    private function checkSignatureAndPod(array $d): array
    {
        $tripId = (int)($d['id'] ?? "");
        $shiftId = (int)($d['shift_id'] ?? "");
        
        $tripIdEscaped = $this->db->escape_str($tripId);
        $shiftIdEscaped = $this->db->escape_str($shiftId);
        
        $pod = $signature = "";
        
        $chkdoc = $this->db->query("select id,doc_type from tb_pod_uploads where doc_type in(1,3) and shipment_id = " . $shiftIdEscaped . " AND trip_id=" . $tripIdEscaped);
        $checkDocResult = !$chkdoc ? [] : $chkdoc->result();
        
        foreach ($checkDocResult as $doc) {
            if ((int)$doc->doc_type === DocumentType::SIGNATURE) {
                $signature = 1;
            } elseif ((int)$doc->doc_type === DocumentType::POD) {
                $pod = 1;
            }
        }
        
        return [$signature, $pod];
    }
}
