<?php

namespace App\PodUploads\MakePod;

class CompletedOrderPodData extends PodData {

    private array $params = [];

    public static function fromPodData(PodData $podData): PodData {
        return new self(
            $podData->getShipperAddress(),
            $podData->getConsigneeAddress(),
            $podData->getActualPickupDateTime(),
            $podData->getActualDeliveryDateTime(),
            $podData->getBookingId(),
            $podData->getExternalOrderId(),
            $podData->getSignatureFile(),
            $podData->getSignatureHash(),
            $podData->getDeliveryComments(),
            $podData->measurements(),
            $podData->curtz(),
            $podData->getCompanyCode(),
            $podData->getDocumentDate()
        );
    }

    public function add(array $params): void {
        $this->params = $params;
    }

    public function toArray(): array {
        return array_merge(
            parent::toArray(),
            $this->params
        );
    }
}
