<?php

namespace App\PodUploads\MakePod;

use App\Time\Timer;
use CI_Controller;

class MakePodFromOrderAndSignature
{
    /**
     * @var CI_Controller
     */
    private $CI;
    private PodFilename $podFilename;

    public function __construct(CI_Controller $CI) {
        $this->CI = $CI;
        $this->podFilename = new PodFilename(new Timer());
    }

    public function download(PodData $podData, string $template): string {
        return $this->build($podData, $template, true);
    }

    /**
     * @return string Filename of the generated POD document
     */
    public function make(PodData $podData): string {
        return $this->build($podData, 'customer/downloadepod_openboxes', false);
    }

    private function build(PodData $podData, string $template, bool $downloadFlag): string {
        $this->CI->load->library('m_pdf');
        $html = $this->CI->load->view(
            $template,
            $podData->toArray(),
            true
        );

        $fileName = $this->podFilename->getFileName($podData->getExternalOrderId());

        $this->CI->m_pdf->resetInstance();
        $this->CI->m_pdf->pdf->WriteHTML($html);
        $this->CI->m_pdf->pdf->Output($fileName, $downloadFlag ? 'D' : '');

        return basename($fileName);
    }
}
