<?php

namespace App\PodUploads\MakePod;

class Measurements
{
    /**
     * @var float
     */
    private $quantity;
    /**
     * @var float
     */
    private $volume;
    /**
     * @var float
     */
    private $weight;

    public function __construct(float $quantity, float $volume, float $weight) {
        $this->quantity = $quantity;
        $this->volume = $volume;
        $this->weight = $weight;
    }

    /**
     * @return float
     */
    public function getQuantity(): float
    {
        return $this->quantity;
    }

    /**
     * @return float
     */
    public function getVolume(): float
    {
        return $this->volume;
    }

    /**
     * @return float
     */
    public function getWeight(): float
    {
        return $this->weight;
    }

    public function toArray(): array
    {
        return [
            'quantity' => $this->quantity,
            'volume' => $this->volume,
            'weight' => $this->weight,
        ];
    }
}
