<?php

namespace App\PodUploads\MakePod;

use DateTime;

class PodData
{
    /**
     * @var Address
     */
    private $shipperAddress;
    /**
     * @var Address
     */
    private $consigneeAddress;
    /**
     * @var DateTime
     */
    private $actualPickupDateTime;
    /**
     * @var DateTime
     */
    private $actualDeliveryDateTime;
    /**
     * @var string
     */
    private $bookingId;
    /**
     * @var string
     */
    private $externalOrderId;
    /**
     * @var string
     */
    private $signatureFile;
    /**
     * @var string
     */
    private $signatureHash;
    /**
     * @var string
     */
    private $deliveryComments;
    /**
     * @var Measurements
     */
    private $measurements;
    /**
     * @var string
     */
    private $curtz;
    /**
     * @var string
     */
    private $companyCode;
    /**
     * @var string
     */
    private $documentDate;

    public function __construct(
        Address $shipperAddress,
        Address $consigneeAddress,
        ?DateTime $actualPickupDateTime,
        ?DateTime $actualDeliveryDateTime,
        string $bookingId, string $externalOrderId,
        string $signatureFile,
        string $signatureHash,
        string $deliveryComments,
        Measurements $measurements,
        string $curtz,
        string $companyCode,
        string $documentDate = ''
    )
    {
        $this->shipperAddress = $shipperAddress;
        $this->consigneeAddress = $consigneeAddress;
        $this->actualPickupDateTime = $actualPickupDateTime;
        $this->actualDeliveryDateTime = $actualDeliveryDateTime;
        $this->bookingId = $bookingId;
        $this->externalOrderId = $externalOrderId;
        $this->signatureFile = $signatureFile;
        $this->signatureHash = $signatureHash;
        $this->deliveryComments = $deliveryComments;
        $this->measurements = $measurements;
        $this->curtz = $curtz;
        $this->companyCode = $companyCode;
        $this->documentDate = $documentDate ?: date("d/M/Y");

    }

    /**
     * @return Address
     */
    public function getShipperAddress(): Address
    {
        return $this->shipperAddress;
    }

    /**
     * @return Address
     */
    public function getConsigneeAddress(): Address
    {
        return $this->consigneeAddress;
    }

    /**
     * @return ?DateTime
     */
    public function getActualPickupDateTime(): ?DateTime
    {
        return $this->actualPickupDateTime;
    }

    /**
     * @return ?DateTime
     */
    public function getActualDeliveryDateTime(): ?DateTime
    {
        return $this->actualDeliveryDateTime;
    }

    /**
     * @return string
     */
    public function getBookingId(): string
    {
        return $this->bookingId;
    }

    /**
     * @return string
     */
    public function getExternalOrderId(): string
    {
        return $this->externalOrderId;
    }

    /**
     * @return string
     */
    public function getSignatureFile(): string
    {
        return $this->signatureFile;
    }

    /**
     * @return string
     */
    public function getSignatureHash(): string
    {
        return $this->signatureHash;
    }

    /**
     * @return string
     */
    public function getDeliveryComments(): string
    {
        return $this->deliveryComments;
    }

    public function measurements(): Measurements
    {
        return $this->measurements;
    }

    public function curtz(): string
    {
        return $this->curtz;
    }

    public function getCompanyCode(): string
    {
        return $this->companyCode;
    }

    public function getDocumentDate(): string
    {
        return $this->documentDate;
    }

    public function toArray(): array
    {
        return [
            'shipperAddress' => $this->shipperAddress->__toString(),
            'consigneeAddress' => $this->consigneeAddress->__toString(),
            'actualPickupDateTime' => $this->actualPickupDateTime
                ? $this->actualPickupDateTime->format('Y-m-d H:i:s')
                : '',
            'actualDeliveryDateTime' => $this->actualDeliveryDateTime
                ? $this->actualDeliveryDateTime->format('Y-m-d H:i:s')
                : '',
            'bookingId' => $this->bookingId,
            'externalOrderId' => $this->externalOrderId,
            'signatureFile' => $this->signatureFile,
            'signatureHash' => $this->signatureHash,
            'deliveryComments' => $this->deliveryComments,
            'measurements' => $this->measurements->toArray(),
            'curtz' => $this->curtz,
            'companyCode' => $this->companyCode,
            'documentDate' => $this->documentDate
        ];
    }
}
