<?php

declare(strict_types=1);

namespace App\PodUploads;

final class PodFile
{
    private string $fileName;
    private string $podPath;
    private string $backupPath;

    public function __construct(string $fileName)
    {
        $this->fileName = $fileName;
        $this->backupPath = '/home/svkonekt/assets/poduploads/' . $fileName;
        $this->podPath = '/home/svkonekt/assets/poduploads/' . $fileName;
    }

    public function getPath(): string
    {
        if (file_exists($this->podPath)) {
            return $this->stripBasePath($this->podPath);
        }

        if (file_exists($this->backupPath)) {
            copy($this->backupPath, $this->podPath);
            unlink($this->backupPath);
            return $this->stripBasePath($this->podPath);
        }

        if ($this->ifAlternativeFileExists()) {
            return $this->stripBasePath($this->podPath);
        }

        throw new \Exception(
            sprintf('POD %s could not be found', $this->fileName)
        );
    }

    public function getAbsolutePath(): string
    {
        if (file_exists($this->podPath)) {
            return $this->podPath;
        }

        if (file_exists($this->backupPath)) {
            return $this->backupPath;
        }

        if ($this->ifAlternativeFileExists()) {
            return $this->podPath;
        }

        throw new \Exception(
            sprintf('Absolute path cannot be found for POD %s', $this->fileName)
        );
    }

    private function stripBasePath(string $path): string
    {
        return str_replace('/home/efs', '', $path);
    }

    private function ifAlternativeFileExists(): bool
    {
        $alternativeFileName = str_replace("-", " ", $this->fileName);

        if (!file_exists($alternativeFileName)){
            return false;
        }
        copy($alternativeFileName, $this->podPath);
        return true;
    }
}
