<?php

declare(strict_types=1);

namespace App\Reporting\MisReport;

final class CurrentStatus
{
    private const DELIVERED_STATUS = 'Delivered';
    private const IN_TRANSIT_STATUS = 'In-Transit';

    private string $currentStatus = '';
    private string $remarks;
    private string $lastStatusName;
    private string $statusType;

    public function __construct(array $orderScans, string $lastStatusName)
    {
        if (empty($orderScans)) {
            throw new \Exception('Cannot fetch current status for empty data set');
        }

        foreach ($orderScans as $orderScan) {
            if ($orderScan['scan_val'] === self::DELIVERED_STATUS) {
                $this->currentStatus = $orderScan['scan_instruction'];
            }
        }

        $lastScan = array_pop($orderScans);
        if (!in_array($lastStatusName, [self::DELIVERED_STATUS, self::IN_TRANSIT_STATUS])) {
            $lastStatusName = $lastScan['scan_val'];
            $lastStatusName = $this->unifyCanceledStatus($lastStatusName);
        }

        $this->lastStatusName = $lastStatusName;
        $this->remarks = $lastScan['scan_instruction'];
        $this->statusType = $lastScan['scan_val'];
    }

    public function currentStatus(string $orderStatusType): string
    {
        if ($orderStatusType === self::DELIVERED_STATUS) {
            return self::DELIVERED_STATUS;
        }

        return $this->currentStatus ?: $this->remarks;
    }

    public function remarks(): string
    {
        return $this->remarks;
    }

    public function lastStatusName(): string
    {
        return $this->lastStatusName;
    }

    public function statusType(): string
    {
        return $this->statusType;
    }

    private function unifyCanceledStatus(string $lastStatusName): string
    {
        if ($lastStatusName === 'Canceled') {
            $lastStatusName = 'Cancelled';
        }

        return $lastStatusName;
    }
}
