<?php

declare(strict_types=1);

namespace App\Reporting\MisReport;

use App\Reporting\MisReport\Vendor\VendorInterface;
use DateTimeImmutable;

final class DeliveryAttempts
{
    private const DATE_FORMAT = 'Y-m-d';

    private $deliveryDate;
    private $txnclosed = '';
    private $rtodtodate;
    private $rtoreason = '';

    public function __construct(array $orders, VendorInterface $vendor, string $stsType)
    {
        $deliveredStatusCode = ['200', '20001', '20002', '345', '34501', '239', '20003', '999'];

        foreach ($orders as $order) {
            if ($order['scan_val'] === "Delivered" || in_array(
                    $order['scan_status_code'],
                    $deliveredStatusCode
                )) {
                $this->deliveryDate = new DateTimeImmutable($order['scan_status_time']);
                $this->txnclosed = "Closed";
            }
            if (($vendor->isDelhivery() && $order['prev_scan_val'] === "RTO") || $order['prev_scan_val'] === "DTO") {
                $this->deliveryDate = new DateTimeImmutable($order['scan_status_time']);
                $this->txnclosed = "Closed";
                $this->rtodtodate = new DateTimeImmutable($order['scan_status_time']);
            }

            if ($stsType == "RTO" && $order['scan_val'] == "In Transit" && $order['scan_type'] == "UD") {
                $this->rtoreason .= $order['scan_instruction'] . ", ";
            }
        }
    }

    public function deliveryDate(): string
    {
        if (!$this->deliveryDate instanceof DateTimeImmutable) {
            return '';
        }

        return $this->deliveryDate->format(self::DATE_FORMAT);
    }

    public function rtodtodate(): string
    {
        if (!$this->rtodtodate instanceof DateTimeImmutable) {
            return '';
        }

        return $this->rtodtodate->format(self::DATE_FORMAT);
    }

    public function rtoreason(): string
    {
        return $this->rtoreason;
    }

    public function txnclosed(): string
    {
        return $this->txnclosed;
    }
}
