<?php

namespace App\Reporting\MisReport\Vendor;

final class VendorFactory
{
    private const DEFAULT_VENDOR_ID = 310;
    private const DELHIVERY_VENDOR_ID = 310;
    private const ECOM_VENDOR_ID = 311;

    public static function create(int $vendorId): VendorInterface
    {
        $vendorId = self::checkDefaultVendor($vendorId);

        if ($vendorId === self::DELHIVERY_VENDOR_ID) {
            return new DelhiveryVendor();
        }

        if ($vendorId === self::ECOM_VENDOR_ID) {
            return new EcomVendor();
        }

        throw new \Exception(sprintf('Unexpected vendor: %d', $vendorId));
    }

    private static function checkDefaultVendor(int $vendorId): int
    {
        if ($vendorId === 0) {
            return self::DEFAULT_VENDOR_ID;
        }

        return $vendorId;
    }
}
