<?php

namespace App\ShiftsData;

class GetDocumentStatusAndStopsData
{
    public static function getDocumentStatus($trip_id, $stop_id, $stop_detail_id, \CI_DB_mysqli_driver $db)
    {
        $whereParams = self::getInitialWhereParams($trip_id, $stop_id, $stop_detail_id);
        return self::documentStatus($db, $whereParams);
    }

    public static function getStopsData($trip_id, $stop_id, $stop_detail_id, $shipment_id, \CI_DB_mysqli_driver $db)
    {
        $whereParams = self::getInitialWhereParams($trip_id, $stop_id, $stop_detail_id);
        $where = self::getWhere($stop_id, $stop_detail_id, $whereParams, $shipment_id);
        return self::stopsData($db, $where);
    }

    /**
     * @param \CI_DB_mysqli_driver $db
     * @param string $where
     * @return array
     */
    private static function stopsData(\CI_DB_mysqli_driver $db, string $where): array
    {
        $stopsData = [];
        $qry = $db->query(
            "SELECT s.latitude,s.longitude,s.createdon,m.status_name, s.stop_type, s.status_code, s.comment
            FROM tb_stop_status s,tb_status_master m
            WHERE s.status_id=m.id $where ORDER BY s.createdon asc"
        );
        log_message("error","111:".$db->last_query());
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $placename = getLocationName($res->latitude, $res->longitude);
                $stopsData[] = [
                    'status_name' => $res->status_name,
                    'place' => $placename,
                    'createdon' => strtotime($res->createdon),
                    'stop_type' => $res->stop_type,
                    'status_code' => $res->status_code,
                    'comment' => in_array($res->status_code, ['0500', '2300', '3000']) ? $res->comment : '',
                ];
            }
        }
        log_message("error","222:".json_encode($stopsData));
        return $stopsData;
    }

    /**
     * @param $trip_id
     * @param $stop_id
     * @param $stop_detail_id
     * @return array
     */
    private static function getInitialWhereParams($trip_id, $stop_id, $stop_detail_id): array
    {
        $whereParams["trip_id"] = $trip_id;

        if ($stop_id != null) {
            $whereParams["stop_id"] = $stop_id;
        }
        if ($stop_detail_id != null) {
            $whereParams["stop_detail_id"] = $stop_detail_id;
        }
        return $whereParams;
    }

    /**
     * @param \CI_DB_mysqli_driver $db
     * @param array $whereParams
     * @return int
     */
    private static function documentStatus(\CI_DB_mysqli_driver $db, array $whereParams): int
    {
        $sign_sign = $db->select('id')->get_where('tb_pod_uploads', $whereParams, 1, 0);
        return $sign_sign->num_rows() > 0 ? 1 : 0;
    }

    /**
     * @param $stop_id
     * @param $stop_detail_id
     * @param array $whereParams
     * @param $shipment_id
     * @return string
     */
    private static function getWhere($stop_id, $stop_detail_id, array $whereParams, $shipment_id): string
    {
        $where = "";
        if ($stop_id != null) {
            $where = " AND s.stop_id = $stop_id";
        }
        if ($stop_detail_id != null) {
            $where .= " AND s.stop_detail_id = $stop_detail_id";
        }
        if ($whereParams["trip_id"] != "") {
            $where .= " AND s.trip_id='" . $whereParams["trip_id"] . "'";
        } else {
            if ($shipment_id != "") {
                $whereParams["shipment_id"] = $shipment_id;
                $where .= " AND s.shipment_id='" . $whereParams["shipment_id"] . "'";
            }
        }
        return $where;
    }
}
