<?php

namespace App\ShipmentStopDetails;

use App\ApiRequest\DataPreprocessing\NoDataFoundException;
use App\ApiRequest\GetPartyInformation;
use CI_DB_mysqli_prod_driver;
use CI_Model;

class ShipmentStopDetailsService
{
    private const MILESTONE_NOT_STARTED = 0;
    private const MILESTONE_STARTED = 1;
    private const MILESTONE_COMPLETED = 2;

    public static function getShipmentStopDetails(string $curtz, string $shift_id, string $stop_id, string $trip, string $stop_sts, string $order_id, CI_DB_mysqli_prod_driver $db, CI_Model $common, bool $acceptedOnly): array
    {
        //log_message("error","Innnnnnnnnn:::");
        $result = [];
        $goods = [];
        $package = "";
        $content = "";
        $instructions = "";

        $where =  $acceptedOnly  ? ' AND accepted = 1 ' : '';
        $query = self::getStopDetailsData($shift_id, $stop_id, $order_id, $curtz, $where, $db);
        //log_message("error","getStopDetailsDataquery:::".$db->last_query());

        if ($query->num_rows() == 0) {
            throw new NoDataFoundException("Shipment stop details not found.");
        }

        $milestoneStatus = self::MILESTONE_NOT_STARTED;
        $k = 0;
        $index = 0;
        //log_message("error","query->result():::".json_encode($query->result()));
        foreach ($query->result() as $res) {
            $allstatus['274'] = $allstatus['275'] = $allstatus['278'] = $allstatus['279'] = $allstatus['280'] = $allstatus['281'] = $allstatus['285'] = $allstatus['286'] = 0;
            $status = 'N';
            $statusid = '0';
            $check_in = '';
            $reason = '';

            $custname = $res->customer_name;
            $custmobi = $res->custphone;

            $whr = array('stop_id' => $res->stop_id);
            $getsts = self::getStopStatus($whr, $curtz, $db);

            if (!empty($getsts)) {
                $status = $getsts['name'];
                $statusid = $getsts['status_id'];
                $check_in = strtotime($getsts['createdon']);
                $reason = $getsts['name'];
            }

            $stop_detail_id = $res->id;
            list($milestoneStatus, $anystatus, $has_pod, $allstatus) = self::extractShipmentStopDetailsStatus($milestoneStatus, $shift_id, $stop_id, $stop_detail_id, $allstatus, $trip, $res, $db);

            $material = $res->material_name == "" ? $res->material_name : $res->name;
            $drop = PrepareShipmentStopDetailsResult::prepareAddress($res->drop_city, $res->drop);
            $pickup = PrepareShipmentStopDetailsResult::prepareAddress($res->pickup_city, $res->pickup);

            if ($milestoneStatus != self::MILESTONE_NOT_STARTED) {
                $k = 1;
            }

            $order_id = $res->order_id;
            $ship_type = $res->ship_type;
            $orderRowId = $res->tb_orders_id;
            $cargo_orders = $db->query("SELECT cd.dg_goods, cd.stackable, cd.grounded, cd.splittable,
                    ocd.quantity_type, ocd.cargo_content, ocd.id, ocd.order_id, ocd.quantity
                FROM tb_cargo_details AS cd
                INNER JOIN tb_order_cargodetails AS ocd ON cd.id=ocd.cargo_id
                LEFT JOIN tb_orders AS o ON o.order_id = ?
                WHERE ocd.order_id=o.id", [$order_id]);

            list($package, $content, $goods) = PrepareShipmentStopDetailsResult::extractOrderCargoDetails($cargo_orders, $package, $content, $goods);
            $where_condition = $orderReferences = '';

            if ($ship_type == "P") {
                $where_condition = " and reference_id IN ('ORD_PIKINST','DQ','PO','HBL','BOL') AND status =1";
            } elseif ($ship_type == "D") {
                $where_condition = " and reference_id IN ('ORD_DLVINST','DQ','PO','HBL','BOL') AND status =1";
            }

            $orders_ref = $db->query("SELECT ref_value, reference_id
                FROM tb_order_references
                WHERE order_id = ?" . $where_condition, [$orderRowId]);
            $referenceQueryResult = $orders_ref->num_rows() > 0 ? $orders_ref->result_array() : [];
            foreach ($referenceQueryResult as $eachLine) {
                $referenceId = $eachLine['reference_id'];
                if (in_array($referenceId, ['ORD_PIKINST', 'ORD_DLVINST'])) {
                    $instructions = $eachLine['ref_value'];
                } else {
                    if ($orderReferences != "") {
                        $orderReferences .= " , ";
                    }
                    $orderReferences .= $referenceId . "-" . $eachLine['ref_value'];
                }
            }
            /*get shipper and consignee parties to get full address */
            $source = $destination = $source_party = $dest_party = "";
            $company_code = "";
            $chkcmp = $common->gettblrowdata(array("id" => $shift_id), "company_code", "tb_shifts", 0, 0);

            if (!empty($chkcmp)) {
                $company_code = $chkcmp['company_code'];
            }
            $stopsarr = array('sstop' => $stop_id, 'dstop' => $stop_id, 'shipment_id' => $shift_id, 'cmpcode' => $company_code);
            $partyaddr = GetPartyInformation::getPartyAddrByOrdStops($stopsarr, $index, $db);
            $index++;

            if (!empty($partyaddr)) {
                if (!empty($partyaddr['source'])) {
                    $source = $partyaddr['source'];
                    $source_party = $partyaddr['source_party'];
                }
                if (!empty($partyaddr['destination'])) {
                    $destination = $partyaddr['destination'];
                    $dest_party = $partyaddr['dest_party'];
                }
            }

            $result[] = [
                'id' => $res->id,
                'name' => $res->name,
                'pickup' => $pickup,
                'drop' => $drop,
                'phone' => $res->phone,
                'plat' => $res->plat,
                'plng' => $res->plng,
                'dlat' => $res->dlat,
                'dlng' => $res->dlng,
                'capacity' => $res->capacity,
                'ship_type' => $res->ship_type,
                'shipment_weight' => $res->shipment_weight,
                'shipment_volume' => $res->shipment_volume,
                'startdate' => strtotime($res->startdate),
                'enddate' => strtotime($res->enddate),
                'priority' => $res->priority,
                'status' => $status,
                'status_id' => $statusid,
                'check_in' => $check_in,
                'reason' => $reason,
                'milestone' => $milestoneStatus,
                'exists_status' => $anystatus,
                'material' => $material,
                'order_id' => $res->order_id,
                "accepted" => $res->accepted,
                'customer' => $custname,
                'customerphone' => $custmobi,
                "allstatus" => $allstatus,
                "has_pod" => $has_pod,
                'instructions' => $instructions,
                'package' => $package,
                'content' => $content,
                'goods' => $goods,
                'source' => $source,
                'destination' => $destination,
                'source_party' => $source_party,
                'dest_party' => $dest_party,
                'orderReferences' => $orderReferences
            ];
        }
        //log_message("error","PrepareResult111111111:::".json_encode($result));
        return PrepareShipmentStopDetailsResult::prepareResult($stop_sts, $k, $result);
    }

    private static function getStopStatus($whr, $curtz, $db): array
    {
        $res = [];
        if (self::checkForExistingStopStatus($whr, $db)) {
            $db->select("s.id, s.stop_type, s.status_id, convertToClientTZ(s.createdon,'" . $curtz . "') as createdon, t.status_name");
            $db->from('tb_stop_status s');
            $db->join('tb_status_master t', 's.status_id = t.id', 'INNER');
            $db->where($whr);
            $db->order_by('s.createdon', 'DESC');
            $db->limit(1);
            $chkrecent = $db->get();
            if ($chkrecent->num_rows() > 0) {
                $res['name'] = $chkrecent->row()->status_name;
                $res['id'] = $chkrecent->row()->id;
                $res['createdon'] = $chkrecent->row()->createdon;
                $res['status_id'] = $chkrecent->row()->status_id;
                $res['stop_type'] = $chkrecent->row()->stop_type;
            }
        }

        return $res;
    }

    /**
     * @param int $shift_id
     * @param int $stop_id
     * @param string $curtz
     * @param string $where
     * @param object $db
     * @return mixed
     */
    public static function getStopDetailsData(int $shift_id, int $stop_id, int $order_id, string $curtz, string $where, object $db)
    {
        $sql = "SELECT e.id,
                        convertToClientTZ(e.startdate, ?) AS startdate,
                        convertToClientTZ(e.enddate, ?) AS enddate,
                        IF(e.drop_stopid = ?, e.drop_stopid, e.stop_id) AS stop_id,
                        e.phone, e.pickup, e.plat, e.plng,
                        e.`drop`, e.drop_city, e.pickup_city, e.dlat, e.dlng,
                        convertToClientTZ(o.pickup_datetime, ?) AS pickup_datetime,
                        convertToClientTZ(o.delivery_datetime, ?) AS drop_datetime,
                        e.name, e.material_id, o.id as tb_orders_id,
                        IFNULL(
                            (SELECT SUM(cargo.weight) AS weight FROM tb_order_cargodetails cargo JOIN tb_orders odr ON odr.id=cargo.order_id WHERE cargo.status = 1 AND odr.order_id=e.order_id), 0
                        ) AS shipment_weight,
                        IFNULL(
                            (SELECT SUM(cargo.volume) AS volume FROM tb_order_cargodetails cargo JOIN tb_orders odr ON odr.id=cargo.order_id WHERE cargo.status = 1 AND odr.order_id=e.order_id), 0
                        ) AS shipment_volume,
                        IF(e.drop_stopid = ?, 'D', 'P') AS ship_type,
                        e.customer_id, e.vendor_id,
                        IF(e.drop_stopid = ?, e.drop_order, e.stop_order) AS priority,
                        e.order_id, e.capacity,
                        c.name AS customer_name,
                        c.phone AS custphone,
                        v.name AS carrier_name, m.material AS material_name, e.accepted
                    FROM `tb_employee` e
                        LEFT JOIN tb_orders o ON o.order_id = e.order_id
                        LEFT JOIN tb_order_cargodetails cargo ON cargo.order_id = o.id
                        LEFT JOIN tb_vendors v ON v.id = e.vendor_id
                        LEFT JOIN tb_customers c ON c.id = e.customer_id
                        LEFT JOIN tb_materials m ON m.id = e.material_id
                    WHERE e.shift_id = ? and o.order_id = ? AND e.status = 1 AND (e.stop_id = ? OR e.drop_stopid = ?)" . $where . "
                    GROUP BY priority, e.order_id
                    ORDER BY priority";

        return $db->query($sql, [$curtz, $curtz, $stop_id, $curtz, $curtz, $stop_id, $stop_id, $shift_id, $order_id, $stop_id, $stop_id]);
    }

    /**
     * @param int $shift_id
     * @param int $stop_id
     * @param string $curtz
     * @param string $where
     * @param object $db
     * @return mixed
     */
    public static function getStopDetailsDataV3(int $shift_id, int $stop_id, string $curtz, string $where, object $db)
    {
        $sql = "SELECT
                        cd.ldm,
                        cd.ldm_uom,
                        e.id,
                        e.assoc_id,
                        o.shipmentid,
                        o.created_source,
                        convertToClientTZ(e.startdate, ?) AS startdate,
                        convertToClientTZ(e.enddate, ?) AS enddate,
                        e.phone, e.stop_id, e.drop_stopid, e.pickup, e.plat, e.plng,
                        e.`drop`, e.dlat, e.dlng,
                        convertToClientTZ(o.pickup_datetime, ?) AS pickup_datetime,
                        convertToClientTZ(o.delivery_datetime, ?) AS drop_datetime,
                        convertToClientTZ(o.pickup_endtime, ?) AS pickup_late_datetime,
                        convertToClientTZ(o.drop_endtime, ?) AS drop_late_datetime,
                        e.name, e.material_id,
                        IFNULL(
                            (SELECT SUM(cargo.weight) AS weight FROM tb_order_cargodetails cargo JOIN tb_orders odr ON odr.id=cargo.order_id WHERE cargo.status = 1 AND odr.order_id=e.order_id), 0
                        ) AS shipment_weight,
                        IFNULL(
                            (SELECT SUM(cargo.volume) AS volume FROM tb_order_cargodetails cargo JOIN tb_orders odr ON odr.id=cargo.order_id WHERE cargo.status = 1 AND odr.order_id=e.order_id), 0
                        ) AS shipment_volume,
                        IF(e.drop_stopid = ?, 'D', 'P') AS ship_type,
                        e.customer_id, e.vendor_id, cd.weight_unit,
                        IF(e.drop_stopid = ?, e.drop_order, e.stop_order) AS priority,
                        e.order_id, o.id AS tb_orders_id, e.capacity,
                        c.name AS customer_name,
                        c.phone AS custphone,
                        v.name AS carrier_name,
                        m.material AS material_name,
                        e.accepted,
                        IFNULL(sm.name, '') AS service_name,
                        sm.service_id,
                        o.pickup_company,
                        o.company_code,
                        o.pickup_city,
                        o.pickup_country,
                        o.pickup_address1,
                        o.pickup_address2,
                        o.pickup_pincode,
                        o.delivery_country,
                        o.delivery_company,
                        o.delivery_city,
                        e.drop_city,
                        o.delivery_address1,
                        o.delivery_address2,
                        o.delivery_pincode,
                        cd.dg_goods,
                        cd.goods_description,
                        od.purchase_order,
                        cd.cargo_type,
                        ocd.handling_unit,
                        ocd.cargo_content,
                        ocd.order_id AS tb_order_cargodetails_orderid,
                        cd.length, cd.length_unit,
                        cd.width,
                        cd.width_unit,
                        cd.height,
                        cd.height_unit,
                        cd.quantity,
                        ocd.quantity_type,
                        cd.stackable,
                       cd.grounded,
                       cd.splittable,
                       cd.id AS cargo_id
                    FROM `tb_employee` e
                        LEFT JOIN tb_vendors AS v ON v.id = e.vendor_id
                        LEFT JOIN tb_customers AS c ON c.id = e.customer_id
                        LEFT JOIN tb_materials AS m ON m.id = e.material_id
                        LEFT JOIN tb_orders AS o ON (e.shift_id = o.shift_id AND e.order_id = o.order_id)
                        LEFT JOIN tb_order_details AS od ON (o.id = od.order_row_id)
                        LEFT JOIN tb_service_master AS sm ON (sm.id = od.service AND sm.status = 1)
                        LEFT JOIN tb_order_cargodetails AS ocd ON (ocd.order_id = o.id AND ocd.status = 1)
                        LEFT JOIN tb_cargo_details AS cd ON (cd.id = ocd.cargo_id AND cd.status = 1)
                    WHERE o.shift_id > 0 AND o.trip_id > 0 AND e.shift_id = ? AND e.status = 1 AND (e.stop_id = ? OR e.drop_stopid = ?)" . $where . "
                    GROUP BY priority, e.order_id
                    ORDER BY priority";

        return $db->query($sql, [$curtz, $curtz, $curtz, $curtz, $curtz, $curtz, $stop_id, $stop_id, $shift_id, $stop_id, $stop_id]);
    }

    public static function getCrossBorderStopDetailsDataV3(int $shift_id, int $stop_id, string $curtz, string $where, object $db){
        $sql = "SELECT
                        cd.ldm,
                        cd.ldm_uom,
                        e.id,
                        s.shipmentid as assoc_id,
                        o.shipmentid,
                        o.created_source,
                        convertToClientTZ(e.startdate, ?) AS startdate,
                        convertToClientTZ(e.enddate, ?) AS enddate,
                        e.phone, e.stop_id, e.drop_stopid, e.pickup, e.plat, e.plng,
                        e.`drop`, e.dlat, e.dlng,
                        convertToClientTZ(o.pickup_datetime, ?) AS pickup_datetime,
                        convertToClientTZ(o.delivery_datetime, ?) AS drop_datetime,
                        convertToClientTZ(o.pickup_endtime, ?) AS pickup_late_datetime,
                        convertToClientTZ(o.drop_endtime, ?) AS drop_late_datetime,
                        e.name, e.material_id,
                        IFNULL(
                            (SELECT SUM(cargo.weight) AS weight FROM tb_order_cargodetails cargo JOIN tb_orders odr ON odr.id=cargo.order_id WHERE cargo.status = 1 AND odr.order_id=e.order_id), 0
                        ) AS shipment_weight,
                        IFNULL(
                            (SELECT SUM(cargo.volume) AS volume FROM tb_order_cargodetails cargo JOIN tb_orders odr ON odr.id=cargo.order_id WHERE cargo.status = 1 AND odr.order_id=e.order_id), 0
                        ) AS shipment_volume,
                        IF(e.drop_stopid = ?, 'D', 'P') AS ship_type,
                        e.customer_id, e.vendor_id, cd.weight_unit,
                        IF(e.drop_stopid = ?, e.drop_order, e.stop_order) AS priority,
                        e.order_id, o.id AS tb_orders_id, e.capacity,
                        c.name AS customer_name,
                        c.phone AS custphone,
                        v.name AS carrier_name,
                        m.material AS material_name,
                        e.accepted,
                        IFNULL(sm.name, '') AS service_name,
                        sm.service_id,
                        o.pickup_company,
                        o.company_code,
                        o.pickup_city,
                        o.pickup_country,
                        o.pickup_address1,
                        o.pickup_address2,
                        o.pickup_pincode,
                        o.delivery_country,
                        o.delivery_company,
                        o.delivery_city,
                        e.drop_city,
                        o.delivery_address1,
                        o.delivery_address2,
                        o.delivery_pincode,
                        cd.dg_goods,
                        cd.goods_description,
                        od.purchase_order,
                        cd.cargo_type,
                        ocd.handling_unit,
                        ocd.cargo_content,
                        ocd.order_id AS tb_order_cargodetails_orderid,
                        cd.length, cd.length_unit,
                        cd.width,
                        cd.width_unit,
                        cd.height,
                        cd.height_unit,
                        cd.quantity,
                        ocd.quantity_type,
                        cd.stackable,
                       cd.grounded,
                       cd.splittable,
                       cd.id AS cargo_id
                    FROM `tb_employee` e
                        LEFT JOIN tb_vendors AS v ON v.id = e.vendor_id
                        LEFT JOIN tb_customers AS c ON c.id = e.customer_id
                        LEFT JOIN tb_materials AS m ON m.id = e.material_id
                        LEFT JOIN tb_shifts AS s ON s.id = e.shift_id
                        LEFT JOIN  tb_orders AS o ON ( o.shift_id = s.shift_leg_id)
                        LEFT JOIN tb_order_details AS od ON (o.id = od.order_row_id)
                        LEFT JOIN tb_service_master AS sm ON (sm.id = od.service AND sm.status = 1)
                        LEFT JOIN tb_order_cargodetails AS ocd ON (ocd.order_id = o.id AND ocd.status = 1)
                        LEFT JOIN tb_cargo_details AS cd ON (cd.id = ocd.cargo_id AND cd.status = 1)
                    WHERE e.shift_id = ? AND e.status = 1 AND (e.stop_id = ? OR e.drop_stopid = ?)" . $where . "
                     GROUP BY e.id
                    ORDER BY priority";

        return $db->query($sql, [$curtz, $curtz, $curtz, $curtz, $curtz, $curtz, $stop_id, $stop_id, $shift_id, $stop_id, $stop_id]);
    }

    private static function checkForExistingStopStatus($whr, $db): bool
    {
        $db->select("s.stop_id");
        $db->from("tb_stop_status s");
        $db->where($whr);
        $db->limit(1);
        return $db->get()->num_rows > 0;
    }

    /**
     * @param int $milestoneStatus
     * @param $shift_id
     * @param $stop_id
     * @param $stop_detail_id
     * @param array $allstatus
     * @param $trip
     * @param $res
     * @param $db
     * @return array
     */
    private static function extractShipmentStopDetailsStatus(int $milestoneStatus, $shift_id, $stop_id, $stop_detail_id, array $allstatus, $trip, $res, $db): array
    {
        //log_message('error', '===== extractShipmentStopDetailsStatus() START =====');
        //log_message('error', 'milestoneStatus: ' . $milestoneStatus);
        //log_message('error', 'shift_id: ' . print_r($shift_id, true));
        //log_message('error', 'stop_id: ' . print_r($stop_id, true));
        //log_message('error', 'stop_detail_id: ' . print_r($stop_detail_id, true));
        
        //log_message('error', '===== extractShipmentStopDetailsStatus() END =====');
        if ($milestoneStatus == self::MILESTONE_COMPLETED) {
            $milestoneStatus = self::MILESTONE_STARTED;
        } else {
            $milestoneStatus = self::MILESTONE_NOT_STARTED;
        }
        //log_message("error","milestoneStatus111:::".$milestoneStatus);
        $anystatus = 0;
        $has_pod = 0;
        $chkpodsign = $db->query("SELECT id
            FROM tb_pod_uploads
            WHERE shipment_id = ?
              AND stop_id = ?
              AND stop_detail_id = ?
              AND status = 1
            ORDER BY createdon DESC",
            [$shift_id, $stop_id, $stop_detail_id]);
        if ($chkpodsign->num_rows() > 0) {
            $anystatus = 1;
            $allstatus['286'] = 1;
            $has_pod = 1;
        }
        if ($trip > 0) {
            $chk1 = $db->select('id, stop_type')
                ->where([
                    'shipment_id'     => $shift_id,
                    'stop_id'         => $res->stop_id,
                    'trip_id'         => $trip,
                    'stop_detail_id'  => $res->id,
                ])
                ->where_in('status_id', [275, 281])
                ->get('tb_stop_status');
            //log_message('error', 'stop_id: ' . $res->stop_id);
            //log_message('error', 'shift_id: ' . $shift_id);
            //log_message('error', 'shift_id: ' . $trip);
            //log_message('error', 'stop_id: ' . $res->id);
            if ($chk1->num_rows() > 0) {
                $milestoneStatus = self::MILESTONE_STARTED;
                 //log_message("error","milestoneStatus222:::".$milestoneStatus);
                foreach ($chk1->result() as $cr) {
                    if ($cr->stop_type == "D") {
                        $chkdoc = $db->query("SELECT id, doc_type
                            FROM tb_pod_uploads
                            WHERE doc_type IN(1,3)
                              AND shipment_id = ?
                              AND stop_id = ?
                              AND stop_detail_id = ?
                              AND trip_id = ?",
                            [$shift_id, $res->stop_id, $res->id, $trip]);
                        if ($chkdoc->num_rows() > 0) {
                            $milestoneStatus = self::MILESTONE_COMPLETED;
                        }
                    } elseif ($cr->stop_type == "P") {
                        $chk2 = $db->select('id')->get_where('tb_stop_status', [
                            'shipment_id' => $shift_id,
                            'stop_id' => $res->stop_id,
                            'trip_id' => $trip,
                            'stop_detail_id' => $res->id,
                            'status_id' => 278
                        ]);
                        if ($chk2->num_rows() > 0) {
                            $milestoneStatus = self::MILESTONE_COMPLETED;
                        }
                    }
                }
            }
            $chk11 = $db->select('id,status_id')->get_where('tb_stop_status', [
                'shipment_id' => $shift_id,
                'stop_id' => $res->stop_id,
                'trip_id' => $trip,
                'stop_detail_id' => $stop_detail_id,
                'stop_type' => $res->ship_type
            ]);
            if ($chk11->num_rows() > 0) {
                if ($milestoneStatus != self::MILESTONE_COMPLETED) {
                    $milestoneStatus = self::MILESTONE_STARTED;
                }
                //log_message("error","milestoneStatus333:::".$milestoneStatus);
                foreach ($chk11->result() as $chr) {
                    if ($chr->status_id == 274) {
                        $allstatus['274'] = 1;
                    }
                    if ($chr->status_id == 275) {
                        $allstatus['275'] = 1;
                    }
                    if ($chr->status_id == 278) {
                        $allstatus['278'] = 1;
                    }
                    if ($chr->status_id == 279) {
                        $allstatus['279'] = 1;
                    }
                    if ($chr->status_id == 280) {
                        $allstatus['280'] = 1;
                    }
                    if ($chr->status_id == 281) {
                        $allstatus['281'] = 1;
                    }
                    if ($chr->status_id == 285) {
                        $allstatus['285'] = 1;
                    }
                    if ($chr->status_id == 286) {
                        $allstatus['286'] = 1;
                    }
                }
            }
        }
        //log_message("error","milestoneStatus:::".$milestoneStatus);
        return [$milestoneStatus, $anystatus, $has_pod, $allstatus];
    }
}
