<?php

namespace App\ShipmentStops;

use App\ShiporderStops\GetStopName;

class PrepareShipmentStopResult
{
    public static function prepareShipmentStopResult(
        \stdClass $res,
        string $status,
        array $bookingIds,
        array $knTruckingNumbers
    ): array {
        $currentDate = date("Y-m-d H:i:s");

        return [
            'id' => $res->id,
            'name' => GetStopName::getStopName($res),
            'plat' => $res->plat ?? null,
            'plng' => $res->plng ?? null,
            'ship_type' => $res->stoptype ?? 'P',
            'shipment_weight' => $res->weight ?? 0,
            'shipment_volume' => $res->volume ?? 0,
            'startdate' => strtotime($res->startdate ?? $currentDate),
            'enddate' => strtotime($res->enddate ?? $currentDate),
            'priority' => $res->ordernumber ?? 0,
            'status' => $status,
            'order_id' => implode(',', $bookingIds),
            'kn_tracking_no' => implode(',', $knTruckingNumbers)
        ];
    }

    /**
     * @return array|array[]|string[]
     */
    public static function prepareShipmentStopResultWithPlaces(
        \stdClass $res,
        string $status,
        array $bookingIds,
        string $place,
        array $location,
        string $source,
        string $destination,
        string $source_party,
        string $dest_party,
        int $ordernumber,
        array $knTruckingNumbers
    ): array {
        return array_merge(
            static::prepareShipmentStopResult(
                $res,
                $status,
                $bookingIds,
                $knTruckingNumbers
            ),
            [
                'place' => $place,
                'location' => $location,
                'source' => $source,
                'destination' => $destination,
                'source_party' => $source_party,
                'dest_party' => $dest_party,
                'ordernumber' => $ordernumber,
            ]
        );
    }
}
