<?php
namespace App\ShipmentStops;
use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException;

class PreprocessPostData
{
    public static function preprocessPostData(): array
    {
        $shiftId = $_POST["shift_id"] ?? "";
        if ($shiftId == "") {
            throw new BadRequestException("Insufficient Input Data");
        }
        $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
        return [$shiftId, $curtz];
    }
}