<?php
declare(strict_types=1);
namespace App\Trip\Services;
use App\Trip\DriverTripListInterface;

final class DriverShipmentsService
{
    private const LIMIT = 5;
    private DriverTripListInterface $driverTripList;

    public function __construct(DriverTripListInterface $driverTripList)
    {
        $this->driverTripList = $driverTripList;
    }

    public function getShipments(
        int $offset,
        int $driverId,
        int $userId,
        string $timezone,
        bool $returnCompleted,
        string $search
    ): array {
        $searchCriteria = '';
        if ($search) {
            $searchCriteria = $this->driverTripList->getSearches(
                $search,
                $userId,
                $returnCompleted
            );
        }
        if ($returnCompleted) {
            return $this->driverTripList->getCompletedTripData(
                $searchCriteria,
                $offset,
                self::LIMIT,
                $timezone,
                $driverId,
                $userId
            );
        }
        return $this->driverTripList->getAssignedTripData(
            $searchCriteria,
            $offset,
            self::LIMIT,
            $timezone,
            $driverId
        );
    }

    public function getLiveShipments(
        int $offset,
        int $driverId,
        int $userId,
        string $timezone,
        string $search
    ): array {
        $searchCriteria = '';
        if ($search) {
            $searchCriteria = $this->driverTripList->getSearches(
                $search,
                $userId,
                false
            );
        }
        return $this->driverTripList->getLiveTripData(
            $searchCriteria,
            $offset,
            self::LIMIT,
            $timezone,
            $driverId,
            $userId
        );
    }

    public function getShipmentsCount(int $driverId, string $status)
    {
        return $this->driverTripList->getShipmentsCount(
            $driverId,
            $status
        );
    }

    public function getShipmentsList(
        int $offset,
        int $driverId,
        int $userId,
        string $timezone,
        int $type
    ): array {
        return $this->driverTripList->getShipmentsList(
            $offset,
            $driverId,
            $userId,
            $timezone,
            $type,
            self::LIMIT
        );
    }
}