<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";
require_once './vendor/autoload.php';
use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Message\AMQPMessage;
use PhpAmqpLib\Connection\AMQPSSLConnection;
use PhpAmqpLib\Wire;

use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;
class Aconedi extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->library('exchangerate');
		$this->load->library('ratemanagement');
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('aconedimodel');
		$this->load->model('common');
		$this->load->model('truckwaybillmodel');
		$this->load->library("aconinvoiceduedate");
		$this->load->library('billingjplfile');
	}
	public function index(){
		ini_set('max_execution_time', 300);
		$curdt = date('Y-m-d H:i:s');
		$zonecode = $this->session->userdata("usr_tzone");
		$curtz = $zonecode['timezone'];
		$cntryname = $zonecode['country_name'];
		$cntrycode = $zonecode['country'];
		$currency = isset($zonecode['currency']) ? $zonecode['currency'] : "";
		$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
		$timestamp = $getactual['date']."T".$getactual['time']."Z";
		$company_code = $this->session->userdata("company_code");
		$branch_code = $this->session->userdata("branch_code");
		$name = $this->session->userdata("name");
		$post 	= array();
		$post   = $this->input->post(NULL,TRUE);
		$country_code = substr($company_code, 0,2);
		$order_ids   = isset($post['order_ids']) ? $post['order_ids'] : array();
		$revenue_count = $accural_count = 0;
		if(!empty($order_ids)){
			$setreadytoinv = $this->makeselectedasinvoice($order_ids);
			foreach($order_ids as $order_id){
				$order_id = $order_id['ids'];
				$delivery_note = "";
				$getdnote = $this->db->select("ref_value")->get_where("tb_order_references",array('order_id'=>$order_id,'reference_id'=>'DQ'));
				if($getdnote->num_rows() >0){
					$delivery_note = $getdnote->row()->ref_value;
				}
				$chkorder = $this->aconedimodel->getordertoedit($order_id);
				if($chkorder->num_rows() >0){
					$cargos = array();
					$total_volume = $total_weight = $total_quantity = 1;
					$ordernum = $chkorder->row()->order_id;
					$where  = array('order_id'=>$order_id,'status'=>'1');
					$select = "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content";
					$table = "tb_order_cargodetails";
					$getcargos = $this->aconedimodel->gettabledata($where,$select,$table);
					if(count($getcargos) >0){
						foreach($getcargos as $res){
							$volume = $res['volume'];
							$weight = $res['weight'];
							if($volume == ""){ $volume = 1; }
							if($weight == ""){ $weight = 1; }
							$weight_unit = "KG";
							$volume_unit = "CBM";
							$goods_description = "N";
							if($res['cargo_id'] != ""){
								$chk = $this->aconedimodel->gettblrowdata(array("id"=>$res['cargo_id']),"weight_unit,volume_unit,goods_description","tb_cargo_details",0,0);
								if(count($chk)>0){
									$weight_unit = $chk['weight_unit'];
									$volume_unit = $chk['volume_unit'];
									if($chk['goods_description'] != ""){
										$goods_description = $chk['goods_description'];
									}
								}
							}
							$content = $res['cargo_content'];
							if($content == ""){ $content == "Dummy"; }
							$length = $res['length'];
							if($length == "" || $length == 0){ $length = 1;}
							$width = $res['width'];
							if($width == "" || $width == 0){ $width = 1;}
							$height = $res['height'];
							if($height == "" || $height == 0){ $height = 1;}
							$quantity = $res['quantity'];
							if($quantity == "" || $quantity == 0){
								$quantity = 1;
							}
							$cargos[] = array('cargo_type'=>$res['quantity_type'],'content'=>$content,'length'=>$length,'width'=>$width,'height'=>$height,'weight'=>$weight,'volume'=>$volume,'quantity'=>round($quantity),'weight_unit'=>$weight_unit,'volume_unit'=>$volume_unit,'goods_description'=>$goods_description);
							$total_volume += $volume;
							$total_weight += $weight;
							$total_quantity += $res['quantity'];
						}
					}
					if($chkorder->row()->company_code != ""){
						$company_code = $chkorder->row()->company_code;
					}
					if($chkorder->row()->branch_code != ""){
						$branch_code = $chkorder->row()->branch_code;
					}
					$transport_mode = $chkorder->row()->transport_mode;
					if(($transport_mode == "") || (strlen($transport_mode) > 3)){
						$transport_mode = "FTL";
					}
					$logicalsender = $acon_country = '';
					$logicalinfo=$this->db->query("select logical_sender,acon_country from tb_branch_master where
					company_code = ? AND branch_code = ? ", [$company_code, $branch_code] );
					if($logicalinfo->num_rows()>0){
						$logicalsender = $logicalinfo->row()->logical_sender;
						$acon_country = $logicalinfo->row()->acon_country;;
					}
					$trip_no = $chkorder->row()->shipmentid;
					$txnid = $incoterm = $insdate = "";
					$product = $chkorder->row()->product;
					if($product == ""){ $product = "KN AsiaDirect"; }
					$product = strtolower($product);
					if($product == "kn secure chain"){
						$producttype = "S";
					}else{
						$producttype = "L";
					}
					$incoterm = $chkorder->row()->incoterm;
					if($incoterm == ""){ $incoterm = "FOC"; }
					$service = $chkorder->row()->service;
					$service_type = "";
					if($service > 0){
						$chkservice =$this->db->query("select name from tb_service_master where id = ? AND status=1", [$service]);
						if($chkservice->num_rows() > 0){
							$service_type = $chkservice->row()->name;
						}
					}
					if($service_type == ""){ $service_type = "Special"; }
					$delivery_term = $chkorder->row()->delivery_term;
					if($delivery_term == ""){ $delivery_term = 41;}
					$pickup_country=$chkorder->row()->pickup_country;
					$delivery_country=$chkorder->row()->delivery_country;
					$getrevenues = $this->aconedimodel->getrevenues($order_id);
					$revenue_ids =  $revenues = $charges = array();
					if ($getrevenues->num_rows() > 0) {
						foreach ($getrevenues->result() as $res) {
							$acon_code = $res->acon_debitor_code;
							$debtor_jfr = $res->debtor_jfr;
							if(($acon_code != "") && ($debtor_jfr != "")){
								$charges = array();
								$getcharges = $this->aconedimodel->getcharges($res->id);
								if ($getcharges->num_rows() > 0) {
									foreach ($getcharges->result() as $charge) {
										$charges[] = array('charge_code' => $charge->chargecode, 'amount' => round($charge->amount,2), 'currency' => $charge->currency, 'local_amount' => round($charge->local_amount,2), 'local_currency' => $charge->local_currency);
									}
								}
								if(count($charges) > 0){
									$custcountrycode = $this->aconedimodel->getcompanycode($res->country);
									$revpincode = $res->pincode;
									if($revpincode == "" ){
										$revpincode = 1000;
									}
									$rev_currency = $res->currency;
									if($rev_currency == ""){
										$rev_currency = $currency;
									}
									if($company_code == 'PLKN'){
										$currency = "PLN";
									}
									$revenues[] = array('revenue_id' => $res->id,'type'=>$res->type,'recipient_role' => $res->recipient_role,  'recipient_code' => $res->recipient_code,  'debtor_jfr' => $res->debtor_jfr, 'bu_jfr' =>substr($res->bu_jfr,2),'amount' => $res->amount, 'currency' => $rev_currency,'exchange_rate' => $res->exchange_rate,'foreign_currency' => $res->foreign_currency,  'remarks' => $res->remarks,"name"=>substr($res->name,0,34),"code"=>$res->code,"customeridentifier"=>$res->customeridentifier,"city"=>$res->location_id,"country"=>$custcountrycode,"street"=>$res->street,"pincode"=>$revpincode,"acon_code"=>$res->acon_debitor_code,'charges'=>$charges,"delivery_note"=>$delivery_note,"local_currency"=>$currency,'acon_country'=>$acon_country,'ordernum'=>$ordernum);
									$invoice_date = $getactual['date'];
									$upd_revenue = $this->db->where(array('id'=>$res->id))->update("tb_reveneus",array('invoice_date'=>$invoice_date,'invoice_status'=>2));
									$revenue_count++;
								}
							}
						}
					}

					$chekparty = $this->aconedimodel->getparty($order_id);
					if($chekparty->num_rows() >0){
						foreach($chekparty->result() as $rr){
							$ptype = $rr->party_type;
							$chktype = $this->aconedimodel->gettblrowdata(array("id"=>$ptype),"name","tbl_party_types",0,0);
							if(count($chktype)>0){
								if($chktype['name'] == "Consignee"){
									$consignee = array('name'=>substr($rr->name,0,34),'phone'=>$rr->mobile,'email'=>$rr->email,'code'=>$rr->code,'customeridentifier'=>$rr->customeridentifier,'fax'=>$rr->fax);
								}else if($chktype['name'] == "Shipper"){
									$shipper = array('name'=>substr($rr->name,0,34),'phone'=>$rr->mobile,'email'=>$rr->email,'code'=>$rr->code,'customeridentifier'=>$rr->customeridentifier,'fax'=>$rr->fax);
								}
							}
						}
					}
					$shipper['street'] = $chkorder->row()->pickup_address1;
					$shipper['state'] = $chkorder->row()->pickup_address2;
					$shipper['city'] = $chkorder->row()->pickup_city;
					$shipper['country'] = $this->aconedimodel->getcompanycode($pickup_country);
					$shipper['pincode'] = $chkorder->row()->pickup_pincode;

					$consignee['street'] = $chkorder->row()->delivery_address1;
					$consignee['state'] = $chkorder->row()->delivery_address2;
					$consignee['city'] = $chkorder->row()->delivery_city;
					$consignee['country'] = $this->aconedimodel->getcompanycode($delivery_country);
					$consignee['pincode'] = $chkorder->row()->delivery_pincode;

					if($shipper['pincode'] == "" || !is_numeric($shipper['pincode'])){
						$shipper['pincode'] = 1061;
					}
					if($consignee['pincode'] == "" || !is_numeric($consignee['pincode'])){
						$consignee['pincode'] = 1061;
					}
					$pickup_datetime = $chkorder->row()->pickup_datetime;
					$delivery_datetime = $chkorder->row()->delivery_datetime;
					$getactual = getdatetimebytimezone($curtz,$pickup_datetime,DFLT_TZ);
					$early_pickup = $getactual['date']."T".$getactual['time']."Z";
					$getactual = getdatetimebytimezone($curtz,$delivery_datetime,DFLT_TZ);
					$early_delivery = $getactual['date']."T".$getactual['time']."Z";
					$department_code = $chkorder->row()->department_code;
					if($department_code == ""){
						$department_code = "CTP";
					}
					$deliverydate = $delivery_datetime;
					$bookingid = $chkorder->row()->order_id;
					$get_deliverydate = $this->db->query("select tps.createdon from `tb_stop_status` tps where tps.stop_type='D'
					AND tps.status_code='3000' AND tps.order_id = ? order by tps.id desc LIMIT 1", [$order_id]);
					if($get_deliverydate->num_rows() > 0){
						$delivery_date = $get_deliverydate->row()->createdon;
						if($delivery_date !=""){
							$getactual = getdatetimebytimezone($curtz,$delivery_date,DFLT_TZ);
							$deliverydate = $getactual['date']."T".$getactual['time']."Z";
							/*$deliverydate= date("Y-m-d\TH:i:s\Z",strtotime($delivery_date));*/
						}
					}
					/*$upd = $this->db->where(array('order_row_id'=>$order_id))->update("tb_order_details",array('order_status'=>"INVOICED"));*/
					$data = array("timestamp"=>$timestamp,'order_id'=>$bookingid,'early_pickup'=>$early_pickup,'early_delivery'=>$early_delivery,'branch_code'=>$branch_code,'company_code'=>$company_code,'department_code'=>$department_code,'cargos'=>$cargos,'total_weight'=>$total_weight,'total_volume'=>$total_volume,"currency"=>$currency,"trip_no"=>$trip_no,"quantity"=>round($total_quantity),"incoterm"=>$incoterm,"product"=>$product,"service_type"=>$service_type,'country_name'=>$cntryname,"cntrycode"=>$cntrycode,"revenues"=>$revenues,"consignee"=>$consignee,"shipper"=>$shipper,"name"=>$name,"delivery_term"=>$delivery_term,"transport_mode"=>$transport_mode,"deliverydate"=>$deliverydate,"producttype"=>$producttype);
					$this->load->library('uuid');
					$uuid = $this->uuid->v4();
					$ShipmentPayLoadarr = $this->orderxml($data,$uuid);
					$headerdata = array('uuid'=>$uuid,'logsenderid'=>$logicalsender,'routing_country'=>$country_code ,'routing_company'=>$acon_country,'routing_branch'=>$branch_code,'routing_department'=>$department_code);
					if(count($ShipmentPayLoadarr) > 0){
						$this->publishxml($ShipmentPayLoadarr,$headerdata);
					}
				}
			}
			$accuraledi = $this->knaconaccuraledi($order_ids);
			$accural_count = $accuraledi;
		}
		$count_data = array("revenue_count"=>$revenue_count,"accural_count"=>$accural_count);
		echo json_encode($count_data);
	}
	public function orderxml($data,$uuid){
		$revenues = $data['revenues'];
		$yearmonth = date('Ym');
		$ShipmentPayLoadarr = array();
		if(count($revenues) > 0) {
			foreach ($revenues as $revenue) {
				$ShipmentPayLoad = "";
				if($revenue['recipient_role'] == "Customer"){
					$ShipmentPayLoad .= '<?xml version="1.0" encoding="UTF-8"?><billingMessage xmlns="http://services.kn.com/xsd/knbill/Invoicing/v1">';
					$ShipmentPayLoad .= '<messageHeader>';
					$ShipmentPayLoad .= '<sendingSystem>eTN</sendingSystem>';
					$ShipmentPayLoad .= '<timestamp>'.$data['timestamp'].'</timestamp>';
					$ShipmentPayLoad .= '<processMode>STANDARD</processMode>';
					$ShipmentPayLoad .= '</messageHeader>';
					$ShipmentPayLoad .= '<financialDocument>';
					$ShipmentPayLoad .= '<financialDocumentHeader>';
					$ShipmentPayLoad .= '<documentId>'.$uuid.'</documentId>';
					$ShipmentPayLoad .= '<companyCode>'.$data['company_code'].'</companyCode>';
					$ShipmentPayLoad .= '<branchCode>'.$data['branch_code'].'</branchCode>';
					$ShipmentPayLoad .= '<receivingBranchCode>'.$data['branch_code'].'</receivingBranchCode>';
					$ShipmentPayLoad .= '<departmentCode>'.$data['department_code'].'</departmentCode>';
					$ShipmentPayLoad .= '<aconCode>'.$revenue['acon_code'].'</aconCode>';
					$ShipmentPayLoad .= '<documentType>INVOICE</documentType>';
					$ShipmentPayLoad .= '<documentDate>'.$data['timestamp'].'</documentDate>';
					$ShipmentPayLoad .= '<documentRecipient>CUSTOMER</documentRecipient>';
					$ShipmentPayLoad .= '<billingComplete>Y</billingComplete>';
					$ShipmentPayLoad .= '<freightSourceCountry>'.$data['shipper']['country'].'</freightSourceCountry>';
					$ShipmentPayLoad .= '<freightDestinationCountry>'.$data['consignee']['country'].'</freightDestinationCountry>';
					$ShipmentPayLoad .= '<invoicePayerCountry>'.$revenue['country'].'</invoicePayerCountry>';
					if($revenue['foreign_currency'] !=""){
						$ShipmentPayLoad .= '<invoiceCurrency>'.$revenue['foreign_currency'].'</invoiceCurrency>';
					}else{
						$ShipmentPayLoad .= '<localCurrency>'.$revenue['local_currency'].'</localCurrency>';
					}
					$ShipmentPayLoad .= '<localCurrency>'.$revenue['local_currency'].'</localCurrency>';
					$ShipmentPayLoad .= '<creatingUser>root</creatingUser>';
					if($revenue['foreign_currency'] !="" && $revenue['exchange_rate'] > 0){
						$ShipmentPayLoad .= '<exchangeRates>';
						$ShipmentPayLoad .= '<exchangeRate>';
						$ShipmentPayLoad .= '<fromCurrency>'.$revenue['foreign_currency'].'</fromCurrency>';
						$ShipmentPayLoad .= '<toCurrency>'.$revenue['local_currency'].'</toCurrency>';
						$ShipmentPayLoad .= '<rate>'.$revenue['exchange_rate'].'</rate>';
						$ShipmentPayLoad .= '</exchangeRate>';
						$ShipmentPayLoad .= '</exchangeRates>';
					}
					$ShipmentPayLoad .= '</financialDocumentHeader>';
					$ShipmentPayLoad .= '<shipment>';
					$ShipmentPayLoad .= '<shipmentType>'.$data['transport_mode'].'</shipmentType>';
					$ShipmentPayLoad .= '<incoTerm>'.$data['incoterm'].'</incoTerm>';
					$ShipmentPayLoad .= '<deliveryTerm>'.$data['delivery_term'].'</deliveryTerm>';
					$ShipmentPayLoad .= '<knProduct>'.$data['producttype'].'</knProduct>';
					$ShipmentPayLoad .= '<businessSolution>OL</businessSolution>';
					$ShipmentPayLoad .= '<deliveryDate>'.$data['deliverydate'].'</deliveryDate>';
					$ShipmentPayLoad .= '<chargeableWeight>'.$data['total_weight'].'</chargeableWeight>';
					$ShipmentPayLoad .= '<departureDate>'.$data['early_pickup'].'</departureDate>';
					$ShipmentPayLoad .= '<arrivalDate>'.$data['early_delivery'].'</arrivalDate>';
					$ShipmentPayLoad .= '<manifestNumber>'.'ET'.$data['order_id'].'</manifestNumber>';
					$ShipmentPayLoad .= '<comRef>'.$revenue['delivery_note'].'</comRef>';
					$ShipmentPayLoad .= '<trackingNumber>'.$data['order_id'].'</trackingNumber>';
					$ShipmentPayLoad .= '<cashOnDelivery>N</cashOnDelivery>';
					$ShipmentPayLoad .= '<route>';
					$ShipmentPayLoad .= '<receivingDepot>'.$data['branch_code'].'</receivingDepot>';
					$ShipmentPayLoad .= '</route>';
					$ShipmentPayLoad .= '<shipper>';
					$ShipmentPayLoad .= '<customerCode>'.$data['shipper']['customeridentifier'].'</customerCode>';
					$ShipmentPayLoad .= '<name>'. $data['shipper']['name'].'</name>';
					$ShipmentPayLoad .= '<street>'.$data['shipper']['street'].'</street>';
					$ShipmentPayLoad .= '<zipcode>'.$data['shipper']['pincode'].'</zipcode>';
					$ShipmentPayLoad .= '<city>'.$data['shipper']['city'].'</city>';
					$ShipmentPayLoad .= '<country>'.$data['shipper']['country'].'</country>';
					$ShipmentPayLoad .= '</shipper>';
					$ShipmentPayLoad .= '<consignee>';
					$ShipmentPayLoad .= '<customerCode>'.$data['consignee']['customeridentifier'].'</customerCode>';
					$ShipmentPayLoad .= '<name>'.$data['consignee']['name'].'</name>';
					$ShipmentPayLoad .= '<street>'.$data['consignee']['street'].'</street>';
					$ShipmentPayLoad .= '<zipcode>'.$data['consignee']['pincode'].'</zipcode>';
					$ShipmentPayLoad .= '<city>'.$data['consignee']['city'].'</city>';
					$ShipmentPayLoad .= '<country>'.$data['consignee']['country'].'</country>';
					$ShipmentPayLoad .= '</consignee>';
					$ShipmentPayLoad .= '<invoiceTo>';
					$ShipmentPayLoad .= '<customerCode>'.$revenue['customeridentifier'].'</customerCode>';
					$ShipmentPayLoad .= '<name>'.$revenue['name'].'</name>';
					$ShipmentPayLoad .= '<street>'.$revenue['street'].'</street>';
					$ShipmentPayLoad .= '<zipcode>'.$revenue['pincode'].'</zipcode>';
					$ShipmentPayLoad .= '<city>'.$revenue['city'].'</city>';
					$ShipmentPayLoad .= '<country>'.$revenue['country'].'</country>';
					$ShipmentPayLoad .= '</invoiceTo>';
					$ShipmentPayLoad .= '<dimensions>';
					$ShipmentPayLoad .= '<grossWeight>'.$data['total_weight'].'</grossWeight>';
					$ShipmentPayLoad .= '<volume>'.$data['total_volume'].'</volume>';
					$ShipmentPayLoad .= '<loadingMeters>0</loadingMeters>';
					$ShipmentPayLoad .= '</dimensions>';
					$ShipmentPayLoad .= '<shipmentDetails>';
					foreach($data['cargos'] as $info){
						$ShipmentPayLoad .= '<shipmentLine>';
						$ShipmentPayLoad .= '<quantity>'.$info['quantity'].'</quantity>';
						$ShipmentPayLoad .= '<packageType>PLT</packageType>';
						$ShipmentPayLoad .= '<descriptionOfGoods>'.$info['goods_description'].'</descriptionOfGoods>';
						$ShipmentPayLoad .= '<grossWeight>'.$info['weight'].'</grossWeight>';
						$ShipmentPayLoad .= '<loadingMetre>0</loadingMetre>';
						$ShipmentPayLoad .= '<volume>'.$info['volume'].'</volume>';
						$ShipmentPayLoad .= '<dimensionLength>'.$info['length'].'</dimensionLength>';
						$ShipmentPayLoad .= '<dimensionWidth>'.$info['width'].'</dimensionWidth>';
						$ShipmentPayLoad .= '<dimensionHeight>'.$info['height'].'</dimensionHeight>';
						$ShipmentPayLoad .= '</shipmentLine>';
					}
					$ShipmentPayLoad .= '</shipmentDetails>';
					$ShipmentPayLoad .= '<shipmentFreeText>';
					$ShipmentPayLoad .= '<line>{LABEL.LOADING}'.$data['shipper']['country'].",".$data['shipper']['street'].",".$data['shipper']['city'].'</line>';
					$ShipmentPayLoad .= '<line>{LABEL.UNLOADING}'.$data['consignee']['country'].",".$data['consignee']['street'].",".$data['consignee']['city'].'</line>';
					$ShipmentPayLoad .= '</shipmentFreeText>';
					$ShipmentPayLoad .= '</shipment>';
					$ShipmentPayLoad .= '<financialDocumentDetails>';
					$i = 1;
					foreach($revenue['charges'] as $charge){
						$ShipmentPayLoad .= '<financialDocumentLine>';
						$ShipmentPayLoad .= '<sequenceNumber>'.$i.'</sequenceNumber>';
						$ShipmentPayLoad .= '<chargeCode>'.$charge['charge_code'].'</chargeCode>';
						$ShipmentPayLoad .= '<jobFileNumberSender>'.$revenue['debtor_jfr'].'</jobFileNumberSender>';
						$ShipmentPayLoad .= '<jobFileNumberReceiver>'.$revenue['debtor_jfr'].'</jobFileNumberReceiver>';
						$ShipmentPayLoad .= '<profitCentre>'.$data['department_code'].'</profitCentre>';
						$ShipmentPayLoad .= '<filePeriod>'.$yearmonth.'</filePeriod>';
						$ShipmentPayLoad .= '<filePeriodTo>'.$yearmonth.'</filePeriodTo>';
						$ShipmentPayLoad .= '<invoiceAmount>'.$charge['amount'].'</invoiceAmount>';
						$ShipmentPayLoad .= '<remarks>KN CHARGE</remarks>';
						$ShipmentPayLoad .= '</financialDocumentLine>';
						$i++;
					}
					$ShipmentPayLoad .= '</financialDocumentDetails>';
					$ShipmentPayLoad .= '</financialDocument>';
					$ShipmentPayLoad .= '</billingMessage>';
					$ShipmentPayLoadarr[] = $ShipmentPayLoad;
				}
				if($revenue['recipient_role'] == "Internal BU") {
					$ShipmentPayLoad = $this->filetransferxml($revenue,$yearmonth);
					$ShipmentPayLoadarr[] = $ShipmentPayLoad;
				}
			}
		}
		return $ShipmentPayLoadarr;
	}
	public function publishxml($ShipmentPayLoadarr,$headerdata){
		$ssl_options = array(
			'verify_peer' => false,
			'verify_peer_name' => false
		);
		$headers = new Wire\AMQPTable
		(array(
			'uuid' => $headerdata['uuid'],
			'KN_MS_PhysSenderID' => 'KNRLG01',
			'KN_MS_LogSenderID' => $headerdata['logsenderid'],
			'KNESB_Routing_SenderId' => ACON_SENDERID,
			'KNESB_Routing_SenderInstance' => 'TEST_ACCEPTANCE',
			'KNESB_Routing_ReceiverId' => ACON_RECEIVERID,
			'KNESB_Routing_ReceiverInstance' => 'ACCEPTT',
			'KNESB_Routing_Country' => $headerdata['routing_country'],
			'KNESB_Routing_Company' => $headerdata['routing_company'],
			'KNESB_Routing_Branch' => $headerdata['routing_branch'],
			'KNESB_Routing_Department' => $headerdata['routing_department']
		));
		$headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
		$connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME,ACON_PWD, ACON_ESB, $ssl_options);
		$channel = $connection->channel();
		foreach ($ShipmentPayLoadarr as $ShipmentPayLoad) {
			$Xmldata = new AMQPMessage($ShipmentPayLoad,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
			$Xmldata->set('application_headers', $headers);
			$channel->basic_publish($Xmldata,ACON_PUBLISHURL,null);
		}
		/*echo " [x] Sent 'Hello World!'\n";*/
		$channel->close();
		$connection->close();

	}
	public function knaconaccuraledi($order_ids){
		$curdt = date('Y-m-d H:i:s');
		$accural_count = 0;
		$accuralxmls = array();
		$zonecode = $this->session->userdata("usr_tzone");
		$curtz = $zonecode['timezone'];
		$cntryname = $zonecode['country_name'];
		$cntrycode = $zonecode['country'];
		$session_currency = isset($zonecode['currency']) ? $zonecode['currency'] : "";
		$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
		$timestamp = $getactual['date']."T".$getactual['time']."Z";
		$invoice_date = $getactual['date'];
		$company_code = $this->session->userdata("company_code");
		$branch_code = $this->session->userdata("branch_code");
		$country_code = substr($company_code, 0,2);
		$invoice_no = $acon_code = $currency  = $routing_company =  "";
		$user_id = $this->session->userdata('user_id');
		$user_name = "";
		$getuserdetails = $this->common->gettblrowdata(array('id' => $user_id),'name','tb_users',0,0);
		if(!empty($getuserdetails)){
			$user_name = $getuserdetails['name'];
		}
		$acon_country = $logical_sender = "";
		$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"logical_sender,acon_country","tb_branch_master",0,0);
		if(count($getacon_country)>0){
			$acon_country = $routing_company = $getacon_country['acon_country'];
			$logical_sender = $getacon_country['logical_sender'];
		}
		$data_arr = $orderids = array();
		foreach($order_ids as $order_id){
			$orderids[] = $order_id['ids'];
		}
		$rev_where  = array("r.type"=>'0','r.invoice_status'=>'2','r.status'=>'1');
		$this->db->select("r.id,r.order_id,r.recipient_code,r.debtor_jfr,r.invoice_number,r.invoice_date,r.amount,r.currency,r.foreign_currency,p.name,p.acon_debitor_code");
		$this->db->from("tb_reveneus r");
		$this->db->join("tbl_party_master p", "r.recipient_code=p.code", "LEFT");
		$this->db->where($rev_where);
		$this->db->where_in("r.order_id",$orderids);
		$this->db->group_by("r.id");
		$getrevenues = $this->db->get();
		$order_id = "";
		if ($getrevenues->num_rows() > 0) {
			foreach ($getrevenues->result() as $res) {
				$data = array();
				$order_id = $res->order_id;
				$debtor_jfr = $res->debtor_jfr;
				$invoice_no =  $res->invoice_number;
				/*$invoice_date =  $res->invoice_date;*/
/*$invoice_date = date('Y-m-d',strtotime($invoice_date));
$fileperiod = date('Ym',strtotime($invoice_date));*/
$fileperiod = date('Ym',strtotime($invoice_date));
$where  = array("r.type"=>'1','r.order_id'=>$order_id,'r.amount >'=>'0','r.invoice_status'=>0,'r.status'=>'1','p.acon_debitor_code<>'=>'');
$getcost_revenue = $this->aconedimodel->getallrevenues($where);
if ($getcost_revenue->num_rows() > 0) {
	foreach ($getcost_revenue->result() as $rescost) {
		$costrevid = $rescost->id;
		$carrier_code = $rescost->recipient_code;
		$carrier_aconcode = $rescost->acon_debitor_code;
		if(($debtor_jfr != "") && ($carrier_aconcode != "")){
			$charges = array();
			$currency = $rescost->currency;
			if($currency == ""){
				$currency = $session_currency;
			}
			if($company_code == "PLKN"){
				$session_currency = "PLN";
			}
			$getcharges = $this->aconedimodel->getcharges($costrevid);
			if ($getcharges->num_rows() > 0) {
				foreach ($getcharges->result() as $charge) {
					$charge_currency = $charge->currency;
					if($charge_currency != $session_currency){
						$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>round($charge->local_amount,2),'local_currency'=>$charge->local_currency);
					}else {
						$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>0,'local_currency'=>"");
					}
				}
			}
			if(count($charges)>0){
				$upd_rev = $this->db->where(array('id'=>$costrevid))->update("tb_reveneus",array('debtor_jfr'=>$debtor_jfr,'invoice_number'=>$invoice_no,'invoice_date'=>$invoice_date,'invoice_creation_date'=>$curdt,'invoice_receivdon_date'=>$curdt,'invoice_status'=>2));
				if($upd_rev){
					$order_weight = 0;
					$getorderdetails = $this->common->gettblrowdata(array('id' => $order_id),'weight','tb_orders',0,0);
					if(!empty($getorderdetails)){
						$order_weight = $getorderdetails['weight'];
					}
					$data_arr[] = array('carrier_aconcode'=>$carrier_aconcode,'order_weight'=>$order_weight,'invoice_date'=>$invoice_date,'currency'=>$currency,'invoice_no'=>$invoice_no ,'charges'=>$charges,'fileperiod'=>$fileperiod,'user_name'=>$user_name,'acon_country'=>$acon_country,'debtor_jfr'=>$debtor_jfr);
					$accural_count++;
// $accuralxmls[] = $this->accuralxml($data);
// echo htmlentities($accuralxml);
				}
			}
		}
	}
}
}
}
if(count($data_arr) > 0){
	$accuralxml = $this->accuralxml($data_arr);
	$this->load->library('uuid');
	$uuid = $this->uuid->v4();
	$headerdata = array('uuid'=>$uuid,'logical_sender'=>$logical_sender,'country_code'=>$country_code ,'acon_country'=>$acon_country,'branch_code'=>$branch_code,'routing_department'=>"");
	$publishaccuralxml =$this->publishaccuralxml($accuralxml,$headerdata);
}
/*echo htmlentities($accuralxml);*/
return $accural_count;
}
public function checkdebitorandacon(){
	$post 	= array();
	$post   = $this->input->post(NULL,TRUE);
	$order_ids   = $post['order_ids'];
	$error = array();
	if(!empty($order_ids)){
		foreach($order_ids as $order_id){
			$order_id = $order_id['ids'];
			$revenues = $this->aconedimodel->checkrevenues($order_id);
			if($revenues->num_rows() > 0 ){
				foreach ($revenues->result() as $revenue) {
					$ref_orderid = $revenue->order_id;
					if($revenue->debtor_jfr ==""){
						$error[] = "Debtor Jfr Not found for Order ID ".$ref_orderid;
					}
					if($revenue->acon_debitor_code ==""){
						$error[] = "Acon Code Not found for Order ID ".$ref_orderid;
					}
/*if($revenue->shipmentid ==""){
$error[] = "Trip No Not found for Order ID ".$ref_orderid;
}*/
}
}else{
	$error[] = "invoice not ready";
}

}
}else{
	$error[] = "Please Select Order";
}
echo json_encode($error);

}
public function aconinvoiceedi($billid){
	$curdt = date('Y-m-d H:i:s');
	$data['status'] = 0;
	$bu_data = array();
	$company_code = $this->session->userdata("company_code");
	$branch_code = $this->session->userdata("branch_code");
	if($billid > 0 ){
		$acon_invoice_status = 0;
		$chkbill = $this->common->gettblrowdata(array('id'=>$billid),"acon_invoice_status","tbl_bills",0,0);
		if(!empty($chkbill)){
			$acon_invoice_status = $chkbill['acon_invoice_status'];
		}
		if($acon_invoice_status == 0){
			$session_currency = $this->session->userdata( "usr_tzone" )['currency'];
			$zonecode = $this->session->userdata("usr_tzone");
			$curtz = $zonecode['timezone'];
			$cntryname = $zonecode['country_name'];
			$cntrycode = $zonecode['country'];
			$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
			$timestamp = $getactual['date']."T".$getactual['time']."Z";
			$routing_company = "";
			$invoice_typecode = "I";
			$country_code = substr($company_code, 0,2);
			$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"acon_country","tb_branch_master",0,0);
			if(count($getacon_country)>0){
				$routing_company = $getacon_country['acon_country'];
			}
			$duedate = date("Y-m-20", strtotime("+1 month"));
			$issuedate = date("Ym");
			$invoice_no = $acon_code = $currency = $invoice_date = "";
			$billgroup_id = 0;
			$getbilldata = $this->aconedimodel->gettblrowdata(array("id"=>$billid),"bill_group,invoice_no,invoice_date,acon_code,currency","tbl_bills",0,0);
			if(count($getbilldata)>0){
				$invoice_no = $getbilldata['invoice_no'];
				$acon_code = $getbilldata['acon_code'];
				$currency = $getbilldata['currency'];
				$invoice_date = $getbilldata['invoice_date'];
				$billgroup_id = $getbilldata['bill_group'];
				if($invoice_date != ""){
					$issuedate = date('Ym', strtotime($invoice_date));
				}
			}
			$where  = array("r.type"=>'0','r.invoice_status'=>'2','r.bill_id'=>$billid,'r.status'=>'1','p.acon_debitor_code<>'=>'');
			if($billgroup_id > 0){
				$getbillgroup = $this->aconedimodel->gettblrowdata(array("id"=>$billgroup_id),"name","tb_billgroup_master",0,0);
				if(count($getbillgroup)>0){
					if($getbillgroup['name'] == "Bill"){
						$invoice_typecode = "I";
						$where['amount >'] = 0;
					}else if($getbillgroup['name'] == "Credit Note"){
						$invoice_typecode = "C";
						$where['amount <'] = 0;
					}
				}
			}
			$revenue_ids  = $charges = $order_ids = array();
			$totalcharges = $vatamount =$nztotalcharges=0;
			$ordids = array();
			$getrevenues = $this->aconedimodel->getallrevenues($where);
			if ($getrevenues->num_rows() > 0) {
				foreach ($getrevenues->result() as $res) {
					$ordids[] = $res->order_id;
					$getcharges = $this->aconedimodel->getcharges($res->id);
					if($res->recipient_role == "Customer"){
						if ($getcharges->num_rows() > 0) {
							foreach ($getcharges->result() as $charge) {
								$local_amount = $charge->local_amount;
								$local_vat_amount = $charge->local_vat_amount;
								$charge_currency = $charge->currency;
								$vat_amount = $vat_percentage = 0;
								$vat_percentage = $charge->vat_percentage;
								if(strtoupper($session_currency) == strtoupper($charge_currency)){
									$chargeamt = round($charge->amount,2);
									$nztotalcharges += $chargeamt;
									$totalcharges += $charge->amount;
									if(is_numeric($charge->vat_amount)){
										$vatamount += $charge->vat_amount;
										$vat_amount = round($charge->vat_amount,2);
										if($company_code == "VNKN"){
											$vat_amount = round($charge->vat_amount);
										}
									}
								}else{
									$chargeamt = round($charge->local_amount,2);
									$nztotalcharges += $chargeamt;
									$totalcharges += $charge->local_amount;
									if(is_numeric($local_vat_amount)){
										$vatamount += $local_vat_amount;
										$vat_amount = round($local_vat_amount,2);
										if($company_code == "VNKN"){
											$vat_amount = round($local_vat_amount);
										}
									}
								}
								$cat_val = "";
								if(($charge->cat_id) > 0 && ($charge->cat_val != "")){
									$cat_val = $charge->cat_val;
								}
								$charges[] = array('amount'=>$chargeamt,"debtor_jfr"=>$res->debtor_jfr,'local_amount'=>round($charge->local_amount,2),'local_currency'=>$charge->local_currency,'vat_amount'=>abs($vat_amount),'vat_percentage'=>$vat_percentage,'cat_val'=>$cat_val);
							}
						}
					}
				}
			}
			$data['status'] = 3;
			if(!empty($charges)){
				if($company_code == "NZKN"){
					$totalcharges = $nztotalcharges;
					$taxamount = ($totalcharges*0.15);
				}else{
					if($company_code == "VNKN"){
						$taxamount = round($vatamount);
					}else{
						$taxamount = $vatamount;
					}
				}
				$final_charges 	= ($taxamount + $totalcharges);
				$data = array('company_code'=>$routing_company,'accountcode'=>$acon_code,'itemduedate'=>$duedate,'issuedate'=>$issuedate,'currency'=>$currency,'totalcharges'=>round($final_charges,2),'taxamount'=>round($taxamount,2),'invoice_no'=>$invoice_no ,'charges'=>$charges,'invoice_date'=>$invoice_date,'invoice_typecode'=>$invoice_typecode);
				$this->load->library('uuid');
				$uuid = $this->uuid->v4();
				$invoicexml = $this->aconinvoicexml($data);
				//log_message("error","Acon new invoicexml- ".$invoicexml);
				$headerdata = array('uuid'=>$uuid,'routing_country'=>$country_code,'routing_company'=>$routing_company);
				/*echo htmlentities($invoicexml);*/
				$sendxml = $this->publishinvoicexml($invoicexml,$headerdata);
				if($company_code == "SGKN"){
					$pdfFilePath  = $this->generateinvoicepdf($billid);
					$jplFilePath  = $this->billingjplfile->saveJPLFile($billid,$pdfFilePath);
				}
				$upd_bill = $this->db->where(array('id'=>$billid))->update("tbl_bills",array('acon_invoice_status'=>1));
				if($upd_bill){
					$data['status'] = 1;
				}
			}
		}else{
			$data['status'] = 2;
		}
	}
	echo json_encode($data);
}
public function aconinvoicexml($data){
	$company_code = $this->session->userdata("company_code");
	$charges = 	$data['charges'];
	$invoicexml = "";
	$invoicexml .= '<?xml version="1.0" encoding="UTF-8"?><ns4:Invoice xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ns2="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:ns3="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:ns4="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2">';
	$invoicexml .= '<ns2:UBLExtensions>';
	$invoicexml .= '<ns2:UBLExtension>';
	$invoicexml .= '<ns2:ExtensionContent>';
	$invoicexml .= '<InvoiceHeaderInfo xmlns="http://services.kn.com/xsd/acon/ubl/InvoiceHeaderInfo/v1">';
	$invoicexml .= '<CompanyCode>'.$data['company_code'].'</CompanyCode>';
	$invoicexml .= '<AccountCode>'.$data['accountcode'].'</AccountCode>';
	$invoicexml .= '<CashInvoiceInd>N</CashInvoiceInd>';
	$invoicexml .= '<ItemDueDate>'.$data['itemduedate'].'</ItemDueDate>';
	$invoicexml .= '<LCDecimalPlace>2</LCDecimalPlace>';
	$invoicexml .= '<FCDecimalPlace>2</FCDecimalPlace>';
	$invoicexml .= '</InvoiceHeaderInfo>';
	$invoicexml .= '</ns2:ExtensionContent>';
	$invoicexml .= '</ns2:UBLExtension>';
	$invoicexml .= '</ns2:UBLExtensions>';
	$invoicexml .= '<ID>'.$data['invoice_no'].'</ID>';
	$invoicexml .= '<IssueDate>'.$data['invoice_date'].'</IssueDate>';
	$invoicexml .= '<InvoiceTypeCode>'.$data['invoice_typecode'].'</InvoiceTypeCode>';
	$invoicexml .= '<PricingCurrencyCode>'.$data['currency'].'</PricingCurrencyCode>';
	$invoicexml .= '<ns3:AccountingSupplierParty>';
	$invoicexml .= '<ns3:Party>';
	$invoicexml .= '<ns3:PartyName>';
	$invoicexml .= '<Name>ETRUCAR</Name>';
	$invoicexml .= '</ns3:PartyName>';
	$invoicexml .= '</ns3:Party>';
	$invoicexml .= '</ns3:AccountingSupplierParty>';
	$invoicexml .= '<ns3:AccountingCustomerParty/>';
	$invoicexml .= '<ns3:TaxTotal>';
	$invoicexml .= '<TaxAmount currencyID="'.$data['currency'].'">'.abs($data['taxamount']).'</TaxAmount>';
	$invoicexml .= '<RoundingAmount currencyID="'.$data['currency'].'">'.abs($data['taxamount']).'</RoundingAmount>';
	$invoicexml .= '</ns3:TaxTotal>';
	$invoicexml .= '<ns3:LegalMonetaryTotal>';
	$invoicexml .= '<PayableRoundingAmount currencyID="'.$data['currency'].'">'.abs($data['totalcharges']).'</PayableRoundingAmount>';
	$invoicexml .= '<PayableAmount currencyID="'.$data['currency'].'">'.abs($data['totalcharges']).'</PayableAmount>';
	$invoicexml .= '</ns3:LegalMonetaryTotal>';
	if(count($charges) > 0){
		$i =1;
		foreach ($charges as $charge) {
			$invoicexml .= '<ns3:InvoiceLine>';
			$invoicexml .= '<ID>'.$i.'</ID>';
			$invoicexml .= '<Note>KN CHARGE</Note>';
			$invoicexml .= '<LineExtensionAmount currencyID="'.$data['currency'].'">'.abs($charge['amount']).'</LineExtensionAmount>';
			$invoicexml .= '<AccountingCost>045</AccountingCost>';
			$invoicexml .= '<ns3:BillingReference>';
			$invoicexml .= '<ns3:AdditionalDocumentReference>';
			$invoicexml .= '<ID>Y</ID>';
			$invoicexml .= '</ns3:AdditionalDocumentReference>';
			$invoicexml .= '</ns3:BillingReference>';
			$invoicexml .= '<ns3:DocumentReference>';
			$invoicexml .= '<ID>045</ID>';
			$invoicexml .= '<DocumentType>CHARGE_CATEGORY</DocumentType>';
			$invoicexml .= '</ns3:DocumentReference>';
			$invoicexml .= '<ns3:DocumentReference>';
			$invoicexml .= '<ID>'.$data['issuedate'].'</ID>';
			$invoicexml .= '<DocumentType>FILE_PERIOD</DocumentType>';
			$invoicexml .= '</ns3:DocumentReference>';
			$invoicexml .= '<ns3:DocumentReference>';
			$invoicexml .= '<ID>'.$charge['debtor_jfr'].'</ID>';
			$invoicexml .= '<DocumentType>JOB_FILE_NO</DocumentType>';
			$invoicexml .= '</ns3:DocumentReference>';
			$invoicexml .= '<ns3:TaxTotal>';
			$invoicexml .= '<TaxAmount currencyID="'.$data['currency'].'">'.$charge['vat_amount'].'</TaxAmount>';
			$invoicexml .= '<ns3:TaxSubtotal>';
			$invoicexml .= '<TaxAmount currencyID="'.$data['currency'].'">'.$charge['vat_amount'].'</TaxAmount>';
			if($company_code == "NZKN"){
				$invoicexml .= '<Percent>15</Percent>';
			}else{
				$invoicexml .= '<Percent>'.$charge['vat_percentage'].'</Percent>';
			}
			$invoicexml .= '<ns3:TaxCategory>';
			if($company_code == "NZKN"){
				$invoicexml .= '<ID>1</ID>';
			}else{
				if($charge['cat_val'] !=""){
					$invoicexml .= '<ID>'.$charge['cat_val'].'</ID>';
				}else if($company_code == "RUKN" && $charge['vat_percentage'] == "20"){
					$invoicexml .= '<ID>1</ID>';
				}else{
					$invoicexml .= '<ID>0</ID>';
				}
			}
			$invoicexml .= '<ns3:TaxScheme/>';
			$invoicexml .= '</ns3:TaxCategory>';
			$invoicexml .= '</ns3:TaxSubtotal>';
			$invoicexml .= '</ns3:TaxTotal>';
			$invoicexml .= '<ns3:Item/>';
			$invoicexml .= '<ns3:Price>';
			$invoicexml .= '<PriceAmount currencyID="'.$data['currency'].'">'.abs($charge['amount']).'</PriceAmount>';
			$invoicexml .=  '</ns3:Price>';
			$invoicexml .= '</ns3:InvoiceLine>';
			$i++;
		}
	}
	$invoicexml .= '</ns4:Invoice>';
	return $invoicexml;
}
public function publishinvoicexml($invoicexml,$headerdata){
	$ssl_options = array(
		'verify_peer' => false,
		'verify_peer_name' => false
	);
	$headers = new Wire\AMQPTable
	(array(
		'uuid' => $headerdata['uuid'],
		'KNESB_Routing_SenderId' => ACON_SENDERID,
		'KNESB_Routing_SenderInstance' => 'PROD',
		'KNESB_Routing_Country' => $headerdata['routing_country'],/*NZ*/
		'KNESB_Routing_Company' => $headerdata['routing_company']/*'NZ65'*/

	));
	$headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
	$connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME,ACON_PWD, ACON_ESB, $ssl_options);
	$channel = $connection->channel();
	$Xmldata = new AMQPMessage($invoicexml,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
	$Xmldata->set('application_headers', $headers);
	$channel->basic_publish($Xmldata,ACON_INV_PUBLISHURL,null);
	$channel->close();
	$connection->close();
}
public function publishfiletransferxml($filexml,$headerdata){
	$ssl_options = array(
		'verify_peer' => false,
		'verify_peer_name' => false
	);
	$headers = new Wire\AMQPTable
	(array(
		'uuid' => $headerdata['uuid'],
		'KNESB_Routing_SenderId' => ACON_SENDERID,
		'KNESB_Routing_SenderInstance' => 'PROD',
		'KNESB_Routing_Country' => $headerdata['routing_country'],/*NZ*/
		'KNESB_Routing_Company' => $headerdata['routing_company']/*'NZ65'*/

	));
	$headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
	$connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME,ACON_PWD, ACON_ESB, $ssl_options);
	$channel = $connection->channel();
	$Xmldata = new AMQPMessage($filexml,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
	$Xmldata->set('application_headers', $headers);
	$channel->basic_publish($Xmldata,ACON_FILE_PUBLISHURL,null);
	$channel->close();
	$connection->close();
}

public function aconaccuraledi($billid){
	$curdt = date('Y-m-d H:i:s');
	$data['status'] = 0;
	$accuralxmls = $bu_data = array();
	if($billid > 0 ){
		$acon_accrual_status = 0;
		$chkbill = $this->common->gettblrowdata(array('id'=>$billid),"acon_accrual_status","tbl_bills",0,0);
		if(!empty($chkbill)){
			$acon_accrual_status = $chkbill['acon_accrual_status'];
		}
		if($acon_accrual_status == 0){
			$zonecode = $this->session->userdata("usr_tzone");
			$curtz = $zonecode['timezone'];
			$cntryname = $zonecode['country_name'];
			$cntrycode = $zonecode['country'];
			$session_currency = isset($zonecode['currency']) ? $zonecode['currency'] : "";
			$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
			$timestamp = $getactual['date']."T".$getactual['time']."Z";
			$company_code = $this->session->userdata("company_code");
			$branch_code = $this->session->userdata("branch_code");
			$country_code = substr($company_code, 0,2);
			$invoice_no = $acon_code = $currency = $invoice_date = $routing_company =  "";
			$user_id = $this->session->userdata('user_id');
			$user_name = "";
			$getuserdetails = $this->common->gettblrowdata(array('id' => $user_id),'name','tb_users',0,0);
			if(!empty($getuserdetails)){
				$user_name = $getuserdetails['name'];
			}
			$acon_country = $logical_sender = "";
			$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"logical_sender,acon_country","tb_branch_master",0,0);
			if(count($getacon_country)>0){
				$acon_country = $routing_company = $getacon_country['acon_country'];
				$logical_sender = $getacon_country['logical_sender'];
			}
			$data_arr = array();
			$rev_where  = array("r.type"=>'0','r.invoice_status'=>'2','r.bill_id'=>$billid,'r.status'=>'1','p.acon_debitor_code<>'=>'');
			$ordids = array();
			$getrevenues = $this->aconedimodel->getallrevenues($rev_where);
			if ($getrevenues->num_rows() > 0) {
				foreach ($getrevenues->result() as $res) {
					$data = array();
					$order_id = $res->order_id;
					$debtor_jfr = $res->debtor_jfr;
					$invoice_no =  $res->invoice_number;
					$invoice_date =  $res->invoice_date;
					$invoice_date = date('Y-m-d',strtotime($invoice_date));
					$fileperiod = date('Ym',strtotime($invoice_date));
					$where  = array("r.type"=>'1','recipient_role'=>"Carrier",'r.order_id'=>$order_id,'r.amount >'=>'0','r.invoice_status'=>'0','r.status'=>'1','p.acon_debitor_code<>'=>'');
					$getcost_revenue = $this->aconedimodel->getallrevenues($where);
					if ($getcost_revenue->num_rows() > 0) {
						foreach ($getcost_revenue->result() as $res_cost) {
							$ordids[] = $res_cost->order_id;
							$costrevid = $res_cost->id;
							$carrier_code = $res_cost->recipient_code;
							$carrier_aconcode = $res_cost->acon_debitor_code;
							$foreign_currency = $res_cost->foreign_currency;
							$exchange_rate = $res_cost->exchange_rate;
							if($foreign_currency != ""){
								if($exchange_rate >0){
									$chkexchange_rate = $exchange_rate;
								}else{
									$info = array('exchange_rate_id'=>'0','from_currency'=>$foreign_currency,'to_currency'=>$session_currency,'user_id'=>$user_id,'order_id'=>$order_id,'revenue_id'=>$costrevid);
									$exchange_rate_amount = $this->ratemanagement->getexchnageamountfromcurrency($info);
									if($exchange_rate_amount > 0){
										$chkexchange_rate = $exchange_rate_amount;
							            $this->exchangerate->updatelocalamout_byexchangerate($costrevid,$exchange_rate_amount,$foreign_currency);
							        }else{
							        	$chkexchange_rate = 0;
							        }
								}
							}else{
								$chkexchange_rate = 1;
							}
							if(($debtor_jfr !="") && ($carrier_aconcode != "") && ($chkexchange_rate >0)){
								$upd_rev = $this->db->where(array('id'=>$costrevid))->update("tb_reveneus",array('debtor_jfr'=>$debtor_jfr,'invoice_number'=>$invoice_no,'invoice_date'=>$invoice_date,'invoice_creation_date'=>$getactual['datetime'],'invoice_receivdon_date'=>$getactual['datetime'],'invoice_status'=>2,'bill_id'=>$billid));
								if($upd_rev){
									$order_weight = 0;
									$getorderdetails = $this->common->gettblrowdata(array('id' => $order_id),'weight','tb_orders',0,0);
									if(!empty($getorderdetails)){
										$order_weight = $getorderdetails['weight'];
									}
									$currency = $res_cost->currency;
									if($currency == ""){
										$currency = $session_currency;
									}
									if($company_code == "PLKN"){
										$session_currency = "PLN";
									}
									$getcharges = $this->aconedimodel->getcharges($costrevid);
									$charges = array();
									if ($getcharges->num_rows() > 0) {
										foreach ($getcharges->result() as $charge) {
											$charge_currency = $charge->currency;
											if($charge_currency != $session_currency){
												$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>round($charge->local_amount,2),'local_currency'=>$charge->local_currency);
											}else {
												$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>0,'local_currency'=>"");
											}
										}
									}
									$data_arr[] = array('carrier_aconcode'=>$carrier_aconcode,'order_weight'=>$order_weight,'invoice_date'=>$invoice_date,'currency'=>$currency,'invoice_no'=>$invoice_no ,'charges'=>$charges,'fileperiod'=>$fileperiod,'user_name'=>$user_name,'acon_country'=>$acon_country,'debtor_jfr'=>$debtor_jfr);
/*$accuralxmls[] = $this->accuralxml($data);
echo htmlentities($accuralxml);*/
}
}
}
}
}
}
$data['status'] = 3;
if(!empty($charges)){
	$this->load->library('uuid');
	$accuralxml = $this->accuralxml($data_arr);
	/*echo htmlentities($accuralxml);*/
	$uuid = $this->uuid->v4();
	$headerdata = array('uuid'=>$uuid,'logical_sender'=>$logical_sender,'country_code'=>$country_code ,'acon_country'=>$acon_country,'branch_code'=>$branch_code,'routing_department'=>"");
	$sendaccuralxml = $this->publishaccuralxml($accuralxml,$headerdata);
	$upd_bill = $this->db->where(array('id'=>$billid))->update("tbl_bills",array('acon_accrual_status'=>1));
	if($upd_bill){
		$data['status'] = 1;
	}
}
}else {
	$data['status'] = 2;
}
}
echo json_encode($data);
}

public function accuralxml($data_arr){
	$accuralxml = "";
	$accuralxml .= '<?xml version="1.0" encoding="UTF-8"?>';
	$accuralxml .= '<AccruedExpenses xmlns="http://services.kn.com/xsd/acon/fsl/AccuredExpenses/v1">';
	$i =1;
	foreach ($data_arr as $data) {
		foreach($data['charges'] as $charges){
			$accuralxml .= '<AccruedExpense>';
			$accuralxml .= '<CompanyCode>'.$data['acon_country'].'</CompanyCode>';
			$accuralxml .= '<CallingApplication>ETRUCACC</CallingApplication>';
			$accuralxml .= '<TxDate>'.$data['invoice_date'].'</TxDate>';
			$accuralxml .= '<CreditorCode>'.$data['carrier_aconcode'].'</CreditorCode>';
			$accuralxml .= '<JobFileNo>'.$data['debtor_jfr'].'</JobFileNo>';
			$accuralxml .= '<FilePeriod>'.$data['fileperiod'].'</FilePeriod>';
			$accuralxml .= '<ChargeCategory>045</ChargeCategory>';
			if($charges['local_amount'] > 0){
				$accuralxml .= '<CurrencyCode>'.$charges['local_currency'].'</CurrencyCode>';
				$accuralxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
				$accuralxml .= '<AccrualLCAmount>'.$charges['local_amount'].'</AccrualLCAmount>';
			}else{
				$accuralxml .= '<CurrencyCode>'.$charges['currency'].'</CurrencyCode>';
				$accuralxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
				$accuralxml .= '<AccrualLCAmount>'.$charges['amount'].'</AccrualLCAmount>';
			}
			$accuralxml .= '<Weight>'.$data['order_weight'].'</Weight>';
			$accuralxml .= '<SequenceNo>'.$i.'</SequenceNo>';
			$accuralxml .= '<InterfaceStatus>A</InterfaceStatus>';
			$accuralxml .= '<CostType>R</CostType>';
			if($charges['local_amount'] > 0){
				$accuralxml .= '<ForeignCurrencyCode>'.$charges['currency'].'</ForeignCurrencyCode>';
				$accuralxml .= '<AccrualFCAmount>'.$charges['amount'].'</AccrualFCAmount>';
			}

			$accuralxml .= '<LastUpdatedUser>'.$data['user_name'].'</LastUpdatedUser>';
			$accuralxml .= '</AccruedExpense>';
			$i++;
		}
	}
	$accuralxml .= '</AccruedExpenses>';
	return $accuralxml;
}

public function publishaccuralxml($accuralxml,$headerdata){
	$ssl_options = array(
		'verify_peer' => false,
		'verify_peer_name' => false
	);

	$headers = new Wire\AMQPTable
	(array(
		'uuid' => $headerdata['uuid'],
		'KN_MS_PhysSenderID' => 'KNRLG01',
		'KN_MS_LogSenderID' => $headerdata['logical_sender'],
		'KNESB_Routing_SenderId' => ACON_USRNAME,
		'KNESB_Routing_SenderInstance' => 'TEST_ACCEPTANCE',
		'KNESB_Routing_ReceiverId' => 'KNBILL',
		'KNESB_Routing_ReceiverInstance' => 'ACCEPTT',
		'KNESB_Routing_Country' => $headerdata['country_code'],
		'KNESB_Routing_Company' => $headerdata['acon_country'],
		'KNESB_Routing_Branch' => $headerdata['branch_code'],
		'KNESB_Routing_Department' => 'CTP'
	));

	$headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
	$connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME,ACON_PWD, ACON_ESB, $ssl_options);
	$channel = $connection->channel();
	$Xmldata = new AMQPMessage($accuralxml,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
	$Xmldata->set('application_headers', $headers);
	$channel->basic_publish($Xmldata,ACON_ACCRUAL_URL,null);
	$channel->close();
	$connection->close();
}
public function makeselectedasinvoice($order_ids){
	ini_set('max_execution_time', 300);
	$post 	= array();
	$post   = $this->input->post(NULL,TRUE);
	$from_date = isset($post['fromdate']) ? $post['fromdate'] : date('Y-m-d H:i:s');
	$user_id = $this->session->userdata("user_id");
	if(!empty($order_ids)){
		$curtz = $this->session->userdata("usr_tzone")['timezone'];
		$info = array('order_ids'=>$order_ids,'curtz'=>$curtz,'user_id'=>$user_id);
		$chk_exchange = $this->exchangerate->checkorderrevenuecurrency($order_ids);
		$upd = makeselectedordersasinvoice($info);
	}

}

public function filetrasnferfor_selectedorders(){
	ini_set('max_execution_time', 300);
    $post = $invoiceddata = $tobeinvoiced = $sendorders = $norevenues = $invoiced_orders = $tobeinvoice_orders = $send_orders = $norev_orders =array();
	$post = $this->input->post(NULL,TRUE);
	$responce = "";
	$order_ids = isset($post['order_ids']) ? $post['order_ids'] : array();
	if(!empty($order_ids)){
		foreach ($order_ids as $oids) {
			$ids = $oids['ids'];
			$chk_internalbu = $this->common->gettbldata(array('order_id'=>$ids,'recipient_role'=>'Internal BU','amount >'=>'0','status'=>'1'),"id,order_id,invoice_status","tb_reveneus",0,0);
			if(!empty($chk_internalbu)){
				foreach ($chk_internalbu as $row) {
					$revenue_id     = $row['id'];
					$order_id       = $row['id'];
					$invoice_status = $row['invoice_status'];
					if($invoice_status == '1'){
						if($revenue_id >0){
							$invoiceddata[] = $ids;
							$this->filetransferedi($revenue_id,'1');

						}
					}else if($invoice_status == '0'){
						$tobeinvoiced[] = $ids;
					}else if($invoice_status >2){
						$sendorders[] = $ids;
					}
				}
			}else{
				$norevenues[] = $ids;
			}
		}
	}
	if(!empty($invoiceddata)){
		$this->db->select("id,order_id");
		$this->db->from("tb_orders");
		$this->db->where_in('id',$invoiceddata);
		$this->db->where('status!=','0');
		$get_invoicedorders = $this->db->get();
		if($get_invoicedorders->num_rows() >0){
			foreach ($get_invoicedorders->result() as $res) {
				$chkrev= $this->common->gettblrowdata(array('order_id'=>$res->id,'recipient_role'=>'Internal BU','amount >'=>'0','status'=>'1','invoice_status <'=>'3'),"id","tb_reveneus",0,0);
				if(!empty($chkrev)){
					$invoiced_orders[] = array('bookingid'=>$res->order_id,'status'=>'Something Went Wrong');
				}else{
					$invoiced_orders[] = array('bookingid'=>$res->order_id,'status'=>'FiLe Transfer Done Successfully');
				}
			}
		}
	}
	if(!empty($tobeinvoiced)){
		$this->db->select("order_id");
		$this->db->from("tb_orders");
		$this->db->where_in('id',$tobeinvoiced);
		$this->db->where('status!=','0');
		$get_tobeinvoicedorders = $this->db->get();
		if($get_tobeinvoicedorders->num_rows() >0){
			foreach ($get_tobeinvoicedorders->result() as $res) {
				$tobeinvoice_orders[] = array('bookingid'=>$res->order_id,'status'=>'Order status is not in "Ready To Invoice"');
			}
		}
	}
	if(!empty($sendorders)){
		$this->db->select("order_id");
		$this->db->from("tb_orders");
		$this->db->where_in('id',$sendorders);
		$this->db->where('status!=','0');
		$get_sendordersorders = $this->db->get();
		if($get_sendordersorders->num_rows() >0){
			foreach ($get_sendordersorders->result() as $res) {
				$send_orders[] = array('bookingid'=>$res->order_id,'status'=>'File Transfer is already Done');
			}
		}
	}
	if(!empty($norevenues)){
		$this->db->select("order_id");
		$this->db->from("tb_orders");
		$this->db->where_in('id',$norevenues);
		$this->db->where('status!=','0');
		$get_norevenuesorders = $this->db->get();
		if($get_norevenuesorders->num_rows() >0){
			foreach ($get_norevenuesorders->result() as $res) {
				$norev_orders[] = array('bookingid'=>$res->order_id,'status'=>'Internal Bu not found for these order');
			}
		}
	}
	$result = array();
	if(!empty($send_orders)){
		foreach ($send_orders as $ord) {
			$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
		}
	}
	if(!empty($tobeinvoice_orders)){
		foreach ($tobeinvoice_orders as $ord) {
			$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
		}
	}
	if(!empty($invoiced_orders)){
		foreach ($invoiced_orders as $ord) {
			$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
		}
	}
	if(!empty($norev_orders)){
		foreach ($norev_orders as $ord) {
			$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
		}
	}

	/*$result = array('send_orders'=>$send_orders,'tobeinvoice_orders'=>$tobeinvoice_orders,'invoiced_orders'=>$invoiced_orders);*/
	echo json_encode($result);
}
public function filetransferedi($revenue_id,$jsontype = null){
	$curdt = date('Y-m-d H:i:s');
	$data['status'] = 0;
	if($revenue_id > 0 ){
		$zonecode = $this->session->userdata("usr_tzone");
		$curtz = $zonecode['timezone'];
		$cntryname = $zonecode['country_name'];
		$cntrycode = $zonecode['country'];
		$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
		$timestamp = $getactual['date']."T".$getactual['time']."Z";
		$company_code = $this->session->userdata("company_code");
		$branch_code = $this->session->userdata("branch_code");
		$country_code = substr($company_code, 0,2);
		$invoice_no = $acon_code = $currency = $invoice_date = $routing_company =  "";
		$user_id = $this->session->userdata('user_id');
		$user_name = "";
		$getuserdetails = $this->common->gettblrowdata(array('id' => $user_id),'name','tb_users',0,0);
		if(!empty($getuserdetails)){
			$user_name = $getuserdetails['name'];
		}
		$acon_country = $logical_sender = "";
		$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"logical_sender,acon_country","tb_branch_master",0,0);
		if(count($getacon_country)>0){
			$acon_country = $routing_company = $getacon_country['acon_country'];
			$logical_sender = $getacon_country['logical_sender'];
		}
		$data_arr = array();
		$data = array();
		$invoice_date = $getactual['date'];
		$fileperiod = date('Ym',strtotime($getactual['date']));
		$where  = array("r.id"=>$revenue_id,'r.amount >'=>'0','r.invoice_status'=>'1','r.status'=>'1','p.acon_debitor_code<>'=>'','p.status'=>'1');
		$getbu_revenue = $this->aconedimodel->getallrevenues($where);
		if($getbu_revenue->num_rows() > 0) {
			$order_id = $getbu_revenue->row()->order_id;
			$type     = $getbu_revenue->row()->type;
			$debtor_jfr = $getbu_revenue->row()->debtor_jfr;
			$bu_jfr = $getbu_revenue->row()->bu_jfr;
			$acon_code = $getbu_revenue->row()->acon_debitor_code;
			$order_weight = 0;
			$createdon = $ordernum ="";
			$getorderdetails = $this->common->gettblrowdata(array('id' => $order_id),'order_id,weight,createdon','tb_orders',0,0);
			if(!empty($getorderdetails)){
				$order_weight = $getorderdetails['weight'];
				$createdon = $getorderdetails['createdon'];
				$ordernum = $getorderdetails['order_id'];
			}
			if($createdon != ""){
				$getcreatedon = getdatetimebytimezone($curtz,$createdon,DFLT_TZ);
				$createdon = $getcreatedon['date'];
				$fileperiod = date('Ym',strtotime($createdon));
			}
			$currency = $getbu_revenue->row()->currency;
			$getcharges = $this->aconedimodel->getcharges($revenue_id);
			$bucharges = array();
			if ($getcharges->num_rows() > 0) {
				foreach($getcharges->result() as $bucharge) {
					$bucharges[] = array('amount'=>$bucharge->amount,"debtor_jfr"=>$debtor_jfr,'local_amount'=>$bucharge->local_amount,'local_currency'=>$bucharge->local_currency);
				}
			}
			$data['status'] = 2;
			if(!empty($bucharges)){
				$bu_data = array('acon_country'=>$routing_company,'acon_code'=>$acon_code,'issuedate'=>$fileperiod,'currency'=>$currency,'invoice_no'=>$invoice_no ,'charges'=>$bucharges,'invoice_date'=>$invoice_date,'debtor_jfr'=>$debtor_jfr,'bu_jfr'=>$bu_jfr,'ordernum'=>$ordernum,'type'=>$type);
			}
			$this->load->library('uuid');
			$uuid = $this->uuid->v4();
			$headerdata = array('uuid'=>$uuid,'routing_country'=>$country_code,'routing_company'=>$routing_company);
			if(!empty($bu_data)){
				$upd_rev = $this->db->where(array('id'=>$revenue_id))->update("tb_reveneus",array('invoice_number'=>"",'invoice_date'=>$invoice_date,'invoice_creation_date'=>$curdt,'invoice_receivdon_date'=>$curdt,'invoice_status'=>3));
				if($upd_rev){
					$ShipmentPayLoad = $this->filetransferxml($bu_data,$fileperiod);
					$sendfilexml = $this->publishfiletransferxml($ShipmentPayLoad,$headerdata);
					$data['status'] = 1;
				}
			}
		}
	}else {
		$data['status'] = 0;
	}
	if($jsontype == "1"){
	}else{
		echo json_encode($data);
	}
}
public function filetransferxml($revenue,$yearmonth){
	$transferlcamount = $type = 0;
	foreach($revenue['charges'] as $charge){
		$local_currency = $charge['local_currency'];
		$transferlcamount += $charge['local_amount'];
	}
	$type = $revenue['type'] ?? 0;
	$date = date('Y-m-d');
	$transferxml = "";
	$transferxml .= '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
	$transferxml .= '<FileTransfers xmlns="http://services.kn.com/xsd/acon/fsl/FileTransfers/v1">';
	$transferxml .= '<FileTransfer>';
	$transferxml .= '<CompanyCodeFrom>'.$revenue['acon_country'].'</CompanyCodeFrom>';
	$transferxml .= '<FilePeriodFrom>'.$yearmonth.'</FilePeriodFrom>';
    if ($type == 1) {
        $revenue['bu_jfr'] = substr($revenue['bu_jfr'], 2);
        $transferxml .= '<JobFileNoFrom>' . $revenue['bu_jfr'] . '</JobFileNoFrom>';
    } else {
        $transferxml .= '<JobFileNoFrom>' . $revenue['debtor_jfr'] . '</JobFileNoFrom>';
    }
	$transferxml .= '<BillingCompletedInFrom>Y</BillingCompletedInFrom>';
	$transferxml .= '<CompanyCodeTo>'.$revenue['acon_country'].'</CompanyCodeTo>';
    if ($type == 1) {
        $transferxml .= '<FilePeriodTo>' . $yearmonth . '</FilePeriodTo>';
        $transferxml .= '<JobFileNoTo>' . $revenue['debtor_jfr'] . '</JobFileNoTo>';
    } else {
        $trackingno = $profitcentre = '';
        if (strlen($revenue['bu_jfr']) == 15) {
            if (strpos($revenue['bu_jfr'], '-') !== false) {
                $track_profit = explode("-", $revenue['bu_jfr']);
                if (isset($track_profit[0])) {
                    $trackingno = $track_profit[0];
                }
                if (isset($track_profit[1])) {
                    $profitcentre = $track_profit[1];
                }
                if ($trackingno != '' && $profitcentre != '') {
                    $transferxml .= '<TrackingNoTo>' . $trackingno . '</TrackingNoTo>';
                    $transferxml .= '<ProfitCentreTo>' . $profitcentre . '</ProfitCentreTo>';
                    $transferxml .= '<FilePeriodTo>' . $yearmonth . '</FilePeriodTo>';
                }
            }
        } else {
            if (strlen($revenue['bu_jfr']) == 16) {
                $revenue['bu_jfr'] = substr($revenue['bu_jfr'], 2);
                $transferxml .= '<FilePeriodTo>' . $yearmonth . '</FilePeriodTo>';
                $transferxml .= '<JobFileNoTo>' . $revenue['bu_jfr'] . '</JobFileNoTo>';
            }
        }
    }
	$transferxml .= '<CallingApplication>ETRUCTXF</CallingApplication>';
	$transferxml .= '<TransferDate>'.$date.'</TransferDate>';
	$transferxml .= '<CreditorCode>'.$revenue['acon_code'].'</CreditorCode>';
	$transferxml .= '<ChargeCode>045</ChargeCode>';
	$transferxml .= '<ChargeCategory>045</ChargeCategory>';
	$transferxml .= '<TransferType>I</TransferType>';
	$transferxml .= '<CurrencyCode>'.$local_currency.'</CurrencyCode>';
	$transferxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
	$transferxml .= '<TransferLCAmount>'.round($transferlcamount,2).'</TransferLCAmount>';
	$transferxml .= '<ItemType>I</ItemType>';
	$transferxml .= '<ItemNo>'.$revenue['ordernum'].'</ItemNo>';
	$transferxml .= '<SequenceNo>1</SequenceNo>';
	$transferxml .= '</FileTransfer>';
	$transferxml .= '</FileTransfers>';
	return $transferxml;
}
public function filetransferxmltypee($data){
	/* TRANSFER_Type_E */
	$transferxml  = "";
	$transferxml .= '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
	$transferxml .= '<FileTransfers xmlns="http://services.kn.com/xsd/acon/fsl/FileTransfers/v1">';
	foreach ($data as $data) {
		$transferxml .= '<FileTransfer>';
		$transferxml .= '<CompanyCodeFrom>'.$data['itemno'].'</CompanyCodeFrom>';
		$transferxml .= '<FilePeriodFrom>'.$data['itemno'].'</FilePeriodFrom>';
		$transferxml .= '<JobFileNoFrom>'.$data['itemno'].'</JobFileNoFrom>';
		$transferxml .= '<BillingCompletedInFrom>Y</BillingCompletedInFrom>';
		$transferxml .= '<CompanyCodeTo>'.$data['itemno'].'</CompanyCodeTo>';
		$transferxml .= '<TrackingNoTo>'.$data['itemno'].'</TrackingNoTo>';
		$transferxml .= '<ProfitCentreTo>'.$data['itemno'].'</ProfitCentreTo>';
		$transferxml .= '<FilePeriodTo>'.$data['itemno'].'</FilePeriodTo>';
		$transferxml .= '<CallingApplication>SALOGTXF</CallingApplication>';
		$transferxml .= '<TransferDate>'.$data['itemno'].'</TransferDate>';
		$transferxml .= '<CreditorCode>'.$data['itemno'].'</CreditorCode>';
		$transferxml .= '<ChargeCode>'.$data['itemno'].'</ChargeCode>';
		$transferxml .= '<ChargeCategory>'.$data['itemno'].'</ChargeCategory>';
		$transferxml .= '<TransferType>E</TransferType>';
		$transferxml .= '<CurrencyCode>'.$data['itemno'].'</CurrencyCode>';
		$transferxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
		$transferxml .= '<TransferLCAmount>'.$data['itemno'].'</TransferLCAmount>';
		$transferxml .= '<SequenceNo>1</SequenceNo>';
		$transferxml .= '</FileTransfer>';
	}
	$transferxml .= '</FileTransfers>';
	return $transferxml;
}
public function singleaccrualedi($revenue_id){
	$curdt = date('Y-m-d H:i:s');
	$data['status'] = 0;
	$accuralxmls = $bu_data = array();
	if($revenue_id > 0 ){
		$invoice_status = $order_id = $invoice_number =0;
		$debtor_jfr = '';
		$chkrev = $this->common->gettblrowdata(array('id'=>$revenue_id),"order_id,debtor_jfr,invoice_number,invoice_status","tb_reveneus",0,0);
		if(!empty($chkrev)){
			$invoice_status = $chkrev['invoice_status'];
			$debtor_jfr = $chkrev['debtor_jfr'];
			$order_id = $chkrev['order_id'];
			$invoice_number = $chkrev['invoice_number'];
		}
		if($invoice_status == 1 && $debtor_jfr !=''){
			$zonecode = $this->session->userdata("usr_tzone");
			$curtz = $zonecode['timezone'];
			$cntryname = $zonecode['country_name'];
			$cntrycode = $zonecode['country'];
			$session_currency = isset($zonecode['currency']) ? $zonecode['currency'] : "";
			$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
			$timestamp = $getactual['date']."T".$getactual['time']."Z";
			$company_code = $this->session->userdata("company_code");
			$branch_code = $this->session->userdata("branch_code");
			$country_code = substr($company_code, 0,2);
			$invoice_no = $acon_code = $currency = $invoice_date = $routing_company =  "";
			$user_id = $this->session->userdata('user_id');
			$user_name = "";
			$getuserdetails = $this->common->gettblrowdata(array('id' => $user_id),'name','tb_users',0,0);
			if(!empty($getuserdetails)){
				$user_name = $getuserdetails['name'];
			}
			$acon_country = $logical_sender = "";
			$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"logical_sender,acon_country","tb_branch_master",0,0);
			if(count($getacon_country)>0){
				$acon_country = $routing_company = $getacon_country['acon_country'];
				$logical_sender = $getacon_country['logical_sender'];
			}
			$data_arr = array();
					$invoice_no =  $invoice_number;
					$invoice_date = date('Y-m-d',strtotime($curdt));
					$fileperiod = date('Ym',strtotime($invoice_date));
					$where  = array("r.id"=>$revenue_id,"r.type"=>'1','recipient_role'=>"Carrier",'r.order_id'=>$order_id,'r.amount >'=>'0','r.invoice_status'=>'1','r.status'=>'1','p.acon_debitor_code<>'=>'');
					$getcost_revenue = $this->aconedimodel->getallrevenues($where);
					if ($getcost_revenue->num_rows() > 0) {
						foreach ($getcost_revenue->result() as $res_cost) {
							$ordids[] = $res_cost->order_id;
							$costrevid = $res_cost->id;
							$carrier_code = $res_cost->recipient_code;
							$carrier_aconcode = $res_cost->acon_debitor_code;
							if(($debtor_jfr !="") && ($carrier_aconcode != "")){
								$upd_rev = $this->db->where(array('id'=>$costrevid))->update("tb_reveneus",array('debtor_jfr'=>$debtor_jfr,'invoice_number'=>$debtor_jfr,'invoice_date'=>$invoice_date,'invoice_creation_date'=>$getactual['datetime'],'invoice_receivdon_date'=>$getactual['datetime'],'invoice_status'=>2));
								if($upd_rev){
									$order_weight = 0;
									$getorderdetails = $this->common->gettblrowdata(array('id' => $order_id),'weight','tb_orders',0,0);
									if(!empty($getorderdetails)){
										$order_weight = $getorderdetails['weight'];
									}
									$currency = $res_cost->currency;
									if($currency == ""){
										$currency = $session_currency;
									}
									if($company_code == "PLKN"){
										$session_currency = "PLN";
									}
									$getcharges = $this->aconedimodel->getcharges($costrevid);
									$charges = array();
									if ($getcharges->num_rows() > 0) {
										foreach ($getcharges->result() as $charge) {
											$charge_currency = $charge->currency;
											if($charge_currency != $session_currency){
												$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>round($charge->local_amount,2),'local_currency'=>$charge->local_currency);
											}else {
												$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>0,'local_currency'=>"");
											}
										}
									}
									$data_arr[] = array('carrier_aconcode'=>$carrier_aconcode,'order_weight'=>$order_weight,'invoice_date'=>$invoice_date,'currency'=>$currency ,'charges'=>$charges,'fileperiod'=>$fileperiod,'user_name'=>$user_name,'acon_country'=>$acon_country,'debtor_jfr'=>$debtor_jfr);
}
}


}
}
$data['status'] = 3;
if(!empty($charges)){
	$this->load->library('uuid');
	$accuralxml = $this->accuralxml($data_arr);
	$uuid = $this->uuid->v4();
	$headerdata = array('uuid'=>$uuid,'logical_sender'=>$logical_sender,'country_code'=>$country_code ,'acon_country'=>$acon_country,'branch_code'=>$branch_code,'routing_department'=>"");
	$sendaccuralxml = $this->publishaccuralxml($accuralxml,$headerdata);
	$data['status'] = 1;
}
}else {
	$data['status'] = 2;
}
}
echo json_encode($data);
}
public function testf(){
	$xml = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><FileTransfers xmlns="http://services.kn.com/xsd/acon/fsl/FileTransfers/v1"><FileTransfer><CompanyCodeFrom>TH48</CompanyCodeFrom><FilePeriodFrom>202103</FilePeriodFrom><JobFileNoFrom>1038003346</JobFileNoFrom><BillingCompletedInFrom>Y</BillingCompletedInFrom><CompanyCodeTo>TH48</CompanyCodeTo><TrackingNoTo>10789110370301</TrackingNoTo><ProfitCentreTo>0003</ProfitCentreTo><FilePeriodTo>202103</FilePeriodTo><CallingApplication>ETRUCTXF</CallingApplication><TransferDate>2021-03-10</TransferDate><CreditorCode>KN00878</CreditorCode><ChargeCode>045</ChargeCode><ChargeCategory>045</ChargeCategory><TransferType>I</TransferType><CurrencyCode>THB</CurrencyCode><LCDecimalPlace>2</LCDecimalPlace><TransferLCAmount>1000</TransferLCAmount><ItemType>I</ItemType><ItemNo>6621090183</ItemNo><SequenceNo>1</SequenceNo></FileTransfer></FileTransfers>';
	return $xml;
}


	public function generateinvoicepdf($bill_id = null){
		$filePath = $bill_group = "";
		$bill_group_id = 0;
		$order_ids = array();
			if($bill_id != ""){
				$getbilling_details = $this->common->gettblrowdata(array("id"=>$bill_id),"bill_group","tbl_bills",0,0);
				if(!empty($getbilling_details)){
					$bill_group_id  = $getbilling_details['bill_group'];
				}
				if($bill_group_id >0){
					$getbillgroup_details = $this->common->gettblrowdata(array('id'=>$bill_group_id,'status'=>'1'),"name","tb_billgroup_master",0,0);
					if(!empty($getbillgroup_details)){
						$bill_group = strtoupper($getbillgroup_details['name']);
					}
				}
				if($bill_group == "BILL" || $bill_group == "CREDIT NOTE"){
					if($bill_group == "BILL"){
						$getrev = $this->common->gettbldata(array('bill_id'=>$bill_id,'status'=>'1'),"order_id","tb_reveneus",0,0);
						if(!empty($getrev)){
							foreach ($getrev as $rev) {
								$order_ids[] = $rev['order_id'];
							}
						}
						if(!empty($order_ids)){
							$filePath = $this->donwloadexternalinvoice($order_ids,$bill_id);
						}
					}else{
						$filePath = $this->donwloadcreditnote($bill_id,'credit');
					}
				}

			}
		return $filePath;
	}

	public function donwloadcreditnote($invoice,$type){

		$data = $order_types = array();
		$filename = $pdfPath = "";
		$zonecode = $this->session->userdata("usr_tzone");
		$usercompany_code = $this->session->userdata('company_code');
	 	$curtz = $zonecode['timezone'];
		$data['shipper']=array();
		$data['type']=$type;
		$add_info=array();
		$orderinfo = $orders_data = array();
		$pickup_address=$delivery_address=$shipper_address=$cargo_details=$order_reference=$noity_address=$branch_details=$cargo_info=array();
		$from_loc=$to_loc=$truck_num=$driver_name=$departure_date='';
		$gene_order_id='';
		$total_amount = $total_vat = 0;
        $returndata = $this->aconinvoiceduedate->getrequest($invoice);
		if($invoice!=''){
			$where=array('id'=>$invoice);
			$invoiceinfo=$this->common->gettblrowdata($where,'invoice_no,invoice_date,acon_code,customer_code,code,branch_code,acon_invoice_due_date,acon_invoice_due_payment_term,acon_invoice_due_credit_terms,acon_invoice_isprint_due_date,acon_invoice_due_date_special_text','tbl_bills',0,0);
			if(count($invoiceinfo)>0){
				$add_info['invoice_no']=$invoiceinfo['invoice_no'];
				$filename = $invoiceinfo['invoice_no'];
				$add_info['invoice_date']=date("d-m-Y",strtotime($invoiceinfo['invoice_date']));
				$add_info['customer_code']=$invoiceinfo['customer_code'];
				$add_info['acon_code']=$invoiceinfo['acon_code'];
				$add_info['general_customer_code']=$invoiceinfo['code'];
				$branchcode=$invoiceinfo['branch_code'];
				$add_info['acon_invoice_due_date']=$invoiceinfo['acon_invoice_due_date'];
				$add_info['acon_invoice_due_payment_term']=$invoiceinfo['acon_invoice_due_payment_term'];
				$add_info['acon_invoice_due_credit_terms']=$invoiceinfo['acon_invoice_due_credit_terms'];
				$add_info['acon_invoice_isprint_due_date']=$invoiceinfo['acon_invoice_isprint_due_date'];
				$add_info['acon_invoice_due_date_special_text']=$invoiceinfo['acon_invoice_due_date_special_text'];

				$branch_info=$this->truckwaybillmodel->branch_info($branchcode);
				if($branch_info->num_rows()>0){
					$branch_details['branch_name']=$branch_info->row()->branch_name;
					$branch_details['street']=$branch_info->row()->street;
					$branch_details['city']=$branch_info->row()->city;
					$branch_details['state']=$branch_info->row()->state;
					$branch_details['country']=$branch_info->row()->country;
					$branch_details['zipcode']=$branch_info->row()->zipcode;
					$branch_details['phone']=$branch_info->row()->phone;
					$branch_details['fax']=$branch_info->row()->fax;
					$branch_details['email']=$branch_info->row()->email;
					$branch_details['bank_name']=$branch_info->row()->bank_name;
					$branch_details['bank_address']=$branch_info->row()->bank_address;
					$branch_details['bank_code']=$branch_info->row()->bank_code;
					$branch_details['bank_city']=$branch_info->row()->bank_city;
					$branch_details['bank_phone']=$branch_info->row()->bank_phone;
					$branch_details['bank_zipcode']=$branch_info->row()->bank_zipcode;
				}
				$recipient_name = $recipient_code = "";
				$where=array('type'=>'0','bill_id'=>$invoice,'status'=>1);
				$reveninfo=$this->common->gettbldata($where,'id,order_id,recipient_code,recipient_name,debtor_jfr,amount,currency','tb_reveneus',0,0);
				if(count($reveninfo)>0){
					foreach ($reveninfo as $eachreveninfo) {
						$order_id= "";
						$revenue_id = $eachreveninfo['id'];
						$order_id=$eachreveninfo['order_id'];
						$recipient_code = $eachreveninfo['recipient_code'];
						$recipient_name = $eachreveninfo['recipient_name'];
						$add_info['amount']=$eachreveninfo['amount'];
						/*$total_amount += $eachreveninfo['amount'];*/
						$add_info['currency']=$eachreveninfo['currency'];
						$add_info['debtor_jfr']=$eachreveninfo['debtor_jfr'];
						if($order_id != ""){
							$chkorder = $this->Order->getordertoedit($order_id);
							if($chkorder->num_rows() >0){
								$gene_order_id = $chkorder->row()->order_id;
								$add_info['tracking_number']=$chkorder->row()->order_id;
								$pickup_address['pickup_company']=$chkorder->row()->pickup;
								$pickup_address['pickup_country']=$chkorder->row()->pickup_country;
								$pickup_address['pickup_city']=$chkorder->row()->pickup_city;
								$pickup_address['pickup_pincode']=$chkorder->row()->pickup_pincode;
								$pickup_address['pickup_address1']=$chkorder->row()->pickup_address1;
								$delivery_address['delivery_company']=$chkorder->row()->delivery;
								$delivery_address['delivery_country']=$chkorder->row()->delivery_country;
								$delivery_address['delivery_city']=$chkorder->row()->delivery_city;
								$delivery_address['delivery_pincode']=$chkorder->row()->delivery_pincode;
								$delivery_address['delivery_address1']=$chkorder->row()->delivery_address1;
								$customer_id=$chkorder->row()->customer_id;
                                if (checkAccessConditions('RELATED_2_SG_MY', $usercompany_code)) {
									$sgmy_where = array('code'=>$recipient_code,'name'=>$recipient_name,'status'=>'1');
									$custdetails = $this->common->gettblrowdata($sgmy_where,"name,phone,code,email_id,location,street,state,country,pincode","tb_customers",0,0);
									if(count($custdetails)>0){
										$shipper_address['name']=$custdetails['name'];
										$shipper_address['location']=$custdetails['location'];
										$shipper_address['street']=$custdetails['street'];
										$shipper_address['state']=$custdetails['state'];
										$shipper_address['country']=$custdetails['country'];
										$shipper_address['pincode']=$custdetails['pincode'];
										$customer_code = $custdetails['code'];

									}
								}else{
                                    $where = array("id"=>$customer_id);
								    $custdetails = $this->common->gettblrowdata($where,"name,phone,code,email_id,location,street,state,country,pincode","tb_customers",0,0);
								    if(count($custdetails)>0){
									    $shipper_address['name']=$custdetails['name'];
									    $shipper_address['location']=$custdetails['location'];
									    $shipper_address['street']=$custdetails['street'];
									    $shipper_address['state']=$custdetails['state'];
									    $shipper_address['country']=$custdetails['country'];
									    $shipper_address['pincode']=$custdetails['pincode'];
										$customer_code = $custdetails['code'];
								    }
								}
								$ordwhere = array("order_row_id"=>$order_id);
								$order_sub_details = $this->common->gettblrowdata($ordwhere,"delivery_term,incoterm,delivery_note,notify_party,customs_required,lane_reference","tb_order_details",0,0);
								if(count($order_sub_details)>0){
									$add_info['inco_term']=$order_sub_details['incoterm'];
									$delivery_note=$order_sub_details['delivery_note'];
									if($order_sub_details['customs_required']==1){
										$add_info['customs_required']='Y';
									}else{
										$add_info['customs_required']='N';
									}
									$add_info['lane_reference']=$order_sub_details['lane_reference'];
									$where=array("term_id"=>$delivery_note);
									$delivery_incoterms= $this->common->gettblrowdata($where,"name","tb_delivery_terms",0,0);
									if(count($delivery_incoterms)>0){
										$add_info['delivery_term']=$delivery_incoterms['name'];
									}
								}
								$where=array("order_id"=>$order_id);
								$cargo_info = $this->common->gettbldata($where,"cargo_id,handling_unit,quantity_type,length,width,height,weight,volume,quantity,quantity_type,cargo_content","tb_order_cargodetails ",0,0);
								$order_reference=$this->truckwaybillmodel->orderrefernce($gene_order_id);
								$notify_party=$this->truckwaybillmodel->notify_party($gene_order_id);
								if($notify_party->num_rows()>0){
									$noity_address['name']=$notify_party->row()->name;
									$noity_address['location_id']=$notify_party->row()->location_id;
									$noity_address['address']=$notify_party->row()->address;
									$noity_address['country']=$notify_party->row()->country;
									$noity_address['state']=$notify_party->row()->state;
								}
								$tracknum=$chkorder->row()->order_id;
								if($tracknum!=''){
									$tripinfo = getTripinfoByOrder($tracknum);
									if(isset($tripinfo['ship_id'])){
										$shift_id = $tripinfo['ship_id'];
										if(isset($tripinfo['trip_id'])){
											$driver_info = $this->truckwaybillmodel->driverinfo($tripinfo['trip_id']);
											if($driver_info->num_rows()>0){
												$driver_name=$driver_info->row()->name;
											}
										}else{
											$driver_name = $this->truckwaybillmodel->shiftdriverinfo($shift_id);
										}
								//get vehicel information
										$truck_num=$this->truckwaybillmodel->vehicelinfo($shift_id);
									}
								}
							}
							$add_info['driver_name']=$driver_name;
							if(!empty($truck_num)){
							  $add_info['truck_num']=$truck_num['register_number'];
							  $add_info['trailer_no']=$truck_num['truck_number'];
						    }
							 $pickup_datetime = $chkorder->row()->pickup_datetime;
					$delivery_datetime = $chkorder->row()->delivery_datetime;
					$getactual = getdatetimebytimezone($curtz,$pickup_datetime,DFLT_TZ);
					$add_info['departure_date'] = date("d-m-Y", strtotime($getactual['date']));
					$getactual = getdatetimebytimezone($curtz,$delivery_datetime,DFLT_TZ);
				    $add_info['arrival_date'] = date("d-m-Y", strtotime($getactual['date']));
				    $charges = array();
				    $getcharges =$this->truckwaybillmodel->getchargesbyrevid($revenue_id);
				    if(!empty($getcharges)){
				    	foreach ($getcharges as $getcharge) {
				    		$vat_amount = $vat_percentage = 0;
				    		if(is_numeric($getcharge['vat_amount'])){
                             $vat_amount = $getcharge['vat_amount'];
				    		}
				    		if(is_numeric($getcharge['vat_percentage'])){
				    			$vat_percentage = $getcharge['vat_percentage'];
				    		}
				    	if($getcharge['local_amount'] > 0){
				    	 $charges[] = array('chargecodename'=>$getcharge['chargecodename'],'amount'=>$getcharge['local_amount'],'currency'=>$getcharge['local_currency'],'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$getcharge['cat_val']);
				    	    $total_amount += $getcharge['local_amount'];
				    	    $total_vat += $getcharge['vat_amount'];
				    	}else{
                      $charges[] = array('chargecodename'=>$getcharge['chargecodename'],'amount'=>$getcharge['amount'],'currency'=>$getcharge['currency'],'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$getcharge['cat_val']);
                          $total_amount += $getcharge['amount'];
                          $total_vat += $getcharge['vat_amount'];
                       }
                      }
				    }
							$orders_data[] = array('pickup_address'=>$pickup_address,'delivery_address'=>$delivery_address,'shipper_address'=>$shipper_address,'cargo_details'=>$cargo_info,'order_reference'=>$order_reference,'noity_address'=>$noity_address,'branch_details'=>$branch_details,'add_info'=>$add_info,'type'=>$type,'charges'=>$charges);
							/*$departure_date=$this->truckwaybillmodel->getvehicledetails($gene_order_id);*/
						}
					}
			    //get orders infornmation
					if($this->session->userdata('company_code')=='NZKN'){
						$where=array('type'=>'0','bill_id'=>$invoice,'amount >'=>0,'invoice_status'=>2,'status'=>1);
						$ord_info=$this->common->gettbldata($where,'id,order_id,amount,createdon','tb_reveneus',0,0);
						if(count($ord_info)>0){
							foreach($ord_info as $info){
								$ordinfo=$chargeinfo=array();
								$rev_id=$info['id'];
								$ord_id=$info['order_id'];
								$createdon=date("d-m-Y",strtotime($info['createdon']));
								$where=array('revenue_id'=>$rev_id);
								$costinfo=$this->common->gettbldata($where,'charge_code,amount,description','tb_charges',0,0);
								if(count($costinfo)>0){
									foreach($costinfo as $char){
										$cinfo=array();
										$charge_name='Freight';
										$chargecode=$char['charge_code'];
										if($chargecode!=0){
											$where=array('id'=>$chargecode);
											$charref=$this->common->gettblrowdata($where,'name','tb_charge_codes',0,0);
											if(count($charref)>0){
												$charge_name=	$charref['name'];
											}
										}
										$cinfo['charge_name']= $charge_name;
										$cinfo['charge_amount']=  $char['amount'];
										$chargeinfo[]= $cinfo;
									}
								//$ordinfo['service']=$costinfo['charge_code'];
								//$ordinfo['description']=$costinfo['description'];
								}else{
									$cinfo['charge_name']= 'Freight';
									$cinfo['charge_amount']= '0.00' ;
									$chargeinfo[]= $cinfo;
								}
								$ordinfo['amount']=$info['amount'];
								$where=array('id'=>$ord_id);
								$parentorder=$this->common->gettblrowdata($where,'pickup_company,pickup_datetime,order_id,delivery_company,pickup_city,delivery_city,quantity,weight,volume','tb_orders',0,0);
								$where=array('order_id'=>$ord_id,'reference_id'=>'DQ');
								$ref='';
								$orderref=$this->common->gettblrowdata($where,'ref_value','tb_order_references',0,0);
								if(count($orderref)>0){
									$ref=$orderref['ref_value'];
								}
								if(count($parentorder)>0){
									$ordinfo['pickup_company']=$parentorder['pickup_company'];
									$ordinfo['delivery_company']=$parentorder['delivery_company'];
									$ordinfo['pickup_city']=$parentorder['pickup_city'];
									$ordinfo['delivery_city']=$parentorder['delivery_city'];
									$ordinfo['quantity']=$parentorder['quantity'];
									$ordinfo['weight']=$parentorder['weight'];
									$ordinfo['volume']=$parentorder['volume'];
									$ordinfo['creat_date']=$createdon;
									$ordinfo['order_reference']=$ref;
									$ordinfo['track_num']=$parentorder['order_id'];
									$ordinfo['shipment_date']=date("d-m-Y",strtotime($parentorder['pickup_datetime']));
									$ordinfo['charge_info']=$chargeinfo;
								}
								$orderinfo[]=$ordinfo;
							}
						}
					}

				}
			}
		}
		$data['pickup_address']=$pickup_address;
		$data['delivery_address']=$delivery_address;
		$data['shipper_address']=$shipper_address;
		$data['cargo_details']=$cargo_info;
		$data['order_reference']=$order_reference;
		$data['noity_address']=$noity_address;
		$data['branch_details']=$branch_details;
		$add_info['driver_name']=$driver_name;
		$add_info['truck_num']=$truck_num;
		$add_info['departure_date']=$departure_date;
		$data['add_info']=$add_info;
		$data['orderinfo']=$orderinfo;

		if($this->session->userdata('company_code')=='NZKN'){
			$mpdf = new \Mpdf\Mpdf([
				'mode' => 'utf-8',
				'tempDir' => FCPATH .'assets/tmp',
				'default_font_size' => 9,
				'format' => 'A4-L'
			]);
			$mpdf->setAutoBottomMargin='stretch';

		}else{
			$mpdf = new \Mpdf\Mpdf([
				'mode' => 'utf-8',
				'tempDir' => FCPATH .'assets/tmp',
				'default_font_size' => 9, 'format' => 'A4'
			]);
			$mpdf->setAutoBottomMargin='stretch';
		}
		$footer='';
		$header='';
		if($this->session->userdata('company_code')=='NZKN'){
            $mpdf->WriteHTML($this->load->view('nzinvoice/index',$data,true));
			$footer= $this->load->view('nzinvoice/footer',$data,true);
		}else{

			$html = '';
			$count = count($orders_data)-1;
			for($i=0;$i<count($orders_data);$i++){
				if($count == $i){
					$orders_data[$i]['total_amount']= $total_amount;
					$orders_data[$i]['total_vat']= $total_vat;
				}
                $mpdf->WriteHTML($this->load->view('kninvoice/index',$orders_data[$i],true));
				if($i<($count)){
                    $mpdf->WriteHTML("<pagebreak/>");
				}
			}
		}
		$mpdf->SetFooter($footer);
		if(count($orderinfo)>5){
			$mpdf->shrink_tables_to_fit = 1;
		}
		$page_count = count($mpdf->pages);
		$pdfPath = "./assets/tmp/".$filename.".pdf";
		$mpdf->Output($pdfPath, 'F');
		return $pdfPath;

	}
	public function donwloadexternalinvoice($order_ids,$bill_id){
		$filePath = $pdfPath = "";
		$data = $orderdetails = array();
		$revenues = $charges = $orderdetails = $cargos = $branch_details = $customer_details = array();
		$total_weight = $total_volume = $total_qty = $total_ldm = $total_charges_amount = $total_charge_vat = $shift_id = $total_rev_amount = 0;
		$company_code = $vat_id = $tax_id =$invoice_number = $invoice_date = $debtor_jfr = $bu_jfr = $inn = $currency = $customer_code = $register_number = $incoterm = $bookingid = $filename  = $general_code = $bill_party = "";
		$session_currency = $this->session->userdata("usr_tzone")['currency'];
		$add_info=array();
		$returndata = $this->aconinvoiceduedate->getrequest($bill_id);
		$where=array('id'=>$bill_id);
		$invoice_date = date('Y-m-d');
		$invoiceinfo=$this->common->gettblrowdata($where,'bill_party,invoice_no,invoice_date,acon_code,customer_code,code,branch_code,acon_invoice_due_date','tbl_bills',0,0);
		if(count($invoiceinfo)>0){
			$add_info['invoice_no']            = $filename = $invoiceinfo['invoice_no'];
			$add_info['general_code']          =  $general_code = $invoiceinfo['code'];
			$add_info['invoice_date']          = $invoice_date = date("Y-m-d",strtotime($invoiceinfo['invoice_date']));
			$add_info['customer_code']         = $invoiceinfo['customer_code'];
			$add_info['acon_code']             = $invoiceinfo['acon_code'];
			$branchcode                        = $invoiceinfo['branch_code'];
			$add_info['acon_invoice_due_date'] = $invoiceinfo['acon_invoice_due_date'];
			$bill_party                         = $invoiceinfo['bill_party'];
		}
		if($general_code != ""){
			$get_customerdetails = $this->common->gettblrowdata(array('code'=>$general_code,'name'=>$bill_party,'status'=>'1'),"name,location_id,country,state,street,pincode,vat_reg_no,tax_payer_no","tbl_party_master",0,0);
			if(!empty($get_customerdetails)){
				$customer_details = array('name'=>$get_customerdetails['name'],'country'=>strtolower($get_customerdetails['country']),'state'=>$get_customerdetails['state'],'street'=>$get_customerdetails['street'],'location'=>$get_customerdetails['location_id'],'pincode'=>$get_customerdetails['pincode']);
				$vat_id = $get_customerdetails['vat_reg_no'];
				$tax_id = $get_customerdetails['tax_payer_no'];
			}else{
				$getcustomerdetails = $this->common->gettblrowdata(array('code'=>$general_code,'name'=>$bill_party,'status'=>'1'),"name,country,state,street,location,pincode","tb_customers",0,0);
				if(!empty($getcustomerdetails)){
					$customer_details = array('name'=>$getcustomerdetails['name'],'country'=>strtolower($getcustomerdetails['country']),'state'=>$getcustomerdetails['state'],'street'=>$getcustomerdetails['street'],'location'=>$getcustomerdetails['location_id'],'pincode'=>$getcustomerdetails['pincode']);
				}
			}
		}
		$childid=0;
		$user_name = "";
		$user_id=$this->session->userdata('user_id');
		if($this->session->userdata('childid')){
			$childid = $this->session->userdata('childid');
		}
		if($childid > 0){
			$getusername = $this->common->gettblrowdata(array("id"=>$childid),"name","tb_user_logins",0,0);
			if(!empty($getusername)){
				$user_name= $getusername['name'];
			}
		}else{
			$getusername = $this->common->gettblrowdata(array("id"=>$user_id),"name","tb_users",0,0);
			if(!empty($getusername)){
				$user_name= $getusername['name'];
			}
		}

		$add_info['user_name'] = $user_name;
		if(!empty($order_ids)){
			$company_code = $this->session->userdata('company_code');
			$branch_code = $this->session->userdata('branch_code');
			$getbranchdetails = $this->common->gettblrowdata(array('branch_code'=>$branch_code,'status'=>'1'),"branch_name,city,street,zipcode,country,state,phone,fax","tb_branch_details",0,0);
			if(!empty($getbranchdetails)){
				$branch_details = array('branch_name'=>$getbranchdetails['branch_name'],'city'=>$getbranchdetails['city'],'street'=>$getbranchdetails['street'],'zipcode'=>$getbranchdetails['zipcode'],'country'=>strtolower($getbranchdetails['country']),'state'=>$getbranchdetails['state'],'phone'=>$getbranchdetails['phone'],'fax'=>$getbranchdetails['fax']);
			}
			$order_details = $this->truckwaybillmodel->orderdetails_forbilling($order_ids);
			if(!empty($order_details)){
				foreach ($order_details as $res) {
					$customer_id = $res['customer_id'];
					$bookingid = $res['order_id'];
					$order_id = $res['id'];
					$shift_id = $res['shift_id'];
					$getordercargo = $this->common->gettbldata(array('order_id' => $order_id,'status' => '1'),"id,cargo_id,weight,ldm,volume,quantity,quantity_type,cargo_content,marks_numbers", "tb_order_cargodetails", 0, 0);
					$cargos = array();
					$total_weight = $total_volume = $total_qty = $total_ldm = 0;
					if(!empty($getordercargo)){
						foreach ($getordercargo as $ordcargo) {
							$total_weight += $ordcargo['weight'];
							$total_volume += $ordcargo['volume'];
							$total_qty    += $ordcargo['quantity'];
							$total_ldm    += $ordcargo['ldm'];
							$cargos[] = array('cargo_id'=>$ordcargo['cargo_id'],'weight'=>$ordcargo['weight'],'ldm'=>$ordcargo['ldm'],'volume'=>$ordcargo['volume'],'quantity'=>$ordcargo['quantity'],'cargo_content'=>$ordcargo['cargo_content'],'quantity_type'=>$ordcargo['quantity_type'],'marks_numbers'=>$ordcargo['marks_numbers']);
						}
					}
					$charges = $vat_arr = $vat_applicable_arr = $revenues = array();
					$vat_applicable_amnt = $vat_notapplicable_amnt = $final_local_vat_amount = $final_local_amount = $exchange_rate = 0;
					$final_currency = $final_local_currency = "";
					$getrevenuedetails = $this->common->gettbldata(array('type'=>'0','order_id' => $order_id,'bill_id' => $bill_id,'status' => '1'),"id,amount,exchange_rate", "tb_reveneus", 0, 0);
					if(!empty($getrevenuedetails)){
						foreach ($getrevenuedetails as $rev) {
							$rev_amount    = $rev['amount'];
							$exchange_rate = $rev['exchange_rate'];
							if($rev_amount >0){
								$revenues[] =$rev['id'];
							}
						}
					}
					$currency_arr = $this->truckwaybillmodel->checksinglecurrencyexists_inallcharges($revenues,$session_currency);
					if(!empty($currency_arr)){
						if(count($currency_arr) >1){
							$chk_localcurrency = 0;
						}else{
							if(in_array($session_currency,$currency_arr)){
								$chk_localcurrency = 0;
							}else{
								$chk_localcurrency = 1;
							}
						}
					}
					if(!empty($revenues)){
						foreach ($revenues as $eachid) {
							$revenue_id = $eachid;
							$total_charges_amount = 0;
							$getcharges = $this->common->gettbldata(array('revenue_id' => $revenue_id,'status' => '1'),"id,charge_code,description,amount,currency,local_amount,local_currency,local_vat_amount,vat_percentage,vat_amount,cat_id,cat_val", "tb_charges", 0, 0);
							if(!empty($getcharges)){
								foreach ($getcharges as $chrg) {
									$final_amount   = $chrg['amount'];
									$final_currency = $chrg['currency'];
									$vat_percentage = $chrg['vat_percentage'];
									$local_currency = $chrg['local_currency'];
									$local_amount   = $chrg['local_amount'];
									if($chk_localcurrency == "0"){
										if($local_amount > 0){
											$final_amount = $local_amount;
											$final_currency = $local_currency;
										}
									}
									$local_vat_amount = $chrg['local_vat_amount'];
									$vat_amount = $chrg['vat_amount'];
									if($chk_localcurrency == "0"){
										if(is_numeric($local_vat_amount)){
											$vat_amount = $chrg['local_vat_amount'];
										}
									}
									$final_local_amount += $local_amount;
									$final_local_vat_amount += $local_vat_amount;
									$final_local_currency = $local_currency;
									$total_charges_amount += $final_amount;
									if(is_numeric($vat_percentage)){
										if($vat_percentage >0){
											if(empty($vat_arr)){
												$vat_arr[] = $vat_percentage;
											}else{
												if(!in_array($vat_percentage, $vat_arr)){
													$vat_arr[] = $vat_percentage;
												}
											}
										}else{
											$vat_percentage = "0.00";
										}
									}else{
										$vat_percentage = "0.00";
									}
									$charges[] = array('charge_code'=>$chrg['charge_code'],'description'=>$chrg['description'],'amount'=>$final_amount,'currency'=>$final_currency,'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$chrg['cat_val'],'cat_id'=>$chrg['cat_id']);
								}
							}
						}
					}
					$zero_percentage = $applied_vat_amount = $total_vat_applicable_amount = $total_vatpercentage_amount =0;
					if(!empty($vat_arr)){
						foreach ($vat_arr as $vat_per) {
							$single_vat = $vat_per;
							if(!empty($charges)){
								foreach ($charges as $chrg) {
									$charge_vat_percentage = $chrg['vat_percentage'];
									if($charge_vat_percentage > 0){
										if($charge_vat_percentage == $single_vat){
											$vat_applicable_amnt   += $chrg['amount'];
											$applied_vat_amount += $chrg['vat_amount'];
											$vat_applicable_arr[$charge_vat_percentage] = array('vat_applicable_amount'=>$vat_applicable_amnt,'vat_percentage'=>$charge_vat_percentage,'vat_amount'=>$applied_vat_amount);
										}else{
											$applied_vat_amount = $vat_applicable_amnt = "0.00";
										}
									}
								}
							}
						}
					}
					if(!empty($charges)){
						foreach ($charges as $chrg) {
							$vat_percentage = $chrg['vat_percentage'];
							if($vat_percentage == 0){
								$vat_notapplicable_amnt += $chrg['amount'];
								$vat_applicable_arr[$zero_percentage] = array('vat_applicable_amount'=>$vat_notapplicable_amnt,'vat_percentage'=>'0.00','vat_amount'=>'0.00');
							}
						}
					}
					if(!empty($vat_applicable_arr)){
						foreach ($vat_applicable_arr as $each) {
							$total_vat_applicable_amount += $each['vat_applicable_amount'];
							$total_vatpercentage_amount  += $each['vat_amount'];
						}
					}
					$final_total_amount       = $total_vat_applicable_amount + $total_vatpercentage_amount;
					$final_local_total_amount = $final_local_amount + $final_local_vat_amount;
					$register_number = "";
					if($shift_id >0){
						$getvehicle = $this->common->gettblrowdata(array('shft_id'=>$shift_id,'status'=>'1'),"register_number","tb_shft_veh",0,0);
						if(!empty($getvehicle)){
							$register_number = $getvehicle['register_number'];
						}
					}
					$incoterm = "";
					$getincoterm = $this->common->gettblrowdata(array('order_row_id'=>$order_id),"incoterm","tb_order_details",0,0);
					if(!empty($getincoterm)){
						$incoterm = $getincoterm['incoterm'];
					}
					$inn = "";
					$getinn = $this->common->gettblrowdata(array('order_id'=>$order_id,'reference_id'=>'INN','status'=>'1'),"ref_value","tb_order_references",0,0);
					if(!empty($getinn)){
						$inn = $getinn['ref_value'];
					}
					$donumber = "";
					$getdonumber = $this->common->gettblrowdata(array('order_id'=>$order_id,'reference_id'=>'DQ','status'=>'1'),"ref_value","tb_order_references",0,0);
					if(!empty($getdonumber)){
						$donumber = $getdonumber['ref_value'];
					}
					$ponumber = "";
					$getgetponumber = $this->common->gettblrowdata(array('order_id'=>$order_id,'reference_id'=>'PO','status'=>'1'),"ref_value","tb_order_references",0,0);
					if(!empty($getgetponumber)){
						$ponumber = $getgetponumber['ref_value'];
					}
					$total_rev_amount = 0;
					$currency = $this->session->userdata("usr_tzone")['currency'];
					$gettotalrev = $this->common->gettblrowdata(array('type'=>'0','order_id' => $order_id,'bill_id'=>$bill_id,'status'=>'1'), "sum(amount) as total_amount,currency", "tb_reveneus", 0, 0);
					if(!empty($gettotalrev)){
						$total_rev_amount = $gettotalrev['total_amount'];
						$currency = $gettotalrev['currency'];
					}
					$debtor_jfr= "";
					$getjfr = $this->common->gettblrowdata(array('type'=>'0','order_id'=>$order_id),"debtor_jfr","tb_reveneus",0,0);
					if(!empty($getjfr)){
						$debtor_jfr     = $getjfr['debtor_jfr'];
					}
					$total_cargos = array('total_ldm'=>$total_ldm,'total_qty'=>$total_qty,'total_volume'=>$total_volume,'total_weight'=>$total_weight);
					$orderdata = array('booking_id'=>$res['order_id'],'pickup_datetime'=>$res['pickup_datetime'],'pickup_company'=>$res['pickup_company'],'delivery_company'=>$res['delivery_company'],'pickup_country'=>strtolower($res['pickup_country']),'delivery_country'=>strtolower($res['delivery_country']),'pickup_city'=>$res['pickup_city'],'delivery_city'=>$res['delivery_city'],'pickup_pincode'=>$res['pickup_pincode'],'delivery_pincode'=>$res['delivery_pincode'],'pickup_address1'=>$res['pickup_address1'],'delivery_address1'=>$res['delivery_address1'],'pickup_address2'=>$res['pickup_address2'],'delivery_address2'=>$res['delivery_address2'],'tax_id'=>$tax_id,'vat_id'=>$vat_id,'company_code'=>$company_code,'incoterm'=>$incoterm,'register_number'=>$register_number,'inn'=>$inn,'customer_code'=>$customer_code,'donumber'=>$donumber,'ponumber'=>$ponumber,'debtor_jfr'=>$debtor_jfr,'invoice_date'=>$invoice_date,'invoice_number'=>$filename,'total_charges_amount'=>$total_charges_amount,'total_rev_amount'=>$total_rev_amount,'currency'=>$currency,'session_currency'=>$session_currency,'currency'=>$final_currency,'final_local_currency'=>$final_local_currency);
					$orderdetails[] = array('orderdata'=>$orderdata,'customer_details'=>$customer_details,'charges'=>$charges,'branch_details'=>$branch_details,'total_cargos'=>$total_cargos,'cargos'=>$cargos,'add_info'=>$add_info,'vat_applicable_arr'=>$vat_applicable_arr,'final_total_amount'=>$final_total_amount,'total_vat_applicable_amount'=>$total_vat_applicable_amount,'total_vatpercentage_amount'=>$total_vatpercentage_amount,'final_local_vat_amount'=>$final_local_vat_amount,'final_local_amount'=>$final_local_amount,'final_local_total_amount'=>$final_local_total_amount,'chk_localcurrency'=>$chk_localcurrency,'exchange_rate'=>$exchange_rate);
				}
			}
			$data['orderdetails'] = $orderdetails;
			if(!empty($data['orderdetails'])){
				$html = "";
		        $mpdf = new \Mpdf\Mpdf([
					'tempDir' => FCPATH .'assets/tmp',
					'mode' => 'utf-8',
					'default_font_size' => 9,
					'format' => 'A4',
					'margin_footer' => 10,
					'orientation' => 'P']);
				$mpdf->setAutoBottomMargin='false';
				$mpdf->defaultfooterline=0;
		        $count = count($data['orderdetails'])-1;
				for($i=0;$i<count($data['orderdetails']);$i++){
					/*print_r($data['orderdetails'][$i]);*/
					$html .= $this->load->view('billinginvoices/externalinvoice', $data['orderdetails'][$i], TRUE);
					$footerdata= $this->load->view('billinginvoices/footer', $data['orderdetails'][$i], TRUE);
					$mpdf->setFooter('<table style="padding:100px;" height="100%" width="100%">'.$footerdata.'</table>');
					if($i<($count)){
						$html .= "<pagebreak/>";
					}
				}
				if($filename == ""){
		        }else{
					$pdfPath = "./assets/tmp/".$filename.".pdf";
					$mpdf->WriteHTML($html);
					$mpdf->Output($pdfPath, 'F');
		        }
			}
		}
		return $pdfPath;
	}
}
