<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Altovaroadlogstatus extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('Roadlog_status');
    }

    public function index(): void
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (empty($postData)) {
            echo "Please Send Proper XML";
            return;
        }
        $this->pushRoadlogXml($postData);
    }

    private function pushRoadlogXml(string $postData): void
    {
        if (!($xml = new SimpleXMLElement($postData))) {
            echo "Invalid request,Please try again!";
            return;
        }
        $MessageHeader = $xml->xpath('lhdr:MessageHeader');
        $orderInfo = [
            "physicalreceiver" => (string)($MessageHeader[0]->xpath('PhysicalSender')[0]) ?? "",
            "logicalreceiver" => (string)($MessageHeader[0]->xpath('LogicalSender')[0]) ?? "",
            "physicalsender" => (string)($MessageHeader[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver) ?? "",
            "logicalsender" => (string)($MessageHeader[0]->xpath('ReceiverDetails')[0]->LogicalReceiver) ?? "",
        ];
        $this->roadlog_status->publishxml($postData, $orderInfo);
    }
}
