<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Amazonedipostman extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        $this->load->model("common");
    }

    /**
     * Process Amazonin EDI.
     *
     * @return void
     */
    public function index()
    {
        ini_set("post_max_size", 0);
        ini_set("upload_max_filesize", "64M");
        ini_set("max_input_time", 1200);
        ini_set("memory_limit", "1024M");
        ini_set("max_execution_time", 1200);
        $file_data = file_get_contents('php://input');
        if (!empty($file_data)) {
            $explodecontainers = explode("ST*856", $file_data);
            $basicinfo = isset($explodecontainers[0]) ? $explodecontainers[0] : "";
            if ($basicinfo != "") {
                $allcontainers = array();
                for ($z = 1; $z < count($explodecontainers); $z++) {
                    if (isset($explodecontainers[$z])) {
                        $allcontainers[] = "ST*856" . $explodecontainers[$z];
                    }
                }
                $genInfo = array();
                $basics = explode("~", $basicinfo);
                for ($i = 0; $i < count($basics); $i++) {
                    if (isset($basics[$i])) {
                        if (strpos($basics[$i], "ISA") !== false) {
                            $ISADetails = array_filter(explode('*', $basics[$i]));
                            if ($ISADetails[0] == "ISA") {
                                $genInfo['ISADetails']['isaValue0'] = $ISADetails['0'];
                                $genInfo['ISADetails']['isaValue1'] = $ISADetails['1'];
                                $genInfo['ISADetails']['isaValue2'] = $ISADetails['2'];
                                $genInfo['ISADetails']['isaValue3'] = $ISADetails['3'];
                                $genInfo['ISADetails']['isaValue4'] = $ISADetails['4'];
                                $genInfo['ISADetails']['isaValue5'] = $ISADetails['5'];
                                $genInfo['ISADetails']['isaValue6'] = $ISADetails['6'];
                                $genInfo['ISADetails']['isaValue7'] = $ISADetails['7'];
                                $genInfo['ISADetails']['isaValue8'] = $ISADetails['8'];
                                $genInfo['ISADetails']['isaValue9'] = $ISADetails['9'];
                                $genInfo['ISADetails']['isaValue10'] = $ISADetails['10'];
                                $genInfo['ISADetails']['isaValue11'] = $ISADetails['11'];
                                $genInfo['ISADetails']['isaValue12'] = $ISADetails['12'];
                                $genInfo['transactionId'] = $ISADetails['13'];
                            }
                        }
                        if (strpos($basics[$i], 'GS') !== false) {
                            $GSetails = array_filter(explode('*', $basics[$i]));
                            if ($GSetails['1'] == 'SH') {
                                foreach ($GSetails as $gsrefKey => $gsrefValues) {
                                    $genInfo['ISADetails']['gs' . $gsrefKey] = $gsrefValues;
                                }
                            }
                        }
                    }
                }
                if (!empty($allcontainers)) {
                    foreach ($allcontainers as $containerinfo) {
                        $explodedContents = array();
                        $explodedContents12 = array();
                        $explodedContents12 = explode("~", $containerinfo);
                        $explodedContents = array_filter($explodedContents12);
                        $generalInfo = [];
                        $generalInfo = $genInfo;
                        $shipmentInfo = [];
                        $orderInfo = [];
                        $itemInfo = [];
                        $orderInfo['container'] = array();
                        $l = 0;
                        for ($i = 0; $i < count($explodedContents); $i++) {
                            if (isset($explodedContents[$i])) {
                                $explodedContents[$i] = trim($explodedContents[$i]);
                                if (strpos($explodedContents[$i], 'ST') !== false) {
                                    $STDetails = array();
                                    $STDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if ($STDetails['1'] == '856') {
                                        $generalInfo['ST856Details']['code0'] = $STDetails['0'] ?? "";
                                        $generalInfo['ST856Details']['code1'] = $STDetails['1'] ?? "";
                                        $generalInfo['ST856Details']['code2'] = $STDetails['2'] ?? "";
                                    }
                                }
                                if (strpos($explodedContents[$i], 'BSN') !== false) {
                                    $BSNDetails = array();
                                    $BSNDetails = array_filter(explode('*', $explodedContents[$i]));
                                    $generalInfo['BSNInfo']['bsnVal1'] = isset($BSNDetails['1']) ? $BSNDetails['1'] : "";
                                    $generalInfo['BSNInfo']['shipmentId'] = isset($BSNDetails['2']) ? $BSNDetails['2'] : "";
                                    $generalInfo['BSNInfo']['bsnVal2'] = isset($BSNDetails['3']) ? $BSNDetails['3'] : "";
                                    $generalInfo['BSNInfo']['bsnVal3'] = isset($BSNDetails['4']) ? $BSNDetails['4'] : "";
                                    $generalInfo['BSNInfo']['bsnVal4'] = isset($BSNDetails['5']) ? $BSNDetails['5'] : "";
                                }
                                if (strpos($explodedContents[$i], 'DTM') !== false) {
                                    $DTMDetails = array();
                                    $DTMDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if ($DTMDetails[1] == '017') { // Estimated Delivery
                                        $generalInfo['DTMDetails']['DTMValue1'] = isset($DTMDetails['1']) ? $DTMDetails['1'] : "";
                                        $generalInfo['DTMDetails']['estimatedDate'] = isset($DTMDetails['2']) ? $DTMDetails['2'] : "";
                                        $generalInfo['DTMDetails']['estimatedTime'] = isset($DTMDetails['3']) ? $DTMDetails['3'] : "";
                                        $generalInfo['DTMDetails']['DTMValue4'] = isset($DTMDetails['4']) ? $DTMDetails['4'] : "";
                                    } else if ($DTMDetails[1] == '050') {
                                        $generalInfo['DTMDetails']['receivedValue1'] = isset($DTMDetails['1']) ? $DTMDetails['1'] : "";
                                        $generalInfo['DTMDetails']['receivedDate'] = isset($DTMDetails['2']) ? $DTMDetails['2'] : "";
                                        $generalInfo['DTMDetails']['receivedTime'] = isset($DTMDetails['3']) ? $DTMDetails['3'] : "";
                                        $generalInfo['DTMDetails']['receivedValue4'] = isset($DTMDetails['4']) ? $DTMDetails['4'] : "";
                                    }
                                }
                                if (strpos($explodedContents[$i], 'HL') !== false) {
                                    $HLDetails = array();
                                    $HLDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($HLDetails[1])) {
                                        if ($HLDetails[1] == 1) {
                                            $shipmentInfo['shipmentDetails']['shipmentLevel'] = isset($HLDetails['1']) ? $HLDetails['1'] : "";
                                            $shipmentInfo['shipmentDetails']['shipmentVal1'] = isset($HLDetails['3']) ? $HLDetails['3'] : "";
                                        }
                                    }
                                }

                                if (strpos($explodedContents[$i], 'TD1') !== false) {

                      if(isset($explodedContents[$i-1])){
                        if(strpos($explodedContents[$i-1], 'HL') !== false){
                          $packageDetails = array();
                          $packageDetails = explode('*', $explodedContents[$i]);
                          if(!empty($packageDetails)){
                            if($packageDetails[0] == "TD1"){
                              foreach($packageDetails as $pkg){
                                if(!empty($pkg)){
                                  $shipmentInfo['shipmentDetails']['packageinfo'][] = $pkg;
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                    if(strpos($explodedContents[$i], 'TD5') !== false) {
                      $TD5Details = array();
                      $TD5Details = array_filter(explode('*', $explodedContents[$i]));
                      if($TD5Details[0] == "TD5"){
                        $shipmentInfo['shipmentDetails']['carrierinfo'] = $TD5Details;
                      }
                    }

                                if (strpos($explodedContents[$i], 'TD3') !== false) {
                                    $TD3Details = array();
                                    $TD3Details = array_filter(explode('*', $explodedContents[$i]));
                                    if ($TD3Details[0] == "TD3") {
                                        $shipmentInfo['shipmentDetails']['equipmentCode'] = isset($TD3Details['1']) ? $TD3Details['1'] : "";
                                        $shipmentInfo['shipmentDetails']['equipmentInitial'] = isset($TD3Details['2']) ? $TD3Details['2'] : "";
                                        $shipmentInfo['shipmentDetails']['equipmentNumber'] = isset($TD3Details['3']) ? $TD3Details['3'] : "";
                                        $shipmentInfo['shipmentDetails']['grossWeight'] = isset($TD3Details['5']) ? $TD3Details['5'] : "1";
                                        $shipmentInfo['shipmentDetails']['weight'] = isset($TD3Details['5']) ? $TD3Details['5'] : "1";
                                        $shipmentInfo['shipmentDetails']['unit'] = isset($TD3Details['6']) ? $TD3Details['6'] : "";
                                        $shipmentInfo['shipmentDetails']['seal'] = isset($TD3Details['9']) ? $TD3Details['9'] : "";
                                        $shipmentInfo['shipmentDetails']['equipmentType'] = isset($TD3Details['10']) ? $TD3Details['10'] : "";
                                    }
                                }
                                if (strpos($explodedContents[$i], 'REF') !== false) {
                                    $REFDetails = array();
                                    $REFDetails = array_filter(explode('*', $explodedContents[$i]));
                                    foreach ($REFDetails as $refKey => $refValues) {
                                        if ($REFDetails['1'] == "CN") {
                                            if (!in_array($REFDetails['2'], $orderInfo['container'])) {
                                                $orderInfo['container'][] = $REFDetails['2'];
                                            }
                                        }
                                        $orderInfo['parties'][$REFDetails['1']] = $REFDetails['2'];
                                    }
                                }
                                if (strpos($explodedContents[$i], 'DTM') !== false) {
                                    $DTMDetails1 = array();
                                    $DTMDetails1 = array_filter(explode('*', $explodedContents[$i]));
                                    if ($DTMDetails1[1] == '011') {
                                        $shipmentInfo['shipmentDetails']['DTMValue1'] = $DTMDetails1['1'];
                                        $shipmentInfo['shipmentDetails']['estimatedDate'] = $DTMDetails1['2'];
                                        $shipmentInfo['shipmentDetails']['estimatedTime'] = isset($DTMDetails1['3']) ? $DTMDetails1['3'] : '';
                                        $shipmentInfo['shipmentDetails']['DTMValue4'] = $DTMDetails1['4'];
                                    }
                                }

                    if(strpos($explodedContents[$i], 'N1') !== false) {
                      $addressDetails = array();
                      $addressDetails = explode('*', $explodedContents[$i]);
                      foreach($addressDetails as $addKey => $addValues) {
                        if (strpos($addressDetails[$addKey], 'SF') !== false) {
                          $shipmentInfo['shipmentDetails']['shipFromAddress']['addressType'] = isset($addressDetails['1']) ? $addressDetails['1'] : "";
                          $shipmentInfo['shipmentDetails']['shipFromAddress']['countryName'] = isset($addressDetails['2']) ? $addressDetails['2'] : "";
                          $shipmentInfo['shipmentDetails']['shipFromAddress']['code'] = isset($addressDetails['3']) ? $addressDetails['3'] : "";
                          $shipmentInfo['shipmentDetails']['shipFromAddress']['airportCode'] = isset($addressDetails['4']) ? $addressDetails['4'] : "";
                          if(isset($explodedContents[$i+1])){
                            if(strpos($explodedContents[$i+1], 'N3') !== false) {
                              $address1Details = array_filter(explode('*', $explodedContents[$i+1]));
                              $shipmentInfo['shipmentDetails']['shipFromAddress']['address1'] = $address1Details;
                            }
                          }
                          if(isset($explodedContents[$i+2])){
                            if(strpos($explodedContents[$i+2], 'N4') !== false) {
                              $address2Details = explode('*', $explodedContents[$i+2]);
                              $shipmentInfo['shipmentDetails']['shipFromAddress']['address2'] = $address2Details;
                            }
                          }
                        }
                        if(isset($addressDetails[$addKey])){
                          if (strpos($addressDetails[$addKey], 'ST') !== false) {
                            if(!isset($shipmentInfo['shipmentDetails']['shipToAddress'][$addKey])){
                              $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['addressType'] = isset($addressDetails['1']) ? $addressDetails['1'] : "";
                              $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['countryName'] = isset($addressDetails['2']) ? $addressDetails['2'] : "";
                              $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['code'] = isset($addressDetails['3']) ? $addressDetails['3'] : "";
                              $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['airportCode'] = isset($addressDetails['4']) ? $addressDetails['4'] : "";
                            }
                            if(isset($explodedContents[$i+1]) && strpos($explodedContents[$i+1], 'N3') !== false) {
                              $address1Details = array_filter(explode('*', $explodedContents[$i+1]));
                              $shipmentInfo['shipmentDetails']['shipToAddress']['address1'] = $address1Details;
                            }
                            if(isset($explodedContents[$i+1]) && strpos($explodedContents[$i+2], 'N4') !== false) {
                              $address2Details = explode('*', $explodedContents[$i+2]);
                              $shipmentInfo['shipmentDetails']['shipToAddress']['address2'] = $address2Details;
                            }
                          }
                        }
                      }
                    }
                    if(strpos($explodedContents[$i], 'V1') !== false) {
                      $vesselDetails = array();
                      $vesselDetails = array_filter(explode('*', $explodedContents[$i]));
                      if($vesselDetails[0] == "V1"){
                        $shipmentInfo['shipmentDetails']['vesselCode'] = $vesselDetails['1'];
                        $shipmentInfo['shipmentDetails']['vesselName'] = $vesselDetails['2'];
                        $shipmentInfo['shipmentDetails']['vesselNumber'] = $vesselDetails['4'];
                        $shipmentInfo['shipmentDetails']['vesselSCAC'] = $vesselDetails['5'];
                        $shipmentInfo['shipmentDetails']['air'] = $vesselDetails['9'];
                      }
                    }

                                if (strpos($explodedContents[$i], 'R4') !== false) {
                                    $routeDetails = array();
                                    $routeDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if ($routeDetails[0] == "R4") {
                                        foreach ($routeDetails as $key => $rt) {
                                            $shipmentInfo['shipmentDetails']['routes'][] = $rt;
                                        }
                                    }
                                }
                                if (strpos($explodedContents[$i], 'DTM') !== false) {
                                    $DTMDetails2 = array();
                                    $DTMDetails2 = array_filter(explode('*', $explodedContents[$i]));
                                    if ($DTMDetails2[1] == '370') { // Estimated Delivery
                                        $shipmentInfo['shipmentDetails']['actualDepartureDate'] = $DTMDetails2['2'];
                                    } else if ($DTMDetails2[1] == 'AFD') {
                                        $shipmentInfo['shipmentDetails']['aDC'] = $DTMDetails2['2'];
                                    } else if ($DTMDetails2[1] == 'AAA') {
                                        $shipmentInfo['shipmentDetails']['arrivalInCountry'] = $DTMDetails2['2'];
                                    }
                                }

                                if (strpos($explodedContents[$i], "FOB") !== false) {
                                    $paymentTermDetails = array();
                                    $paymentTermDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if ($paymentTermDetails[0] == "FOB") {
                                        $shipmentInfo['shipmentDetails']['poRef'] = $paymentTermDetails;
                                    }
                                }
                                if (strpos($explodedContents[$i], 'HL') !== false) {
                                    $HLDetails = array();
                                    $HLDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($HLDetails[1])) {
                                        if ($HLDetails[1] == 3) {
                                            $orderInfo['orderHL3']['code1'] = $HLDetails['1'];
                                            $orderInfo['orderHL3']['code2'] = $HLDetails['2'];
                                            $orderInfo['orderHL3']['orderType'] = $HLDetails['3'];
                                        }
                                    }
                                }
                                if (strpos($explodedContents[$i], 'PRF') !== false) {
                                    $PRFOrdDetails = array();
                                    $PRFOrdDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($PRFOrdDetails[0])) {
                                        if ($PRFOrdDetails[0] == "PRF") {
                                            foreach ($PRFOrdDetails as $poref) {
                                                if ($poref != "") {
                                                    $orderInfo['prfOrdDetails'][] = $poref;
                                                }
                                            }
                                        }
                                    }
                                }
                                if (strpos($explodedContents[$i], 'MAN') !== false) {
                                    $manDetails = array();
                                    $manDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($manDetails[0])) {
                                        if ($manDetails[0] == "MAN") {
                                            foreach ($manDetails as $poman) {
                                                if ($poman != "" && $l == 0) {
                                                    $orderInfo['manDetails'] = $manDetails[2];
                                                }
                                                $l++;
                                            }
                                        }
                                    }
                                }
                                if (strpos($explodedContents[$i], 'DTM') !== false) {
                                    $DTMDetails3 = array();
                                    $DTMDetails3 = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($DTMDetails3[1])) {
                                        if ($DTMDetails3[1] == '537') {
                                            $orderInfo['DTM537Details']['DTMValue1'] = $DTMDetails3['1'];
                                            $orderInfo['DTM537Details']['estimatedDate'] = $DTMDetails3['2'];
                                            $orderInfo['DTM537Details']['estimatedTime'] = $DTMDetails3['3'];
                                            $orderInfo['DTM537Details']['DTMValue4'] = $DTMDetails3['4'];
                                        }
                                    }
                                }
                                if (strpos($explodedContents[$i], 'HL') !== false) {
                                    $HL6Details = array();
                                    $HL6Details = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($HL6Details[1])) {
                                        if ($HL6Details[1] == 6) {
                                            $orderInfo['HL6Details']['shipmentLevel'] = $HL6Details['1'];
                                            $orderInfo['HL6Details']['shipmentVal1'] = $HL6Details['3'];
                                        }
                                    }
                                }

                                if (strpos($explodedContents[$i], 'SN1') !== false) {
                                    $shipmentDetails = array();
                                    $shipmentDetails = array_filter(explode('*', $explodedContents[$i]));
                                    if (isset($shipmentDetails[2])) {
                                        if ($shipmentDetails[2] == 20) {
                                            $orderInfo['SN1Code1'] = $shipmentDetails['1'];
                                            $orderInfo['SN1Code2'] = $shipmentDetails['2'];
                                            $orderInfo['SN1OrderType'] = $shipmentDetails['3'];
                                        }
                                    }
                                }

                    if(strpos($explodedContents[$i], 'TD1') !== false) {
                      if(isset($explodedContents['56'])) {
                        $TD1Details = array();
                        $TD1Details = array_filter(explode('*', $explodedContents[$i]));
                        $orderInfo['TD1Details']['packageCode'] = isset($TD1Details['1']) ? $TD1Details['1'] : '';
                        $orderInfo['TD1Details']['number'] = isset($TD1Details['2']) ? $TD1Details['2'] : '';
                        $orderInfo['TD1Details']['packageVal'] = isset($TD1Details['6']) ? $TD1Details['6'] : '';
                        $orderInfo['TD1Details']['weight'] = isset($TD1Details['7']) ? $TD1Details['7'] : '';
                        $orderInfo['TD1Details']['unit'] = isset($TD1Details['8']) ? $TD1Details['8'] : '';
                        $orderInfo['TD1Details']['unit'] = isset($TD1Details['9']) ? $TD1Details['9'] : '';
                        $orderInfo['TD1Details']['volumeUnit'] = isset($TD1Details['10']) ? $TD1Details['10'] : '';
                      }
                    }
                    if(strpos($explodedContents[$i], 'HL') !== false) {
                      $HLDetails1 = array();
                      $HLDetails1 = array_filter(explode('*', $explodedContents[$i]));
                      if(isset($HLDetails1[1])){
                        if ($HLDetails1[1] == 8) {
                          $itemInfo['orderHL8']['code1'] = $HLDetails1['1'];
                          $itemInfo['orderHL8']['code2'] = $HLDetails1['2'];
                          $itemInfo['orderHL8']['orderType'] = $HLDetails1['3'];
                        }
                      }
                    }
                    if(strpos($explodedContents[$i], 'LIN') !== false) {
                      $lineDetails = array();
                      $lineDetails = array_filter(explode('*', $explodedContents[$i]));
                      foreach($lineDetails as $lineKey => $lineValues) {
                        if(isset($lineDetails[0])){
                          if($lineDetails[0] == "LIN"){
                            $itemInfo['lineInfo']['lineKey'][$i][] = $lineValues;
                          }
                        }
                      }
                    }

                    if(strpos($explodedContents[$i], 'SN1') !== false) {
                      $snDetails = array();
                      $snDetails = array_filter(explode('*', $explodedContents[$i]));
                      foreach($snDetails as $snKey => $snValues) {
                        if(isset($snDetails[0])){
                          if($snDetails[0] == "SN1"){
                            $itemInfo['lineInfo']['snKey'][$i][] = $snValues;
                          }
                        }
                      }
                    }

                    if(strpos($explodedContents[$i], 'TD1') !== false) {
                      $td1Details1 = array();
                      $td1Details1 = explode('*', $explodedContents[$i]);
                      foreach($td1Details1 as $td1Values) {
                        if(isset($td1Details1[0])){
                          if($td1Details1[0] == "TD1"){
                            if(isset($explodedContents[$i-1])){
                              if(strpos($explodedContents[$i-1], 'HL') === false) {
                                $itemInfo['lineInfo']['td1Key'][$i][] = $td1Values;
                              }
                            }
                          }
                        }
                      }
                    }

                    if(strpos($explodedContents[$i], 'MAN') !== false) {
                      $ManDetails1 = array();
                      $ManDetails1 = array_filter(explode('*', $explodedContents[$i]));
                      foreach($ManDetails1 as $mansKey => $manValues1) {
                        if(isset($ManDetails1[0])){
                          if($ManDetails1[0] == "MAN"){
                            $itemInfo['lineInfo']['manKey'][$i][] = $manValues1;
                            if(isset($explodedContents[$i-1])){
                              if(strpos($explodedContents[$i-1], 'REF') !== false){
                                $lincontainer = explode('*', $explodedContents[$i-1]);
                                if(isset($lincontainer[1])){
                                  if($lincontainer[1] == "CN"){
                                    $itemInfo['lineInfo']['refKey'][] = $lincontainer;
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                    if(strpos($explodedContents[$i], 'DTM') !== false) {
                      $DTMDetails4 = array();
                      $DTMDetails4 = array_filter(explode('*', $explodedContents[$i]));
                      foreach($DTMDetails4 as $DTMDKey => $DTMDkeyValues) {
                        if(isset($DTMDetails4[0])){
                          if($DTMDetails4[0] == "DTM"){
                            $itemInfo['lineInfo']['DTMDKey'][$i][] = $DTMDkeyValues;
                          }
                        }
                      }
                    }
                    if(strpos($explodedContents[$i], 'HL') !== false) {
                      $HLDetails2 = array();
                      $HLDetails2 = array_filter(explode('*', $explodedContents[$i]));
                      foreach($HLDetails2 as $HLDsKey => $HLDVkalues) {
                        if(isset($HLDetails2[0]) && isset($HLDetails2[1])){
                          if($HLDetails2[0] == "HL" && $HLDetails2[1] >=4){
                            $itemInfo['lineInfo']['HLDKey'][$i][] = $HLDVkalues;
                          }
                        }
                      }
                    }
                  }
                }
                $overallinfo[] = array("generalinfo"=>$generalInfo,"shipmentInfo"=>$shipmentInfo,"orderInfo"=>$orderInfo,"itemInfo"=>$itemInfo);
              }
            }
          }
        }
      foreach($overallinfo as $rrp){
        $cgeninfo = $rrp['generalinfo'];
        $cshipinfo = $rrp['shipmentInfo'];
        $cordinfo = $rrp['orderInfo'];
        $citeninfo = $rrp['itemInfo'];
        $resp = $this->saveGeneralInfo($cgeninfo,$cshipinfo,$cordinfo,$citeninfo);
        if(!empty($resp)){
          $order = $this->saveOrderInfo($resp);
          if($order > 0){
              $this->common->updatetbledata(
                  "tb_orders",
                  ['trip_sts' => 0, 'shift_id' => 0, 'trip_id' => 0],
                  ['id' => $order]
              );
            $response = "Success";
          }
        }
      }
      echo $response;
    }

    /**
     * save General Info
     *
     * @param mixed $generalInfo
     * @return void
     */
    public function saveGeneralInfo($generalInfo, $shipmentInfo, $orderInfo, $itemInfo)
    {
        $response = array();
        $company_code = "UKKN";
        $branch_code = "UKLON";
        $response['txnid'] = isset($generalInfo['transactionId']) ? $generalInfo['transactionId'] : "";
        $response['shipid'] = isset($generalInfo['BSNInfo']['shipmentId']) ? $generalInfo['BSNInfo']['shipmentId'] : "";
        $response['txncode'] = isset($generalInfo['ST856Details']['code2']) ? $generalInfo['ST856Details']['code2'] : "";
        $response['trucktype'] = isset($shipmentInfo['shipmentDetails']['vesselNumber']) ? $shipmentInfo['shipmentDetails']['vesselNumber'] : "";
        $response['incoterm'] = isset($shipmentInfo['shipmentDetails']['poRef'][0]) ? $shipmentInfo['shipmentDetails']['poRef'][0] : "";
        $response['delivery_term'] = isset($shipmentInfo['shipmentDetails']['poRef'][1]) ? $shipmentInfo['shipmentDetails']['poRef'][1] : "";
        $response['insertusr'] = isset($generalInfo['ISADetails']['isaValue8']) ? $generalInfo['ISADetails']['isaValue8'] : "";
        $txn_date = isset($generalInfo['ISADetails']['gs4']) ? $generalInfo['ISADetails']['gs4'] : "";
        $txn_time = isset($generalInfo['ISADetails']['gs5']) ? $generalInfo['ISADetails']['gs5'] : "";
        $response['insdate'] = date("Y-m-d", strtotime($txn_date)) . " " . date("H:i:s", strtotime($txn_time));
        $txn_date = isset($generalInfo['BSNInfo']['bsnVal2']) ? $generalInfo['BSNInfo']['bsnVal2'] : "";
        $txn_time = isset($generalInfo['BSNInfo']['bsnVal3']) ? $generalInfo['BSNInfo']['bsnVal3'] : "";
        $response['logdate'] = date("Y-m-d", strtotime($txn_date)) . " " . date("H:i:s", strtotime($txn_time));
        $response['transport_mode'] = "FTL";
        $response['ship_object'] = "SHIPMENT";
        $response['reason'] = "SHIPMENT";
        $response['purpose'] = "SEND INTEGRATION";
        $response['domainname'] = $branch_code;
        $response['sendercmpcode'] = $company_code;
        $response['senderbranchcode'] = $branch_code;
        $response['product'] = "KN EuroDirect";
        $response['freight_term'] = 60;
        $response['freight_termname'] = "Free of Charge";
        $response['modeoftransport'] = 2;
        $response['unitspec'] = isset($itemInfo['lineInfo'][0]['lineKey9']) ? $itemInfo['lineInfo'][0]['lineKey9'] : "";
        $orddetails = array();
        $poorddet = isset($orderInfo['prfOrdDetails']) ? $orderInfo['prfOrdDetails'] : array();
        $orddetails['po_order'] = "";
        $orddetails['po_line'] = "";
        $orddetails['po_date'] = "";
        $orddetails['po_linedate'] = "";
        $poorder = array();
        if (!empty($poorddet)) {
            if (count($poorddet) > 4) {
                $poorder = array_chunk($poorddet, 3);
                $i = 0;
                foreach ($poorder as $po) {
                    if ($i == 0) {
                        $orddetails['po_order'] = $po[1];
                        $orddetails['po_date'] = $po[2];
                    } else {
                        $orddetails['po_line'] = $po[1];
                        $orddetails['po_linedate'] = $po[2];
                    }
                    $i++;
                }
            } else {
                $poorder = $poorddet;
                foreach ($poorder as $po) {
                    $orddetails['po_order'] = $poorder[1];
                    $orddetails['po_date'] = $poorder[2];
                }
            }
        }
        $orddetails['customs_required'] = 1;
        $orddetails['pickup_datefrom'] = isset($shipmentInfo['shipmentDetails']['estimatedDate']) ? $shipmentInfo['shipmentDetails']['estimatedDate'] : "";
        if ($orddetails['pickup_datefrom'] == "") {
            $orddetails['pickup_datefrom'] = date("Y-m-d");
        } else {
            $orddetails['pickup_datefrom'] = date("Y-m-d", strtotime($orddetails['pickup_datefrom']));
        }
        $orddetails['pickup_dateto'] = $orddetails['pickup_datefrom'];

        $orddetails['pickup_datefromtime'] = isset($shipmentInfo['shipmentDetails']['estimatedTime']) ? $shipmentInfo['shipmentDetails']['estimatedTime'] : "";
        if ($orddetails['pickup_datefromtime'] == "") {
            $orddetails['pickup_datefromtime'] = "00:00";
        } else {
            $orddetails['pickup_datefromtime'] = date("H:i", strtotime($orddetails['pickup_datefromtime']));
        }
        $orddetails['pickup_datetotime'] = $orddetails['pickup_datefromtime'];
        $orddetails['drop_datefrom'] = isset($shipmentInfo['shipmentDetails']['DTMDetails']['estimatedDate']) ? $shipmentInfo['shipmentDetails']['DTMDetails']['estimatedDate'] : "";
        if ($orddetails['drop_datefrom'] == "") {
            $orddetails['drop_datefrom'] = date("Y-m-d");
        } else {
            $orddetails['drop_datefrom'] = date("Y-m-d", strtotime($orddetails['drop_datefrom']));
        }
        $orddetails['drop_datefromtime'] = isset($shipmentInfo['shipmentDetails']['DTMDetails']['estimatedTime']) ? $shipmentInfo['shipmentDetails']['DTMDetails']['estimatedTime'] : "";
        if ($orddetails['drop_datefromtime'] == "") {
            $orddetails['drop_datefromtime'] = "00:00";
        } else {
            $orddetails['drop_datefromtime'] = date("H:i", strtotime($orddetails['drop_datefromtime']));
        }
        $orddetails['drop_dateto'] = $orddetails['drop_datefrom'];
        $orddetails['drop_datetotime'] = $orddetails['drop_datefromtime'];
        $orddetails['source'] = $orddetails['destination'] = array();
        $source = isset($shipmentInfo['shipmentDetails']['shipFromAddress']) ? $shipmentInfo['shipmentDetails']['shipFromAddress'] : array();
        if (!empty($source)) {
            $companyname = isset($source['countryName']) ? trim($source['countryName']) : "";
            $cmpcode = isset($source['code']) ? $source['code'] : "";
            $cmpareacode = isset($source['airportCode']) ? $source['airportCode'] : "";
            $address1chk = isset($source['address1']) ? $source['address1'] : array();
            $address1 = $address2 = $city = $state = $postalcode = $country_code = "";
            if (strpos($companyname, "(") !== FALSE) {
                $chkspecialchars = explode("(", $companyname);
                if (isset($chkspecialchars[0])) {
                    $country_code = substr(trim($chkspecialchars[0]), -2);
                }
            }
            if (!empty($address1chk)) {
                unset($address1chk[0]);
                $address1 = implode(",", $address1chk);
            }
            $address2chk = isset($source['address2']) ? $source['address2'] : array();
            if (!empty($address2chk)) {
                unset($address2chk[0]);
                $city = isset($address2chk[1]) ? $address2chk[1] : "";
                $state = isset($address2chk[2]) ? $address2chk[2] : "";
                $postalcode = isset($address2chk[3]) ? $address2chk[3] : "";
                if ($country_code == "") {
                    $sourcecountry_code = isset($address2chk[4]) ? $address2chk[4] : "";
                    if ($sourcecountry_code != "") {
                        $country_code = $sourcecountry_code;
                    }
                }
                $address2 = implode(",", $address2chk);
            }
            $orddetails['source'] = array('companyname' => $companyname, "cmpcode" => $cmpcode, "cmpareacode" => $cmpareacode, "address1" => $address1, "address2" => $address2, "country_code" => $country_code, "state" => $state, "city" => $city, "postalcode" => $postalcode);
        }
        $destination = isset($shipmentInfo['shipmentDetails']['shipToAddress']) ? $shipmentInfo['shipmentDetails']['shipToAddress'] : array();
        if (!empty($destination)) {
            $companyname = isset($destination[1]['countryName']) ? $destination[1]['countryName'] : "";
            $cmpcode = isset($destination[1]['code']) ? $destination[1]['code'] : "";
            $cmpareacode = isset($destination[1]['airportCode']) ? $destination[1]['airportCode'] : "";
            $address1chk = isset($destination['address1']) ? $destination['address1'] : array();
            $address1 = $address2 = $city = $state = $postalcode = $country_code = "";
            if ($companyname == "") {
                $companyname = isset($orddetails['source']['companyname']) ? $orddetails['source']['companyname'] : "";
            }
            if (strpos($companyname, "(") !== FALSE) {
                $chkspecialchars = explode("(", $companyname);
                if (isset($chkspecialchars[0])) {
                    $country_code = substr(trim($chkspecialchars[0]), -2);
                }
            }
            if (!empty($address1chk)) {
                unset($address1chk[0]);
                $address1 = implode(",", $address1chk);
            } else {
                $address1 = $companyname . " , " . $cmpareacode;
            }
            $address2chk = isset($destination['address2']) ? $destination['address2'] : array();
            if (!empty($address2chk)) {
                unset($address2chk[0]);
                $city = isset($address2chk[1]) ? $address2chk[1] : "";
                $state = isset($address2chk[2]) ? $address2chk[2] : "";
                $postalcode = isset($address2chk[3]) ? $address2chk[3] : "";
                if ($country_code == "") {
                    $sourcecountry_code = isset($address2chk[4]) ? $address2chk[4] : "";
                    if ($sourcecountry_code != "") {
                        $country_code = $sourcecountry_code;
                    }
                }
                $address2 = implode(",", $address2chk);
            }
            $orddetails['destination'] = array('companyname' => $companyname, "cmpcode" => $cmpcode, "cmpareacode" => $cmpareacode, "address1" => $address1, "address2" => $address2, "country_code" => $country_code, "state" => $state, "city" => $city, "postalcode" => $postalcode);
        }
        $response['orderinfo'] = $orddetails;
        $response['carrier_code'] = isset($shipmentInfo['shipmentDetails']['carrierinfo'][2]) ? $shipmentInfo['shipmentDetails']['carrierinfo'][2] : "";
        $response['carrier_id'] = isset($shipmentInfo['shipmentDetails']['carrierinfo'][3]) ? $shipmentInfo['shipmentDetails']['carrierinfo'][3] : "";
        $shipments = array();
        $shipments['pkg_code'] = "CTN";
        $shipments['pkg_count'] = 1;
        $shipments['weight'] = 1;
        $shipments['weight_unit'] = 'KG';
        $shipments['volume'] = 0;
        $shipments['volume_unit'] = 'CR';
        $packageinfo = isset($shipmentInfo['shipmentDetails']['packageinfo']) ? $shipmentInfo['shipmentDetails']['packageinfo'] : array();
        if (!empty($packageinfo)) {
            $shipments['pkg_code'] = isset($packageinfo[1]) ? $packageinfo[1] : "";
            $shipments['pkg_count'] = isset($packageinfo[2]) ? $packageinfo[2] : 1;
            $shipments['weight'] = isset($packageinfo[4]) ? $packageinfo[4] : 1;
            $shipments['weight_unit'] = isset($packageinfo[5]) ? $packageinfo[5] : 'KG';
            $shipments['volume'] = isset($packageinfo[6]) ? $packageinfo[6] : 1;
            $shipments['volume_unit'] = isset($packageinfo[7]) ? $packageinfo[7] : 'CR';
        }
        $startroute = $endroute = array();
        $routes = isset($shipmentInfo['shipmentDetails']['routes']) ? $shipmentInfo['shipmentDetails']['routes'] : array();
        if(!empty($routes)){
          if(count($routes)>8){
            $rts = array_chunk($routes, 5);
             $i = 0;
            foreach($rts as $r){
              if($i == 0){
                $startroute = array("polcode"=>$r[1],"uncode"=>$r[2],"unlocation"=>$r[3],"countrycode"=>$r[4]);
              }else{
                $endroute = array("polcode"=>$r[1],"uncode"=>$r[2],"unlocation"=>$r[3],"countrycode"=>$r[4]);
              }
              $i++;
            }
          }else{
            $startroute = array("polcode"=>$routes[1],"uncode"=>$routes[2],"unlocation"=>$routes[3],"countrycode"=>$routes[4]);
          }
        }
        $response['shipmentinfo'] = $shipments;
        $response['start_route'] = $startroute;
        $response['end_route'] = $endroute;
        $response['poldate'] = isset($shipmentInfo['shipmentDetails']['aDC']) ? $shipmentInfo['shipmentDetails']['aDC'] : "";
        $response['poddate'] = isset($shipmentInfo['shipmentDetails']['arrivalInCountry']) ? $shipmentInfo['shipmentDetails']['arrivalInCountry'] : "";
        $response['cargo_line'] = array();
        $lines = array();
        $dtmkeys = $hlkeys = $td1keys = $linekeys = $snkeys = $mankeys = $refkeys = array();
        $DTMDKey = isset($itemInfo['lineInfo']['DTMDKey']) ? $itemInfo['lineInfo']['DTMDKey'] : array();
        if (!empty($DTMDKey)) {
            foreach ($DTMDKey as $dtm) {
                $dtmkeys[] = $dtm;
            }
        }
        $HLDKey = isset($itemInfo['lineInfo']['HLDKey']) ? $itemInfo['lineInfo']['HLDKey'] : array();
        if (!empty($HLDKey)) {
            foreach ($HLDKey as $hl) {
                $hlkeys[] = $hl;
            }
        }
        $td1Key = isset($itemInfo['lineInfo']['td1Key']) ? $itemInfo['lineInfo']['td1Key'] : array();
        if (!empty($td1Key)) {
            foreach ($td1Key as $td) {
                $td1keys[] = $td;
            }
        }
        $lineKey = isset($itemInfo['lineInfo']['lineKey']) ? $itemInfo['lineInfo']['lineKey'] : array();
        if (!empty($lineKey)) {
            foreach ($lineKey as $lk) {
                $linekeys[] = $lk;
            }
        }
        $snKey = isset($itemInfo['lineInfo']['snKey']) ? $itemInfo['lineInfo']['snKey'] : array();
        if (!empty($snKey)) {
            foreach ($snKey as $sn) {
                $snkeys[] = $sn;
            }
        }
        $manKey = isset($itemInfo['lineInfo']['manKey']) ? $itemInfo['lineInfo']['manKey'] : array();
        if (!empty($manKey)) {
            foreach ($manKey as $man) {
                $mankeys[] = $man;
            }
        }

        $refKey = isset($itemInfo['lineInfo']['refKey']) ? $itemInfo['lineInfo']['refKey'] : array();
        if (!empty($refKey)) {
            foreach ($refKey as $rk) {
                $refkeys[] = $rk;
            }
        }
        foreach ($linekeys as $key => $lks) {
            $lineinfo = $lks;
            $snin = $snkeys[$key];
            $tdkey = $td1keys[$key];
            $dtm = isset($dtmkeys[$key]) ? $dtmkeys[$key] : "";
            $hl = $hlkeys[$key];
            $man = isset($mankeys[$key]) ? $mankeys[$key] : "";
            $rk = isset($refkeys[$key]) ? $refkeys[$key] : "";
            $lines[] = array("lineinfo" => $lineinfo, "snin" => $snin, "tdkey" => $tdkey, "dtm" => $dtm, "hl" => $hl, "man" => $man, "ref" => $rk);
        }
        $cargo_line = array();
        $arr = array();
        foreach ($lines as $key => $ln) {
            if (isset($ln["lineinfo"])) {
                $arr['sno'] = isset($ln['lineinfo'][1]) ? $ln['lineinfo'][1] : "";
                $arr['bp_code'] = isset($ln['lineinfo'][2]) ? $ln['lineinfo'][2] : "";
                $arr['bp_num'] = isset($ln['lineinfo'][3]) ? $ln['lineinfo'][3] : "";
                $arr['bp_cnt'] = isset($ln['lineinfo'][4]) ? $ln['lineinfo'][4] : "";
                $arr['bp_num1'] = isset($ln['lineinfo'][5]) ? $ln['lineinfo'][5] : "";
                $arr['comm_code'] = isset($ln['lineinfo'][6]) ? $ln['lineinfo'][6] : "";
                $arr['comm_num'] = isset($ln['lineinfo'][7]) ? $ln['lineinfo'][7] : "";
                $arr['init_code'] = isset($ln['lineinfo'][8]) ? $ln['lineinfo'][8] : "";
                $arr['init_num'] = isset($ln['lineinfo'][9]) ? $ln['lineinfo'][9] : "";
            }
            if (isset($ln["snin"])) {
                $arr['sidentity'] = isset($ln['snin'][1]) ? $ln['snin'][1] : "";
                $arr['num_unit'] = isset($ln['snin'][2]) ? $ln['snin'][2] : "";
                $arr['unit_uom'] = isset($ln['snin'][3]) ? $ln['snin'][3] : "";
            }
            if (isset($ln["tdkey"])) {
                $arr['pkg_code'] = isset($ln['tdkey'][1]) ? $ln['tdkey'][1] : "";
                $arr['qty'] = isset($ln['tdkey'][2]) ? $ln['tdkey'][2] : "";
                $arr['weight_code'] = isset($ln['tdkey'][6]) ? $ln['tdkey'][6] : "";
                $arr['weight'] = isset($ln['tdkey'][7]) ? $ln['tdkey'][7] : "";
                $arr['weight_uom'] = isset($ln['tdkey'][8]) ? $ln['tdkey'][8] : "";
                $arr['volume'] = isset($ln['tdkey'][9]) ? $ln['tdkey'][9] : "";
                $arr['volume_uom'] = isset($ln['tdkey'][10]) ? $ln['tdkey'][10] : "";
            }
            if (isset($ln["dtm"])) {
                $arr['doc_value'] = isset($ln['dtm'][1]) ? $ln['dtm'][1] : "";
                $arr['doc_date'] = isset($ln['dtm'][2]) ? $ln['dtm'][2] : "";
                $arr['doc_time'] = isset($ln['dtm'][3]) ? $ln['dtm'][3] : "";
                $arr['dt_format'] = isset($ln['dtm'][4]) ? $ln['dtm'][4] : "";
            }
            if (isset($ln["hl"])) {
                $arr['line_id'] = isset($ln['hl'][1]) ? $ln['hl'][1] : "";
                $arr['line_num'] = isset($ln['hl'][2]) ? $ln['hl'][2] : "";
                $arr['line_type'] = isset($ln['hl'][3]) ? $ln['hl'][3] : "";
            }
            if (isset($ln["man"])) {
                $arr['man_id'] = isset($ln['man'][1]) ? $ln['man'][1] : "";
                $arr['man_num'] = isset($ln['man'][2]) ? $ln['man'][2] : "";
            }
            $cargo_line[] = $arr;
        }
        $response['cargo_line'] = $cargo_line;
        $response['partyrefs'] = isset($orderInfo['parties']) ? $orderInfo['parties'] : array();
        $response['container'] = isset($orderInfo['container']) ? $orderInfo['container'] : array();
        return $response;
    }

    /**
     * save Amazon Order Data
     *
     * @param mixed $orderInfo
     * @return void
     */
    private function saveOrderInfo($shipdata)
    {
        $result = 0;
        $ca_partytype = 2;
        $curdt = date("Y-m-d H:i:s");
        $company_code = $shipdata['sendercmpcode'];
        $branch_code = $shipdata['senderbranchcode'];
        $department_code = 'OTFI';
        $country_code = substr($company_code, 0, 2);
        $sql = 'SELECT id FROM tb_users WHERE company_code = ? AND branch_code = ? AND status="Active" LIMIT 1';
        $chk = $this->db->query($sql, [$company_code, $branch_code]);
        if ($chk->num_rows() > 0) {
            $user_id = $chk->row()->id;
        } else {
            $sql = 'SELECT user_id FROM tb_user_companies WHERE company_code=? AND branch_code=? AND status=1 LIMIT 1';
            $chk01 = $this->db->query($sql, [$company_code, $branch_code]);
            if ($chk01->num_rows() > 0) {
                $user_id = $chk01->row()->user_id;
            } else {
                $adminrand = "eTN" . $company_code;
                $adminpwd = password_hash($adminrand,PASSWORD_DEFAULT);
                $udata = [
                    'country_code' => $country_code,
                    'name' => $country_code . "_Admin",
                    'company_indv_name' => $company_code,
                    'business_type' => 'Truck_Owner',
                    'mobile_no' => $adminrand,
                    'password' => $adminpwd,
                    'emailid' => 'svkonekt@kuehne-nagel.com',
                    'domain_name' => $branch_code,
                    'location_id' => 1646,
                    'createdby' => 1,
                    'status' => 'Active',
                    'createdon' => $curdt,
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                    "lat" => "40",
                    "lng" => "112"
                ];
                $user_id = $this->common->insertTableData('tb_users', $udata);
            }
        }
        $data['carrier'] = [
            'name' => $shipdata['carrier_id'],
            'street' => $shipdata['orderinfo']['source']['address1'] ?? "",
            'street1' => '',
            'city' => $shipdata['orderinfo']['source']['city'] ?? "",
            'country' => $shipdata['orderinfo']['source']['country_code'] ?? "",
            'zip' => $shipdata['orderinfo']['source']['cmpareacode'] ?? "",
            'custid' => $shipdata['carrier_id'],
            'partyid' => $shipdata['carrier_id']
        ];
        $carrier = $this->checkcarrier($data['carrier'], $shipdata['sendercmpcode'], $shipdata['senderbranchcode'], $user_id);
        $customer_id = 535;
        $shipdata['shipperid'] = $cust_name = "";
        if (isset($shipdata['partyrefs']['SI'])) {
            $shipdata['shipperid'] = $cust_name = $shipdata['partyrefs']['SI'];
        }
        $carrier_id = $carrier['id'];
        if (isset($carrier['party_id'])) {
            $carrier_party_id = $carrier['party_id'];
            $ca_partytype = $carrier['party_type'];
        }
        $shipdata['sourcedate'] = "";
        $curtz = gettimezonebycountrycode($country_code);
        $getactual = getdatetimebytimezone(DFLT_TZ, $shipdata['insdate'], $curtz);
        $shipdata['sourcedate'] = $getactual['datetime'];
        $getactual = getdatetimebytimezone(DFLT_TZ, $shipdata['logdate'], $curtz);
        $shipdata['destinationdate'] = $getactual['datetime'];
        $shipdata['serviceproduct'] = $shipdata['product'];
        $shipdata['pickcount'] = 1;
        $shipdata['dropcount'] = 1;
        $shipdata['logicalreceiver'] = "";
        $shipdata['physicalreceiver'] = "";
        $shipdata['physicalsender'] = "";
        $shipdata['logicalsender'] = "";
        $transmode = $shipdata['transport_mode'];
        $vendorcode = isset($shipdata['orderinfo']['source']['cmpareacode']) ? $shipdata['orderinfo']['source']['cmpareacode'] : "";
        $shipdatains = [
            'shipid' => $shipdata['shipid'],
            'txnid' => $shipdata['txnid'],
            'trucktype' => $shipdata['trucktype'],
            'product' => $shipdata['serviceproduct'],
            'pickupcnt' => $shipdata['pickcount'],
            'dropcnt' => $shipdata['dropcount'],
            'unitspec' => $shipdata['shipmentinfo']['pkg_code'],
            'insertusr' => $shipdata['insertusr'],
            'carrier' => $carrier_id,
            'insertuserdate' => $shipdata['sourcedate'],
            'enddate' => $shipdata['destinationdate'],
            'insdate' => $shipdata['sourcedate'],
            'upddate' => $shipdata['destinationdate'],
            'reason' => $shipdata['reason'],
            'purpose' => $shipdata['purpose'],
            'ship_object' => $shipdata['ship_object'],
            'logdate' => $shipdata['logdate'],
            'status' => 1,
            'createdon' => $curdt,
            'transport_mode' => $transmode,
            'txncode' => $shipdata['txncode'],
            'domainname' => $shipdata['senderbranchcode'],
            'company_code' => $shipdata['sendercmpcode'],
            'branch_code' => $shipdata['senderbranchcode'],
            'freight_term' => $shipdata['freight_term'],
            'freight_termname' => $shipdata['freight_termname'],
            'incoterm' => $shipdata['incoterm'],
            'logicalreceiver' => $shipdata['logicalreceiver'],
            'physicalreceiver' => $shipdata['physicalreceiver'],
            'physicalsender' => $shipdata['physicalsender'],
            'logicalsender' => $shipdata['logicalsender'],
            'modeoftransport' => $shipdata['modeoftransport'],
            'vendorcode' => $vendorcode
        ];
        $sship_id = $this->common->insertTableData('tb_shipments', $shipdatains);
        $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
        $starttime = $endtime = "";
        if (isset($shipdata['orderinfo'])) {
            $starttime = $shipdata['orderinfo']['pickup_datefromtime'];
            $pickup_datetime = $shipdata['orderinfo']['pickup_datefrom'] . " " . $shipdata['orderinfo']['pickup_datefromtime'];
            $pickup_datetime = date('Y-m-d H:i:s', strtotime($pickup_datetime));
            $srccountry = $shipdata['orderinfo']['source']['country_code'] ?? "";
            $curtzs = gettimezonebycountrycode($srccountry);
            $getactual = getdatetimebytimezone(DFLT_TZ, $pickup_datetime, $curtzs);
            $pickup_datetime = $getactual['datetime'];
            $pickup_endtime = $shipdata['orderinfo']['pickup_dateto'] . " " . $shipdata['orderinfo']['pickup_datetotime'];
            $pickup_endtime = date('Y-m-d H:i:s', strtotime($pickup_endtime));
            $getactual = getdatetimebytimezone(DFLT_TZ, $pickup_endtime, $curtzs);
            $pickup_endtime = $getactual['datetime'];
            $pickup_company = $shipdata['orderinfo']['source']['companyname'] ?? "";
            $pickup_address = $shipdata['orderinfo']['source']['address1'] ?? "";
            $pickup_state = $shipdata['orderinfo']['source']['state'] ?? "";
            $pickup_city = $shipdata['orderinfo']['source']['city'] ?? "";
            $pickup_countrycode = $srccountry ?? "";
            $pickup_postal = $shipdata['orderinfo']['source']['postalcode'] ?? "";
            $pickup_address1 = $shipdata['orderinfo']['source']['address2'] ?? "";
            $pickup_custid = $shipdata['shipperid'];
            $pickup_partyid = $shipdata['shipperid'];
            $endtime = $shipdata['orderinfo']['drop_datefromtime'];
            $delivery_datetime = $shipdata['orderinfo']['drop_datefrom'] . " " . $shipdata['orderinfo']['drop_datefromtime'];
            $delivery_datetime = date('Y-m-d H:i:s', strtotime($delivery_datetime));
            $destcountry = $shipdata['orderinfo']['destination']['country_code'] ?? "";
            $curtzs = gettimezonebycountrycode($destcountry);
            $getactual = getdatetimebytimezone(DFLT_TZ, $delivery_datetime, $curtzs);
            $delivery_datetime = $getactual['datetime'];
            $drop_endtime = $shipdata['orderinfo']['drop_dateto'] . " " . $shipdata['orderinfo']['drop_datetotime'];
            $drop_endtime = date('Y-m-d H:i:s', strtotime($drop_endtime));
            $getactual = getdatetimebytimezone(DFLT_TZ, $drop_endtime, $curtzs);
            $drop_endtime = $getactual['datetime'];
            $drop_company = $shipdata['orderinfo']['destination']['companyname'] ?? "";
            $drop_address = $shipdata['orderinfo']['destination']['address1'] ?? "";
            $drop_state = $shipdata['orderinfo']['destination']['state'] ?? "";
            $drop_city = $shipdata['orderinfo']['destination']['city'] ?? "";
            $drop_countrycode = $destcountry;
            $drop_postal = $shipdata['orderinfo']['destination']['postalcode'] ?? "";
            $drop_address1 = $shipdata['orderinfo']['destination']['address2'] ?? "";
            $drop_custid = $shipdata['shipperid'];
            $drop_partyid = $shipdata['shipperid'];
            $shipdata['pkgs_count'] = $shipdata['shipmentinfo']['pkg_count'];
            $shipdata['gross_weight'] = $shipdata['shipmentinfo']['weight'];
            $shipdata['volume'] = $shipdata['shipmentinfo']['volume'];
            $shipdata['goods_value'] = $dedicateveh = 0;
            $pickup_area = $pickup_address . ", " . $pickup_state . ", " . $pickup_city . ", " . $pickup_postal;
            $drop_area = $drop_address . ", " . $drop_state . ", " . $drop_city . ", " . $drop_postal;
            /*create shipper n create consignee*/
            $chktype = $this->common->gettblrowdata(['name' => 'Shipper', 'user_id' => $user_id], "id", "tbl_party_types", 1, 0);
            if (count($chktype) > 0) {
                $sparty_id = $chktype['id'];
            } else {
                $party = [
                    'name' => 'Shipper',
                    'description' => 'Shipper',
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                    'created_on' => $curdt,
                    'user_id' => $user_id
                ];
                $sparty_id = $this->common->insertTableData("tbl_party_types", $party);
            }
            $master = [
                'party_type_id' => $sparty_id,
                'name' => $pickup_company,
                'street' => $pickup_address,
                'state' => $pickup_state,
                'pincode' => $pickup_postal,
                'country' => $pickup_countrycode,
                'user_id' => $user_id,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => '1',
                'address' => $pickup_area,
                'location_id' => $pickup_city
            ];
            $checkshipper = $this->common->gettblrowdata($master, "id", "tbl_party_master", 1, 0);
            if (count($checkshipper) > 0) {
                $shipper_id = $checkshipper['id'];
            } else {
                $shipper_id = $this->common->insertTableData("tbl_party_master", $master);
                $year = date('y');
                $week = date('W');
                $shipper_code = $country_code . $year . $week . $shipper_id;
                $upd = $this->common->updatetbledata("tbl_party_master",
                    [
                        'code' => $shipper_code,
                        'mobile' => $shipper_code,
                        'customeridentifier' => $shipper_code
                    ], ['id' => $shipper_id]
                );
            }
            $chktype = $this->common->gettblrowdata(['name' => 'Consignee', 'user_id' => $user_id], "id", "tbl_party_types", 1, 0);
            if (count($chktype) > 0) {
                $cparty_id = $chktype['id'];
            } else {
                $party = [
                    'name' => 'Consignee',
                    'description' => 'Consignee',
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                    'created_on' => $curdt,
                    'user_id' => $user_id
                ];
                $cparty_id = $this->common->insertTableData("tbl_party_types", $party);
            }
            $master = [
                'party_type_id' => $cparty_id,
                'name' => $drop_company,
                'street' => $drop_address,
                'state' => $drop_state,
                'pincode' => $drop_postal,
                'country' => $drop_countrycode,
                'user_id' => $user_id,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => '1',
                'address' => $drop_area,
                'location_id' => $drop_city
            ];
            $checkconsignee = $this->common->gettblrowdata($master, "id", "tbl_party_master", 1, 0);
            if (count($checkconsignee) > 0) {
                $consignee_id = $checkconsignee['id'];
            } else {
                $consignee_id = $this->common->insertTableData("tbl_party_master", $master);
                $year = date('y');
                $week = date('W');
                $consignee_code = $country_code . $year . $week . $consignee_id;
                $upd = $this->common->updatetbledata("tbl_party_master", ['code' => $consignee_code, 'mobile' => $consignee_code, 'customeridentifier' => $consignee_code], ['id' => $consignee_id]);
            }
            /*orders table */
            /*check existed container*/
            $container_num = $extqty = $extweight = $extvolume = 0;
            if (count($shipdata['container']) > 0) {
                $chkref = $this->common->getordcontainernum(["o.parent_id" => 0, "r.reference_id" => "CTR", "r.ref_value" => trim($shipdata['container'][0])]);
                 if (count($chkref)) {
                    $container_num = $chkref['id'];
                }
            }
            if ($container_num == 0) {
                $opkgcount = count($shipdata['cargo_line']);
                $orddata = [
                    'pickup_datetime' => $pickup_datetime,
                    'pickup_endtime' => $pickup_endtime,
                    'delivery_datetime' => $delivery_datetime,
                    'drop_endtime' => $drop_endtime,
                    'pickup_company' => $pickup_company,
                    'delivery_company' => $drop_company,
                    'pickup_country' => $pickup_countrycode,
                    'delivery_country' => $drop_countrycode,
                    'pickup_city' => $pickup_city,
                    'delivery_city' => $drop_city,
                    'pickup_pincode' => $pickup_postal,
                    'delivery_pincode' => $drop_postal,
                    'pickup_address1' => $pickup_address,
                    'delivery_address1' => $drop_address,
                    'pickup_address2' => $pickup_address1,
                    'delivery_address2' => $drop_address1,
                    'quantity' => $opkgcount,
                    'weight' => $shipdata['gross_weight'],
                    'volume' => $shipdata['volume'],
                    'goods_value' => $shipdata['goods_value'],
                    'transport_mode' => $transmode,
                    'dedicated_vehicle' => $dedicateveh,
                    'vehicle_type' => $shipdata['trucktype'],
                    'user_id' => $user_id,
                    'customer_id' => $customer_id,
                    'vendor_id' => $carrier_id,
                    'customer_name' => $cust_name,
                    'customer_code' => $cust_name,
                    'vendor_code' => $shipdata['carrier_id'],
                    'company_code' => $shipdata['sendercmpcode'],
                    'branch_code' => $shipdata['senderbranchcode'],
                    'product' => $shipdata['serviceproduct'],
                    'shipment_id' => $sship_id,
                    'pickup_custid' => $pickup_custid,
                    'pickup_partyid' => $pickup_partyid,
                    'drop_custid' => $drop_custid,
                    'drop_partyid' => $drop_partyid,
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt,
                    "created_source" => 13,
                    'logicalreceiver' => $shipdata['logicalreceiver'],
                    'physicalreceiver' => $shipdata['physicalreceiver'],
                    'physicalsender' => $shipdata['physicalsender'],
                    'logicalsender' => $shipdata['logicalsender'],
                    'modeoftransport' => $shipdata['modeoftransport']
                ];
                $ord_id = $this->common->insertTableData('tb_orders', $orddata);
                if ($ord_id > 0) {
                    $genord = ["user_id" => $user_id, "order_id" => $ord_id, "country_code" => $country_code, "company_code" => $company_code];
                    $booking_id = generatebookingid($genord);
                    $shipdata['orderid'] = $booking_id;
                    $upd = $this->common->updatetbledata("tb_orders", ["order_id" => $booking_id], ["id" => $ord_id]);
                    /* insert into order parties */
                    $order_ins = [
                        'party_id' => $shipper_id,
                        'order_id' => $ord_id,
                        'createdon' => $curdt,
                        'status' => '1',
                        'party_type' => $sparty_id,
                        'order_number' => $booking_id
                    ];
                    $ins = $this->common->insertTableData("tb_order_parties", $order_ins);
                    $order_ins = [
                        'party_id' => $consignee_id,
                        'order_id' => $ord_id,
                        'createdon' => $curdt,
                        'status' => '1',
                        'party_type' => $cparty_id,
                        'order_number' => $booking_id
                    ];
                    $ins = $this->common->insertTableData("tb_order_parties", $order_ins);
                    /*order types*/
                    $getordertype = $this->common->gettblrowdata(['type_name' => 'Normal', 'company_code' => $company_code], "id", "tb_order_types", 0, 0);
                    if (count($getordertype) > 0) {
                        $order_type = $getordertype['id'];
                    } else {
                        $getorders = [
                            'type_name' => 'Normal',
                            'description' => 'Normal',
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'department_code' => $department_code,
                            'customer_id' => $customer_id,
                            'ordtype_code' => 'N',
                            'status' => 1,
                            'createdon' => $curdt
                        ];
                        $order_type = $this->common->insertTableData("tb_order_types", $getorders);
                    }
                    $order_details = [
                        'order_row_id' => $ord_id,
                        'order_id' => $shipdata['orderid'],
                        'order_status' => 'Pending',
                        'order_type' => $order_type,
                        'shipper_id' => $shipper_id,
                        'delivery_term' => $shipdata['delivery_term'],
                        "incoterm" => $shipdata['incoterm'],
                        "delivery_note" => $shipdata['shipid'],
                        "purchase_order" => $shipdata['orderinfo']['po_order'],
                        "department_code" => $department_code,
                        "status" => 1,
                        "createdon" => $curdt
                    ];
                    $ins = $this->common->insertTableData("tb_order_details", $order_details);
                    $ttansmode = $shipdata['transport_mode'];
                    $transmode = "FTL";
                    $dedicateveh = 1;
                    /*cargo details*/
                    $qty = 0;
                    $wet = 0;
                    $vol = 0;
                    if (count($shipdata['cargo_line']) > 0) {
                        foreach ($shipdata['cargo_line'] as $cl) {
                            $gethandling_unit = $this->common->gettblrowdata(["unit_name" => $cl['pkg_code']], "id", "tbl_shipunit_types", 0, 0);
                            if (count($gethandling_unit) > 0) {
                                $handling_unit = $gethandling_unit['id'];
                            } else {
                                $handlingunit_ar = [
                                    'unit_name' => $cl['pkg_code'],
                                    'description' => $cl['comm_num'],
                                    'user_id' => $user_id,
                                    'created_at' => $curdt,
                                    'status' => '1'
                                ];
                                $handling_unit = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                            }
                            $qty += $cl['qty'];
                            $wet += $cl['weight'];
                            $vol += $cl['volume'];
                            $carr = [
                                'cargo_type' => $cl['pkg_code'],
                                'handlingunit_id' => $handling_unit,
                                'goods_description' => $cl['comm_num'],
                                'quantity' => $cl['qty'],
                                'length' => 1,
                                'length_unit' => 'M',
                                'width' => 1,
                                'width_unit' => 'M',
                                'height' => 1,
                                'height_unit' => 'M',
                                'weight' => $cl['weight'],
                                'weight_unit' => $cl['weight_uom'],
                                'volume' => $cl['volume'],
                                'volume_unit' => $cl['volume_uom'],
                                'stackable' => 0,
                                'grounded' => 0,
                                'splittable' => 0,
                                'createdby' => $user_id,
                                'volumetric_weight' => 1,
                                'volweight_uom' => 'M',
                                'createdon' => $curdt
                            ];
                            $cargo_id = $this->common->insertTableData("tb_cargo_details", $carr);
                            $ordcargo = [
                                'order_id' => $ord_id,
                                'cargo_id' => $cargo_id,
                                'handling_unit' => $handling_unit,
                                'status' => '1',
                                'createdon' => $curdt,
                                'length' => 1,
                                'width' => 1,
                                'height' => 1,
                                'weight' => $cl['weight'],
                                'volume' => $cl['volume'],
                                'quantity' => $cl['qty'],
                                'cargo_content' => $cl['comm_num'],
                                'volumetric_weight' => 1,
                                'volweight_uom' => 'M',
                                'buyer_part' => $cl['bp_num'],
                                'qr_code' => $cl['man_num'],
                                'linebp_num1' => $cl['bp_num1'],
                                'linecontainer_no' => $cl['init_num']
                            ];
                            $ordcargo_id = $this->common->insertTableData("tb_order_cargodetails", $ordcargo);
                        }
                    }
                    $upd = $this->common->updatetbledata("tb_orders", ["quantity" => $qty, 'weight' => $wet, 'volume' => $vol], ["id" => $ord_id]);
                    /*party ref*/
                    $arr = [
                        'order_id' => $ord_id,
                        'reference_id' => 'DQ',
                        'ref_value' => $shipdata['shipid'],
                        'createdon' => $curdt
                    ];
                    $dqref = $this->common->insertTableData('tb_order_references', $arr);
                    if (isset($shipdata['start_route']['unlocation'])) {
                        $arr = [
                            'order_id' => $ord_id,
                            'reference_id' => 'POL',
                            'ref_value' => $shipdata['start_route']['unlocation'],
                            'createdon' => $curdt
                        ];
                        $polref = $this->common->insertTableData('tb_order_references', $arr);
                    }
                    if (isset($shipdata['end_route']['unlocation'])) {
                        $arr = ['order_id' => $ord_id, 'reference_id' => 'POD', 'ref_value' => $shipdata['end_route']['unlocation'], 'createdon' => $curdt];
                        $podref = $this->common->insertTableData('tb_order_references', $arr);
                    }
                    if (isset($shipdata['poldate'])) {
                        $arr = ['order_id' => $ord_id, 'reference_id' => 'POL Date', 'ref_value' => $shipdata['poldate'], 'createdon' => $curdt];
                        $podref = $this->common->insertTableData('tb_order_references', $arr);
                    }
                    if (isset($shipdata['poddate'])) {
                        $arr = ['order_id' => $ord_id, 'reference_id' => 'POD Date', 'ref_value' => $shipdata['poddate'], 'createdon' => $curdt];
                        $podref = $this->common->insertTableData('tb_order_references', $arr);
                    }
                    if (count($shipdata['partyrefs']) > 0) {
                        foreach ($shipdata['partyrefs'] as $key => $ref) {
                            if ($key == "ZZ") {
                                $chkserv = $this->common->gettblrowdata(["name" => $ref], "id", "tb_service_master", 0, 0);
                                if (count($chkserv) > 0) {
                                    $service = $chkserv['id'];
                                } else {
                                    $arr = [
                                        'company_code' => $company_code,
                                        'branch_code' => $branch_code,
                                        'user_id' => $user_id,
                                        'service_id' => 'ZZ',
                                        'name' => $ref,
                                        'createdon' => $curdt
                                    ];
                                    $service = $this->common->insertTableData('tb_service_master', $arr);
                                }
                                $upd = $this->common->updatetbledata("tb_order_details", ["service" => $service], ["order_row_id" => $ord_id]);
                            } else {
                                if ($key == "CN") {
                                    $key = "CTR";
                                }
                                $ord_refs = $this->common->gettblrowdata([
                                    "order_id" => $ord_id,
                                    "reference_id" => $key,
                                    "ref_value" => $ref
                                ], "id", "tb_order_references", 0, 0);
                                if (count($ord_refs) == 0) {
                                    $ref_ar = ["order_id" => $ord_id, "reference_id" => $key, "ref_value" => $ref, 'createdon' => $curdt, 'status' => 1];
                                    $refins = $this->common->insertTableData("tb_order_references", $ref_ar);
                                }
                            }
                        }
                    }
                    $result = $ord_id;
                }
            } else {
                $ord_id = $container_num;
                if (count($shipdata['cargo_line']) > 0) {
                    $qty = $wet = $vol = 0;
                    if (isset($chkref)) {
                        if (count($chkref)) {
                            $qty = $chkref['quantity'];
                            $wet = $chkref['weight'];
                            $vol = $chkref['volume'];
                        }
                    }
                    foreach ($shipdata['cargo_line'] as $cl) {
                        $gethandling_unit = $this->common->gettblrowdata(["unit_name" => $cl['pkg_code']], "id", "tbl_shipunit_types", 0, 0);
                        if (count($gethandling_unit) > 0) {
                            $handling_unit = $gethandling_unit['id'];
                        } else {
                            $handlingunit_ar = [
                                'unit_name' => $cl['pkg_code'],
                                'description' => $cl['comm_num'],
                                'user_id' => $user_id,
                                'created_at' => $curdt,
                                'status' => '1'
                            ];
                            $handling_unit = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                        }
                        $qty += $cl['qty'];
                        $wet += $cl['weight'];
                        $vol += $cl['volume'];
                        $carr = [
                            'cargo_type' => $cl['pkg_code'],
                            'handlingunit_id' => $handling_unit,
                            'goods_description' => $cl['comm_num'],
                            'quantity' => $cl['qty'],
                            'length' => 1,
                            'length_unit' => 'M',
                            'width' => 1,
                            'width_unit' => 'M',
                            'height' => 1,
                            'height_unit' => 'M',
                            'weight' => $cl['weight'],
                            'weight_unit' => $cl['weight_uom'],
                            'volume' => $cl['volume'],
                            'volume_unit' => $cl['volume_uom'],
                            'stackable' => 0,
                            'grounded' => 0,
                            'splittable' => 0,
                            'createdby' => $user_id,
                            'volumetric_weight' => 1,
                            'volweight_uom' => 'M',
                            'createdon' => $curdt
                        ];
                        $cargo_id = $this->common->insertTableData("tb_cargo_details", $carr);
                        $ordcargo = [
                            'order_id' => $ord_id,
                            'cargo_id' => $cargo_id,
                            'handling_unit' => $handling_unit,
                            'status' => '1',
                            'createdon' => $curdt,
                            'length' => 1,
                            'width' => 1,
                            'height' => 1,
                            'weight' => $cl['weight'],
                            'volume' => $cl['volume'],
                            'quantity' => $cl['qty'],
                            'cargo_content' => $cl['comm_num'],
                            'volumetric_weight' => 1,
                            'volweight_uom' => 'M',
                            'buyer_part' => $cl['bp_num'],
                            'qr_code' => $cl['man_num'],
                            'linebp_num1' => $cl['bp_num1'],
                            'linecontainer_no' => $cl['init_num']
                        ];
                        $ordcargo_id = $this->common->insertTableData("tb_order_cargodetails", $ordcargo);
                    }
                    $extqty += $qty;
                    $extweight += $wet;
                    $extvolume += $vol;
                    $upd = $this->common->updatetbledata("tb_orders", ["quantity" => $extqty, 'weight' => $extweight, 'volume' => $extvolume], ["id" => $ord_id]);
                }
                $result = $ord_id;
            }
        }
        return $result;
    }

    public function checkcarrier($customer, $cmpcode, $branchcode, $uid)
    {
        $res = array();
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cwhr1['party_type_id'] = 2;
        $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", ["name" => "Carrier", "user_id" => $uid, 'company_code' => $cmpcode], 1, 0);
        if ($chkpartytype->num_rows() > 0) {
            $cwhr1['party_type_id'] = $chkpartytype->row()->id;
        }
        if (isset($customer['custid'])) {
            $cwhr = ['name' => $customer['name'], "code" => $customer['custid']];
            $ctable = 'tb_vendors';
            $cselect = 'id';
            $chkcust = $this->common->gettblrowdata($cwhr, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $cust_id = $chkcust['id'];
                $addr = $customer['street'] . ", " . $customer['street1'] . ", " . $customer['city'] . ", " . $customer['country'] . ", " . $customer['zip'];
                $upddata = [
                    'location' => $customer['city'],
                    'address' => $addr,
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'effective_date' => date('Y-m-d'),
                    'expiry_date' => date('Y-m-d'),
                    'service_id' => $customer['custid'],
                    'service_name' => $customer['partyid'],
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status ' => 1,
                    'updated_on' => $curdt
                ];
                $upd = $this->db->where(["id" => $cust_id])->update('tb_vendors', $upddata);
            } else {
                $randnum = trim($customer['custid']);
                $randnum = str_replace(" ", "", $randnum);
                $randnum = str_replace("+", "", $randnum);
                $randnum = str_replace("-", "", $randnum);
                $pwd = password_hash($randnum,PASSWORD_DEFAULT);
                $addr = $customer['street'] . ", " . $customer['street1'] . ", " . $customer['city'] . ", " . $customer['country'] . ", " . $customer['zip'];
                $cinsdata = [
                    'name' => $customer['name'],
                    'mobile' => $customer['custid'],
                    'location' => $customer['city'],
                    'address' => $addr,
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'password' => $pwd, 'email' => '',
                    'code' => $customer['custid'],
                    'offering_type' => 'FTL',
                    'carrier_grade' => 'ABC',
                    'effective_date' => date('Y-m-d'),
                    'expiry_date' => date('Y-m-d'),
                    'service_id' => $customer['custid'],
                    'service_name' => $customer['partyid'],
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                ];
                $cust_id = $this->common->insertTableData('tb_vendors', $cinsdata);
            }
            $chkcust = $this->common->gettblrowdata($cwhr, $cselect, "tbl_party_master", 0, 0);
            if (count($chkcust) > 0) {
                $custid = $chkcust['id'];
                $upddata = [
                    'location_id' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'user_id' => $uid,
                    'customeridentifier' => $customer['custid'],
                    'partyindetifier' => $customer['partyid'],
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'updated_on' => $curdt
                ];
                $upd = $this->db->where(["id" => $custid])->update('tbl_party_master', $upddata);
            } else {
                $randnum = trim($customer['custid']);
                $randnum = str_replace(" ", "", $randnum);
                $randnum = str_replace("+", "", $randnum);
                $randnum = str_replace("-", "", $randnum);
                $pwd = password_hash($randnum,PASSWORD_DEFAULT);
                $cinsdata = [
                    'party_type_id' => $cwhr1['party_type_id'],
                    'name' => $customer['name'],
                    'email' => 'svkonekt@kuehne-nagel.com',
                    'mobile' => $customer['custid'],
                    'location_id' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'code' => $customer['custid'],
                    'country' => $customer['country'],
                    'user_id' => $uid,
                    'customeridentifier' => $customer['custid'],
                    'partyindetifier' => $customer['partyid'],
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                ];
                $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
            }
        } else {
            $randnum = time();
            $pwd = password_hash($randnum,PASSWORD_DEFAULT);
            if (strlen($cmpcode) > 2) {
                $cntry = substr($cmpcode, 0, 2);
            } else {
                $cntry = $cmpcode;
            }
            $addr = $cntry;
            $effctdate = date('Y-m-d');
            $cinsdata = [
                'name' => $cntry . "_Carrier",
                'mobile' => $randnum,
                'location' => $cntry,
                'address' => $addr,
                'pincode' => $addr,
                'country' => $cntry,
                'password' => $pwd,
                'email' => '',
                'code' => $randnum,
                'offering_type' => 'FTL',
                'carrier_grade' => 'ABC',
                'effective_date' => $effctdate,
                'expiry_date' => $effctdate,
                'service_id' => $randnum,
                'service_name' => "",
                'user_id' => $uid,
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            ];
            $cust_id = $this->common->insertTableData('tb_vendors', $cinsdata);
            $cinsdata = [
                'party_type_id' => $cwhr1['party_type_id'],
                'name' => $cntry . "_Carrier",
                'email' => 'svkonekt@kuehne-nagel.com',
                'mobile' => $randnum,
                'location_id' => $cntry,
                'address' => $addr,
                'pincode' => '1111',
                'code' => $randnum,
                'country' => $cntry,
                'user_id' => $uid,
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            ];
            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $cwhr1['party_type_id'];
        return $res;
    }
}
