<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Order\Models\OrderReference;
use App\Models\OrderList\Search\Properties;
use App\Models\OrderList\Search\AdvancedSearch;
use App\Models\OrderList\Search\Search;

class Amzorders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        if ($this->session->userdata('company_code') != "UKKN") {
            redirect('home');
        }
        $this->load->library('form_validation');
        $this->load->library('Ratemanagement');
        $this->load->model('Order');
        $this->load->model('common');
        $this->load->library(["email", "statusintigration", "svkonektquote", "Standard_status_execution","Altovaordercreation"]);
    }

    public function index($id = NULL)
    {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        if ($id != "") {
            $this->orderslist($id);
        } else {
            $this->orderslist();
        }
    }

    public function orderslist($id = NULL)
    {

        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        $properties = new Properties($this->db);
        $role_id = $this->session->userdata('user_role_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");

        $data['page_title'] = $this->lang->line('order_list');
        $data['sub_title'] = $this->lang->line('menu_orders');

        $order = [];
        $whr = [];
        $post = [];
        $subcusts = [];
        $conditions = [];

        if ($id != "") {
            $post['bookingid'] = [];
            $getbooking_id = $this->common->gettblrowdata(['id' => $id], "order_id", "tb_orders", 0, 0);

            if (!empty($getbooking_id)) {
                $post['bookingid'] = [$getbooking_id['order_id']];
            }

            $data['getbookingid'] = $post['bookingid'];
        }

        $searchInitialized = filter_input(INPUT_POST, "searchsubmit", FILTER_SANITIZE_STRING);

        if ($searchInitialized !== null) {
            $post = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);

            if (isset($post['searchcustomer_id'])) {
                $search = new AdvancedSearch($this->db, $post);
                $conditions = $search->buildWhereClause($this->input, $role_id, $userid);
            } else {
                $search = new Search($this->db, $post);
            }

            $field = $properties->getDateFieldName($post);
            $search->fromDate($field, $whr);
            $search->toDate($field, $whr);

            $whr = array_merge($whr, $conditions);

            $order_status = isset($post['status']) ? $post['status'] : "";
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";

            $status_search = $order_status;

            if ($status_search == "") {
                $status_search = $ad_orderstatus;
            }

            $searchids = isset($post['bookingid']) ? $post['bookingid'] : [];

            if ($role_id == "4" && $subcusts && !empty($subcusts)) {
                array_push($subcusts, $custid);
            }

            if (isset($post['container_no']) && $post['container_no'] != "") {
                $containerNumber = $post['container_no'];
                $sql = 'SELECT o.order_id FROM tb_orders o,tb_order_references r
                WHERE o.id=r.order_id AND r.ref_value=? AND o.status!=0 AND r.status=1 AND r.reference_id="CTR"';
                $getcontainer_no = $this->db->query($sql, [$containerNumber]);
                if ($getcontainer_no->num_rows() > 0) {
                    foreach ($getcontainer_no->result_array() as $res) {
                        array_push($searchids, $res['order_id']);
                    }
                }
            }

            if (isset($post['order_id']) && !empty($post['order_id'])) {
                $searchids = [$post['order_id']];
            }

            $orderdata = $this->Order->getamzorderdata($userid, $searchids, $status_search, $custid, $country_userids, $whr, $subcusts);

            foreach ($orderdata as $res) {
                $trip_no = $res['shipmentid'] == '0' ? "" : $res['shipmentid'];
                $created_source = $res['created_source'];

                $order_status = $properties->getStatusName($res);
                $otherstatus = $properties->getOtherStatus($res);
                $referenceData = $properties->getReferences($res);
                $invoiceArray = $properties->getInvoices($res);
                $html = $invoiceArray['html'] ?? "";
                $chkdate = '2020-07-01 00:00:00';
                $createdon = isset($res['createdon']) ? $res['createdon'] : '0000-00-00';
                $order_str = strtotime($createdon);
                $chk_str = strtotime($chkdate);
                $early_pickup = $res['pickup_datetime'];
                $early_delivery = $res['delivery_datetime'];

                if ($order_str > $chk_str) {
                    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                        $early_pickup = $epickup['datetime'];
                    }

                    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                        $early_delivery = $edelivery['datetime'];
                    }
                }
                $orderUpdatedDate = getdatetimebytimezone($curtz, $res['updatedon'], DFLT_TZ);
                $updatedDate = $orderUpdatedDate['datetime'];
                $order[] = [
                    'order_row_id' => $res['id'],
                    'order_id' => $res['order_id'],
                    'delivery_note' => $referenceData['delivery_note'],
                    'pickup' => $res['pickup'],
                    'delivery' => $res['delivery'],
                    'trip_no' => $trip_no,
                    'order_status' => $order_status,
                    'transport_mode' => $res['transport_mode'],
                    'createdon' => $createdon,
                    'total_packages' => round($res['totqty']),
                    'weight' => $res['totwg'],
                    'volume' => $res['totvol'],
                    'company_code' => $res['company_code'],
                    'branch_code' => $res['branch_code'],
                    'otherstatus' => $otherstatus,
                    'delivery_date' => $early_delivery,
                    'pickup_date' => $early_pickup,
                    'html' => $html,
                    'manifestdoc' => '',
                    'container_no' => $referenceData['container_no'],
                    "parent_id" => $res['parent_id'],
                    'created_source' => $created_source,
                    'updatedDate' => $updatedDate
                ];
            }
        }

        $data['company_code'] = $company_code;

        $ordertypes = array();

        if ($custid != "") {
            $getpickupdetails = $this->Order->getpickupdetails($custid);

            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = [
                    'id' => $getpickupdetails->row()->id,
                    'name' => $getpickupdetails->row()->name,
                    'party_id' => $getpickupdetails->row()->code,
                    'address' => $getpickupdetails->row()->address,
                    'pincode' => $getpickupdetails->row()->pincode,
                    'country' => $getpickupdetails->row()->country
                ];
            }

            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['customer_id' => $custid, 'company_code' => $company_code, 'status' => '1']);

            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, "status" => '1']);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                    }
                } else {
                    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => '1']);
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                        }
                    }
                }
            }
        } else {
            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, "status" => '1']);
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => '1']);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                    }
                }
            }
        }
        $data['order'] = $order;
        $data['bill_type'] = "svkonekt";
        $getbilltype = $this->db->select("bill_type")->get_where("tb_branch_master", ['branch_code' => $branch_code, 'company_code' => $company_code]);

        if ($getbilltype->num_rows() > 0) {
            $data['bill_type'] = $getbilltype->row()->bill_type;
        }

        $data['ordertypes'] = $ordertypes;

        $data['user_currency'] = $this->session->userdata("usr_tzone")['currency'];
        $res = $this->common->gettbldata(['status' => '1'], "currency", "tbl_country_master", 0, 0);
        if (!empty($res)) {
            foreach ($res as $result) {
                $data['currencies'][] = $result['currency'];
            }
        }

        $this->newtemplate->dashboard("amzorders/order", $data);
    }

    public function checkpurchaseordervalue()
    {
        $p_order = $this->input->post('purchase_order');
        $chkorder = $this->db->select('id')->get_where("tb_order_details", ['purchase_order' => $p_order]);
        if ($chkorder->num_rows() > 0) {
            echo '1';
        } else {
            echo '0';
        }
    }

    public function findcountrybyname()
    {
        $name = $this->input->post('name');
        $result = [];
        $chkqry = $this->db->select('id,company_name,company_code,description')->get_where("tb_company_master", ['company_code' => $name]);
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
                $result[] = [
                    'check' => $check,
                    'company_code' => $res->company_code,
                    'company_name' => $res->company_name,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function findbranchbyname()
    {
        $name = $this->input->post('name');
        $result = [];
        $chkqry = $this->db->select('id,branch_name,company_code,description,branch_code')->get_where("tb_branch_master", ['branch_code' => $name]);
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
                $result[] = [
                    'check' => $check,
                    'branch_code' => $res->branch_code,
                    'branch_name' => $res->branch_name,
                    'company_code' => $res->company_code,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function viewcompanylist()
    {
        $result = [];
        $check = "";
        $popup = isset($_POST['popup']) ? $_POST['popup'] : "";
        $popup = $popup;
        $chkqry = $this->db->select("id,company_name,company_code,description")->get_where("tb_company_master", ['status' => 1]);
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                if ($popup == 'popup') {
                    $check = "<input type='radio' name='listpopupcompany' id='listpopupcompany_" . $res->id . "' class='listpopupcompany' onchange='selectpopupcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
                } else {
                    $check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
                }
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'company_code' => $res->company_code,
                    'company_name' => $res->company_name,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function getcompanyname()
    {
        $post = $this->input->post();
        $term = $post['term'];
        $result = [];
        $check = "";
        $popup = isset($_POST['popup']) ? $_POST['popup'] : "";
        $this->db->select("id,company_code,company_name,description");
        $this->db->from("tb_company_master");
        $this->db->like('company_code', $term);
        $this->db->order_by('createdon', 'DESC');
        $getcompanyname = $this->db->get();
        if ($getcompanyname->num_rows() > 0) {
            foreach ($getcompanyname->result() as $res) {
                if ($popup == 'popup') {
                    $check = "<input type='radio' name='listpopupcompany' id='listpopupcompany_" . $res->id . "' class='listpopupcompany' onchange='selectpopupcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
                } else {
                    $check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
                }
                $result[] = [
                    'check' => $check,
                    'company_code' => $res->company_code,
                    'company_name' => $res->company_name,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function addcompanydetails()
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $ins_ar = [
            'company_name' => $post['company_name'],
            'company_code' => $post['company_code'],
            'description' => $post['description'],
            'status' => 1,
            'createdon' => $cdate
        ];
        $chkqry = $this->db->select('id')->get_where("tb_company_master", ['company_name' => $post['company_name'], 'company_code' => $post['company_code']]);
        if ($chkqry->num_rows() > 0) {
            echo json_encode(2);
        } else {
            $ins = $this->db->insert('tb_company_master', $ins_ar);
            if ($ins) {
                echo json_encode(1);
            } else {
                echo json_encode(0);
            }
        }
    }

    public function adddepartmentdetails()
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $ins_ar = [
            'department_name' => $post['department_name'],
            'department_code' => $post['department_code'],
            'company_code' => $post['company_code'],
            'branch_code' => $post['branch_code'],
            'description' => $post['description'],
            'status' => 1,
            'createdon' => $cdate
        ];
        $chkqry = $this->db->select('id')->get_where("tb_department_master",
            [
                'department_code' => $post['department_code'],
                'department_name' => $post['department_name'],
                'company_code' => $post['company_code'],
                'branch_code' => $post['branch_code']
            ]
        );
        if ($chkqry->num_rows() > 0) {
            echo json_encode(2);
        } else {
            $ins = $this->db->insert('tb_department_master', $ins_ar);
            if ($ins) {
                echo json_encode(1);
            } else {
                echo json_encode(0);
            }
        }
    }

    public function getbranchbycompany()
    {
        $cmp_id = $this->input->post('cmp_code');
        $id = $this->input->post('term');
        $result = [];
        $this->db->select('id,branch_code');
        $this->db->from('tb_branch_master');
        $this->db->like('company_code', $cmp_id);
        $this->db->like('branch_code', $id);
        $qry = $this->db->get();
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $result[] = ['id' => $res->id, 'branch_code' => $res->branch_code];
            }
        }
        echo json_encode($result);
    }

    public function getbranchbyname()
    {
        $cmp_id = $this->input->post('name');
        $result = [];
        $this->db->select('id,branch_code,branch_name,company_code,description');
        $this->db->from('tb_branch_master');
        $this->db->like('branch_code', $cmp_id);
        $qry = $this->db->get();
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'branch_code' => $res->branch_code,
                    'branch_name' => $res->branch_name,
                    'company_code' => $res->company_code,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function viewbranchlist()
    {
        $result = array();
        $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : "";
        $check = "";
        $popup = isset($_POST['popup']) ? $_POST['popup'] : "";
        $where = array('status' => 1);
        if ($company_code != "") {
            $where['company_code'] = $company_code;
        }
        $this->db->select('id,branch_code,branch_name,company_code,description');
        $this->db->from('tb_branch_master');
        $this->db->where($where);
        $qry = $this->db->get();
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                if ($popup == 'popup') {
                    $check = "<input type='radio' name='listpopupbranch' id='listpopupbranch_" . $res->id . "' class='listpopupbranch' onchange='selectpopupbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
                } else {
                    $check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
                }
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'branch_code' => $res->branch_code,
                    'branch_name' => $res->branch_name,
                    'company_code' => $res->company_code,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function addbranchdetails()
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $ins_ar = [
            'branch_name' => $post['branch_name'],
            'branch_code' => $post['branch_code'],
            'company_code' => $post['company_code'],
            'description' => $post['description'],
            'status' => 1,
            'createdon' => $cdate
        ];
        $chkqry = $this->db->select("id")->get_where("tb_branch_master", ['branch_code' => $post['branch_code'], 'branch_name' => $post['branch_name']]);
        if ($chkqry->num_rows() > 0) {
            echo json_encode(2);
        } else {
            $ins = $this->db->insert("tb_branch_master", $ins_ar);
            if ($ins) {
                echo json_encode(1);
            } else {
                echo json_encode(0);
            }
        }
    }

    public function getdepartmentbybranch()
    {
        $cmp_id = $this->input->post('branch_code');
        $id = $this->input->post('term');
        $result = [];
        $qry = $this->db->select("id,department_code");
        $this->db->from("tb_department_master");
        $this->db->where(['branch_code' => $cmp_id]);
        $this->db->like('department_code', $id);
        $qry = $this->db->get();
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $result[] = ['id' => $res->id, 'department_code' => $res->department_code];
            }
        }
        echo json_encode($result);
    }

    public function finddepartmentlist()
    {
        $name = $this->input->post('name');
        $result = [];
        $qry = $this->db->select("id,department_code,department_name,company_code,branch_code,description")->get_where("tb_department_master", ['department_code' => $name]);
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $check = "<input type='radio' name='listdepartment' id='listdepartment_" . $res->id . "' class='listdepartment' onchange='selectdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'department_code' => $res->department_code,
                    'department_name' => $res->department_name,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function finddepartmentlikelist()
    {
        $name = $this->input->post('name');
        $result = array();
        $qry = $this->db->select("id,department_code,department_name,company_code,branch_code,description")->get_where("tb_department_master", ['department_code' => $name]);
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $check = "<input type='radio' name='listdepartment' id='listdepartment_" . $res->id . "' class='listdepartment' onchange='selectdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'department_code' => $res->department_code,
                    'department_name' => $res->department_name,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function viewdepartmentlist()
    {
        $result = [];
        $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : "";
        $branch_code = isset($_POST['branch_code']) ? $_POST['branch_code'] : "";
        $popup = isset($_POST['popup']) ? $_POST['popup'] : "";
        $whr = ['status' => 1];
        if ($company_code != "") {
            $whr['company_code'] = $company_code;
        }
        if ($branch_code != "") {
            $whr['branch_code'] = $branch_code;
        }
        $this->db->select("id,department_code,department_name,company_code,branch_code,description");
        $this->db->from("tb_department_master");
        $this->db->where($whr);
        $qry = $this->db->get();
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                if ($popup == 'popup') {
                    $check = "<input type='radio' name='listpopupdepartment' id='listpopupdepartment_" . $res->id . "' class='listpopupdepartment' onchange='selectpopupdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
                } else {
                    $check = "<input type='radio' name='listdepartment' id='listdepartment_" . $res->id . "' class='listdepartment' onchange='selectdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
                }
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'department_code' => $res->department_code,
                    'department_name' => $res->department_name,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($result);
    }

    public function checkcompanycode()
    {
        $companys = [];
        $c_code = isset($_POST['data']) ? $_POST['data'] : "";
        if (!empty($c_code)) {
            $this->db->select('company_code');
            $this->db->from("tb_company_master");
            $this->db->where_in('company_code', $c_code);
            $chk = $this->db->get();
            if ($chk->num_rows() > 0) {
                foreach ($chk->result() as $res) {
                    $companys[] = $res->company_code;
                }
            }
        }
        $diff_companys = [];
        if (!empty($companys)) {
            $diff_companys = array_diff($c_code, $companys);
        }
        echo json_encode($diff_companys);
    }

    public function neworder()
    {

        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data = $transport = [];
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if ($company_code == 'RUKN') {
            $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        } else {
            $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", ['status' => 1]);
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        }
        $data['transport'] = $transport;
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $pickup_details = [];
        $custid = $this->session->userdata('cust_id');
        $ordertypes = [];
        if ($custid != "") {
            $getpickupdetails = $this->Order->getpickupdetails($custid);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = [
                    'id' => $getpickupdetails->row()->id,
                    'name' => $getpickupdetails->row()->name,
                    'party_id' => $getpickupdetails->row()->code,
                    'address' => $getpickupdetails->row()->address,
                    'pincode' => $getpickupdetails->row()->pincode,
                    'country' => $getpickupdetails->row()->country
                ];
            }
            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['customer_id' => $custid, 'company_code' => $company_code, 'status' => '1']);
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, "status" => '1']);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                    }
                } else {
                    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => '1']);
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                        }
                    }
                }
            }
        } else {
            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, "status" => '1']);
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => '1']);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                    }
                }
            }
        }
        $roles = [];
        $sql = 'SELECT id,name FROM tbl_party_types WHERE user_id= ? AND status=1 GROUP BY name';
        $qyery = $this->db->query($sql, [$user_id]);
        if ($qyery->num_rows() > 0) {
            foreach ($qyery->result() as $res) {
                $roles[] = ['id' => $res->id, 'name' => $res->name];
            }
        }
        $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", ['status' => '1']);
        if ($getchargecodes->num_rows() > 0) {
            foreach ($getchargecodes->result() as $res) {
                $chargecodes[] = ['charge_id' => $res->id, 'charge_code' => $res->charge_code];
            }
        }
        $data['chargecodes'] = $chargecodes;
        $data['pickup_details'] = $pickup_details;
        $data['ordertypes'] = $ordertypes;
        $data['roles'] = $roles;
        $this->newtemplate->dashboard('amzorders/neworder', $data);
    }

    public function getdeliverytermvalue()
    {
        $incoterm = $this->input->post('incoterm');
        $terms = [];
        $terms = getDeliverytermsbyIncoterm($incoterm);
        echo json_encode($terms);
    }

    public function copyorder($id = NULL)
    {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data = $order_types = [];
        $order_details = $shipper_details = $drop_details = $pickup_details = $delivery_array = $chargecodes = array();
        $order_details['type_name'] = $order_details['ordtype_code'] = "";
        if ($id != "") {
            $chkorder = $this->Order->getordertoedit($id);
            if ($chkorder->num_rows() > 0) {
                $incoterm = $chkorder->row()->incoterm;
                $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
                $sql = 'SELECT reference_id,ref_value FROM tb_order_references WHERE order_id =? AND reference_id IN ("DQ","ORD_DLVINST","ORD_PIKINST","CTR")';
                $getdnote = $this->db->query($sql, [$id]);
                if ($getdnote->num_rows() > 0) {
                    foreach ($getdnote->result() as $ref) {
                        $ref_id = $ref->reference_id;
                        if ($ref_id == 'DQ') {
                            $shipment_id = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_DLVINST') {
                            $delivery_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_PIKINST') {
                            $pickup_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'CTR') {
                            $container_no = $ref->ref_value;
                        }
                    }
                }
                $pickup_custid = $chkorder->row()->pickup_custid;
                $status = $chkorder->row()->status;
                $trip_id = $chkorder->row()->trip_id;
                $trip_sts = $chkorder->row()->trip_sts;
                $order_status = "PENDING";
                /*if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }*/
                $chkdate = '2020-07-01 00:00:00';
                $createdon = $chkorder->row()->createdon;
                $order_str = strtotime($createdon);
                $chk_str = strtotime($chkdate);
                $early_pickup = $chkorder->row()->pickup_datetime;
                $early_delivery = $chkorder->row()->delivery_datetime;
                $late_pickup = $chkorder->row()->pickup_endtime;
                $late_delivery = $chkorder->row()->drop_endtime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                if ($order_str > $chk_str) {
                    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                        $early_pickup = $epickup['datetime'];
                    }
                    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                        $early_delivery = $edelivery['datetime'];
                    }
                    if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
                        $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
                        $late_pickup = $lpickup['datetime'];
                    }
                    if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
                        $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                        $late_delivery = $ldelivery['datetime'];
                    }
                }
                $order_details = [
                    'id' => $chkorder->row()->id,
                    'order_id' => $chkorder->row()->order_id,
                    'shipment_id' => $shipment_id,
                    'early_pickup' => $early_pickup,
                    'early_delivery' => $early_delivery,
                    'late_pickup' => $late_pickup,
                    'late_delivery' => $late_delivery,
                    'product' => $chkorder->row()->product,
                    'service' => $chkorder->row()->service,
                    'delivery_term' => $chkorder->row()->delivery_term,
                    'incoterm' => $chkorder->row()->incoterm,
                    'delivery_note' => $chkorder->row()->delivery_note,
                    'purchase_order' => $chkorder->row()->purchase_order,
                    'notify_party' => $chkorder->row()->notify_party,
                    'goods_value' => $chkorder->row()->goods_value,
                    'lane_reference' => $chkorder->row()->lane_reference,
                    'distance' => $chkorder->row()->distance,
                    'customs_required' => $chkorder->row()->customs_required,
                    'high_cargo_value' => $chkorder->row()->high_cargo_value,
                    'valorance_insurance' => $chkorder->row()->valorance_insurance,
                    'temperature_control' => $chkorder->row()->temperature_control,
                    'company_code' => $chkorder->row()->company_code,
                    'branch_code' => $chkorder->row()->branch_code,
                    'department_code' => $chkorder->row()->department_code,
                    'createdon' => $chkorder->row()->createdon,
                    'order_type' => $chkorder->row()->order_type,
                    'transport_mode' => $chkorder->row()->transport_mode,
                    'pickup_inst' => $pickup_inst,
                    'delivery_inst' => $delivery_inst,
                    'container_no' => $container_no
                ];
                $order_details['order_status'] = $order_status;
                if ($incoterm != '') {
                    $delivery_array = getDeliverytermsbyIncoterm($incoterm);
                }
                $pickup_id = $chkorder->row()->customer_id;
                $company_code = $this->session->userdata('company_code');
                if ($company_code != "") {
                    $company_code = $chkorder->row()->company_code;
                }
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['customer_id' => $pickup_id, 'company_code' => $company_code, 'status' => '1']);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $order_types[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                    }
                } else {
                    $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, 'status' => 1]);
                    if ($getorder_types->num_rows() > 0) {
                        foreach ($getorder_types->result() as $res) {
                            $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                        }
                    } else {
                        $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => 1]);
                        if ($getorders->num_rows() > 0) {
                            foreach ($getorders->result() as $res) {
                                $order_types[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                            }
                        }
                    }
                }
                $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
                if ($getpickupdetails->num_rows() > 0) {
                    $pickup_details = [
                        'id' => $getpickupdetails->row()->id,
                        'name' => $getpickupdetails->row()->name,
                        'party_id' => $getpickupdetails->row()->code,
                        'address' => $getpickupdetails->row()->address,
                        'pincode' => $getpickupdetails->row()->pincode,
                        'country' => $getpickupdetails->row()->country
                    ];
                }
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $party_row_ids = [];
                $sql = 'SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p
                INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
                $chekparty = $this->db->query($sql, [$id]);
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = [
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = [
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            } else {
                                $party_row_ids[] = $rr->id;
                            }
                        }
                    }
                }
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;
                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
                $drop_id = $chkorder->row()->drop_custid;
            }
            $user_id = $this->session->userdata('user_id');
            $roles = [];
            $sql = 'SELECT id,name FROM tbl_party_types WHERE user_id= ? AND status=1 GROUP BY name';
            $qyery = $this->db->query($sql, [$user_id]);
            if ($qyery->num_rows() > 0) {
                foreach ($qyery->result() as $res) {
                    $roles[] = ['id' => $res->id, 'name' => $res->name];
                }
            }
            $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", ['status' => '1']);
            if ($getchargecodes->num_rows() > 0) {
                foreach ($getchargecodes->result() as $res) {
                    $chargecodes[] = ['charge_id' => $res->id, 'charge_code' => $res->charge_code];
                }
            }
            $cdate = date('Y-m-d H:i:s');
            $cargo_row_ids = [];
            $sql = 'SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE
            o.order_id =? AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC';
            $qry = $this->db->query($sql, [$id]);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $cargo_ins = [
                        'cargo_type' => $res->cargo_type,
                        'goods_description' => $res->goods_description,
                        'quantity' => $res->quantity,
                        'length' => $res->length,
                        'length_unit' => $res->length_unit,
                        'width' => $res->width,
                        'width_unit' => $res->width_unit,
                        'height' => $res->height,
                        'height_unit' => $res->height_unit,
                        'weight' => $res->weight,
                        'weight_unit' => $res->weight_unit,
                        'volume' => $res->volume,
                        'volume_unit' => $res->volume_unit,
                        'stackable' => $res->stackable,
                        'grounded' => $res->grounded,
                        'splittable' => $res->splittable,
                        'createdby' => $user_id,
                        'volumetric_weight' => $res->volumetric_weight,
                        'volweight_uom' => $res->volweight_uom,
                        'createdon' => $cdate,
                        'ldm' => $res->ldm
                    ];
                    $ins_cargo = $this->db->insert("tb_cargo_details", $cargo_ins);
                    $cargo_row_ids[] = $this->db->insert_id();
                    /*   array_push($ids,$cargo_row_id);*/
                }
            }
        }
        $transport = [];
        if ($company_code == 'RUKN') {
            $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        } else {
            $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", ['status' => 1]);
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        }
        $cargo_id = "";
        if (!empty($cargo_row_ids)) {
            $cargo_id = implode("','", $cargo_row_ids);
        }
        $party_id = "";
        if (!empty($party_row_ids)) {
            $party_id = implode(',', $party_row_ids);
        }
        $order_details['cargo_id'] = $cargo_id;
        $order_details['party_id'] = $party_id;
        $data['transport'] = $transport;
        $data['order_details'] = $order_details;
        $data['pickup_details'] = $pickup_details;
        $data['drop_details'] = $drop_details;
        $data['shipper_details'] = $shipper_details;
        $data['order_types'] = $order_types;
        $data['delivery_array'] = $delivery_array;
        $data['chargecodes'] = $chargecodes;
        $data['roles'] = $roles;
        $this->newtemplate->dashboard('amzorders/copyorder', $data);
    }

    public function reverseorder($id = NULL)
    {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data = $order_types = [];
        $order_details = $shipper_details = $drop_details = $pickup_details = $delivery_array = $chargecodes = array();
        $order_details['type_name'] = $order_details['ordtype_code'] = "";
        if ($id != "") {
            $chkorder = $this->Order->getordertoedit($id);
            if ($chkorder->num_rows() > 0) {
                $incoterm = $chkorder->row()->incoterm;
                $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
                $sql = 'SELECT reference_id,ref_value FROM tb_order_references WHERE order_id =? AND reference_id IN ("DQ","ORD_DLVINST","ORD_PIKINST","CTR")';
                $getdnote = $this->db->query($sql, [$id]);
                if ($getdnote->num_rows() > 0) {
                    foreach ($getdnote->result() as $ref) {
                        $ref_id = $ref->reference_id;
                        if ($ref_id == 'DQ') {
                            $shipment_id = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_DLVINST') {
                            $delivery_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_PIKINST') {
                            $pickup_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'CTR') {
                            $container_no = $ref->ref_value;
                        }
                    }
                }
                $pickup_custid = $chkorder->row()->pickup_custid;
                $status = $chkorder->row()->status;
                $trip_id = $chkorder->row()->trip_id;
                $trip_sts = $chkorder->row()->trip_sts;
                $order_status = "PENDING";
                /*if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }*/
                $chkdate = '2020-07-01 00:00:00';
                $createdon = $chkorder->row()->createdon;
                $order_str = strtotime($createdon);
                $chk_str = strtotime($chkdate);
                $early_pickup = $chkorder->row()->pickup_datetime;
                $early_delivery = $chkorder->row()->delivery_datetime;
                $late_pickup = $chkorder->row()->pickup_endtime;
                $late_delivery = $chkorder->row()->drop_endtime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                if ($order_str > $chk_str) {
                    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                        $early_pickup = $epickup['datetime'];
                    }
                    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                        $early_delivery = $edelivery['datetime'];
                    }
                    if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
                        $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
                        $late_pickup = $lpickup['datetime'];
                    }
                    if ($late_delivery != "" && $late_delivery !== "0000-00-00 00:00:00") {
                        $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                        $late_delivery = $ldelivery['datetime'];
                    }
                }
                $order_details = [
                    'id' => $chkorder->row()->id,
                    'order_id' => $chkorder->row()->order_id,
                    'shipment_id' => $shipment_id,
                    'early_pickup' => $early_pickup,
                    'early_delivery' => $early_delivery,
                    'late_pickup' => $late_pickup,
                    'late_delivery' => $late_delivery,
                    'product' => $chkorder->row()->product,
                    'service' => $chkorder->row()->service,
                    'delivery_term' => $chkorder->row()->delivery_term,
                    'incoterm' => $chkorder->row()->incoterm,
                    'delivery_note' => $chkorder->row()->delivery_note,
                    'purchase_order' => $chkorder->row()->purchase_order,
                    'notify_party' => $chkorder->row()->notify_party,
                    'goods_value' => $chkorder->row()->goods_value,
                    'lane_reference' => $chkorder->row()->lane_reference,
                    'distance' => $chkorder->row()->distance,
                    'customs_required' => $chkorder->row()->customs_required,
                    'high_cargo_value' => $chkorder->row()->high_cargo_value,
                    'valorance_insurance' => $chkorder->row()->valorance_insurance,
                    'temperature_control' => $chkorder->row()->temperature_control,
                    'company_code' => $chkorder->row()->company_code,
                    'branch_code' => $chkorder->row()->branch_code,
                    'department_code' => $chkorder->row()->department_code,
                    'createdon' => $chkorder->row()->createdon,
                    'order_type' => $chkorder->row()->order_type,
                    'transport_mode' => $chkorder->row()->transport_mode,
                    'pickup_inst' => $pickup_inst,
                    'delivery_inst' => $delivery_inst,
                    'container_no' => $container_no
                ];
                $order_details['order_status'] = $order_status;
                if ($incoterm != '') {
                    $delivery_array = getDeliverytermsbyIncoterm($incoterm);
                }
                $pickup_id = $chkorder->row()->customer_id;
                $company_code = $this->session->userdata('company_code');
                if ($company_code != "") {
                    $company_code = $chkorder->row()->company_code;
                }
                $getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", ['company_code' => $company_code, 'status' => 1]);
                if ($getorder_types->num_rows() > 0) {
                    foreach ($getorder_types->result() as $res) {
                        $order_types[] = ['type_name' => $res->type_name, 'type_id' => $res->id];
                    }
                }
                $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
                if ($getpickupdetails->num_rows() > 0) {
                    $pickup_details = [
                        'id' => $getpickupdetails->row()->id,
                        'name' => $getpickupdetails->row()->name,
                        'party_id' => $getpickupdetails->row()->code,
                        'address' => $getpickupdetails->row()->address,
                        'pincode' => $getpickupdetails->row()->pincode,
                        'country' => $getpickupdetails->row()->country
                    ];
                }
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $party_row_ids = [];
                $sql = 'SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p
                    INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1
                    WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
                $chekparty = $this->db->query($sql, [$id]);
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $shipper_details = [
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            } else if ($chktype->row()->name == "Shipper") {
                                $drop_details = [
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            } else {
                                $party_row_ids[] = $rr->id;
                            }
                        }
                    }
                }
                $drop_details['name'] = $chkorder->row()->pickup;
                $drop_details['street'] = $chkorder->row()->pickup_address1;
                $drop_details['state'] = $chkorder->row()->pickup_address2;
                $drop_details['city'] = $chkorder->row()->pickup_city;
                $drop_details['country'] = $chkorder->row()->pickup_country;
                $drop_details['pincode'] = $chkorder->row()->pickup_pincode;
                $shipper_details['name'] = $chkorder->row()->delivery;
                $shipper_details['street'] = $chkorder->row()->delivery_address1;
                $shipper_details['state'] = $chkorder->row()->delivery_address2;
                $shipper_details['city'] = $chkorder->row()->delivery_city;
                $shipper_details['country'] = $chkorder->row()->delivery_country;
                $shipper_details['pincode'] = $chkorder->row()->delivery_pincode;
                $drop_id = $chkorder->row()->drop_custid;
            }
            $user_id = $this->session->userdata('user_id');
            $roles = [];
            $sql = 'SELECT id,name FROM tbl_party_types WHERE user_id= ? AND status=1 GROUP BY name';
            $qyery = $this->db->query($sql, [$user_id]);
            if ($qyery->num_rows() > 0) {
                foreach ($qyery->result() as $res) {
                    $roles[] = ['id' => $res->id, 'name' => $res->name];
                }
            }
            $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", ['status' => '1']);
            if ($getchargecodes->num_rows() > 0) {
                foreach ($getchargecodes->result() as $res) {
                    $chargecodes[] = ['charge_id' => $res->id, 'charge_code' => $res->charge_code];
                }
            }
            $cdate = date('Y-m-d H:i:s');
            $cargo_row_ids = [];
            $sql = 'SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o
            WHERE o.order_id =? AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC';
            $qry = $this->db->query($sql, [$id]);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $cargo_ins = [
                        'cargo_type' => $res->cargo_type,
                        'goods_description' => $res->goods_description,
                        'quantity' => $res->quantity,
                        'length' => $res->length,
                        'length_unit' => $res->length_unit,
                        'width' => $res->width,
                        'width_unit' => $res->width_unit,
                        'height' => $res->height,
                        'height_unit' => $res->height_unit,
                        'weight' => $res->weight,
                        'weight_unit' => $res->weight_unit,
                        'volume' => $res->volume,
                        'volume_unit' => $res->volume_unit,
                        'stackable' => $res->stackable,
                        'grounded' => $res->grounded,
                        'splittable' => $res->splittable,
                        'volumetric_weight' => $res->volumetric_weight,
                        'volweight_uom' => $res->volweight_uom,
                        'createdby' => $user_id,
                        'createdon' => $cdate,
                        'ldm' => $res->ldm
                    ];
                    $ins_cargo = $this->db->insert("tb_cargo_details", $cargo_ins);
                    $cargo_row_ids[] = $this->db->insert_id();
                    /*   array_push($ids,$cargo_row_id);*/
                }
            }
        }
        $transport = [];
        if ($company_code == 'RUKN') {
            $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        } else {
            $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", ['status' => 1]);
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        }
        $cargo_id = "";
        if (!empty($cargo_row_ids)) {
            $cargo_id = implode(',', $cargo_row_ids);
        }
        $party_id = "";
        if (!empty($party_row_ids)) {
            $party_id = implode(',', $party_row_ids);
        }
        $order_details['cargo_id'] = $cargo_id;
        $order_details['party_id'] = $party_id;
        $data['transport'] = $transport;
        $data['order_details'] = $order_details;
        $data['pickup_details'] = $pickup_details;
        $data['drop_details'] = $drop_details;
        $data['shipper_details'] = $shipper_details;
        $data['order_types'] = $order_types;
        $data['delivery_array'] = $delivery_array;
        $data['chargecodes'] = $chargecodes;
        $data['roles'] = $roles;
        $this->newtemplate->dashboard('amzorders/copyorder', $data);
    }

    public function editorder($id = NULL)
    {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data = $order_types = [];
        $order_details = $shipper_details = $drop_details = $pickup_details = $delivery_array = $chargecodes = [];
        $order_details['type_name'] = $order_details['ordtype_code'] = "";
        if ($id != "") {
            $chkorder = $this->Order->getordertoedit($id);
            if ($chkorder->num_rows() > 0) {
                $incoterm = $chkorder->row()->incoterm;
                $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
                $sql = 'SELECT reference_id,ref_value FROM tb_order_references
                WHERE order_id =? AND reference_id IN ("DQ","ORD_DLVINST","ORD_PIKINST","CTR")';
                $getdnote = $this->db->query($sql, [$id]);
                if ($getdnote->num_rows() > 0) {
                    foreach ($getdnote->result() as $ref) {
                        $ref_id = $ref->reference_id;
                        if ($ref_id == 'DQ') {
                            $shipment_id = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_DLVINST') {
                            $delivery_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_PIKINST') {
                            $pickup_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'CTR') {
                            $container_no = $ref->ref_value;
                        }
                    }
                }
                $pickup_custid = $chkorder->row()->pickup_custid;
                $status = $chkorder->row()->status;
                $trip_id = $chkorder->row()->trip_id;
                $trip_sts = $chkorder->row()->trip_sts;
                $order_status = "PENDING";
                if ($trip_id != 0 && $trip_sts == 0) {
                    $order_status = 'ACTIVE';
                }
                if ($trip_id != 0 && $trip_sts == 1) {
                    $order_status = 'CLOSED';
                }
                $chkdate = '2020-07-01 00:00:00';
                $createdon = $chkorder->row()->createdon;
                $order_str = strtotime($createdon);
                $chk_str = strtotime($chkdate);
                $early_pickup = $chkorder->row()->pickup_datetime;
                $early_delivery = $chkorder->row()->delivery_datetime;
                $late_pickup = $chkorder->row()->pickup_endtime;
                $late_delivery = $chkorder->row()->drop_endtime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                if ($order_str > $chk_str) {
                    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                        $early_pickup = $epickup['datetime'];
                    }
                    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                        $early_delivery = $edelivery['datetime'];
                    }
                    if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
                        $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
                        $late_pickup = $lpickup['datetime'];
                    }
                    if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
                        $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                        $late_delivery = $ldelivery['datetime'];
                    }
                }
                $order_details = [
                    'id' => $chkorder->row()->id,
                    'order_id' => $chkorder->row()->order_id,
                    'shipment_id' => $shipment_id,
                    'early_pickup' => $early_pickup,
                    'early_delivery' => $early_delivery,
                    'late_pickup' => $late_pickup,
                    'late_delivery' => $late_delivery,
                    'product' => $chkorder->row()->product,
                    'service' => $chkorder->row()->service,
                    'delivery_term' => $chkorder->row()->delivery_term,
                    'incoterm' => $chkorder->row()->incoterm,
                    'delivery_note' => $chkorder->row()->delivery_note,
                    'purchase_order' => $chkorder->row()->purchase_order,
                    'notify_party' => $chkorder->row()->notify_party,
                    'goods_value' => $chkorder->row()->goods_value,
                    'lane_reference' => $chkorder->row()->lane_reference,
                    'distance' => $chkorder->row()->distance,
                    'customs_required' => $chkorder->row()->customs_required,
                    'high_cargo_value' => $chkorder->row()->high_cargo_value,
                    'valorance_insurance' => $chkorder->row()->valorance_insurance,
                    'temperature_control' => $chkorder->row()->temperature_control,
                    'company_code' => $chkorder->row()->company_code,
                    'branch_code' => $chkorder->row()->branch_code,
                    'department_code' => $chkorder->row()->department_code,
                    'createdon' => $chkorder->row()->createdon,
                    'order_type' => $chkorder->row()->order_type,
                    'transport_mode' => $chkorder->row()->transport_mode,
                    'pickup_inst' => $pickup_inst,
                    'delivery_inst' => $delivery_inst,
                    'container_no' => $container_no
                ];
                $order_details['order_status'] = $order_status;
                if ($incoterm != '') {
                    $delivery_array = getDeliverytermsbyIncoterm($incoterm);
                }
                $pickup_id = $chkorder->row()->customer_id;
                $vendor_id = $chkorder->row()->vendor_id;
                $user_id = $this->session->userdata('user_id');
                $pickup_location = [
                    'country' => $chkorder->row()->pickup_country,
                    'zipcode' => $chkorder->row()->pickup_pincode,
                    'user_id' => $user_id
                ];
                $delivery_location = [
                    'country' => $chkorder->row()->delivery_country,
                    'zipcode' => $chkorder->row()->delivery_pincode,
                    'user_id' => $user_id
                ];
                $info = ['order_id' => $id, 'product' => $chkorder->row()->product];
                $data['rates'] = $this->ratemanagement->getcustomerprofiledetailsbyid($pickup_id, $chkorder->row()->service, $pickup_location, $delivery_location, $info);
                $data['vendor_rates'] = $this->ratemanagement->getvendorprofiledetailsbyid($vendor_id, $chkorder->row()->service, $info);
                $company_code = $this->session->userdata('company_code');
                if ($company_code != "") {
                    $company_code = $chkorder->row()->company_code;
                }
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['customer_id' => $pickup_id, 'company_code' => $company_code, 'status' => '1']);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $order_types[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                    }
                } else {
                    $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, 'status' => 1]);
                    if ($getorder_types->num_rows() > 0) {
                        foreach ($getorder_types->result() as $res) {
                            $order_types[] = ['type_name' => $res->type_name, 'type_id' => $res->id];
                        }
                    } else {
                        $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => 1]);
                        if ($getorders->num_rows() > 0) {
                            foreach ($getorders->result() as $res) {
                                $order_types[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                            }
                        }
                    }
                }
                $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
                if ($getpickupdetails->num_rows() > 0) {
                    $pickup_details = [
                        'id' => $getpickupdetails->row()->id,
                        'name' => $getpickupdetails->row()->name,
                        'party_id' => $getpickupdetails->row()->code,
                        'address' => $getpickupdetails->row()->address,
                        'pincode' => $getpickupdetails->row()->pincode,
                        'country' => $getpickupdetails->row()->country
                    ];
                }
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $sql = 'SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p
                INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
                $chekparty = $this->db->query($sql, [$id]);
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = [
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = [
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            }
                        }
                    }
                }
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;
                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
                $drop_id = $chkorder->row()->drop_custid;
            }
            $roles = [];
            $sql = 'SELECT id,name FROM tbl_party_types WHERE user_id= ? AND status=1 GROUP BY name';
            $qyery = $this->db->query($sql, [$user_id]);
            if ($qyery->num_rows() > 0) {
                foreach ($qyery->result() as $res) {
                    $roles[] = ['id' => $res->id, 'name' => $res->name];
                }
            }
            $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", ['status' => '1']);
            if ($getchargecodes->num_rows() > 0) {
                foreach ($getchargecodes->result() as $res) {
                    $chargecodes[] = ['charge_id' => $res->id, 'charge_code' => $res->charge_code];
                }
            }
        }
        $vas_ids = [];
        $getvas_ids = $this->db->select("id,vas_id,vas_name")->get_where("tb_vas_master", ['status' => '1']);
        if ($getvas_ids->num_rows() > 0) {
            foreach ($getvas_ids->result() as $res) {
                $vas_ids[] = ['vas_row_id' => $res->id, 'vas_id' => $res->vas_id . "-" . $res->vas_name];
            }
        }
        $transport = [];
        if ($company_code == 'RUKN') {
            $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        } else {
            $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", ['status' => 1]);
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = ['code' => $res->code, 'name' => $res->name];
                }
            }
        }
        $data['stoppagecodes'] = $data['resolutioncodes'] = [];
        $select = "id,code";
        $getstoppage = $this->Order->getmasters('tbl_stoppage_master', $select);
        if ($getstoppage->num_rows() > 0) {
            foreach ($getstoppage->result() as $res) {
                $data['stoppagecodes'][] = ['id' => $res->id, 'code' => $res->code];
            }
        }
        $select = "id,name";
        $getresolution = $this->Order->getmasters('tbl_resolution_master', $select);
        if ($getresolution->num_rows() > 0) {
            foreach ($getresolution->result() as $res) {
                $data['resolutioncodes'][] = ['id' => $res->id, 'name' => $res->name];
            }
        }
        $data['transport'] = $transport;
        $data['order_details'] = $order_details;
        $data['pickup_details'] = $pickup_details;
        $data['drop_details'] = $drop_details;
        $data['shipper_details'] = $shipper_details;
        $data['order_types'] = $order_types;
        $data['delivery_array'] = $delivery_array;
        $data['chargecodes'] = $chargecodes;
        $data['roles'] = $roles;
        $data['vas_ids'] = $vas_ids;
        //  $data['cargos'] = $cargos;
        $this->newtemplate->dashboard('amzorders/editorder', $data);
    }

    public function viewroletypelist()
    {
        $data = [];
        $type = isset($_POST['type']) ? $_POST['type'] : "";
        if ($type != "") {
            $user_id = $this->session->userdata('user_id');
            if ($user_id != '0') {
                if ($type == "Vendor") {
                    $type = "Carrier";
                }
                $this->db->select("m.id,m.name,m.email,m.code,m.company_code,m.branch_code,m.country,m.location_id,m.street");
                $this->db->from("tbl_party_master m");
                $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
                if ($type == "Overseas OL") {
                    $this->db->where('m.category_type', 'Overseas OL');
                } else if ($type == "Internal BU") {
                    $this->db->where('m.category_type', 'KN Office');
                } else {
                    $this->db->like("p.name", $type);
                }
                $this->db->where("m.user_id", $user_id);
                $where = "m.acon_debitor_code is  NOT NULL";
                $this->db->where($where);
                $getroles = $this->db->get();
                if ($getroles->num_rows() > 0) {
                    foreach ($getroles->result() as $res) {
                        $check = "";
                        if ($type == "Customer") {
                            $check = "<input class='rolelist' type='radio' name='selectrole' id='rolelist_" . $res->id . "' value='" . $res->code . "' onchange=selectrolebyid(" . $res->id . ")>";
                        }
                        if ($type == "Carrier") {
                            $check = "<input class='vendorlist' type='radio' name='selectvendor' id='vendorlist_" . $res->id . "' value='" . $res->code . "' onchange=selectvendorbyid(" . $res->id . ")>";
                        }
                        if ($type == "Overseas OL" || $type == "Internal BU") {
                            $check = "<input class='twopartieslist' type='radio' name='selectparties' id='twopartieslist_" . $res->id . "' value='" . $res->code . "' onchange=selectpartiesbyid(" . $res->id . ")>";
                        }
                        $data[] = [
                            'check' => $check,
                            'id' => $res->id,
                            'code' => $res->code,
                            'name' => $res->name,
                            'email_id' => $res->email,
                            'company_code' => $res->company_code,
                            'branch_code' => $res->branch_code,
                            'country' => $res->country,
                            'street' => $res->street,
                            'city' => $res->location_id
                        ];
                    }
                }
            }
        }
        echo json_encode($data);
    }

    public function getorderstatusdetails()
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $company_code = $this->session->userdata("company_code");
        $status = [];
        $order_id = $this->input->post('order_id');
        if ($order_id != "") {
            $getshiftid = $this->db->select("order_id,shift_id")->get_where("tb_orders", ['id' => $order_id]);
            if ($getshiftid->num_rows() > 0) {
                $sql = 'select o.id,o.latitude,o.longitude,o.status_code,
                convertToClientTZ(o.status_date,?) as status_date,o.createdon,s.status_name
                from tb_order_status o,tb_status_master s
                where order_id=? AND o.status_id=s.id AND o.status =1';
                $getorderstatus = $this->db->query($sql, [$curtz, $order_id]);

                if ($getorderstatus->num_rows() > 0) {
                    foreach ($getorderstatus->result() as $res) {
                        $location_name = getLocationName($res->latitude, $res->longitude);
                        $location = '"' . $location_name . '"';
                        $code = $res->status_code . "-" . $res->status_name;
                        $status_code = '"' . $res->status_code . '"';
                        $status_name = '"' . $res->status_name . '"';
                        $createdon = $res->status_date;
                        /* $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);*/
                        $date = '"' . $createdon . '"';
                        /*$createdon = $getactual['datetime'];*/
                        /*  $getcdate = getdatetimebytimezone(DFLT_TZ,$created_on,$curtz);
                $createdon = '"'.$getcdate['datetime'].'"';
                $listcreatedon = $getcdate['datetime'];*/
                        $name = $res->status_name;
                        $type = "order_sts";
                        $stop_type = "P";
                        $sts_value = '"' . $res->status_code . '_' . $stop_type . '_' . $name . '"';
                        $sts_name = '"' . $stop_type . '-' . $name . '"';
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this," . $res->id . "," . $status_code . "," . $location . "," . $date . "," . $sts_value . "," . $sts_name . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
                        $status[] = [
                            'id' => $res->id,
                            'status_name' => $res->status_name,
                            'date' => $createdon,
                            'action' => $action,
                            'stop_id' => $res->status_code,
                            'status_type' => $stop_type,
                            'location' => $location_name
                        ];

                    }
                }
                $bookingid = $getshiftid->row()->order_id;
                $shift_id = $getshiftid->row()->shift_id;
                if ($shift_id != "0") {
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];

                    $sql = 'SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,
                convertToClientTZ(ts.createdon,?) as createdon,sm.status_name from tb_stop_status ts,tb_status_master sm,tb_employee e
                WHERE sm.id=ts.status_id AND ts.shipment_id=e.shift_id AND e.order_id=?
                AND ts.shipment_id = ? AND (ts.stop_detail_id=0 OR ts.stop_detail_id=e.id) GROUP BY ts.id ORDER BY ts.id ASC';
                    $getstatus = $this->db->query($sql, [$curtz, $bookingid, $shift_id]);
                    if ($getstatus->num_rows() > 0) {
                        if ($getstatus->num_rows() == 1) {
                            $sql = 'SELECT id,shift_id from  tb_employee  WHERE order_id=? GROUP BY shift_id';
                            $getlegshiftid = $this->db->query($sql, [$order_id]);
                            if ($getlegshiftid->num_rows() > 0) {
                                foreach ($getlegshiftid->result() as $res) {
                                    $shift_id = $res->shift_id;
                                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                                    $sql = 'SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,
                                    convertToClientTZ(ts.createdon,?) as createdon,sm.status_name from tb_stop_status ts,tb_status_master sm,tb_employee e
                                    WHERE sm.id=ts.status_id AND ts.shipment_id=e.shift_id AND e.order_id=? AND
                                    ts.shipment_id =? AND (ts.stop_detail_id=0 OR ts.stop_detail_id=e.id) GROUP BY ts.id ORDER BY ts.id ASC';
                                    $getlegstatus = $this->db->query($sql, [$curtz, $order_id, $shift_id]);
                                    if ($getlegstatus->num_rows() > 0) {
                                        foreach ($getlegstatus->result() as $res) {
                                            $location_name = $res->loc_name;
                                            if ($location_name == "") {
                                                $location_name = getLocationName($res->latitude, $res->longitude);
                                            }

                                            $location = '"' . $location_name . '"';
                                            $status_code = '"' . $res->status_code . '"';
                                            $status_name = '"' . $res->status_name . '"';
                                            /* if($company_code == "RUKN" && $res->id == "1"){
                                    $status_name = '"Actual Pick Up"';
                                }
                                if($company_code == "RUKN" && $res->id == "3"){
                                    $status_name = '"Delivery To Consignee"';
                                }
                               */
                                            $stop_type = $res->stop_type;
                                            if ($stop_type == "") {
                                                $stop_type = "P";
                                            }
                                            if ($status_code == 'KN007') {
                                                $name = 'PickUp';
                                            } else {
                                                $name = $res->status_name;
                                            }
                                            if ($company_code == "RUKN" && $res->status_code == "0500") {
                                                $name = 'Actual Pick Up';
                                            }
                                            if ($company_code == "RUKN" && $res->status_code == "3000") {
                                                $name = 'Delivery To Consignee';
                                            }
                                            $sts_value = '"' . $res->status_code . '_' . $stop_type . '_' . $name . '"';
                                            $date = '"' . $res->createdon . '"';
                                            $sts_name = '"' . $stop_type . '-' . $name . '"';
                                            $sts_finalname = $res->status_name;
                                            if ($company_code == "RUKN" && $res->status_code == "0500") {
                                                $sts_finalname = 'Actual Pick Up';
                                            }
                                            if ($company_code == "RUKN" && $res->status_code == "3000") {
                                                $sts_finalname = 'Delivered To Consignee';
                                            }
                                            if ($company_code == "RUKN" && $res->status_code == "2300") {
                                                $sts_finalname = 'Arrival at Delivery Point';
                                            }
                                            $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this," . $res->id . "," . $status_code . "," . $location . "," . $date . "," . $sts_value . "," . $sts_name . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
                                            $status[] = [
                                                'id' => $res->id,
                                                'lattitude' => $res->latitude,
                                                'longitude' => $res->longitude,
                                                'stop_id' => $res->status_code,
                                                'status_name' => $sts_finalname,
                                                'date' => $res->createdon,
                                                'action' => $action,
                                                'location' => $location_name,
                                                'status_type' => $stop_type
                                            ];
                                        }

                                    }
                                }
                            }

                        } else {
                            foreach ($getstatus->result() as $res) {
                                $location_name = $res->loc_name;
                                if ($location_name == "") {
                                    $location_name = getLocationName($res->latitude, $res->longitude);
                                }

                                $location = '"' . $location_name . '"';
                                $status_code = '"' . $res->status_code . '"';
                                $status_name = '"' . $res->status_name . '"';
                                /* if($company_code == "RUKN" && $res->id == "1"){
                            $status_name = '"Actual Pick Up"';
                        }
                        if($company_code == "RUKN" && $res->id == "3"){
                            $status_name = '"Delivery To Consignee"';
                        }
                       */
                                $stop_type = $res->stop_type;
                                if ($stop_type == "") {
                                    $stop_type = "P";
                                }
                                if ($status_code == 'KN007') {
                                    $name = 'PickUp';
                                } else {
                                    $name = $res->status_name;
                                }
                                if ($company_code == "RUKN" && $res->status_code == "0500") {
                                    $name = 'Actual Pick Up';
                                }
                                if ($company_code == "RUKN" && $res->status_code == "3000") {
                                    $name = 'Delivery To Consignee';
                                }
                                $sts_value = '"' . $res->status_code . '_' . $stop_type . '_' . $name . '"';
                                $date = '"' . $res->createdon . '"';
                                $sts_name = '"' . $stop_type . '-' . $name . '"';
                                $sts_finalname = $res->status_name;
                                if ($company_code == "RUKN" && $res->status_code == "0500") {
                                    $sts_finalname = 'Actual Pick Up';
                                }
                                if ($company_code == "RUKN" && $res->status_code == "3000") {
                                    $sts_finalname = 'Delivered To Consignee';
                                }
                                if ($company_code == "RUKN" && $res->status_code == "2300") {
                                    $sts_finalname = 'Arrival at Delivery Point';
                                }
                                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this," . $res->id . "," . $status_code . "," . $location . "," . $date . "," . $sts_value . "," . $sts_name . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
                                $status[] = [
                                    'id' => $res->id,
                                    'lattitude' => $res->latitude,
                                    'longitude' => $res->longitude,
                                    'stop_id' => $res->status_code,
                                    'status_name' => $sts_finalname,
                                    'date' => $res->createdon,
                                    'action' => $action,
                                    'location' => $location_name,
                                    'status_type' => $stop_type
                                ];
                            }
                        }
                    }
                } else {
                }
            }
        }
        echo json_encode($status);
    }

    public function orddocsdetails()
    {
        $status = [];
        $order_id = $this->input->post('order_id');
        if ($order_id != "") {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $sql = 'SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,
            convertToClientTZ(ts.createdon,?) as createdon,ts.imgpath from tb_pod_uploads ts
            LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type
            WHERE ts.order_id = ? AND ts.status=1 GROUP BY ts.id';
            $sql1 = $this->db->query($sql, [$curtz, $order_id]);
            if ($sql1->num_rows() > 0) {
                foreach ($sql1->result() as $res) {
                    $location_name = getLocationName($res->latitude, $res->longitude);
                    $imgpath = "";
                    $allowed = ['pdf'];
                    if ($res->imgpath != "") {
                        $ext = pathinfo($res->imgpath, PATHINFO_EXTENSION);
                        $imglink = checkimageintmsorknlmv($res->imgpath, false);
                        if ($imglink != "") {
                            if (in_array($ext, $allowed)) {
                                $path = '<a target="_blank" href="' . $imglink . '"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                            } else {
                                $path = '<a target="_blank" href="' . $imglink . '"><img src="' . $imglink . '" class="img-responsive" style="width: 10%;"></a>';
                            }
                        }
                        $driver = getDrivernameById($res->createdby)["name"];
                        $action = "";
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowdocAdd(this," . $order_id . ");'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li></li></ul>";
                        $status[] = [
                            'id' => $res->id,
                            'type_name' => $res->type_name,
                            'imgpath' => $path,
                            'stop_id' => $res->stop_id,
                            'stop_type' => $res->stop_type,
                            'date' => date("d M,y h:i A", strtotime($res->createdon)),
                            'action' => $action,
                            'location' => $location_name,
                            'driver' => $driver
                        ];
                    }
                }
            }
        }
        echo json_encode($status);
    }

    public function addorderdoc()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
        $data['stops'] = $data['document_types'] = [];
        $data['booking_id'] = $data['shift_id'] = $data['trip_id'] = $booking_id = 0;
        $data['company_code'] = $data['branch_code'] = "";
        if ($order_id != "" && $order_id != '0') {
            $ord = $order_id;
            $getorderdetails = $this->db->select("id,order_id,company_code,branch_code,shift_id,trip_id")->get_where("tb_orders", ['id' => $order_id]);
            if ($getorderdetails->num_rows() > 0) {
                $data['order_row_id'] = $getorderdetails->row()->id;
                $data['booking_id'] = $booking_id = $getorderdetails->row()->order_id;
                $data['company_code'] = $getorderdetails->row()->company_code;
                $data['branch_code'] = $getorderdetails->row()->branch_code;
                $data['shift_id'] = $getorderdetails->row()->shift_id;
                $data['trip_id'] = $getorderdetails->row()->trip_id;
            }
            $sql = 'SELECT o.id,o.stopname FROM tb_shiporder_stops o,tb_employee e
            WHERE o.shipment_id=e.shift_id AND e.order_id=?
            AND o.status=1 AND e.status=1 ORDER BY o.ordernumber ASC';
            $stops = $this->db->query($sql, [$booking_id]);
            if ($stops->num_rows() > 0) {
                $data['stops'] = $stops->result_array();
                $data['document_types'] = $this->db->select("id,type_name")->get_where("tb_document_types", ["status" => 1])->result_array();
            } else {
                $data['document_types'] = $this->db->select("id,type_name")->get_where("tb_document_types", ["status" => 1, "type_name" => 'Others'])->result_array();
            }
        }
        echo json_encode($data);
    }

    public function checktripfororder()
    {
        $company_code = $this->session->userdata('company_code');
        $order_id = $this->input->post('order_id');
        $trip_id = $shift_id = $booking_id = $parent_id = 0;
        $chkorder = $this->db->select("order_id,shift_id,parent_id,trip_id")->get_where("tb_orders", ['id' => $order_id]);
        if ($chkorder->num_rows() > 0) {
            $shift_id = $chkorder->row()->shift_id;
            $trip_id = $chkorder->row()->trip_id;
            $booking_id = $chkorder->row()->order_id;
            $parent_id = $chkorder->row()->parent_id;
        }
        $dshipid = $pshipid = $dstopdetailsid = $pstopdetailsid = 0;
        $select = '<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option>';
        if ($shift_id != '0' && $parent_id != 0) {
            $arr = array('0212' => 'Accept By Driver', 'TL' => 'Outbound Trailer Started', 'CL' => 'Outbound Tailer Ended', 'LY' => 'Outbound Trailer Departed');
            $stsqry = $this->db->query("SELECT id,status_code FROM tb_stop_status WHERE order_id=$order_id AND status=1 ORDER BY FIELD(status_code,'0212','TL','CL','LY') DESC limit 1");
            if ($stsqry->num_rows() > 0) {
                $getsts = "";
                $stsrow = $stsqry->row_array();
                if ($stsrow['status_code'] == "0212") {
                    $select .= '<option value="TL" >' . $arr['TL'] . '</option>';
                } else if ($stsrow['status_code'] == "TL" || $stsrow['status_code'] == "0420") {
                    $select .= '<option value="CL" >' . $arr['CL'] . '</option>';
                } else if ($stsrow['status_code'] == "CL" || $stsrow['status_code'] == "0500") {
                    $select .= '<option value="LY" >' . $arr['LY'] . '</option>';
                } else if ($stsrow['status_code'] == "LY" || $stsrow['status_code'] == "0191") {
                    /*$select .= '<option value="TL" >'.$arr['TL'].'</option>';*/
                }
            } else {
                $select .= '<option value="0212">' . $arr['0212'] . '</option>';
            }
            $select .= "</select>";
        } else {
            $select = '<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option>';
            $arr1 = ['RY' => 'Container Arrived', 'ON' => 'Container Opened', 'ED' => 'Container Closed', 'ER' => 'Container Departed'];
            $sql = 'SELECT id,status_code FROM tb_order_status WHERE order_id=? AND status=1 ORDER BY FIELD(status_code,"RY", "ON", "ED", "ER") DESC limit 1';
            $stsqry = $this->db->query($sql, [$order_id]);

            if ($stsqry->num_rows() > 0) {
                $stsrow = $stsqry->row_array();
                if ($stsrow['status_code'] == "RY") {
                    $select .= '<option value="ON">' . $arr1['ON'] . '</option>';
                } else if ($stsrow['status_code'] == "ON") {
                    $select .= '<option value="ED">' . $arr1['ED'] . '</option>';
                } else if ($stsrow['status_code'] == "ED") {
                    $select .= '<option value="ER">' . $arr1['ER'] . '</option>';
                } else if ($stsrow['status_code'] == "ER") {
                    /*$select .= '<option value="ON">'.$arr1['ON'].'</option>';*/
                }
            } else {
                $select .= '<option value="RY">' . $arr1['RY'] . '</option>';
            }
            $select .= "</select>";
        }
        $response = array('select' => $select, 'pshipid' => $pshipid, 'dshipid' => $dshipid, 'dstopdetailsid' => $dstopdetailsid, 'pstopdetailsid' => $pstopdetailsid);
        echo json_encode($response);
    }

    public function addstatus($id = NULL)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $company_code = $this->session->userdata('company_code');
        $curdt = $getactual['datetime'];
        $hrs = $this->session->userdata("usr_tzone")['hrs'];
        $order_id = isset($_POST['order_status_id']) ? $_POST['order_status_id'] : "0";
        $lattitude = $longitude = "";
        $booking_id = 0;
        if ($order_id != "0") {
            $user_id = $this->session->userdata('user_id');
            $shift_id = $trip_id = $ord_id = 0;
            $createdsource = "";
            $latitude = $longitude = "";
            $plat = $plng = $dlat = $dlng = "";
            $chkshft = $this->db->select("id,order_id,plat,plng,dlat,dlng,shift_id,trip_id,parent_id,created_source")->get_where("tb_orders", ['id' => $order_id]);
            if ($chkshft->num_rows() > 0) {
                $booking_id = $chkshft->row()->order_id;
                $shift_id = $chkshft->row()->shift_id;
                $trip_id = $chkshft->row()->trip_id;
                if ($shift_id == '0' && $chkshft->row()->parent_id == '0') {
                    $chkshft1 = $this->db->select("id,order_id,shift_id,trip_id")->get_where("tb_orders", ['parent_id' => $order_id, 'shift_id <>' => 0], 1, 0);
                    if ($chkshft1->num_rows() > 0) {
                        $shift_id = $chkshft1->row()->shift_id;
                        $trip_id = $chkshft1->row()->trip_id;
                    }
                }
                $createdsource = $chkshft->row()->created_source;
                $ord_id = $chkshft->row()->id;
                if ($chkshft->row()->plat != "") {
                    $plat = $chkshft->row()->plat;
                    $plng = $chkshft->row()->plng;
                } else {
                    $chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings", ["user_id" => $user_id], 1, 0);
                    if ($chklatlng->num_rows() > 0) {
                        $plat = $chklatlng->row()->latitude;
                        $plng = $chklatlng->row()->longitude;
                    }
                }
                if ($chkshft->row()->dlat != "") {
                    $dlat = $chkshft->row()->dlat;
                    $dlng = $chkshft->row()->dlng;
                } else {
                    $chklatlng1 = $this->db->select("latitude,longitude")->get_where("tb_site_settings", ["user_id" => $user_id], 1, 0);
                    if ($chklatlng1->num_rows() > 0) {
                        $dlat = $chklatlng1->row()->latitude;
                        $dlng = $chklatlng1->row()->longitude;
                    }
                }
            }
            $status_code = isset($_POST['status_code']) ? $_POST['status_code'] : "";
            $status_date = isset($_POST['status_date']) ? $_POST['status_date'] : "";
            if ($status_date == "") {
                $status_date = date('Y-m-d H:i:s');
            }
            $sts_times = getdatetimebytimezone(DFLT_TZ, $status_date, $curtz);
            $sts_time = $sts_times['datetime'];
            $pshipid = isset($_POST['pshipid']) ? $_POST['pshipid'] : "0";
            $dshipid = isset($_POST['dshipid']) ? $_POST['dshipid'] : "0";
            $pstopdetailsid = isset($_POST['pstopdetailsid']) ? $_POST['pstopdetailsid'] : "0";
            $dstopdetailsid = isset($_POST['dstopdetailsid']) ? $_POST['dstopdetailsid'] : "0";
            $sname = isset($_POST['status_name']) ? $_POST['status_name'] : "";
            $status_name = "";
            if ($sname != "") {
                $sts = explode('_', $sname);
                $stop_type = 'P';
                if (!empty($sts)) {
                    $stop_type = isset($sts[1]) ? $sts[1] : "P";
                    $status_name = isset($sts[2]) ? $sts[2] : "";
                }
            }
            $getstatusid = $this->db->select("id")->get_where("tb_status_master", ['status_code' => $status_code]);
            $status_id = 0;
            if ($getstatusid->num_rows() > 0) {
                $status_id = $getstatusid->row()->id;
            }
            $stssend = "0";
            if ($status_code != "TL" && $status_code != "CL" && $status_code != "LY" && $status_code != "0212") {
                if ($id == "" && $status_id != 0) {
                    $latitude = $plat;
                    $longitude = $plng;
                    $status_ar = ['order_id' => $order_id, 'status_id' => $status_id, 'latitude' => $lattitude, 'longitude' => $longitude, 'status_code' => $status_code, 'status' => '1', 'status_date' => $sts_time];
                    $chksts = $this->db->select("id")->get_where("tb_order_status", ['order_id' => $order_id, 'status_id' => $status_id, 'status_code' => $status_code]);
                    if ($chksts->num_rows() == 0) {
                        $ins = $this->common->insertTableData("tb_order_status", $status_ar);
                        if ($ins) {
                            /*send status xml to amazon*/
                            $this->load->library("amazonstatusintegration");
                            $postdata = array(
                                "shipment_id" => $shift_id,
                                "trip_id" => $trip_id,
                                "driver_id" => 0,
                                "vehicle_id" => 0,
                                "order_id" => $booking_id,
                                "user_id" => $user_id,
                                "stop_id" => '',
                                "latitude" => $lattitude,
                                "longitude" => $longitude,
                                "curtz" => $curtz,
                                "hrs" => $hrs,
                                "web" => $status_date,
                                "status_code" => $status_code,
                                "ord_id" => $order_id
                            );
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                            $stssend = "1";
                        }
                    }
                } else {
                    $upd = $this->db->where(['id' => $id])->update("tb_order_status", ['status_date' => $sts_time]);
                    $stssend = "1";
                }
                echo $stssend;
            } else {
                if ($id == "" && $shift_id != "0") {
                    $vehicle_id = 0;
                    $contact_num = "";
                    $driver_id = 0;
                    $stop_id = $stopdetailid = 0;
                    if ($stop_type == 'P') {
                        $stop_id = $pshipid;
                        $stopdetailid = $pstopdetailsid;
                    } else {
                        $stop_id = $dshipid;
                        $stopdetailid = $dstopdetailsid;
                    }
                    $getvehicleid = $this->db->select("vehicle_id")->get_where("tb_shft_veh", ['shft_id' => $shift_id]);
                    if ($getvehicleid->num_rows() > 0) {
                        $vehicle_id = $getvehicleid->row()->vehicle_id;
                    }
                    $sql = 'SELECT id,vehicle_id,driver_id,start_imei FROM tb_trips WHERE shift_id=? AND status=1';
                    $checktrip = $this->db->query($sql, [$shift_id]);
                    if ($checktrip->num_rows() > 0) {
                        $contact_num = $checktrip->row()->start_imei;
                        $trip_id = $checktrip->row()->id;
                        $vehicle_id = $checktrip->row()->vehicle_id;
                        $driver_id = $checktrip->row()->driver_id;
                    }
                    if ($trip_id == 0 && $vehicle_id != "") {
                        $sql = 'SELECT vehicle_id,driver_id,imei FROM tbl_assigned_drivers WHERE vehicle_id=? AND status=1 LIMIT 1';
                        $checktrip1 = $this->db->query($sql, [$vehicle_id]);
                        if ($checktrip1->num_rows() > 0) {
                            $vehicle_id = $checktrip1->row()->vehicle_id;
                            $driver_id = $checktrip1->row()->driver_id;
                            $contact_num = $checktrip1->row()->imei;
                        }
                    }
                    if ($driver_id == 0) {
                        $sql = 'SELECT vehicle_id,driver_id,imei FROM tb_vehicles_drivers WHERE vehicle_id=? AND status=1 LIMIT 1';
                        $checktrip11 = $this->db->query($sql, [$vehicle_id]);
                        if ($checktrip11->num_rows() > 0) {
                            $driver_id = $checktrip11->row()->driver_id;
                            $contact_num = $checktrip11->row()->imei;
                        }
                    }
                    if ($status_code == "TL" || $status_code == "CL" || $status_code == "LY") {
                        if ($status_code == "TL") {
                            $chqry1 = $this->db->select("id,trip_id")->get_where("tb_stop_status", ['order_id' => $order_id, 'shipment_id' => $shift_id, "status_id" => '10', "status" => 1], 1, 0);
                            if ($chqry1->num_rows() == 0) {
                                if ($shift_id != "") {
                                    $status_id = '10';
                                    $trip_id == '0';
                                }
                            } else {
                                $trip_id = $chqry1->row()->trip_id;
                                $status_id = 2;
                                $stop_type == "P";
                            }
                        } else if ($status_code == "CL") {
                            $chqry1 = $this->db->select("id,trip_id")->get_where("tb_stop_status", ['order_id' => $order_id, 'shipment_id' => $shift_id, "status_id" => '2', "status" => 1], 1, 0);
                            if ($chqry1->num_rows() > 0) {
                                $status_id = 1;
                                $stop_type == "P";
                            }
                        } else if ($status_code == "LY") {
                            $chqry1 = $this->db->select("id,trip_id")->get_where("tb_stop_status", ['order_id' => $order_id, 'shipment_id' => $shift_id, "status_id" => '1', "status" => 1], 1, 0);
                            if ($chqry1->num_rows() > 0) {
                                $status_id = 3;
                                $stop_type == "P";
                            }
                        }
                    }
                    if ($status_id == '10' && $trip_id == '0') {
                        $chqry = $this->db->select("id")->get_where("tb_trips", ['shift_id' => $shift_id, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id], 1, 0);
                        if ($chqry->num_rows() == 0) {
                            if ($contact_num == "") {
                                $newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers", ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 1], 1, 0);
                                if ($newimei->num_rows() > 0) {
                                    $contact_num = $newimei->row()->imei;
                                }
                            }
                            $latitude = $plat;
                            $longitude = $plng;
                            $triparr = [
                                'shift_id' => $shift_id,
                                'vehicle_id' => $vehicle_id,
                                'driver_id' => $driver_id,
                                'stime' => $sts_time,
                                'start_imei' => $contact_num,
                                'splace' => "",
                                'eplace' => "",
                                'start_reading' => 0,
                                'end_reading' => 0,
                                'created_on' => $sts_time,
                                'updated_on' => $curdt,
                                'status' => 1,
                                'trip_type' => 0,
                                'transit_status' => 0
                            ];
                            $trip_id = $this->common->insertTableData('tb_trips', $triparr);
                            $insarry = [
                                'order_id' => $order_id,
                                "shipment_id" => $shift_id,
                                "stop_id" => 0,
                                "stop_detail_id" => 0,
                                "stop_type" => "",
                                "trip_id" => $trip_id,
                                "status_id" => $status_id,
                                "latitude" => $lattitude,
                                "longitude" => $longitude,
                                "status" => 1,
                                "reason" => "From Admin",
                                "vehicle_id" => $vehicle_id,
                                "driver_id" => $driver_id,
                                "status_code" => $status_code,
                                "createdon" => $sts_time
                            ];
                            $ins = $this->db->insert("tb_stop_status", $insarry);
                            /* update orders table */
                            $ordwhr = ["shift_id" => $shift_id];
                            $ordset = ["trip_id" => $trip_id];
                            $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
                            $postdata = [
                                "shipment_id" => $shift_id,
                                "trip_id" => $trip_id,
                                "driver_id" => $driver_id,
                                "vehicle_id" => $vehicle_id,
                                "order_id" => $booking_id,
                                "user_id" => $user_id,
                                "stop_id" => '',
                                "latitude" => $lattitude,
                                "longitude" => $longitude,
                                "curtz" => $curtz,
                                "hrs" => $hrs,
                                "web" => $status_date,
                                "status_code" => $status_code,
                                "ord_id" => $order_id,
                            ];
                            if ($createdsource == "18") {
                                $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                            } else if ($createdsource == '9') {
                                $postdata['status_code'] = '0212';
                                $sts = $this->svkonektquote->getstatusresponse($postdata);
                            } else if ($createdsource == '13') {
                                $this->load->library("amazonstatusintegration");
                                $sts = $this->amazonstatusintegration->outboundTrailerASN($postdata);
                            }
                        }
                        $stssend = "1";
                    } else {
                        if ($trip_id != "0" && $status_id != "11") {
                            $chqry = $this->db->select("id")->get_where("tb_stop_status", [
                                "shipment_id" => $shift_id,
                                "stop_id" => $stop_id,
                                "stop_detail_id" => $stopdetailid,
                                "stop_type" => $stop_type,
                                "trip_id" => $trip_id,
                                "status_id" => $status_id
                            ], 1, 0);
                            if ($chqry->num_rows() == 0) {
                                if ($status_id == "2" && $stop_type == "P") {
                                    $ttdata = array("id" => $trip_id);
                                    $data2["updated_on"] = $curdt;
                                    $data2["transit_status"] = '1';
                                    $res = $this->db->set($data2)->where($ttdata)->update("tb_trips");
                                }
                                if ($stop_type == "P" || $status_id == "4") {
                                    $latitude = $plat;
                                    $longitude = $plng;
                                }
                                if ($stop_type == "D") {
                                    $latitude = $dlat;
                                    $longitude = $dlng;
                                }
                                $insarry = [
                                    "shipment_id" => $shift_id,
                                    'order_id' => $order_id,
                                    "stop_id" => $stop_id,
                                    "stop_detail_id" => $stopdetailid,
                                    "stop_type" => $stop_type,
                                    "trip_id" => $trip_id,
                                    "status_id" => $status_id,
                                    "latitude" => $lattitude,
                                    "longitude" => $longitude,
                                    "status" => 1,
                                    "reason" => "From Admin",
                                    "vehicle_id" => $vehicle_id,
                                    "driver_id" => $driver_id,
                                    "status_code" => $status_code,
                                    "createdon" => $sts_time
                                ];
                                $ins = $this->db->insert("tb_stop_status", $insarry);
                                /*}*/
                                $chqry1 = $this->db->select("id")->get_where("tb_trip_employee", ["employee_id" => $stopdetailid, "stop_id" => $stop_id, "trip_id" => $trip_id, "status" => 1], 1, 0);
                                if ($chqry1->num_rows() == 0) {
                                    $insarr = [
                                        'employee_id' => $stopdetailid,
                                        'stop_id' => $stop_id,
                                        'trip_id' => $trip_id,
                                        "status" => 1,
                                        'driver_late' => 0,
                                        'emp_late' => 0,
                                        'stime' => $curdt,
                                        'check_in' => $curdt,
                                        'absent_reason' => 'Closed',
                                        'created_on' => $curdt,
                                        'updated_on' => $curdt,
                                        'pd_status' => 1
                                    ];
                                    $ins = $this->db->insert("tb_trip_employee", $insarr);
                                }
                                $postdata = [
                                    "shipment_id" => $shift_id,
                                    "trip_id" => $trip_id,
                                    "driver_id" => $driver_id,
                                    "stop_id" => $stop_id,
                                    "order_id" => $booking_id,
                                    "inc_id" => 0,
                                    "pod_type" => '',
                                    "latitude" => $lattitude,
                                    "longitude" => $longitude,
                                    "stop_type" => $stop_type,
                                    "vehicle_id" => $vehicle_id,
                                    "curtz" => $curtz,
                                    "hrs" => $hrs,
                                    "web" => $status_date,
                                    "status_code" => $status_code,
                                    "ord_id" => $order_id,
                                    "user_id" => $user_id,
                                ];
                                if ($createdsource == "13") {
                                    $this->load->library("amazonstatusintegration");
                                    if ($status_id == "2" && $stop_type == "P") {
                                        /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                                    }
                                    if ($status_id == "1" && $stop_type == "P") {
                                        /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                                    }
                                    if ($status_id == "3" && $stop_type == "P") {
                                        /*send to roadlog*/
                                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                                    }
                                    if ($status_id == "2" && $stop_type == "D") {
                                        /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                                    }
                                    if ($status_id == "1" && $stop_type == "D") {
                                        /*$sts = $this->statusintigration->shipmentdelivered($postdata);*/
                                        /*send to roadlog*/
                                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                                    }
                                    if ($status_id == "3" && $stop_type == "D") {
                                        /*send to roadlog*/
                                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                                    }
                                    if ($status_code == "LY") {
                                        $chkmuliti = $this->db->select("id")->get_where("tb_orders", ["shift_id" => $shift_id, "trip_sts" => '0']);
                                        if ($chkmuliti->num_rows() > 1) {
                                            $upd = $this->db->where(array("id" => $order_id, "trip_id !=" => 0))->update("tb_orders", ["trip_sts" => '1']);
                                        } else {
                                            $updwhr = ["id" => $shift_id];
                                            $upddata = ["status" => '0', "updated_on" => $curdt];
                                            $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                                            $data1 = array();
                                            $tdata = ["id" => $trip_id];
                                            $data1["end_imei"] = "";
                                            $data1["end_reading"] = '0';
                                            $data1["etime"] = $data1["updated_on"] = $curdt;
                                            $data1["status"] = '0';
                                            $data1["transit_status"] = '1';
                                            $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                                            if ($shift_id > 0) {
                                                $upd = $this->db->where(["shift_id" => $shift_id])->update("tb_orders", ["trip_sts" => '1']);
                                            }
                                            /*$gensum = $this->generatesummary($trip_id,$curtz);*/
                                        }
                                    }
                                }
                            }
                        }
                        $stssend = "1";
                    }
                }
            }
                try {
                    $statusPayload = [
                        "trip" => $trip_id,
                        "ship" => $shift_id,
                        "ord_id" => $order_id,
                        "orderid" => $booking_id,
                        "stop_id" => 0,
                        "stop_detail_id" => 0,
                        "vehicle_id" => $vehicle_id,
                        "driver_id" => $driver_id,
                        "stop_type" => "P",
                        "timezone" => $this->session->userdata("timezone"),
                        "sts_date" => $sts_time,
                        "status_code" => $status_code
                    ];
                    $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                    $this->altovaordercreation->sendOrderToAltova($order_id, $status_code);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                }

            echo $stssend;
        }
    }

    public function vieworder($id = NULL)
    {
        if (!checkUrlAccessForUser('AMZORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data = [];
        $order_details = $shipper_details = $drop_details = $pickup_details = [];
        if ($id != "") {
            $chkorder = $this->Order->getordertoedit($id);
            if ($chkorder->num_rows() > 0) {
                $transport = $chkorder->row()->transport_mode;
                $transport_mode = "";
                if ($transport != "") {
                    $getmode = $this->db->select("name")->get_where("tb_transportmode", ['code' => $transport]);
                    if ($getmode->num_rows() > 0) {
                        $transport_mode = $getmode->row()->name;
                    }
                }
                $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
                $sql = 'SELECT reference_id,ref_value FROM tb_order_references WHERE order_id =? AND reference_id IN ("DQ","ORD_DLVINST","ORD_PIKINST","CTR")';
                $getdnote = $this->db->query($sql, [$id]);
                if ($getdnote->num_rows() > 0) {
                    foreach ($getdnote->result() as $ref) {
                        $ref_id = $ref->reference_id;
                        if ($ref_id == 'DQ') {
                            $shipment_id = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_DLVINST') {
                            $delivery_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'ORD_PIKINST') {
                            $pickup_inst = $ref->ref_value;
                        }
                        if ($ref_id == 'CTR') {
                            $container_no = $ref->ref_value;
                        }
                    }
                }
                $pickup_custid = $chkorder->row()->pickup_custid;
                $trip_id = $chkorder->row()->trip_id;
                $trip_sts = $chkorder->row()->trip_sts;
                $order_status = "PENDING";
                if ($trip_id != 0 && $trip_sts == 0) {
                    $order_status = 'ACTIVE';
                }
                if ($trip_id != 0 && $trip_sts == 1) {
                    $order_status = 'CLOSED';
                }
                $chkdate = '2020-07-01 00:00:00';
                $createdon = $chkorder->row()->createdon;
                $order_str = strtotime($createdon);
                $chk_str = strtotime($chkdate);
                $early_pickup = $chkorder->row()->pickup_datetime;
                $early_delivery = $chkorder->row()->delivery_datetime;
                $late_pickup = $chkorder->row()->pickup_endtime;
                $late_delivery = $chkorder->row()->drop_endtime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                if ($order_str > $chk_str) {
                    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                        $early_pickup = $epickup['datetime'];
                    }
                    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                        $early_delivery = $edelivery['datetime'];
                    }
                    if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
                        $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
                        $late_pickup = $lpickup['datetime'];
                    }
                    if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
                        $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                        $late_delivery = $ldelivery['datetime'];
                    }
                }
                $order_details = [
                    'id' => $chkorder->row()->id,
                    'order_id' => $chkorder->row()->order_id,
                    'shipment_id' => $shipment_id,
                    'order_status' => $order_status,
                    'early_pickup' => $early_pickup,
                    'early_delivery' => $early_delivery,
                    'late_pickup' => $late_pickup,
                    'late_delivery' => $late_delivery,
                    'product' => $chkorder->row()->product,
                    'incoterm' => $chkorder->row()->incoterm,
                    'delivery_note' => $chkorder->row()->delivery_note,
                    'purchase_order' => $chkorder->row()->purchase_order,
                    'notify_party' => $chkorder->row()->notify_party,
                    'goods_value' => $chkorder->row()->goods_value,
                    'lane_reference' => $chkorder->row()->lane_reference,
                    'distance' => $chkorder->row()->distance,
                    'customs_required' => $chkorder->row()->customs_required,
                    'high_cargo_value' => $chkorder->row()->high_cargo_value,
                    'valorance_insurance' => $chkorder->row()->valorance_insurance,
                    'temperature_control' => $chkorder->row()->temperature_control,
                    'company_code' => $chkorder->row()->company_code,
                    'branch_code' => $chkorder->row()->branch_code,
                    'department_code' => $chkorder->row()->department_code,
                    'createdon' => $chkorder->row()->createdon,
                    'transport_mode' => $transport_mode,
                    'pickup_inst' => $pickup_inst,
                    'delivery_inst' => $delivery_inst,
                    'container_no' => $container_no
                ];
                $delivery_term = "";
                $pickup_id = $chkorder->row()->customer_id;
                $ord_type = $chkorder->row()->order_type;
                $order_details['order_type'] = "";
                $getordertype = $this->db->select("type_name")->get_where("tb_order_types", ['id' => $ord_type, 'status' => '1', 'company_code' => $chkorder->row()->company_code]);
                if ($getordertype->num_rows() > 0) {
                    $order_details['order_type'] = $getordertype->row()->type_name;
                }
                $delivery_term_id = $chkorder->row()->delivery_term;
                if ($delivery_term_id != "") {
                    $getdelivery_term = $this->db->select("term_id,name")->get_where("tb_delivery_terms", ['term_id' => $delivery_term_id]);
                    if ($getdelivery_term->num_rows() > 0) {
                        $delivery_term = $getdelivery_term->row()->term_id . "-" . $getdelivery_term->row()->name;
                    }
                }
                $service = "";
                $service_id = $chkorder->row()->service;
                if ($service_id != "") {
                    $getservice = $this->db->select("service_id,name")->get_where("tb_service_master", ['id' => $service_id]);
                    if ($getservice->num_rows() > 0) {
                        $service = $getservice->row()->service_id . "-" . $getservice->row()->name;
                    }
                }
                $order_details['service'] = $service;
                $order_details['delivery_term'] = $delivery_term;
                $getpickupdetails = $this->db->select("id,name,address,pincode,code,country")->get_where("tb_customers", ['status' => 1, 'id' => $pickup_id]);
                if ($getpickupdetails->num_rows() > 0) {
                    $pickup_details = [
                        'id' => $getpickupdetails->row()->id,
                        'name' => $getpickupdetails->row()->name,
                        'party_id' => $getpickupdetails->row()->code,
                        'address' => $getpickupdetails->row()->address,
                        'pincode' => $getpickupdetails->row()->pincode,
                        'country' => $getpickupdetails->row()->country
                    ];
                }
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $sql = 'SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p
                INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1
                WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
                $chekparty = $this->db->query($sql, [$id]);
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = [
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = [
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                ];
                            }
                        }
                    }
                }
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;
                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
                $drop_id = $chkorder->row()->drop_custid;
            }
        }
        $data['order_details'] = $order_details;
        $data['pickup_details'] = $pickup_details;
        $data['drop_details'] = $drop_details;
        $data['shipper_details'] = $shipper_details;
        $this->newtemplate->dashboard('amzorders/vieworder', $data);
    }

    public function getshipperID()
    {
        $parties = [];
        $partytype_id = $this->input->post('partytype_id');
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $where = "status = 1 AND code != '' AND company_code != '' AND company_code IS NOT NULL AND code is NOT NULL AND code != '0' AND user_id = '" . $user_id . "' AND code LIKE '%" . $partytype_id . "%'";
        $this->db->select("id,name,phone,code,email_id,company_code,branch_code");
        $this->db->from("tb_customers");
        $this->db->where($where);
        $this->db->group_by('id');
        $this->db->order_by('createdon', 'DESC');
        $chkqry = $this->db->get();
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = [
                    'id' => $res->id,
                    'party_id' => $res->code,
                    'name' => $res->name,
                    'phone' => $res->phone,
                    'email' => $res->email_id,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code
                ];
            }
        }
        if ($company_code != "") {
            $getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", ['company_code' => $company_code, 'status' => '1']);
            if ($getorder_types->num_rows() > 0) {
                foreach ($getorder_types->result() as $res) {
                    $parties['ordparties'][] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            }
        }
        echo json_encode($parties);
    }

    public function getvendordetailsbyID()
    {
        $list = [];
        $code = $this->input->post('id');
        if ($code != "") {
            $sql = 'SELECT name,code FROM tb_vendors WHERE code LIKE ? AND status =1';
            $getvendordetails = $this->db->query($sql, [$code]);
            if ($getvendordetails->num_rows() > 0) {
                $list = ['name' => $getvendordetails->row()->name, 'code' => $getvendordetails->row()->code];
            }
        }
        echo json_encode($list);
    }

    public function getshipperdetailsbyID()
    {
        $parties = [];
        $code = $this->input->post('id');
        $customer_id = "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $chkqry = $this->db->select("id,name,phone,location,address,street,location,state,pincode,code,country,email_id,fax,company_code,branch_code")->get_where("tb_customers", ['code' => $code, 'user_id' => $user_id]);
        if ($chkqry->num_rows() > 0) {
            $customer_id = $chkqry->row()->id;
            $parties['customer_details'][] = [
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->phone,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->location,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email_id,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'location' => $chkqry->row()->location,
                'address' => $chkqry->row()->address,
                'company_code' => $chkqry->row()->company_code,
                'branch_code' => $chkqry->row()->branch_code
            ];
        }
        $parties['ordparties'] = [];
        if ($customer_id != "") {
            $getorder_types = $this->db->select("id,type_name")->group_by('type_name')->get_where("tb_order_types", ['customer_id' => $customer_id, 'status' => '1', 'company_code' => $company_code]);
            if ($getorder_types->num_rows() > 0) {
                foreach ($getorder_types->result() as $res) {
                    $parties['ordparties'][] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => $company_code, "status" => 1]);
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $parties['ordparties'][] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                    }
                } else {
                    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", ['company_code' => "SGKN", "status" => 1]);
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $parties['ordparties'][] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                        }
                    }
                }
            }
        }
        echo json_encode($parties);
    }

    public function saveshipper()
    {
        $post = $this->input->post();
        $master_id = "";
        $user_id = $this->session->userdata('user_id');
        $cust_id = isset($post['shipper_row_id']) ? $post['shipper_row_id'] : "";
        $customer_code = isset($post['scustomer_code']) ? $post['scustomer_code'] : "";
        $order_id = isset($post['shipper_orderrow_id']) ? $post['shipper_orderrow_id'] : "";
        $company_code = isset($post['shipper_company_code']) ? $post['shipper_company_code'] : "";
        $branch_code = isset($post['shipper_branch_code']) ? $post['shipper_branch_code'] : "";
        $cdate = date('Y-m-d H:i:s');
        $status = '1';
        $address = $post['shipper_street'] . ',' . $post['shipper_city'] . ',' . $post['shipper_state'];
        if ($company_code == "") {
            $company_code = $this->session->userdata('company_code');
        }
        if ($branch_code == "") {
            $branch_code = $this->session->userdata('branch_code');
        }
        $master_id = 0;
        $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", ['name' => 'Shipper', 'user_id' => $user_id]);
        if ($chktype->num_rows() > 0) {
            $party_id = $chktype->row()->id;
        } else {
            $party = [
                'name' => 'Shipper',
                'description' => 'Shipper',
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'created_on' => $cdate,
                'user_id' => $user_id
            ];
            $ins = $this->db->insert("tbl_party_types", $party);
            $party_id = $this->db->insert_id();
        }
        $code = $post['shipper_id'];
        if ($code == "") {
            $code = 0;
        }
        $master = [
            'party_type_id' => $party_id,
            'name' => $post['shipper_name'],
            'email' => $post['shipper_email'],
            'street' => $post['shipper_street'],
            'state' => $post['shipper_state'],
            'mobile' => $post['shipper_phone'],
            'pincode' => $post['shipper_zipcode'],
            'country' => $post['shipper_country'],
            'user_id' => $user_id,
            'code' => $code,
            'customeridentifier' => $code,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status' => '1',
            'fax' => $post['shipper_fax'],
            'address' => $address,
            'location_id' => $post['shipper_city']
        ];
        if ($code != '0') {
            $shipper_id = $code;
            $chkmaster = $this->db->select('id,customer_code')->get_where("tbl_party_master", ['code' => $post['shipper_id']]);
            if ($chkmaster->num_rows() > 0) {
                $master_id = $chkmaster->row()->id;
                $shipper_customer_code = $chkmaster->row()->customer_code;
                if ($order_id != "") {
                    if ($shipper_customer_code == "" || $shipper_customer_code == '0') {
                        $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master", ['mobile' => $post['shipper_phone'], 'email' => $post['shipper_email'], 'fax' => $post['shipper_fax'], 'customer_code' => $customer_code]);
                    } else {
                        $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master", ['mobile' => $post['shipper_phone'], 'email' => $post['shipper_email'], 'fax' => $post['shipper_fax']]);
                    }
                    $status = '1';
                } else {
                    if ($shipper_customer_code == "" || $shipper_customer_code == '0') {
                        $master['customer_code'] = $customer_code;
                    }
                    $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master", $master);
                    $status = '1';
                }
            } else {
                $conisgnee_id = "";
                $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code]);
                if ($chktype->num_rows() > 0) {
                    $conisgnee_id = $chktype->row()->id;
                }
                $master['party_types'] = $conisgnee_id;
                $master['created_on'] = $cdate;
                $master['customer_code'] = $customer_code;
                $ins = $this->db->insert("tbl_party_master", $master);
                $master_id = $this->db->insert_id();
                $status = '0';
            }
        } else {
            $conisgnee_id = "";
            $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", ['name' => 'Consignee', 'user_id' => $user_id]);
            if ($chktype->num_rows() > 0) {
                $conisgnee_id = $chktype->row()->id;
            }
            $master['party_types'] = $conisgnee_id;
            $master['created_on'] = $cdate;
            $master['customer_code'] = $customer_code;
            $ins = $this->db->insert("tbl_party_master", $master);
            $master_id = $this->db->insert_id();
            $country_code = $this->session->userdata("usr_tzone")['phone_code'];
            $year = date('y');
            $week = date('W');
            $shipper_id = $country_code . $year . $week . $master_id;
            $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master", ['code' => $shipper_id, 'customeridentifier' => $shipper_id]);
            $status = '0';
        }
        if ($order_id != "") {
            if ($master_id != '0') {
                $chk_address = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $master_id, 'status' => '1']);
                if ($chk_address->num_rows() > 0) {
                    $address_id = $chk_address->row()->id;
                    $upd_ar = [
                        'order_id' => $order_id,
                        'party_master_id' => $master_id,
                        'location_id' => $post['shipper_city'],
                        'street' => $post['shipper_street'],
                        'state' => $post['shipper_state'],
                        'address' => $address,
                        'pincode' => $post['shipper_zipcode'],
                        'country' => $post['shipper_country'],
                        'user_id' => $user_id
                    ];
                    $updaddress = $this->db->where(['id' => $address_id])->update("tbl_orderparty_address", $upd_ar);
                } else {
                    $insadd_ar = [
                        'order_id' => $order_id,
                        'party_master_id' => $master_id,
                        'location_id' => $post['shipper_city'],
                        'street' => $post['shipper_street'],
                        'state' => $post['shipper_state'],
                        'address' => $address,
                        'pincode' => $post['shipper_zipcode'],
                        'country' => $post['shipper_country'],
                        'user_id' => $user_id,
                        'status' => '1',
                        'createdon' => $cdate
                    ];
                    $updaddress = $this->db->insert("tbl_orderparty_address", $insadd_ar);
                }
            }
            $status = '1';
        }
        $arr = ['master_id' => $master_id, 'status' => $status, 'shipper_id' => $shipper_id];
        echo json_encode($arr);
    }

    public function getconsigneeID()
    {
        $user_id = 1;
        $parties = [];
        $code = $this->input->post('partytype_id');
        $user_id = $this->session->userdata('user_id');
        $custid = "0";
        $party_type = isset($_POST['type']) ? $_POST['type'] : "";
        $whr = "";
        $chkcompanycode = $this->session->userdata('company_code');
        if ($chkcompanycode != 'NZKN') {
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $subcusts = [];
            if ($custid != 0) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
                        // array_push($subcusts, $custid);
                    }
                } else {
                    $subcusts = $custid;
                    // array_push($subcusts, $custid);
                }
            }
            $customer_code = [];
            if (!empty($subcusts)) {
                $select = "code";
                $table = "tb_customers";
                $customerdetails = $this->Order->getcustomercodebyids($select, $table, $subcusts);
                if (!empty($customerdetails)) {
                    foreach ($customerdetails as $cust) {
                        $customer_code[] = $cust['code'];
                    }
                }
            }
            if (!empty($customer_code)) {
                $whr = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
            }
        }
        $party_type_whr = "";
        if ($party_type != "") {
            $party_type_whr = " AND p.name LIKE '" . $party_type . "' ";
        }
        $master_ids = [];
        $where = "m.code LIKE '%" . $code . "%' AND m.user_id='" . $user_id . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL  AND m.status='1' " . $party_type_whr . " " . $whr;
        $this->db->select("m.id,m.code");
        $this->db->from("tbl_party_master m");
        $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
        $this->db->where($where);
        $this->db->group_by('m.id');
        $this->db->order_by('m.id', 'DESC');
        $chkqry = $this->db->get();
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $master_ids[] = $res->id;
                $parties[] = ['id' => $res->id, 'party_id' => $res->code];
            }
        }
        $additional_ids = [];
        if (!empty($master_ids)) {
            $mwhr = "m.id NOT IN (" . implode(',', $master_ids) . ") AND ";
        } else {
            $mwhr = "";
        }
        $getmultipleparties = $this->db->query("SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE " . $mwhr . " m.code LIKE '%" . $code . "%'  AND m.user_id ='" . $user_id . "' AND m.party_types IS NOT NULL");
        if ($getmultipleparties->num_rows() > 0) {
            foreach ($getmultipleparties->result() as $res) {
                $party_types = explode(',', $res->party_types);
                if (!empty($party_types)) {
                    $chkshipper = $this->db->query("SELECT id FROM tbl_party_types WHERE id IN (" . implode(',', $party_types) . ") AND name LIKE '" . $party_type . "'");
                    if ($chkshipper->num_rows() > 0) {
                        $additional_ids[] = $res->master_id;
                    }
                }
            }
        }
        if (!empty($additional_ids)) {
            $get_addids = $this->db->query("SELECT m.id as master_id,m.code FROM tbl_party_master m WHERE m.id IN (" . implode(',', $additional_ids) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL AND m.user_id='" . $user_id . "' AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC");
            if ($get_addids->num_rows() > 0) {
                foreach ($get_addids->result() as $res) {
                    $master_ids[] = $res->master_id;
                    $parties[] = array('id' => $res->master_id, 'party_id' => $res->code);
                }
            }
        }
        echo json_encode($parties);
    }

    public function getconsigneedetailsbyID()
    {
        $user_id = 1;
        $parties = [];
        $code = $this->input->post('id');
        $this->db->select("id,name,email,street,location_id as city,state,mobile,pincode,country,code,fax");
        $this->db->from("tbl_party_master");
        $this->db->like("code", $code);
        $this->db->order_by("id", "DESC");
        $chkqry = $this->db->get();
        if ($chkqry->num_rows() > 0) {
            $parties[] = [
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->mobile,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->city,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state
            ];
        }
        echo json_encode($parties);
    }

    public function saveconsignee()
    {
        $post = $this->input->post();
        $master_id = "";
        $c_id = isset($post['consignee_row_id']) ? $post['consignee_row_id'] : "";
        $customer_code = isset($post['ccustomer_code']) ? $post['ccustomer_code'] : "0";
        $order_id = isset($post['consignee_orderrow_id']) ? $post['consignee_orderrow_id'] : "";
        $company_code = isset($post['consignee_company_code']) ? $post['consignee_company_code'] : "";
        $branch_code = isset($post['consignee_branch_code']) ? $post['consignee_branch_code'] : "";
        $user_id = $this->session->userdata('user_id');
        $cdate = date('Y-m-d H:i:s');
        $status = '1';
        if ($company_code == "") {
            $company_code = $this->session->userdata('company_code');
        }
        if ($branch_code == "") {
            $branch_code = $this->session->userdata('branch_code');
        }
        $user_id = $this->session->userdata('user_id');
        $sql = 'SELECT id FROM tbl_party_types WHERE name="Consignee" AND company_code LIKE ? ORDER BY created_on DESC';
        $chktype = $this->db->query($sql, [$company_code]);
        if ($chktype->num_rows() > 0) {
            $party_id = $chktype->row()->id;
        } else {
            $party = [
                'name' => 'Consignee',
                'description' => 'Consignee',
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'created_on' => $cdate,
                'user_id' => '1'
            ];
            $ins = $this->db->insert("tbl_party_types", $party);
            $party_id = $this->db->insert_id();
        }
        $code = $post['consignee_id'];
        if ($code == "") {
            $code = 0;
        }
        $address = $post['consignee_street'] . ',' . $post['consignee_city'] . ',' . $post['consignee_state'];
        $master = [
            'party_type_id' => $party_id,
            'name' => $post['consignee_name'],
            'email' => $post['consignee_email'],
            'street' => $post['consignee_street'],
            'state' => $post['consignee_state'],
            'mobile' => $post['consignee_phone'],
            'pincode' => $post['consignee_zipcode'],
            'country' => $post['consignee_country'],
            'code' => $code,
            'customeridentifier' => $code,
            'status' => '1',
            'fax' => $post['consignee_fax'],
            'address' => $address,
            'user_id' => $user_id,
            'location_id' => $post['consignee_city']
        ];
        if ($code != 0) {
            $consignee_id = $code;
            $chkmaster = $this->db->select('id,customer_code')->get_where("tbl_party_master", ['code' => $code]);
            if ($chkmaster->num_rows() > 0) {
                $master_id = $chkmaster->row()->id;
                $consginee_customer_code = $chkmaster->row()->customer_code;
                if ($order_id != "") {
                    if ($consginee_customer_code != "" && $consginee_customer_code != '0') {
                        $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master",
                            [
                                'mobile' => $post['consignee_phone'],
                                'email' => $post['consignee_email'],
                                'fax' => $post['consignee_fax'],
                                'customer_code' => $consginee_customer_code
                            ]
                        );
                    } else {
                        $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master",
                            [
                                'mobile' => $post['consignee_phone'],
                                'email' => $post['consignee_email'],
                                'fax' => $post['consignee_fax']
                            ]
                        );
                    }
                    $status = '1';
                } else {
                    if ($consginee_customer_code != "" && $consginee_customer_code != '0') {
                        $master['customer_code'] = $consginee_customer_code;
                    }
                    $upd = $this->db->where(['id' => $master_id])->update("tbl_party_master", $master);
                    $status = '1';
                }
            } else {
                if ($company_code != "") {
                    $master['company_code'] = $company_code;
                }
                if ($branch_code != "") {
                    $master['branch_code'] = $branch_code;
                }
                $custid = "0";
                if ($this->session->userdata('cust_id') !== FALSE) {
                    $custid = $this->session->userdata('cust_id');
                }
                $shipper_id = "";
                $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types",
                    ['name' => 'Shipper', 'user_id' => $user_id]);
                if ($chktype->num_rows() > 0) {
                    $shipper_id = $chktype->row()->id;
                }
                $master['party_types'] = $shipper_id;
                $master['created_on'] = $cdate;
                $master['customer_code'] = $customer_code;
                $ins = $this->db->insert("tbl_party_master", $master);
                $master_id = $this->db->insert_id();
                $status = '0';
            }
        } else {
            if ($company_code != "") {
                $master['company_code'] = $company_code;
            }
            if ($branch_code != "") {
                $master['branch_code'] = $branch_code;
            }
            $shipper_id = "";
            $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", ['name' => 'Shipper', 'user_id' => $user_id]);
            if ($chktype->num_rows() > 0) {
                $shipper_id = $chktype->row()->id;
            }
            $master['party_types'] = $shipper_id;
            $master['created_on'] = $cdate;
            $master['customer_code'] = $customer_code;
            $ins = $this->db->insert("tbl_party_master", $master);
            $master_id = $this->db->insert_id();
            $country_code = $this->session->userdata("usr_tzone")['phone_code'];
            $year = date('y');
            $week = date('W');
            $consignee_id = $country_code . $year . $week . $master_id;
            $upd = $this->db->where(array('id' => $master_id))->update("tbl_party_master", ['code' => $consignee_id, 'customeridentifier' => $consignee_id]);
            $status = '0';
        }
        if ($order_id != "") {
            if ($master_id != '0') {
                $chk_address = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $master_id, 'status' => '1']);
                if ($chk_address->num_rows() > 0) {
                    $address_id = $chk_address->row()->id;
                    $upd_ar = [
                        'order_id' => $order_id,
                        'party_master_id' => $master_id,
                        'location_id' => $post['consignee_city'],
                        'street' => $post['consignee_street'],
                        'state' => $post['consignee_state'],
                        'address' => $address,
                        'pincode' => $post['consignee_zipcode'],
                        'country' => $post['consignee_country'],
                        'user_id' => $user_id
                    ];
                    $updaddress = $this->db->where(['id' => $address_id])->update("tbl_orderparty_address", $upd_ar);
                } else {
                    $insadd_ar = [
                        'order_id' => $order_id,
                        'party_master_id' => $master_id,
                        'location_id' => $post['consignee_city'],
                        'street' => $post['consignee_street'],
                        'state' => $post['consignee_state'],
                        'address' => $address,
                        'pincode' => $post['consignee_zipcode'],
                        'country' => $post['consignee_country'],
                        'status' => '1',
                        'user_id' => $user_id,
                        'createdon' => $cdate
                    ];
                    $updaddress = $this->db->insert("tbl_orderparty_address", $insadd_ar);
                }
            }
            $status = '1';
        }
        $arr = ['master_id' => $master_id, 'status' => $status, 'consignee_id' => $consignee_id];
        echo json_encode($arr);
    }

    public function getinvolvedpartyId()
    {
        $user_id = $this->session->userdata('user_id');
        $parties = [];
        $code = $this->input->post('code');
        if ($user_id != "") {
            $custid = "0";
            $whr = "";
            $chkcompanycode = $this->session->userdata('company_code');
            if ($chkcompanycode != 'NZKN') {
                if ($this->session->userdata('cust_id') !== FALSE) {
                    $custid = $this->session->userdata('cust_id');
                }
                $subcusts = [];
                if ($custid != 0) {
                    if ($this->session->userdata('sub_cust') !== FALSE) {
                        $subcusts = $this->session->userdata('sub_cust');
                        if (count($subcusts) > 0) {
                            array_push($subcusts, $custid);
                        } else {
                            $subcusts = $custid;
                            // array_push($subcusts, $custid);
                        }
                    } else {
                        $subcusts = $custid;
                        // array_push($subcusts, $custid);
                    }
                }
                $customer_code = [];
                if (!empty($subcusts)) {
                    $select = "code";
                    $table = "tb_customers";
                    $customerdetails = $this->Order->getcustomercodebyids($select, $table, $subcusts);
                    if (!empty($customerdetails)) {
                        foreach ($customerdetails as $cust) {
                            $customer_code[] = $cust['code'];
                        }
                    }
                }
                if (!empty($customer_code)) {
                    $whr = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
                }
            }
            $sql = 'SELECT m.id,m.code FROM tbl_party_master m,tbl_party_types t
            WHERE t.id=m.party_type_id AND m.user_id=?
            AND m.code LIKE ? AND m.code IS NOT NULL AND m.code != "" AND m.code !=0
            AND m.company_code != "" AND m.company_code IS NOT NULL AND m.branch_code != ""
            AND m.branch_code IS NOT NULL ' . $whr . ' GROUP BY m.id ORDER BY m.created_on DESC';
            $chkqry = $this->db->query($sql, [$user_id, $code]);
            if ($chkqry->num_rows() > 0) {
                foreach ($chkqry->result() as $res) {
                    $parties[] = ['id' => $res->id, 'customeridentifier' => $res->code];
                }
            }
        }
        echo json_encode($parties);
    }

    public function getpartydetailsbyID()
    {
        $parties = [];
        $code = $this->input->post('id');
        $code_like = '%' . $code . '%';
        $sql = 'SELECT m.id,m.name,m.email,m.street,m.location_id as city,m.state,m.mobile,m.address,m.country,m.pincode,m.country,
        m.code,m.fax,t.id as partytype_id,t.name as role FROM tbl_party_master m,tbl_party_types t
        WHERE m.code LIKE ? AND t.id=m.party_type_id ORDER BY m.id DESC';
        $chkqry = $this->db->query($sql, [$code_like]);
        if ($chkqry->num_rows() > 0) {
            $parties[] = [
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->mobile,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->city,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'role' => $chkqry->row()->role,
                'partytype_id' => $chkqry->row()->partytype_id,
                'address' => $chkqry->row()->address,
                'country' => $chkqry->row()->country
            ];
        }
        echo json_encode($parties);
    }

    public function addinvolvedpartyfororder($order_id = NULL)
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $party_id = 0;
        $inner_id = $data = [];
        $user_id = $this->session->userdata('user_id');
        $company_code = isset($_POST['party_company_id']) ? $_POST['party_company_id'] : "";
        $branch_code = isset($_POST['party_branch_id']) ? $_POST['party_branch_id'] : "";
        if ($user_id != "") {
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $address = $post['street'] . ',' . $post['city'] . ',' . $post['city'];
            $party = [
                'customeridentifier' => $post['party_id'],
                'code' => $post['party_id'],
                'name' => $post['party_name'],
                'street' => $post['street'],
                'pincode' => $post['zipcode'],
                'country' => $post['country'],
                'state' => $post['state'],
                'mobile' => $post['mobile'],
                'fax' => $post['fax'],
                'email' => $post['email'],
                'created_on' => $cdate,
                'address' => $address,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'location_id' => $post['city']
            ];
            $role_id = 0;
            if ($post['role'] != "") {
                $getroleid = $this->db->select("id")->get_where("tbl_party_types", [
                        'name' => $post['role'],
                        'company_code' => $company_code,
                        'branch_code' => $branch_code,
                        'status' => 1,
                        'user_id' => $user_id
                    ]
                );
                if ($getroleid->num_rows() > 0) {
                    $role_id = $getroleid->row()->id;
                } else {
                    $getroleid_nobranch = $this->db->select("id")->get_where("tbl_party_types", ['name' => $post['role'], 'company_code' => $company_code, 'status' => 1, 'user_id' => $user_id]);
                    if ($getroleid_nobranch->num_rows() > 0) {
                        $role_id = $getroleid_nobranch->row()->id;
                    } else {
                        $ins_role = [
                            'name' => $post['role'],
                            'description' => $post['role'],
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'user_id' => $user_id,
                            'status' => '1',
                            'created_on' => $cdate
                        ];
                        $insqry = $this->db->insert("tbl_party_types", $ins_role);
                        $role_id = $this->db->insert_id();
                    }
                }
            }
            $party['party_type_id'] = $role_id;
            $party_type = "";
            $getpartytype = $this->db->select("name")->get_where("tbl_party_types", ['id' => $party_id]);
            if ($getpartytype->num_rows() > 0) {
                $party_type = $getpartytype->row()->name;
            }
            $parties = [
                'party_id' => $post['party_id'],
                'party_type' => $party_type,
                'name' => $post['party_name'],
                'street' => $post['street'],
                'zipcode' => $post['zipcode'],
                'city' => $post['city'],
                'country' => $post['country'],
                'state' => $post['state'],
                'mobile' => $post['mobile'],
                'fax' => $post['fax'],
                'emailid' => $post['email'],
                'action' => "<button id=" . $post['party_id'] . " class='btn btn-primary btn-xs editparties' onclick='editpartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $post['party_id'] . " class='btn btn-primary btn-xs deleteround' onclick='deletepartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>"
            ];
            $chk = $this->db->select('id')->get_where('tbl_party_master', ['code' => $post['party_id']]);
            if ($chk->num_rows() > 0) {
                $party_id = $chk->row()->id;
                $upd = $this->db->where(['id' => $party_id])->update("tbl_party_master", $party);
            } else {
                $ins = $this->db->insert("tbl_party_master", $party);
                $party_id = $this->db->insert_id();
            }
            if ($order_id != NULL) {
                $chk = $this->db->select('id,status')->get_where('tb_order_parties', ['party_id' => $party_id, 'order_id' => $order_id]);
                if ($chk->num_rows() > 0) {
                    $id = $chk->row()->id;
                    $status = $chk->row()->status;
                    if ($status == '1') {
                        echo "2";
                    } else if ($status == '0') {
                        $upd = $this->db->where(['id' => $id])->update('tb_order_parties', ['status' => '1']);
                        if ($upd) {
                            echo "1";
                        }
                    }
                    if ($role_id != "0") {
                        $upd = $this->db->where(['id' => $id])->update("tb_order_parties", ['party_type' => $role_id]);
                    }
                } else {
                    $getorder_number = $this->db->select("order_id")->get_where("tb_orders", ['id' => $order_id]);
                    $order_number = $getorder_number->row()->order_id;
                    $party_type = 1;
                    if ($role_id != "0") {
                        $party_type = $role_id;
                    } else {
                        $sql = 'SELECT party_type_id FROM tbl_party_master WHERE id=?';
                        $getpartytype = $this->db->query($sql, [$party_id]);
                        if ($getpartytype->num_rows() > 0) {
                            $party_type = $getpartytype->row()->party_type_id;
                        }
                    }
                    $order_ins = [
                        'party_id' => $party_id,
                        'order_id' => $order_id,
                        'createdon' => $cdate,
                        'status' => '1',
                        'party_type' => $party_type,
                        'order_number' => $order_number
                    ];
                    $ins = $this->db->insert("tb_order_parties", $order_ins);
                    if ($ins) {
                        echo "1";
                    } else {
                        echo "0";
                    }
                }
            }
        }
    }

    public function updateorder()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : '0';
        if ($order_id != "0") {
            $cdate = date('Y-m-d H:i:s');
            $user_id = $this->session->userdata('user_id');
            $booking_id = isset($_POST['booking_id']) ? $_POST['booking_id'] : "";
            $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : "";
            $branch_code = isset($_POST['branch_code']) ? $_POST['branch_code'] : "";
            $department_code = isset($_POST['department_code']) ? $_POST['department_code'] : "";
            $product = isset($_POST['product']) ? $_POST['product'] : "";
            $service = isset($_POST['service']) ? $_POST['service'] : "";
            $delivery_terms = isset($_POST['delivery_terms']) ? $_POST['delivery_terms'] : "";
            $modeof_trasnport = isset($_POST['modeof_trasnport']) ? $_POST['modeof_trasnport'] : "TL";
            $order_type = isset($_POST['order_type']) ? $_POST['order_type'] : "";
            $incoterm = isset($_POST['incoterm']) ? $_POST['incoterm'] : "";
            $shipment_id = isset($_POST['delivery_note']) ? $_POST['delivery_note'] : "";
            $container_no = isset($_POST['container_num']) ? $_POST['container_num'] : "";
            $porder = isset($_POST['purchase_order']) ? $_POST['purchase_order'] : "";
            $order_shipper_id = isset($_POST['order_shipper_id']) ? $_POST['order_shipper_id'] : "0";
            $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : "0";
            $pickup = isset($_POST['order_pickup_id']) ? $_POST['order_pickup_id'] : "0";
            if ($pickup == "" || $pickup == "0") {
                if ($customer_id != "" && $customer_id != "0") {
                    $getcustomerid = $this->db->select("id")->get_where("tb_customers", array('code' => $customer_id, 'user_id' => $user_id, 'status' => '1'));
                    if ($getcustomerid->num_rows() > 0) {
                        $pickup = $getcustomerid->row()->id;
                    }
                }
            }
            $notify_party = isset($_POST['notify_party']) ? $_POST['notify_party'] : "";
            $driver_pickup_instructions = isset($_POST['driver_pickup_instructions']) ? $_POST['driver_pickup_instructions'] : "";
            $driver_delivery_instructions = isset($_POST['driver_delivery_instructions']) ? $_POST['driver_delivery_instructions'] : "";
            if ($shipment_id != "") {
                $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "DQ" AND r.name=o.reference_id AND o.order_id=?';
                $upddq = $this->db->query($sql, [$order_id]);
                if ($upddq->num_rows() > 0) {
                    $this->db->where(['id' => $upddq->row()->id])->update('tb_order_references', ['ref_value' => $shipment_id]);
                } else {
                    $arr = ['order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate];
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            if ($company_code == 'AUKN' || $company_code == 'UKKN') {
                if ($container_no != "") {
                    $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "CTR" AND r.name=o.reference_id AND o.order_id=? ';
                    $upddq = $this->db->query($sql, [$order_id]);
                    if ($upddq->num_rows() > 0) {
                        $this->db->where(['id' => $upddq->row()->id])->update('tb_order_references', ['ref_value' => $container_no]);
                    } else {
                        $arr = ['order_id' => $order_id, 'reference_id' => 'CTR', 'ref_value' => $container_no, 'createdon' => $cdate];
                        $this->db->insert('tb_order_references', $arr);
                    }
                }
            }
            if ($driver_pickup_instructions != "") {
                $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "ORD_PIKINST" AND r.name=o.reference_id AND o.order_id=?';
                $updporder = $this->db->query($sql, [$order_id]);
                if ($updporder->num_rows() > 0) {
                    $this->db->where(['id' => $updporder->row()->id])->update('tb_order_references', ['ref_value' => $driver_pickup_instructions]);
                } else {
                    $arr = ['order_id' => $order_id, 'reference_id' => 'ORD_PIKINST', 'ref_value' => $driver_pickup_instructions, 'createdon' => $cdate];
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            if ($driver_delivery_instructions != "") {
                $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "ORD_DLVINST" AND r.name=o.reference_id AND o.order_id=?';
                $updporder = $this->db->query($sql, [$order_id]);
                if ($updporder->num_rows() > 0) {
                    $this->db->where(['id' => $updporder->row()->id])->update('tb_order_references', ['ref_value' => $driver_delivery_instructions]);
                } else {
                    $arr = ['order_id' => $order_id, 'reference_id' => 'ORD_DLVINST', 'ref_value' => $driver_delivery_instructions, 'createdon' => $cdate];
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            if ($porder != "") {
                $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "PO" AND r.name=o.reference_id AND o.order_id=?';
                $updporder = $this->db->query($sql, [$order_id]);
                if ($updporder->num_rows() > 0) {
                    $this->db->where(['id' => $updporder->row()->id])->update('tb_order_references', ['ref_value' => $porder]);
                } else {
                    $arr = ['order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate];
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            $goods_value = isset($_POST['goods_value']) ? $_POST['goods_value'] : "0.00";
            if ($goods_value == "") {
                $goods_value = 0.00;
            }
            $party_row_id = isset($_POST['order_party_row_id']) ? $_POST['order_party_row_id'] : "0";
            $reference_ids = isset($_POST['reference_ids']) ? $_POST['reference_ids'] : "0";
            $order_inv_row_id = isset($_POST['order_inv_row_id']) ? $_POST['order_inv_row_id'] : '0';
            $order_cargo_id = isset($_POST['order_cargo_id']) ? $_POST['order_cargo_id'] : "";
            $pickup = isset($_POST['order_pickup_id']) ? $_POST['order_pickup_id'] : "";
            $delivery = isset($_POST['order_drop_id']) ? $_POST['order_drop_id'] : "";
            $early_pickup = isset($_POST['early_pickup']) ? $_POST['early_pickup'] : "";
            $late_pickup = isset($_POST['late_pickup']) ? $_POST['late_pickup'] : "";
            $early_delivery = isset($_POST['early_delivery']) ? $_POST['early_delivery'] : "";
            $late_delivery = isset($_POST['late_delivery']) ? $_POST['late_delivery'] : "";
            $e_pickup = date('Y-m-d H:i:s');
            if ($early_pickup != "") {
                $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
            }
            if ($late_pickup != "") {
                $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
            } else {
                $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
            }
            $e_delivery = date('Y-m-d H:i:s');
            if ($early_delivery != "") {
                $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
            }
            if ($late_delivery != "") {
                $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
            } else {
                $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
            }
            $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = "";
            $drop_id = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $drop_state = $pickup_state = $drop_state = $pickup_address = $drop_address = "";
            $pickup_custid = $drop_custid = $pickup_id = 0;
            $drop_row_id = $shipper_party_id = $consignee_party_id = 0;

            $sql = 'SELECT p.id,p.party_type_id, p.name,p.code,o.id as order_party_id,o.party_type FROM tbl_party_master p
            INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1
            WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
            $chekparty = $this->db->query($sql, [$order_id]);

            if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                    if ($chktype->num_rows() > 0) {
                        if ($chktype->row()->name == "Consignee") {
                            $drop_row_id = $rr->id;
                            $drop_id = $rr->code;
                            $drop_name = $rr->name;
                            $drop_custid = $rr->code;
                            $consignee_party_id = $rr->order_party_id;
                        } else if ($chktype->row()->name == "Shipper") {
                            $pickup_id = $rr->id;
                            $pickup_custid = $rr->code;
                            $pickup_name = $rr->name;
                            $shipper_party_id = $rr->order_party_id;
                        }
                    }
                }
            }
            if ($pickup_id != $order_shipper_id) {
                if ($order_shipper_id != "0") {
                    $sql = 'SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id=?';
                    $getshippercustid = $this->db->query($sql, [$order_shipper_id]);
                    if ($getshippercustid->num_rows() > 0) {
                        $pickup_custid = $getshippercustid->row()->code;
                        $pickup_name = $getshippercustid->row()->name;
                        $pickup_state = $getshippercustid->row()->state;
                        $pickup_address = $getshippercustid->row()->address;
                        $pickup_country = $getshippercustid->row()->country;
                        $pickup_street = $getshippercustid->row()->street;
                        $pickup_pincode = $getshippercustid->row()->pincode;
                        $pickup_city = $getshippercustid->row()->city;
                        if ($pickup_id != 0) {
                            if ($shipper_party_id != 0) {
                                $chkorder_sparty = $this->db->select("id")->get_where("tb_order_parties", ['id' => $shipper_party_id]);
                                if ($chkorder_sparty->num_rows() > 0) {
                                    $upd_sparty_address = $this->db->where(['id' => $shipper_party_id])->update("tb_order_parties", ['status' => '0']);
                                }
                            }
                            $chkprevious_shipperaddress = $this->db->select('id')->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $pickup_id, 'status' => '1']);
                            if ($chkprevious_shipperaddress->num_rows() > 0) {
                                $upd_oldsaddress = $this->db->where(['id' => $chkprevious_shipperaddress->row()->id])->update("tbl_orderparty_address", ['status' => '0']);
                            }
                        }
                        $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1']);
                        $shipper_address = ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id, 'status' => '1'];
                        if ($chkpartyaddress->num_rows() > 0) {
                            $pickup_addressid = $chkpartyaddress->row()->id;
                            $upd = $this->db->where(['id' => $pickup_addressid])->update("tbl_orderparty_address", $shipper_address);
                        } else {
                            $shipper_address['createdon'] = $cdate;
                            $this->db->insert("tbl_orderparty_address", $shipper_address);
                        }
                    }
                }
            } else if ($order_shipper_id == $pickup_id) {
                if ($order_shipper_id != 0) {
                    $chk_shipperaddress = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1']);
                    if ($chk_shipperaddress->num_rows() > 0) {
                        $pickup_city = $chk_shipperaddress->row()->location_id;
                        $pickup_country = $chk_shipperaddress->row()->country;
                        $pickup_street = $chk_shipperaddress->row()->street;
                        $pickup_pincode = $chk_shipperaddress->row()->pincode;
                        $pickup_state = $chk_shipperaddress->row()->state;
                        $pickup_address = $chk_shipperaddress->row()->address;
                    }
                }
            }
            if ($drop_row_id != $delivery) {
                if ($delivery != "0") {
                    $sql = 'SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id=?';
                    $getdropcustid = $this->db->query($sql, [$delivery]);
                    if ($getdropcustid->num_rows() > 0) {
                        $drop_id = $delivery;
                        $drop_custid = $getdropcustid->row()->code;
                        $drop_name = $getdropcustid->row()->name;
                        $drop_state = $getdropcustid->row()->state;
                        $drop_address = $getdropcustid->row()->address;
                        $drop_country = $getdropcustid->row()->country;
                        $drop_street = $getdropcustid->row()->street;
                        $drop_pincode = $getdropcustid->row()->pincode;
                        $drop_city = $getdropcustid->row()->city;
                        if ($drop_row_id != 0) {
                            $chkprevious_dropaddress = $this->db->select('id')->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $drop_row_id, 'status' => '1']);
                            if ($chkprevious_dropaddress->num_rows() > 0) {
                                $upd_olddaddress = $this->db->where(['id' => $chkprevious_dropaddress->row()->id])->update("tbl_orderparty_address", ['status' => '0']);
                            }
                        }
                        if ($consignee_party_id != '0') {
                            $chkorder_cparty = $this->db->select("id")->get_where("tb_order_parties", ['id' => $shipper_party_id]);
                            if ($chkorder_cparty->num_rows() > 0) {
                                $upd_cparty_address = $this->db->where(['id' => $consignee_party_id])->update("tb_order_parties", ['status' => '0']);
                            }
                        }
                        $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1']);
                        $drop_address = ['order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id, 'status' => '1'];
                        if ($chkpartyaddress->num_rows() > 0) {
                            $drop_addressid = $chkpartyaddress->row()->id;
                            $upd = $this->db->where(['id' => $drop_addressid])->update("tbl_orderparty_address", $drop_address);
                        } else {
                            $drop_address['createdon'] = $cdate;
                            $this->db->insert("tbl_orderparty_address", $drop_address);
                        }
                    }
                }
            } else if ($drop_row_id == $delivery) {
                if ($delivery != 0) {
                    $chkdrop = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1']);
                    if ($chkdrop->num_rows() > 0) {
                        $drop_city = $chkdrop->row()->location_id;
                        $drop_state = $chkdrop->row()->state;
                        $drop_country = $chkdrop->row()->country;
                        $drop_street = $chkdrop->row()->street;
                        $drop_pincode = $chkdrop->row()->pincode;
                        $drop_address = $chkdrop->row()->address;
                    }
                }
            }
            if ($order_shipper_id != "" || $order_shipper_id != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id]);
                    if ($chk1->num_rows() > 0) {
                        $party_type = $chk1->row()->id;
                    }
                }
                $chkparty = $this->db->select("id")->get_where("tb_order_parties", ['order_id' => $order_id, 'party_type' => $party_type, 'party_id' => $order_shipper_id, 'status' => '1']);
                if ($chkparty->num_rows() == 0) {
                    $party = ['order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
                    $ins_party = $this->db->insert("tb_order_parties", $party);
                }
            }
            if ($delivery != "" || $delivery != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id]);
                    if ($chk1->num_rows() > 0) {
                        $party_type = $chk1->row()->id;
                    }
                }
                $chkparty = $this->db->select("id")->get_where("tb_order_parties", ['order_id' => $order_id, 'party_type' => $party_type, 'party_id' => $delivery, 'status' => '1']);
                if ($chkparty->num_rows() == 0) {
                    $party = ['order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
                    $ins_party = $this->db->insert("tb_order_parties", $party);
                }
            }
            $ship_row_id = 0;
            $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
            $tid = $tname = "";
            $sql = 'SELECT id,name FROM tb_transportmode WHERE code LIKE ?';
            $gettrasnportmode = $this->db->query($sql, [$modeof_trasnport]);
            if ($gettrasnportmode->num_rows() > 0) {
                $tid = $gettrasnportmode->row()->id;
                $tname = $gettrasnportmode->row()->name;
            }
            $ship_arr = [
                'unitspec' => 1,
                'shipid' => $shipment_id,
                'txnid' => $shipment_id,
                'trucktype' => $tname,
                'pickupcnt' => '1',
                'dropcnt' => '1',
                'insertusr' => $pickup_custid,
                'carrier' => '0',
                'insertuserdate' => $cdate,
                'enddate' => $enddate,
                'insdate' => $cdate,
                'upddate' => $cdate,
                'reason' => 'SHIPMENT',
                'purpose' => 'SEND INTEGRATION',
                'ship_object' => 'SHIPMENT',
                'logdate' => $cdate,
                'transport_mode' => $modeof_trasnport,
                'domainname' => $branch_code,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'product' => $product,
                'freight_term' => '60',
                'freight_termname' => 'Free of Charge',
                'incoterm' => $incoterm,
                'modeoftransport' => $tid
            ];
            $sql = 'SELECT id FROM tb_shipments WHERE shipid LIKE ?';
            $chk_shipid = $this->db->query($sql, [$shipment_id]);
            if ($chk_shipid->num_rows() > 0) {
                $ship_row_id = $chk_shipid->row()->id;
                $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
            } else {
                $ship_arr['createdon'] = $cdate;
                $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
                $ship_row_id = $this->db->insert_id();
            }
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $curtz);
            $e_pickup = $getpickup['datetime'];
            $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $curtz);
            $l_pickup = $getlpickup['datetime'];
            $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $curtz);
            $e_delivery = $getdelivery['datetime'];
            $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $curtz);
            $l_delivery = $getldelivery['datetime'];
            $ins = [
                'shipment_id' => $ship_row_id,
                'product' => $product,
                'pickup_datetime' => $e_pickup,
                'delivery_datetime' => $e_delivery,
                'pickup_endtime' => $l_pickup,
                'drop_endtime' => $l_delivery,
                'goods_value' => $goods_value,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'transport_mode' => $modeof_trasnport,
                'updatedon' => date('Y-m-d H:i:s')
            ];
            if ($pickup_name != "") {
                $ins['pickup_company'] = $pickup_name;
            }
            if ($pickup_country != "") {
                $ins['pickup_country'] = $pickup_country;
            }
            if ($drop_name != "") {
                $ins['delivery_company'] = $drop_name;
            }
            if ($drop_country != "") {
                $ins['delivery_country'] = $drop_country;
            }
            if ($pickup_street != "") {
                $ins['pickup_address1'] = $pickup_street;
            }
            if ($pickup_city != "") {
                $ins['pickup_city'] = $pickup_city;
            }
            if ($pickup_pincode != "") {
                $loc = [];
                $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
                $loc = getlatlngsbyplace($add1);
                $ins['plat'] = @$loc[0];
                $ins['plng'] = @$loc[1];
                $ins['pickup_pincode'] = $pickup_pincode;
            }
            if ($pickup_state != "") {
                $ins['pickup_address2'] = $pickup_state;
            }
            if ($drop_street != "") {
                $ins['delivery_address1'] = $drop_street;
            }
            if ($drop_state != "") {
                $ins['delivery_address2'] = $drop_state;
            }
            if ($drop_city != "") {
                $ins['delivery_city'] = $drop_city;
            }
            if ($pickup != "" && $pickup != "") {
                $ins['customer_id'] = $pickup;
            }
            if ($drop_pincode != "") {
                $loc = [];
                $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
                $loc = getlatlngsbyplace($add2);
                $ins['dlat'] = @$loc[0];
                $ins['dlng'] = @$loc[1];
                $ins['delivery_pincode'] = $drop_pincode;
                $ins['delivery_pincode'] = $drop_pincode;
            }
            $this->db->where(['id' => $order_id])->update('tb_orders', $ins);
            $details_ins = [
                'service' => $service,
                'delivery_term' => $delivery_terms,
                'incoterm' => $incoterm,
                'purchase_order' => $porder,
                'notify_party' => $notify_party,
                'lane_reference' => "LR",
                'distance' => '0',
                'department_code' => $department_code,
                'temperature_control' => '0',
                'valorance_insurance' => '0',
                'high_cargo_value' => '0',
                'customs_required' => '0',
                'order_type' => $order_type
            ];
            $chk = $this->db->select("id")->get_where("tb_order_details", ['order_row_id' => $order_id]);
            if ($chk->num_rows() > 0) {
                $upd_details = $this->db->where(['order_row_id' => $order_id])->update("tb_order_details", $details_ins);
            } else {
                $details_ins['createdon'] = $cdate;
                $details_ins['order_row_id'] = $order_id;
                $details_ins['order_id'] = $booking_id;
                $ins = $this->db->insert("tb_order_details", $details_ins);
            }
            $total_weight = $total_volume = $total_quantity = 0;
            $sql = 'SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id=? AND status =1';
            $gettotal = $this->db->query($sql, [$order_id]);

            if ($gettotal->num_rows() > 0) {
                $total_volume = $gettotal->row()->total_volume;
                $total_weight = $gettotal->row()->total_weight;
                $total_quantity = $gettotal->row()->total_quantity;
            }
            $upd_order = $this->db->where(['id' => $order_id])->update("tb_orders", ['volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity]);
            $this->ordernotify('booking_edit', $order_id);
        }
        if ($order_id != "" && $order_id != '0') {
            redirect('amzorders/orderslist/' . $order_id);
        } else {
            redirect('amzorders');
        }
    }

    public function insertinvolvedparties($id = NULL)
    {

        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $party_id = 0;
        $ins_ar = $inner_id = $data = [];

        $user_id = $this->session->userdata('user_id');
        $order_id = isset($_POST['party_order_id']) ? $_POST['party_order_id'] : "0";
        if ($user_id != "") {
            $custid = "0";
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');

            $address = $post['street'] . ',' . $post['city'] . $post['state'];
            $party = [
                'customeridentifier' => $post['party_id'],
                'code' => $post['party_id'],
                'name' => $post['party_name'],
                'street' => $post['street'],
                'pincode' => $post['zipcode'],
                'country' => $post['country'],
                'state' => $post['state'],
                'mobile' => $post['mobile'],
                'fax' => $post['fax'],
                'email' => $post['email'],
                'created_on' => $cdate,
                'address' => $address,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'user_id' => $user_id,
                'location_id' => $post['city']
            ];
            $party_type = "";
            $getpartyname = $this->db->select("name")->get_where("tbl_party_types", ['id' => $post['party_id']]);
            if ($getpartyname->num_rows() > 0) {
                $party_type = $getpartyname->row()->name;
            }

            $parties = [
                'party_id' => $post['party_id'],
                'party_type' => $post['role'],
                'name' => $post['party_name'],
                'street' => $post['street'],
                'zipcode' => $post['zipcode'],
                'city' => $post['city'],
                'country' => $post['country'],
                'state' => $post['state'],
                'mobile' => $post['mobile'],
                'fax' => $post['fax'],
                'emailid' => $post['email'],
                'action' => "<button id=" . $post['party_id'] . " class='btn btn-primary btn-xs editparties' onclick='editpartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $post['party_id'] . " class='btn btn-primary btn-xs deleteround' onclick='deletepartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>"
            ];
            $role_id = 0;
            if ($post['role'] != '') {
                $getroleid = $this->db->select("id")->get_where("tbl_party_types", ['name' => $post['role'], 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 1, 'user_id' => $user_id]);
                if ($getroleid->num_rows() > 0) {
                    $role_id = $getroleid->row()->id;
                } else {
                    $getroleid_nobranch = $this->db->select("id")->get_where("tbl_party_types", ['name' => $post['role'], 'company_code' => $company_code, 'status' => 1, 'user_id' => $user_id]);
                    if ($getroleid_nobranch->num_rows() > 0) {
                        $role_id = $getroleid_nobranch->row()->id;
                    } else {
                        $ins_role = ['name' => $post['role'], 'description' => $post['role'], 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id, 'status' => '1', 'created_on' => $cdate];
                        $insqry = $this->db->insert("tbl_party_types", $ins_ar);
                        $role_id = $this->db->insert_id();
                    }
                }
            }
            if ($id == NULL) {
                if ($custid != "0") {
                    $getcustomer_code = $this->db->select("code")->get_where("tb_customers", ['id' => $custid]);
                    if ($getcustomer_code->num_rows() > 0) {
                        $party['customer_code'] = $getcustomer_code->row()->code;
                    }
                }
                $chk = $this->db->select('id')->get_where('tbl_party_master', ['code' => $post['party_id']]);
                if ($chk->num_rows() > 0) {
                    $party_id = $chk->row()->id;
                    $upd = $this->db->where(['id' => $party_id])->update("tbl_party_master", $party);
                } else {

                    $party['party_type_id'] = $role_id;
                    $ins = $this->db->insert("tbl_party_master", $party);
                    $party_id = $this->db->insert_id();
                }

                $data = array('party_id' => $party_id);
            } else {
                $party_id = $id;
                $upd = $this->db->where(['id' => $party_id])->update("tbl_party_master", $party);
                if ($order_id != "0") {
                    $chkorderparty = $this->db->select("id")->get_where("tb_order_parties", ['order_id' => $order_id, 'party_id' => $party_id]);
                    if ($chkorderparty->num_rows() > 0) {
                        $rowid = $chkorderparty->row()->id;
                        if ($role_id != "0") {
                            $upd = $this->db->where(['id' => $rowid])->update("tb_order_parties", ['party_type' => $role_id]);
                        }
                    }
                }
                $data = ['party_id' => $party_id];
            }
            echo json_encode($data);
        }
    }

    public function getorderinvolvedparties()
    {
        $user_id = $this->session->userdata('user_id');
        $parties = [];
        $order_id = isset($_REQUEST['order_id']) ? $_REQUEST['order_id'] : "";
        $cust_id = $this->session->userdata("cust_id");
        if ($order_id != "") {
            $sql = 'SELECT m.id as party_master_id,m.name as username,m.email as emailid,m.mobile as mobile,m.location_id as city,
            m.state,m.street as street,m.pincode as zipcode,m.country,m.partyindetifier,m.code,m.fax,p.name,p.id as party_type_id,
            p.name as party_name,p.company_code,p.branch_code,t.id as party_id
            FROM tbl_party_master m,tbl_party_types p,tb_order_parties t
            WHERE t.order_id=? AND t.status =1 AND m.id=t.party_id AND t.party_type=p.id GROUP BY t.party_type ORDER BY m.id DESC';
            $getparties = $this->db->query($sql, [$order_id]);
            if ($getparties->num_rows() > 0) {
                foreach ($getparties->result() as $res) {
                    $id = '"' . $res->party_master_id . '"';
                    $code = '"' . $res->code . '"';
                    $name = '"' . $res->username . '"';
                    $street = '"' . $res->street . '"';
                    $emailid = '"' . $res->emailid . '"';
                    $state = '"' . $res->state . '"';
                    $country = '"' . $res->country . '"';
                    $fax = '"' . $res->fax . '"';
                    $city = '"' . $res->city . '"';
                    $role = '"' . $res->party_name . '"';
                    $mobile = '"' . $res->mobile . '"';
                    $res->zipcode = '"' . $res->zipcode . '"';
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowPartyEdit(this," . $id . "," . $code . "," . $name . "," . $street . "," . $emailid . "," . $mobile . "," . $state . "," . $country . "," . $res->zipcode . "," . $fax . "," . $city . "," . $role . "," . $order_id . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletepartydetailswithorder(" . $id . ");'><span class='glyphicon glyphicon-trash'> </span>Remove<li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddParty(this);'><span class='glyphicon glyphicon-plus' > </span>Add Parties</a></li></ul></li></ul>";
                    if ($cust_id == "") {
                        $parties[] = [
                            'id' => $res->party_master_id,
                            'party_id' => $res->code,
                            'street' => $res->street,
                            'party_type' => $res->party_name,
                            'name' => $res->name,
                            'username' => $res->username,
                            'email' => $res->emailid,
                            'mobile' => $res->mobile,
                            'zipcode' => $res->zipcode,
                            'street' => $res->street,
                            'customeridentifier' => $res->code,
                            'partyindetifier' => $res->partyindetifier,
                            'fax' => $res->fax,
                            'code' => $res->code,
                            'name' => $res->name,
                            'city' => $res->city,
                            'state' => $res->state,
                            'country' => $res->country,
                            'company_code' => $res->company_code,
                            'branch_code' => $res->branch_code,
                            'action' => $action
                        ];
                    } else {
                        if (strtoupper($res->party_name) != 'CARRIER') {
                            $parties[] = [
                                'id' => $res->party_master_id,
                                'party_id' => $res->code,
                                'street' => $res->street,
                                'party_type' => $res->party_name,
                                'name' => $res->name,
                                'username' => $res->username,
                                'email' => $res->emailid,
                                'mobile' => $res->mobile,
                                'zipcode' => $res->zipcode,
                                'street' => $res->street,
                                'customeridentifier' => $res->code,
                                'partyindetifier' => $res->partyindetifier,
                                'fax' => $res->fax,
                                'code' => $res->code,
                                'name' => $res->name,
                                'city' => $res->city,
                                'state' => $res->state,
                                'country' => $res->country,
                                'company_code' => $res->company_code,
                                'branch_code' => $res->branch_code,
                                'action' => $action
                            ];
                        }
                    }
                }
            }
        }
        echo json_encode($parties);
    }

    public function showinvolvedparties()
    {
        $user_id = $this->session->userdata('user_id');
        $parties = $ids = [];
        $party_row_id = isset($_POST['party_row_id']) ? $_POST['party_row_id'] : "";
        if ($party_row_id != "") {
            $ids = implode(',', $party_row_id);
            if (!empty($ids)) {

                $getparties = $this->db->query("SELECT m.id as party_master_id,m.name as username,m.email as emailid,
                m.mobile as mobile,m.location_id as city,m.state,m.street as street,m.pincode as zipcode,m.country,
                m.partyindetifier,m.code,m.fax,m.code,p.id as party_type_id,p.name as party_type,p.company_code,p.branch_code
                FROM tbl_party_master m,tbl_party_types p WHERE m.id IN (" . $ids . ")
                AND m.party_type_id=p.id GROUP BY m.id ORDER BY m.id DESC");
                if ($getparties->num_rows() > 0) {
                    foreach ($getparties->result() as $res) {
                        $id = '"' . $res->party_master_id . '"';
                        $code = '"' . $res->code . '"';
                        $name = '"' . $res->username . '"';
                        $street = '"' . $res->street . '"';
                        $emailid = '"' . $res->emailid . '"';
                        $state = '"' . $res->state . '"';
                        $country = '"' . $res->country . '"';
                        $fax = '"' . $res->fax . '"';
                        $city = '"' . $res->city . '"';
                        $role = '"' . $res->party_type . '"';
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowPartyEdit(this," . $id . "," . $code . "," . $name . "," . $street . "," . $emailid . "," . $res->mobile . "," . $state . "," . $country . "," . $res->zipcode . "," . $fax . "," . $city . "," . $role . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowPartyElim(this," . $id . ");'><span class='glyphicon glyphicon-trash'> </span>Remove<li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddParty(this);'><span class='glyphicon glyphicon-plus' > </span>Add Parties</a></li></ul></li></ul>";
                        $parties[] = [
                            'party_id' => $res->code,
                            'party_type' => $res->party_type,
                            'party_type_id' => $res->party_type_id,
                            'street' => $res->street,
                            'username' => $res->username,
                            'email' => $res->emailid,
                            'mobile' => $res->mobile,
                            'zipcode' => $res->zipcode,
                            'street' => $res->street,
                            'customeridentifier' => $res->code,
                            'partyindetifier' => $res->partyindetifier,
                            'fax' => $res->fax,
                            'code' => $res->code,
                            'city' => $res->city,
                            'state' => $res->state,
                            'country' => $res->country,
                            'company_code' => $res->company_code,
                            'branch_code' => $res->branch_code,
                            'action' => $action
                        ];
                    }
                }
            }
        }
        echo json_encode($parties);
    }

    public function editpartydetails()
    {
        $id = $this->input->post('id');
        $parties = [];
        $chk = $this->db->select('id')->get_where("tbl_party_master", ['id' => $id]);
        if ($chk->num_rows() > 0) {
            $sql = 'SELECT m.id,m.party_type_id,m.name,m.email,m.mobile,m.location_id,m.street,m.state,m.fax,m.address,m.pincode,m.country,
            m.user_id,m.customeridentifier,p.id as party_type_id FROM tbl_party_master m,tbl_party_types p
            WHERE m.id=? AND p.id=m.party_type_id ORDER BY m.id DESC';
            $get_parties = $this->db->query($sql, [$id]);
            if ($get_parties->num_rows() > 0) {
                $parties = [
                    'name' => $get_parties->row()->name,
                    'street' => $get_parties->row()->street,
                    'zipcode' => $get_parties->row()->pincode,
                    'city' => $get_parties->row()->location_id,
                    'country' => $get_parties->row()->country,
                    'state' => $get_parties->row()->state,
                    'phone' => $get_parties->row()->mobile,
                    'email' => $get_parties->row()->email,
                    'fax' => $get_parties->row()->fax,
                    'code' => $get_parties->row()->customeridentifier,
                    'type_id' => $get_parties->row()->party_type_id
                ];
            }
        }
        echo json_encode($parties);
    }

    public function additem()
    {
        $cdate = date('y-m-d H:i:s');
        $post = $this->input->post();
        $item_id = $post['item_id'];
        $item_name = $post['item_name'];
        $description = $post['description'];
        $user_id = $this->session->userdata('user_id');
        $length = isset($post['length']) ? $post['length'] : "0";
        $width = isset($post['width']) ? $post['width'] : "0";
        $weight = isset($post['weight']) ? $post['weight'] : "0";
        $height = isset($post['height']) ? $post['height'] : "0";
        $volume = isset($post['volume']) ? $post['volume'] : "0";
        $volumentric_weight = isset($post['volumentric_weight']) ? $post['volumentric_weight'] : "0";
        if ($length == "") {
            $length = 0;
        }
        if ($width == "") {
            $width = 0;
        }
        if ($weight == "") {
            $weight = 0;
        }
        if ($height == "") {
            $height = 0;
        }
        if ($volume == "") {
            $volume = 0;
        }
        if ($volumentric_weight == "") {
            $volumentric_weight = 0;
        }
        $ins_ar = [
            'item_id' => $item_id,
            'item_name' => $item_name,
            'description' => $description,
            'status' => '1',
            'createdby' => $user_id,
            'length' => $length,
            'length_unit' => $post['length_uom'],
            'width' => $width,
            'width_unit' => $post['width_uom'],
            'weight' => $weight,
            'weight_unit' => $post['weight_uom'],
            'height' => $height,
            'height_unit' => $post['height_uom'],
            'volume' => $volume,
            'volume_unit' => $post['volume_uom'],
            'volumetric_weight' => $volumentric_weight,
            'volweight_uom' => $post['volumeticweight_uom']
        ];
        $chk = $this->db->select('id')->get_where('tb_items', $ins_ar);
        if ($chk->num_rows() == 0) {
            $ins = $this->db->insert('tb_items', $ins_ar);
            if ($ins) {
                $ins_id = $this->db->insert_id();
                $ins_type = 'ins';
            } else {
                $ins_id = 0;
                $ins_type = '';
            }
        } else {
            $ins_id = $chk->row()->id;
            $ins_type = 'upd';
        }
        $res = ['id' => $ins_id, 'ins' => $ins_type];
        echo json_encode($res);
    }

    public function getitemid()
    {
        $post = $this->input->post();
        $term = $post['term'];
        $result = [];
        $whr = "";
        $outer_cargo = isset($_POST['outer_cargo']) ? $_POST['outer_cargo'] : "";
        if ($outer_cargo != "") {
            $whr .= " AND item_id NOT LIKE '" . $outer_cargo . "' ";
        }
        $whr1 = $whr2 = "";
        if ($this->session->userdata('cust_id') !== FALSE) {
            $custid = $this->session->userdata('cust_id');
            $ironmountain_ids = ['415', '187', '188', '192', '226', '428', '431', '430', '426', '427', '418', '417', '429', '419', '423', '416', '422', '425', '420', '424', '489', '421'];
            if ($custid != "" && $custid != '0') {
                if (in_array($custid, $ironmountain_ids)) {
                    $whr1 = "AND item_id IN ('Docs','Non-Docs') ";
                }
                $company_code = $this->session->userdata('company_code');
                if ($company_code == "NZKN") {
                    $whr2 = " AND description LIKE 'APPLIANCES' ";
                }
            }
        }
        $getitemname = $this->db->query("SELECT id,item_id FROM tb_items WHERE item_id LIKE '%" . $term . "%' " . $whr . " " . $whr1 . " " . $whr2 . " ORDER BY createdon DESC");
        if ($getitemname->num_rows() > 0) {
            foreach ($getitemname->result() as $res) {
                $result[] = ['id' => $res->id, 'item_id' => $res->item_id];
            }
        }
        echo json_encode($result);
    }

    public function searchviewitem()
    {
        $post = $this->input->post();
        $term = $post['term'];
        $result = [];
        $getitemname = $this->db->query("SELECT * FROM tb_items WHERE item_id LIKE '%" . $term . "%' GROUP BY id ORDER BY createdon DESC");
        if ($getitemname->num_rows() > 0) {
            foreach ($getitemname->result() as $res) {
                $check = "<input type='radio' name='listitem' id='listitem_" . $res->id . "' class='listitem' onchange='selectitem(" . $res->id . ")' value='" . $res->id . "'>";
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'item_id' => $res->item_id,
                    'item_name' => $res->item_name,
                    'description' => $res->description,
                    'length' => $res->length . $res->length_unit,
                    'width' => $res->width . $res->width_unit,
                    'height' => $res->height . $res->height_unit,
                    'weight' => $res->weight . $res->weight_unit,
                    'volume' => $res->volume . $res->volume_unit,
                    'volumetric_weight' => $res->volumetric_weight . $res->volweight_uom
                ];
            }
        }
        echo json_encode($result);
    }

    public function finditembyid()
    {
        $post = $this->input->post();
        $term = $post['item'];
        $result = [];
        $getitemname = $this->db->query("SELECT * FROM tb_items WHERE item_id LIKE '%" . $term . "%' GROUP BY id ORDER BY createdon DESC");
        if ($getitemname->num_rows() > 0) {
            foreach ($getitemname->result() as $res) {
                $check = "<input type='radio' name='listitem' id='listitem_" . $res->id . "' class='listitem' onchange='selectitem(" . $res->id . ")' value='" . $res->item_id . "'>";
                $result[] = [
                    'check' => $check,
                    'id' => $res->id,
                    'item_id' => $res->item_id,
                    'item_name' => $res->item_name,
                    'description' => $res->description,
                    'length' => $res->length . $res->length_unit,
                    'width' => $res->width . $res->width_unit,
                    'height' => $res->height . $res->height_unit,
                    'weight' => $res->weight . $res->weight_unit,
                    'volume' => $res->volume . $res->volume_unit
                ];
            }
        }
        echo json_encode($result);
    }

    public function viewitemslist()
    {
        $items = [];
        $type = isset($_POST['ctype']) ? $_POST['ctype'] : "";
        $popup = isset($_POST['popup']) ? $_POST['popup'] : "";
        $whr = "";
        if ($type != "") {
            $whr .= " AND item_id NOT LIKE '%" . $type . "%'";
        }
        $check = $whr1 = $whr2 = "";
        if ($this->session->userdata('cust_id') !== FALSE) {
            $custid = $this->session->userdata('cust_id');
            $ironmountain_ids = ['415', '187', '188', '192', '226', '428', '431', '430', '426', '427', '418', '417', '429', '419', '423', '416', '422', '425', '420', '424', '489', '421'];
            if ($custid != "" && $custid != '0') {
                if (in_array($custid, $ironmountain_ids)) {
                    $whr1 = "AND item_id IN ('Docs','Non-Docs') ";
                }
                $company_code = $this->session->userdata('company_code');
                if ($company_code == 'NZKN') {
                    $whr2 = " AND description LIKE 'APPLIANCES' ";
                }
            }
        }
        $qry = $this->db->query("SELECT * FROM tb_items WHERE status='1'" . $whr . " " . $whr1 . " " . $whr2 . "  GROUP BY id ORDER BY id DESC");
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $check = "<input type='radio' name='listitem' id='listitem_" . $res->id . "' class='listitem' onchange='selectitem(" . $res->id . ")' value='" . $res->id . "'>";
                $items[] = [
                    'check' => $check,
                    'item_name' => $res->item_name,
                    'item_id' => $res->item_id,
                    'description' => $res->description,
                    'length' => $res->length . $res->length_unit,
                    'width' => $res->width . $res->width_unit,
                    'height' => $res->height . $res->height_unit,
                    'weight' => $res->weight . $res->weight_unit,
                    'volume' => $res->volume . $res->volume_unit,
                    'volumentric_weight' => $res->volumetric_weight . $res->volweight_uom
                ];
            }
        }
        echo json_encode($items);
    }

    public function getitemdetailsbyId()
    {
        $items = [];
        $item_id = $_POST['item_id'];
        $sql = 'SELECT * FROM tb_items WHERE status=1 and item_id LIKE ? ORDER BY createdon DESC';
        $qry = $this->db->query($sql, [$item_id]);
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $items[] = [
                    'item_name' => $res->item_name,
                    'item_id' => $res->item_id,
                    'description' => $res->description,
                    'length' => $res->length,
                    'length_uom' => $res->length_unit,
                    'width' => $res->width,
                    'width_uom' => $res->width_unit,
                    'height' => $res->height,
                    'height_uom' => $res->height_unit,
                    'weight' => $res->weight,
                    'weight_uom' => $res->weight_unit,
                    'volume' => $res->volume,
                    'volume_uom' => $res->volume_unit
                ];
            }
        }
        echo json_encode($items);
    }

    public function getitemdetailslist()
    {
        $items = [];
        $item_id = isset($_POST['item_id']) ? $_POST['item_id'] : "";
        if ($item_id != "") {
            $sql = 'SELECT * FROM tb_items WHERE status=1 and id = ? ORDER BY createdon DESC';
            $qry = $this->db->query($sql, [$item_id]);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $items[] = [
                        'item_name' => $res->item_name,
                        'item_id' => $res->item_id,
                        'description' => $res->description,
                        'length' => $res->length,
                        'length_uom' => ucfirst($res->length_unit),
                        'width' => $res->width,
                        'width_uom' => ucfirst($res->width_unit),
                        'height' => $res->height,
                        'height_uom' => ucfirst($res->height_unit),
                        'weight' => $res->weight,
                        'weight_uom' => ucfirst($res->weight_unit),
                        'volume' => $res->volume,
                        'volume_uom' => ucfirst($res->volume_unit),
                        'volumetric_weight' => $res->volumetric_weight,
                        'volweight_uom' => ucfirst($res->volweight_uom)
                    ];
                }
            }
        }
        echo json_encode($items);
    }

    public function getordercargodetails()
    {
        $cargos = [];
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        if ($order_id != "") {
            $sql = 'SELECT c.id,c.cargo_type,c.length_unit,c.width_unit,c.height_unit,c.weight_unit,c.volume_unit,c.goods_description,
            c.stackable,c.grounded,c.splittable,c.dg_goods,o.length,o.width,o.height,o.weight,o.volume,o.volumetric_weight,
            o.volweight_uom,c.ldm,o.quantity,o.scanned_quantity  FROM tb_cargo_details c,tb_order_cargodetails o
            WHERE o.order_id =? AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC';
            $qry = $this->db->query($sql, [$order_id]);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $stackable = 'Off';
                    if ($res->stackable == 0) {
                        $stackable = 'Off';
                    } else if ($res->stackable == 1) {
                        $stackable = 'On';
                    }
                    $grounded = 'Off';
                    if ($res->grounded == 0) {
                        $grounded = 'Off';
                    } else if ($res->grounded == 1) {
                        $grounded = 'On';
                    }
                    $splittable = 'Off';
                    if ($res->splittable == 0) {
                        $splittable = 'Off';
                    } else if ($res->splittable == 1) {
                        $splittable = 'On';
                    }
                    $dg_goods = 'Off';
                    if ($res->dg_goods == 0) {
                        $dg_goods = 'Off';
                    } else if ($res->dg_goods == 1) {
                        $dg_goods = 'On';
                    }
                    $cargo_type = '"' . $res->cargo_type . '"';
                    $goods_desc = '"' . $res->goods_description . '"';
                    $length_unit = '"' . $res->length_unit . '"';
                    $width_unit = '"' . $res->width_unit . '"';
                    $height_unit = '"' . $res->height_unit . '"';
                    $weight_unit = '"' . $res->weight_unit . '"';
                    $volume_unit = '"' . $res->volume_unit . '"';
                    $volweight_uom = '"' . $res->volweight_uom . '"';
                    $scanned_quantity = $res->scanned_quantity;
                    if ($scanned_quantity == "") {
                        $scanned_quantity = 0;
                    }
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $res->volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $res->ldm . "," . $scanned_quantity . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteordercargodetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargos</a></li>";
                    $empty = "";
                    $cargos[] = [
                        'id' => $res->id,
                        'cargo_type' => $res->cargo_type,
                        'goods_desc' => $res->goods_description,
                        'quantity' => $res->quantity,
                        'length' => $res->length . " " . $res->length_unit,
                        'width' => $res->width . " " . $res->width_unit,
                        'height' => $res->height . " " . $res->height_unit,
                        'weight' => $res->weight . " " . $res->weight_unit,
                        'volume' => $res->volume . " " . $res->volume_unit,
                        'volumetric_weight' => $res->volumetric_weight . " " . $res->volweight_uom,
                        'stackable' => $stackable,
                        'splittable' => $splittable,
                        'grounded' => $grounded,
                        'action' => $action,
                        'empty' => $empty,
                        'dg_goods' => $dg_goods,
                        "ldm" => $res->ldm,
                        'scanned_quantity' => $scanned_quantity
                    ];
                }
            }
        }
        echo json_encode($cargos);
    }

    public function deleteorder($id)
    {
        if ($id != '' || $id != 0) {
            $chk = $this->db->select('id')->get_where("tb_orders", ['id' => $id]);

            if ($chk->num_rows() > 0) {
                $upd = $this->db->where(['id' => $id])->update('tb_orders', ['status' => 0]);

                if ($upd) {
                    $refs = new OrderReference();
                    $refs->deleteForOrder($id, ['DQ']);
                }
            }

            $this->ordernotify('booking_delete', $id);
        }
        echo "1";
    }

    public function deleteordercargodetails()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : '0';
        $cargo_id = isset($_POST['cargo_id']) ? $_POST['cargo_id'] : '0';
        if ($order_id != '0' && $cargo_id != '0') {
            $chk = $this->db->select('id')->get_where('tb_order_cargodetails', ['order_id' => $order_id, 'cargo_id' => $cargo_id]);
            if ($chk->num_rows() > 0) {
                $row_id = $chk->row()->id;
                $upd = $this->db->where(['id' => $row_id])->update('tb_order_cargodetails', ['status' => '0']);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function showcargodetails()
    {
        $user_id = $this->session->userdata('user_id');
        $cargos = [];
        $ids = isset($_POST['cargo_id']) ? $_POST['cargo_id'] : "";
        $type = isset($_POST['type']) ? $_POST['type'] : "";
        if ($ids != "") {
            $cargo_ids = implode("','", $ids);
            if (!empty($cargo_ids)) {

                $qry = $this->db->query("SELECT c.* FROM tb_cargo_details c WHERE c.id IN (" . $cargo_ids . ") AND c.status='1' GROUP BY c.id ORDER BY c.id DESC");
                if ($qry->num_rows() > 0) {
                    if ($type == 'popup') {
                        foreach ($qry->result() as $res) {
                            $stackable = 'Off';
                            if ($res->stackable == 0) {
                                $stackable = 'Off';
                            } else if ($res->stackable == 1) {
                                $stackable = 'On';
                            }
                            $grounded = 'Off';
                            if ($res->grounded == 0) {
                                $grounded = 'Off';
                            } else if ($res->grounded == 1) {
                                $grounded = 'On';
                            }
                            $splittable = 'Off';
                            if ($res->splittable == 0) {
                                $splittable = 'Off';
                            } else if ($res->splittable == 1) {
                                $splittable = 'On';
                            }
                            $dg_goods = 'Off';
                            if ($res->dg_goods == 0) {
                                $dg_goods = 'Off';
                            } else if ($res->dg_goods == 1) {
                                $dg_goods = 'On';
                            }
                            $action = "<button id=" . $res->id . " class='btn btn-xs' onclick='editpopupcargodetails(" . $res->id . ",event)'><span class='icon tru-icon-edit' aria-hidden='true'></span></button> <button id=" . $res->id . " class='btn btn-xs' onclick='deletepopupcargodetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                            $cargos[] = [
                                'cargo_type' => $res->cargo_type,
                                'goods_desc' => $res->goods_description,
                                'quantity' => $res->quantity,
                                'length' => $res->length . " " . $res->length_unit,
                                'width' => $res->width . " " . $res->width_unit,
                                'height' => $res->height . " " . $res->height_unit,
                                'weight' => $res->weight . " " . $res->weight_unit,
                                'volume' => $res->volume . " " . $res->volume_unit,
                                'volumentric_weight' => $res->volumetric_weight . " " . $res->volweight_uom,
                                'stackable' => $stackable,
                                'grounded' => $grounded,
                                'splittable' => $splittable,
                                'dg_goods' => $dg_goods,
                                'ldm' => $res->ldm,
                                'action' => $action
                            ];
                        }
                    } else {
                        foreach ($qry->result() as $res) {
                            $stackable = 'Off';
                            if ($res->stackable == 0) {
                                $stackable = 'Off';
                            } else if ($res->stackable == 1) {
                                $stackable = 'On';
                            }
                            $grounded = 'Off';
                            if ($res->grounded == 0) {
                                $grounded = 'Off';
                            } else if ($res->grounded == 1) {
                                $grounded = 'On';
                            }
                            $splittable = 'Off';
                            if ($res->splittable == 0) {
                                $splittable = 'Off';
                            } else if ($res->splittable == 1) {
                                $splittable = 'On';
                            }
                            $dg_goods = 'Off';
                            if ($res->dg_goods == 0) {
                                $dg_goods = 'Off';
                            } else if ($res->dg_goods == 1) {
                                $dg_goods = 'On';
                            }
                            $cargos_ar = [
                                'id' => $res->id,
                                'cargo_type' => $res->cargo_type,
                                'goods_desc' => $res->goods_description,
                                'quantity' => $res->quantity,
                                'length' => $res->length . " " . $res->length_unit,
                                'width' => $res->width . " " . $res->width_unit,
                                'height' => $res->height . " " . $res->height_unit,
                                'weight' => $res->weight . " " . $res->weight_unit,
                                'volume' => $res->volume . " " . $res->volume_unit,
                                'stackable' => $stackable,
                                'dg_goods' => $dg_goods
                            ];
                            $cargo_type = '"' . $res->cargo_type . '"';
                            $goods_desc = '"' . $res->goods_description . '"';
                            $length_unit = '"' . $res->length_unit . '"';
                            $width_unit = '"' . $res->width_unit . '"';
                            $height_unit = '"' . $res->height_unit . '"';
                            $weight_unit = '"' . $res->weight_unit . '"';
                            $volume_unit = '"' . $res->volume_unit . '"';
                            $volweight_uom = '"' . $res->volweight_uom . '"';
                            $scanned_quantity = 0;
                            $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $res->volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $res->ldm . "," . $scanned_quantity . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowCargoElim(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargo</a></li>";
                            $cargos[] = [
                                'id' => $res->id,
                                'cargo_type' => $res->cargo_type,
                                'goods_desc' => $res->goods_description,
                                'quantity' => $res->quantity,
                                'length' => $res->length . " " . $res->length_unit,
                                'width' => $res->width . " " . $res->width_unit,
                                'height' => $res->height . " " . $res->height_unit,
                                'weight' => $res->weight . " " . $res->weight_unit,
                                'volume' => $res->volume . " " . $res->volume_unit,
                                'volumentric_weight' => $res->volumetric_weight . " " . $res->volweight_uom,
                                'stackable' => $stackable,
                                'splittable' => $splittable,
                                'grounded' => $grounded,
                                'dg_goods' => $dg_goods,
                                'ldm' => $res->ldm,
                                'action' => $action,
                                'scanned_quantity' => $scanned_quantity
                            ];
                        }
                    }
                }
            }
        }
        echo json_encode($cargos);
    }

    public function getinnercargo()
    {
        $cargos = [];
        $cargo_id = $this->input->post('cargo_id');
        if ($cargo_id != "" || $cargo_id != 0) {
            $sql = 'SELECT i.id as inner_id,i.cargo_type as inner_cargo,i.goods_description as inner_gd,i.quantity as inner_quantity,
            i.length as inner_length,i.length_unit as inner_lum,i.width as inner_width,i.width_unit as inner_wum,i.height as inner_height,
            i.height_unit as inner_hum,i.weight as inner_weight,i.weight_unit as inner_weum,i.volume as inner_volume,i.volume_unit as inner_vum,
            i.stackable as inner_stackable FROM tb_inner_cargo i
            WHERE i.cargo_id=? AND i.status=1 GROUP BY i.id ORDER BY i.id DESC';
            $inner_qry = $this->db->query($sql, [$cargo_id]);
            if ($inner_qry->num_rows() > 0) {
                foreach ($inner_qry->result() as $inner) {
                    $stackable = 'Off';
                    if ($inner->inner_stackable == 0) {
                        $stackable = 'Off';
                    } else if ($inner->inner_stackable == 1) {
                        $stackable = 'On';
                    }
                    $cargo_type = '"' . $inner->inner_cargo . '"';
                    $goods_desc = '"' . $inner->inner_gd . '"';
                    /* $action     = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowinnercargoEdit(this," . $inner->inner_id . "," . $cargo_type . "," . $goods_desc . "," . $inner->inner_quantity . "," . $inner->inner_length . "," . $inner->inner_width . "," . $inner->inner_height . "," . $inner->inner_weight . "," . $inner->inner_volume . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default'  onclick='deleteinnercargopackage(" . $inner->inner_id . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='addinnercargo(this," . $cargo_id . ");'><span class='fa fa-archive' > </span>Inner Cargo</a></li>";*/
                    $action = "";
                    $cargos[] = [
                        'inner_id' => $inner->inner_id,
                        'main_cargo_id' => $cargo_id,
                        'inner_cargo' => $inner->inner_cargo,
                        'inner_gd' => $inner->inner_gd,
                        'inner_quantity' => $inner->inner_quantity,
                        'inner_width' => $inner->inner_width . " " . $inner->inner_wum,
                        'inner_height' => $inner->inner_height . " " . $inner->inner_hum,
                        'inner_length' => $inner->inner_length . " " . $inner->inner_lum,
                        'inner_weight' => $inner->inner_weight . " " . $inner->inner_weum,
                        'inner_volume' => $inner->inner_volume . " " . $inner->inner_vum,
                        'inner_stackable' => $stackable,
                        'action' => $action
                    ];
                }
            }
        }
        echo json_encode($cargos);
    }

    public function deleteorderpartydetails()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
        $party_id = isset($_POST['party_id']) ? $_POST['party_id'] : "0";
        if ($order_id != '0' && $party_id != '0') {
            $sql = 'SELECT id FROM tb_order_parties WHERE status=1 AND party_id = ? AND order_id = ? ';
            $getdata = $this->db->query($sql, [$party_id, $order_id]);
            if ($getdata->num_rows() > 0) {
                $id = $getdata->row()->id;
                $upd = $this->db->where(array('id' => $id))->update("tb_order_parties", ['status' => 0]);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        }
    }

    public function savecargo($id = NULL)
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $cargo_id = 0;
        $inner_id = $data = $inner = [];
        $user_id = $this->session->userdata('user_id');
        $stackable = isset($_POST['stackable']) ? $_POST['stackable'] : "0";
        $grounded = isset($_POST['grounded']) ? $_POST['grounded'] : "0";
        $splittable = isset($_POST['splittable']) ? $_POST['splittable'] : "0";
        $dg_goods = isset($_POST['dg_goods']) ? $_POST['dg_goods'] : "0";
        $length = isset($post['length']) ? $post['length'] : "0.00";
        $width = isset($post['width']) ? $post['width'] : "0.00";
        $height = isset($post['height']) ? $post['height'] : "0.00";
        $weight = isset($post['weight']) ? $post['weight'] : "0.00";
        $volume = isset($post['volume']) ? $post['volume'] : "0.00";
        $ldm = isset($post['ldm']) ? $post['ldm'] : "0.00";
        if ($ldm == "" || !(is_numeric($ldm))) {
            $ldm = "0.00";
        }
        $volumetric_weight = isset($post['volumetric_weight']) ? $post['volumetric_weight'] : "0.00";
        if ($length == "") {
            $length = '0.00';
        }
        if ($width == "") {
            $width = '0.00';
        }
        if ($height == "") {
            $height = '0.00';
        }
        if ($weight == "") {
            $weight = '0.00';
        }
        if ($volume == "") {
            $volume = '0.00';
        }
        if ($volumetric_weight == "") {
            $volumetric_weight = '0.00';
        }
        $cargo = [
            'cargo_type' => $post['cargo_type'],
            'goods_description' => $post['goods_desc'],
            'quantity' => $post['quantity'],
            'length' => $length,
            'length_unit' => $post['length_uom'],
            'width' => $width,
            'width_unit' => $post['width_uom'],
            'height' => $height,
            'height_unit' => $post['height_uom'],
            'weight' => $weight,
            'weight_unit' => $post['weight_uom'],
            'volume' => $volume,
            'volume_unit' => $post['volume_uom'],
            'volumetric_weight' => $volumetric_weight,
            'volweight_uom' => $post['volweight_uom'],
            'stackable' => $stackable,
            'grounded' => $grounded,
            'splittable' => $splittable,
            'dg_goods' => $dg_goods,
            'createdby' => $user_id,
            'createdon' => $cdate,
            'ldm' => $ldm
        ];
        if ($id == NULL) {
            $ins = $this->db->insert("tb_cargo_details", $cargo);
            $cargo_id = $this->db->insert_id();
            $data = ['cargo_id' => $cargo_id, 'inner_cargo_id' => $inner_id];
        } else {
            $cargo_id = $id;
            $upd = $this->db->where(['id' => $cargo_id])->update("tb_cargo_details", $cargo);
            $upd = $this->db->where(['cargo_id' => $cargo_id])->update("tb_order_cargodetails", [
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'weight' => $weight,
                'volume' => $volume,
                'quantity' => $post['quantity'],
                'quantity_type' => $post['cargo_type'],
                'cargo_content' => $post['goods_desc'],
                'volumetric_weight' => $volumetric_weight,
                'volweight_uom' => $post['volweight_uom'],
                'ldm' => $ldm
            ]);
            $data = ['cargo_id' => $cargo_id, 'inner_cargo_id' => $inner_id];
        }
        $order_id = isset($_POST['order_forcargo']) ? $_POST['order_forcargo'] : "0";
        if ($order_id != '0') {
            $chk = $this->db->select('id')->get_where('tb_order_cargodetails', ['order_id' => $order_id, 'cargo_id' => $cargo_id, 'status' => '1']);
            $sql = 'SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE ?';
            $gethandling_unit = $this->db->query($sql, [$post['cargo_type']]);
            $handling_unit = "";
            if ($gethandling_unit->num_rows() > 0) {
                $handling_unit = $gethandling_unit->row()->id;
            } else {
                $handlingunit_ar = ['unit_name' => $post['cargo_type'], 'description' => $post['cargo_type'], 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1'];
                $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                $handling_unit = $this->db->insert_id();
            }
            if ($chk->num_rows() == 0) {
                $ins = $this->db->insert('tb_order_cargodetails', [
                    'order_id' => $order_id,
                    'cargo_id' => $cargo_id,
                    'status' => '1',
                    'createdon' => $cdate,
                    'length' => $length,
                    'width' => $width,
                    'height' => $height,
                    'weight' => $weight,
                    'volume' => $volume,
                    'quantity' => $post['quantity'],
                    'quantity_type' => $post['cargo_type'],
                    'cargo_content' => $post['goods_desc'],
                    'handling_unit' => $handling_unit,
                    'volumetric_weight' => $volumetric_weight,
                    'volweight_uom' => $post['volweight_uom'],
                    'ldm' => $ldm
                ]);
            } else {
                $upd = $this->db->where(['order_id' => $order_id, 'cargo_id' => $cargo_id])->update("tb_order_cargodetails", [
                    'length' => $length,
                    'width' => $width,
                    'height' => $height,
                    'weight' => $weight,
                    'volume' => $volume,
                    'quantity' => $post['quantity'],
                    'quantity_type' => $post['cargo_type'],
                    'cargo_content' => $post['goods_desc'],
                    'handling_unit' => $handling_unit,
                    'volumetric_weight' => $volumetric_weight,
                    'volweight_uom' => $post['volweight_uom'],
                    'ldm' => $ldm
                ]);
            }
        }
        echo json_encode($data);
    }

    public function saveinnercargo($id = NULL)
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $cargo_id = 0;
        $inner_id = $data = $inner = [];
        $main_cargo_id = isset($_POST['main_cargo_id']) ? $_POST['main_cargo_id'] : "0";
        $user_id = $this->session->userdata('user_id');
        $stackable = isset($_POST['stackable']) ? $_POST['stackable'] : "0";
        $length = isset($post['length']) ? $post['length'] : "0.00";
        $width = isset($post['width']) ? $post['width'] : "0.00";
        $height = isset($post['height']) ? $post['height'] : "0.00";
        $weight = isset($post['weight']) ? $post['weight'] : "0.00";
        $volume = isset($post['volume']) ? $post['volume'] : "0.00";
        //   if($main_cargo_id != "0"){
        if ($length == "") {
            $length = '0.00';
        }
        if ($width == "") {
            $width = '0.00';
        }
        if ($height == "") {
            $height = '0.00';
        }
        if ($weight == "") {
            $weight = '0.00';
        }
        if ($volume == "") {
            $volume = '0.00';
        }
        if ($id == NULL) {
            $inner_cargo = [
                'cargo_id' => $main_cargo_id,
                'cargo_type' => $post['cargo_type'],
                'goods_description' => $post['goods_desc'],
                'quantity' => $post['quantity'],
                'length' => $length,
                'length_unit' => $post['length_uom'],
                'width' => $width,
                'width_unit' => $post['width_uom'],
                'height' => $height,
                'height_unit' => $post['height_uom'],
                'weight' => $weight,
                'weight_unit' => $post['weight_uom'],
                'volume' => $volume,
                'volume_unit' => $post['volume_uom'],
                'stackable' => $stackable,
                'createdby' => $user_id,
                'createdon' => $cdate
            ];
            $ins = $this->db->insert("tb_inner_cargo", $inner_cargo);
            $innercargo_id = $this->db->insert_id();
            $data = ['main_cargo_id' => $main_cargo_id];
        } else {
            $innercargo_id = $id;
            if ($main_cargo_id == "" && $main_cargo_id == 0) {
                $getmaincargo = $this->db->select("cargo_id")->get_where("tb_inner_cargo", ['id' => $innercargo_id]);
                if ($getmaincargo->num_rows() > 0) {
                    $main_cargo_id = $getmaincargo->row()->cargo_id;
                }
            }
            $inner_cargo = [
                'cargo_id' => $main_cargo_id,
                'cargo_type' => $post['cargo_type'],
                'goods_description' => $post['goods_desc'],
                'quantity' => $post['quantity'],
                'length' => $length,
                'length_unit' => $post['length_uom'],
                'width' => $width,
                'width_unit' => $post['width_uom'],
                'height' => $height,
                'height_unit' => $post['height_uom'],
                'weight' => $weight,
                'weight_unit' => $post['weight_uom'],
                'volume' => $volume,
                'volume_unit' => $post['volume_uom'],
                'stackable' => $stackable
            ];
            $upd = $this->db->where(['id' => $innercargo_id])->update("tb_inner_cargo", $inner_cargo);
            $data = ['main_cargo_id' => $main_cargo_id];
        }
        echo json_encode($data);
    }

    public function savepopupcargo($id = NULL)
    {
        $post = $this->input->post();
        $cdate = date('Y-m-d H:i:s');
        $cargo_id = 0;
        $inner_id = $data = $inner = [];
        $user_id = $this->session->userdata('user_id');
        $stackable = isset($_POST['popupstackable']) ? $_POST['popupstackable'] : "0";
        $grounded = isset($_POST['popupgroundable']) ? $_POST['popupgroundable'] : "0";
        $splittable = isset($_POST['popupsplittable']) ? $_POST['popupsplittable'] : "0";
        $popuplength = isset($_POST['popuplength']) ? $_POST['popuplength'] : "0";
        $popupwidth = isset($_POST['popupwidth']) ? $_POST['popupwidth'] : "0";
        $popupheight = isset($_POST['popupheight']) ? $_POST['popupheight'] : "0";
        $popupweight = isset($_POST['popupweight']) ? $_POST['popupweight'] : "0";
        $popupvolume = isset($_POST['popupvolume']) ? $_POST['popupvolume'] : "0";
        $popupdg_goods = isset($_POST['popupdg_goods']) ? $_POST['popupdg_goods'] : "0";
        $popupldm = isset($_POST['popupldm']) ? $_POST['popupldm'] : "0";
        if ($popupldm == "" || !(is_numeric($popupldm))) {
            $popupldm = "0.00";
        }
        $popupvolumetric_weight = isset($_POST['popupvolumetric_weight']) ? $_POST['popupvolumetric_weight'] : "0";
        if ($popuplength == "") {
            $popuplength = '0.00';
        }
        if ($popupwidth == "") {
            $popupwidth = '0.00';
        }
        if ($popupheight == "") {
            $popupheight = '0.00';
        }
        if ($popupweight == "") {
            $popupweight = '0.00';
        }
        if ($popupvolume == "") {
            $popupvolume = '0.00';
        }
        if ($popupvolumetric_weight == "") {
            $popupvolumetric_weight = '0.00';
        }
        $cargo = [
            'cargo_type' => $post['popupcargo_type'],
            'goods_description' => $post['popupgoods_desc'],
            'quantity' => $post['popupquantity'],
            'length' => $popuplength,
            'length_unit' => $post['popuplength_uom'],
            'width' => $popupwidth,
            'width_unit' => $post['popupwidth_uom'],
            'height' => $popupheight,
            'height_unit' => $post['popupheight_uom'],
            'weight' => $popupweight,
            'weight_unit' => $post['popupweight_uom'],
            'volume' => $popupvolume,
            'volume_unit' => $post['popupvolume_uom'],
            'volumetric_weight' => $popupvolumetric_weight,
            'volweight_uom' => $post['popupvow_uom'],
            'stackable' => $stackable,
            'grounded' => $grounded,
            'splittable' => $splittable,
            'createdby' => $user_id,
            'createdon' => $cdate,
            'dg_goods' => $popupdg_goods,
            'ldm' => $popupldm
        ];
        if ($id == NULL) {
            $ins = $this->db->insert("tb_cargo_details", $cargo);
            $cargo_id = $this->db->insert_id();
            $data = ['cargo_id' => $cargo_id];
        } else {
            $cargo_id = $id;
            $upd = $this->db->where(['id' => $cargo_id])->update("tb_cargo_details", $cargo);
            $data = ['cargo_id' => $cargo_id];
        }
        echo json_encode($data);
    }

    public function editcargodetails()
    {
        $id = $this->input->post('id');
        $cargo = $inner = [];
        if ($id != "") {
            $sql = 'SELECT * FROM tb_cargo_details WHERE id=? GROUP BY id';
            $get_cargo = $this->db->query($sql, [$id]);
            if ($get_cargo->num_rows() > 0) {
                $sql = 'SELECT * FROM tb_inner_cargo WHERE cargo_id=? AND status=1 GROUP BY id';
                $get_inner = $this->db->query($sql, [$id]);
                if ($get_inner->num_rows() > 0) {
                    foreach ($get_inner->result() as $res) {
                        $inner[] = [
                            'inner_id' => $res->id,
                            'inner_cargo_type' => $res->cargo_type,
                            'inner_goods_description' => $res->goods_description,
                            'inner_quantity' => $res->quantity,
                            'inner_length' => $res->length,
                            'inner_length_uom' => $res->length_unit,
                            'inner_width' => $res->width,
                            'inner_width_uom' => $res->width_unit,
                            'inner_height' => $res->height,
                            'inner_height_uom' => $res->height_unit,
                            'inner_weight' => $res->weight,
                            'inner_weight_uom' => $res->weight_unit,
                            'inner_volume' => $res->volume,
                            'inner_volume_uom' => $res->volume_unit,
                            'inner_stackable' => $res->stackable
                        ];
                    }
                }
                $cargo = [
                    'id' => $get_cargo->row()->id,
                    'cargo_type' => $get_cargo->row()->cargo_type,
                    'goods_description' => $get_cargo->row()->goods_description,
                    'quantity' => $get_cargo->row()->quantity,
                    'length' => $get_cargo->row()->length,
                    'length_uom' => $get_cargo->row()->length_unit,
                    'width' => $get_cargo->row()->width,
                    'width_uom' => $get_cargo->row()->width_unit,
                    'height' => $get_cargo->row()->height,
                    'height_uom' => $get_cargo->row()->height_unit,
                    'weight' => $get_cargo->row()->weight,
                    'weight_uom' => $get_cargo->row()->weight_unit,
                    'volume' => $get_cargo->row()->volume,
                    'volume_uom' => $get_cargo->row()->volume_unit,
                    'volumetric_weight' => $get_cargo->row()->volumetric_weight,
                    'volweight_uom' => $get_cargo->row()->volweight_uom,
                    'stackable' => $get_cargo->row()->stackable,
                    'grounded' => $get_cargo->row()->grounded,
                    'splittable' => $get_cargo->row()->splittable,
                    'dg_goods' => $get_cargo->row()->dg_goods,
                    'ldm' => $get_cargo->row()->ldm,
                    'inner' => $inner
                ];
            }
        }
        echo json_encode($cargo);
    }

    public function deleteinnercargopackage()
    {
        $inner_id = isset($_POST['inner_id']) ? $_POST['inner_id'] : '0';
        $cargo_id = 0;
        if ($inner_id != 0) {
            $chk = $this->db->select('id,cargo_id')->get_where('tb_inner_cargo', ['id' => $inner_id]);
            if ($chk->num_rows() > 0) {
                $cargo_id = $chk->row()->cargo_id;
                $upd = $this->db->where(array('id' => $inner_id))->update('tb_inner_cargo', ['status' => '0']);
            }
        }
        echo json_encode($cargo_id);
    }

    public function insertorder()
    {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : "";
        $branch_code = isset($_POST['branch_code']) ? $_POST['branch_code'] : "";
        $department_code = isset($_POST['department_code']) ? $_POST['department_code'] : "";
        $product = isset($_POST['product']) ? $_POST['product'] : "";
        $service = isset($_POST['service']) ? $_POST['service'] : "";
        $order_shipper_id = isset($_POST['order_shipper_id']) ? $_POST['order_shipper_id'] : "";
        /*$order_status     = isset($_POST['order_status']) ? $_POST['order_status'] : "";
    if ($order_status == "") {
        $order_status = "OPEN";
    }*/
        $delivery_terms = isset($_POST['delivery_terms']) ? $_POST['delivery_terms'] : "";
        $incoterm = isset($_POST['incoterm']) ? $_POST['incoterm'] : "";
        $shipment_id = isset($_POST['delivery_note']) ? $_POST['delivery_note'] : "";
        $container_no = isset($_POST['container_num']) ? $_POST['container_num'] : "";
        $porder = isset($_POST['purchase_order']) ? $_POST['purchase_order'] : "";
        $notify_party = isset($_POST['notify_party']) ? $_POST['notify_party'] : "";
        $goods_value = isset($_POST['goods_value']) ? $_POST['goods_value'] : "0.00";
        if ($goods_value == "") {
            $goods_value = 0.00;
        }
        $party_row_id = isset($_POST['order_party_row_id']) ? $_POST['order_party_row_id'] : "0";
        $order_inv_row_id = isset($_POST['order_inv_row_id']) ? $_POST['order_inv_row_id'] : '0';
        $order_cargo_id = isset($_POST['order_cargo_id']) ? $_POST['order_cargo_id'] : "";
        $pickup = isset($_POST['order_pickup_id']) ? $_POST['order_pickup_id'] : "0";
        $delivery = isset($_POST['order_drop_id']) ? $_POST['order_drop_id'] : "";
        $early_pickup = isset($_POST['early_pickup']) ? $_POST['early_pickup'] : "";
        $late_pickup = isset($_POST['late_pickup']) ? $_POST['late_pickup'] : "";
        $early_delivery = isset($_POST['early_delivery']) ? $_POST['early_delivery'] : "";
        $late_delivery = isset($_POST['late_delivery']) ? $_POST['late_delivery'] : "";
        $modeof_trasnport = isset($_POST['modeof_trasnport']) ? $_POST['modeof_trasnport'] : "LTL";
        $order_type = isset($_POST['order_type']) ? $_POST['order_type'] : "";
        $rev_row_id = isset($_POST['rev_row_id']) ? $_POST['rev_row_id'] : "";
        $ordcost_row_id = isset($_POST['ordcost_row_id']) ? $_POST['ordcost_row_id'] : "";
        $customer_code = isset($_POST['customer_id']) ? $_POST['customer_id'] : "";
        $driver_pickup_instructions = isset($_POST['driver_pickup_instructions']) ? $_POST['driver_pickup_instructions'] : "";
        $driver_delivery_instructions = isset($_POST['driver_delivery_instructions']) ? $_POST['driver_delivery_instructions'] : "";
        $e_pickup = date('Y-m-d H:i:s');
        if ($early_pickup != "") {
            $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
        }
        if ($late_pickup != "") {
            $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
        } else {
            $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
        }
        $e_delivery = date('Y-m-d H:i:s');
        if ($early_delivery != "") {
            $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
        }
        if ($late_delivery != "") {
            $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
        } else {
            $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
        }
        $same_porder = "0";
        if ($porder != "") {
            $chkporder = $this->db->query("SELECT id FROM tb_order_details WHERE purchase_order='" . $porder . "' AND status='1'");
            if ($chkporder->num_rows() > 0) {
                $same_porder = "1";
            }
        }
        if ($same_porder == 1) {
            $this->session->set_flashdata('error_msg', 'Purchase Order "' . $porder . '" already exists with One ORDER');
        } else {
            $drop_id = $pickup_custid = 0;
            $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $pickup_address = $pickup_state = $drop_address = $drop_state = "";
            $sql = 'SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode FROM tbl_party_master WHERE id = ?';
            $getdrop_custid = $this->db->query($sql, [$delivery]);
            if ($getdrop_custid->num_rows() > 0) {
                $drop_id = $getdrop_custid->row()->customeridentifier;
                $drop_name = $getdrop_custid->row()->name;
                $drop_state = $getdrop_custid->row()->state;
                $drop_address = $getdrop_custid->row()->address;
                $drop_country = $getdrop_custid->row()->country;
                $drop_street = $getdrop_custid->row()->street;
                $drop_pincode = $getdrop_custid->row()->pincode;
                $drop_city = $getdrop_custid->row()->city;
            }
            $sql = 'SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode FROM tbl_party_master WHERE id=?';
            $getshippercustid = $this->db->query($sql, [$order_shipper_id]);
            if ($getshippercustid->num_rows() > 0) {
                $pickup_custid = $getshippercustid->row()->customeridentifier;
                $pickup_name = $getshippercustid->row()->name;
                $pickup_state = $getshippercustid->row()->state;
                $pickup_address = $getshippercustid->row()->address;
                $pickup_country = $getshippercustid->row()->country;
                $pickup_street = $getshippercustid->row()->street;
                $pickup_pincode = $getshippercustid->row()->pincode;
                $pickup_city = $getshippercustid->row()->city;
            }
            $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
            $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
            $data = getlatlngsbyplace($add1);
            $lat1 = @$data[0];
            $lng1 = @$data[1];
            $data = [];
            $data = getlatlngsbyplace($add2);
            $lat2 = @$data[0];
            $lng2 = @$data[1];
            $ship_row_id = 0;
            $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
            $tid = $tname = "";
            $sql = 'SELECT id,name FROM tb_transportmode WHERE code LIKE ?';
            $gettrasnportmode = $this->db->query($sql, [$modeof_trasnport]);
            if ($gettrasnportmode->num_rows() > 0) {
                $tid = $gettrasnportmode->row()->id;
                $tname = $gettrasnportmode->row()->name;
            }
            if ($shipment_id == "") {
                $shipment_id = "SVK" . time();
            }
            $ship_arr = [
                'shipid' => $shipment_id,
                'txnid' => $shipment_id,
                'trucktype' => $tname,
                'pickupcnt' => '1',
                'dropcnt' => '1',
                'unitspec' => 1,
                'insertusr' => $pickup_custid,
                'carrier' => '0',
                'insertuserdate' => $cdate,
                'enddate' => $enddate,
                'insdate' => $cdate,
                'upddate' => $cdate,
                'reason' => 'SHIPMENT',
                'purpose' => 'SEND INTEGRATION',
                'ship_object' => 'SHIPMENT',
                'logdate' => $cdate,
                'transport_mode' => $modeof_trasnport,
                'domainname' => $branch_code,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'product' => $product,
                'freight_term' => '60',
                'freight_termname' => 'Free of Charge',
                'incoterm' => $incoterm,
                'modeoftransport' => $tid
            ];
            $sql = 'SELECT id FROM tb_shipments WHERE shipid LIKE ?';
            $chk_shipid = $this->db->query($sql, [$shipment_id]);
            if ($chk_shipid->num_rows() > 0) {
                $ship_row_id = $chk_shipid->row()->id;
                $this->db->where(['id' => $ship_row_id])->update("tb_shipments", $ship_arr);
            } else {
                $ship_arr['createdon'] = $cdate;
                $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
                $ship_row_id = $this->db->insert_id();
            }
            $customer_id = 0;
            $cust_id = $this->session->userdata('cust_id');
            if ($pickup == "") {
                $pickup = 0;
            }
            $customer_id = $pickup;
            if ($customer_id == "" || $customer_id == "0") {
                if ($customer_code != "" && $customer_code != "0") {
                    $getcustomerid = $this->db->select("id")->get_where("tb_customers", ['code' => $customer_code, 'user_id' => $user_id, 'status' => '1']);
                    if ($getcustomerid->num_rows() > 0) {
                        $customer_id = $getcustomerid->row()->id;
                    }
                }
            }
            if ($this->session->userdata('company_code') == 'NZKN') {
                if ($product == "") {
                    $product = "KN AsiaLink";
                }
                if ($modeof_trasnport == "") {
                    $modeof_trasnport = "LTL";
                }
                if ($service == "") {
                    $service = "19";
                }
            }
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $logdate = $getactual['datetime'];
            $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $curtz);
            $e_pickup = $getpickup['datetime'];
            $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $curtz);
            $l_pickup = $getlpickup['datetime'];
            $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $curtz);
            $e_delivery = $getdelivery['datetime'];
            $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $curtz);
            $l_delivery = $getldelivery['datetime'];
            $childid = 0;
            if ($this->session->userdata('childid')) {
                $childid = $this->session->userdata('childid');
            }
            $orderinfo = [
                'shipment_id' => $ship_row_id,
                'customer_id' => $customer_id,
                'product' => $product,
                'pickup_datetime' => $e_pickup,
                'delivery_datetime' => $e_delivery,
                'pickup_endtime' => $l_pickup,
                'drop_endtime' => $l_delivery,
                'goods_value' => $goods_value,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'createdon' => $cdate,
                'drop_custid' => $drop_id,
                'drop_partyid' => $drop_id,
                'user_id' => $user_id,
                'sub_uid' => $childid,
                'pickup_custid' => $pickup_custid,
                'pickup_partyid' => $pickup_custid,
                'pickup_country' => $pickup_country,
                'pickup_city' => $pickup_city,
                'pickup_pincode' => $pickup_pincode,
                'pickup_company' => $pickup_name,
                'pickup_address1' => $pickup_street,
                'pickup_address2' => $pickup_state,
                'delivery_country' => $drop_country,
                'delivery_city' => $drop_city,
                'delivery_pincode' => $drop_pincode,
                'delivery_company' => $drop_name,
                'delivery_address1' => $drop_street,
                'delivery_address2' => $drop_state,
                'is_created' => '1',
                'plat' => $lat1,
                'plng' => $lng1,
                'dlat' => $lat2,
                'dlng' => $lng2,
                'transport_mode' => $modeof_trasnport,
                'created_source' => '4',
                'createdon' => $logdate
            ];
            $ins_order = $this->db->insert("tb_orders", $orderinfo);
            $order_id = $this->db->insert_id();
            $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
            $country_code = $get_country->row()->country_code;
            $company_code = $get_country->row()->company_code;
            $genord = ["user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code];
            $booking_id = generatebookingid($genord);
            $upd = $this->db->where(array('id' => $order_id))->update("tb_orders", ['order_id' => $booking_id]);
            $details = [
                'service' => $service,
                'delivery_term' => $delivery_terms,
                'incoterm' => $incoterm,
                'purchase_order' => $porder,
                'notify_party' => $notify_party,
                'department_code' => $department_code,
                'temperature_control' => '0',
                'valorance_insurance' => '0',
                'high_cargo_value' => '0',
                'customs_required' => '0',
                'order_row_id' => $order_id,
                'order_id' => $booking_id,
                'createdon' => $cdate,
                'shipper_id' => $order_shipper_id,
                'order_type' => $order_type
            ];
            $this->db->insert("tb_order_details", $details);
            $shipper_address = ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id];
            $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1']);
            if ($chk_shipperaddress->num_rows() > 0) {
                $shipperadd_id = $chk_shipperaddress->row()->id;
                $upd_add = $this->db->where(['id' => $shipperadd_id])->update("tbl_orderparty_address", $shipper_address);
            } else {
                $shipper_address['createdon'] = $cdate;
                $this->db->insert("tbl_orderparty_address", $shipper_address);
                $shipperadd_id = $this->db->insert_id();
            }
            $delivery_address = ['order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id];
            $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1']);
            if ($chk_deliveryaddress->num_rows() > 0) {
                $dropadd_id = $chk_deliveryaddress->row()->id;
                $upd_add = $this->db->where(['id' => $dropadd_id])->update("tbl_orderparty_address", $delivery_address);
            } else {
                $delivery_address['createdon'] = $cdate;
                $this->db->insert("tbl_orderparty_address", $delivery_address);
                $dropadd_id = $this->db->insert_id();
            }
            $cargo_forship = [];
            if ($order_cargo_id != "") {
                $cargo_ids = [];
                $cargo_ids = explode(',', $order_cargo_id);
                for ($i = 0; $i < count($cargo_ids); $i++) {
                    $length = $width = $height = $weight = $volume = 0;
                    $quantity = 1;

                    $sql = 'SELECT cargo_type,length,width,height,weight,volumetric_weight,volume,quantity,goods_description
                    FROM tb_cargo_details WHERE id=?';
                    $getcargo_details = $this->db->query($sql, [$cargo_ids[$i]]);
                    $cargo_type = $description = "";
                    if ($getcargo_details->num_rows() > 0) {
                        $length = $getcargo_details->row()->length;
                        $width = $getcargo_details->row()->width;
                        $height = $getcargo_details->row()->height;
                        $weight = $getcargo_details->row()->weight;
                        $volume = $getcargo_details->row()->volume;
                        $quantity = $getcargo_details->row()->quantity;
                        $cargo_type = $getcargo_details->row()->cargo_type;
                        $description = $getcargo_details->row()->goods_description;
                        $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                        $cargo_forship[$i] = $getcargo_details->row()->cargo_type;
                    }
                    $sql = 'SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE ?';
                    $gethandling_unit = $this->db->query($sql, [$cargo_type]);
                    $handling_unit = "";
                    if ($gethandling_unit->num_rows() > 0) {
                        $handling_unit = $gethandling_unit->row()->id;
                    } else {
                        $handlingunit_ar = ['unit_name' => $cargo_type, 'description' => $cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1'];
                        $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo = [
                        'order_id' => $order_id,
                        'cargo_id' => $cargo_ids[$i],
                        'status' => '1',
                        'length' => $length,
                        'width' => $width,
                        'height' => $height,
                        'weight' => $weight,
                        'volumetric_weight' => $volumetric_weight,
                        'volweight_uom' => 'kg',
                        'volume' => $volume,
                        'quantity' => $quantity,
                        'cargo_content' => $description,
                        'quantity_type' => $cargo_type,
                        'handling_unit' => $handling_unit
                    ];
                    $ins_cargo = $this->db->insert("tb_order_cargodetails", $cargo);
                }
            }
            $unitspec = "1";
            if (!empty($cargo_forship)) {
                $unitspec = implode(',', $cargo_forship);
            }
            $updship = $this->db->where(['id' => $ship_row_id])->update("tb_shipments", ['unitspec' => $unitspec, 'txncode' => $booking_id]);
            $total_weight = $total_volume = $total_quantity = 0;
            $sql = 'SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails
            WHERE order_id=? AND status=1';
            $gettotal = $this->db->query($sql, [$order_id]);
            if ($gettotal->num_rows() > 0) {
                $total_volume = $gettotal->row()->total_volume;
                $total_weight = $gettotal->row()->total_weight;
                $total_quantity = $gettotal->row()->total_quantity;
            }
            $upd_order = $this->db->where(['id' => $order_id])->update("tb_orders", ['volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity]);
            $ids = [];
            if ($shipment_id != "") {
                $ins_ref = ['order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate];
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($company_code == 'UKKN' || $company_code == 'AUKN') {
                if ($container_no != "") {
                    $ins_ref = ['order_id' => $order_id, 'reference_id' => 'CTR', 'ref_value' => $container_no, 'createdon' => $cdate];
                    $ins = $this->db->insert('tb_order_references', $ins_ref);
                }
            }
            if ($porder != "") {
                $ins_ref = ['order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate];
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($driver_pickup_instructions != "") {
                $ins_ref = ['order_id' => $order_id, 'reference_id' => 'ORD_PIKINST', 'ref_value' => $driver_pickup_instructions, 'createdon' => $cdate];
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($driver_delivery_instructions != "") {
                $ins_ref = ['order_id' => $order_id, 'reference_id' => 'ORD_DLVINST', 'ref_value' => $driver_delivery_instructions, 'createdon' => $cdate];
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($party_row_id != "0") {
                $ids = explode(',', $party_row_id);
            }
            if ($order_inv_row_id != 0 || $order_inv_row_id != "") {
                array_push($ids, $order_inv_row_id);
            }
            if (!empty($ids)) {
                for ($i = 0; $i < count($ids); $i++) {
                    if ($ids[$i] != "") {
                        $sql = 'SELECT party_type_id FROM tbl_party_master WHERE id=?';
                        $getpartytype = $this->db->query($sql, [$ids[$i]]);
                        $party_type = 1;
                        if ($getpartytype->num_rows() > 0) {
                            $party_type = $getpartytype->row()->party_type_id;
                        }
                        $party = ['order_id' => $order_id, 'party_id' => $ids[$i], 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
                        $ins_party = $this->db->insert("tb_order_parties", $party);
                    }
                }
            }
            if ($order_shipper_id != "" || $order_shipper_id != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id]);
                    if ($chk1->num_rows() > 0) {
                        $party_type = $chk1->row()->id;
                    }
                }
                $party = ['order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
                $ins_party = $this->db->insert("tb_order_parties", $party);
            }
            if ($delivery != "" || $delivery != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id]);
                    if ($chk1->num_rows() > 0) {
                        $party_type = $chk1->row()->id;
                    }
                }
                $party = ['order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
                $ins_party = $this->db->insert("tb_order_parties", $party);
            }
            $rev_ids = [];
            if ($rev_row_id != "" && $rev_row_id != "0") {
                $rev_ids = explode(',', $rev_row_id);
                if ($ordcost_row_id != "") {
                    $cost_ids = array();
                    $cost_ids = explode(',', $ordcost_row_id);
                    foreach ($cost_ids as $ids) {
                        array_push($rev_ids, $ids);
                    }
                }
                if (!empty($rev_ids)) {
                    $upd = $this->db->query("UPDATE tb_reveneus set order_id ='" . $order_id . "' WHERE id IN (" . implode(',', $rev_ids) . ")");
                }
            }
            $shipment_name = "BOXES";
            $total_weight = $total_volume = $total_quantity = 0;
            $sql = 'SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id=?';
            $gettotal = $this->db->query($sql, [$order_id]);
            if ($gettotal->num_rows() > 0) {
                $total_volume = $gettotal->row()->total_volume;
                $total_weight = $gettotal->row()->total_weight;
                $total_quantity = $gettotal->row()->total_quantity;
            }
            $getcust_details = $this->common->gettblrowdata(['id' => $customer_id], "name,phone,email_id", 'tb_customers', 0, 0);
            if (!empty($getcust_details)) {
                $customer_email = $getcust_details['email_id'];
                $customer_phone = $getcust_details['phone'];
            }
            /*if($this->session->userdata('usr_tzone')['country'] == "RU"){*/
            if ($order_id != "" && $customer_id != "") {
                $pickupinfo['country'] = trim($pickup_country);
                $pickupinfo['state'] = trim($pickup_state);
                $pickupinfo['city'] = trim($pickup_city);
                $pickupinfo['region'] = trim($pickup_street);
                $pickupinfo['zipcode'] = trim($pickup_pincode);
                $pickupinfo['order_country'] = trim($pickup_country);
                $pickupinfo['order_city'] = trim($pickup_city);
                $pickupinfo['order_zipcode'] = trim($pickup_pincode);
                $pickupinfo['stoptype'] = "P";
                $dropinfo['country'] = trim($drop_country);
                $dropinfo['state'] = trim($drop_state);
                $dropinfo['city'] = trim($drop_city);
                $dropinfo['region'] = trim($drop_street);
                $dropinfo['zipcode'] = trim($drop_pincode);
                $dropinfo['stoptype'] = "D";
                $dropinfo['order_country'] = trim($drop_country);
                $dropinfo['order_city'] = trim($drop_city);
                $dropinfo['order_zipcode'] = trim($drop_pincode);
                $pickupgeocode = checkgeocode($pickupinfo);
                $dropgeocode = checkgeocode($pickupinfo);
                if (!empty($pickupgeocode) && !empty($dropgeocode)) {
                    $pickupgeocode['stoptype'] = "P";
                    $dropgeocode['stoptype'] = "D";
                    $pickupgeocode['order_country'] = trim($pickup_country);
                    $pickupgeocode['order_city'] = trim($pickup_city);
                    $pickupgeocode['order_zipcode'] = trim($pickup_pincode);
                    $dropgeocode['order_country'] = trim($drop_country);
                    $dropgeocode['order_city'] = trim($drop_city);
                    $dropgeocode['order_zipcode'] = trim($drop_pincode);
                    $pickuproute = getcust_routeautomate($customer_id, $pickupgeocode);
                    $droproute = getcust_routeautomate($customer_id, $dropgeocode);
                    if (!empty($pickuproute) && !empty($droproute)) {
                        $orderinfo['id'] = $order_id;
                        $orderinfo['order_id'] = $booking_id;
                        $orderinfo['shipment_name'] = $shipment_name;
                        $orderinfo['customer_phone'] = $customer_phone;
                        $orderinfo['customer_email'] = $customer_email;
                        $orderinfo['volume'] = $total_volume;
                        $orderinfo['weight'] = $total_weight;
                        $orderinfo['quantity'] = $total_quantity;
                        $orderinfo['quantity'] = $total_quantity;
                        $shipment = createshipmentbyorder($pickuproute, $orderinfo);
                    } else {
                        $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                        $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                        if (!empty($pickuproute1) && !empty($droproute1)) {
                            $orderinfo['id'] = $order_id;
                            $orderinfo['order_id'] = $booking_id;
                            $orderinfo['shipment_name'] = $shipment_name;
                            $orderinfo['customer_phone'] = $customer_phone;
                            $orderinfo['customer_email'] = $customer_email;
                            $orderinfo['volume'] = $total_volume;
                            $orderinfo['weight'] = $total_weight;
                            $orderinfo['quantity'] = $total_quantity;
                            $orderinfo['quantity'] = $total_quantity;
                            $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                        }
                    }
                } else {
                    $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                    $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                    if (!empty($pickuproute1) && !empty($droproute1)) {
                        $orderinfo['id'] = $order_id;
                        $orderinfo['order_id'] = $booking_id;
                        $orderinfo['shipment_name'] = $shipment_name;
                        $orderinfo['customer_phone'] = $customer_phone;
                        $orderinfo['customer_email'] = $customer_email;
                        $orderinfo['volume'] = $total_volume;
                        $orderinfo['weight'] = $total_weight;
                        $orderinfo['quantity'] = $total_quantity;
                        $orderinfo['quantity'] = $total_quantity;
                        $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                    }
                }
            }
            /*}*/
            $pref_arr = [
                'pickup' => strtoupper($pickup_country),
                'pickup_state' => strtoupper($pickup_state),
                'pickup_city' => strtoupper($pickup_city),
                'pickup_pincode' => $pickup_pincode,
                'drop' => strtoupper($drop_country),
                'drop_state' => strtoupper($drop_state),
                'drop_city' => strtoupper($drop_city),
                'drop_pincode' => $drop_pincode,
                'customer_id' => $customer_code,
                'service' => $service,
                'product' => $product,
                'user_id' => $user_id,
                'company_code' => $company_code,
                'order_id' => $order_id,
                'order_type' => $order_type,
                'customer_row_id' => $customer_id
            ];
            /*if($company_code == 'PLKN'){*/
            $this->ratemanagement->addrecodfororderinsertion($pref_arr);
            /*}*/
            $this->ordernotify('booking_create', $order_id);
        }
        if ($order_id != "" && $order_id != '0') {
            $this->session->set_flashdata('success_msg', 'Order Created Successfully - ' . $booking_id);
            redirect('amzorders/orderslist/' . $order_id);
        } else {
            redirect("amzorders");
        }
    }

    public function savequickbook()
    {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $cust_id = $this->session->userdata('cust_id');
        $company_code = isset($_POST['popupcompany_code']) ? $_POST['popupcompany_code'] : "";
        $branch_code = isset($_POST['popupbranch_code']) ? $_POST['popupbranch_code'] : "";
        $department_code = isset($_POST['popupdepartment_code']) ? $_POST['popupdepartment_code'] : "";
        $product = isset($_POST['productpopup']) ? $_POST['productpopup'] : "";
        $service = isset($_POST['servicepopup']) ? $_POST['servicepopup'] : "";
        $delivery_terms = isset($_POST['popupdelivery_terms']) ? $_POST['popupdelivery_terms'] : "";
        $incoterm = isset($_POST['incoterm_popup']) ? $_POST['incoterm_popup'] : "";
        $shipment_id = isset($_POST['popupdelivery_note']) ? $_POST['popupdelivery_note'] : "";
        $porder = isset($_POST['purchaseorder_popup']) ? $_POST['purchaseorder_popup'] : "";
        $notify_party = isset($_POST['popupnotifyparty']) ? $_POST['popupnotifyparty'] : "";
        $popuppickup = isset($_POST['popuppickup']) ? $_POST['popuppickup'] : "";
        $popupdelivery = isset($_POST['popupdelivery']) ? $_POST['popupdelivery'] : "";
        $customer_phone = isset($_POST['popupshipper_phone']) ? $_POST['popupshipper_phone'] : "";
        $customer_email = isset($_POST['popupshipper_email']) ? $_POST['popupshipper_email'] : "";
        $popupcustomer_id = isset($_POST['popupcustomer_id']) ? $_POST['popupcustomer_id'] : "";
        $driverdelivery_popup = isset($_POST['driverdelivery_popup']) ? $_POST['driverdelivery_popup'] : "";
        $driverpickup_popup = isset($_POST['driverpickup_popup']) ? $_POST['driverpickup_popup'] : "";

        $currency = isset($_POST['currency']) ? $_POST['currency'] : "";
        $goods_value = isset($_POST['goods_value']) ? $_POST['goods_value'] : "0.00";

        $earlyquickbook_delivery = $latequickbook_delivery = "";
        if ($popupdelivery != "") {
            $earlyquickbook_delivery = date('Y-m-d H:i:s', strtotime($popupdelivery));
            $latequickbook_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_delivery)));
        }
        $earlyquickbook_pickup = $latequickbook_pickup = "";
        if ($popuppickup != "") {
            $earlyquickbook_pickup = date('Y-m-d H:i:s', strtotime($popuppickup));
            $latequickbook_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_pickup)));
        }
        $popuporder_type = isset($_POST['popuporder_type']) ? $_POST['popuporder_type'] : "";
        $popupmodeof_trasnport = isset($_POST['popupmodeof_trasnport']) ? $_POST['popupmodeof_trasnport'] : "LTL";
        $reference_ids = isset($_POST['quickbookreference_ids']) ? $_POST['quickbookreference_ids'] : "0";
        $quickbook_order_reference_ids = isset($_POST['quickbook_order_reference_ids']) ? $_POST['quickbook_order_reference_ids'] : "0";
        $order_cargo_id = isset($_POST['quickbookorder_cargo_id']) ? $_POST['quickbookorder_cargo_id'] : "";
        $inv_parties = array($_POST['quickbookshipper_id'], $_POST['quickboookconsignee_id']);
        $pickup = isset($_POST['quickbookpickup_id']) ? $_POST['quickbookpickup_id'] : "0";
        if ($pickup == "") {
            $pickup = 0;
        }
        $delivery = $_POST['quickboookconsignee_id'];
        $drop_id = $pickup_custid = 0;
        $pickup_name = $pickup_country = $pickup_street = $pickup_state = $drop_state = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = "";
        $sql = 'SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id=?';
        $getdrop_custid = $this->db->query($sql, [$delivery]);

        if ($getdrop_custid->num_rows() > 0) {
            $drop_id = $getdrop_custid->row()->customeridentifier;
            $drop_name = $getdrop_custid->row()->name;
            $drop_country = $getdrop_custid->row()->country;
            $drop_state = $getdrop_custid->row()->state;
            $drop_street = $getdrop_custid->row()->street;
            $drop_pincode = $getdrop_custid->row()->pincode;
            $drop_city = $getdrop_custid->row()->city;
        }
        $sql = 'SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id=?';
        $getshippercustid = $this->db->query($sql, [$_POST['quickbookshipper_id']]);

        if ($getshippercustid->num_rows() > 0) {
            $pickup_custid = $getshippercustid->row()->customeridentifier;
            $pickup_name = $getshippercustid->row()->name;
            $pickup_country = $getshippercustid->row()->country;
            $pickup_state = $getshippercustid->row()->state;
            $pickup_street = $getshippercustid->row()->street;
            $pickup_pincode = $getshippercustid->row()->pincode;
            $pickup_city = $getshippercustid->row()->city;
        }
        $tname = "Full Truck Load";
        $tid = "FTL";
        $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid = 1;
        $tname = "";
        $sql = 'SELECT id,name FROM tb_transportmode WHERE code LIKE ?';
        $gettrasnportmode = $this->db->query($sql, [$popupmodeof_trasnport]);

        if ($gettrasnportmode->num_rows() > 0) {
            $tid = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        if ($shipment_id == "") {
            $shipment_id = "SVK" . time();
        }
        $ship_row_id = 0;
        $ship_arr = [
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $tname,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickup_custid,
            'carrier' => '0',
            'insertuserdate' => $cdate,
            'enddate' => $enddate,
            'insdate' => $cdate,
            'upddate' => $cdate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $cdate,
            'transport_mode' => $popupmodeof_trasnport,
            'domainname' => $branch_code,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $tid,
            'unitspec' => 1
        ];
        $sql = 'SELECT id FROM tb_shipments WHERE shipid LIKE ?';
        $chk_shipid = $this->db->query($sql, [$shipment_id]);

        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(['id' => $ship_row_id])->update("tb_shipments", $ship_arr);
        } else {
            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id = $this->db->insert_id();
        }
        $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
        $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $data = [];
        $data = getlatlngsbyplace($add2);
        $lat2 = @$data[0];
        $lng2 = @$data[1];
        $customer_id = $pickup;
        if ($customer_id == "0" || $customer_id == "") {
            if ($popupcustomer_id != "" && $popupcustomer_id != "0") {
                $getcustomerid = $this->db->select("id")->get_where("tb_customers", ['code' => $popupcustomer_id, 'user_id' => $user_id, 'status' => '1']);
                if ($getcustomerid->num_rows() > 0) {
                    $customer_id = $getcustomerid->row()->id;
                }
            }
        }
        if ($this->session->userdata('company_code') == 'NZKN') {
            if ($product == "") {
                $product = "KN AsiaLink";
            }
            if ($popupmodeof_trasnport == "") {
                $popupmodeof_trasnport = "LTL";
            }
            if ($service == "") {
                $service = "19";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_pickup, $curtz);
        $earlyquickbook_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $latequickbook_pickup, $curtz);
        $latequickbook_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_delivery, $curtz);
        $earlyquickbook_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $latequickbook_delivery, $curtz);
        $latequickbook_delivery = $getldelivery['datetime'];
        $childid = 0;
        if ($this->session->userdata('childid')) {
            $childid = $this->session->userdata('childid');
        }
        $orderinfo = [
            'goods_value' => '0.00',
            'shipment_id' => $ship_row_id,
            'customer_id' => $customer_id,
            'product' => $product,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'createdon' => $cdate,
            'pickup_datetime' => $earlyquickbook_pickup,
            'delivery_datetime' => $earlyquickbook_delivery,
            'pickup_endtime' => $latequickbook_pickup,
            'drop_endtime' => $latequickbook_delivery,
            'goods_value' => $goods_value,
            'currency' => $currency,
            'drop_custid' => $drop_id,
            'drop_partyid' => $drop_id,
            'user_id' => $user_id,
            'sub_uid' => $childid,
            'pickup_custid' => $pickup_custid,
            'pickup_partyid' => $pickup_custid,
            'pickup_country' => $pickup_country,
            'pickup_city' => $pickup_city,
            'pickup_pincode' => $pickup_pincode,
            'pickup_company' => $pickup_name,
            'pickup_address1' => $pickup_street,
            'pickup_address2' => $pickup_state,
            'delivery_country' => $drop_country,
            'delivery_city' => $drop_city,
            'delivery_pincode' => $drop_pincode,
            'delivery_company' => $drop_name,
            'delivery_address1' => $drop_street,
            'delivery_address2' => $drop_state,
            'transport_mode' => $popupmodeof_trasnport,
            'plat' => $lat1,
            'plng' => $lng1,
            'dlat' => $lat2,
            'dlng' => $lng2,
            'is_created' => '1',
            'modeoftransport' => $tid,
            'created_source' => '3',
            'createdon' => $logdate
        ];
        $ins_order = $this->db->insert("tb_orders", $orderinfo);
        $order_id = $this->db->insert_id();
        $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
        $country_code = $get_country->row()->country_code;
        $company_code = $get_country->row()->company_code;
        $genord = ["user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code];
        $booking_id = generatebookingid($genord);
        $upd = $this->db->where(['id' => $order_id])->update("tb_orders", ['order_id' => $booking_id]);
        $details = [
            'shipper_id' => $_POST['quickbookshipper_id'],
            'service' => $service,
            'delivery_term' => $delivery_terms,
            'incoterm' => $incoterm,
            'purchase_order' => $porder,
            'notify_party' => $notify_party,
            'department_code' => $department_code,
            'createdon' => $cdate,
            'order_row_id' => $order_id,
            'order_id' => $booking_id,
            'order_type' => $popuporder_type
        ];
        $this->db->insert('tb_order_details', $details);
        $order_shipper_id = isset($_POST['quickbookshipper_id']) ? $_POST['quickbookshipper_id'] : "";
        $pickup_address = $pickup_street . "," . $pickup_city . "," . $pickup_state;
        $shipper_address = ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id];
        $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1']);
        if ($chk_shipperaddress->num_rows() > 0) {
            $shipperadd_id = $chk_shipperaddress->row()->id;
            $upd_add = $this->db->where(['id' => $shipperadd_id])->update("tbl_orderparty_address", $shipper_address);
        } else {
            $shipper_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $shipper_address);
            $shipperadd_id = $this->db->insert_id();
        }
        $drop_address = $drop_street . "," . $drop_city . "," . $drop_state;
        $delivery_address = ['order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id];
        $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1']);
        if ($chk_deliveryaddress->num_rows() > 0) {
            $dropadd_id = $chk_deliveryaddress->row()->id;
            $upd_add = $this->db->where(['id' => $dropadd_id])->update("tbl_orderparty_address", $delivery_address);
        } else {
            $delivery_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $delivery_address);
            $dropadd_id = $this->db->insert_id();
        }
        $shipment_name = "BOXES";
        if ($order_cargo_id != "") {
            $cargo_ids = [];
            $cargo_ids = explode(',', $order_cargo_id);
            for ($i = 0; $i < count($cargo_ids); $i++) {
                $length =
                $width = $height = $weight = $volume = 0;
                $quantity = 1;
                if ($cargo_ids[$i] != "") {
                    $sql = 'SELECT cargo_type,goods_description,length,width,height,weight,volumetric_weight,volume,quantity FROM tb_cargo_details WHERE id=?';
                    $getcargo_details = $this->db->query($sql, [$cargo_ids[$i]]);
                    $length = $width = $height = $weight = $volume = $quantity = $cargo_type = $description = "";
                    if ($getcargo_details->num_rows() > 0) {
                        $length = $getcargo_details->row()->length;
                        $width = $getcargo_details->row()->width;
                        $height = $getcargo_details->row()->height;
                        $weight = $getcargo_details->row()->weight;
                        $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                        $volume = $getcargo_details->row()->volume;
                        $quantity = $getcargo_details->row()->quantity;
                        $shipment_name = $cargo_type = $getcargo_details->row()->cargo_type;
                        $description = $getcargo_details->row()->goods_description;
                    }
                    $sql = 'SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE ?';
                    $gethandling_unit = $this->db->query($sql, [$cargo_type]);
                    $handling_unit = "";
                    if ($gethandling_unit->num_rows() > 0) {
                        $handling_unit = $gethandling_unit->row()->id;
                    } else {
                        $handlingunit_ar = ['unit_name' => $cargo_type, 'description' => $cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1'];
                        $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo = [
                        'order_id' => $order_id,
                        'cargo_id' => $cargo_ids[$i],
                        'status' => '1',
                        'length' => $length,
                        'width' => $width,
                        'height' => $height,
                        'weight' => $weight,
                        'volume' => $volume,
                        'quantity' => $quantity,
                        'cargo_content' => $description,
                        'quantity_type' => $cargo_type,
                        'handling_unit' => $handling_unit,
                        'volumetric_weight' => $volumetric_weight,
                        'volweight_uom' => 'kg'
                    ];
                    $this->db->insert("tb_order_cargodetails", $cargo);
                }
            }
        }
        $total_weight = $total_volume = $total_quantity = 0;
        $sql = 'SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id = ?';
        $gettotal = $this->db->query($sql, [$order_id]);
        if ($gettotal->num_rows() > 0) {
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $cargo_forship = [];
        $sql = 'SELECT quantity_type FROM tb_order_cargodetails WHERE order_id = ?';
        $getcargos = $this->db->query($sql, [$order_id]);
        if ($getcargos->num_rows() > 0) {
            foreach ($getcargos->result() as $res) {
                $cargo_forship[] = $res->quantity_type;
            }
        }
        $unitspec = "";
        if (!empty($cargo_forship)) {
            $unitspec = implode(',', $cargo_forship);
        }
        $updship = $this->db->where(['id' => $ship_row_id])->update("tb_shipments", ['unitspec' => $unitspec, 'txncode' => $booking_id]);
        $upd_order = $this->db->where(['id' => $order_id])->update("tb_orders", ['volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity]);
        $ids = [];
        if ($reference_ids != "0") {
            $refids = explode(',', $reference_ids);
        }
        $order_ref_ids = [];
        if ($quickbook_order_reference_ids != "0") {
            $order_ref_ids = explode(',', $quickbook_order_reference_ids);
        }
        if (!empty($order_ref_ids)) {
            for ($i = 0; $i < count($order_ref_ids); $i++) {
                if ($order_ref_ids[$i] != "") {
                    $upd = $this->db->where(['id' => $order_ref_ids[$i]])->update("tb_order_references", ['order_id' => $order_id]);
                }
            }
        }
        if ($shipment_id != "") {
            $ins_ref = ['order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate];
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($driverdelivery_popup != "") {
            $ins_ref = ['order_id' => $order_id, 'reference_id' => 'ORD_DLVINST', 'ref_value' => $driverdelivery_popup, 'createdon' => $cdate];
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($driverpickup_popup != "") {
            $ins_ref = ['order_id' => $order_id, 'reference_id' => 'ORD_PIKINST', 'ref_value' => $driverpickup_popup, 'createdon' => $cdate];
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($porder != "") {
            $ins_ref = ['order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate];
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($order_shipper_id != "" || $order_shipper_id != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id]);
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = ['order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
            $ins_party = $this->db->insert("tb_order_parties", $party);
        }
        if ($delivery != "" || $delivery != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id]);
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = ['order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
            $ins_party = $this->db->insert("tb_order_parties", $party);
        }
        $pref_arr = [
            'pickup' => strtoupper($pickup_country),
            'pickup_state' => strtoupper($pickup_state),
            'pickup_city' => strtoupper($pickup_city),
            'pickup_pincode' => $pickup_pincode,
            'drop' => strtoupper($drop_country),
            'drop_state' => strtoupper($drop_state),
            'drop_city' => strtoupper($drop_city),
            'drop_pincode' => $drop_pincode,
            'customer_id' => $popupcustomer_id,
            'service' => $service,
            'product' => $product,
            'user_id' => $user_id,
            'company_code' => $company_code,
            'order_id' => $order_id,
            'order_type' => $popuporder_type,
            'customer_row_id' => $customer_id
        ];
        /*if($company_code == 'PLKN'){*/
        $this->ratemanagement->addrecodfororderinsertion($pref_arr);
        /*}*/
        /*if($this->session->userdata('usr_tzone')['country'] == "RU"){*/
        if ($order_id != "" && $customer_id != "") {
            $pickupinfo['country'] = trim($pickup_country);
            $pickupinfo['order_country'] = trim($pickup_country);
            $pickupinfo['order_city'] = trim($pickup_city);
            $pickupinfo['order_zipcode'] = trim($pickup_pincode);
            $pickupinfo['state'] = trim($pickup_state);
            $pickupinfo['city'] = trim($pickup_city);
            $pickupinfo['region'] = trim($pickup_street);
            $pickupinfo['zipcode'] = trim($pickup_pincode);
            $pickupinfo['stoptype'] = "P";
            $dropinfo['order_country'] = trim($drop_country);
            $dropinfo['order_city'] = trim($drop_city);
            $dropinfo['order_zipcode'] = trim($drop_pincode);
            $dropinfo['country'] = trim($drop_country);
            $dropinfo['state'] = trim($drop_state);
            $dropinfo['city'] = trim($drop_city);
            $dropinfo['region'] = trim($drop_street);
            $dropinfo['zipcode'] = trim($drop_pincode);
            $dropinfo['stoptype'] = "D";
            $pickupgeocode = checkgeocode($pickupinfo);
            $dropgeocode = checkgeocode($pickupinfo);
            if (!empty($pickupgeocode) && !empty($dropgeocode)) {
                $pickupgeocode['stoptype'] = "P";
                $dropgeocode['stoptype'] = "D";
                $pickupgeocode['order_country'] = trim($pickup_country);
                $pickupgeocode['order_city'] = trim($pickup_city);
                $pickupgeocode['order_zipcode'] = trim($pickup_pincode);
                $dropgeocode['order_country'] = trim($drop_country);
                $dropgeocode['order_city'] = trim($drop_city);
                $dropgeocode['order_zipcode'] = trim($drop_pincode);
                $pickuproute = getcust_routeautomate($customer_id, $pickupgeocode);
                $droproute = getcust_routeautomate($customer_id, $dropgeocode);
                if (!empty($pickuproute) && !empty($droproute)) {
                    $orderinfo['id'] = $order_id;
                    $orderinfo['order_id'] = $booking_id;
                    $orderinfo['shipment_name'] = $shipment_name;
                    $orderinfo['customer_phone'] = $customer_phone;
                    $orderinfo['customer_email'] = $customer_email;
                    $orderinfo['volume'] = $total_volume;
                    $orderinfo['weight'] = $total_weight;
                    $orderinfo['quantity'] = $total_quantity;
                    $orderinfo['quantity'] = $total_quantity;
                    $shipment = createshipmentbyorder($pickuproute, $orderinfo);
                } else {
                    $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                    $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                    if (!empty($pickuproute1) && !empty($droproute1)) {
                        $orderinfo['id'] = $order_id;
                        $orderinfo['order_id'] = $booking_id;
                        $orderinfo['shipment_name'] = $shipment_name;
                        $orderinfo['customer_phone'] = $customer_phone;
                        $orderinfo['customer_email'] = $customer_email;
                        $orderinfo['volume'] = $total_volume;
                        $orderinfo['weight'] = $total_weight;
                        $orderinfo['quantity'] = $total_quantity;
                        $orderinfo['quantity'] = $total_quantity;
                        $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                    }
                }
            } else {
                $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                if (!empty($pickuproute1) && !empty($droproute1)) {
                    $orderinfo['id'] = $order_id;
                    $orderinfo['order_id'] = $booking_id;
                    $orderinfo['shipment_name'] = $shipment_name;
                    $orderinfo['customer_phone'] = $customer_phone;
                    $orderinfo['customer_email'] = $customer_email;
                    $orderinfo['volume'] = $total_volume;
                    $orderinfo['weight'] = $total_weight;
                    $orderinfo['quantity'] = $total_quantity;
                    $orderinfo['quantity'] = $total_quantity;
                    $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                }
            }
        }
        /*}*/
        $this->ordernotify('booking_create', $order_id);
        if ($order_id != "" && $order_id != '0') {
            $this->session->set_flashdata('success_msg', 'Order Created Successfully - ' . $booking_id);
            redirect('amzorders/orderslist/' . $order_id);
        } else {
            redirect("amzorders");
        }
    }

    public function addreferencedetails()
    {
        $id = $this->input->post('reference_id');
        $name = $this->input->post('reference_name');
        $value = $this->input->post('reference_value');
        if ($id == "ETA") {
            $chkrtime = getdatetimebytimezone(DFLT_TZ, $value, $this->session->userdata('usr_tzone')['timezone']);
            $value = $chkrtime['datetime'];
        }
        $row_id = isset($_POST['ref_row_id']) ? $_POST['ref_row_id'] : "";
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
        $order_ref_id = isset($_POST['order_ref_id']) ? $_POST['order_ref_id'] : "0";
        $cdate = date('Y-m-d H:i:s');
        $ins_id = $order_ins_id = 0;
        if ($row_id == "") {
            $ins_arr = ['name' => $id, 'description' => $name, 'createdon' => $cdate];
            $chk_ar = $this->db->select('id')->get_where('tb_reference_master', ['name' => $id, 'status' => '1']);
            if ($chk_ar->num_rows() == 0) {
                $ins = $this->db->insert("tb_reference_master", $ins_arr);
                $ins_id = $this->db->insert_id();
            } else {
                $ins_id = $chk_ar->row()->id;
            }
            if ($ins_id != "") {
                $ins_order = ['reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate, 'order_id' => $order_id];
                $ins = $this->db->insert("tb_order_references", $ins_order);
                $order_ins_id = $this->db->insert_id();
            }
        } else {
            $upd_ar = ['name' => $id, 'description' => $name];
            if ($id == 'PO') {
                $po_val = $value;
                $upd = $this->db->where(['order_row_id' => $order_id])->update("tb_order_details", ['purchase_order' => $po_val]);
            }
            if ($id == 'DQ') {
                $dq_val = $value;
                $sql = 'SELECT s.id FROM tb_shipments s,tb_orders o WHERE o.id=? AND o.shipment_id=s.id';
                $chkshipment = $this->db->query($sql, [$order_id]);
                if ($chkshipment->num_rows() > 0) {
                    $shipment_id = $chkshipment->row()->id;
                    $upd = $this->db->where(['id' => $shipment_id])->update("tb_shipments", ['shipid' => $dq_val, 'txnid' => $dq_val]);
                }
            }
            $this->db->where(['id' => $row_id])->update("tb_reference_master", $upd_ar);
            if ($order_id != "") {
                $ins_ar = ['order_id' => $order_id, 'reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate];
                $chk = $this->db->select('id')->get_where('tb_order_references', ['order_id' => $order_id, 'reference_id' => $id, 'status' => '1']);
                if ($chk->num_rows() == 0) {
                    $ins_ar['createdon'] = $cdate;
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $this->db->where(['id' => $chk->row()->id])->update("tb_order_references", $ins_ar);
                }
            } else {
                $chk = $this->db->select('id')->get_where('tb_order_references', ['reference_id' => $id, 'status' => '1']);
                $ins_ar = ['order_id' => '0', 'reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate];
                if ($chk->num_rows() == 0) {
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $order_ins_id = $chk->row()->id;
                    $upd = $this->db->where(['id' => $order_ins_id])->update("tb_order_references", $ins_ar);
                }
            }
            $ins_id = $row_id;
        }
        $arr = ['ins_id' => $ins_id, 'order_ins_id' => $order_ins_id];
        echo json_encode($arr);
    }

    public function addpopupreferencedetails()
    {
        $id = $this->input->post('reference_id');
        $name = $this->input->post('reference_name');
        $value = $this->input->post('reference_value');
        $row_id = isset($_POST['ref_row_id']) ? $_POST['ref_row_id'] : "";
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
        $order_ref_id = isset($_POST['order_ref_id']) ? $_POST['order_ref_id'] : "0";
        $cdate = date('Y-m-d H:i:s');
        $ins_id = $order_ins_id = 0;
        if ($row_id == "") {
            $ins_arr = ['name' => $id, 'description' => $name, 'createdon' => $cdate];
            $chk_ar = $this->db->select('id')->get_where('tb_reference_master', ['name' => $id, 'description' => $name, 'status' => '1']);
            if ($chk_ar->num_rows() == 0) {
                $ins = $this->db->insert("tb_reference_master", $ins_arr);
                $ins_id = $this->db->insert_id();
            } else {
                $ins_id = $chk_ar->row()->id;
            }
            if ($ins_id != "") {
                $ins_order = ['reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate, 'order_id' => $order_id];
                $ins = $this->db->insert("tb_order_references", $ins_order);
                $order_ins_id = $this->db->insert_id();
            }
        } else {
            $upd_ar = ['name' => $id, 'description' => $name];
            $this->db->where(['id' => $row_id])->update("tb_reference_master", $upd_ar);
            if ($order_id != "") {
                $ins_ar = ['order_id' => $order_id, 'reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate];
                $chk = $this->db->select('id')->get_where('tb_order_references', ['order_id' => $order_id, 'reference_id' => $id, 'status' => '1', 'id' => $order_ref_id]);
                if ($chk->num_rows() == 0) {
                    $ins_ar['createdon'] = $cdate;
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $this->db->where(['id' => $chk->row()->id])->update("tb_order_references", $ins_ar);
                }
            } else {
                $chk = $this->db->select('id')->get_where('tb_order_references', ['reference_id' => $id, 'status' => '1', 'id' => $order_ref_id]);
                $ins_ar = ['order_id' => '0', 'reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate];
                if ($chk->num_rows() == 0) {
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $order_ins_id = $chk->row()->id;
                    $upd = $this->db->where(['id' => $order_ins_id])->update("tb_order_references", $ins_ar);
                }
            }
            $ins_id = $row_id;
        }
        $arr = ['ins_id' => $ins_id, 'order_ins_id' => $order_ins_id];
        echo json_encode($arr);
    }

    public function deleteorderreferencedetails()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
        $ref_id = isset($_POST['ref_id']) ? $_POST['ref_id'] : "0";
        if ($order_id != '0' && $ref_id != '0') {
            $getref_name = $this->db->select('name')->get_where("tb_reference_master", ['id' => $ref_id]);
            if ($getref_name->num_rows() > 0) {
                $ref_id = $getref_name->row()->name;
            }
            $chkdetails = $this->db->select('id')->get_where("tb_order_references", ['order_id' => $order_id, 'reference_id' => $ref_id]);
            if ($chkdetails->num_rows() > 0) {
                $upd = $this->db->where(['id' => $chkdetails->row()->id])->update("tb_order_references", ['status' => '0']);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        }
    }

    public function getotherreferencedetails()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        $type = isset($_POST['type']) ? $_POST['type'] : "";
        $ref_ids = isset($_POST['ref_ids']) ? $_POST['ref_ids'] : [];
        $getrefer_rows = 0;
        $refer = [];
        $whr = "";
        $action = "";
        if ($order_id != "") {
            $sql = 'SELECT r.*,o.id as order_ref_id,o.reference_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o
            WHERE o.order_id=? AND o.reference_id =r.name  AND r.status=1 AND o.status=1 GROUP BY o.id ORDER BY r.createdon DESC';
            $getrefer = $this->db->query($sql, [$order_id]);
            $getrefer_rows = $getrefer->num_rows();
        } else {
            $whr = "";
            if ($ref_ids != "") {
                $refids = implode(',', $ref_ids);
                if (!empty($refids)) {
                    $whr .= " AND r.id IN (" . $refids . ") ";
                }
            }
            $getrefer = $this->db->query("SELECT r.*,o.id as order_ref_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.name=o.reference_id  AND  o.status='1' AND r.status ='1' " . $whr . " ORDER BY r.createdon DESC");
            $getrefer_rows = $getrefer->num_rows();
        }
        if ($getrefer_rows > 0) {
            foreach ($getrefer->result() as $res) {
                $ref_name = '"' . $res->name . '"';
                $ref_desc = '"' . $res->description . '"';
                $ref_value = '"' . $res->order_value . '"';
                if ($type == 'popup') {
                    $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs' onclick='editpopupreferencedetails(" . $res->id . "," . $res->order_ref_id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs' onclick='deletepopupreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                } else {
                    if ($order_id != "") {
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='editreferencedetails(this," . $res->id . "," . $ref_name . "," . $ref_desc . "," . $ref_value . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletereferencedetailsbyorder(" . $res->id . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRefAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Reference</a></li>";
                    } else {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    }
                }
                $res_val = $res->order_value;
                if ($res_val != "") {
                    if (DateTime::createFromFormat('Y-m-d H:i:s', $res_val) !== FALSE) {
                        $chkrtime = getdatetimebytimezone($this->session->userdata('usr_tzone')['timezone'], $res_val, DFLT_TZ);
                        $res_val = $chkrtime['datetime'];
                    } else {
                        $res_val = $res_val;
                    }
                }
                $refer[] = ['id' => $res->name, 'name' => $res->description, 'value' => $res_val, 'action' => $action];
            }
        }
        echo json_encode($refer);
    }

    public function getotherpopupreferencedetails()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        $type = isset($_POST['type']) ? $_POST['type'] : "";
        $ref_ids = isset($_POST['ref_ids']) ? $_POST['ref_ids'] : "";
        $popupref_order_id = isset($_POST['popupref_order_id']) ? $_POST['popupref_order_id'] : "";
        $getrefer_rows = 0;
        $refer = $popupref_order_ids = [];
        $whr = "";
        $action = "";
        if ($order_id != "") {
            $sql = 'SELECT r.*,o.reference_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o
            WHERE o.order_id=? AND o.reference_id =r.name AND r.status=1 AND o.status=1 ORDER BY r.createdon DESC';
            $getrefer = $this->db->query($sql, [$order_id]);
            $getrefer_rows = $getrefer->num_rows();
        } else {
            if ($ref_ids != "") {
                $refids = implode(',', $ref_ids);
                if ($popupref_order_id != "") {
                    $popupref_order_ids = implode(',', $popupref_order_id);
                    if (!empty($popupref_order_ids)) {
                        $whr = " AND o.id IN (" . $popupref_order_ids . ") ";
                    }
                }
                if (!empty($refids)) {
                    $whr .= " AND r.id IN (" . $refids . ") ";
                    $getrefer = $this->db->query("SELECT r.*,o.id as order_ref_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.name=o.reference_id AND o.status='1' AND r.status ='1' " . $whr . " ORDER BY r.createdon DESC");
                    $getrefer_rows = $getrefer->num_rows();
                }
            }
        }
        if ($getrefer_rows > 0) {
            foreach ($getrefer->result() as $res) {
                if ($type == 'popup') {
                    $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs' onclick='editpopupreferencedetails(" . $res->id . "," . $res->order_ref_id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs' onclick='deletepopupreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                } else {
                    if ($order_id != "") {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetailsbyorder(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    } else {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    }
                }
                $refer[] = ['id' => $res->name, 'name' => $res->description, 'value' => $res->order_value, 'action' => $action];
            }
        }
        echo json_encode($refer);
    }

    public function editreferencedetails()
    {
        $id = $this->input->post('id');
        $refer = [];
        $sql = 'SELECT r.*,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o
        WHERE r.id=? AND r.name=o.reference_id';
        $get_details = $this->db->query($sql, [$id]);
        if ($get_details->num_rows() > 0) {
            $refer = ['id' => $get_details->row()->id, 'ref_id' => $get_details->row()->name, 'name' => $get_details->row()->description, 'value' => $get_details->row()->order_value];
        }
        echo json_encode($refer);
    }

    public function editpopupreferencedetails()
    {
        $id = $this->input->post('id');
        $order_ref_id = isset($_POST['order_ref_id']) ? $_POST['order_ref_id'] : "";
        $refer = [];
        $whr = "";
        if ($order_ref_id != "") {
            $whr .= " AND o.id='" . $order_ref_id . "'";
        }
        $get_details = $this->db->query("SELECT r.*,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.id='" . $id . "' AND r.name=o.reference_id " . $whr);
        if ($get_details->num_rows() > 0) {
            $refer = ['order_ref_id' => $order_ref_id, 'id' => $get_details->row()->id, 'ref_id' => $get_details->row()->name, 'name' => $get_details->row()->description, 'value' => $get_details->row()->order_value];
        }
        echo json_encode($refer);
    }

    public function viewpartylist()
    {
        $parties = [];
        $user_id = $this->session->userdata('user_id');
        $type = isset($_POST['type']) ? $_POST['type'] : "0";
        $party_type = isset($_POST['party']) ? $_POST['party'] : "";
        $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : "0";
        $check = "";
        $custid = "0";
        $whr = $usrwhr = "";
        if ($customer_id == "") {
            $customer_id = 0;
        }
        $chkcompanycode = $this->session->userdata('company_code');
        if ($chkcompanycode == 'RUKN') {
            $usrwhr = "";
        } else {
            $usrwhr = " AND m.user_id='" . $user_id . "' ";
        }
        if ($chkcompanycode != 'NZKN') {
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $subcusts = array();
            if ($custid != 0) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
                        // array_push($subcusts, $custid);
                    }
                } else {
                    $subcusts = $custid;
                    // array_push($subcusts, $custid);
                }
            }
            $customer_code = [];
            if (!empty($subcusts)) {
                $select = "code";
                $table = "tb_customers";
                $customerdetails = $this->Order->getcustomercodebyids($select, $table, $subcusts);
                if (!empty($customerdetails)) {
                    foreach ($customerdetails as $cust) {
                        $customer_code[] = $cust['code'];
                    }
                }
            }

            if (!empty($customer_code)) {
                $whr = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
            }
        }
        $party_type_whr = " ";
        if ($party_type != "") {
            $party_type_whr = " AND t.name LIKE '" . $party_type . "' ";
        }
        $contact_ids = $master_ids = [];
        if ($customer_id != '0') {
            $getid = $this->common->gettblrowdata(array('code' => $customer_id), "id", 'tbl_party_master', 0, 0);
            if (!empty($getid)) {
                $customer_row_id = $getid['id'];
                $customer_row_id = $customer_row_id;


                $get_custparties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,
                m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name
                FROM tbl_party_master m,tbl_party_types t WHERE  m.company_code != '' AND m.company_code IS NOT NULL AND
                 m.company_code LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL
                 " . $usrwhr . " AND m.parent_id ='" . $customer_row_id . "'
                 AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id
                 GROUP BY m.id ORDER BY m.id DESC");
                if ($get_custparties->num_rows() > 0) {
                    foreach ($get_custparties->result() as $res) {
                        if ($type == '1') {
                            $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                        } else {
                            $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                        }
                        $contact_ids[] = $res->master_id;
                        $master_ids[] = $res->master_id;
                        $parties[] = [
                            'check' => $check,
                            'id' => $res->code,
                            'name' => $res->master_name,
                            'email' => $res->master_email_id,
                            'mobile' => $res->master_mobile,
                            'party_name' => $res->party_name,
                            'company_code' => $res->company_code,
                            'branch_code' => $res->branch_code,
                            'party_name' => $party_type,
                            'city' => $res->city,
                            'country' => $res->country,
                            'street' => $res->street
                        ];
                    }
                }
            }
        }

        $get_parties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,
        m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name
        FROM tbl_party_master m,tbl_party_types t WHERE m.company_code != ''
        AND m.company_code IS NOT NULL AND m.company_code
        LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL
        " . $whr . " " . $usrwhr . " AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL
        AND m.code != '0' AND t.id=m.party_type_id " . $party_type_whr . "
        GROUP BY m.id ORDER BY m.id DESC");
        if ($get_parties->num_rows() > 0) {
            foreach ($get_parties->result() as $res) {
                if ($type == '1') {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                } else {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                }
                $master_ids[] = $res->master_id;
                $parties[] = [
                    'check' => $check,
                    'id' => $res->code,
                    'name' => $res->master_name,
                    'email' => $res->master_email_id,
                    'mobile' => $res->master_mobile,
                    'party_name' => $res->party_name,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'party_name' => $res->party_name,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                ];
            }
        }
        $master_whr = "";
        $additional_ids = $party_types = [];
        if (!empty($master_ids)) {
            $master_whr = "AND m.id NOT IN (" . implode(',', $master_ids) . ")  ";
        }
        $getmultipleparties = $this->db->query("SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE m.code IS NOT NULL " . $master_whr . " " . $whr . " " . $usrwhr . " AND m.party_types IS NOT NULL");
        if ($getmultipleparties->num_rows() > 0) {
            foreach ($getmultipleparties->result() as $res) {
                if ($res->party_types != "" && $res->party_types != '0') {
                    $party_types = explode(',', $res->party_types);
                    if (is_array($party_types)) {
                        if (!empty($party_types)) {
                            $chkshipper = $this->db->query("SELECT id FROM tbl_party_types WHERE id IN (" . implode(',', $party_types) . ") AND name LIKE '" . $party_type . "'");
                            if ($chkshipper->num_rows() > 0) {
                                $additional_ids[] = $res->master_id;
                            }
                        }
                    }
                }
            }
        }
        if (!empty($additional_ids)) {
            $get_addids = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,
            m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street FROM tbl_party_master m
            WHERE m.id IN (" . implode(',', $additional_ids) . ") AND m.company_code != '' AND m.company_code IS NOT NULL
             AND m.company_code LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL
             " . $usrwhr . " AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0'
             GROUP BY m.id ORDER BY m.id DESC");
            if ($get_addids->num_rows() > 0) {
                foreach ($get_addids->result() as $res) {
                    if ($type == '1') {
                        $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                    } else {
                        $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                    }
                    $master_ids[] = $res->master_id;
                    $parties[] = [
                        'check' => $check,
                        'id' => $res->code,
                        'name' => $res->master_name,
                        'email' => $res->master_email_id,
                        'mobile' => $res->master_mobile,
                        'party_name' => $party_type,
                        'company_code' => $res->company_code,
                        'branch_code' => $res->branch_code,
                        'party_name' => $party_type,
                        'city' => $res->city,
                        'country' => $res->country,
                        'street' => $res->street
                    ];
                }
            }
        }
        echo json_encode($parties);
    }

    public function getshipperdetailslistbyID()
    {
        $parties = [];
        $code = $this->input->post('id');
        $code_like = '%' . $code . '%';
        $sql = 'SELECT c.id,c.name,c.phone,c.address,c.street,c.location as city,c.state,c.pincode,c.code,c.country,c.email_id,c.fax,c.company_code,c.branch_code FROM tb_customers c
        WHERE c.code LIKE ? GROUP BY c.id ORDER BY c.id DESC';
        $chkqry = $this->db->query($sql, [$code_like]);
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = [
                    'check' => "<input class='shipperlist' type='radio' name='selectshipper' id='shipperlist_" . $res->id . "' value='" . $res->code . "' onchange=selectshipper(" . $res->id . ")>",
                    'id' => $res->id,
                    'party_id' => $res->code,
                    'name' => $res->name,
                    'phone' => $res->phone,
                    'email' => $res->email_id,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                ];
            }
        }
        echo json_encode($parties);
    }

    public function getshipperListID()
    {
        $parties = [];
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
//      $whr= " AND c.user_id ='".$user_id."' ";
        if ($company_code == 'RUKN') {
            $whr = " AND c.company_code LIKE '" . $company_code . "' ";
        } else {
            $whr = " AND c.user_id ='" . $user_id . "' ";
        }
        $chkqry = $this->db->query("SELECT c.id,c.name,c.phone,c.code,c.country,c.street,c.location as city,c.email_id,c.company_code,c.branch_code
        FROM tb_customers c WHERE  c.status ='1' AND  c.company_code != '' AND c.company_code IS NOT NULL " . $whr . " GROUP BY c.id ORDER BY c.createdon DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = [
                    'check' => "<input class='shipperlist' type='radio' name='selectshipper' id='shipperlist_" . $res->id . "' value='" . $res->code . "' onchange=selectshipper(" . $res->id . ")>",
                    'id' => $res->id,
                    'party_id' => $res->code,
                    'name' => $res->name,
                    'phone' => $res->phone,
                    'email' => wordwrap($res->email_id, 25, "<br />\n"),
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                ];
            }
        }
        echo json_encode($parties);
    }

    public function getconsigneedetailsListbyID()
    {
        $user_id = 1;
        $parties = [];
        $code = $this->input->post('id');
        $code_like = '%' . $code . '%';
        $sql = 'SELECT p.id,p.party_type_id,p.name,p.email,p.street,p.location_id as city,p.state,p.mobile,p.address,p.pincode,p.country,
        p.code,p.fax FROM tbl_party_master p WHERE p.code LIKE ? ORDER BY p.id DESC';
        $chkqry = $this->db->query($sql, [$code_like]);
        if ($chkqry->num_rows() > 0) {
            $role_name = "";
            $getrolename = $this->db->select('name')->get_where("tbl_party_types", ['id' => $chkqry->row()->party_type_id]);
            if ($getrolename->num_rows() > 0) {
                $role_name = $getrolename->row()->name;
            }
            $parties[] = [
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->mobile,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->city,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'address' => $chkqry->row()->address,
                'party_type_id' => $chkqry->row()->party_type_id,
                'role_name' => $role_name
            ];
        }
        echo json_encode($parties);
    }

    public function getpartydetailsListbyID()
    {
        $parties = [];
        $code = $this->input->post('id');
        $type = isset($_POST['type']) ? $_POST['type'] : "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $branch_code = $whr = "";
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $whr = "";
        if ($company_code != "") {
            $whr .= " AND m.company_code LIKE '" . $company_code . "'";
        }
        $custid = "0";
        $whr1 = "";
        if ($company_code != 'NZKN') {
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $subcusts = [];
            if ($custid != 0) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
                        // array_push($subcusts, $custid);
                    }
                } else {
                    $subcusts = $custid;
                    // array_push($subcusts, $custid);
                }
            }
            $customer_code = [];
            if (!empty($subcusts)) {
                $select = "code";
                $table = "tb_customers";
                $customerdetails = $this->Order->getcustomercodebyids($select, $table, $subcusts);
                if (!empty($customerdetails)) {
                    foreach ($customerdetails as $cust) {
                        $customer_code[] = $cust['code'];
                    }
                }
            }
            if (!empty($customer_code)) {
                $whr1 = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
            }
        }
        $chkqry = $this->db->query("SELECT m.id,m.name,m.email,m.street,m.location_id as city,m.state,m.mobile,m.address,
        m.country,m.pincode,m.country,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,m.fax,
        t.id as partytype_id,t.name as role FROM tbl_party_master m,tbl_party_types t
        WHERE m.code LIKE '%" . $code . "%' " . $whr . " AND m.code Is NOT NULL AND m.code != '0'
        AND m.code != '' " . $whr1 . " AND t.id=m.party_type_id AND m.company_code != '' AND m.company_code IS NOT NULL
        AND m.branch_code != '' AND m.branch_code IS NOT NULL GROUP BY m.id ORDER BY m.id DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->id . "' class='consigneelist' onchange='selectparty(" . $res->id . ")' value='" . $res->code . "'>";
                if ($type == 'inv') {
                    $check = "<input type='radio' name='partylist' id='partylist_" . $res->id . "' class='partylist' onchange='selectparty(" . $res->id . ")' value='" . $res->code . "'>";
                } else {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->id . "' class='consigneelist' onchange='selectparty(" . $res->id . ")' value='" . $res->code . "'>";
                }
                $parties[] = ['check' => $check, 'id' => $res->code, 'name' => $res->name, 'email' => $res->email, 'mobile' => $res->mobile, 'party_name' => $res->role, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code, 'city' => $res->city, 'country' => $res->country, 'street' => $res->street];
            }
        }
        echo json_encode($parties);
    }

    public function getchargedesc($id)
    {
        $data['desc'] = "";
        if ($id != "") {
            $sql = 'SELECT description FROM tb_charge_codes WHERE id=? AND status=1';
            $getdesc = $this->db->query($sql, [$id]);
            if ($getdesc->num_rows() > 0) {
                $data['desc'] = $getdesc->row()->description;
            }
        }
        echo json_encode($data);
    }

    /* code for trip management */
    public function gettripcarinfo($id)
    {
        $result = [];
        if ($id != "") {
            $vendor_list = $this->db->select("code")->get_where("tb_vendors", ['id' => $id]);
            if ($vendor_list->num_rows() > 0) {
                $result['carrier_name'] = $vendor_list->row()->code;
            }
            $drivers = '<select class="add_company Txtfld tripcar_id form-control" name="tdrivernum" id="tdri_name" onchange="getdrid()"
        form="tripcreation" style="margin-top:4px;">
        <option value="">--Select--</option>';
            if ($this->session->userdata('business_type') == "Carrier") {
                $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", ['vendor_id' => $id, 'status' => 'Active']);
            } else {
                $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", ['vendor_id' => $id, 'status' => 'Active']);
                if ($drivers_list->num_rows() == 0) {
                    $user_id = $this->session->userdata('user_id');
                    $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", ['user_id' => $user_id, 'status' => 'Active']);
                }
            }
            if ($drivers_list->num_rows() > 0) {
                foreach ($drivers_list->result() as $row) {
                    $drivers .= '<option value="' . $row->id . '">' . $row->name . '</option>';
                }
            }
            $drivers .= '</select>';
            $result['drivers'] = $drivers;
        }
        echo json_encode($result);
    }

    public function gettripvelinfo()
    {
        $result = [];
        $post = $this->input->post();
        $id = $post['vtype'];
        $carrierid = $post['carrierid'];
        $res = '';
        $vtypename = $this->db->select("description")->get_where("tb_trucktypes",
            ['id' => $id]);
        if ($vtypename->num_rows() > 0) {
            $res = $vtypename->row()->description;
        }
        $result['typename'] = $res;
        $vehres = '<select name="tvehnum" id="tvehnum" onchange="myfun()"
    form="tripcreation" class="Txtfld tripcar_id form-control" style="margin-top:4px;"><option value="">--Select--</option>';
        $vehile_list = $this->db->select("id,truck_number,register_number")->get_where("tb_trucks_data", ['truck_type' => $id, 'vendor_id' => $carrierid]);
        if ($vehile_list->num_rows() > 0) {
            foreach ($vehile_list->result() as $vehi) {
                $vehres .= '<option value="' . $vehi->id . '">' . $vehi->truck_number . '</option>';
            }
        } else {
            $sql = 'select td.id,td.register_number from `tb_trucks_data` td,tb_vehicles_drivers vd,tb_vendor_vehicles vv
            where td.id=vd.vehicle_id AND td.id=vv.vehicle_id AND vd.vehicle_id=vv.vehicle_id AND
            td.truck_type=? AND vv.vendor_id=?';
            $vehile_list1 = $this->db->query($sql, [$id, $carrierid]);
            if ($vehile_list1->num_rows() > 0) {
                foreach ($vehile_list1->result() as $vehi1) {
                    $vehres .= '<option value="' . $vehi1->id . '">' . $vehi1->register_number . '</option>';
                }
            }
        }
        $vehres .= '</select>';
        $result['vehiclenum'] = $vehres;
        echo json_encode($result);
    }

    public function getvelinfo($id)
    {
        $result = [];
        $result['vehid'] = "";
        $result['transit'] = 0;
        if ($id != "") {
            $vendor_list = $this->db->select("truck_number")->get_where("tb_trucks_data", ['id' => $id]);
            if ($vendor_list->num_rows() > 0) {
                $result['vehid'] = $vendor_list->row()->truck_number;
            }
            $trip_transit = $this->db->select("id")->get_where("tb_trips", ['vehicle_id' => $id, 'status' => 1]);
            if ($trip_transit->num_rows() > 0) {
                /*$result['vehid']   = '';*/
                $result['transit'] = 1;
            }
        }
        echo json_encode($result);
    }

    public function getdriverid($id)
    {
        $res = '';
        if ($id != "") {
            $driver_list = $this->db->select("contact_num")->get_where("tb_truck_drivers", ['id' => $id], 1, 0);
            if ($driver_list->num_rows() > 0) {
                $res = $driver_list->row()->contact_num;
            }
        }
        echo $res;
    }

    public function tripcreatemultiorder($input)
    {
        $response = 0;
        $userid = $input['user_id'];
        $curtz = $input['curtz'];
        $logdate = date('Y-m-d H:i:s');
        $curdt = $input['curdt'];
        $year = date('y');
        $week = date('W');
        $coun_sess = $input['company_code'];
        $count_code = substr($coun_sess, 0, 2);
        $where = " id IN(" . $input['ordid'] . ")";
        $select = "*";
        $table = "tb_orders";
        $orders = $this->common->gettbldata($where, $select, $table, 0, 0);
        $seq_num = 000001;
        $ordcnt = count($orders);
        for ($k = 0; $k < $ordcnt; $k++) {
            $orderNumbers[] = $orders[$k]['order_id'];
            $pickUpDates[] = $orders[$k]['pickup_datetime'];
            $customerIds[] = $orders[$k]['customer_id'];
            $createdSource[] = $orders[$k]['created_source'];
            $orderIds[] = $orders[$k]['id'];
        }
        if ($ordcnt > 0) {
            $order_nm = $orders[0]['order_id'];
            $seq_num = substr($order_nm, -6);
            $shipid = "T" . $count_code . $week . $year . $seq_num;
            $vendor_id = $input['carrierid'];
            $vehicle_id = isset($input['tvehnum']) ? $input['tvehnum'] : "";
            $driver_id = isset($input['tdrivernum']) ? $input['tdrivernum'] : "";
            $tpvehicle_type = isset($input['vehicle_type']) ? $input['vehicle_type'] : 0;
            $carrier_instructions = isset($input['carrier_instructions']) ? $input['carrier_instructions'] : "";
            $vehicle_type = "";
            if ($shipid != "" && $vendor_id > 0) {
                $i = $j = 0;
                $weight = 0;
                $volume = 0;
                $quantity = 0;
                foreach ($orders as $order) {
                    $j++;
                    $i++;
                    $ordid = $order['id'];
                    $pickup = $order['pickup_address1'];
                    if ($pickup == "") {
                        $pickup = $order['pickup_city'];
                    }
                    $delivery = $order['delivery_address1'];
                    if ($delivery == "") {
                        $delivery = $order['delivery_city'];
                    }
                    $address = $dropaddr = "";
                    if ($order['pickup_address1'] != "") {
                        $address .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if ($order['pickup_company'] != "") {
                        $address .= ", " . $order['pickup_company'];
                        $dropaddr .= ", " . $order['delivery_company'];
                    }
                    if ($order['pickup_country'] != "") {
                        $address .= ", " . $order['pickup_country'];
                        $dropaddr .= ", " . $order['delivery_country'];
                    }
                    if ($order['pickup_city'] != "") {
                        $address .= ", " . $order['pickup_city'];
                        $dropaddr .= ", " . $order['delivery_city'];
                    }
                    if ($order['pickup_pincode'] != "") {
                        $address .= ", " . $order['pickup_pincode'];
                        $dropaddr .= ", " . $order['delivery_pincode'];
                    }
                    if ($order['weight'] == "") {
                        $order['weight'] = 1;
                    }
                    if ($order['volume'] == "") {
                        $order['volume'] = 1;
                    }
                    if ($order['quantity'] == "") {
                        $order['quantity'] = 1;
                    }
                    $weight += $order['weight'];
                    $volume += $order['volume'];
                    $quantity += $order['quantity'];
                    $plat = $order['plat'];
                    $plng = $order['plng'];
                    $dlat = $order['dlat'];
                    $dlng = $order['dlng'];
                    $where = array("shipmentid" => $shipid);
                    $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                    $table = "tb_shifts";
                    $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($shipment) == 0) {
                        $customer_id = $order['customer_id'];
                        $transport_mode = $order['transport_mode'];
                        $txnid = $shipid;
                        if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                            $vtwhere = array("id" => $tpvehicle_type);
                            $vtselect = "trucktype";
                            $vttable = "tb_trucktypes";
                            $vtorder = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                            if (count($vtorder) > 0) {
                                $vehicle_type = $vtorder['trucktype'];
                            } else {
                                $vehicle_type = $order['vehicle_type'];
                            }
                        } else {
                            $vehicle_type = $order['vehicle_type'];
                        }
                        $startdate = $order['pickup_datetime'];
                        $starttime = date('H:i', strtotime($startdate));
                        $enddate = $order['delivery_datetime'];
                        $endtime = date('H:i', strtotime($enddate));
                        $insarr = [
                            'user_id' => $userid,
                            'stime' => $starttime,
                            'etime' => $endtime,
                            'splace' => $order['pickup_city'],
                            'slat' => $plat,
                            'slng' => $plng,
                            'eplace' => $order['delivery_city'],
                            'elat' => $dlat,
                            'elng' => $dlng,
                            'scity' => $order['pickup_city'],
                            'dcity' => $order['delivery_city'],
                            'zone_id' => 1,
                            'empshift_start' => $starttime,
                            'empshift_end' => $endtime,
                            'trip_type' => 0,
                            'startdate' => $startdate,
                            'enddate' => $enddate,
                            'shipment_name' => 'Boxes',
                            'shipment_id' => 0,
                            'transport_mode' => $transport_mode,
                            'customer_id' => $customer_id,
                            'vendor_id' => $vendor_id,
                            'carrier_type' => 0,
                            'shipmentid' => $shipid,
                            'txnid' => $txnid,
                            'weight' => $weight,
                            'volume' => $volume,
                            'units' => $quantity,
                            'domainname' => 'INFD',
                            'vehicle_type' => $vehicle_type,
                            'company_code' => $order['company_code'],
                            'branch_code' => $order['branch_code'],
                            'carrier_instructions' => $carrier_instructions,
                            'status' => 1
                        ];
                        $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                    } else {
                        if ($ordcnt == $j) {
                            $enddate = $order['delivery_datetime'];
                            $endtime = date('H:i', strtotime($enddate));
                            $updarr = ['etime' => $endtime, 'eplace' => $order['delivery_city'], 'elat' => $dlat, 'elng' => $dlng, 'dcity' => $order['delivery_city'], 'empshift_end' => $endtime, 'enddate' => $enddate, 'weight' => $weight, 'volume' => $volume, 'units' => $quantity, 'carrier_instructions' => $carrier_instructions];
                            $upd = $this->common->updatetbledata("tb_shifts", $updarr, ["id" => $shipment['id']]);
                        }
                        $ship_id = $shipment['id'];
                    }
                    /*update order table*/
                    $upddt = ['vendor_id' => $vendor_id, 'shift_id' => $ship_id, "shipmentid" => $shipid, 'status' => 2];
                    $updwhr = ["id" => $ordid];
                    $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                    $this->ordernotify('trip_create', $ordid);
                    $capacity = $order['weight'];
                    if ($capacity == "") {
                        $capacity = "0";
                    }
                    /*insert stops records */
                    $where = ["shipment_id" => $ship_id, 'plat' => $plat, 'plng' => $plng, "stopcity" => $order['pickup_city'], "stoptype" => "P"];
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr = [
                            'stopname' => $order['pickup_city'],
                            'plat' => $plat,
                            'plng' => $plng,
                            'stopcity' => $order['pickup_city'],
                            'address' => $address,
                            'stoptype' => 'P',
                            'stopstatus' => 0,
                            'shipment_id' => $ship_id,
                            'ordernumber' => $j,
                            'startdate' => $order['pickup_datetime'],
                            'enddate' => $order['delivery_datetime'],
                            'weight' => $order['weight'],
                            'volume' => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units' => $order['quantity'],
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $curdt
                        ];
                        $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                        $pickupstop_id = $this->db->insert_id();
                    } else {
                        $pickupstop_id = $chkstop['id'];
                    }
                    $where = ["shipment_id" => $ship_id, 'plat' => $dlat, 'plng' => $dlng, "stopcity" => $order['delivery_city'], "stoptype" => "D"];
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr = [
                            'stopname' => $order['delivery_city'],
                            'plat' => $dlat,
                            'plng' => $dlng,
                            'stopcity' => $order['delivery_city'],
                            'address' => $dropaddr,
                            'stoptype' => 'D',
                            'stopstatus' => 0,
                            'shipment_id' => $ship_id,
                            'ordernumber' => $i + 1,
                            'startdate' => $order['delivery_datetime'],
                            'enddate' => $order['delivery_datetime'],
                            'weight' => $order['weight'],
                            'volume' => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units' => $order['quantity'],
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $curdt
                        ];
                        $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                        $dropstop_id = $this->db->insert_id();
                    } else {
                        $dropstop_id = $chkstop['id'];
                    }
                    /*add pickupstop and drop stop id into details/tb_employee table */
                    $where = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'shift_id' => $ship_id];
                    $select = "id";
                    $table = "tb_employee";
                    $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkemp) == 0) {
                        $insarr = [
                            'assoc_id' => $shipid,
                            'pickup' => $pickup,
                            'plat' => $plat,
                            'plng' => $plng,
                            'drop' => $delivery,
                            'dlat' => $dlat,
                            'dlng' => $dlng,
                            'pickup_city' => $order['pickup_city'],
                            'drop_city' => $order['delivery_city'],
                            'pickup_datetime' => $order['pickup_datetime'],
                            'drop_datetime' => $order['delivery_datetime'],
                            'name' => 'Boxes',
                            'phone' => $order['customer_phone'],
                            'address' => $address,
                            'emailid' => $order['customer_email'],
                            'user_id' => $userid,
                            'status' => 1,
                            'createdon' => $curdt,
                            'material_id' => 0,
                            'capacity' => $capacity,
                            'information' => $order['customer_comments'],
                            'shipment_weight' => $order['weight'],
                            'shipment_volume' => $order['volume'],
                            'ship_type' => 'P',
                            'customer_id' => $order['customer_id'],
                            'vendor_id' => $vendor_id,
                            'shipment_id' => 0,
                            'startdate' => $order['pickup_datetime'],
                            'enddate' => $order['delivery_datetime'],
                            'shift_id' => $ship_id,
                            'stop_order' => 1,
                            'drop_order' => 0,
                            'basic_stop' => 0,
                            'stop_id' => $pickupstop_id,
                            'drop_stopid' => $dropstop_id,
                            'order_id' => $order['order_id'],
                            'pkgitemid' => 'BOXES',
                            'no_of_pkgs' => $order['quantity'],
                            'domainname' => 'INFD'
                        ];
                        $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                    } else {
                        $detail_id = $chkemp['id'];
                    }
                    $sql = 'SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im
                    WHERE oc.order_id = ? AND im.id = oc.handling_unit AND oc.status=1';
                    $stops_units = $this->db->query($sql, [$ordid]);
                    if ($stops_units->num_rows() > 1) {
                        $odata = $stops_units->row();
                        $sql = 'UPDATE tb_order_cargodetails set stop_detail_id=? WHERE id = ?';
                        $upd = $this->db->query($sql, [$detail_id, $odata->id]);
                    }
                    $chk1 = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $ship_id], 1, 0);
                    if ($chk1->num_rows() > 0) {
                        $shftvehid = $chk1->row()->id;
                        $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                        if ($chk->num_rows() == 0) {
                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                            if ($getemp->num_rows() > 0) {
                                $pri = 1;
                                foreach ($getemp->result() as $gt) {
                                    $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                    $pri++;
                                }
                            }
                        } else {
                            $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                            if ($chkemp->num_rows() == 0) {
                                $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                            }
                        }
                    } else {
                        if ($vehicle_id != "") {
                            $veh_num = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
                            $arr = ['user_id' => $userid, 'route_id' => 0, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id, 'vehicle_id' => $vehicle_id, 'register_number' => $veh_num, 'created_on' => $curdt, 'updated_on' => $curdt, 'status' => 1];
                            $shftvehid = $this->common->insertTableData("tb_shft_veh", $arr);
                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                            if ($getemp->num_rows() > 0) {
                                $pri = 1;
                                foreach ($getemp->result() as $gt) {
                                    $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                    $pri++;
                                }
                            }
                        }
                    }
                    if ($vehicle_id != "" && $driver_id != "") {
                        $chk = $this->db->select("id,driver_id,status")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["vehicle_id" => $vehicle_id]);
                        if ($chk->num_rows() > 0) {
                            if ($driver_id == $chk->row()->driver_id) {
                                $upd = $this->db->where(["id" => $chk->row()->id])->update("tb_vehicles_drivers", ["status" => 1]);
                            } else {
                                $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                            }
                        } else {
                            $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                            $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                        }
                        $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $driver_id, "vehicle_id" => $vehicle_id], 1, 0);
                        if ($chk11->num_rows() > 0) {
                            $upd = $this->db->where(["id" => $chk11->row()->id])->update("tbl_assigned_drivers", ["status" => "1", 'updated_on' => $curdt]);
                        } else {
                            $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id <>" => $driver_id, "vehicle_id" => $vehicle_id, "status" => 1], 1, 0);
                            if ($chk111->num_rows() == 0) {
                                $ins = $this->common->insertTableData("tbl_assigned_drivers", ["vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "mobile_no" => $driver_id, "imei" => $imei, "from_time" => $curdt, "to_time" => $curdt, "status" => "1", 'created_on' => $curdt]);
                            } else {
                                $upd = $this->db->where(["id" => $chk111->row()->id])->update("tbl_assigned_drivers", ["driver_id" => $driver_id, 'updated_on' => $curdt]);
                            }
                        }
                    }
                    $response = 1;
                    /* update status */
                    $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $ship_id, "status_id" => 9], 1, 0);
                    if ($chk->num_rows() == 0) {
                        $ins = ["shipment_id" => $ship_id, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $curdt];
                        $insqry = $this->common->insertTableData("tb_stop_status", $ins);
                    }
                    /*send email notification*/
                    if ($vendor_id != "") {
                        //spoton code starts here
                        $compnay_code = $coun_sess;
                        if ($compnay_code == 'INKN' && $vendor_id == '164') {
                            $this->getconinfo($ordid);
                        }
                        //spoton code ends here
                        /*border code starts here*/
                        /*border code ends here*/
                    }
                }
                /* Push notification to mobile using Firebase */
                $customerNames = $knTrackingNos=[];
                if (!empty($customerIds)) {
                    $customerData = $this->common->gettbldata("id IN (" . implode(",", $customerIds) . ")", "name", "tb_customers", 0, 0);
                    $customerNames = array_merge($customerNames, array_column($customerData, 'name'));
                }
                if (!empty($createdSource)) {
                    $referenceId = in_array(18, $createdSource) ? 'AWB' : 'DQ';
                    $whereCondition = "order_id IN (" . implode(",", $orderIds) . ") AND reference_id = '" . $referenceId . "' AND status = '1'";
                    $trackingData = $this->common->gettbldata($whereCondition, "ref_value", "tb_order_references", 0, 0);
                    $knTrackingNos = array_merge($knTrackingNos, array_column($trackingData, 'ref_value'));
                }
                if ($shipid != "" && $driver_id > 0) {
                    $customerName = implode(", ", $customerNames);
                    $pickUpDate = implode(
                        ", ",
                        array_map(function ($date) {
                            return substr($date, 0, 10);
                        }, $pickUpDates)
                    );
                    $bookingID = implode(", ", $orderNumbers);
                    $knTrackingNo = implode(", ", $knTrackingNos);
                    $message = "New trip is assigned" . " "
                        . "Pickup Date: " . $pickUpDate . " "
                        . "Customer Name: " . $customerName . " "
                        . "Booking ID: " . $bookingID . " "
                        . "Trip No: " . $shipid . " "
                        . "KN tracking No: " . $knTrackingNo;
                    $messageData = json_encode(["msg" => $message, "info" => (object)[], "type"=>1],JSON_UNESCAPED_UNICODE);
                    $this->load->library('sendfirebase');
                    $fire_ret = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driver_id, 'type' => 'Driver']);
                }
                /* END Push notification to mobile using Firebase */

            }
        }

        return $response;
    }

    public function triporderintoshipment()
    {
        $response = 0;
        $userid = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt = $getactual['datetime'];
        $input = $this->input->post(NULL, TRUE);
        /*$shipid = $input['ship_id'];*/
        /*trip id generation*/
        $input['user_id'] = $userid;
        $input['curtz'] = $curtz;
        $input['curdt'] = $curdt;
        $input['company_code'] = $this->session->userdata('company_code');
        $input['branch_code'] = $this->session->userdata('branch_code');
        $ordeschk = explode(",", $input['ordid']);
        if ($input['carrierid'] == 277 && !empty($input['vehicle_type']) && $input['company_code'] == 'AUKN') {
            $this->load->helper('bonds_helper');
            foreach ($ordeschk as $ordid) {
                $edi_res = bondsbooking(array('ordid' => $ordid, 'vehicle_type' => $input['vehicle_type']));
                if ($edi_res['status'] == 0) {
                    $orderinfo = $this->common->gettblrowdata(array('id' => $ordid), 'order_id', 'tb_orders', 0, 0);
                    $error_msg = "Bonds Couriers Errors for order #" . $orderinfo['order_id'];
                    foreach ($edi_res['errors'] as $error) {
                        if (is_array($error)) {
                            foreach ($error as $er) {
                                $error_msg .= '<p>' . $er . '</p>';
                            }
                        } else {
                            $error_msg .= '<p>' . $error . '</p>';
                        }
                    }
                    $this->session->set_flashdata('edierror_msg', $error_msg);
                    redirect('amzorders');
                }
            }
        }
        if (count($ordeschk) > 1) {
            if ($input['trip_type'] == 'multi') {
                $response = $this->tripcreatemultiorder($input);
            } else {
                $getref = $this->db->query("SELECT GROUP_CONCAT(order_id) as orders FROM tb_order_references WHERE order_id IN(" . $input['ordid'] . ") AND reference_id='ROT' AND status=1 GROUP BY ref_value");
                /*log_message("error","0th ".$this->db->last_query());*/
                if ($getref->num_rows() > 0) {
                    foreach ($getref->result_array() as $reford) {
                        $input['ordid'] = $reford['orders'];
                        $response = $this->tripcreatemultiorder($input);
                    }
                } else {
                    $response = $this->eachordercreatetrip($input);
                }
            }
        } else {
            $response = $this->eachordercreatetrip($input);
        }
        if ($response == 1) {
            $this->session->set_flashdata('success_msg', 'Trip Created Successfully.');
        } else if ($response == 2) {
            $this->session->set_flashdata('error_msg', 'Your selected orders are not in same root.(example: Ref. ID (ROT))');
        } else {
            $this->session->set_flashdata('error_msg', 'Oops..Something Went Wrong.');
        }
        redirect('amzorders');
    }

    public function eachordercreatetrip($ordinput)
    {
        $response = 0;
        $userid = $ordinput['user_id'];
        $year = date('y');
        $week = date('W');
        $curtz = $ordinput['curtz'];
        $curdt = date('Y-m-d H:i:s');
        $count_code = substr($ordinput['company_code'], 0, 2);
        $ordeschk = explode(",", $ordinput['ordid']);
        foreach ($ordeschk as $chkord) {
            $input['ordid'] = $chkord;
            $where = ["id" => $input['ordid']];
            $select = "*";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            $seq_num = 000001;
            if (count($order) > 0) {
                if ($order['shift_id'] != 0) {
                    $this->session->set_flashdata('error_msg', 'Trip already created for this order. Please check details.');
                    redirect('amzorders');
                }
                $order_nm = $order['order_id'];
                $seq_num = substr($order_nm, -6);
            }
            $shipid = "T" . $count_code . $week . $year . $seq_num;
            /* check for exists */
            /*$twhere = array("shipmentid"=>$shipid);
        $tselect = "id";
        $ttable = "tb_shifts";
        $tship = $this->common->gettblrowdata($twhere,$tselect,$ttable,0,0);
        if(count($tship)>0){
            $seq_num = ($seq_num + 1);
            $shipid = "T".$count_code.$week.$year.$seq_num;
        }*/
            /*trip id creation ends here*/
            $vendor_id = $ordinput['carrierid'];
            $vehicle_id = isset($ordinput['tvehnum']) ? $ordinput['tvehnum'] : "";
            $driver_id = isset($ordinput['tdrivernum']) ? $ordinput['tdrivernum'] : "";
            $tpvehicle_type = isset($ordinput['vehicle_type']) ? $ordinput['vehicle_type'] : 0;
            $carrier_instructions = isset($ordinput['carrier_instructions']) ? $ordinput['carrier_instructions'] : "";
            $vehicle_type = "";
            if ($shipid != "" && $vendor_id > 0 && $input['ordid'] > 0) {
                $sid = $input['ordid'];
                if (count($order) > 0) {
                    $shift_idchk = $order['shift_id'];
                    if ($shift_idchk == 0) {
                        $pickup = $order['pickup_address1'];
                        if ($pickup == "") {
                            $pickup = $order['pickup_city'];
                        }
                        $delivery = $order['delivery_address1'];
                        if ($delivery == "") {
                            $delivery = $order['delivery_city'];
                        }
                        $address = $dropaddr = "";
                        if ($order['pickup_address1'] != "") {
                            $address .= $order['pickup_address1'];
                            $dropaddr .= $order['delivery_address1'];
                        }
                        if ($order['pickup_company'] != "") {
                            $address .= ", " . $order['pickup_company'];
                            $dropaddr .= ", " . $order['delivery_company'];
                        }
                        if ($order['pickup_country'] != "") {
                            $address .= ", " . $order['pickup_country'];
                            $dropaddr .= ", " . $order['delivery_country'];
                        }
                        if ($order['pickup_city'] != "") {
                            $address .= ", " . $order['pickup_city'];
                            $dropaddr .= ", " . $order['delivery_city'];
                        }
                        if ($order['pickup_pincode'] != "") {
                            $address .= ", " . $order['pickup_pincode'];
                            $dropaddr .= ", " . $order['delivery_pincode'];
                        }
                        $plat = $order['plat'];
                        $plng = $order['plng'];
                        $dlat = $order['dlat'];
                        $dlng = $order['dlng'];
                        $where = array("shipmentid" => $shipid);
                        $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                        $table = "tb_shifts";
                        $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($shipment) == 0) {
                            $splace = $order['pickup_address1'];
                            $eplace = $order['delivery_address1'];
                            $pickup_city = $order['pickup_city'];
                            $delivery_city = $order['delivery_city'];
                            $customer_id = $order['customer_id'];
                            $transport_mode = $order['transport_mode'];
                            $weight = $order['weight'];
                            $volume = $order['volume'];
                            $txnid = $shipid;
                            if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                                $vtwhere = array("id" => $tpvehicle_type);
                                $vtselect = "trucktype";
                                $vttable = "tb_trucktypes";
                                $vtorder = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                                if (count($vtorder) > 0) {
                                    $vehicle_type = $vtorder['trucktype'];
                                } else {
                                    $vehicle_type = $order['vehicle_type'];
                                }
                            } else {
                                $vehicle_type = $order['vehicle_type'];
                            }
                            $startdate = $order['pickup_datetime'];
                            $starttime = date('H:i', strtotime($startdate));
                            $enddate = $order['delivery_datetime'];
                            $endtime = date('H:i', strtotime($enddate));
                            /* $getactual = getdatetimebytimezone(DFLT_TZ,$enddate,$curtz);
                       $enddate = $getactual['datetime'];*/
                            $insarr = [
                                'user_id' => $userid,
                                'stime' => $starttime,
                                'etime' => $endtime,
                                'splace' => $order['pickup_city'],
                                'slat' => $plat,
                                'slng' => $plng,
                                'eplace' => $order['delivery_city'],
                                'elat' => $dlat,
                                'elng' => $dlng,
                                'scity' => $order['pickup_city'],
                                'dcity' => $order['delivery_city'],
                                'zone_id' => 1,
                                'empshift_start' => $starttime,
                                'empshift_end' => $endtime,
                                'trip_type' => 0,
                                'startdate' => $startdate,
                                'enddate' => $enddate,
                                'shipment_name' => 'Boxes',
                                'shipment_id' => 0,
                                'transport_mode' => $transport_mode,
                                'customer_id' => $customer_id,
                                'vendor_id' => $vendor_id,
                                'carrier_type' => 0,
                                'shipmentid' => $shipid,
                                'txnid' => $txnid,
                                'weight' => $weight,
                                'volume' => $volume,
                                'units' => $order['quantity'],
                                'domainname' => 'INFD',
                                'vehicle_type' => $vehicle_type,
                                'company_code' => $order['company_code'],
                                'branch_code' => $order['branch_code'],
                                'carrier_instructions' => $carrier_instructions,
                                'status' => 1
                            ];
                            $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                        } else {
                            $ship_id = $shipment['id'];
                        }
                        /*update order table*/
                        $upddt = ['vendor_id' => $vendor_id, 'shift_id' => $ship_id, "shipmentid" => $shipid];
                        $updwhr = ["id" => $input['ordid']];
                        $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                        $this->ordernotify('trip_create', $input['ordid']);
                        $capacity = $order['weight'];
                        if ($capacity == "") {
                            $capacity = "0";
                        }
                        /*update orders table*/
                        $updwhr = ['id' => $input['ordid']];
                        $setwhr = ['status' => 2];
                        $ins = $this->db->where($updwhr)->update("tb_orders", $setwhr);
                        /*insert stops records */
                        $where = ["shipment_id" => $ship_id, "stopcity" => $order['pickup_city'], "stoptype" => "P"];
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr = [
                                'stopname' => $order['pickup_city'],
                                'plat' => $plat,
                                'plng' => $plng,
                                'stopcity' => $order['pickup_city'],
                                'address' => $address,
                                'stoptype' => 'P',
                                'stopstatus' => 0,
                                'shipment_id' => $ship_id,
                                'ordernumber' => 1,
                                'startdate' => $order['pickup_datetime'],
                                'enddate' => $order['delivery_datetime'],
                                'weight' => $order['weight'],
                                'volume' => $order['volume'],
                                'shipmentstopid' => 0,
                                'ship_units' => $order['quantity'],
                                'txncode' => 'NP',
                                'status' => 1,
                                'created_on' => $curdt
                            ];
                            $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                            $pickupstop_id = $this->db->insert_id();
                        } else {
                            $pickupstop_id = $chkstop['id'];
                        }
                        $where = ["shipment_id" => $ship_id, "stopcity" => $order['delivery_city'], "stoptype" => "D"];
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr = [
                                'stopname' => $order['delivery_city'],
                                'plat' => $dlat,
                                'plng' => $dlng,
                                'stopcity' => $order['delivery_city'],
                                'address' => $dropaddr,
                                'stoptype' => 'D',
                                'stopstatus' => 0,
                                'shipment_id' => $ship_id,
                                'ordernumber' => 2,
                                'startdate' => $order['delivery_datetime'],
                                'enddate' => $order['delivery_datetime'],
                                'weight' => $order['weight'],
                                'volume' => $order['volume'],
                                'shipmentstopid' => 0,
                                'ship_units' => $order['quantity'],
                                'txncode' => 'NP',
                                'status' => 1,
                                'created_on' => $curdt
                            ];
                            $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                            $dropstop_id = $this->db->insert_id();
                        } else {
                            $dropstop_id = $chkstop['id'];
                        }
                        /*add pickupstop and drop stop id into details/tb_employee table */
                        $where = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'shift_id' => $ship_id];
                        $select = "id";
                        $table = "tb_employee";
                        $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr = [
                                'assoc_id' => $shipid,
                                'pickup' => $pickup,
                                'plat' => $plat,
                                'plng' => $plng,
                                'drop' => $delivery,
                                'dlat' => $dlat,
                                'dlng' => $dlng,
                                'pickup_city' => $order['pickup_city'],
                                'drop_city' => $order['delivery_city'],
                                'pickup_datetime' => $order['pickup_datetime'],
                                'drop_datetime' => $order['delivery_datetime'],
                                'name' => 'Boxes',
                                'phone' => $order['customer_phone'],
                                'address' => $address,
                                'emailid' => $order['customer_email'],
                                'user_id' => $userid,
                                'status' => 1,
                                'createdon' => $curdt,
                                'material_id' => 0,
                                'capacity' => $capacity,
                                'information' => $order['customer_comments'],
                                'shipment_weight' => $order['weight'],
                                'shipment_volume' => $order['volume'],
                                'ship_type' => 'P',
                                'customer_id' => $order['customer_id'],
                                'vendor_id' => $vendor_id,
                                'shipment_id' => 0,
                                'startdate' => $order['pickup_datetime'],
                                'enddate' => $order['delivery_datetime'],
                                'shift_id' => $ship_id,
                                'stop_order' => 1,
                                'drop_order' => 0,
                                'basic_stop' => 0,
                                'stop_id' => $pickupstop_id,
                                'drop_stopid' => $dropstop_id,
                                'order_id' => $order['order_id'],
                                'pkgitemid' => 'BOXES',
                                'no_of_pkgs' => $order['quantity'],
                                'domainname' => 'INFD'
                            ];
                            $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                        } else {
                            $detail_id = $chkemp['id'];
                        }
                        $sql = 'SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im
                        WHERE oc.order_id = ? AND im.id = oc.handling_unit AND oc.status=1';
                        $stops_units = $this->db->query($sql, [$sid]);
                        if ($stops_units->num_rows() > 1) {
                            $odata = $stops_units->row();
                            $sql = 'UPDATE tb_order_cargodetails set stop_detail_id=? WHERE id = ?';
                            $upd = $this->db->query($sql, [$detail_id, $odata->id]);
                        }
                        $chk1 = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $ship_id], 1, 0);
                        if ($chk1->num_rows() > 0) {
                            $shftvehid = $chk1->row()->id;
                            $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                            if ($chk->num_rows() == 0) {
                                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                                if ($getemp->num_rows() > 0) {
                                    $pri = 1;
                                    foreach ($getemp->result() as $gt) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                        $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                        $pri++;
                                    }
                                }
                            } else {
                                $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                                if ($chkemp->num_rows() == 0) {
                                    $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                }
                            }
                        } else {
                            if ($vehicle_id != "") {
                                $veh_num = isset($ordinput['vehicle_id']) ? $ordinput['vehicle_id'] : "";
                                $arr = ['user_id' => $userid, 'route_id' => 0, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id, 'vehicle_id' => $vehicle_id, 'register_number' => $veh_num, 'created_on' => $curdt, 'updated_on' => $curdt, 'status' => 1];
                                $shftvehid = $this->common->insertTableData("tb_shft_veh", $arr);
                                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array("shift_id" => $ship_id));
                                if ($getemp->num_rows() > 0) {
                                    $pri = 1;
                                    foreach ($getemp->result() as $gt) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                        $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                        $pri++;
                                    }
                                }
                            }
                        }
                        if ($vehicle_id != "" && $driver_id != "") {
                            $chk = $this->db->select("id,driver_id,status")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["vehicle_id" => $vehicle_id]);
                            if ($chk->num_rows() > 0) {
                                if ($driver_id == $chk->row()->driver_id) {
                                    $upd = $this->db->where(["id" => $chk->row()->id])->update("tb_vehicles_drivers", ["status" => 1]);
                                } else {
                                    $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                    $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                                }
                            } else {
                                $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                            }
                            $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $driver_id, "vehicle_id" => $vehicle_id], 1, 0);
                            if ($chk11->num_rows() > 0) {
                                $upd = $this->db->where(["id" => $chk11->row()->id])->update("tbl_assigned_drivers", ["status" => "1", 'updated_on' => $curdt]);
                            } else {
                                $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id <>" => $driver_id, "vehicle_id" => $vehicle_id, "status" => 1], 1, 0);
                                if ($chk111->num_rows() == 0) {
                                    $ins = $this->common->insertTableData("tbl_assigned_drivers", ["vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "mobile_no" => $driver_id, "imei" => $imei, "from_time" => $curdt, "to_time" => $curdt, "status" => "1", 'created_on' => $curdt]);
                                } else {
                                    $upd = $this->db->where(["id" => $chk111->row()->id])->update("tbl_assigned_drivers", ["driver_id" => $driver_id, 'updated_on' => $curdt]);
                                }
                            }
                        }
                        $response = 1;
                        /* update status */
                        $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $ship_id, "status_id" => 9], 1, 0);
                        if ($chk->num_rows() == 0) {
                            $curdt1 = $ordinput['curdt'];
                            $ins = ["shipment_id" => $ship_id, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $curdt1];
                            $insqry = $this->common->insertTableData("tb_stop_status", $ins);
                        }
                        /*send email notification*/
                        if ($vendor_id != "") {
                            /*spoton code starts here*/
                            if ($ordinput['company_code'] == 'INKN' && $vendor_id == '164') {
                                $this->getconinfo($input['ordid']);
                            }
                            /*spoton code ends here*/
                            /*Vendor Maruthi Api Condition */
                            if ($ordinput['company_code'] == 'INKN' && $vendor_id == 194) {
                                $this->GetOrderIntoapi($order['order_id']);
                            }
                            /*end  Vendor Maruthi Api Condition*/
                        }
                    }
                }
            }
        }
        $this->load->helper('pushnotification_helper');
        mobilePushNotification($ordinput);

        return $response;
    }

    /* code for trip management */
    public function orderlabel($order_id)
    {
        $data = $order_types = [];
        require 'vendor/autoload.php';
        $reference = $shipmentnumber = $communication_reference = $date = "";
        $drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = "";
        $cargos = $drop_details = $shipper_details = [];
        if ($order_id != "") {
            if ($this->session->userdata('cust_id') == TRUE) {
                $upd_orderstatus = $this->db->where(array('id' => $order_id))->update("tb_orders", ['order_status' => 'READY']);
            }
            $chkorder = $this->Order->getordertoedit($order_id);
            if ($chkorder->num_rows() > 0) {
                $date = $chkorder->row()->pickup_datetime;
                $reference = $chkorder->row()->shipment_id;
                if ($reference != "" && $reference != 0) {
                    $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", ['id' => $reference]);
                    if ($getshipment_number->num_rows() > 0) {
                        $reference = $getshipment_number->row()->shipid;
                    }
                }
                $shipmentnumber = $chkorder->row()->order_id;
                $communication_reference = $chkorder->row()->purchase_order;
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $sql = 'SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type
                FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1
                WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
                $chekparty = $this->db->query($sql, [$order_id]);
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = ['id' => $rr->id, 'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'fax' => $rr->fax, 'party_id' => $rr->code];
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = ['id' => $rr->id, 'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'fax' => $rr->fax, 'party_id' => $rr->code];
                            }
                        }
                    }
                }
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;
                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
                $sql = 'SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o
                WHERE o.order_id =? AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC';
                $qry = $this->db->query($sql, [$order_id]);

                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $units = $res->weight_unit;
                        if ($units == "") {
                            $units = "Kg";
                        }
                        $qty = $res->quantity;
                        $wt = @round(($res->weight / $qty), 2);
                        for ($i = 1; $i <= $qty; $i++) {
                            $cargos[] = ['id' => $res->id, 'weight' => $wt . " " . $units];
                        }
                    }
                }
            }
            $data['drop_details'] = $drop_details;
            $data['shipper_details'] = $shipper_details;
            $data['reference'] = $reference;
            $data['shipmentnumber'] = $shipmentnumber;
            $data['communication_reference'] = $communication_reference;
            if ($date != "") {
                $timestamp = strtotime($date);
                $data['date'] = date('d M Y', $timestamp);
            }
            $data['cargos'] = $cargos;
            $ordernumber = $chkorder->row()->order_id;
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'format' => [100, 110],
                'margin_left' => 0,
                'margin_right' => 0,
                'margin_top' => 0,
                'margin_bottom' => 0,
                'margin_header' => 0,
                'margin_footer' => 0,
                'tempDir' => FCPATH . 'assets/tmp',
            ]);
            $html = "";
            $i = 1;
            $data['count'] = count($cargos);
            foreach ($cargos as $cargo) {
                $data['weight'] = $cargo['weight'];
                $data['no'] = $i;
                $html .= $this->load->view('amzorders/orderlabel', $data, TRUE);
                /*$mpdf->WriteHTML($html);*/
                $i++;
            }
            $data1['labelcontent'] = $html;
            $output = $this->load->view('amzorders/order_label', $data1, TRUE);
            $mpdf->WriteHTML($output);
            $mpdf->Output($ordernumber . "_" . date('YmdHis') . ".pdf", 'D');
        }
    }

    public function getorderdetails($order_id)
    {
        if ($order_id != "") {
            $cdate = date('Y-m-d H:i:s');
            $chkorder = $this->Order->getordertoedit($order_id);
            $tripsts = "Pending";
            $order_status = "PENDING";
            if ($chkorder->num_rows() > 0) {
                $status = $chkorder->row()->status;
                $trip_sts = $chkorder->row()->trip_sts;
                $trip_id = $chkorder->row()->trip_id;
                if ($trip_id != 0 && $trip_sts == 0) {
                    $order_status = 'ACTIVE';
                    $tripsts = 'ACTIVE';
                }
                if ($trip_id != 0 && $trip_sts == 1) {
                    $order_status = 'ACTIVE';
                    $tripsts = 'ACTIVE';
                }
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $createdon = $chkorder->row()->createdon;
                $updatedon = $chkorder->row()->updatedon;
                //  $getactual = getdatetimebytimezone($curtz,$createdon,DFLT_TZ);
                $curdt = $cdate;
                /* $curdt = $getactual['datetime'];*/
                //  $getactual = getdatetimebytimezone($curtz,$updatedon,DFLT_TZ);
                $upddt = $cdate;
                /* $upddt = $getactual['datetime'];*/
                $parties = [];
                $vendor_id = $chkorder->row()->vendor_id;
                if ($vendor_id != 0) {
                    $sql = 'SELECT name,mobile,location,address,pincode,country,email,code FROM tb_vendors where id =?';
                    $getvendor = $this->db->query($sql, [$vendor_id]);
                    if ($getvendor->num_rows() > 0) {
                        $vendordetails = [
                            'name' => $getvendor->row()->name,
                            'party_id' => $getvendor->row()->code,
                            'address' => $getvendor->row()->address,
                            'pincode' => $getvendor->row()->pincode,
                            'country' => $getvendor->row()->country,
                            'street' => "",
                            'city' => $getvendor->row()->location,
                            'state' => "",
                            'phone' => $getvendor->row()->mobile,
                            'email' => $getvendor->row()->email
                        ];
                    }
                }
                $pickup_id = $chkorder->row()->customer_id;
                $sql = 'SELECT name,phone,state,street,location,pincode, address, email_id, code,country FROM tb_customers WHERE id=? AND status=1 LIMIT 1';
                $getpickupdetails = $this->db->query($sql, [$pickup_id]);
                if ($getpickupdetails->num_rows() > 0) {
                    $customerdetails = [
                        'name' => $getpickupdetails->row()->name,
                        'party_id' => $getpickupdetails->row()->code,
                        'address' => $getpickupdetails->row()->address,
                        'pincode' => $getpickupdetails->row()->pincode,
                        'country' => $getpickupdetails->row()->country,
                        'street' => $getpickupdetails->row()->street,
                        'city' => $getpickupdetails->row()->location,
                        'state' => $getpickupdetails->row()->state,
                        'phone' => $getpickupdetails->row()->phone,
                        'email' => $getpickupdetails->row()->email_id
                    ];
                }
                $consignee_mobile = $consignor_mobile = $shipper_mobile = $carrier_mobile = "";
                $sql = 'SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code, p.location_id, p.address, p.country,p.state,
                p.street, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,a.street as pstreet,a.state as pstate,
                a.address as paddress,a.pincode as ppincode,a.country as pcountry FROM tbl_party_master p
                INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1
                LEFT JOIN tbl_orderparty_address a ON o.party_id=a.party_master_id AND o.order_id=a.order_id
                AND a.status=1 WHERE p.status=1 AND o.order_id=? GROUP BY o.party_type';
                $chekparty = $this->db->query($sql, [$order_id]);
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $pdetail = [];
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", ["id" => $ptype], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($rr->party_master_id != "") {
                                $pdetail = ['name' => $rr->name, 'party_id' => $rr->code, 'address' => $rr->paddress, 'pincode' => $rr->ppincode, 'country' => $rr->pcountry, 'street' => $rr->pstreet, 'city' => $rr->plocation_id, 'state' => $rr->pstate, 'phone' => $rr->mobile, 'email' => $rr->email];
                            } else {
                                $pdetail = ['name' => $rr->name, 'party_id' => $rr->code, 'address' => $rr->address, 'pincode' => $rr->pincode, 'country' => $rr->country, 'street' => $rr->street, 'city' => $rr->location_id, 'state' => $rr->state, 'phone' => $rr->mobile, 'email' => $rr->email];
                            }
                            if ($chktype->row()->name == "Consignee") {
                                $pdetail['type'] = "Consignee";
                                $consignee_mobile = $rr->mobile;
                            }
                            /*if($chktype->row()->name == "CUSTOMER"){
                $pdetail['type'] = "Customer";
            }*/
                            if ($chktype->row()->name == "Consignor") {
                                $pdetail['type'] = "Consignor";
                                $consignor_mobile = $rr->mobile;
                            }
                            /*if($chktype->row()->name == "FREIGHT_PAYER"){
                $pdetail['type'] = "FREIGHT_PAYER";
            }*/
                            if ($chktype->row()->name == "Shipper") {
                                $pdetail['type'] = "Shipper";
                                $shipper_mobile = $rr->mobile;
                            }
                            if ($chktype->row()->name == "Carrier") {
                                $pdetail['type'] = "Carrier";
                                $carrier_mobile = $rr->mobile;
                            }
                            $parties[] = $pdetail;
                        }
                    }
                }
                $code = "";
                $areacodes = ["1", "2", "3", "10", "11", "12", "673", "653", "645", "644", "635", "629", "628", "627", "624", "6", "5", "4", "29", "28", "27", "26", "25", "24", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "675", "676", "677", "678", "7", "8", "9"];
                $zonecode = $this->session->userdata("usr_tzone");
                $currency = isset($zonecode['currency']) ? $zonecode['currency'] : "SGD";
                $company_code = $this->session->userdata("company_code");
                $branch_code = $this->session->userdata("branch_code");
                if (isset($zonecode['phone_code'])) {
                    $code = $zonecode['phone_code'];
                } else {
                    if ($company_code == "THKN") {
                        $code = "66";
                    }
                    if ($company_code == "SGKN") {
                        $code = "65";
                    }
                    if ($company_code == "INKN") {
                        $code = "91";
                    }
                }
                $cargos = [];
                $total_volume = $total_weight = 0;
                $sql = 'select handling_unit,length,width,height,weight,volume,quantity,quantity_type,cargo_content from tb_order_cargodetails
                where order_id =?';
                $getcargos = $this->db->query($sql, [$order_id]);
                if ($getcargos->num_rows() > 0) {
                    foreach ($getcargos->result() as $res) {
                        $volume = $res->volume;
                        $weight = $res->weight;
                        if ($volume == "") {
                            $volume = 1;
                        }
                        if ($weight == "") {
                            $weight = 1;
                        }
                        $cargos[] = ['cargo_type' => $res->quantity_type, 'content' => $res->cargo_content, 'length' => $res->length, 'width' => $res->width, 'height' => $res->height, 'weight' => $weight, 'volume' => $volume, 'quantity' => $res->quantity];
                        $total_volume += $volume;
                        $total_weight += $weight;
                    }
                }
                if ($chkorder->row()->company_code != "") {
                    $company_code = $chkorder->row()->company_code;
                }
                if ($chkorder->row()->branch_code != "") {
                    $branch_code = $chkorder->row()->branch_code;
                }
                $shipperdetail = $vendordetails = $consignedetail = $consignordetail = $pfdetails = $customerdetails = [];
                $cncontact = $consignee_mobile;
                $cacontact = $consignor_mobile;
                if ($cacontact == "") {
                    $cacontact = $shipper_mobile;
                }
                $data = [
                    'SenderTransmissionNo' => $chkorder->row()->order_id,
                    'order_status' => $order_status,
                    'pickup_datetime' => $chkorder->row()->pickup_datetime,
                    'delivery_datetime' => $chkorder->row()->delivery_datetime,
                    'pickup_endtime' => $chkorder->row()->pickup_endtime,
                    'delivery_endtime' => $chkorder->row()->drop_endtime,
                    'createdon' => $curdt,
                    "delivery_company" => $chkorder->row()->delivery_company,
                    'delivery_contact' => $cncontact,
                    'delivery_city' => $chkorder->row()->delivery_city,
                    'delivery_country' => $chkorder->row()->delivery_country,
                    'delivery_address1' => $chkorder->row()->delivery_address1,
                    'delivery_address2' => $chkorder->row()->delivery_address2,
                    'delivery_pincode' => $chkorder->row()->delivery_pincode,
                    'branch_code' => $branch_code,
                    'company_code' => $company_code,
                    'transport_mode' => $chkorder->row()->transport_mode,
                    'pickup_country' => $chkorder->row()->pickup_country,
                    'pickup_pincode' => $chkorder->row()->pickup_pincode,
                    'country_code' => $code,
                    "pickup_company" => $chkorder->row()->pickup_company,
                    'pickup_contact' => $cacontact,
                    'pickup_city' => $chkorder->row()->pickup_city,
                    'pickup_address1' => $chkorder->row()->pickup_address1,
                    'pickup_address2' => $chkorder->row()->pickup_address2,
                    'cargos' => $cargos,
                    'total_weight' => $total_weight,
                    'total_volume' => $total_volume,
                    'tripsts' => $tripsts,
                    'ststime' => $upddt,
                    "area_code" => $areacodes[1],
                    "goods_value" => $chkorder->row()->goods_value,
                    "currency" => $currency,
                    "parties" => $parties
                ];
                $this->generateorderxml($data);
            }
        }
    }

    public function generateorderxml($data)
    {
        $date = date('Y-m-d H:i:s');
        $timestamp = strtotime($date);
        $request = '';
        $request .= '<TransmissionMessage>';
        $request .= '<TransmissionHeader>';
        $request .= '<Version>1.0</Version>';
        $request .= '<UserName>INFD/PNQFD.INTEGRATION</UserName>';
        $request .= '<Password>ALLIANCE</Password>';
        $request .= '<SenderTransmissionNo>' . $timestamp . '_' . $data['SenderTransmissionNo'] . '</SenderTransmissionNo>';
        $request .= '<AckSpec>';
        $request .= '<ComMethodGid>transmission</ComMethodGid>';
        $request .= '<ComType>';
        $request .= '<Url>https://elog360.app/svkonekt_test/api/v1/edi</Url>';
        $request .= '<EmailAddress>dummy@email.com</EmailAddress>';
        $request .= '</ComType>';
        $request .= '<AckOption>SUCCESS</AckOption>';
        $request .= '</AckSpec>';
        $request .= '<Source>ETN</Source>';
        $request .= '<Destination>' . $data['branch_code'] . '</Destination>';
        $request .= '<ReferenceId>' . $data['SenderTransmissionNo'] . '</ReferenceId>';
        $modetrans = "FTL";
        if (isset($data['transport_mode'])) {
            if ($data['transport_mode'] == "TL") {
                $modetrans = "FTL";
            } else {
                $modetrans = "LTL";
            }
        }
        $request .= '<ModeOfTransport>' . $modetrans . '</ModeOfTransport>';
        $request .= '<Action>BookingDetails</Action>';
        $request .= '</TransmissionHeader>';
        $request .= '<TransmissionBody>';
        $request .= '<InvolvedParties>';
        foreach ($data['parties'] as $ptype) {
            if (isset($ptype['type'])) {
                if ($ptype['type'] == "Shipper") {
                    $request .= '<Shipper>';
                }
                if ($ptype['type'] == "Carrier") {
                    $request .= '<Carrier>';
                }
                if ($ptype['type'] == "Consignor") {
                    $request .= '<Consignor>';
                }
                if ($ptype['type'] == "Consignee") {
                    $request .= '<Consignee>';
                }
                $request .= '<ID>' . $ptype['party_id'] . '</ID>';
                $request .= '<FirstName>' . $ptype['name'] . '</FirstName>';
                $request .= '<LastName>' . $ptype['name'] . '</LastName>';
                $request .= '<FullName>' . $ptype['name'] . '</FullName>';
                if ($ptype['type'] == "Shipper") {
                    $request .= '<UserName>ratchanee.limwatthana@kuehne-nagel.com</UserName>';
                    $request .= '<Password>$2a$11$7xOpu6cePv2sR4HrzWGyOui1evc5GyHE2/72UQjYK9OJOvIEyKZGW</Password>';
                }
                if ($ptype['type'] == "Carrier") {
                    $request .= '<UserName>thananyas@jtclogistics.com</UserName>';
                    $request .= '<Password>$2a$11$NrwvCZ2E9RTMdQJSlUGCT.Jeb13bKWkJP.HQ6pOdcSWjV74Y.18c2</Password>';
                }
                $request .= '<ContactNo>';
                $request .= '<CountryCode>' . $data['country_code'] . '</CountryCode>';
                $request .= '<AreaCode>' . $data['area_code'] . '</AreaCode>';
                $request .= '<ContactNo>' . $ptype['phone'] . '</ContactNo>';
                $request .= '</ContactNo>';
                $request .= '<Company>';
                $request .= '<Name>' . $data['pickup_company'] . '</Name>';
                $request .= '<ContactNo>+' . $data['country_code'] . '' . $data['area_code'] . '' . $ptype['phone'] . '</ContactNo>';
                $request .= '<RegistrationNumber>' . $ptype['party_id'] . '</RegistrationNumber>';
                $request .= '<EmailAddress>' . $ptype['email'] . '</EmailAddress>';
                $request .= '</Company>';
                $request .= '<Address>';
                $request .= '<Country>' . $ptype['country'] . '</Country>';
                $request .= '<City>' . $ptype['city'] . '</City>';
                $request .= '<Postal>' . $ptype['pincode'] . '</Postal>';
                $request .= '<Address1>' . $ptype['address'] . '</Address1>';
                $request .= '<Address2>' . $ptype['street'] . '</Address2>';
                $request .= '</Address>';
                if ($ptype['type'] == "Consignor") {
                    $request .= '<Comments></Comments>';
                }
                if ($ptype['type'] == "Consignee") {
                    $request .= '<Comments></Comments>';
                }
                if ($ptype['type'] == "Shipper") {
                    $request .= '</Shipper>';
                }
                if ($ptype['type'] == "Carrier") {
                    $request .= '</Carrier>';
                }
                if ($ptype['type'] == "Consignor") {
                    $request .= '</Consignor>';
                }
                if ($ptype['type'] == "Consignee") {
                    $request .= '</Consignee>';
                }
            }
        }
        $request .= '</InvolvedParties>';
        /*$request .= '<VehicleDetails>';
      $request .= '<VehicleTypeCode>6WC</VehicleTypeCode>';
      $request .= '<VehicleModelCode>SIX_WHEELER</VehicleModelCode>';
      $request .= '<RegistrationNumber></RegistrationNumber>';
      $request .= '<License></License>';
      $request .= '<ApplicableForDangerousGoods></ApplicableForDangerousGoods>';
      $request .= '<CommodityType>6 Wheeler Cabinet</CommodityType>';
      $request .= '<Properties>';
      $request .= '</Properties>';
      $request .= '</VehicleDetails>';*/
        $request .= '<TripDetails>';
        $request .= '<PickUp>';
        $request .= '<Company>';
        $request .= '<Name>' . $data['pickup_company'] . '</Name>';
        $request .= '<ContactNo>' . $data['pickup_contact'] . '</ContactNo>';
        $request .= '</Company>';
        $request .= '<Address>';
        $request .= '<Country>' . $data['pickup_country'] . '</Country>';
        $request .= '<City>' . $data['pickup_city'] . '</City>';
        $request .= '<Postal>' . $data['pickup_pincode'] . '</Postal>';
        $request .= '<Address1>' . $data['pickup_address1'] . '</Address1>';
        $request .= '<Address2>' . $data['pickup_address2'] . '</Address2>';
        $request .= '</Address>';
        $request .= '<DateTime>';
        $request .= '<From>' . date("Y-m-d", strtotime($data['pickup_datetime'])) . 'T' . date("H:i:s", strtotime($data['pickup_datetime'])) . '.000</From>';
        $request .= '<To>' . date("Y-m-d", strtotime($data['pickup_endtime'])) . 'T' . date("H:i:s", strtotime($data['pickup_endtime'])) . '.000</To>';
        $request .= '</DateTime>';
        $request .= '</PickUp>';
        $request .= '<DropOff>';
        $request .= '<Company>';
        $request .= '<Name>' . $data['delivery_company'] . '</Name>';
        $request .= '<ContactNo>' . $data['delivery_contact'] . '</ContactNo>';
        $request .= '</Company>';
        $request .= '<Address>';
        $request .= '<Country>' . $data['delivery_country'] . '</Country>';
        $request .= '<City>' . $data['delivery_city'] . '</City>';
        $request .= '<Postal>' . $data['delivery_pincode'] . '</Postal>';
        $request .= '<Address1>' . $data['delivery_address1'] . '</Address1>';
        $request .= '<Address2>' . $data['delivery_address2'] . '</Address2>';
        $request .= '</Address>';
        $request .= '<DateTime>';
        $request .= '<From>' . date("Y-m-d", strtotime($data['delivery_datetime'])) . 'T' . date("H:i:s", strtotime($data['delivery_datetime'])) . '.000</From>';
        $request .= '<To>' . date("Y-m-d", strtotime($data['delivery_endtime'])) . 'T' . date("H:i:s", strtotime($data['delivery_endtime'])) . '.000</To>';
        $request .= '</DateTime>';
        $request .= '</DropOff>';
        $request .= '</TripDetails>';
        $request .= '<CargoDetails>';
        $request .= '<CargoType>GENERAL CATEGORY</CargoType>';
        $request .= '<ValueOfGoods>' . $data['goods_value'] . '</ValueOfGoods>';
        $request .= '<Items>';
        if (!empty($cargos)) {
            foreach ($cargos as $goods) {
                $request .= '<Item>';
                $request .= '<HandlingUnit>' . $goods['cargo_type'] . '</HandlingUnit>';
                $request .= '<Length>';
                $request .= '<Value>' . $goods['length'] . '</Value>';
                $request .= '<UOM>m</UOM>';
                $request .= '</Length>';
                $request .= '<Width>';
                $request .= '<Value>' . $goods['width'] . '</Value>';
                $request .= '<UOM>m</UOM>';
                $request .= '</Width>';
                $request .= '<Height>';
                $request .= '<Value>' . $goods['height'] . '</Value>';
                $request .= '<UOM>m</UOM>';
                $request .= '</Height>';
                $request .= '<Weight>';
                $request .= '<Value>' . $goods['weight'] . '</Value>';
                $request .= '<UOM>m</UOM>';
                $request .= '</Weight>';
                $request .= '<TotalVolume>';
                $request .= '<Value>' . $data['total_volume'] . '</Value>';
                $request .= '<UOM>cbm</UOM>';
                $request .= '</TotalVolume>';
                $request .= '<TotalWeight>';
                $request .= '<Value>' . $data['total_weight'] . '</Value>';
                $request .= '<UOM>kg</UOM>';
                $request .= '</TotalWeight>';
                $request .= '<Quantity>' . $data['quantity'] . '</Quantity>';
                $request .= '</Item>';
            }
        }
        $request .= '</Items>';
        $request .= '</CargoDetails>';
        $request .= '<Rate>';
        $request .= '<BuyGroup>';
        $request .= '<Freights>';
        $request .= '<Freight>';
        $request .= '  <FreightBuyRate>2000</FreightBuyRate>';
        $request .= '<Description></Description>';
        $request .= '<RateUnit>trip</RateUnit>';
        $request .= '<Currency>' . $data['currency'] . '</Currency>';
        $request .= '<RevisedFreightBuyRate></RevisedFreightBuyRate>';
        $request .= '</Freight>';
        $request .= '</Freights>';
        $request .= '<Addons/>';
        $request .= '</BuyGroup>';
        $request .= '<SellGroup>';
        $request .= '<Freights>';
        $request .= '<Freight>';
        $request .= '<FreightBuyRate>2000</FreightBuyRate>';
        $request .= '<Description></Description>';
        $request .= '<RateUnit>trip</RateUnit>';
        $request .= '<Currency>' . $data['currency'] . '</Currency>';
        $request .= '<KNMarginPercentage>25</KNMarginPercentage>';
        $request .= '<KNMarginAbs></KNMarginAbs>';
        $request .= '<SellPrice>2500</SellPrice>';
        $request .= '</Freight>';
        $request .= '</Freights>';
        $request .= '<Addons/>';
        $request .= '<Discount>500</Discount>';
        $request .= '</SellGroup>';
        $request .= '</Rate>';
        $request .= '<Status>';
        $request .= '<Shipper>';
        $request .= '<StatusCode>READY_FOR_PICKUP</StatusCode>';
        $request .= '<StatusValue>READY_FOR_PICKUP</StatusValue>';
        $request .= '<DateTime>' . date("Y-m-d", strtotime($data['createdon'])) . 'T' . date("H:i:s", strtotime($data['createdon'])) . '.049Z</DateTime>';
        $request .= '</Shipper>';
        $request .= '<Carrier>';
        $request .= '<StatusCode>READY_FOR_PICKUP</StatusCode>';
        $request .= '<StatusValue>READY_FOR_PICKUP</StatusValue>';
        $request .= '<DateTime>' . date("Y-m-d", strtotime($data['createdon'])) . 'T' . date("H:i:s", strtotime($data['createdon'])) . '.049Z</DateTime>';
        $request .= '</Carrier>';
        $request .= '<Booking>';
        $request .= '<StatusCode>' . $data['tripsts'] . '</StatusCode>';
        $request .= '<StatusValue>' . $data['tripsts'] . '</StatusValue>';
        $request .= '<DateTime>' . date("Y-m-d", strtotime($data['ststime'])) . 'T' . date("H:i:s", strtotime($data['ststime'])) . '.049Z</DateTime>';
        $request .= '</Booking>';
        $request .= '</Status>';
        $request .= '<Remarks>';
        $request .= '<ShipperInstructions></ShipperInstructions>';
        $request .= '<AddressComments></AddressComments>';
        $request .= '<SpecialAddons></SpecialAddons>';
        $request .= '</Remarks>';
        $request .= '<KNOrgDetails>';
        $request .= '<KNCompanycode>' . $data['company_code'] . '</KNCompanycode>';
        $request .= '<KNBranchcode>' . $data['branch_code'] . '</KNBranchcode>';
        $request .= '</KNOrgDetails>';
        $request .= '</TransmissionBody>';
        $request .= '</TransmissionMessage>';
        $resname = date("Ymdhis");
        $dom = new DOMDocument;
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($request);
        $dom->save('xml/response' . $resname . '.xml');
        /*log_message( "error", "request-order " . $request );*/
        $serviceurl = BOOKING_ETRA_URL;
        $username = BOOKING_ETRA_USRNAME;
        $password = BOOKING_ETRA_PWD;
        /*$username = "ws_etra";
    $password = "4fh2drGs3n";*/
        $auth = base64_encode($username . ':' . $password);
        $headers = [
            'Content-Type: application/xml',
            'Authorization: Basic ' . base64_encode("$username:$password")
        ];
        $output = thirdpartyservicecurl($serviceurl, $headers, $request);
        /*log_message( 'error', "orderslogresponsexml " . json_encode( $output ) );*/
    }

    public function creditblock()
    {
        $post = $this->input->post();
        $uid = $this->session->userdata('user_id');
        $data['status'] = 0;
        $curdt = date('Y-m-d H:i:s');
        $cb_orderid = isset($post['cb_orderid']) ? $post['cb_orderid'] : 0;
        $creditid = isset($post['creditid']) ? $post['creditid'] : 0;
        $cb_companycode = isset($post['cb_companycode']) ? $post['cb_companycode'] : "";
        $cb_branchcode = isset($post['cb_branchcode']) ? $post['cb_branchcode'] : "";
        $cb_departcode = isset($post['cb_departcode']) ? $post['cb_departcode'] : "";
        $stoppage_id = isset($post['stoppage_id']) ? $post['stoppage_id'] : 0;
        $stoppage_name = isset($post['stoppage_name']) ? $post['stoppage_name'] : "";
        $stoppage_remark = isset($post['stoppage_remark']) ? $post['stoppage_remark'] : "";
        $remainder_date = isset($post['remainder_date']) ? $post['remainder_date'] : date('Y-m-d');
        $return_date = isset($post['return_date']) ? $post['return_date'] : date('Y-m-d');
        $resolution_id = isset($post['resolution_id']) ? $post['resolution_id'] : 0;
        $resolution_date = isset($post['resolution_date']) ? $post['resolution_date'] : date('Y-m-d');
        $extra_cost = isset($post['extra_cost']) ? $post['extra_cost'] : 0;
        $extracost_id = isset($post['extracost_id']) ? $post['extracost_id'] : "";
        $status_id = isset($post['status_id']) ? $post['status_id'] : 0;
        $status_dttime = isset($post['status_dttime']) ? $post['status_dttime'] : date('Y-m-d H:i:s');
        $status_remark = isset($post['status_remark']) ? $post['status_remark'] : "";
        $remainder_date = date('Y-m-d', strtotime($remainder_date));
        $return_date = date('Y-m-d', strtotime($return_date));
        $resolution_date = date('Y-m-d', strtotime($resolution_date));
        if ($creditid == 0) {
            $insdata = [
                'order_id' => $cb_orderid,
                'stoppage_id' => $stoppage_id,
                'stoppage_name' => $stoppage_name,
                'stoppage_remarks' => $stoppage_remark,
                'remainder_date' => $remainder_date,
                'return_date' => $return_date,
                'resolution_id' => $resolution_id,
                'resolution_date' => $resolution_date,
                'extra_cost' => $extra_cost,
                'extracost_id' => $extracost_id,
                'status_id' => $status_id,
                'status_datetime' => $status_dttime,
                'status_remark' => $status_remark,
                'company_code' => $cb_companycode,
                'branch_code' => $cb_branchcode,
                'department_code' => $cb_departcode,
                'user_id' => $uid,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            ];
            $ins = $this->db->insert("tbl_credit_blocked", $insdata);
            $creditblockid = $this->db->insert_id();
            $data['status'] = 1;
        } else {
            $updata = [
                'order_id' => $cb_orderid,
                'stoppage_id' => $stoppage_id,
                'stoppage_name' => $stoppage_name,
                'stoppage_remarks' => $stoppage_remark,
                'remainder_date' => $remainder_date,
                'return_date' => $return_date,
                'resolution_id' => $resolution_id,
                'resolution_date' => $resolution_date,
                'extra_cost' => $extra_cost,
                'extracost_id' => $extracost_id,
                'status_id' => $status_id,
                'status_datetime' => $status_dttime,
                'status_remark' => $status_remark,
                'company_code' => $cb_companycode,
                'branch_code' => $cb_branchcode,
                'department_code' => $cb_departcode,
                'user_id' => $uid,
                'updated_on' => $curdt
            ];
            $updatecredit = $this->db->where_in("id", $creditid)->update("tbl_credit_blocked", $updata);
            $data['status'] = 1;
        }
        echo json_encode($data);
    }

    public function checkcreditblocked()
    {
        $post = $this->input->post();
        $order_id = isset($post['order_id']) ? $post['order_id'] : 0;
        $data = [];
        if ($order_id > 0) {
            $creditdata = $this->Order->getcreditdata("tbl_credit_blocked", $order_id);
            if ($creditdata->num_rows() > 0) {
                $data = [
                    'creditid' => $creditdata->row()->id,
                    'cb_orderid' => $creditdata->row()->order_id,
                    'stoppage_id' => $creditdata->row()->stoppage_id,
                    'stoppage_name' => $creditdata->row()->stoppage_name,
                    'stoppage_remark' => $creditdata->row()->stoppage_remarks,
                    'remainder_date' => $creditdata->row()->remainder_date,
                    'return_date' => $creditdata->row()->return_date,
                    'resolution_id' => $creditdata->row()->resolution_id,
                    'resolution_date' => $creditdata->row()->resolution_date,
                    'extra_cost' => $creditdata->row()->extra_cost,
                    'extracost_id' => $creditdata->row()->extracost_id,
                    'status_id' => $creditdata->row()->status_id,
                    'status_dttime' => $creditdata->row()->status_datetime,
                    'status_remark' => $creditdata->row()->status_remark,
                    'cb_companycode' => $creditdata->row()->company_code,
                    'cb_branchcode' => $creditdata->row()->branch_code,
                    'cb_departcode' => $creditdata->row()->department_code
                ];
            }
        }
        echo json_encode($data);
    }

    public function getstoppagename($id)
    {
        $data['name'] = "";
        if ($id != "") {
            $sql = 'SELECT name FROM tbl_stoppage_master WHERE id=? AND status=1';
            $getdesc = $this->db->query($sql, [$id]);
            if ($getdesc->num_rows() > 0) {
                $data['name'] = $getdesc->row()->name;
            }
        }
        echo json_encode($data);
    }

    public function getconinfo($order_row_id)
    {
        $this->load->model('truckwaybillmodel');
        $serviceurl = SPOTON_URL;
        $username = SPOTON_USRNAME;
        $password = SPOTON_PWD;
        $headers = [
            'Content-Type: application/json',
            'Authorization: Basic ' . base64_encode("$username:$password")
        ];
        $requestinfo = $req_in_arr = [];
        $where = ["id" => $order_row_id];
        $select = "order_id,weight,delivery_city,pickup_city,pickup_datetime";
        $table = "tb_orders";
        $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $order_number = '';
        $request_id = 0;
        if (count($order) > 0) {
            $reference_val = '';
            $where = ["order_id" => $order_row_id];
            $select = "length,width,height,quantity";
            $table = "tb_order_cargodetails";
            $dimensions = [];
            $order_cargo = $this->common->gettbldata($where, $select, $table, 0, 0);
            $pickupinfo = $this->truckwaybillmodel->getshipper($order_row_id, 'Shipper');
            $receiverinfo = $this->truckwaybillmodel->getshipper($order_row_id, 'Consignee');
            $order_number = $order['order_id'];
            $order_reference = $this->truckwaybillmodel->orderrefernce($order_number);
            if (count($order_reference) > 0) {
                foreach ($order_reference as $res) {
                    $reference_val = $res['ref_value'] . ",";
                }
            }
            $reference_val = trim($reference_val, ",");
            $total_packages = 0;
            if (count($order_cargo) > 0) {
                foreach ($order_cargo as $info) {
                    $dimensions[] = ['Length' => round($info['length']), 'Breadth' => round($info['width']), 'height' => round($info['height']), 'Pieces' => round($info['quantity'])];
                    $total_packages = $total_packages + $info['quantity'];
                }
            }
            $picklocationname = isset($pickupinfo['location_id']) ? $pickupinfo['location_id'] : "";
            if ($picklocationname == '') {
                $picklocationname = $order['pickup_city'];
            }
            $pickpincode = isset($pickupinfo['pincode']) ? $pickupinfo['pincode'] : "";
            $pickaddress = isset($pickupinfo['address']) ? $pickupinfo['address'] : "";
            $pickmobile = isset($pickupinfo['mobile']) ? $pickupinfo['mobile'] : "";
            $pickemail = isset($pickupinfo['email']) ? $pickupinfo['email'] : "";
            $pickup_datetime = date("Y-m-d", strtotime($order['pickup_datetime']));
            $requestinfo['UniqueHashValue'] = '#@64@!$%3';
            $requestinfo['CustomerCode'] = $username;
            $requestinfo['PickupPincode'] = substr($pickpincode, 0, 6);
            $requestinfo['PickupDateTime'] = $pickup_datetime;
            $requestinfo['ReceiverPincode'] = substr($receiverinfo['pincode'], 0, 6);
            $requestinfo['PaymentMode'] = 'credit';
            $requestinfo['PickupLocationName'] = $picklocationname;
            $requestinfo['PickupAddress'] = $pickaddress;
            $requestinfo['PickupCity'] = $order['pickup_city'];
            $requestinfo['PickupContactPhone'] = $pickmobile;
            $requestinfo['PickupContactMail'] = $pickemail;
            $requestinfo['ReceiverName'] = $receiverinfo['name'];
            $requestinfo['ReceiverAddress'] = $receiverinfo['address'];
            $requestinfo['ReceiverCity'] = $order['delivery_city'];
            $requestinfo['ReceiverContactPerson'] = $receiverinfo['name'];
            $requestinfo['ReceiverContactPhone'] = $receiverinfo['mobile'];
            $requestinfo['ReceiverMail'] = $receiverinfo['email'];
            $requestinfo['TotalPackages'] = $total_packages;
            $requestinfo['TotalActualWeight'] = $order['weight'];
            $requestinfo['Remarks'] = 'Pickup and delivery notes';
            $requestinfo['SpecialInstruction'] = 'On time';
            $requestinfo['VTCApplicable'] = 'N';
            $requestinfo['VTCAmount'] = '0';
            $requestinfo['ReferenceNumber'] = $reference_val;
            $requestinfo['TINNumber'] = '';
            $requestinfo['AWBConsignmentValue'] = '0';
            $requestinfo['GstIn'] = '';
            $requestinfo['ProductId'] = '';
            $requestinfo['SplInstruction'] = '';
            $requestinfo['Dimensions'] = $dimensions;
            //store value to con request table
            $req_in_arr = [
                'customer_code' => $requestinfo['CustomerCode'],
                'unique_value' => $requestinfo['UniqueHashValue'],
                'order_id' => $order_number,
                'order_rowid' => $order_row_id,
                'user_id' => $user_id,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'pickup_pincode' => $requestinfo['PickupPincode'],
                'pickupdatetime' => $requestinfo['PickupDateTime'],
                'pickupreadytime' => '',
                'receiverpincode' => $requestinfo['ReceiverPincode'],
                'paymentmode' => $requestinfo['PaymentMode'],
                'pic_loc_name' => $requestinfo['PickupLocationName'],
                'pickupaddress' => $requestinfo['PickupAddress'],
                'pickupcity' => $requestinfo['PickupCity'],
                'pic_contactphone' => $requestinfo['PickupContactPhone'],
                'pic_contactmail' => $requestinfo['PickupContactMail'],
                'receivername' => $requestinfo['ReceiverName'],
                'receiveraddress' => $requestinfo['ReceiverAddress'],
                'receivercontactperson' => $requestinfo['ReceiverContactPerson'],
                'receiver_cont_phone' => $requestinfo['ReceiverContactPhone'],
                'receivermail' => $requestinfo['ReceiverMail'],
                'totalpackages' => $requestinfo['TotalPackages'],
                'tot_actual_weight' => $requestinfo['TotalActualWeight'],
                'remarks' => $requestinfo['Remarks'],
                'special_instruction' => $requestinfo['SpecialInstruction'],
                'vtc_applicable' => $requestinfo['VTCApplicable'],
                'vtc_amount' => $requestinfo['VTCAmount'],
                'refe_number' => $requestinfo['ReferenceNumber'],
                'tin_number' => $requestinfo['TINNumber'],
                'awb_consig_value' => $requestinfo['AWBConsignmentValue'],
                'gst_in' => $requestinfo['GstIn'],
                'product_id' => $requestinfo['ProductId'],
                'spl_instruction' => $requestinfo['SplInstruction'],
                'eway_bill' => '',
                'invoice_no' => '',
                'invoice_amt' => '0',
                'dimensions' => json_encode($dimensions)
            ];
            $request_id = $this->common->insertTableData('tb_getcon_request', $req_in_arr);
        }
        $json_request = json_encode($requestinfo);
        /*log_message( 'error', "spoton request " . $json_request );*/
        $response = thirdpartyservicecurl($serviceurl, $headers, $json_request);
        /*log_message( 'error', "spoton response " . json_encode( $response ) );*/
        curl_close($ch);
        if ($response) {
            $startNo = (isset($response->Pieces[0]->StartNo) && !empty($response->Pieces[0]->StartNo)) ? (string)($response->Pieces[0]->StartNo) : "";
            $endNo = (isset($response->Pieces[0]->EndNo) && !empty($response->Pieces[0]->EndNo)) ? (string)($response->Pieces[0]->EndNo) : "";
            $res_array = [
                'request_id' => $request_id,
                'order_id' => $order_number,
                'order_rowid' => $order_row_id,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'res_status' => $response->Status,
                'error_remarks' => $response->ErrorRemarks,
                'unique_value' => $response->UniqueValue,
                'customer_refno' => $response->CustomerRefNo,
                'con_num' => $response->ConNo,
                'pickup_sccode' => $response->PickupScCode,
                'delivery_sccode' => $response->DeliveryScCode,
                'pickup_order_no' => $response->PickupOrderNo,
                'pie_startno' => $startNo,
                'pie_endno' => $endNo,
                'error_code' => $response->ErrorCode,
                'user_id' => $user_id
            ];
            $this->common->insertTableData('tb_getcon_response', $res_array);
            $ins_ar = [
                'order_id' => $order_row_id,
                'reference_id' => 'BN',
                'ref_value' => $response->ConNo,
                'status' => 1
            ];
            $chkqry = $this->db->select('id')->get_where("tb_order_references", ['order_id' => $order_row_id, 'reference_id' => 'BN', 'ref_value' => $response->ConNo]);
            if ($chkqry->num_rows() > 0) {
            } else {
                $ins = $this->db->insert('tb_order_references', $ins_ar);
            }
            /* code for ABH - Pickuporder number */
            if ($response->PickupOrderNo != '') {
                $picins_ar = array(
                    'order_id' => $order_row_id,
                    'reference_id' => 'ABH',
                    'ref_value' => $response->PickupOrderNo,
                    'status' => 1
                );
                $chkqry = $this->db->select('id')->get_where("tb_order_references", ['order_id' => $order_row_id, 'reference_id' => 'ABH', 'ref_value' => $response->PickupOrderNo]);
                if ($chkqry->num_rows() == 0) {
                    $ins = $this->db->insert('tb_order_references', $picins_ar);
                }
            }
            /* code for ABH - Pickuporder number */
        }
    }

    public function check_trip()
    {
        $id = $this->input->post('order_id');
        $result = 0;
        if (!is_array($id)) {
            $where = ["id" => $id];
            $select = "shift_id";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($order) > 0) {
                if ($order['shift_id'] > 0) {
                    $result = 1;
                }
            }
        } else {
            $bookids = implode("','", $id);
            $where = " id IN($bookids) AND shift_id != 0";
            $select = "id";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($order) > 0) {
                $result = 1;
            }
        }
        echo $result;
    }

    public function GetOrderIntoapi($order_id)
    {
        $url = "https://www.sevasetu.in/sp/index.php/api/tracking/track_v2";
        $headers = [
            'Content-Type: application/json',
            'Username: maruticourier',
            MARUTI_PASSWORD,
            MARUTI_TOKEN
        ];
        $where = [
            "order_id" => $order_id
        ];
        $select = "order_id,pickup_datetime,pickup_endtime,delivery_datetime,drop_endtime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,quantity,weight,volume,goods_value,transport_mode,customer_name,customer_phone,customer_email,company_code,branch_code";
        $table = "tb_orders";
        $data_order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($data_order) > 0) {
            $postdata = [
                'data' => $data_order
            ];
            $getdata = thirdpartyservicecurl($url, $headers, $postdata);
            // assumption response array
            // {"success":"1","message":"Barcode successfully fetched.","data":{"barcode":{"order_id":"123","barcode_no":"589"}}}
            $json = json_decode($getdata, TRUE);
            $get_order_id = $json['data']['barcode']['order_id'];
            $get_barcode_no = $json['data']['barcode']['barcode_no'];
            $where = [
                "order_id" => $get_order_id
            ];
            $select = "order_id,ref_value";
            $table = "tb_order_references";
            $data_ref = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($data_ref) == 0) {
                $insdata = [
                    'order_id' => $get_order_id,
                    'reference_id' => 'DQ',
                    'ref_value' => $get_barcode_no,
                    'status' => 1
                ];
                $this->db->insert("tbl_credit_blocked", $insdata);
            }
        }
    }

    public function ordernotify($action, $orderid)
    {
        $this->load->library('notifytrigger');
        $info['page_title'] = 'Booking Notification';
        $info['subject'] = 'Booking Notification';
        $info['order_id'] = $orderid;
        $info['action'] = $action;
        $orderinfo = $this->common->gettblrowdata(['id' => $orderid], 'order_id,shift_id', 'tb_orders', 0, 0);
        if ($orderinfo) {
            $info['orderid'] = $orderinfo['order_id'];
            $info['cargos'] = $this->common->gettbldata(['order_id' => $orderid], 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
            if ($action != 'trip_create') {
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, TRUE);
                $this->notifytrigger->sendordernotify($info);
            } else {
                $info['shift_id'] = $orderinfo['shift_id'];
                $shipinfo = $this->common->gettblrowdata(['id' => $info['shift_id']], 'shipmentid', 'tb_shifts', 0, 0);
                $info['shiftid'] = (!empty($shipinfo['shipmentid'])) ? $shipinfo['shipmentid'] : '';
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, TRUE);
                $this->notifytrigger->sendtripnotify($info);
            }
        }
    }

    /*  public function testprefer(){
        $order_id = '1';
        $company_code = 'PLKN';
        $pref_arr = array('pickup'=>'GERMANY','drop'=>'POLAND','customer_id'=>'1000739642','service'=>'11','product'=>'KN PharmaChain','user_id'=>'7','company_code'=>$company_code,'order_id'=>$order_id);
        if($company_code == 'PLKN'){
            $this->ratemanagement->addrecodfororderinsertion($pref_arr);
        }
    }*/

    public function ajaxListing()
    {
        $this->load->model('Datatables_model');
        $draw = $this->input->get('draw');
        $start = $this->input->get('start');

        $indexColumn = 'c.id';
        $selectColumns = [
            'c.id',
            'c.cargo_type',
            'c.length_unit',
            'c.width_unit',
            'c.height_unit',
            'c.weight_unit',
            'c.volume_unit',
            'c.goods_description',
            'c.stackable',
            'c.grounded',
            'c.splittable',
            'c.dg_goods',
            'o.length',
            'o.width',
            'o.height',
            'o.weight',
            'o.volume',
            'o.volumetric_weight',
            'o.volweight_uom',
            'c.ldm',
            'o.quantity',
            'o.scanned_quantity'
        ];

        $dataTableSortOrdering = [
            'c.cargo_type',
            'c.goods_description',
            'o.quantity',
            'o.scanned_quantity',
            'o.length',
            'o.width',
            'o.height',
            'o.weight',
            'o.volumetric_weight',
            'o.volume',
            'c.ldm',
            'c.stackable',
            'c.grounded',
            'c.splittable',
            'c.dg_goods',
            'c.id'
        ];
        $table_name = 'tb_cargo_details c,tb_order_cargodetails o';
        $joinsArray = [];

        $get = $this->input->get('data');
        $order_id = $get['order_id'];
        $actionType = $get['actionType'];
        $wherecondition = " o.order_id ='" . $order_id . "' AND o.cargo_id=c.id AND o.status='1'  ";
        $groupBy = 'c.id';
        $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, '', $groupBy);
        $totalRecords = $getRecordListing['recordsTotal'];
        $recordsFiltered = $getRecordListing['recordsFiltered'];
        $recordListing = array();
        $content = '[';
        $i = 0;

        $srNumber = $start;

        if (!empty($getRecordListing)) {
            $actionContent = '';
            foreach ($getRecordListing['data'] as $res) {
                $stackable = 'Off';
                if ($res->stackable == 0) {
                    $stackable = 'Off';
                } else if ($res->stackable == 1) {
                    $stackable = 'On';
                }
                $grounded = 'Off';
                if ($res->grounded == 0) {
                    $grounded = 'Off';
                } else if ($res->grounded == 1) {
                    $grounded = 'On';
                }
                $splittable = 'Off';
                if ($res->splittable == 0) {
                    $splittable = 'Off';
                } else if ($res->splittable == 1) {
                    $splittable = 'On';
                }
                $dg_goods = 'Off';
                if ($res->dg_goods == 0) {
                    $dg_goods = 'Off';
                } else if ($res->dg_goods == 1) {
                    $dg_goods = 'On';
                }
                $cargo_type = '"' . $res->cargo_type . '"';
                $goods_desc = '"' . $res->goods_description . '"';
                $length_unit = '"' . $res->length_unit . '"';
                $width_unit = '"' . $res->width_unit . '"';
                $height_unit = '"' . $res->height_unit . '"';
                $weight_unit = '"' . $res->weight_unit . '"';
                $volume_unit = '"' . $res->volume_unit . '"';
                $volweight_uom = '"' . $res->volweight_uom . '"';
                $scanned_quantity = $res->scanned_quantity;
                if ($scanned_quantity == "") {
                    $scanned_quantity = 0;
                }
                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $res->volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $res->ldm . "," . $scanned_quantity . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteordercargodetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargos</a></li>";
                $empty = "";

                $content .= '[';

                /*
                $recordListing[$i][0]= $res->cargo_type;
                $recordListing[$i][1]= $res->goods_description;
                $recordListing[$i][2]= $res->quantity;
                $recordListing[$i][3]= $res->length . " " . $res->length_unit;
                $recordListing[$i][4]= $res->width . " " . $res->width_unit;
                $recordListing[$i][5]= $res->height . " " . $res->height_unit;
                $recordListing[$i][6]= $res->weight . " " . $res->weight_unit;
                $recordListing[$i][7]= $res->volume . " " . $res->volume_unit;
                $recordListing[$i][8]= $res->volumetric_weight . " " . $res->volweight_uom;
                $recordListing[$i][9]= $stackable;
                $recordListing[$i][10]= $splittable;
                $recordListing[$i][11]= $grounded;
                $recordListing[$i][12]= $action;
                $recordListing[$i][13]= $empty;
                $recordListing[$i][14]= $dg_goods;
                $recordListing[$i][15]= $res->ldm;
                $recordListing[$i][16]=$scanned_quantity;
*/

                if ($actionType == 'Edit') {
                    $recordListing[$i][0] = $action;
                    $recordListing[$i][1] = $res->cargo_type;
                    $recordListing[$i][2] = $res->goods_description;
                    $recordListing[$i][3] = $res->quantity;
                    $recordListing[$i][4] = $scanned_quantity;
                    $recordListing[$i][5] = $res->length . " " . $res->length_unit;
                    $recordListing[$i][6] = $res->width . " " . $res->width_unit;
                    $recordListing[$i][7] = $res->height . " " . $res->height_unit;
                    $recordListing[$i][8] = $res->weight . " " . $res->weight_unit;
                    $recordListing[$i][9] = $res->volumetric_weight . " " . $res->volweight_uom;
                    $recordListing[$i][10] = $res->volume . " " . $res->volume_unit;
                    $recordListing[$i][11] = $res->ldm;
                    $recordListing[$i][12] = $stackable;
                    $recordListing[$i][13] = $grounded;
                    $recordListing[$i][14] = $splittable;
                    $recordListing[$i][15] = $dg_goods;
//    $recordListing[$i][16]= $res->id;
                    $recordListing[$i][16] = '';
                } else {
                    $recordListing[$i][0] = $res->cargo_type;
                    $recordListing[$i][1] = $res->goods_description;
                    $recordListing[$i][2] = $res->quantity;
                    $recordListing[$i][3] = $scanned_quantity;
                    $recordListing[$i][4] = $res->length . " " . $res->length_unit;
                    $recordListing[$i][5] = $res->width . " " . $res->width_unit;
                    $recordListing[$i][6] = $res->height . " " . $res->height_unit;
                    $recordListing[$i][7] = $res->weight . " " . $res->weight_unit;
                    $recordListing[$i][8] = $res->volumetric_weight . " " . $res->volweight_uom;
                    $recordListing[$i][9] = $res->volume . " " . $res->volume_unit;
                    $recordListing[$i][10] = $res->ldm;
                    $recordListing[$i][11] = $stackable;
                    $recordListing[$i][12] = $grounded;
                    $recordListing[$i][13] = $splittable;
                    $recordListing[$i][14] = $dg_goods;
                    $recordListing[$i][15] = $res->id;
                }


                $i++;
                $srNumber++;
            }

            $content .= ']';
            $final_data = json_encode($recordListing);
        } else {
            $final_data = '[]';
        }

        // echo '{"draw":'.$draw.',"recordsTotal":'.$totalRecords.',"recordsFiltered":'.$recordsFiltered.',"data":'.$final_data.'}';
        echo '{"draw":' . $draw . ',"recordsTotal":' . $recordsFiltered . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';


    }

    public function deleteorders(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->load->helper(['log']);
            $ids = $this->input->post('deleteids');
            $tables = [
                ['name' => 'tb_orders', 'column' => 'id'],
                ['name' => 'tb_order_details', 'column' => 'order_row_id'],
                ['name' => 'tb_order_parties', 'column' => 'order_id'],
                ['name' => 'tbl_orderparty_address', 'column' => 'order_id'],
                ['name' => 'tb_order_cargodetails', 'column' => 'order_id'],
                ['name' => 'tb_order_addons', 'column' => 'order_id'],
                ['name' => 'tb_order_references', 'column' => 'order_id'],
            ];
            $result = true;
            foreach ($tables as $table) {
                foreach ($ids as $id) {
                    $this->db->reset_query();
                    $data = $this->db->delete($table['name'], [$table['column'] => $id]);
                    if (!$data) {
                        $error = $this->db->error();
                        log_error(sprintf('While execute query [%s] the following error came back [%s]', $query, $error['message']));
                        $result = false;
                    }
                }
            }
            echo $result ? "success" : "failed";
        }
    }
}
