<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Approvalorders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if($this->session->userdata('user_id')=='')
        {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->model('approvalordersmodal');
        if (!checkUrlAccessForUser('APPROVALORDERS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $data['page_title']=$this->lang->line('menu_approvetype');
        $data['sub_title']=$this->lang->line('general_search');
        $user_id = $this->session->userdata("user_id");
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');

        $eligible_currency = $hold_type = "";
        $eligible_amount = 0;
        $all_limits = array();
        $data['current_currency'] = $this->session->userdata['usr_tzone']['currency'];

        $approvetype_bookings = $checking_array = array();

        $checking_array = ['user_id' => $user_id,'branch_code'=>$branch_code,'company_code'=>$company_code];

        $select = "id,code,name";
        $table = "tbl_resolution_master";
        $resoluton_master=$this->common->gettbldata(['status' => 1],$select,$table,0,0);
        $data['resoluton_master'] = $resoluton_master;

        $select1 = "id,currency";
        $table1 = "tbl_country_master";
        $currencies=$this->common->gettbldata(['status' => 1],$select1,$table1,0,0);
        $data['currencies']=$currencies;
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }
        if (!empty($post)) {
            $whr = $this->searchsubmitdata($post);
            $orderdata = $this->approvalordersmodal->getsearcheddata($checking_array, $whr);
            foreach ($orderdata as $res) {

                if($res['hold_type'] == 1) {
                    //cargo limit
                    $hold_type = "Cargo Limit";
                    $eligible_amount = $res['limit_amount'];

                    if($res['currency'] == '' || is_null($res['currency'])) {
                        $eligible_currency = $data['current_currency'];
                    } else {
                        $eligible_currency = $res['currency'];
                    }
                } elseif($res['hold_type'] == '2') {
                    //credit limit
                    $hold_type = "Credit Limit";
                    $eligible_amount = $res['credit_limit_amount'];

                    if($res['credit_currency'] == '' || is_null($res['credit_currency'])) {
                        $eligible_currency = $data['current_currency'];
                    } else {
                        $eligible_currency = $res['credit_currency'];
                    }

                } elseif($res['hold_type'] == 3) {
                    //all limits
                    for($i=1;$i<=2;$i++) {

                        if($i == 1) {
                            $hold_type = "Cargo Limit";
                            $eligible_amount = $res['limit_amount'];

                            if($res['currency'] == '' || is_null($res['currency'])) {
                                $eligible_currency = $data['current_currency'];
                            } else {
                                $eligible_currency = $res['currency'];
                            }
                        }

                        if($i == 2) {
                            $hold_type = "Credit Limit";
                            $eligible_amount = $res['credit_limit_amount'];

                            if($res['credit_currency'] == '' || is_null($res['credit_currency'])) {
                                $eligible_currency = $data['current_currency'];
                            } else {
                                $eligible_currency = $res['credit_currency'];
                            }
                        }

                       $all_limits[] = ['order_row_id' =>$res['id'],'order_id'=>$res['order_id'],'name'=>$res['name'],'customer_id'=>$res['code'],'hold_type'=>$hold_type,'eligible_amount'=>$eligible_amount,'utilized_amount'=>$res['utilized_amount'],'business_partner_id'=>$res['business_partner_id'],'resolution_id' => $res['resolution_id'],'eligible_currency' => $eligible_currency,'hold_type_val' => $res['hold_type']];
                    }
                }


                if($res['hold_type'] == 1 || $res['hold_type'] == 2) {
                    $approvetype_bookings[] = ['order_row_id' =>$res['id'],'order_id'=>$res['order_id'],'name'=>$res['name'],'customer_id'=>$res['code'],'hold_type'=>$hold_type,'eligible_amount'=>$eligible_amount,'utilized_amount'=>$res['utilized_amount'],'business_partner_id'=>$res['business_partner_id'],'resolution_id' => $res['resolution_id'],'eligible_currency' => $eligible_currency,'hold_type_val' => $res['hold_type']
                        ];
                }
            }
        }

        $data['approvetype_bookings'] = $approvetype_bookings;
        $data['all_limits'] = $all_limits;
        $this->newtemplate->dashboard('approvaltype/index',$data);
    }

    public function searchsubmitdata($post)
    {
        $whr = array();
        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
			$post_fromdate_search = $this->db->escape_str($post['fromdate_search']);
            $fromdate_search = date('Y-m-d', strtotime($post_fromdate_search));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;

        }
        if (isset($post['todate_search']) && $post['todate_search'] != "") {
			$post_todate_search = $this->db->escape_str($post['todate_search']);
            $todate_search  = date('Y-m-d', strtotime($post_todate_search));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate_search;

        }

        if (isset($post['cid']) && $post['cid'] != "") {
            $cid = $this->db->escape_str($post['cid']);
            $whr["pm.code="] = $cid;

        }

        if (isset($post['hold_type_status']) && $post['hold_type_status'] != '') {
            $hold_type_status  = $this->db->escape_str($post['hold_type_status']);
            if($hold_type_status == 4) {
                // $whr=array(1,2,3);
                $whr["o.hold_type!="] = 0;
            } else {
                $whr["o.hold_type="] = $hold_type_status;
            }

        }

        return $whr;
    }

    public function getbusinesscid()
    {
        $uid = $this->session->userdata('user_id');
        $cid = trim($_REQUEST["cid"]);
        $cid = "%$cid%";
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');
        $sql = "SELECT pm.code
        FROM `tbl_party_master` pm
        LEFT JOIN tb_customers c
        LEFT JOIN tb_orders o ON o.customer_id=c.id ON pm.code=c.code
        WHERE o.user_id=? AND o.status !=0 AND o.hold_type !=0 AND pm.code IS NOT NULL AND pm.code !='' AND
        pm.code != 0 AND o.company_code=? AND o.branch_code=? AND pm.code LIKE ?
        ORDER BY o.createdon DESC";
        $get_data = $this->db->query($sql, [$uid, $company_code, $branch_code, $cid]);
        $data = array();
        if($get_data->num_rows() > 0){
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->code;
            }
        }
        echo json_encode($data);
    }

    public function changeeligibleamount()
    {
        $uid = $this->session->userdata('user_id');
        $total_amount = 0;
        $updated_column = $data = [];
        $post = $_POST;
        if(isset($post) && !empty($post)){
            if (isset($post['total_amount']) && $post['total_amount'] != "") {
                $total_amount = $this->db->escape_str($post['total_amount']);
                $set['limit_amount'] = $total_amount;
            }

            $business_partner_id = isset($post["business_partner_id"]) ? $this->db->escape_str($post["business_partner_id"]) : "";
            $hold_type = isset($post["hold_type"]) ? $this->db->escape_str($post["hold_type"]) : "";
            $additional_currency = isset($post["additional_currency"]) ? $this->db->escape_str($post["additional_currency"]) : "";

            //credit limit
            if($hold_type == 'CREDIT LIMIT') {
                $updated_column = ['credit_limit_amount' => $total_amount,'credit_currency'=>$additional_currency];
            } else {
            //cargo limit
                $updated_column = ['limit_amount' => $total_amount,'currency'=>$additional_currency];
            }

            $l = $this->common->updatetbledata('tbl_party_master',$updated_column,array('id'=>$business_partner_id));

            $data = $this->approvalordersmodal->getpartyamountdata($business_partner_id);

            echo json_encode($data);
        }
    }

    public function insertrefvalue()
    {
        $data  = array();
        $post = $_POST;
        if(isset($post) && !empty($post)) {
            $ref_val = ($post['ref_val']) ? $this->db->escape_str($post['ref_val']) : '';
            $order_id = ($post['order_id']) ? $this->db->escape_str($post['order_id']) : '';
            $table = 'tb_order_references';
            $data = ['order_id' => $order_id,'reference_id' => 'REM','ref_value' => $ref_val,'status'=>1];
            $data['createdon'] = date('Y-m-d H:i:s');
            $data['updatedon'] = date('Y-m-d H:i:s');
            $id = $this->common->insertTableData($table, $data);
            if ($id) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }

    public function updateresolution()
    {
        $set = $data = array();
        $post = $_POST;
        if(isset($post) && !empty($post)) {
            if (isset($post['resolution_id']) && $post['resolution_id'] != "") {
                $resolution_id = $this->db->escape_str($post['resolution_id']);
                $set['resolution_id'] = $resolution_id;
            }
            $order_id = $post["order_id"] ? $this->db->escape_str($post["order_id"]) : "";

            $l = $this->common->updatetbledata('tb_orders',$set,array('id'=>$order_id));

            $select = "resolution_id";
            $table = "tb_orders";
            $resolution_id=$this->common->gettbldata(['id' => $order_id],$select,$table,0,0);
            $data['resolution_id'] = $resolution_id;
            echo json_encode($data);
        }
    }

    public function updateapprovestatus()
    {
        $set = $data = array();
        $post = $_POST;
        if(isset($post) && !empty($post)) {
            $order_id = isset($post["order_id"]) ? $this->db->escape_str($post["order_id"]) : "";
            $hold_type = isset($post["hold_type"]) ? $this->db->escape_str($post["hold_type"]) : "";

            //credit limit
            if($hold_type == 'CREDIT LIMIT') {
                $updated_column = ['credit_approval' => 1];
            } else {
            // cargo limit
                $updated_column = ['cargo_approval' => 1];
            }
            $l = $this->common->updatetbledata('tb_orders',$updated_column,array('id'=>$order_id));
            echo json_encode(['result' => 'success']);
        }
    }

    public function getcurrencyname($currency_id)
    {
        $get_currency_name = "";
        $currency_name = $this->common->gettblrowdata(['status' => 1,'id'=>$currency_id],'currency','tbl_country_master',0,0);
        if(count($currency_name) > 0) {
            $get_currency_name = $currency_name['currency'];
        }
        return $get_currency_name;
    }

    public function gecurrencyid($currency_name)
    {
        $get_currency_id = "";
        $currency_id = $this->common->gettblrowdata(['status' => 1,'currency'=>$currency_name],'id','tbl_country_master',0,0);
        if(count($currency_id) > 0) {
            $get_currency_id = $currency_id['id'];
        }
        return $get_currency_id;
    }
}

