<?php

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\NoDataFoundException;
use App\PodUploads\PodFile;
use App\PodUploads\PodZipArchive;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Archiveddocuments extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(["archiveddocumentsmodel"]);
        if (!checkUrlAccessForUser('ARCHIVEDDOCUMENTS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $post = $this->input->post();
        $docId = (isset($post['doc_id']) && $post['doc_id'] > 0) ? (int)$post['doc_id'] : 0;
        $orderIds = $post['bookingid'] ?? [];
        log_message("error","Inn:".json_encode($orderIds));
        $referenceValues = $post['referencevalues'] ?? [];
        $customerId = $this->session->userdata('cust_id') > 0 ? (int)$this->session->userdata('cust_id') : 0;
        if (!empty($orderIds) || !empty($referenceValues) || $docId > 0) {
            $documentsData = $this->archiveddocumentsmodel->getDocumentsData($docId, $orderIds, $referenceValues, $customerId);
            foreach ($documentsData as $res) {
                if (!empty($res['imgpath'])) {
                    $extension = pathinfo($res['imgpath'], PATHINFO_EXTENSION);
                    try {
                        $imgLink = new PodFile($res['imgpath']);
                        $fileLocation = $imgLink->getPath();
                    } catch (Exception $e) {
                        log_message('error', 'Missing POD file for ' . $res['imgpath'] . ' | ' . $e->getMessage());
                        
                        $fileLocation = base_url('assets/img/file-not-found.png');
                        $extension = 'img'; 
                    }
                    if (!empty($fileLocation)) {
                    if (strlen($fileLocation) > 0) {
                        if ($extension == "pdf") {
                            $path = '<a target="_blank" href="' . $fileLocation . '"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                        } else {
                            $path = '<a target="_blank" href="' . $fileLocation . '"><img src="' . $fileLocation . '" class="img-responsive" style="width: 10%;"></a>';
                        }
                        $documents[] = [
                            'document_id' => $res['id'],
                            'order_id' => $res['order_id'],
                            'doc_type' => $res['type_name'],
                            'path' => $path ?? "",
                            'created_by' => $res['drivername'] ?: $res['username'],
                            'date' => date("d M,y h:i A", strtotime($res['createdon'])),
                            'reference_values' => $res['reference_values']
                        ];
                    }
                    }
                }
            }
        }
        $data = [
            'page_title' => $this->lang->line('archived_documents'),
            'sub_title' => $this->lang->line('general_search'),
            'documents' => $documents ?? [],
            'bookingids' => $orderIds,
            'doc_id' => $docId,
            'documents_master' => $this->archiveddocumentsmodel->getDocumentsMasterData(),
            'selected_reference_values' => $referenceValues
        ];
        $this->newtemplate->dashboard("archiveddocuments/archived_documents", $data);
    }

    public function zipdocuments()
    {
        if ($this->session->userdata('user_id') != 30) {
            redirect('/');
        }
        $post = $this->input->post(null, true);
        $documentIdAndName = (isset($post['doc_id']) && $post['doc_id'] > 0) ? $post['doc_id'] : '';
        if ($documentIdAndName != '') {
            $documentData = explode("_", $documentIdAndName);
            if (isset($documentData[0])) {
                $documentId = $documentData[0];
            }
            if (isset($documentData[1])) {
                $documentName = $documentData[1];
            }
        } else {
            $documentId = 0;
            $documentName = '';
        }
        $companyCode = $post['company_code'] ?? '';
        $customerCodes = $post['customercodes'] ?? [];
        $fromDate = (isset($post['from_date']) && $post['from_date'] != '') ? date('Y-m-d', strtotime($post['from_date'])) : '';
        $toDate = (isset($post['to_date']) && $post['to_date'] != '') ? date('Y-m-d', strtotime($post['to_date'])) : '';
        if (!empty($customerCodes)) {
            $whereData = [
                'from_date' => $fromDate,
                'to_date' => $toDate,
                'document_id' => $documentId,
                'company_code' => $companyCode,
                'customer_codes' => $customerCodes,
                'condition' => 'for_count'
            ];
            $documentCount = $this->archiveddocumentsmodel->getDocumentsAndCount($whereData);
            $queryFlag = 1;
        }
        $data = [
            'page_title' => $this->lang->line('archived_documents'),
            'sub_title' => $this->lang->line('general_search'),
            'document_id' => $documentId ?? 0,
            'document_name' => $documentName ?? '',
            'selected_company_code' => $companyCode,
            'selected_customer_codes' => $customerCodes,
            'from_date' => $fromDate,
            'to_date' => $toDate,
            'documents_master' => $this->archiveddocumentsmodel->getDocumentsMasterData(),
            'company_codes' => $this->archiveddocumentsmodel->getCompanyCodes(),
            'document_count' => $documentCount['document_count'] ?? 0,
            'query_flag' => $queryFlag ?? 0
        ];
        $this->newtemplate->dashboard("archiveddocuments/archived_documents_zip", $data);
    }

    public function getcustomercodes()
    {
        $post = $this->input->post(null, true);
        $searchValue = $post['searchTerm'] ?? '';
        $getCustomerCodes = $this->archiveddocumentsmodel->searchCustomerCodes($searchValue);
        foreach ($getCustomerCodes as $customerCode) {
            $data[] = ['id' => $customerCode['code'], 'term' => $customerCode['code']];
        }
        echo json_encode($data ?? []);
    }

    /**
     * Action to create ZIP archive with PODs called by AJAX
     */
    public function getZipFile(): void
    {
        $post = $this->input->post(null, true);
        $documentIdAndName = (isset($post['doc_id']) && $post['doc_id'] > 0) ? $post['doc_id'] : '';
        if ($documentIdAndName != '') {
            $documentData = explode("_", $documentIdAndName);
            if (isset($documentData[0])) {
                $documentId = $documentData[0];
            }
            if (isset($documentData[1])) {
                $documentName = $documentData[1];
            }
        } else {
            $documentId = 0;
            $documentName = '';
        }
        $companyCode = $post['company_code'] ?? '';
        $customerCodes = $post['customer_codes'] ?? [];
        $fromDate = (isset($post['from_date']) && $post['from_date'] != '') ? date('Y-m-d', strtotime($post['from_date'])) : '';
        $toDate = (isset($post['to_date']) && $post['to_date'] != '') ? date('Y-m-d', strtotime($post['to_date'])) : '';
        $zipFileName = $fromDate . "_" . $toDate . "_" . $documentName . "_" . $companyCode . "_" . implode("_", $customerCodes) . ".zip";
        $zipArchive = new PodZipArchive($zipFileName);
        $status = 'failed';
        if ($zipArchive->exists()) {
            echo json_encode(['file_path' => $zipArchive->getPath(), 'status' => 'success']);
            return;
        }
        $whereData = [
            'from_date' => $fromDate,
            'to_date' => $toDate,
            'document_id' => $documentId,
            'company_code' => $companyCode,
            'customer_codes' => $customerCodes,
            'condition' => 'for_documents'
        ];
        $documentsData = $this->archiveddocumentsmodel->getDocumentsAndCount($whereData);
        if (!empty($documentsData)) {
            $status = $zipArchive->generateZipFile($documentsData, $documentName) ? 'success' : 'failed';
        }
        echo json_encode(['file_path' => $zipArchive->getPath(), 'status' => $status]);
    }

    /**
     * Route for AJAX call to check if given bookings have any documents
     */
    public function checkPods(): void
    {
        $bookingIds = $this->input->post('booking_ids', true) ?? [];
        $referenceIds = $this->input->post('referencevalues', true) ?? [];

        if (empty($bookingIds) && (empty($referenceIds))) {
            throw new BadRequestException('booking id or reference value is required');
        }
        if (!empty($bookingIds)) {
            if (!$this->archiveddocumentsmodel->documentsExistsFor($bookingIds)) {
                throw new NoDataFoundException('No documents found for given bookingsid');
            }
        }
        if (!empty($referenceIds)) {
            if (!$this->archiveddocumentsmodel->documentsExistsForReferenceValues($referenceIds)) {
                throw new NoDataFoundException('No documents found for given referenceid');
            }
        }

        echo json_encode(['status' => 'success']);
    }

    /**
     * Route for AJAX call to search bookings id's having documents which are older than 90 days
     */
    public function getBookingIds()
    {
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $searchTerm = $this->input->post('searchTerm', true) ?? '';
        $customerId = $this->session->userdata('cust_id') > 0 ? (int)$this->session->userdata('cust_id') : 0;
        $getBookingIds = $this->archiveddocumentsmodel->searchBookingIds($searchTerm, $companyCode, $customerId, $branchCode);
        foreach ($getBookingIds as $bookingIds) {
            $data[] = ['id' => $bookingIds['order_id'], 'text' => $bookingIds['order_id']];
        }
        echo json_encode($data ?? []);
    }

    public function generateZipForArchivedDocuments()
    {
        $documentIds = $this->input->post('document_ids', true) ?? [];
        $zipFileName = implode("_", $documentIds) . ".zip";
        $zipArchive = new PodZipArchive($zipFileName);
        $status = 'failed';
        if ($zipArchive->exists()) {
            echo json_encode(['file_path' => $zipArchive->getPath(), 'status' => 'success']);
            return;
        }
        $documentsData = $this->archiveddocumentsmodel->getDocumentPathsWithIds($documentIds);
        if (!empty($documentsData)) {
            $status = $zipArchive->generateZipFile($documentsData, 'Documents') ? 'success' : 'failed';
        }
        echo json_encode(['file_path' => $zipArchive->getPath(), 'status' => $status]);
    }

    /**
     * Route for AJAX call to search Reference Values(DQ and PO) reference values having documents which are older than 90 days
     */
    public function getReferenceValues()
    {
        $companyCode = $this->session->userdata('company_code');
        $searchTerm = $this->input->post('searchTerm', true) ?? '';
        $customerId = $this->session->userdata('cust_id') > 0 ? (int)$this->session->userdata('cust_id') : 0;
        $referenceValues = $this->archiveddocumentsmodel->searchReferenceValues($searchTerm, $companyCode, $customerId);
        foreach ($referenceValues as $referenceValue) {
            $data[] = ['id' => $referenceValue['ref_value'], 'text' => $referenceValue['ref_value']];
        }
        echo json_encode($data ?? []);
    }
}
