<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ats extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('Common');
    }

    /*
     *  Purpose : It will initialize Ats Service Process
     */
    public function ats_lib()
    {
        $action = $this->input->post('action', true);
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if (isset($_POST) && isset($_POST['party_master_id']) && is_numeric($_POST['party_master_id'])) {
            $party_master_id = $this->input->post('party_master_id');
            $this->load->library('AtsService');
            $customer_info = $this->atsservice->ats_client($party_master_id, $branch_code, $company_code, $user_id);
            $data = array("customer_info" => $customer_info, 'party_master_id' => $party_master_id);
            $this->load->view('ats/ats_list', $data);
        } else {
            // handle bulk address here.
            $ats_parties = (array) json_decode($this->input->post("ats_parties"), true);
            $this->load->library('AtsService');
            $customer_info = $this->atsservice->ats_client_bulk($ats_parties, $branch_code, $company_code, $user_id);
            if ((!empty($customer_info)) && is_array($customer_info) && sizeof($customer_info) > 0) {
                if ("list" === $action) {
//                    $party_master_id = $this->input->post('party_master_id',true);
                    $party_master_id = 0; //$this->input->post('party_master_id',true);
                    $data = array("customer_info" => $customer_info, 'party_master_id' => $party_master_id);
                    $this->load->view('ats/ats_list', $data);
                } else {
                    echo sizeof($customer_info);
                }
            } else {
                echo 0;
            }
        }
        return;
    }

    /*
     *   Pupose : To change Ats Service status.
     *   @ param  status stirng (H || O || C)
     *   H - Hold
     *   O - Override
     *   C - Cancel
     */
    public function ats_status_update()
    {
        $party_master_id = $this->input->post('party_master_id');
        $status = $this->input->post('status');
        $this->load->library('AtsService');
        header('Content-Type: application/json');
        echo $this->atsservice->ats_status_update($party_master_id, $status);
    }

    /*
     *  Purpose: To set ats demo.
     */
    public function ats_demo()
    {
        $this->newtemplate->dashboard("ats/ats_demo");
    }

}
