<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class AuAwsApi extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(["common", "AuAwsModel"]);
        $this->load->helper(["edivalidation"]);
        $this->load->library("AuAwsOrderCreate");
    }

    /**
     *Australia AWS orders create
     *
     * @return void
     */
    public function orderCreate(): void
    {
        try {
            $getRequestHeaders = $this->input->request_headers(null, true);
            $getAuthenticationStatus = $this->checkAuthentication($getRequestHeaders);
            if ($getAuthenticationStatus == true) {
                $xmlData = file_get_contents("php://input");
                $this->auawsordercreate->processXmlOrderData($xmlData);
            } else {
                echo json_encode($this->auawsordercreate->statusCodes("401"));
            }
        } catch (Exception $e) {
            log_message('error', 'Exception Occur when pulling AU_AWS xml to eTN :' . json_encode($e->getMessage()));
        }
    }

    /**
     * Customer authentication
     *
     * @param $getRequestHeaders
     * @return bool
     */
    private function checkAuthentication($getRequestHeaders): bool
    {
        $password = $this->passwordEncrypt($getRequestHeaders["password"]);
        return !empty($this->AuAwsModel->getCustomerData($getRequestHeaders["user_name"], $password));
    }

    /**
     * This method password encrypt
     *
     * @param $str
     * @return string
     */
    function passwordEncrypt($str): string
    {
        return password_hash($str, PASSWORD_DEFAULT);
    }
}
