<?php

defined('BASEPATH') or exit('No direct script access allowed');

class AuManualMilestoneUpdate extends CI_Controller
{
    private $statusData = [];

    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->library("BiteTransitService");
        $this->load->library("AuUrlAuthentication");
    }

    /**
     * @throws JsonException
     */
    public function index()
    {
        $getAuthenticationData = [
            'username' => $this->input->post('auMilestoneUserName', true),
            'password' => $this->input->post('auMilestonePassword', true)
        ];
        if (!$this->auurlauthentication->isAllowedToAccess($getAuthenticationData)) {
            return false;
        }
        $this->statusData = [
            'acceptedByDriver' => $this->input->post('acceptedByDriver', true),
            'pickUpDate' => $this->input->post('pickUpDate', true),
            'inTransitDate' => $this->input->post('inTransit', true),
            'deliveryDate' => $this->input->post('deliveryDate', true),
            'orderRowId' => $this->input->post('orderRowId', true)
        ];
        echo json_encode($this->statusUpdate($this->statusData), JSON_THROW_ON_ERROR);
    }

    public function statusUpdate($statusData): array
    {
        $returnMessage = [];
        if (empty($statusData['orderRowId']) || !($statusData['acceptedByDriver']
                || $statusData['pickUpDate'] || $statusData['inTransitDate'] || $statusData['deliveryDate'])) {
            $returnMessage['postData'] = $this->statusCodes("204");
            $returnMessage['postData']['message'] = "Please provide an order-id and at least one date.";
            return $returnMessage;
        }
        if (!$this->orderValidation($statusData)) {
            return $this->statusCodes("203");
        }

        if (!empty($statusData['acceptedByDriver'])) {
            $returnMessage['acceptedByDriver'] = $this->driverAccept(
                $statusData['orderRowId'],
                $statusData['acceptedByDriver']
            );
        }
        if (!empty($statusData['pickUpDate'])) {
            $statusName = 'PICKUP';
            $returnMessage['pickUp_status'] = $this->insertStatus(
                $statusData['pickUpDate'],
                $statusName,
                $statusData['orderRowId']
            );
        }
        if (!empty($statusData['inTransitDate'])) {
            $statusName = 'INTRANSITIVE';
            $returnMessage['inTransit_status'] = $this->insertStatus(
                $statusData['inTransitDate'],
                $statusName,
                $statusData['orderRowId']
            );
        }
        if (!empty($statusData['deliveryDate'])) {
            $statusName = 'DELIVERED';
            $returnMessage['delivered_status'] = $this->insertStatus(
                $statusData['deliveryDate'],
                $statusName,
                $statusData['orderRowId']
            );
        }
        return $returnMessage;
    }

    public function orderValidation($statusData): bool
    {
        $orderQuery = "SELECT id
                FROM `tb_orders`
                WHERE company_code in ?  AND id= ? AND status != ? AND shift_id !=?";
        $getOrderData = $this->db->query(
            $orderQuery,
            [["AUKN", "KNAU"], $statusData['orderRowId'], 0, 0]
        )->row_array();
        if (!empty($getOrderData)) {
            return true;
        }
        return false;
    }


    public function driverAccept($orderRowId, $date): array
    {
        $status = 0;
        $driverAcceptedDate = $this->dateFormatValidation($date);
        if (empty($driverAcceptedDate)) {
            return $this->statusCodes("406");
        }
        $this->load->helper('bonds_helper');
        $getTripId = $this->getTripId($orderRowId);
        if (empty($getTripId)) {
            return $this->statusCodes("201");
        }
        auupdatestatusbymanifest($orderRowId, $date);
        $getTripIdCheck = $this->getTripId($orderRowId);
        if (empty($getTripIdCheck)) {
            $status = 1;
            $this->saveEdiLogs($orderRowId, $status);
            return $this->statusCodes("200");
        }
        $this->saveEdiLogs($orderRowId, $status);
        return $this->statusCodes("424");
    }

    public function insertStatus($date, $statusName, $orderRowId): array
    {
        $stopDetailId = $lat = $lng = $StatusCode = $driver_id = $vehicle_id = $location = $status = 0;
        $getCreatedOnDate = $this->dateFormatValidation($date);
        if (empty($getCreatedOnDate)) {
            return $this->statusCodes("406");
        }
        $getOrderData = $this->getOrderData($orderRowId);
        if (empty($getOrderData)) {
            return $this->statusCodes("204");
        }
        $getStatusData = $this->getStatusData($statusName);
        if (empty($getStatusData)) {
            return $this->statusCodes("204");
        }
        $reason = '';
        $getVendorName = $this->common->gettblrowdata([
            'id' => $getOrderData['vendor_id']
        ], 'name', 'tb_vendors', 0, 0);
        if (!empty($getVendorName)) {
            $reason = 'From ' . $getVendorName['name'];
        }
        $stopId = $this->getOrderStopData($getStatusData['stopType'], $getOrderData['shift_id']);
        $dataArray = [
            'order_id' => $orderRowId,
            'shipment_id' => $getOrderData['shift_id'],
            'stop_id' => $stopId,
            'stop_detail_id' => $stopDetailId,
            'stop_type' => $getStatusData['stopType'],
            'trip_id' => $getOrderData['trip_id'],
            'status_id' => $getStatusData['statusId'],
            'status_code' => $getStatusData['statusCode'],
            'status' => 1,
            'reason' => $reason,
            'latitude' => $lat,
            'longitude' => $lng,
            'createdon' => $getCreatedOnDate,
            'loc_name' => $location,
            'driver_id' => $driver_id,
            'vehicle_id' => $vehicle_id
        ];
        $getStopStatusData = $this->common->gettblrowdata([
            'order_id' => $orderRowId,
            'shipment_id' => $getOrderData['shift_id'],
            'stop_id' => $stopId,
            'stop_detail_id' => $stopDetailId,
            'stop_type' => $getStatusData['stopType'],
            'trip_id' => $getOrderData['trip_id'],
            'status_id' => $getStatusData['statusId'],
            'status_code' => $getStatusData['statusCode'],
            'loc_name' => $location,
            'driver_id' => $driver_id,
            'vehicle_id' => $vehicle_id
        ], 'id', 'tb_stop_status', 0, 0);
        if (empty($getStopStatusData)) {
            $insertId = $this->common->insertTableData('tb_stop_status', $dataArray);
            if (!empty($insertId)) {
                if ($statusName === "DELIVERED") {
                    $getTripId = $this->getTripId($orderRowId);
                    if (!empty($getTripId)) {
                        $this->driverAccept($orderRowId, $getOrderData['pickup_datetime']);
                    }
                    $this->tripClose($getOrderData);
                }

                $status = 1;
                $this->saveEdiLogs($orderRowId, $status);
                return $this->statusCodes("200");
            }
            $this->saveEdiLogs($orderRowId, $status);
            return $this->statusCodes("424");
        }
        $updatedID = $this->common->updatetbledata("tb_stop_status", $dataArray, ["id" => $getStopStatusData['id']]);
        if (!empty($updatedID)) {
            if ($statusName === "DELIVERED") {
                $this->tripClose($getOrderData);
            }
            $status = 1;
            $this->saveEdiLogs($orderRowId, $status);
            return $this->statusCodes("200");
        }
        $this->saveEdiLogs($orderRowId, $status);
        return $this->statusCodes("424");
    }

    private function getTripId($orderRowId): array
    {
        return $this->common->gettblrowdata([
            'id' => $orderRowId,
            'trip_id' => 0
        ], 'id', 'tb_orders', 0, 0);
    }


    private function tripClose($order): bool
    {
        $this->common->updatetbledata("tb_orders", [
            "trip_sts" => 1
        ], [
            "id" => $order['id']
        ]);
        $this->common->updatetbledata("tb_shifts", [
            "status" => 0
        ], [
            "id" => $order['shift_id']
        ]);
        $this->common->updatetbledata("tb_trips", [
            "status" => 0
        ], [
            "id" => $order['trip_id']
        ]);
        /* Generated Summary */
        $curtz = "";
        $user = $this->db->select("id,country_code")
            ->get_where("tb_users", [
                "id" => $order['user_id']
            ], 1, 0)
            ->row_array();
        $getTimeZone = getUserTimeZone($user['country_code']);
        $curtz = $getTimeZone['timezone'];

        $this->bitetransitservice->generatesummary($order['trip_id'], $curtz);
        return true;
    }

    private function dateFormatValidation($date): string
    {
        $formattedDate = '';
        if (!empty($date) && preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/', $date)) {
            return date("Y-m-d H:i:s", strtotime($date));
        }
        return $formattedDate;
    }

    private function getOrderData($orderRowId): array
    {
        return $this->common->gettblrowdata([
            'id' => $orderRowId
        ], 'id,order_id,shift_id,trip_id,pickup_pincode,delivery_pincode,plat,plng,dlat,dlng,vendor_id,user_id,company_code,branch_code,pickup_datetime', 'tb_orders', 0, 0);
    }

    private function getOrderStopData($statusType, $shiftId): int
    {
        $stopId = 0;
        $stopIdInfo = $this->common->gettblrowdata([
            "shipment_id" => $shiftId,
            'stoptype' => $statusType,
            "status" => 1
        ], "id", "tb_shiporder_stops", 0, 0);
        if (!empty($stopIdInfo)) {
            $stopId = $stopIdInfo['id'];
        }
        return $stopId;
    }

    private function getStatusData($statusName): array
    {
        switch (strtoupper($statusName)) {
            case "PICKUP" :
                $statusData = ['stopType' => "P", 'statusCode' => '0500', 'statusName' => 'Pickup Or Drop'];
                break;
            case "INTRANSITIVE" :
                $statusData = [
                    'stopType' => "P",
                    'statusCode' => '1550',
                    'statusName' => 'Actual Transit Location'
                ];
                break;
            case "DELIVERED" :
                $statusData = ['stopType' => "D", 'statusCode' => '3000', 'statusName' => 'Delivered to Consignee'];
                break;
            default:
                $statusData = ['stopType' => "", 'statusCode' => '', 'statusName' => ''];
        }
        /**
         * get status id from  tb_status_master
         */
        $statusData['statusId'] = 0;
        if (!empty($statusData)) {
            $statusMasterQuery = 'SELECT tb_status_master.id
                FROM `tb_status_master`
                WHERE (status_code = ?  OR status_name = ?) AND status = ? ';
            $getStatusMasterData = $this->db->query(
                $statusMasterQuery,
                [$statusData['statusCode'], $statusData['statusName'], 1]
            )->row_array();
            if ($getStatusMasterData) {
                $statusData['statusId'] = $getStatusMasterData['id'];
            }
        }
        return $statusData;
    }

    private function statusCodes($code): array
    {
        $statusCodes = [];
        switch ($code) {
            case "200":
                $statusCodes['code'] = "200";
                $statusCodes['message'] = "status updated successfully";
                break;
            case "201":
                $statusCodes['code'] = "201";
                $statusCodes['message'] = "already status updated";
                break;
            case "424":
                $statusCodes['code'] = "424";
                $statusCodes['message'] = "status update fail";
                break;
            case "404":
                $statusCodes['code'] = "404";
                $statusCodes['message'] = "Unable to update status ";
                break;
            case "406":
                $statusCodes['code'] = "406";
                $statusCodes['message'] = "Please provide the date and time in the right format, such as (Y-m-d H:i:s)";
                break;
            case "204":
                $statusCodes['code'] = "204";
                $statusCodes['message'] = "no data found";
                break;
            case "203":
                $statusCodes['code'] = "203";
                $statusCodes['message'] = "Please manifest this order, as it has not yet been manifested";
                break;
            default:
                $statusCodes['code'] = "null";
                $statusCodes['message'] = "no status code found ";
                break;
        }
        return $statusCodes;
    }

    private function saveEdiLogs($orderRowId, $status)
    {
        $getOrderData = $this->getOrderData($orderRowId);
        $response = ($status === 0) ? 'Fail' : 'Success';
        if (!empty($getOrderData) && !empty($this->statusData)) {
            $this->load->library('Edi_logger');
            $this->edi_logger->setEdi_type(1);
            $this->edi_logger->setTransaction_id(time());
            $this->edi_logger->setEdi_name('Status');
            $this->edi_logger->setBounded_type(2);
            $this->edi_logger->setEdi_format_type('json');
            $this->edi_logger->setStatus($status);
            $this->edi_logger->setObj_type_name('order-id');
            $this->edi_logger->setTxn_obj_id(($getOrderData['order_id'] ?? 0));
            $this->edi_logger->setEdi_request(json_encode($this->statusData));
            $this->edi_logger->setEdi_response($response);
            $this->edi_logger->setCompany_code(($getOrderData['company_code'] ?? "AUKN"));
            $this->edi_logger->setBranch_code(($getOrderData['branch_code'] ?? "AUKN"));
            $this->edi_logger->setUser_id(($getOrderData['user_id'] ?? 0));
            $this->edi_logger->saveToEdiLogs();
        }
    }

}
