<?php

defined('BASEPATH') or exit('No direct script access allowed');

class AuManualPodUpload extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->library("AuUrlAuthentication");
    }

    public function index()
    {
        $getAuthenticationData = [
            'username' => $this->input->post('auMilestoneUserName', true),
            'password' => $this->input->post('auMilestonePassword', true)
        ];
        $getPostData = [
            'orderRowId' => $this->input->post('orderRowId', true),
            'receiverName' => $this->input->post('receiverName', true),
            'podDate' => $this->input->post('podDate', true)
        ];

        if (!$this->auurlauthentication->isAllowedToAccess($getAuthenticationData)) {
            return false;
        }
        $podStatus = $this->podUpload($getPostData);
        echo json_encode($podStatus, JSON_THROW_ON_ERROR);
    }

    private function podUpload($getPostData): array
    {
        $validationResult = $this->validatePostData($getPostData);
        if (empty($validationResult)) {
            return $this->statusCodes("204");
        }
        if (!$this->orderValidation($getPostData)) {
            return $this->statusCodes("203");
        }
        $getPostData['podDate'] = date("Y-m-d H:i:s", strtotime($getPostData['podDate']));

        $config = [
            'upload_path' => NEW_POD_PATH,
            'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
        ];
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('podFile')) {
            $getUploadData = $this->upload->data();
            return $this->insertPodData($getPostData, $getUploadData['file_name']);
        }
        log_message(
            'error',
            'Au_manual_pod_upload_failed:' .
            json_encode($this->upload->display_errors(), JSON_THROW_ON_ERROR)
        );
        $errorMsg = $this->statusCodes('424');
        $errorMsg['error'] = strip_tags($this->upload->display_errors());
        return $errorMsg;
    }

    private function insertPodData($getPostData, $fileName): array
    {
        $getOrderData = $this->common->gettblrowdata([
            'id' => $getPostData['orderRowId']
        ], 'id,order_id,shift_id,trip_id,user_id', 'tb_orders', 0, 0);

        $getDocType = $this->common->gettblrowdata([
            'type_name' => 'POD'
        ], 'id', 'tb_document_types', 0, 0);
        $documentTypeId = 3;
        if (!empty($getDocType)) {
            $documentTypeId = $getDocType['id'];
        }

        $podInsertArray = [
            "trip_id" => $getOrderData['trip_id'],
            "shipment_id" => $getOrderData['shift_id'],
            "stop_id" => 0,
            "stop_detail_id" => 0,
            "stop_type" => "D",
            "doc_type" => $documentTypeId,
            "imgpath" => $fileName,
            "latitude" => 0,
            "longitude" => 0,
            "user_id" => $getOrderData['user_id'],
            "createdby" => 0,
            "order_id" => $getOrderData['id'],
            "receiver_name" => (!empty($getPostData['receiverName']) ? $getPostData['receiverName'] : ''),
            "createdon" => $getPostData['podDate']
        ];
        $insertId = $this->common->insertTableData("tb_pod_uploads", $podInsertArray);
        if (!empty($insertId)) {
            return $this->statusCodes('200');
        }
        return $this->statusCodes('404');
    }

    private function validatePostData($postData): bool
    {
        if (!empty($postData['orderRowId']) && !empty($postData['podDate']) &&
            preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/', $postData['podDate'])) {
            return true;
        }
        return false;
    }

    public function orderValidation($postData): bool
    {
        $orderQuery = "SELECT id
                FROM `tb_orders`
                WHERE company_code in ?  AND id= ? AND status != ? AND shift_id !=?";
        $getOrderData = $this->db->query(
            $orderQuery,
            [["AUKN", "KNAU"], $postData['orderRowId'], 0, 0]
        )->row_array();
        if (!empty($getOrderData)) {
            return true;
        }
        return false;
    }

    private function statusCodes($code): array
    {
        $statusCodes = [];
        switch ($code) {
            case "200":
                $statusCodes['code'] = "200";
                $statusCodes['message'] = "POD uploaded successfully";
                break;
            case "424":
                $statusCodes['code'] = "424";
                $statusCodes['message'] = "POD upload failed";
                break;
            case "404":
                $statusCodes['code'] = "404";
                $statusCodes['message'] = "Unable to Insert POD ";
                break;
            case "204":
                $statusCodes['code'] = "204";
                $statusCodes['message'] = "Please provide an order-id and pod date (Y-m-d H:i:s).";
                break;
            case "203":
                $statusCodes['code'] = "203";
                $statusCodes['message'] = "Please manifest this order, as it has not yet been manifested";
                break;
            default:
                $statusCodes['code'] = "null";
                $statusCodes['message'] = "no status code found ";
                break;
        }
        return $statusCodes;
    }


}
