<?php
defined('BASEPATH') or exit('No direct script access allowed');

use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;

class Auasnupload extends CI_Controller
{

    /**
     * Class Variables
     */
    private $companyCode = '';
    private $countryCode = '';
    private $case_id_unique = array();
    private $tb_cargo_details_id = "";
    private $order_ref_num = array();
    private $ref_connote_arr = array();

    /**
     * Class Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->model("Aureportsmodel");
        $this->companyCode = 'AUKN';
        $this->countryCode = substr($this->companyCode, 0, 2);
        $this->userId = "";
    }

    public function uploadasn()
    {
        $file_content = file_get_contents("php://input");
        $filename = "container.txt";
        $msg = $this->asnprocess($file_content, $filename);
    }

    public function asncron()
    {

        $folder = AUASN_OUTBOUND_TEST_PATH;
        $sftp_url = AUASN_SERVER_IP;
        $username = AUASN_USERNAME;
        $pwd = AUASN_PWD;

        $sftp = new SFTP($sftp_url);
        if (!$sftp->login($username, $pwd)) {
            unset($sftp);
            exit('Login Failed');
        } else {
            $sftp->chdir($folder);
            $files_list = $sftp->nlist();
            if (!empty($files_list)) {
                foreach ($files_list as $index => $filename) {
                    $file_path_parts = pathinfo($filename);
                    $file_ext = strtoupper($file_path_parts['extension']);
                    if ($file_ext == "TXT") {
                        $server_file = $folder . '/' . $filename;
                        $file_content = $sftp->get($folder . '/' . $filename);
                        /* move to backup folder */
                        $bkp_file = "/pub/backupasnfiles/" . $filename;
                        /* log_message('error', 'backup file::-->' . json_encode($bkp_file) . '-------->' . json_encode($server_file)); */
                        $move = $sftp->put($bkp_file, $sftp->get($server_file));
                        $sftp->delete($server_file, false);
                        if (!empty($file_content)) {
                            $msg = $this->asnprocess($file_content, $filename);
                        }
                    }
                }
            } else {
                log_message("error", "No files available in Australia ASN FTP");
            }
        }
        unset($sftp);
    }

    public function asnprocess($fileContent, $file_name)
    {
        ini_set("post_max_size", 0);
        ini_set("upload_max_filesize", "100M");
        ini_set("max_input_time", 6000);
        ini_set("memory_limit", "1024M");
        ini_set("max_execution_time", 6000);
        $processed = [];
        $log_edi_arr = array();
        $log_edi_arr['file_name'] = $file_name;

        try {
            /* asn text file  */
           /*  $file = './assets/edi/data/asn.txt';
            file_put_contents($file, '');
            $handle = fopen($file, 'w');
            fwrite($handle, $fileContent);
            $handle = fopen($file, 'r');
            */

            /* Returns directory path used for temporary files */
            $dir = sys_get_temp_dir();
            /*  Create temporary file with unique file name */
            $file = tempnam($dir, "asn");
            file_put_contents($file, '');
            $handle = fopen($file, "w");
            fwrite($handle, $fileContent);
            $handle = fopen($file, 'r');
            //fclose($);
            //echo file_get_contents($tmp);


            if ($handle) {
                while (($line = fgets($handle)) !== false) {
                    $words = preg_split('/\t/', $line);
                    $ctnr_number = isset($words[4]) ? $words[4] : '';
                    /* Container number 0, that particular 0 numbers removing*/
                    if (!empty($ctnr_number)) {
                        $processedchk = $this->processLine($line);
                        if (!empty($processedchk)) {
                            $processeddata[$ctnr_number][] = $processedchk;
                        }
                    }
                }
            } else {
                // echo 'Unable to access file!!!';
                $msg = 'Unable to access file!!!';
                log_message('error', "Australia ASN FTP Unable to access files");
                exit();
            }

            fclose($handle);

            $orders = [];
            $brnchcode = $uid = $handling_unit = "";
            if(!empty($processeddata)){
              /* data process container wise */
                foreach ($processeddata as $container_num => $processed) {
                    /*  log_message('error', 'container_num:::' . json_encode($container_num) . '---------->'); */
                    $container_where = array('ref_value' => $container_num, 'reference_id' => 'CTR', 'status' => 1);
                    $container_check = $this->common->gettblrowdata(
                        $container_where,
                        'ref_value',
                        'tb_order_references',
                        0,
                        0
                    );

                    /*  log_message('error', 'container_check:::' . $this->db->last_query());
                    log_message('error', 'container_check:::' . json_encode($container_check) . '---------->'); */
                    $log_edi_arr['container_num'] = $container_num;
                    $log_edi_arr['container_status'] = "ASN";
                    $log_edi_arr['status'] = 0;
                    if (!empty($container_check)) {
                        $log_edi_arr['status'] = 1;
                        $log_edi_arr['container_status'] = "Old ASN";  // container already exists in eTN
                        $edi_id = $this->edilogtransactions($log_edi_arr);
                        continue;
                    }
                    for ($i = 0; $i < count($processed); $i++) {
                        /* Insert Cargo Details */
                        $processrecord = $processed[$i];
                        $cargdetid = $this->insertCargoDetails($processed[$i]);
                        if (!empty($cargdetid)) {
                            $brnchcode = $cargdetid["branch_code"];
                            $uid = $cargdetid["user_id"];
                            $handling_unit = $cargdetid["handling_unit"];
                        }
                        if (!empty($cargdetid)) {
                            $processed[$i]['tb_cargo_details_id'] = $cargdetid['id'];
                        }
                    }
                    /* log_message('error',json_encode($processed).'------------------------------>');*/
                    //if ($brnchcode != "" && $uid != "") {

                    /* prepare orders based on state and consigee name */
                    $orders = $this->prepareOrders($processed);
                    /* log_message('error','orders:::'.json_encode($orders).'------------------------------>');*/
                    if (!empty($orders)) {

                        /* get customer id and order type id */
                        $customer_id = $this->getCustomerId();
                        $order_type = $this->getOrderTypeId();
                        /* $consignment_note = $this->getConsigneeNote(); */
                        for ($j = 0; $j < count($orders); $j++) {
                             if(!empty($orders[$j])){

                               /* get branch code and user id */
                                $branch_code = $this->getBranchcode($orders[$j]['for_state']);
                                if (!empty($branch_code)) {
                                    $user_Id = $this->getUserId($branch_code);
                                    $orders[$j]['branch_code'] = $branch_code;
                                    if (!empty($user_Id)) {
                                        $orders[$j]['user_id'] = $uid;
                                    }
                                }
                                $orders[$j]['handling_unit'] = $handling_unit;
                                $orders[$j]['customer_id'] = $customer_id;
                                $orders[$j]['order_type'] = $order_type;
                                /* Insert Shipments */
                                $orders[$j]['tb_shipments_id'] = $this->insertShipments($orders[$j]);
                                /* Insert Shipping */
                                $orders[$j]['pickup_partyid'] = $this->saveShipper($orders[$j], 'Shipper');
                                $orders[$j]['drop_partyid'] = $this->saveConsignee($orders[$j], 'Consignee');
                                /* find carrier */
                                $orders[$j]['vendor_id'] = 0;
                                $consignee_postalcode = $orders[$j]['for_zipcode'];
                                if ($consignee_postalcode != "" && $consignee_postalcode > 0) {
                                    $orders[$j]['vendor_id'] = $this->findcarrier($consignee_postalcode, $orders[$j]);
                                }
                                /* Insert or Update Orders */
                                $orders[$j]['tb_orders_id'] = $this->insertOrder($orders[$j]);
                                /*    log_message('error',$this->db->last_query().'------------->');*/
                                /* Update Orders */
                                $orders[$j]['order_num'] = $this->updateorder($orders[$j]);
                                /* log_message('error', json_encode($orders[$j]['order_num']) . '---:' . $j . ':----:' . $orders[$j]['ctnr_number'] . ':---------------->'); */
                                /* Insert Order Parties */
                                $orders[$j]['tb_order_parties_id'] = $this->insertOrderParties($orders[$j]);
                                /* Insert or Update Order Details */
                                $orders[$j]['tb_order_details_id'] = $this->insertOrderDetails($orders[$j]);
                                /* Insert Order References */
                                $orders[$j]['tb_order_ref_ids'] = $this->insertOrderReferences($orders[$j]);
                                /* Inserting Order Cargo Details */
                                $orders[$j]['tb_order_cargodetails_id'] = $this->checkCaseId($orders[$j]);
                                if (isset($orders[$j]['hidden_rows']) && count($orders[$j]['hidden_rows'])) {
                                    for ($k = 0; $k < count($orders[$j]['hidden_rows']); $k++) {
                                        $orders[$j]['hidden_rows'][$k]['tb_orders_id'] = $orders[$j]['tb_orders_id'];
                                        $orders[$j]['hidden_rows'][$k]['tb_order_cargodetails_id'] = $this->checkCaseId($orders[$j]['hidden_rows'][$k]);
                                    }
                                }
                                $log_edi_arr['status'] = 1;
                                /* Update Orders */
                                $upd = $this->updateCargodetails($orders[$j]);
                            }
                        }
                        $edi_id = $this->edilogtransactions($log_edi_arr);
                    }
                    //}
                }
                $msg = 'Successfully Processed!!!!!';
            }else{
                $msg = 'ASN file is empty!!!!!';
            }

            return $msg;
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    private function insertCargoDetails($input)
    {
        $response = array();
        $insert = [];
        if (isset($input['branch_code'])) {
            $branch_code = $input['branch_code'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
        }
        if (isset($input['user_id'])) {
            $User_Id = $input['user_id'];
        } else {
            $User_Id = $this->getUserId($branch_code);
        }
        $response['branch_code'] = $branch_code;
        $response['user_id'] = $User_Id;
        $insert['cargo_type'] = 'CARTON';
        $insert['cargotype_id'] = 0;
        if (isset($input['handling_unit'])) {
            $insert['handling_unit'] = $input['handling_unit'];
        } else {
            $insert['handling_unit'] = $this->getHandlingUnitId('CARTON', $User_Id);
        }
        $response['handling_unit'] = $insert['handling_unit'];
        $insert['handlingunit_id'] = 0;
        $insert['length'] = !empty($input['case_length']) ? $input['case_length'] : '';
        $insert['length_unit'] = '';
        $insert['width'] = !empty($input['case_width']) ? $input['case_width'] : '';
        $insert['width_unit'] = '';
        $insert['height'] = $input['case_height'];
        $insert['height_unit'] = '';
        $insert['weight'] = $input['case_gross_weight'];
        $insert['volumetric_weight'] = 0;
        $insert['volweight_uom'] = 0;
        $insert['ldm'] = null;
        $insert['weight_unit'] = '';
        $insert['volume'] = !empty($input['case_dim_uom']) ? $input['case_dim_uom'] : '';
        $insert['volume_unit'] = null;
        $insert['quantity'] = $input['sku_qty_unit'];
        $insert['goods_description'] = $input['sku_desc'];
        $insert['status'] = 1;
        $insert['stackable'] = 0;
        $insert['grounded'] = 0;
        $insert['splittable'] = 0;
        $insert['dg_goods'] = 0;
        $insert['createdby'] = $User_Id;
        $insert['updatedby'] = null;
        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
        $response['id'] = $this->common->insertTableData('tb_cargo_details', $insert);
        return $response;
    }

    private function insertShipments($input)
    {
        $resp = "";
        $insert = [];
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            if (isset($input['branch_code']) && $input['branch_code'] != "") {
                $branch_code = $input['branch_code'];
            } else {
                $branch_code = $this->getBranchcode($input['for_state']);
            }
            $user_id = $this->getUserId($branch_code);
        }
        $insert['pickupcnt'] = 1;
        $insert['shipid'] = $input['ctnr_number'];
        $insert['dropcnt'] = 1;
        if (isset($input['handling_unit']) && $input['handling_unit'] != "") {
            $insert['unitspec'] = $input['handling_unit'];
        } else {
            $insert['unitspec'] = $this->getHandlingUnitId('CARTON', $user_id);
        }
        $insert['reason'] = $input['sku_desc'];
        $insert['ship_object'] = $input['sku_desc'];
        $insert['transport_mode'] = $input['pick_type'];
        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
        $resp = $this->common->insertTableData('tb_shipments', $insert);
        return $resp;
    }

    private function insertOrder($input)
    {
        try {
            /* log_message('error', "conginee state::" . $input['for_state'] . "::-->conginee name::" . $input['for_name'] . "::-->ASN order num::" . $input['order_number']) . "<--"; */
            $insert = [];
            // $insert['order_id'] = $input['order_number'];
            $insert['order_id'] = 0;
            if (isset($input['branch_code']) && $input['branch_code'] != "") {
                $branch_code = $input['branch_code'];
            } else {
                $branch_code = $this->getBranchcode($input['for_state']);
            }
            if (isset($input['user_id']) && $input['user_id'] != "") {
                $user_id = $input['user_id'];
            } else {
                $user_id = $this->getUserId($branch_code);
            }
            // Pick Up
            $shipper_data = $this->shipperstates($input['for_state']);
            $insert['pickup_company'] = "Kuehne Nagel";
            $insert['pickup_country'] = "AU";
            $insert['pickup_address2'] = $input['for_state'];
            if (!empty($shipper_data)) {
                $insert['pickup_city'] = $shipper_data['location_id'];
                $insert['pickup_pincode'] = $shipper_data['pincode'];
                $insert['pickup_address1'] = $shipper_data['address'];
            }

            // Delivery
            $insert['delivery_company'] = $input['for_name'];
            $insert['delivery_country'] = $input['for_country'];
            $insert['delivery_city'] = $input['for_city'];
            $insert['delivery_pincode'] = $input['for_zipcode'];
            $insert['delivery_address1'] = $input['for_addrline2'];
            $insert['delivery_address2'] = $input['for_state'];
            // vender id
            $insert['vendor_id'] = $input['vendor_id'];
            $insert['user_id'] = $user_id;
            if (isset($input['customer_id'])) {
                $insert['customer_id'] = $input['customer_id'];
            } else {
                $insert['customer_id'] = $this->getCustomerId();
            }
            $insert['product'] = 'KN AsiaLink';
            $insert['quantity'] = null;
            $insert['transport_mode'] = 'LTL';
            $insert['shipment_id'] = $input['tb_shipments_id'];
            $insert['created_source'] = 14;
            $insert['company_code'] = $this->companyCode;
            $insert['branch_code'] = $branch_code;
            $insert['drop_partyid'] = $input['drop_partyid'];
            $insert['pickup_partyid'] = $input['pickup_partyid'];
            $insert['created_source'] = 14;
            $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
            return $this->common->insertTableData('tb_orders', $insert);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }
    
    public function updateorder($input)
    {
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
            $user_id = $this->getUserId($branch_code);
        }
        $genord = array(
            "user_id" => $user_id,
            "order_id" => $input['tb_orders_id'],
            "country_code" => $this->countryCode,
            "company_code" => $this->companyCode
        );
        $booking_id = generatebookingid($genord);
        $upd = $this->db->where(array(
            'id' => $input['tb_orders_id']
        ))->update("tb_orders", array(
            'order_id' => $booking_id
        ));
        return $booking_id;
    }
   
    private function insertOrderParties($input)
    {
        try {
            $curdt = date('Y-m-d H:i:s');
            $orderPartiesOne = [];
            $orderPartiesTwo = [];
            // Reference - 1
            $orderPartiesOne['order_id'] = $input['tb_orders_id'];
            $orderPartiesOne['order_number'] = $input['order_num'];
            $orderPartiesOne['party_id'] = $input['pickup_partyid'];
            $orderPartiesOne['party_type'] = $this->getPartyType($input['pickup_partyid']);
            $orderPartiesOne['createdon'] = $orderPartiesOne['updatedon'] = $curdt;
            $ids[] = $this->common->insertTableData('tb_order_parties', $orderPartiesOne);
            // Reference - 2
            $orderPartiesTwo['order_id'] = $input['tb_orders_id'];
            $orderPartiesTwo['order_number'] = $input['order_num'];
            $orderPartiesTwo['party_id'] = $input['drop_partyid'];
            $orderPartiesTwo['party_type'] = $this->getPartyType($input['drop_partyid']);
            $orderPartiesTwo['createdon'] = $orderPartiesTwo['updatedon'] = $curdt;
            $ids[] = $this->common->insertTableData('tb_order_parties', $orderPartiesTwo);
            return implode(",", $ids);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    private function insertOrderDetails($input)
    {
        $insert = [];
        $insert['order_row_id'] = $input['tb_orders_id'];
        $insert['order_id'] = $input['order_num'];
        $insert['goods_description'] = $input['sku_desc'];
        $insert['revenue_currency'] = 'USD';
        $insert['department_code'] = 'CTP';
        $insert['order_type'] = $input['order_type'];
        $insert['consignment_note'] = $this->getConsigneeNote();
        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
        $orddet = $this->common->insertTableData('tb_order_details', $insert);
        return $orddet;
    }

    private function insertOrderReferences($input)
    {
        /* Reference - 1 */
        $curdt = date('Y-m-d H:i:s');
        $consingee_note = $this->getConsigneeNote($input['tb_orders_id'], 1);
        $reference3['order_id'] = $input['tb_orders_id'];

        /* $reference3['reference_id'] = 'COI'; */
        $reference3['reference_id'] = 'DQ';
        $reference3['ref_value'] = $consingee_note;
        $reference3['createdon'] = $reference3['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference3);
        /* Reference - 2 */
        $reference7['order_id'] = $input['tb_orders_id'];
        $reference7['reference_id'] = 'CTR';
        $reference7['ref_value'] = $input['ctnr_number'];
        $reference7['createdon'] = $reference7['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference7);
        /* Reference - 3 */

        $store_id = $input['for_id'];
        $reference8['order_id'] = $input['tb_orders_id'];
        $reference8['reference_id'] = 'COI';
        $reference8['ref_value'] = $store_id;
        $reference8['createdon'] = $reference8['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference8);

        $reference4['order_id'] = $input['tb_orders_id'];
        $reference4['reference_id'] = 'POS';
        $reference4['ref_value'] = $input['job_file_number'];
        $reference4['createdon'] = $reference4['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference4);
        return implode(",", $ids);
    }

    private function checkCaseId($input)
    {
        $insert_id = 0;
        if (!empty($input)) {
            if (!in_array($input['case_id'], $this->case_id_unique)) {
                $this->case_id_unique[] = $input['case_id'];
                $this->tb_cargo_details_id = $input['tb_cargo_details_id'];
                $ins = $this->insertOrderCargoDetails($input);
                $refins = $this->insertRefConnote($input);
            }
            /* ASN order reference number check */
            if (!in_array($input['order_number'], $this->order_ref_num)) {
                $ins = $this->order_ref_num[] = $input['order_number'];
                $ins = $this->insertRefAsnOrderId($input);
            }
            $input['tb_cargo_details_id'] = $this->tb_cargo_details_id;
            $insert_id = $this->insertInnerCargoDetails($input);
        }
        return $insert_id;
    }

    private function insertOrderCargoDetails($input)
    {
        $insert = [];
        $insert['order_id'] = $input['tb_orders_id'];
        $insert['cargo_id'] = $input['tb_cargo_details_id'];
        $insert['handling_unit'] = $input['sku_case_ratio'];
        $insert['length'] = $input['case_length'];
        $insert['width'] = $input['case_width'];
        $insert['height'] = $input['case_height'];
        $insert['weight'] = $input['case_gross_weight'];
        $insert['volumetric_weight'] = 0;
        $insert['volweight_uom'] = 0;
        $insert['ldm'] = 0;
        $insert['volume'] = $input['case_dim_uom'];
        $insert['quantity'] = 1;
        $insert['quantity_type'] = null;
        $insert['cargo_content'] = null;
        $insert['buyer_part'] = null;
        $insert['stop_detail_id'] = null;
        $insert['qr_code'] = $input['case_id'];
        $insert['status'] = 1;
        $insert['createdon'] = date('Y-m-d H:i:s');
        $lpc = $this->getConnote($input);
        if (!empty($lpc)) {
            $insert['load_plan_connote'] = $lpc;
        }
        $insid = $this->common->insertTableData('tb_order_cargodetails', $insert);
        return $insid;
    }

    private function insertInnerCargoDetails($input)
    {
        $insert = [];
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $User_Id = $input['user_id'];
        } else {
            if (isset($input['branch_code']) && $input['branch_code'] != "") {
                $branch_code = $input['branch_code'];
            } else {
                $branch_code = $this->getBranchcode($input['for_state']);
            }
            $User_Id = $this->getUserId($branch_code);
        }
        $curdt = date('Y-m-d H:i:s');
        $insert['cargo_id'] = $input['tb_cargo_details_id'];
        $insert['cargo_type'] = 'CARTON';
        $insert['goods_description'] = $input['sku_desc'];
        $insert['quantity'] = $input['sku_qty_unit'];
        $insert['length'] = !empty($input['case_length']) ? $input['case_length'] : '';
        $insert['length_unit'] = 'cm';
        $insert['width'] = $input['case_width'];
        $insert['width_unit'] = 'cm';
        $insert['height'] = $input['case_height'];
        $insert['height_unit'] = 'cm';
        $insert['weight'] = $input['case_gross_weight'];
        $insert['weight_unit'] = 'Kg';
        $insert['volume'] = !empty($input['case_dim_uom']) ? $input['case_dim_uom'] : '';
        $insert['volume_unit'] = null;
        $insert['stackable'] = 0;
        $insert['status'] = 1;
        $insert['createdby'] = $User_Id;
        $insert['createdon'] = $insert['updatedon'] = $curdt;
        $insert['ref_order_num'] = $input['order_number'];
        $insid = $this->common->insertTableData('tb_inner_cargo', $insert);
        return $insid;
    }

    private function insertRefAsnOrderId($input)
    {
        $curdt = date('Y-m-d H:i:s');
        $insert = [];
        $insert['order_id'] = $input['tb_orders_id'];
        $insert['reference_id'] = 'PO';
        $insert['ref_value'] = $input['order_number'];
        $insert['createdon'] = $insert['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $insert);
        return $ids;
    }

    private function getConnote($input)
    {
        $first = isset($input['asn_number']) ? $input['asn_number'] : "";
        $second = isset($input['sku_color']) ? $input['sku_color'] : "";
        $lpc = "";
        if ($first != "" && $second != "") {
            $split_first = explode('-', $first);
            if (!empty($split_first)) {
                $split1 = isset($split_first[1]) ? $split_first[1] : "";
                if ($split1 == "") {
                    $split1 = "SRG";
                }
                $split2 = isset($split_first[2]) ? $split_first[2] : "";
                $last_split2 = substr($split2, -4);
                $last_sku_color = substr($second, -5);
                $store_id = $input['for_id'];
                $lpc = $split1 . "-" . $store_id . "-" . $last_sku_color;
            }
        }
        return $lpc;
    }
    
    private function insertRefConnote($input)
    {
        $curdt = date('Y-m-d H:i:s');
        $lpc = $this->getConnote($input);
        if ($lpc != "") {
            if (!in_array($lpc, $this->ref_connote_arr)) {
                $this->ref_connote_arr[] = $lpc;
                $reference6['reference_id'] = 'LPC';
                $reference6['order_id'] = $input['tb_orders_id'];
                $reference6['ref_value'] = $lpc;
                $reference6['createdon'] = $reference6['updatedon'] = $curdt;
                $ids[] = $this->common->insertTableData('tb_order_references', $reference6);
            }
        }
    }

    public function updateCargodetails($input)
    {
        $upd = '';
        $cargo_data = $this->common->gettblrowdata(array(
            'order_id' => $input['tb_orders_id']
        ), 'SUM(IFNULL(quantity,0)) as quantity,SUM(IFNULL(weight,0)) as weight,SUM(IFNULL(volume,0)) as volume', 'tb_order_cargodetails', 0, 0);
        $quantity = $weight = $volume = 0;
        if (!empty($cargo_data)) {
            $getdata = array(
                "quantity" => $cargo_data['quantity'],
                "weight" => $cargo_data['weight'],
                "volume" => $cargo_data['volume']
            );
            $upd = $this->common->updatetbledata("tb_orders", $getdata, array(
                'id' => $input['tb_orders_id']
            ));
        }
        return $upd;
    }

    private function saveShipper($input, $type)
    {
        if (isset($input['branch_code']) && $input['branch_code'] != "") {
            $branch_code = $input['branch_code'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
        }
        $master_id = "";
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            $user_id = $this->getUserId($branch_code);
        }
        $address = $input['for_addrline1'] . ',' . $input['for_addrline2'] . ',' . $input['for_city'];
        $cdate = date('Y-m-d H:i:s');
        $company_code = $this->companyCode;
        $master_id = 0;
        $customer['company_code'] = $company_code;
        $customer['branch_code'] = $branch_code;
        $chktype = $this->db->select("id")
            ->order_by('created_on', 'DESC')
            ->get_where("tbl_party_types", array(
                'name' => $type,
                'company_code' => $company_code,
                "status" => 1
            ), 1, 0);
        if ($chktype->num_rows() > 0) {
            $party_id = $chktype->row()->id;
        } else {
            $party = array(
                'name' => $type,
                'description' => $type,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'created_on' => $cdate,
                'user_id' => $user_id
            );
            $party_id = $this->common->insertTableData("tbl_party_types", $party);
        }
        $master_id = $party_id;
        $country_code = "AU";
        $year = date('y');
        $week = date('W');
        $shipper_id = $country_code . $year . $week . $master_id;
        $code = $shipper_id;
        $randnum = time();
        $master = array(
            'party_type_id' => $party_id,
            'name' => "Kuehne Nagel",
            'email' => '',
            'password' => base64_encode(base64_encode($randnum)),
            'state' => $input['for_state'],
            'mobile' => 0,
            'country' => "AU",
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status' => '1',
            'fax' => 0
        );
        /* conginee state check */
        $consi_data = $this->shipperstates($input['for_state']);
        if (!empty($consi_data)) {
            $master = array_merge($master, $consi_data);
        }
        $shipper_data = $this->Checkshipperconsi($master, $party_id);
        if (!empty($shipper_data)) {
            $s_id = $shipper_data['id'];
            $ship_code = $shipper_data['code'];
            if (empty($ship_code)) {
                $code = $country_code . $year . $week . $s_id;
                $master['code'] = $code;
                $master['customeridentifier'] = $code;
            }
            $upd = $this->common->updatetbledata("tbl_party_master", $master, array(
                "id" => $s_id
            ));
        } else {
            $master['created_on'] = $cdate;
            $s_id = $this->common->insertTableData("tbl_party_master", $master);

            $upd = $this->upadtepartymaster($s_id);
        }
        /* log_message('error',"saveShipper".$this->db->last_query()."<------"); */
        return $s_id;
    }

    private function saveConsignee($input, $type)
    {
        if (isset($input['branch_code']) && $input['branch_code'] != "") {
            $branch_code = $input['branch_code'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
        }
        $master_id = "";
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            $user_id = $this->getUserId($branch_code);
        }
        $address = $input['for_addrline2'];
        $cdate = date('Y-m-d H:i:s');
        $company_code = $this->companyCode;
        $master_id = 0;
        $customer['company_code'] = $company_code;
        $customer['branch_code'] = $branch_code;
        $chktype = $this->db->select("id")
            ->order_by('created_on', 'DESC')
            ->get_where("tbl_party_types", array(
                'name' => $type,
                'company_code' => $company_code
            ));
        if ($chktype->num_rows() > 0) {
            $party_id = $chktype->row()->id;
        } else {
            $party = array(
                'name' => $type,
                'description' => $type,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'created_on' => $cdate,
                'user_id' => $user_id
            );
            $party_id = $this->common->insertTableData("tbl_party_types", $party);
        }
        $master_id = $party_id;
        $country_code = "AU";
        $year = date('y');
        $week = date('W');
        $shipper_id = $country_code . $year . $week . $master_id;
        $code = $shipper_id;
        $randnum = time();
        $email = $this->getConsigneeEmail($input['for_name']);
        $master = array(
            'party_type_id' => $party_id,
            'name' => $input['for_name'],
            'email' => $email,
            'street' => $input['for_addrline2'],
            'password' => base64_encode(base64_encode($randnum)),
            'state' => $input['for_state'],
            'mobile' => $randnum,
            'pincode' => $input['for_zipcode'],
            'country' => $input['for_country'],
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status' => '1',
            'fax' => 0,
            'address' => $address,
            'location_id' => $input['for_city']
        );
        $consignee_data = $this->Checkshipperconsi($master, $party_id);
        if (!empty($consignee_data)) {
            $c_id = trim($consignee_data['id']);
            $congi_code = $consignee_data['code'];
            if (empty($congi_code)) {
                $code = $country_code . $year . $week . $c_id;
                $master['code'] = $code;
                $master['customeridentifier'] = $code;
            }
            $upd = $this->common->updatetbledata("tbl_party_master", $master, array(
                "id" => $c_id
            ));
        } else {
            $master['created_on'] = $cdate;
            $c_id = $this->common->insertTableData("tbl_party_master", $master);

            $upd = $this->upadtepartymaster($c_id);
        }
        /* log_message('error',"saveConsignee".$this->db->last_query()."<------"); */
        return $c_id;
    }

    private function upadtepartymaster($id)
    {
        $country_code = "AU";
        $year = date('y');
        $week = date('W');
        $code = $country_code . $year . $week . $id;
        $data = array(
            'code' => $code,
            'customeridentifier' => $code
        );
        $upd = $this->common->updatetbledata("tbl_party_master", $data, array(
            "id" => $id
        ));
        return true;
    }
   
    private function getConsigneeEmail($name)
    {
        $consignee_email = '';
        $name = trim($name);
        $getconsignee = $this->common->gettblrowdata(array(
            "type" => 1,
            "consignee_name" => $name,
            "status" => 1
        ), "email", "tb_au_carrier_postalcodes", 0, 0);
        if (!empty($getconsignee)) {
            $consignee_email = $getconsignee['email'];
        }
        return $consignee_email;
    }

    private function shipperstates($shipper_state)
    {
        $data = array();
        $state = trim($shipper_state);
        $state = strtoupper($state);
        if ($state == "WA") {
            $data['street'] = "Door 385 Sheffield Road";
            $data['address'] = "Door 385 Sheffield Road Welshpool WA";
            $data['location_id'] = "Welshpool";
            $data['pincode'] = 6106;
        } else if ($state == "VIC" || $state == "TAS" || $state == "SA") {
            $data['street'] = "Door 448 Boundary Road";
            $data['address'] = "Door 448 Boundary Road Derrimut";
            $data['location_id'] = "Derrimut";
            $data['pincode'] = 3026;
        } else if ($state == "NSW" || $state == "ACT") {
            $data['street'] = "Door 312 Kangaroo Avenue";
            $data['address'] = "Door 12 Kangaroo Avenue Eastern Creek";
            $data['location_id'] = "Eastern Creek";
            $data['pincode'] = 2766;
        } else if ($state == "QLD" || $state == "NT") {
            $data['street'] = "Door 113 Buchanan Road";
            $data['address'] = "Door 113 Buchanan Road Banyo";
            $data['location_id'] = "Banyo";
            $data['pincode'] = 4014;
        } else {
            $data['street'] = "Door 448 Boundary Road";
            $data['address'] = "Door 448 Boundary Road Derrimut";
            $data['location_id'] = "Derrimut";
            $data['pincode'] = 3026;
        }
        return $data;
    }
   
    private function Checkshipperconsi($master, $id)
    {
        $company_code = $this->companyCode;
        $where = array(
            'party_type_id' => $id,
            'name' => $master['name'],
            'location_id' => $master['location_id'],
            'company_code' => $company_code,
            'branch_code' => $master['branch_code'],
            'pincode' => $master['pincode'],
            'status' => '1'
        );
        $getdata = $this->common->gettblrowdata($where, "id,code", "tbl_party_master", 0, 0);
        return $getdata;
    }

    /* This method returns User Id */
    private function getUserId($branchCode)
    {
        $userid = "";
        $getuserdata = array();
        /* Check in Users Table */

        $where = array('company_code' => $this->companyCode, 'branch_code' => $branchCode, 'status' => 'Active');
        $getuserdata = $this->common->gettblrowdata($where, "id", "tb_users", 0, 0);
        if (!empty($getuserdata)) {
            $userid = $getuserdata['id'];
        } else {
            /* Check in User Companies Table */
            $where['status'] = '1';

            $getuserdata = $this->common->gettblrowdata($where, "user_id", "tb_user_companies", 0, 0);
            if (!empty($getuserdata)) {
                $userid = $getuserdata['id'];
            } else {
                /* Insert in Users table */
                $adminrand = "eTNKN" . $branchCode;
                $adminpwd = base64_encode(base64_encode($adminrand));
                $udata = array(
                    'country_code' => $this->countryCode,
                    'name' => $branchCode . "_Admin",
                    'company_indv_name' => $this->companyCode,
                    'business_type' => 'Truck_Owner',
                    'mobile_no' => $adminrand,
                    'password' => $adminpwd,
                    'emailid' => 'svkonekt@kuehne-nagel.com',
                    'domain_name' => $branchCode,
                    'location_id' => 1646,
                    'createdby' => 1,
                    'status' => 'Active',
                    'createdon' => date('Y-m-d H:i:s'),
                    'company_code' => $this->companyCode,
                    'branch_code' => $branchCode,
                    "lat" => "40",
                    "lng" => "112"
                );
                $userid = $this->common->insertTableData('tb_users', $udata);
            }
        }
        /* log_message('error','user id query:'.$this->db->last_query().'user_id'.$userid);*/
        return $userid;
    }

    private function getHandlingUnitId($cargoType, $userId)
    {
        $resp = "";
        $handlingUnit = $this->common->gettblrowdata(array(
            "unit_name" => $cargoType
        ), "id", "tbl_shipunit_types", 0, 0);
        if (count($handlingUnit) > 0) {
            $resp = $handlingUnit['id'];
        } else {
            $insert = array(
                'unit_name' => $cargoType,
                'description' => $cargoType,
                'user_id' => $userId,
                'created_at' => date('Y-m-d H:i:s'),
                'status' => '1'
            );
            $resp = $this->common->insertTableData("tbl_shipunit_types", $insert);
        }
        return $resp;
    }

    private function getOrderTypeId()
    {
        $ordtype = 0;
        $orderType = $this->common->gettblrowdata(array(
            "type_name" => 'Air/Road'
        ), "id", "tb_order_types", 0, 0);
        if (count($orderType) > 0) {
            $ordtype = $orderType['id'];
        }
        return $ordtype;
    }

    private function getCustomerId()
    {
        $customer_id = 0;
        $where = array('country' => 'AUSTRALIA', 'company_code' => 'AUKN', 'name' => 'SUPER RETAIL GROUP');
        $where['status'] = '1';
        $customer = $this->Aureportsmodel->getcustdata($where, "id", "tb_customers", 0, 0);
        /* $customer = $this->db->query("SELECT id FROM tb_customers WHERE country LIKE '%AUSTRALIA%' AND company_code='AUKN' AND name LIKE 'SUPER%' LIMIT 1");*/
        if (!empty($customer)) {
            $customer_id = $customer['id'];
        } else {
            $customer_id = 1084;
        }
        return $customer_id;
    }

    private function getPartyType($id)
    {
        $resp = 1;
        /* $chktype = $this->db->select("party_type_id")->get_where("tbl_party_master", array(
            'id' => $id
        ));*/
        $where = array('id' => $id, 'status' => 1);
        $getdata = $this->common->gettblrowdata($where, "party_type_id", "tbl_party_master", 0, 0);

        if (!empty($getdata)) {
            $resp =  $getdata['party_type_id'];
        }
        return $resp;
    }

    private function processLine($line)
    {
        $processed = array();
        $words = preg_split('/\t/', $line);
        $processed['buyer'] = isset($words[0]) ? $words[0] : '';
        $processed['order_number'] = isset($words[1]) ? $words[1] : '';
        $processed['ship_date'] = isset($words[2]) ? $words[2] : '';
        $processed['asn_number'] = isset($words[3]) ? $words[3] : '';
        $processed['ctnr_number'] = isset($words[4]) ? $words[4] : '';
        $processed['case_store_total'] = isset($words[5]) ? $words[5] : '';
        $processed['case_id'] = isset($words[6]) ? $words[6] : '';
        $processed['job_file_number'] = isset($words[7]) ? $words[7] : '';
        $processed['case_gross_weight'] = isset($words[8]) ? $words[8] : '';
        $processed['sku_qty_ctn'] = isset($words[9]) ? $words[9] : '';
        $processed['sku_case_ratio'] = isset($words[10]) ? $words[10] : '';
        $processed['case_length'] = isset($words[11]) ? $words[11] : '';
        $processed['case_width'] = isset($words[12]) ? $words[12] : '';
        $processed['case_height'] = isset($words[13]) ? $words[13] : '';
        $processed['case_dim_uom'] = isset($words[14]) ? $words[14] : '';
        $processed['sku_number'] = isset($words[15]) ? $words[15] : '';
        $processed['sku_qty_unit'] = isset($words[16]) ? $words[16] : '';
        $processed['sku_style'] = isset($words[17]) ? $words[17] : '';
        $processed['sku_color'] = isset($words[18]) ? $words[18] : '';
        $processed['sku_size'] = isset($words[19]) ? $words[19] : '';
        $processed['sku_upc'] = isset($words[20]) ? $words[20] : '';
        $processed['sku_uom'] = isset($words[21]) ? $words[21] : '';
        $processed['sku_desc'] = isset($words[22]) ? $words[22] : '';
        $processed['sku_price'] = isset($words[23]) ? $words[23] : '';
        $processed['ship_to_pool_hub'] = isset($words[24]) ? $words[24] : '';
        $processed['custord'] = isset($words[25]) ? $words[25] : '';
        $processed['info_dept_num'] = isset($words[26]) ? $words[26] : '';
        $processed['to_id'] = isset($words[37]) ? $words[37] : '';
        $processed['for_name'] = isset($words[38]) ? $words[38] : '';
        $processed['for_addrline1'] = isset($words[39]) ? $words[39] : '';
        $processed['for_addrline2'] = isset($words[40]) ? $words[40] : '';
        $processed['proj_ref'] = isset($words[41]) ? $words[41] : '';
        $processed['pick_type'] = isset($words[42]) ? $words[42] : '';
        $processed['for_city'] = isset($words[43]) ? $words[43] : '';
        $processed['for_state'] = isset($words[44]) ? $words[44] : '';
        $processed['for_zipcode'] = isset($words[45]) ? $words[45] : '';
        $processed['for_country'] = isset($words[46]) ? $words[46] : '';
        $processed['for_id'] = isset($words[47]) ? $words[47] : '';
        $processed['ctnr_type'] = isset($words[48]) ? $words[48] : '';
        $processed['ctnr_seal_num'] = isset($words[49]) ? $words[49] : '';
        $processed['cs_name_1'] = isset($words[74]) ? $words[74] : '';
        $processed['cs_name_2'] = isset($words[75]) ? $words[75] : '';
        $processed['cs_addrline_1'] = isset($words[76]) ? $words[76] : '';
        $processed['cs_addrline_2'] = isset($words[77]) ? $words[77] : '';
        /* CS Details */
        $processed['cs_country'] = isset($words[81]) ? $words[81] : '';
        /* LP Details */
        $processed['lp_name_1'] = isset($words[82]) ? $words[82] : '';
        $processed['lp_name_2'] = isset($words[83]) ? $words[83] : '';
        $processed['lp_addrline_1'] = isset($words[84]) ? $words[84] : '';
        $processed['lp_addrline_2'] = isset($words[85]) ? $words[85] : '';
        $processed['lp_country'] = isset($words[89]) ? $words[89] : '';
        $processed['st_name_1'] = isset($words[99]) ? $words[99] : '';
        $processed['st_addrline_1'] = isset($words[100]) ? $words[100] : '';
        $processed['st_addrline_2'] = isset($words[101]) ? $words[101] : '';
        $processed['st_city'] = isset($words[102]) ? $words[102] : '';
        $processed['st_state'] = isset($words[103]) ? $words[103] : '';
        $processed['st_zipcode'] = isset($words[104]) ? $words[104] : '';
        $processed['st_country'] = isset($words[105]) ? $words[105] : '';
        $processed['comm_ref'] = isset($words[117]) ? $words[117] : '';
        $processed['ci_value'] = isset($words[118]) ? $words[118] : '';
        $processed['ci_gross_kgs'] = isset($words[119]) ? $words[119] : '';
        $processed['ci_number'] = isset($words[120]) ? $words[120] : '';
        $processed['ci_date'] = isset($words[121]) ? $words[121] : '';
        $processed['tracking_number'] = isset($words[122]) ? $words[122] : '';
        $processed['hts_1'] = isset($words[123]) ? $words[123] : '';
        /* 4000 and 4001 pin code city add*/
        if ($processed['for_zipcode'] == "4001" || $processed['for_city'] == "Brisbane" || $processed['for_zipcode'] == '4000') {
            $processed['for_zipcode'] = 4000;
            $processed['for_city'] = "Brisbane City";
        }
        /* log_message('error',"before".$processed['for_id']."<------"); */
        if (strpos($processed['for_id'], '-') !== false) {
            $for_id_arr = explode("-", $processed['for_id']);
            $processed['for_id'] = ltrim($for_id_arr[1], '0');
        }
        /* log_message('error',"after".$processed['for_id']."<---------"); */
        return $processed;
    }

    private function prepareOrders($processed)
    {
        $final = [];
        $temp = [];
        $temp2 = [];
        /* Create array based on Same State */
        for ($i = 0; $i < count($processed); $i++) {
            $temp[$processed[$i]['for_state']][] = $processed[$i];
        }
        /* Create array based Same State and Same Name */
        foreach ($temp as $key => $value) {
            for ($j = 0; $j < count($value); $j++) {
                $temp2[$key][$value[$j]['for_name']][] = $value[$j];
            }
        }
        /* Eliminate Orders with Same State and Same Name */
        $counter = 0;
        foreach ($temp2 as $value) {
            foreach ($value as $v) {
                $final[$counter] = $v[0];
                $final[$counter]['asn_numbers'][] = $v[0]['asn_number'];
                for ($i = 1; $i < count($v); $i++) {
                    $final[$counter]['tb_cargo_details_id_' . $i] = $v[$i]['tb_cargo_details_id'];
                    $final[$counter]['hidden_rows'][] = $v[$i];
                }
                $counter++;
            }
        }
        return $final;
    }

    private function findcarrier($postalcode, $input)
    {
        $postalcode1 = (int) $postalcode;
        $store_id = $input['for_id'];
        $carrier_id = 0;
        if ($postalcode1 == '4500') {
            $getcarrier = $this->common->gettblrowdata(array(
                "type" => 1,
                "postalcode" => $postalcode1,
                "status" => 1,
                "site" => $store_id
            ), "carrier,carrier_id", "tb_au_carrier_postalcodes", 0, 0);
        } else {



            $getcarrier = $this->common->gettblrowdata(array(
                "type" => 1,
                "postalcode" => $postalcode1,
                "status" => 1
            ), "carrier,carrier_id", "tb_au_carrier_postalcodes", 0, 0);
        }
        /* log_message('error',$this->db->last_query().'------------>');*/
        if (!empty($getcarrier)) {
            $carrier_name = $getcarrier['carrier'];
            if ($carrier_name == "Borders" || $carrier_name == "Bonds" || $carrier_name == "BONDS DC") {
                $carrier_id = $getcarrier['carrier_id'];
            }
        }
        /* log_message('error',' carrier_id:::'. $carrier_id.'--------------->');*/

        return $carrier_id;
    }

    public function getConsigneeNote($orderId = null, $fun_call_val = null)
    {
        $where = '';
        $where = array('consignment_note !=' => '');
        $consignment_note = 'SRGK100000';
        if ($orderId) {
            /*   $where .= ' AND order_row_id = ' . $orderId;*/
            $where['order_row_id'] = $orderId;
        }
        /*  $notes = $this->db->query("SELECT id,consignment_note FROM tb_order_details where consignment_note IS NOT NULL " . $where . " ORDER BY consignment_note DESC LIMIT 1");*/
        $notes = $this->Aureportsmodel->getsrgknum($where, "id,consignment_note", "tb_order_details", 0, 0);

        if (!empty($notes)) {
            $consignment_note = $notes['consignment_note'];
            if (!empty($consignment_note)) {
                if ($fun_call_val != 1) {
                    $consignment_note = 'SRGK' . ((int) substr($consignment_note, strpos($consignment_note, 'K') + 1) + 1);
                }
            } else {
                $consignment_note = 'SRGK100000';
            }
        }
        return $consignment_note;
    }

    private function getBranchcode($for_state)
    {
        $branchCode = "AUVIC";
        if ($for_state != "") {
            $state = trim($for_state);
            $state = strtoupper($state);
            if ($state == "WA") {
                $branchCode = "AUWA";
            } else if ($state == "VIC" || $state == "TAS" || $state == "SA") {
                $branchCode = "AUVIC";
            } else if ($state == "NSW" || $state == "ACT") {
                $branchCode = "AUNSW";
            } else if ($state == "QLD" || $state == "NT") {
                $branchCode = "AUQLD";
            } else {
                $branchCode = "AUVIC";
            }
        }
        return $branchCode;
    }

    private function edilogtransactions($data)
    {
        $get_ins_id = $edi_id = 0;
        $edi_name = "";
        $get_response = array();
        if (!empty($data)) {
            $branch_code = $user_id = "";
            if (!empty($data['container_num'])) {
                $container_whr = array('r.ref_value' => $data['container_num']);
                $get_asn_data = $this->Aureportsmodel->getcontainerinfo($container_whr);
                /*  log_message('error', "getcontainerinfo" . $this->db->last_query()); */
                if (!empty($get_asn_data)) {
                    $user_id = $get_asn_data['user_id'];
                    $branch_code = $get_asn_data['branch_code'];
                }


                $whr = array('o.company_code' => 'AUKN', 'r.ref_value' => $data['container_num'], 'o.status !=' => 0);
                /* container order details */
                $get_response = $this->Aureportsmodel->getorderinfo($whr);
                /* if(!empty($data['file_name'])){
                    $get_response['file_name']=$data['file_name'];
                } */
                /* log_message('error', "getcontainerinfo" . $this->db->last_query()); */

                /*
                * Get edi_name from tb_edi_types table if edi name is not exists insert edi name
                */
                $edi_name = $data['container_status'];
                $edi_result = $this->common->gettblrowdata(
                    array('status' => '1', 'edi_name' => $edi_name),
                    'id,edi_name',
                    'tb_edi_types',
                    0,
                    0
                );
                if ((!empty($edi_result))) {
                    $edi_name = $edi_result['edi_name'];
                    $edi_id = $edi_result['id'];
                } else {
                    $ins_edi['edi_name'] = $edi_name;
                    $edi_id = $this->common->insertTableData('tb_edi_types', $ins_edi);
                }
            }
            /*
         * Get edi object from tb_edi_object_types table if edi object is not exists insert edi object
         */
            $object_id = 0;
            $obj_type_name = "Container-Number";
            $edi_obj_result = $this->common->gettblrowdata(array('status' => '1', 'obj_type_name' => $obj_type_name), 'id,obj_type_name', 'tb_edi_object_types', 0, 0);

            if (!empty($edi_obj_result)) {
                $object_id = $edi_obj_result['id'];
            } else {
                $ins_obj_edi['obj_type_name'] = $obj_type_name;
                $ins_obj_edi['description'] = "bounds carrier Status types";
                $object_id = $this->common->insertTableData('tb_edi_object_types', $ins_obj_edi);
            }



            $sts = isset($data['status']) ? ($data['status']) : 0;
            $params = array(
                'edi_type' => 1, // '1->EDI Transport Order,2->EDI Status'
                'transaction_id' => time(),
                'edi_id' => isset($edi_id) ? $edi_id : 0, // edi id based on name take it from tb_edi_types
                'edi_name' => isset($edi_name) ? $edi_name : "ASN",
                'bounded_type' => 1, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
                'edi_format_type' => 'Text',
                'status' => isset($sts) ? $sts : "0",
                'obj_type' => isset($object_id) ? $object_id : "0",
                'txn_obj_id' => isset($data['container_num']) ? $data['container_num'] : "0",
                'ref_value' => isset($data['container_num']) ? $data['container_num'] : "0",
                /*'txn_obj_id' => isset($data['job_id'])?$data['job_id']:0,*/
                'user_id' => $user_id,
                'company_code' => "AUKN",
                'branch_code' => $branch_code,
                'edi_request' => isset($data['file_name']) ? $data['file_name'] : 'xml',
                'edi_response' => isset($get_response) ? json_encode($get_response) : "xml"
            );
            $get_ins_id = $this->common->insertTableData('tb_etn_edi_transactions', $params);
            /* log_message('error', "transaction data" . json_encode($params)); */
        }
        return $get_ins_id;
    }
}
