<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * This class processes Australia CAS EDI
 *
 * @deprecated
 */
class Auscasnedi extends CI_Controller
{

    /**
     * Class Variables
     */
    private $branchcode = '';

    private $companyCode = '';

    private $countryCode = '';

    private $userId = '';

    private $case_id_unique = array();

    private $parent_array = array();

    private $tb_cargo_details_id = "";

    private $order_ref_num = array();

    private $ref_connote_arr = array();

    /**
     * Class Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->companyCode = 'AUKN';
        $this->countryCode = substr($this->companyCode, 0, 2);
        $this->userId = "";
    }

    /**
     * This method processes the Australia CASN EDI file
     */
    public function index()
    {
        ini_set("post_max_size", 0);
        ini_set("upload_max_filesize", "100M");
        ini_set("max_input_time", 6000);
        ini_set("memory_limit", "1024M");
        ini_set("max_execution_time", 6000);
        $processed = [];
        $fileContent = file_get_contents("php://input");
        /*$fileContent = $this->input->post('asn');*/
        try {
            $file = './assets/temp.txt';
            file_put_contents($file, '');
            $handle = fopen($file, 'w');
            fwrite($handle, $fileContent);
            $handle = fopen($file, 'r');
            /*log_message("error","handle ".json_encode($handle));*/
            if ($handle) {
                while (($line = fgets($handle)) !== false) {
                    $processedchk = $this->processLine($line);
                    if (! empty($processedchk)) {
                        $processed[] = $processedchk;
                    }
                }
            } else {
                echo 'Unable to access file!!!';
                exit();
            }
            fclose($handle);
            $orders = [];
            $brnchcode = $uid = $handling_unit = "";
            $iMax = count($processed);
            for ($i = 0; $i < $iMax; $i ++) {
                /* Insert Cargo Details */
                if ($brnchcode == "") {
                    $processrecord = $processed[$i];
                    $cargdetid = $this->insertCargoDetails($processed[$i]);
                    if (! empty($cargdetid)) {
                        $brnchcode = $cargdetid["branch_code"];
                        $uid = $cargdetid["user_id"];
                        $handling_unit = $cargdetid["handling_unit"];
                    }
                } else {
                    $processrecord = $processed[$i];
                    $processrecord['branch_code'] = $brnchcode;
                    $processrecord['user_id'] = $uid;
                    $processrecord['handling_unit'] = $handling_unit;
                    $cargdetid = $this->insertCargoDetails($processrecord);
                }
                if (! empty($cargdetid)) {
                    $processed[$i]['tb_cargo_details_id'] = $cargdetid['id'];
                }
            }
            if ($brnchcode != "" && $uid != "") {
                $orders = $this->prepareOrders($processed);
                if (! empty($orders)) {
                    $customer_id = $this->getCustomerId();
                    $order_type = $this->getOrderTypeId();
                    /* $consignment_note = $this->getConsigneeNote(); */
                    $jMax = count($orders);
                    for ($j = 0; $j < $jMax; $j ++) {
                        /* Insert Shipments */
                        $orders[$j]['branch_code'] = $brnchcode;
                        $orders[$j]['user_id'] = $uid;
                        $orders[$j]['handling_unit'] = $handling_unit;
                        $orders[$j]['customer_id'] = $customer_id;
                        $orders[$j]['order_type'] = $order_type;
                        $orders[$j]['tb_shipments_id'] = $this->insertShipments($orders[$j]);
                        /* Insert Shipping */
                        $orders[$j]['pickup_partyid'] = $this->saveShipper($orders[$j], 'Shipper');
                        $orders[$j]['drop_partyid'] = $this->saveConsignee($orders[$j], 'Consignee');
                        /* find carrier */
                        $orders[$j]['vendor_id'] = 0;
                        $consignee_postalcode = $orders[$j]['for_zipcode'];
                        if ($consignee_postalcode != "" && $consignee_postalcode > 0) {
                            $orders[$j]['vendor_id'] = $this->findcarrier($consignee_postalcode,$orders[$j]);
                        }
                        /* Insert or Update Orders */
                        $orders[$j]['tb_orders_id'] = $this->insertOrder($orders[$j]);
                        /* Update Orders */
                        $orders[$j]['order_num'] = $this->updateorder($orders[$j]);
                        /* Insert Order Parties */
                        $orders[$j]['tb_order_parties_id'] = $this->insertOrderParties($orders[$j]);
                        /* Insert or Update Order Details */
                        $orders[$j]['tb_order_details_id'] = $this->insertOrderDetails($orders[$j]);
                        /* Insert Order References */
                        $orders[$j]['tb_order_ref_ids'] = $this->insertOrderReferences($orders[$j]);
                        /* Inserting Order Cargo Details */
                        $orders[$j]['tb_order_cargodetails_id'] = $this->checkCaseId($orders[$j]);
                        
                        if (isset($orders[$j]['hidden_rows'])) {
                            $countHiddenRows = count($orders[$j]['hidden_rows']);
                            for ($k = 0; $k < $countHiddenRows; $k ++) {
                                $orders[$j]['hidden_rows'][$k]['tb_orders_id'] = $orders[$j]['tb_orders_id'];
                                $orders[$j]['hidden_rows'][$k]['tb_order_cargodetails_id'] = $this->checkCaseId($orders[$j]['hidden_rows'][$k]);
                            }
                        }
                        /* Update Orders */
                        $upd = $this->updateCargodetails($orders[$j]);
                    }
                }
            }
            echo 'Successfully Processed!!!!!';
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    // ************************************
    // *** Data Insertion Functions *******
    // ************************************
    /**
     * This method inserts cargo details
     *
     * @param array $input
     */
    private function insertCargoDetails($input)
    {
        $response = array();
        $insert = [];
        if (isset($input['branch_code'])) {
            $branch_code = $input['branch_code'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
        }
        if (isset($input['user_id'])) {
            $User_Id = $input['user_id'];
        } else {
            $User_Id = $this->getUserId($branch_code);
        }
        $response['branch_code'] = $branch_code;
        $response['user_id'] = $User_Id;
        $insert['cargo_type'] = 'CARTON';
        $insert['cargotype_id'] = 0;
        if (isset($input['handling_unit'])) {
            $insert['handling_unit'] = $input['handling_unit'];
        } else {
            $insert['handling_unit'] = $this->getHandlingUnitId('CARTON', $User_Id);
        }
        $response['handling_unit'] = $insert['handling_unit'];
        $insert['handlingunit_id'] = 0;
        $insert['length'] = ! empty($input['case_length']) ? $input['case_length'] : '';
        $insert['length_unit'] = '';
        $insert['width'] = ! empty($input['case_width']) ? $input['case_width'] : '';
        $insert['width_unit'] = '';
        $insert['height'] = $input['case_height'];
        $insert['height_unit'] = '';
        $insert['weight'] = $input['case_gross_weight'];
        $insert['volumetric_weight'] = 0;
        $insert['volweight_uom'] = 0;
        $insert['ldm'] = null;
        $insert['weight_unit'] = '';
        $insert['volume'] = ! empty($input['case_dim_uom']) ? $input['case_dim_uom'] : '';
        $insert['volume_unit'] = null;
        $insert['quantity'] = $input['sku_qty_unit'];
        $insert['goods_description'] = $input['sku_desc'];
        $insert['status'] = 1;
        $insert['stackable'] = 0;
        $insert['grounded'] = 0;
        $insert['splittable'] = 0;
        $insert['dg_goods'] = 0;
        $insert['createdby'] = $User_Id;
        $insert['updatedby'] = null;
        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
        $response['id'] = $this->common->insertTableData('tb_cargo_details', $insert);
        return $response;
    }

    /**
     * This method inserts shipments
     *
     * @param array $input
     * @return int
     */
    private function insertShipments($input)
    {
        $resp = "";
        $insert = [];
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            if (isset($input['branch_code']) && $input['branch_code'] != "") {
                $branch_code = $input['branch_code'];
            } else {
                $branch_code = $this->getBranchcode($input['for_state']);
            }
            $user_id = $this->getUserId($branch_code);
        }
        $insert['pickupcnt'] = 1;
        $insert['shipid'] = $input['ctnr_number'];
        $insert['dropcnt'] = 1;
        if (isset($input['handling_unit']) && $input['handling_unit'] != "") {
            $insert['unitspec'] = $input['handling_unit'];
        } else {
            $insert['unitspec'] = $this->getHandlingUnitId('CARTON', $user_id);
        }
        $insert['reason'] = $input['sku_desc'];
        $insert['ship_object'] = $input['sku_desc'];
        $insert['transport_mode'] = $input['pick_type'];
        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
        $resp = $this->common->insertTableData('tb_shipments', $insert);
        return $resp;
    }

    /**
     * This method creates order
     *
     * @param array $input
     * @return int
     */
    private function insertOrder($input)
    {
        try {
            /* log_message('error', "conginee state::" . $input['for_state'] . "::-->conginee name::" . $input['for_name'] . "::-->ASN order num::" . $input['order_number']) . "<--"; */
            $insert = [];
            // $insert['order_id'] = $input['order_number'];
            $insert['order_id'] = 0;
            if (isset($input['branch_code']) && $input['branch_code'] != "") {
                $branch_code = $input['branch_code'];
            } else {
                $branch_code = $this->getBranchcode($input['for_state']);
            }
            if (isset($input['user_id']) && $input['user_id'] != "") {
                $user_id = $input['user_id'];
            } else {
                $user_id = $this->getUserId($branch_code);
            }
            // Pick Up
            $shipper_data = $this->getShipperAddress($input['for_state']);
            $insert['pickup_company'] = "Kuehne Nagel";
            $insert['pickup_country'] = "AU";
            $insert['pickup_address2'] = $input['for_state'];
            if (! empty($shipper_data)) {
                $insert['pickup_city'] = $shipper_data['location_id'];
                $insert['pickup_pincode'] = $shipper_data['pincode'];
                $insert['pickup_address1'] = $shipper_data['address'];
            }

            // Delivery
            $insert['delivery_company'] = $input['for_name'];
            $insert['delivery_country'] = $input['for_country'];
            $insert['delivery_city'] = $input['for_city'];
            $insert['delivery_pincode'] = $input['for_zipcode'];
            $insert['delivery_address1'] = $input['for_addrline2'];
            $insert['delivery_address2'] = $input['for_state'];
            // vender id
            $insert['vendor_id'] = $input['vendor_id'];
            $insert['user_id'] = $user_id;
            if (isset($input['customer_id'])) {
                $insert['customer_id'] = $input['customer_id'];
            } else {
                $insert['customer_id'] = $this->getCustomerId();
            }
            $insert['product'] = 'KN AsiaLink';
            $insert['quantity'] = null;
            $insert['transport_mode'] = 'LTL';
            $insert['shipment_id'] = $input['tb_shipments_id'];
            $insert['created_source'] = 14;
            $insert['company_code'] = $this->companyCode;
            $insert['branch_code'] = $branch_code;
            $insert['drop_partyid'] = $input['drop_partyid'];
            $insert['pickup_partyid'] = $input['pickup_partyid'];
            $insert['created_source'] = 14;
            $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');

            return $this->common->insertTableData('tb_orders', $insert);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /* booking id update in orders */
    public function updateorder($input)
    {
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
            $user_id = $this->getUserId($branch_code);
        }
        $genord = array(
            "user_id" => $user_id,
            "order_id" => $input['tb_orders_id'],
            "country_code" => $this->countryCode,
            "company_code" => $this->companyCode
        );
        $booking_id = generatebookingid($genord);
        $upd = $this->db->where(array(
            'id' => $input['tb_orders_id']
        ))->update("tb_orders", array(
            'order_id' => $booking_id
        ));
        return $booking_id;
    }

    /* insert tb_order_parties */
    private function insertOrderParties($input)
    {
        try {
            $curdt = date('Y-m-d H:i:s');
            $orderPartiesOne = [];
            $orderPartiesTwo = [];
            // Reference - 1
            $orderPartiesOne['order_id'] = $input['tb_orders_id'];
            $orderPartiesOne['order_number'] = $input['order_num'];
            $orderPartiesOne['party_id'] = $input['pickup_partyid'];
            $orderPartiesOne['party_type'] = $this->getPartyType($input['pickup_partyid']);
            $orderPartiesOne['createdon'] = $orderPartiesOne['updatedon'] = $curdt;
            $ids[] = $this->common->insertTableData('tb_order_parties', $orderPartiesOne);
            // Reference - 2
            $orderPartiesTwo['order_id'] = $input['tb_orders_id'];
            $orderPartiesTwo['order_number'] = $input['order_num'];
            $orderPartiesTwo['party_id'] = $input['drop_partyid'];
            $orderPartiesTwo['party_type'] = $this->getPartyType($input['drop_partyid']);
            $orderPartiesTwo['createdon'] = $orderPartiesTwo['updatedon'] = $curdt;
            $ids[] = $this->common->insertTableData('tb_order_parties', $orderPartiesTwo);
            return implode(",", $ids);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * This method creates order details
     *
     * @param array $input
     * @return int
     */
    private function insertOrderDetails($input)
    {
        $insert = [];
        $insert['order_row_id'] = $input['tb_orders_id'];
        $insert['order_id'] = $input['order_num'];
        $insert['goods_description'] = $input['sku_desc'];
        $insert['revenue_currency'] = 'USD';
        $insert['department_code'] = 'CTP';
        $insert['order_type'] = $input['order_type'];
        $insert['consignment_note'] = $this->getConsigneeNote();
        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
        $orddet = $this->common->insertTableData('tb_order_details', $insert);
        return $orddet;
    }

    /**
     * This method inserts Order References
     *
     * @param array $input
     * @return string
     */
    private function insertOrderReferences($input)
    {
        /* Reference - 1 */
        $curdt = date('Y-m-d H:i:s');
        $consingee_note = $this->getConsigneeNote($input['tb_orders_id'], 1);
        $reference3['order_id'] = $input['tb_orders_id'];

        /* $reference3['reference_id'] = 'COI'; */
        $reference3['reference_id'] = 'DQ';
        $reference3['ref_value'] = $consingee_note;
        $reference3['createdon'] = $reference3['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference3);
        /* Reference - 2 */
        $reference7['order_id'] = $input['tb_orders_id'];
        $reference7['reference_id'] = 'CTR';
        $reference7['ref_value'] = $input['ctnr_number'];
        $reference7['createdon'] = $reference7['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference7);
        /* Reference - 3 */

        $store_id = $input['for_id'];
        $reference8['order_id'] = $input['tb_orders_id'];
        $reference8['reference_id'] = 'COI';
        $reference8['ref_value'] = $store_id;
        $reference8['createdon'] = $reference8['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference8);

          /* job file reference insertion*/
        $reference4['order_id'] = $input['tb_orders_id'];
        $reference4['reference_id'] = 'POS';
        $reference4['ref_value'] = $input['job_file_number'];
        $reference4['createdon'] = $reference4['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $reference4);

        return implode(",", $ids);
    }

    /**
     * This method before check case ID in insert Order Cargo Details
     *
     * @param array $input
     * @return int
     */
    private function checkCaseId($input)
    {
        $insert_id = 0;
        if (! empty($input)) {
            if (! in_array($input['case_id'], $this->case_id_unique)) {
                $this->case_id_unique[] = $input['case_id'];
                $this->tb_cargo_details_id = $input['tb_cargo_details_id'];
                $ins = $this->insertOrderCargoDetails($input);
                $refins = $this->insertRefConnote($input);
            }
            /* ASN order reference number check */
            if (! in_array($input['order_number'], $this->order_ref_num)) {
                $this->order_ref_num[] = $input['order_number'];
                $ins = $this->insertRefAsnOrderId($input);
            }
            $input['tb_cargo_details_id'] = $this->tb_cargo_details_id;
            $insert_id = $this->insertInnerCargoDetails($input);
        }
        return $insert_id;
    }

    /**
     * This method inserts Order Cargo Details
     *
     * @param array $input
     * @return int
     */
    private function insertOrderCargoDetails($input)
    {
        $insert = [];
        $insert['order_id'] = $input['tb_orders_id'];
        $insert['cargo_id'] = $input['tb_cargo_details_id'];
        $insert['handling_unit'] = $input['sku_case_ratio'];
        $insert['length'] = $input['case_length'];
        $insert['width'] = $input['case_width'];
        $insert['height'] = $input['case_height'];
        $insert['weight'] = $input['case_gross_weight'];
        $insert['volumetric_weight'] = 0;
        $insert['volweight_uom'] = 0;
        $insert['ldm'] = 0;
        $insert['volume'] = $input['case_dim_uom'];
        $insert['quantity'] = 1;
        $insert['quantity_type'] = null;
        $insert['cargo_content'] = null;
        $insert['buyer_part'] = null;
        $insert['stop_detail_id'] = null;
        $insert['qr_code'] = $input['case_id'];
        $insert['status'] = 1;
        $insert['createdon'] = date('Y-m-d H:i:s');
        $lpc = $this->getConnote($input);
        if (! empty($lpc)) {
            $insert['load_plan_connote'] = $lpc;
        }
        $insid = $this->common->insertTableData('tb_order_cargodetails', $insert);
        return $insid;
    }

    /**
     * This method inserts Inner Cargo Details
     *
     * @param array $input
     * @return int
     */
    private function insertInnerCargoDetails($input)
    {
        $insert = [];
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $User_Id = $input['user_id'];
        } else {
            if (isset($input['branch_code']) && $input['branch_code'] != "") {
                $branch_code = $input['branch_code'];
            } else {
                $branch_code = $this->getBranchcode($input['for_state']);
            }
            $User_Id = $this->getUserId($branch_code);
        }
        $curdt = date('Y-m-d H:i:s');
        $insert['cargo_id'] = $input['tb_cargo_details_id'];
        $insert['cargo_type'] = 'CARTON';
        $insert['goods_description'] = $input['sku_desc'];
        $insert['quantity'] = $input['sku_qty_unit'];
        $insert['length'] = ! empty($input['case_length']) ? $input['case_length'] : '';
        $insert['length_unit'] = 'cm';
        $insert['width'] = $input['case_width'];
        $insert['width_unit'] = 'cm';
        $insert['height'] = $input['case_height'];
        $insert['height_unit'] = 'cm';
        $insert['weight'] = $input['case_gross_weight'];
        $insert['weight_unit'] = 'Kg';
        $insert['volume'] = ! empty($input['case_dim_uom']) ? $input['case_dim_uom'] : '';
        $insert['volume_unit'] = null;
        $insert['stackable'] = 0;
        $insert['status'] = 1;
        $insert['createdby'] = $User_Id;
        $insert['createdon'] = $insert['updatedon'] = $curdt;
        $insert['ref_order_num'] = $input['order_number'];
        $insid = $this->common->insertTableData('tb_inner_cargo', $insert);
        return $insid;
    }

    /**
     * This method inserts IinsertRefAsnOrderId
     *
     * @param array $input
     * @return int
     */
    private function insertRefAsnOrderId($input)
    {
        $curdt = date('Y-m-d H:i:s');
        $insert = [];
        $insert['order_id'] = $input['tb_orders_id'];
        $insert['reference_id'] = 'PO';
        $insert['ref_value'] = $input['order_number'];
        $insert['createdon'] = $insert['updatedon'] = $curdt;
        $ids[] = $this->common->insertTableData('tb_order_references', $insert);
        return $ids;
    }

    /**
     * This method inserts insertRefConnote
     *
     * @param array $input
     * @return int
     */
    private function getConnote($input)
    {
        $first = isset($input['asn_number']) ? $input['asn_number'] : "";
        $second = isset($input['sku_color']) ? $input['sku_color'] : "";
        $lpc = "";
        if ($first != "" && $second != "") {
            $split_first = explode('-', $first);
            if (! empty($split_first)) {
                $split1 = isset($split_first[1]) ? $split_first[1] : "";
                if ($split1 == "") {
                    $split1 = "SRG";
                }
                $split2 = isset($split_first[2]) ? $split_first[2] : "";
                $last_split2 = substr($split2, - 4);
                $last_sku_color = substr($second, - 5);
                $store_id = $input['for_id'];
                $lpc = $split1 . "-" . $store_id . "-" . $last_sku_color;
            }
        }
        return $lpc;
    }

    private function insertRefConnote($input)
    {
        $curdt = date('Y-m-d H:i:s');
        $lpc = $this->getConnote($input);
        if ($lpc != "") {
            if (! in_array($lpc, $this->ref_connote_arr)) {
                $this->ref_connote_arr[] = $lpc;
                $reference6['reference_id'] = 'LPC';
                $reference6['order_id'] = $input['tb_orders_id'];
                $reference6['ref_value'] = $lpc;
                $reference6['createdon'] = $reference6['updatedon'] = $curdt;
                $ids[] = $this->common->insertTableData('tb_order_references', $reference6);
            }
        }
    }

    /* order update in cargo details */
    public function updateCargodetails($input)
    {
        $cargo_data = $this->common->gettblrowdata(array(
            'order_id' => $input['tb_orders_id']
        ), 'SUM(IFNULL(quantity,0)) as quantity,SUM(IFNULL(weight,0)) as weight,SUM(IFNULL(volume,0)) as volume', 'tb_order_cargodetails', 0, 0);
        $quantity = $weight = $volume = 0;
        if (! empty($cargo_data)) {
            $getdata = array(
                "quantity" => $cargo_data['quantity'],
                "weight" => $cargo_data['weight'],
                "volume" => $cargo_data['volume']
            );
            $upd = $this->common->updatetbledata("tb_orders", $getdata, array(
                'id' => $input['tb_orders_id']
            ));
        }
    }

    /* GET total quantity,weight,volume in cargo details */
    /*
     * private function getcargosWVQ($id){
     * $resp = array();
     * $cargo_data=$this->common->gettbldata(array('order_id'=>$id),'quantity,weight,volume','tb_order_cargodetails',0,0);
     * $quantity=$weight=$volume=0;
     * if(!empty($cargo_data)){
     * foreach($cargo_data as $res){
     * $quantity +=(float)$res['quantity'];
     * $weight +=(float)$res['weight'];
     * $volume += (float)$res['volume'];
     * }
     * $volume=number_format($volume, 5, '.', '');
     * }
     * $resp=array("quantity"=>$quantity,"weight"=>$weight,"volume"=>$volume);
     * return $resp;
     * }
     */
    /**
     * This method saves Shiper address
     *
     * @param array $input
     * @param string $type
     * @return int
     */
    private function saveShipper($input, $type)
    {
        if (isset($input['branch_code']) && $input['branch_code'] != "") {
            $branch_code = $input['branch_code'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
        }
        $master_id = "";
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            $user_id = $this->getUserId($branch_code);
        }
        $address = $input['for_addrline1'] . ',' . $input['for_addrline2'] . ',' . $input['for_city'];
        $cdate = date('Y-m-d H:i:s');
        $company_code = $this->companyCode;
        $master_id = 0;
        $customer['company_code'] = $company_code;
        $customer['branch_code'] = $branch_code;
        $chktype = $this->db->select("id")
            ->order_by('created_on', 'DESC')
            ->get_where("tbl_party_types", array(
            'name' => $type,
            'company_code' => $company_code,
            "status" => 1
        ), 1, 0);
        if ($chktype->num_rows() > 0) {
            $party_id = $chktype->row()->id;
        } else {
            $party = array(
                'name' => $type,
                'description' => $type,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'created_on' => $cdate,
                'user_id' => $user_id
            );
            $party_id = $this->common->insertTableData("tbl_party_types", $party);
        }
        $master_id = $party_id;
        $country_code = "AU";
        $year = date('y');
        $week = date('W');
        $shipper_id = $country_code . $year . $week . $master_id;
        $code = $shipper_id;
        $randnum = time();
        $master = array(
            'party_type_id' => $party_id,
            'name' => "Kuehne Nagel",
            'email' => '',
            'password' => base64_encode(base64_encode($randnum)),
            'state' => $input['for_state'],
            'mobile' => 0,
            'country' => "AU",
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status' => '1',
            'fax' => 0
        );
        /* conginee state check */
        $consi_data = $this->getShipperAddress($input['for_state']);
        if (! empty($consi_data)) {
            $master = array_merge($master, $consi_data);
        }
        $shipper_data = $this->Checkshipperconsi($master, $party_id);
        if (! empty($shipper_data)) {
            $s_id = $shipper_data['id'];
            $ship_code = $shipper_data['code'];
            if (empty($ship_code)) {
                $code = $country_code . $year . $week . $s_id;
                $master['code'] = $code;
                $master['customeridentifier'] = $code;
            }
            $upd = $this->common->updatetbledata("tbl_party_master", $master, array(
                "id" => $s_id
            ));
        } else {
            $master['created_on'] = $cdate;
            $s_id = $this->common->insertTableData("tbl_party_master", $master);

            $upd = $this->upadtepartymaster($s_id);
        }
        /* log_message('error',"saveShipper".$this->db->last_query()."<------"); */
        return $s_id;
    }

    /**
     * This method saves Consignee address
     *
     * @param array $input
     * @param string $type
     * @return int
     */
    private function saveConsignee($input, $type)
    {
        if (isset($input['branch_code']) && $input['branch_code'] != "") {
            $branch_code = $input['branch_code'];
        } else {
            $branch_code = $this->getBranchcode($input['for_state']);
        }
        $master_id = "";
        if (isset($input['user_id']) && $input['user_id'] != "") {
            $user_id = $input['user_id'];
        } else {
            $user_id = $this->getUserId($branch_code);
        }
        $address = $input['for_addrline2'];
        $cdate = date('Y-m-d H:i:s');
        $company_code = $this->companyCode;
        $master_id = 0;
        $customer['company_code'] = $company_code;
        $customer['branch_code'] = $branch_code;
        $chktype = $this->db->select("id")
            ->order_by('created_on', 'DESC')
            ->get_where("tbl_party_types", array(
            'name' => $type,
            'company_code' => $company_code
        ));
        if ($chktype->num_rows() > 0) {
            $party_id = $chktype->row()->id;
        } else {
            $party = array(
                'name' => $type,
                'description' => $type,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'created_on' => $cdate,
                'user_id' => $user_id
            );
            $party_id = $this->common->insertTableData("tbl_party_types", $party);
        }
        $master_id = $party_id;
        $country_code = "AU";
        $year = date('y');
        $week = date('W');
        $shipper_id = $country_code . $year . $week . $master_id;
        $code = $shipper_id;
        $randnum = time();
        $email = $this->getConsigneeEmail($input['for_name']);
        $master = array(
            'party_type_id' => $party_id,
            'name' => $input['for_name'],
            'email' => $email,
            'street' => $input['for_addrline2'],
            'password' => base64_encode(base64_encode($randnum)),
            'state' => $input['for_state'],
            'mobile' => $randnum,
            'pincode' => $input['for_zipcode'],
            'country' => $input['for_country'],
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status' => '1',
            'fax' => 0,
            'address' => $address,
            'location_id' => $input['for_city']
        );
        $consignee_data = $this->Checkshipperconsi($master, $party_id);
        if (! empty($consignee_data)) {
            $c_id = trim($consignee_data['id']);
            $congi_code = $consignee_data['code'];
            if (empty($congi_code)) {
                $code = $country_code . $year . $week . $c_id;
                $master['code'] = $code;
                $master['customeridentifier'] = $code;
            }
            $upd = $this->common->updatetbledata("tbl_party_master", $master, array(
                "id" => $c_id
            ));
        } else {
            $master['created_on'] = $cdate;
            $c_id = $this->common->insertTableData("tbl_party_master", $master);

            $upd = $this->upadtepartymaster($c_id);
        }
        /* log_message('error',"saveConsignee".$this->db->last_query()."<------"); */
        return $c_id;
    }

    /* shipper and conginee code update function */
    private function upadtepartymaster($id)
    {
        $country_code = "AU";
        $year = date('y');
        $week = date('W');
        $code = $country_code . $year . $week . $id;
        $data = array(
            'code' => $code,
            'customeridentifier' => $code
        );
        $upd = $this->common->updatetbledata("tbl_party_master", $data, array(
            "id" => $id
        ));
        return true;
    }

    private function getConsigneeEmail($name)
    {
        $consignee_email = '';
        $name = trim($name);
        $getconsignee = $this->common->gettblrowdata(array(
            "type" => 1,
            "consignee_name" => $name,
            "status" => 1
        ), "email", "tb_au_carrier_postalcodes", 0, 0);
        if (! empty($getconsignee)) {
            $consignee_email = $getconsignee['email'];
        }
        return $consignee_email;
    }

    private function getShipperAddress(string $state): array
    {
        $state = trim($state);
        $pickupData = $this->common->gettblrowdata(
            ['stateName' => $state, 'status' => 1],
            "street, address, location_id, pincode",
            "tb_au_pickup_address",
            0,
            0
        );
        if (empty($pickupData)) {
            $pickupData = $this->common->gettblrowdata(
                ['stateName' => 'VIC', 'status' => 1],
                "street, address, location_id, pincode",
                "tb_au_pickup_address",
                0,
                0
            );
        }
        if (empty($pickupData)) {
            return ['street' => '', 'location_id' => '', 'pincode' => '', 'address' => ''];
        }
        return $pickupData;
    }

    private function Checkshipperconsi($master, $id)
    {
        $company_code = $this->companyCode;
        $where = array(
            'party_type_id' => $id,
            'name' => $master['name'],
            'location_id' => $master['location_id'],
            'company_code' => $company_code,
            'branch_code' => $master['branch_code'],
            'pincode' => $master['pincode'],
            'status' => '1'
        );
        $getdata = $this->common->gettblrowdata($where, "id,code", "tbl_party_master", 0, 0);
        return $getdata;
    }

    /* This method returns User Id */
    private function getUserId($branchCode)
    {
        $userid = "";
        /* Check in Users Table */
        $user = $this->db->query(
            "SELECT id
                FROM tb_users
                WHERE company_code= ? AND branch_code= ? AND status='Active'
                LIMIT 1",
            [$this->companyCode, $branchCode]
        );

        if ($user->num_rows() > 0) {
            $userid = $user->row()->id;
        } else {
            /* Check in User Companies Table */
            $user = $this->db->query(
                "SELECT user_id
                    FROM tb_user_companies
                    WHERE company_code= ? AND branch_code= ? AND status=1
                    LIMIT 1",
                [$this->companyCode, $branchCode]
            );

            if ($user->num_rows() > 0) {
                $userid = $user->row()->id;
            } else {
                /* Insert in Users table */
                $adminrand = "eTNKN" . $branchCode;
                $adminpwd = base64_encode(base64_encode($adminrand));
                $udata = array(
                    'country_code' => $this->countryCode,
                    'name' => $branchCode . "_Admin",
                    'company_indv_name' => $this->companyCode,
                    'business_type' => 'Truck_Owner',
                    'mobile_no' => $adminrand,
                    'password' => $adminpwd,
                    'emailid' => 'svkonekt@kuehne-nagel.com',
                    'domain_name' => $branchCode,
                    'location_id' => 1646,
                    'createdby' => 1,
                    'status' => 'Active',
                    'createdon' => date('Y-m-d H:i:s'),
                    'company_code' => $this->companyCode,
                    'branch_code' => $branchCode,
                    "lat" => "40",
                    "lng" => "112"
                );
                $userid = $this->common->insertTableData('tb_users', $udata);
            }
        }
        return $userid;
    }

    /**
     * This method returns HandlingUnit Id
     *
     * @param string $cargoType
     * @return int
     */
    private function getHandlingUnitId($cargoType, $userId)
    {
        $resp = "";
        $handlingUnit = $this->common->gettblrowdata(array(
            "unit_name" => $cargoType
        ), "id", "tbl_shipunit_types", 0, 0);
        if (count($handlingUnit) > 0) {
            $resp = $handlingUnit['id'];
        } else {
            $insert = array(
                'unit_name' => $cargoType,
                'description' => $cargoType,
                'user_id' => $userId,
                'created_at' => date('Y-m-d H:i:s'),
                'status' => '1'
            );
            $resp = $this->common->insertTableData("tbl_shipunit_types", $insert);
        }
        return $resp;
    }

    /**
     * This method returns Booking Type Id
     *
     * @return int
     */
    private function getOrderTypeId()
    {
        $ordtype = 0;
        $orderType = $this->common->gettblrowdata(array(
            "type_name" => 'Air/Road'
        ), "id", "tb_order_types", 0, 0);
        if (count($orderType) > 0) {
            $ordtype = $orderType['id'];
        }
        return $ordtype;
    }

    /**
     * This method returns customer id
     *
     * @return int|number
     */
    private function getCustomerId()
    {
        $customer = $this->db->query("SELECT id
            FROM tb_customers
            WHERE country LIKE '%AUSTRALIA%' AND company_code='AUKN' AND name LIKE 'SUPER%'
            LIMIT 1");

        return $customer->num_rows() > 0 ? $customer->row()->id : 465;
    }

    /**
     * This method returns party type id
     *
     * @param int $id
     * @return int
     */
    private function getPartyType($id)
    {
        $resp = 1;
        $chktype = $this->db->select("party_type_id")->get_where("tbl_party_master", array(
            'id' => $id
        ));
        if ($chktype->num_rows() > 0) {
            $resp = $chktype->row()->party_type_id;
        }
        return $resp;
    }

    /**
     * This method processes single line in a file
     *
     * @param string $line
     * @return array
     */
    private function processLine($line)
    {
        $processed = array();
        $words = preg_split('/\t/', $line);
        $processed['buyer'] = isset($words[0]) ? $words[0] : '';
        $processed['order_number'] = isset($words[1]) ? $words[1] : '';
        $processed['ship_date'] = isset($words[2]) ? $words[2] : '';
        $processed['asn_number'] = isset($words[3]) ? $words[3] : '';
        $processed['ctnr_number'] = isset($words[4]) ? $words[4] : '';
       /* log_message("error","container_number ".json_encode($processed['ctnr_number']));*/
        $processed['case_store_total'] = isset($words[5]) ? $words[5] : '';
        $processed['case_id'] = isset($words[6]) ? $words[6] : '';
        $processed['job_file_number'] = isset($words[7]) ? $words[7] : '';
        $processed['case_gross_weight'] = isset($words[8]) ? $words[8] : '';
        $processed['sku_qty_ctn'] = isset($words[9]) ? $words[9] : '';
        $processed['sku_case_ratio'] = isset($words[10]) ? $words[10] : '';
        $processed['case_length'] = isset($words[11]) ? $words[11] : '';
        $processed['case_width'] = isset($words[12]) ? $words[12] : '';
        $processed['case_height'] = isset($words[13]) ? $words[13] : '';
        $processed['case_dim_uom'] = isset($words[14]) ? $words[14] : '';
        $processed['sku_number'] = isset($words[15]) ? $words[15] : '';
        $processed['sku_qty_unit'] = isset($words[16]) ? $words[16] : '';
        $processed['sku_style'] = isset($words[17]) ? $words[17] : '';
        $processed['sku_color'] = isset($words[18]) ? $words[18] : '';
        $processed['sku_size'] = isset($words[19]) ? $words[19] : '';
        $processed['sku_upc'] = isset($words[20]) ? $words[20] : '';
        $processed['sku_uom'] = isset($words[21]) ? $words[21] : '';
        $processed['sku_desc'] = isset($words[22]) ? $words[22] : '';
        $processed['sku_price'] = isset($words[23]) ? $words[23] : '';
        $processed['ship_to_pool_hub'] = isset($words[24]) ? $words[24] : '';
        $processed['custord'] = isset($words[25]) ? $words[25] : '';
        $processed['info_dept_num'] = isset($words[26]) ? $words[26] : '';
        $processed['to_id'] = isset($words[37]) ? $words[37] : '';
        $processed['for_name'] = isset($words[38]) ? $words[38] : '';
        $processed['for_addrline1'] = isset($words[39]) ? $words[39] : '';
        $processed['for_addrline2'] = isset($words[40]) ? $words[40] : '';
        $processed['proj_ref'] = isset($words[41]) ? $words[41] : '';
        $processed['pick_type'] = isset($words[42]) ? $words[42] : '';
        $processed['for_city'] = isset($words[43]) ? $words[43] : '';
        $processed['for_state'] = isset($words[44]) ? $words[44] : '';
        $processed['for_zipcode'] = isset($words[45]) ? $words[45] : '';
        $processed['for_country'] = isset($words[46]) ? $words[46] : '';
        $processed['for_id'] = isset($words[47]) ? $words[47] : '';
        $processed['ctnr_type'] = isset($words[48]) ? $words[48] : '';
        $processed['ctnr_seal_num'] = isset($words[49]) ? $words[49] : '';
        $processed['cs_name_1'] = isset($words[74]) ? $words[74] : '';
        $processed['cs_name_2'] = isset($words[75]) ? $words[75] : '';
        $processed['cs_addrline_1'] = isset($words[76]) ? $words[76] : '';
        $processed['cs_addrline_2'] = isset($words[77]) ? $words[77] : '';
        /* CS Details */
        $processed['cs_country'] = isset($words[81]) ? $words[81] : '';
        /* LP Details */
        $processed['lp_name_1'] = isset($words[82]) ? $words[82] : '';
        $processed['lp_name_2'] = isset($words[83]) ? $words[83] : '';
        $processed['lp_addrline_1'] = isset($words[84]) ? $words[84] : '';
        $processed['lp_addrline_2'] = isset($words[85]) ? $words[85] : '';
        $processed['lp_country'] = isset($words[89]) ? $words[89] : '';
        $processed['st_name_1'] = isset($words[99]) ? $words[99] : '';
        $processed['st_addrline_1'] = isset($words[100]) ? $words[100] : '';
        $processed['st_addrline_2'] = isset($words[101]) ? $words[101] : '';
        $processed['st_city'] = isset($words[102]) ? $words[102] : '';
        $processed['st_state'] = isset($words[103]) ? $words[103] : '';
        $processed['st_zipcode'] = isset($words[104]) ? $words[104] : '';
        $processed['st_country'] = isset($words[105]) ? $words[105] : '';
        $processed['comm_ref'] = isset($words[117]) ? $words[117] : '';
        $processed['ci_value'] = isset($words[118]) ? $words[118] : '';
        $processed['ci_gross_kgs'] = isset($words[119]) ? $words[119] : '';
        $processed['ci_number'] = isset($words[120]) ? $words[120] : '';
        $processed['ci_date'] = isset($words[121]) ? $words[121] : '';
        $processed['tracking_number'] = isset($words[122]) ? $words[122] : '';
        $processed['hts_1'] = isset($words[123]) ? $words[123] : '';
        if ($processed['for_zipcode'] == "4001" || $processed['for_city'] == 'Brisbane') {
            $processed['for_zipcode'] = 4000;
            $processed['for_city'] = "Brisbane City";
        }
        /* log_message('error',"before".$processed['for_id']."<------"); */
        if (strpos($processed['for_id'], '-') !== false) {
            $for_id_arr = explode("-", $processed['for_id']);
            $processed['for_id'] = ltrim($for_id_arr[1], '0');
        }
        if (strlen((string)$processed['for_zipcode']) > 4) {
            $processed['for_zipcode'] = substr($processed['for_zipcode'], -4);
        }
        if (strlen((string)$processed['for_zipcode']) === 3) {
            $processed['for_zipcode'] = '0' . $processed['for_zipcode'];
        }
        return $processed;
    }

    /**
     * This method separates Orders by State
     *
     * @param array $processed
     * @return array
     */
    private function prepareOrders($processed)
    {
        $final = [];
        $temp = [];
        $temp2 = [];
        /* Create array based on Same State */
        $countProcessed = count($processed);
        for ($i = 0; $i < $countProcessed; $i ++) {
            $temp[$processed[$i]['for_state']][] = $processed[$i];
        }
        /* Create array based Same State and Same Name */
        foreach ($temp as $key => $value) {
            $countValue = count($value);
            for ($j = 0; $j < $countValue; $j ++) {
                $temp2[$key][$value[$j]['for_name']][] = $value[$j];
            }
        }
        /* Eliminate Orders with Same State and Same Name */
        $counter = 0;
        foreach ($temp2 as $value) {
            foreach ($value as $v) {
                $final[$counter] = $v[0];
                $final[$counter]['asn_numbers'][] = $v[0]['asn_number'];
                $countValue = count($v);
                for ($i = 1; $i < $countValue; $i ++) {
                    $final[$counter]['tb_cargo_details_id_' . $i] = $v[$i]['tb_cargo_details_id'];
                    $final[$counter]['hidden_rows'][] = $v[$i];
                }
                $counter ++;
            }
        }
        return $final;
    }

    /**
     * This method insert's or fetches carrier id by postal code
     *
     * @param string $postalcode
     * @param Arry $input
     * @return int
     */
    private function findcarrier($postalCode, array $input)
    {
        $postalCode = (int)$postalCode;
        $store_id = $input['for_id'];
        $carrier_id = 0;
        $srgCarrierQuery = "SELECT carrierId,carrierName
                FROM tb_au_srg_carrier_postalcodes
                WHERE status=? AND postalCode= ? AND storeIdentifier = ?";
        $getCarrierData = $this->db->query(
            $srgCarrierQuery,
            [1, $postalCode, $store_id])->row_array();
        if (!empty($getCarrierData)) {
            $carrier_name = $getCarrierData['carrierName'] ?? '';
            if ($carrier_name == "BEX" || $carrier_name == "Bonds DC") {
                $carrier_id = $getCarrierData['carrierId'];
            }
        }
        if (empty($carrier_id)) {
            if (stripos($store_id, "DC") === 0) {
                $carrier_id = $this->getCarrierId("BONDS DC");
            } else {
                $carrier_id = $this->getCarrierId("BORDER EXPRESS");
            }
        }
        return $carrier_id;
    }

    private function getCarrierId($name): int
    {
        $srgVendorsQuery = "SELECT id
                FROM `tb_vendors`
                WHERE company_code in ?  AND name like ? AND status = ? ";
        $getVendorData = $this->db->query(
            $srgVendorsQuery,
            [["AUKN", "KNAU"], $name, 1]
        )->row_array();
        return !empty($getVendorData) ? $getVendorData['id'] : 0;
    }

    public function labelnum($qty, $consignee_note, $order_id)
    {
        $label_num1 = [];
        $getdata = $this->db->query(
            "SELECT *
                FROM `tb_order_cargodetails`
                where order_id = ?
                ORDER BY id  DESC
                limit 1",
            [$order_id]
        );
        $label_num = "";
        if ($getdata->num_rows() > 0) {
            $label_number = $getdata->row()->label_number;
            $label_n = explode(",", $label_number);
            $lastval = end($label_n);
            $j = substr($lastval, - 3);
            $qty = $qty + $j;
            $j ++;
        } else {
            $j = 1;
            $qty = $qty;
        }
        for ($i = $j; $i <= $qty; $i ++) {
            $getval = $consignee_note . str_pad($i, 3, "0", STR_PAD_LEFT);
            if ($i == $qty) {
                $label_num .= $getval;
            } else {
                $label_num .= $getval . ",";
            }
        }
        return $label_num;
    }

    public function getConsigneeNote($orderId = null, $fun_call_val = null)
    {
        $consignment_note = 'SRGK100000';

        $this->db->select("id, consignment_note")
            ->from('tb_order_details')
            ->where('consignment_note is NOT NULL', null, false);
        if ($orderId) {
            $this->db->where('order_row_id', $orderId);
        }
        $this->db->order_by('consignment_note', 'desc')->limit(1);
        $notes = $this->db->get();

        if ($notes->num_rows() > 0) {
            $consignment_note = $notes->row()->consignment_note;
            if (! empty($consignment_note)) {
                if ($fun_call_val != 1) {
                    $consignment_note = 'SRGK' . ((int) substr($consignment_note, strpos($consignment_note, 'K') + 1) + 1);
                }
            } else {
                $consignment_note = 'SRGK100000';
            }
        }
        return $consignment_note;
    }

    private function getBranchcode($input)
    {
        $branchCode = "AUVIC";
        if ($input != "") {
            $state = trim($input);
            $state = strtoupper($state);
            if ($state == "WA") {
                $branchCode = "AUWA";
            } else if ($state == "VIC" || $state == "TAS" || $state == "SA") {
                $branchCode = "AUVIC";
            } else if ($state == "NSW" || $state == "ACT") {
                $branchCode = "AUNSW";
            } else if ($state == "QLD" || $state == "NT") {
                $branchCode = "AUQLD";
            } else {
                $branchCode = "AUVIC";
            }
        }
        return $branchCode;
    }
}

