<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";

class BasicshipmentreportV2 extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->helper('report_helper');
    }

    //below method is used to generate the where condition based on the post array parameters
    public function searchorders($post)
    {
        $whr = [];
        $status_search = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        if ($status_search == 'MANIFESTED') {

            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $todate;
            }

            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        }else if(($status_search == "CLOSED") && ($this->session->userdata('company_code') =='AUKN')){
            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        } else {

            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }

            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        }
        return $whr;
    }

    // below method will implement the ajax paging for the basic shipment report
    public function ajaxListing(){
        $checkVendorCondition = checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'));
        if ($this->session->userdata('user_id') == '') {
            echo 'SessionTimeout';
            return false;
        }
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
        $dataTableSortOrdering = [];
        $whr = [];
        $post = [];
        $status_search ="";
        $wherecondition='';
        $draw  = $this->input->post( 'draw',TRUE );
        $start = $this->input->post( 'start',TRUE );
        $limit =  $this->input->post('length',TRUE );
        $orderBy   =  $this->input->post('order',TRUE );
        $userid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        $australiaArray = [ 'AUKN', 'KNAU' ];
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $business_type = $this->session->userdata('business_type');
        $displayVehicleTypeForReport = checkAccessConditions('DISPLAY_VEHICLE_TYPE_FOR_REPORT',$company_code);
        if (! empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $aquorder = $country_userids = $whr = $post = $where = $other_checks = $wherein = $subcusts = [];
        if (! empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $status_search = "";

        $indexColumn   = 'o.id';
        $post              = $this->input->post( 'data',TRUE );
        $methodName  = $post['methodName'];
        $whr = $this->searchorders($post);
        $order_status = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";

        if (isset($post['aqucarrier']) && $post['aqucarrier'] != []) {
            $wherein['vendor_id'] = $post['aqucarrier'];
        }
        if (isset($post['aqucarrierid_adv']) && !empty($post['aqucarrierid_adv'])) {
            $wherein['vendor_id'] = $post['aqucarrierid_adv'];
        }
        if (! empty($order_status)) {
            $status_search = $order_status;
        }
        if (! empty($ad_orderstatus)) {
            $status_search = $ad_orderstatus;
        }
        $other_checks['status_search'] = $status_search;
        if (isset($post['shipper_name']) && $post['shipper_name'] != "") {
            $other_checks['shipper_name'] = $post['shipper_name'];
        }
        if (isset($post['consignee_name']) && $post['consignee_name'] != "") {
            $other_checks['consignee_name'] = $post['consignee_name'];
        }
        if (isset($post['lr_number']) && $post['lr_number'] != "") {
            $other_checks['lr_number'] = $post['lr_number'];
        }
        if (isset($post['customer_reference_number']) && $post['customer_reference_number'] != "") {
            $other_checks['customer_reference_number'] = $post['customer_reference_number'];
        }
        if (isset($post['qbook_pickupdatetime']) && $post['qbook_pickupdatetime'] != "") {
            $other_checks['qbook_pickupdatetime'] = $post['qbook_pickupdatetime'];
        }
        if ($company_code == "AUKN") {
            if (isset($post['container_num']) && $post['container_num'] != "") {
                $other_checks['container_num'] = trim($post['container_num']);
            }
        }
        $other_checks['closed_from_date'] = $other_checks['closed_to_date'] = "";
        if(in_array($company_code,$australiaArray)){
            if($other_checks['status_search'] == 'CLOSED'){
                if(isset($post['aqufromdate']) && $post['aqufromdate'] != ""){
                    $other_checks['closed_from_date'] = date('Y-m-d', strtotime($post['aqufromdate']));
                    if ( isset( $post['aqutodate'] ) ) {
                        if ( $post['aqutodate'] == "" ) {
                            $other_checks['closed_to_date'] = date( 'Y-m-d', strtotime( $cdate ) );
                        }
                    } else {
                        $other_checks['closed_to_date'] = date( 'Y-m-d', strtotime( $cdate ) );
                    }
                    if(isset($post['aqutodate']) && $post['aqutodate'] != ""){
                        $other_checks['closed_to_date'] = date('Y-m-d', strtotime($post['aqutodate']));
                    }
                }
            }
        }

        if ($this->session->userdata('user_role_id')=='4') {
            $userid = 0;
        }

        if (! empty($custid)) {
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (!empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array(
                        $custid
                    );
                }
            } else {
                $subcusts = array(
                    $custid
                );
            }
        }

        $orderTableCondition = [];
        if(!empty($whr)){
            foreach($whr as $key=>$value){
                $value="'$value'";
                if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                    $orderTableCondition[]= $key.$value;
                }else{
                    $orderTableCondition[]= $key.' = '.$value;
                }
            }
        }
        $orderTableCondition[]='o.status!=0';
        if (isset($wherein) && ! empty($wherein)) {
            if (isset($wherein['vendor_id']) && $wherein['vendor_id'] != "") {
                $vendorIds=  implode(',',$wherein['vendor_id']);
                if($vendorIds!=''){
                    $orderTableCondition[]= "o.vendor_id in ($vendorIds)";
                }
            }
        }
        if (isset($other_checks) && ! empty($other_checks)) {
            if (isset($other_checks['status_search']) && ! empty($other_checks['status_search'])) {
                $status_search = $other_checks['status_search'];
                if ($status_search == 'PENDING') {
                    $orderTableCondition[]= "o.trip_id = 0";
                } else if ($status_search == 'ACTIVE') {
                    $orderTableCondition[]= "o.trip_id!= 0";
                    $orderTableCondition[]= "o.trip_sts= 0";
                } else if ($status_search == 'CLOSED') {
                    $orderTableCondition[]= "o.trip_id!= 0";
                    $orderTableCondition[]= "o.trip_sts= 1";
                }
            }
        }

        if ($userid != '0' && $userid != '') {
            if (! empty($country_userids) && count($country_userids) > 0) {
                $countryuseridsArray=  implode(',',$country_userids);
                if($countryuseridsArray!=''){
                    $orderTableCondition[]= "o.user_id in ($countryuseridsArray)";
                }
            } else {
                $orderTableCondition[]= "o.user_id = '$userid' ";

            }
        }

        $orderTableWhere= implode(' AND ',$orderTableCondition);
        $orderByCondition='';
        if(isset($orderBy[0])){
            if($orderBy[0]!=''){
                $ordColIndex= $orderBy[0]['column'];
                $ordColDir= $orderBy[0]['dir'];
                if($ordColDir==''){
                    $ordColDir = 'asc';
                }
                if(isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex]!='' ){
                    $orderByCondition='  '.$dataTableSortOrdering[$ordColIndex].' '.$ordColDir.' ';
                }
            }
        }

        if($orderTableWhere!=''){
            $orderTableWhere=" and $orderTableWhere ";
        }
        if(!isset($other_checks['consignee_name'])){
            $other_checks['consignee_name']='';
        }
        if(!isset($other_checks['shipper_name'])){
            $other_checks['shipper_name']='';
        }
        if(!isset($other_checks['qbook_pickupdatetime'])){
            $other_checks['qbook_pickupdatetime']='';
        }
        if(!isset($other_checks['lr_number'])){
            $other_checks['lr_number']='';
        }
        if(!isset($other_checks['customer_reference_number'])){
            $other_checks['customer_reference_number']='';
        }

        $joinArray = [];
        $whereArray = [];
        if(!empty($other_checks) && sizeof($other_checks)>0){
            if( ($other_checks['consignee_name']!='') || ($other_checks['shipper_name']!='') || ($other_checks['customer_reference_number']!='')  ||  ($other_checks['qbook_pickupdatetime']!='') || ($other_checks['lr_number']!='')  ){
                $sql="select o.id from tb_orders o ";

                // shipper and consignee
                if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '') && isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                    $s = $other_checks['shipper_name'];
                    $c = $other_checks['consignee_name'];
                    $joinArray[]=array('tb'=>'tb_order_parties p','condition'=>'p.order_id=o.id','type'=>'LEFT');
                    $joinArray[]=array('tb'=>'tbl_party_master pm','condition'=>'pm.id=p.party_id','type'=>'LEFT');
                    $whereArray[]="((pm.name LIKE '%" . $s . "%' OR pm.mobile LIKE '%" . $s . "%' OR pm.code LIKE '%" . $s . "%') OR (pm.name LIKE '%" . $c . "%' OR pm.mobile LIKE '%" . $c . "%' OR pm.code LIKE '%" . $c . "%'))";
                } else if (isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                    $c = $other_checks['consignee_name'];
                    $joinArray[]=array('tb'=>'tb_order_parties p','condition'=>'p.order_id=o.id','type'=>'LEFT');
                    $joinArray[]=array('tb'=>'tbl_party_master pm','condition'=>'pm.id=p.party_id','type'=>'LEFT');
                    $whereArray[]="(pm.name LIKE '%" . $c . "%' OR pm.mobile LIKE '%" . $c . "%' OR pm.code LIKE '%" . $c . "%')";
                } else if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '')) {
                    $s = $other_checks['shipper_name'];
                    $joinArray[]=array('tb'=>'tb_order_parties p','condition'=>'p.order_id=o.id','type'=>'LEFT');
                    $joinArray[]=array('tb'=>'tbl_party_master pm','condition'=>'pm.id=p.party_id','type'=>'LEFT');
                    $whereArray[]="(pm.name LIKE '%" . $s . "%' OR pm.mobile LIKE '%" . $s . "%' OR pm.code LIKE '%" . $s . "%')";
                }

                if (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '') && isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                    $lr_val = $other_checks['lr_number'];
                    $cust_ref_val = $other_checks['customer_reference_number'];
                    $joinArray[]=array('tb'=>'tb_order_references orf','condition'=>'orf.order_id=o.id','type'=>'LEFT');
                    if ($business_type == 'Customer') {
                        $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='BN' and orf.status='1') OR (orf.ref_value like '%" . $cust_ref_val . "'  and orf.reference_id='DQ' and orf.status='1')";
                    } else {
                        $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='PO' and orf.status='1') OR (orf.ref_value like '%" . $cust_ref_val . "'  and orf.reference_id='DQ' and orf.status='1')";
                    }
                } elseif (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '')) {
                    $lr_val = $other_checks['lr_number'];
                    $joinArray[]=array('tb'=>'tb_order_references orf','condition'=>'or.order_id=o.id','type'=>'LEFT');
                    if ($business_type == 'Customer') {
                        $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='BN' and orf.status='1')";
                    } else {
                        $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='PO' and orf.status='1')";
                    }
                } elseif (isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                    $cust_ref_val = $other_checks['customer_reference_number'];
                    $joinArray[]=array('tb'=>'tb_order_references orf','condition'=>'orf.order_id=o.id','type'=>'LEFT');
                    $whereArray[]="(orf.ref_value like '%" . $cust_ref_val . "%' and orf.reference_id='DQ' and orf.status='1')";
                }
                // pickdatetime
                if (isset($other_checks['qbook_pickupdatetime']) && ($other_checks['qbook_pickupdatetime'] != '')) {
                    $pickdatetime = date("Y-m-d", strtotime($other_checks['qbook_pickupdatetime']));
                    $joinArray[]=array('tb'=>'tb_stop_status tps','condition'=>'o.shift_id=tps.shipment_id','type'=>'LEFT');
                    $whereArray[]="(tps.status_id='10' and DATE_FORMAT(tps.createdon,'%Y-%m-%d') ='" . $pickdatetime . "') OR (DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') ='" . $pickdatetime . "')";
                }
            }
        }

        if(isset($other_checks['container_num']) && $other_checks['container_num']!='' ) {
            if(!isset($sql)){
                $sql="select o.id from tb_orders o ";
            }

            $container_number = $other_checks['container_num'];
            $joinArray[]=array('tb'=>'tb_order_references orf_ctr','condition'=>'orf_ctr.order_id=o.id','type'=>'LEFT');
            $whereArray[]="(orf_ctr.ref_value like '%" . $container_number . "%' and orf_ctr.reference_id='CTR' and orf_ctr.status='1')";
        }

        if ($status_search == 'MANIFESTED') {
            if(!isset($sql)){
                $sql="select o.id from tb_orders o ";
            }
            $joinArray[]=array('tb'=>'tb_order_status os','condition'=>'os.order_id=o.id','type'=>'LEFT');
            $whereArray[]=" os.status=1 and os.status_code=2492";
        }

        $ordCon='';
        if(!empty($whereArray) && sizeof($whereArray)>0){
            $ordCon= implode(' AND ',$whereArray);
        }

        if(!empty($joinArray) && sizeof($joinArray)>0){
            if(!isset($sql)){
                $sql="select o.id from tb_orders o ";
            }
            foreach($joinArray as $eachJoin){
                $sql.= ' '.$eachJoin['type'].' join '.$eachJoin['tb'].' on '.$eachJoin['condition'].'';
            }
            $sql.=" where o.id!= '' ";
            if($ordCon!=''){
                $sql.=" and $ordCon ";
            }

            $orderNumbers='';
            if($sql!=''){
                $dat = $this->db->query($sql);
                if ($dat->num_rows() > 0) {
                    $resultant = $dat->result_array();
                    if (! empty($resultant) && sizeof($resultant) > 0) {
                        foreach ($resultant as $eachOrdNum) {
                            $orderNumbers = $orderNumbers . $eachOrdNum['id'] . ',';
                        }
                    }
                    $orderNumbers = trim($orderNumbers, ',');
                    if($orderNumbers!=''){
                        $orderTableWhere.=" and o.id in ($orderNumbers)";
                    }
                }
            }
        }

        if(!empty($subcusts) && sizeof($subcusts)>0){
            $customerIdCondition= implode(',',$subcusts);
            if($customerIdCondition!=''){
                $orderTableWhere.=" and o.customer_id in ($customerIdCondition)";
            }
        }

        //below query for pagination count and applying where condition in subquery for sub-query to be fast
        $countAndOrderIdQuery="select count(o.id) as count from tb_orders o
        where o.id!=0  $orderTableWhere ";
        $compiledCount='';
        $resultSet=$this->db->query($countAndOrderIdQuery);
        if($resultSet->num_rows()>0){
            $resdata = $resultSet->result_array();
            if(isset($resdata[0]['count'])){
                $compiledCount=$resdata[0]['count'];
            }
        }else{
            $compiledCount=0;
        }

        $selectColumns=array('o.id','o.order_id','o.goods_value','o.transport_mode','o.pickup_company','o.pickup_city','o.pickup_address2','o.pickup_pincode',
            'o.delivery_company','o.delivery_city','o.delivery_address2','o.delivery_pincode','o.pickup_datetime','o.delivery_datetime',
            'o.createdon','o.shift_id','o.drop_endtime','o.vendor_id','o.customer_id','tv.name as vendor_name',
            'cust.name as customer_name','cust.code as customer_code','s.vehicle_type','sv.register_number'
        );

        if(in_array($company_code,$australiaArray)){
            $selectColumns=array('o.id','o.order_id','o.goods_value','o.transport_mode','o.pickup_company','o.pickup_city','o.pickup_address2','o.pickup_pincode',
                'o.delivery_company','o.delivery_city','o.delivery_address2','o.delivery_pincode','o.pickup_datetime','o.delivery_datetime',
                'o.createdon','o.shift_id','o.drop_endtime','o.vendor_id','o.customer_id','d.consignment_note','tv.name as vendor_name',
                'cust.name as customer_name','cust.code as customer_code'
            );
        }

        $table_name='tb_orders o';
        $indexColumn='o.id';
        $groupBy='o.id';
        //$orderBy='o.id desc';
        $excludeCountQuery='Yes';

        $wherecondition= $indexColumn."!='' ".$orderTableWhere;
        $orderByCondition=$orderByCondition;
        $timeZone=$curtz;
        if(in_array($company_code,$australiaArray) || $this->session->userdata("company_code")=='INKN'){
            $joinsArray[]=array('table_name'=>'tb_order_details as d','condition'=>"o.id=d.order_row_id",'join_type'=>'left');
        }
        $joinsArray[]=array('table_name'=>'tb_vendors as tv','condition'=>"tv.id=o.vendor_id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_customers as cust','condition'=>"cust.id=o.customer_id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_shifts as s','condition'=>"s.id = o.shift_id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_shft_veh as sv','condition'=>"s.id = sv.shft_id",'join_type'=>'left');
        $dataTableSortOrdering=[];
        $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );
        if($excludeCountQuery=='Yes'){
            $totalRecords     = $compiledCount;
            $recordsFiltered  = $compiledCount;
        }else{
            $totalRecords     = $getRecordListing['recordsTotal'];
            $recordsFiltered  = $getRecordListing['recordsFiltered'];
        }

        $reqData=array('id','shift_id');
        $this->db->query('SET SESSION  group_concat_max_len=10240');
        $formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
        if(isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id']!=''){
            $formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData);
            $formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);
            $formattedData=$this->DataQueryFormatter_model->getOrderCargoContent($formattedData['commaSeparated']['id'],$formattedData);
            $formattedData=$this->DataQueryFormatter_model->getEstimatedPickup($formattedData['commaSeparated']['id'],$formattedData);
            $podType = false;
            if (in_array($company_code,$australiaArray)) {
                $podType = true;
            }
            $formattedData = $this->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'], $formattedData, $podType);
            if($this->session->userdata("company_code")=='AUKN' || $this->session->userdata("company_code")=='INKN'){
                $formattedData=$this->DataQueryFormatter_model->getOrderStatusDates($formattedData['commaSeparated']['id'],$formattedData);
                $formattedData=$this->DataQueryFormatter_model->getOrderStopStatusStatus($formattedData['commaSeparated']['id'],$formattedData);
            }
        }

        if(isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id']!=''){
            $deliveredStatusArray=$this->DataQueryFormatter_model->getStopStatusDelviered($formattedData['commaSeparated']['shift_id']);
            $genericStatusArray=$this->DataQueryFormatter_model->getStopStatusGeneric($formattedData['commaSeparated']['shift_id']);

            if(in_array($company_code,$australiaArray)){
                $driverAcceptanceArray=$this->DataQueryFormatter_model->getDriverAcceptance($formattedData['commaSeparated']['shift_id']);
            }
        }

        $getRecordListing=[];
        if(isset($formattedData['orders'])){
            $getRecordListing=$formattedData['orders'];
            krsort($getRecordListing);
        }

        $recordListing    = [];
        $content          = '[';
        $i                = 0;
        $srNumber = $start;

        if ( ! empty( $getRecordListing ) ) {
            $actionContent = '';
            $cntr=1;
            foreach ( $getRecordListing as $res ) {
                $cust_reference_num = $lr_num = $delconsignee_date = $delivery_status = $container_num = $store_code = $load_plan_connote ='';
                $referenceData=$ediReceivedDate='';
                if (isset($res['reference_value'])) {
                    $referenceData = $res['reference_value'];
                }

                if ($referenceData != '') {
                    $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);

                    if ($business_type == 'Customer') {
                        if (isset($arrayData['BN'])) {
                            $lr_num = $arrayData['BN'];
                        }
                    } else {
                        // admin
                        if (isset($arrayData['PO'])) {
                            $lr_num = $arrayData['PO'];
                        }
                    }
                    if (isset($arrayData['IV'])) {
                        $invoice_num = $arrayData['IV'];
                    }else{
                        $invoice_num = '';
                    }
                    // customer reference number
                    if(isset($arrayData['CR'])){
                        $cust_reference_num = $arrayData['CR'];
                    }else{
                        if(isset($arrayData['DQ'])){
                            $cust_reference_num = $arrayData['DQ'];
                        }else{
                            $cust_reference_num = '';
                        }
                    }

                    if ("NZPG" === $company_code) {
                        $customerRefData = $this->DataQueryFormatter_model->getCustomerDeliveryNote($res['id']);
                        $cust_reference_num = $customerRefData['ref_value'] ?? '';
                    }
                    if(isset($arrayData['AWB'])){
                        $docket_num = $arrayData['AWB'];
                    } elseif (isset($arrayData['BN'])) {
                        $docket_num = $arrayData['BN'];
                    }else{
                        if(isset($arrayData['DQ'])){
                            $docket_num = $arrayData['DQ'];
                        }else{
                            $docket_num = '';
                        }
                    }
                    if(isset($arrayData['DQ'])){
                        $consignment_num = $arrayData['DQ'];
                    }
                    if (isset($arrayData['CTR'])) {
                        $container_num = $arrayData['CTR'];
                    }else{
                        $container_num = $res['order_id'];
                    }
                    if (isset($arrayData['COI'])) {
                        $store_code = $arrayData['COI'];
                    }
                    if (isset($arrayData['LPC'])) {
                        $load_plan_connote = $arrayData['LPC'];
                    }
                }

                if(isset($res['cargo_content'])){
                    $tempContentArray = [];
                    $tempContentArray = explode('?????', $res['cargo_content']);
                    $tempContentArray = array_unique($tempContentArray);
                    $res['cargo_content'] = implode(',', $tempContentArray);
                }else{
                    $res['cargo_content']='';
                }
                $final_cargo_content = $res['cargo_content'];
                $this->load->helper('local_timezone_helper');

                $date = '0000-00-00 00:00:00';
                if(isset($res['estimated_pickup_time'])){
                    $estimatedPickupTime = dateConvertByTimeZone($res['estimated_pickup_time'],'UTC',$curtz);
                    if($estimatedPickupTime!=''){
                        $createdon = $estimatedPickupTime;
                    }else{
                        $createdon = '';
                    }

                }else{
                    $createdon = '';
                }
                if(isset($res['delivery_datetime'])){
                    $estimatedDeliveryTime = dateConvertByTimeZone($res['delivery_datetime'],'UTC',$curtz);
                    if($estimatedDeliveryTime!=''){
                        $estimate_d_date = $estimatedDeliveryTime;
                    }else{
                        $estimate_d_date='';
                    }

                }else{
                    $estimate_d_date='';
                }

                /* Time zone conversions*/
                if(isset($res['pickup_datetime'])){
                    $res['pickup_datetime']=dateConvertByTimeZone($res['pickup_datetime'],'UTC',$curtz);
                }
                if(isset($res['drop_endtime'])){
                    $res['drop_endtime']=dateConvertByTimeZone($res['drop_endtime'],'UTC',$curtz);
                }
                if(isset($res['delivery_datetime'])){
                    $res['delivery_datetime']=dateConvertByTimeZone($res['delivery_datetime'],'UTC',$curtz);
                }

                if ($createdon != '' || $estimate_d_date != '') {
                    if (($createdon != $date) && ($createdon != null)) {
                        $pickup_date = date("d M Y", strtotime($createdon));
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                    }
                    if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                        $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                    } else {
                        $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                    }
                } else {
                    $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                    $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                }

                if (in_array($company_code,$australiaArray)) {
                    $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                    $estimate_de_date = date("d M Y", strtotime($res['delivery_datetime']));
                }

                $last_status_name = $last_loc = $delivery_date = "";
                $delivery_status = "Not Delivered";
                $reqStatusData=array(
                    'status_code'=>'','stop_type'=>'','status_id'=>'','createdon'=>'','loc_name'=>'','latitude'=>'','longitude'=>''
                );

                if(isset($res['shift_id']) && $res['shift_id']!='' &&  $res['shift_id']!=0){
                    $shiftIndex=$res['shift_id'];
                    if(isset($deliveredStatusArray[$shiftIndex])){
                        if($deliveredStatusArray[$shiftIndex]['delivered_status_status_code']=='3000'){
                            $last_status_name=$deliveredStatusArray[$shiftIndex]['delivered_status_status_name'];
                            $reqStatusData['status_code']=$deliveredStatusArray[$shiftIndex]['delivered_status_status_code'];
                            $reqStatusData['stop_type']=$deliveredStatusArray[$shiftIndex]['delivered_status_stop_type'];
                            $reqStatusData['status_id']=$deliveredStatusArray[$shiftIndex]['delivered_status_id'];
                            $reqStatusData['createdon']=$deliveredStatusArray[$shiftIndex]['delivered_status_createdon'];
                            $reqStatusData['loc_name']=$deliveredStatusArray[$shiftIndex]['delivered_status_loc_name'];
                            $reqStatusData['latitude']=$deliveredStatusArray[$shiftIndex]['delivered_status_latitude'];
                            $reqStatusData['longitude']=$deliveredStatusArray[$shiftIndex]['delivered_status_longitude'];
                            $reqStatusData['updatedOn']=$deliveredStatusArray[$shiftIndex]['delivered_status_updatedOn'];
                        }
                    }else{
                        if(isset($genericStatusArray[$shiftIndex])){
                            $last_status_name=$genericStatusArray[$shiftIndex]['generic_status_status_name'];
                            $reqStatusData['status_code']=$genericStatusArray[$shiftIndex]['generic_status_status_code'];
                            $reqStatusData['stop_type']=$genericStatusArray[$shiftIndex]['generic_status_stop_type'];
                            $reqStatusData['status_id']=$genericStatusArray[$shiftIndex]['generic_status_id'];
                            $reqStatusData['createdon']=$genericStatusArray[$shiftIndex]['generic_status_createdon'];
                            $reqStatusData['loc_name']=$genericStatusArray[$shiftIndex]['generic_status_loc_name'];
                            $reqStatusData['latitude']=$genericStatusArray[$shiftIndex]['generic_status_latitude'];
                            $reqStatusData['longitude']=$genericStatusArray[$shiftIndex]['generic_status_longitude'];
                        }
                    }

                    if ($reqStatusData['status_id'] == 1) {
                        if ($reqStatusData['stop_type'] == "P") {
                            $last_status_name = "Pickedup";
                        } else {
                            $last_status_name = "Delivered";
                        }
                    }
                    if ($reqStatusData['status_code'] == '0192' && $reqStatusData['stop_type'] == 'D' && $company_code == "INKN") {
                        $last_status_name = "In Transit";
                    }

                    if ($reqStatusData['status_code'] == '0420' || $reqStatusData['status_code'] == '0191' && $reqStatusData['stop_type'] == 'P' && $company_code == "INKN") {
                        $last_status_name = "Pick Up";
                    }
                    if ($reqStatusData['status_code'] == '3000' && $reqStatusData['stop_type'] == 'D') {
                        if (in_array($company_code,$australiaArray) || $company_code == "INKN") {
                            $last_status_name = "Delivered";
                        }
                        $date = '0000-00-00 00:00:00';
                        $d_time = getEDAofNZShipmentbyord($res['id']);
                        $d_date = $d_time['time'];
                        $delivery_status = "Delivered";
                        if (isset($d_date) && $d_date != "") {

                            if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                $delivery_date = date("d M Y", strtotime($d_date));
                            } else {
                                $delivery_date = "";
                            }
                        }
                        if (in_array($company_code,$australiaArray)) {
                            $d_createdon = $reqStatusData['createdon'];
                            if (isset($d_createdon) && !empty($d_createdon)) {
                                if (($d_createdon != $date) || (strtotime($d_createdon) > 0)) {
                                    $d_d_date = getdatetimebytimezone($curtz,$d_createdon,DFLT_TZ);
                                    $d_createdon = $d_d_date['datetime'];
                                    $delivery_date = date("d M Y", strtotime($d_createdon));
                                } else {
                                    $delivery_date = "";
                                }
                            }
                            $ediReceivedDate = $reqStatusData['updatedOn'];
                            if (!empty($ediReceivedDate) && (($ediReceivedDate !== $date) || (strtotime($ediReceivedDate) > 0))) {
                                $ediReceivedDate1 = getdatetimebytimezone($curtz, $ediReceivedDate, DFLT_TZ);
                                $ediReceivedDate = $ediReceivedDate1['datetime'];
                            }
                        }
                    }

                    if ($reqStatusData['loc_name'] != null) {
                        $last_loc = $reqStatusData['loc_name'];
                    } else {
                        $lat = $reqStatusData['latitude'];
                        $lng = $reqStatusData['longitude'];
                        if($lat!='' && $lng!=''){
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }
                }
                if ($last_status_name == "" && in_array($company_code, $australiaArray)) {
                    $orderStatusArray = $this->DataQueryFormatter_model->getOrderLastStatus($res['id']);
                    if (count($orderStatusArray) > 0) {
                        $last_status_name = $orderStatusArray['status_name'];
                        $reqStatusData['status_code'] = $orderStatusArray['status_code'];
                        $reqStatusData['stop_type'] = '';
                        $reqStatusData['status_id'] = $orderStatusArray['id'];
                        $reqStatusData['createdon'] = $orderStatusArray['createdon'];
                        $reqStatusData['loc_name'] = '';
                        $reqStatusData['latitude'] = $orderStatusArray['latitude'];
                        $reqStatusData['longitude'] = $orderStatusArray['longitude'];
                    } else {
                        $last_status_name = "Book by supplier";
                    }
                }
                $carrierservice = $mdate=$manifestdated=$scanned_date=$manifestdated=$accepted="";
                $pickupdate=$pdate=$gateout=$gateoutdate=$transit=$transitdate=$delivered_time=$deliverydate='';
                if (in_array($company_code,$australiaArray) || $company_code == 'INKN') {
                    $this->load->helper('border_helper');
                    $vendor_res = checkborderCarrier($res['vendor_id']);
                    if (! empty($vendor_res)) {
                        $carrierservice = "BORDER BULK";
                        if(isset($res['totqty'])){
                            if ($res['totqty'] < 20) {
                                $carrierservice = "BORDER PALLETS";
                            }
                        }
                    }else{
                        $carrierservice = "";
                    }


                    if(isset($res['status_code'])){
                        if($res['status_code']!=''){
                            $StatusArray=array(  $res['status_date'],$res['status_code'] );
                            $getOrderStatusArray=$this->DataArrayFormatter_model->buildGenericArray($StatusArray,'BasicShipment_OrderStatus');
                            if(!empty($getOrderStatusArray) && sizeof($getOrderStatusArray)>0){
                                foreach($getOrderStatusArray as $eachItem){
                                    if($eachItem['status_code']=='2492'){
                                        //manifested
                                        $manifestdated = $eachItem['status_date'];
                                        if($manifestdated != "" && $manifestdated != "0000-00-00 00:00:00" && $manifestdated != "0"){
                                            $mdate      = getdatetimebytimezone( $curtz, $manifestdated, DFLT_TZ );
                                            $manifestdated = date('Y-m-d h:i A',strtotime($mdate['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='2491'){
                                        //scanned date
                                        $scanned_date = $eachItem['status_date'];
                                        if($scanned_date != "" && $scanned_date != "0000-00-00 00:00:00" && $scanned_date != "0"){
                                            $scanneddate      = getdatetimebytimezone( $curtz, $scanned_date, DFLT_TZ );
                                            $scanned_date = date('Y-m-d h:i A',strtotime($scanneddate['datetime']));
                                        }
                                    }
                                }
                            }
                        } }

                    $order_cdate = $res['createdon'];
                    if($order_cdate != "" && $order_cdate != "0000-00-00 00:00:00" && $order_cdate != "0"){
                        $ocreatedon      = getdatetimebytimezone( $curtz, $order_cdate, DFLT_TZ );
                        $order_cdate = date('Y-m-d h:i A',strtotime($ocreatedon['datetime']));
                    }


                    if(isset($res['stop_status_code'])){
                        if($res['stop_status_code']!=''){
                            $stopStatusArray=array( $res['stop_status_createdon'],$res['stop_status_code'] );
                            $getStopStatusArray=$this->DataArrayFormatter_model->buildGenericArray($stopStatusArray);
                            if(!empty($getStopStatusArray) && sizeof($getStopStatusArray)>0){
                                foreach($getStopStatusArray as $eachItem){
                                    if($eachItem['status_code']=='3000'){
                                        //delivery time
                                        $delivered_time = $eachItem['createdon'];
                                        if($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0"){
                                            $deliverydate      = getdatetimebytimezone( $curtz, $delivered_time, DFLT_TZ );
                                            $delivered_time = date('Y-m-d h:i A',strtotime($deliverydate['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='1550'){
                                        //Transit time
                                        $transit = $eachItem['createdon'];
                                        if($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0"){
                                            $transitdate      = getdatetimebytimezone( $curtz, $transit, DFLT_TZ );
                                            $transit = date('Y-m-d h:i A',strtotime($transitdate['datetime']));
                                        }

                                    }else if($eachItem['status_code']=='0191'){
                                        //Gate out time
                                        $gateout = $eachItem['createdon'];
                                        if($gateout != "" && $gateout != "0000-00-00 00:00:00" && $gateout != "0"){
                                            $gateoutdate      = getdatetimebytimezone( $curtz, $gateout, DFLT_TZ );
                                            $gateout = date('Y-m-d h:i A',strtotime($gateoutdate['datetime']));
                                        }

                                    }
                                    else if($eachItem['status_code']=='0500'){
                                        //Pickup  time
                                        $pickupdate = $eachItem['createdon'];
                                        if($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0"){
                                            $pdate      = getdatetimebytimezone( $curtz, $pickupdate, DFLT_TZ );
                                            $pickupdate = date('Y-m-d h:i A',strtotime($pdate['datetime']));
                                        }

                                    }else if($eachItem['status_code']=='0212'){
                                        //Accepted  time
                                        $accepted = $eachItem['createdon'];
                                        if($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0"){
                                            $pdate = getdatetimebytimezone( $curtz, $accepted, DFLT_TZ );
                                            $accepted = date('Y-m-d h:i A',strtotime($pdate['datetime']));
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if($company_code != 'INKN'){
                        if(isset($res['shift_id']) && $res['shift_id']!='' &&  $res['shift_id']!=0){
                            $shiftIndex=$res['shift_id'];
                            if(isset($driverAcceptanceArray[$shiftIndex])){
                                if($driverAcceptanceArray[$shiftIndex]['driver_acceptance_date']!=''){
                                    $accepted = $driverAcceptanceArray[$shiftIndex]['driver_acceptance_date'];
                                    if($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0"){
                                        $acceptdate      = getdatetimebytimezone( $curtz, $accepted, DFLT_TZ );
                                        $accepted = date('Y-m-d h:i A',strtotime($acceptdate['datetime']));
                                    }
                                }
                            }
                        }

                        if($accepted != "" && $delivered_time != ""){
                            if($accepted > $delivered_time){
                                $pickup_datetime = $res['pickup_datetime'];
                                if($pickup_datetime != "" && $pickup_datetime != "0000-00-00 00:00:00" && $pickup_datetime != "0"){
                                    $paccept      = getdatetimebytimezone( $curtz, $pickup_datetime, DFLT_TZ );
                                    $pdatetime = date('Y-m-d H:i:s',strtotime($paccept['datetime']));
                                    $accepted = date( 'Y-m-d h:i:A', strtotime( '+1 hour', strtotime( $pdatetime ) ) );
                                }
                            }
                        }
                    }
                }

                $pod_available = $imgpath = $receiver_name="";

                if(!isset($res['pod_available'])){
                    $res['pod_available']='';
                }
                if(!isset($res['receiver_name'])){
                    $res['receiver_name']='';
                }
                if(!isset($res['imgpath'])){
                    $res['imgpath']='';
                }

                $pod_available = $res['pod_available'];
                $receiver_name = $res['receiver_name'];
                $imgpath       = $res['imgpath'];
                if($pod_available != "" && $pod_available != "0000-00-00 00:00:00" && $pod_available != "0"){
                    $poddate      = getdatetimebytimezone( $curtz, $pod_available, DFLT_TZ );
                    $pod_available = date('Y-m-d h:i A',strtotime($poddate['datetime']));
                }
                $podAction = $podDocs = $trackingLink = '';
                if ($imgpath != '') {
                    $base64DocumentData = getBase64DocumentData($imgpath);
                    $extention = $base64DocumentData['extention'];
                    $stringData = "'" . $base64DocumentData['file_content'] . "'," . "'" . $extention . "'";
                    if ($extention != "") {
                        if (in_array($extention, ['pdf'])) {
                            $podAction = '<a onclick="return downloadDocument(' . $stringData . ')"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                        } else {
                            $podAction = '<a onclick="return downloadDocument(' . $stringData . ')"><img src="' . $base64DocumentData['file_content'] . '" class="img-responsive" style="width: 10%;"></a>';
                        }
                    } else {
                        $podAction = '<p>No Pod</p>';
                    }
                } else {
                    $podAction = '<p>No Pod</p>';
                }
                if(!isset($container_num)){
                    $container_num='';
                    $trackLink = '';
                    $trackingLink = '';
                }else{
                    $trackLink = base_url('tracking/ordertracking').'/'.$container_num;
                    $trackingLink = '<a target="_blank" href="'.$trackLink.'"><i class="fa fa-link"></i></a><p style="display: none;">'.$trackLink.'</p>';
                }

                $quotedOrderId=$res['order_id'];
                $quotedOrderId="'$quotedOrderId'";
                $quotedId=$res['id'];
                $podDocs.='<a href="#"  onclick="return orddocsdetails('.$quotedId.','.$quotedOrderId.')"
							class="buttonCardIcon" data-action="open"
							data-popup="open-data" data-side="right" data-toggle="tooltip" title="'.$this->lang->line("other_docs").'"><span class="icon tru-icon-tender-list"></span></span></a>';


                $empty  = "";

                $content .= '[';
                $j=0;
                $recordListing[ $i ][0]  = '';
                $recordListing[ $i ][++$j]  = $cntr;
                if($this->session->userdata('company_code') == "INKN"){
                    $recordListing[ $i ][++$j]  = $docket_num;
                }else{
                    $recordListing[ $i ][++$j]  = $res['order_id'];
                }
                if($this->session->userdata('company_code') == "INKN"){
                    $recordListing[ $i ][++$j]=$res['customer_name'];
                }else{
                    $recordListing[ $i ][++$j]=$res['customer_name']."(".$res['customer_code'].")";
                }

                if (in_array($company_code,$australiaArray)) {

                    $res['ref_order_num'] = (!empty($res['ref_order_num'])) ?
                        str_replace(",", ", ", $res['ref_order_num']) : '';
                    if(empty($res['ref_order_num'])){
                       $res['ref_order_num']=$this->getOrdersRefNum($res['id']);
                    }
                    $recordListing[ $i ][++$j]  = $res['ref_order_num'];
                } else {
                    $cust_reference_num= str_replace(",", ", ", $cust_reference_num);
                    $recordListing[ $i ][++$j]  = ($cust_reference_num!='') ? $cust_reference_num : 'NA';
                }

                if (in_array($company_code,$australiaArray)) {
                    $recordListing[ $i ][++$j]  = $container_num;
                    $recordListing[ $i ][++$j]  = $load_plan_connote;
                    if(!isset($res['consignment_note'])){
                        $res['consignment_note']='';
                    }
                    $recordListing[ $i ][++$j]  = $res['consignment_note'];
                } else if ($this->session->userdata('company_code') == "INKN"){
                    $recordListing[ $i ][++$j]  = $container_num;
                    if(!isset($consignment_num)){
                        $consignment_num='';
                    }
                    $recordListing[ $i ][++$j]  = $consignment_num;
                }else {
                    $recordListing[ $i ][++$j]  = $lr_num!='' ? $lr_num : 'NA';
                }

                if(!isset($res['goods_value'])){
                    $res['goods_value']='';
                }
                $recordListing[ $i ][++$j]  = $res['goods_value'];

                if(!isset($res['transport_mode'])){
                    $res['transport_mode']='';
                }
                if(!isset($res['pickup_company'])){
                    $res['pickup_company']='';
                }
                if(!isset($res['pickup_city'])){
                    $res['pickup_city']='';
                }

                $recordListing[ $i ][++$j]  = $res['transport_mode'];
                $recordListing[ $i ][++$j]  = $res['pickup_company'];
                $recordListing[ $i ][++$j]  = $res['pickup_city'];
                if (in_array($company_code,$australiaArray) || $this->session->userdata('company_code') == "INKN") {
                    if(!isset($res['pickup_address2'])){
                        $res['pickup_address2']='';
                    }
                    $recordListing[ $i ][++$j]  = $res['pickup_address2'];
                }
                if($this->session->userdata('company_code') == "INKN") {
                    $recordListing[ $i ][++$j]  = $res['pickup_pincode'];
                }

                if(!isset($res['delivery_company'])){
                    $res['delivery_company']='';
                }
                if(!isset($res['delivery_city'])){
                    $res['delivery_city']='';
                }

                $recordListing[ $i ][++$j]  = $res['delivery_company'];
                $recordListing[ $i ][++$j]  = $res['delivery_city'];
                if (in_array($company_code,$australiaArray)) {

                    if(!isset($res['delivery_address2'])){
                        $res['delivery_address2']='';
                    }

                    if(!isset($res['delivery_pincode'])){
                        $res['delivery_pincode']='';
                    }

                    $recordListing[ $i ][++$j]  = $res['delivery_address2'];
                    $recordListing[ $i ][++$j]  = $res['delivery_pincode'];
                    $recordListing[ $i ][++$j]  = $store_code;
                    $recordListing[ $i ][++$j]  = $carrierservice;
                }
                if($this->session->userdata('company_code') == "INKN") {

                    if(!isset($res['delivery_address2'])){
                        $res['delivery_address2']='';
                    }

                    if(!isset($res['delivery_pincode'])){
                        $res['delivery_pincode']='';
                    }

                    $recordListing[ $i ][++$j]  = $res['delivery_address2'];
                    $recordListing[ $i ][++$j]  = $res['delivery_pincode'];
                    $recordListing[ $i ][++$j]  = $invoice_num;
                    $recordListing[ $i ][++$j]  = '';
                    $recordListing[ $i ][++$j]  = $carrierservice;
                }
                $recordListing[ $i ][++$j]  = $final_cargo_content;
                if(!isset($res['totqty'])){
                    $res['totqty']='';
                }

                $recordListing[ $i ][++$j]  = $res['totqty'];

                if(in_array($company_code,$australiaArray) || $this->session->userdata('company_code')=="INKN"){
                    if(!isset($res['scanned_quantity'])){
                        $res['scanned_quantity']='';
                    }
                    $recordListing[ $i ][++$j]  = $res['scanned_quantity'];
                    if(!isset($res['totwg'])){
                        $res['totwg']='0';
                    }

                    $recordListing[ $i ][++$j]  = ($res['totwg']>0) ? round($res['totwg'],2):'';
                    $recordListing[ $i ][++$j]  = ($res['totwg']>0) ? 'Kgs':'';
                }else{
                    if(!isset($res['totwg'])){
                        $res['totwg']='0';
                    }
                    $recordListing[ $i ][++$j]  = ($res['totwg']>0) ? round($res['totwg'],2). ' Kgs':'';
                }

                if(in_array($company_code,$australiaArray) || $this->session->userdata('company_code')=="INKN"){
                    if(!isset($res['totvolume'])){
                        $res['totvolume']='0';
                    }
                    $recordListing[ $i ][++$j]  = $res['totvolume'];
                }else{
                    if(!isset($res['volumetric_weight'])){
                        $res['volumetric_weight']='0';
                    }
                    $recordListing[ $i ][++$j]  = ($res['volumetric_weight']>0)? round($res['volumetric_weight'],2). ' Kgs':'';
                }

                if(!isset($res['vendor_name'])){
                    $res['vendor_name']='';
                }

                if($business_type != 'Customer' || !$checkVendorCondition) {
                    $recordListing[ $i ][++$j]  = $res['vendor_name'];
                }
                if ( $displayVehicleTypeForReport ) {
                    $recordListing[ $i ][++$j]  = $res['vehicle_type'];
                }

                if(!in_array($company_code,$australiaArray) && $this->session->userdata('company_code') != "INKN"){
                    $recordListing[ $i ][++$j]  = $pickup_date;
                }

                if (in_array($company_code,$australiaArray) && ($this->session->userdata('user_role_id') == '2' ||$this->session->userdata('user_role_id') == '1')) {
                    $recordListing[ $i ][++$j]  = $order_cdate;
                    $recordListing[ $i ][++$j]  = $scanned_date;
                    $recordListing[ $i ][++$j]  = $manifestdated;
                    $recordListing[ $i ][++$j]  = $pickupdate;
                    $recordListing[ $i ][++$j]  = $accepted;
                    $recordListing[ $i ][++$j]  = $gateout;
                    $recordListing[ $i ][++$j]  = $transit;
                }
                if ($this->session->userdata('company_code') == "INKN") {
                    $recordListing[ $i ][++$j]  = $order_cdate;
                    $recordListing[ $i ][++$j]  = $scanned_date;
                    $recordListing[ $i ][++$j]  = $manifestdated;
                    $recordListing[ $i ][++$j]  = $pickupdate;
                    $recordListing[ $i ][++$j]  = $accepted;
                    $recordListing[ $i ][++$j]  = $transit;
                }
                $recordListing[ $i ][++$j]  = $estimate_de_date;
                if (in_array($company_code,$australiaArray) && ($this->session->userdata('user_role_id') == '2' ||$this->session->userdata('user_role_id') == '1')) {
                    $recordListing[ $i ][++$j]  = $delivered_time;
                }
                if ($this->session->userdata('company_code') == "INKN"){
                    $recordListing[ $i ][++$j]  = $delivered_time;
                }
                $australiaCarrierNameCondition = checkAccessConditions('RELATED_2_AUKN_KNAU', $company_code);
                if ($australiaCarrierNameCondition && $methodName ==='ediReceivedBsr') {
                    $recordListing[$i][++$j] = $ediReceivedDate;
                }
                if(!in_array($company_code,$australiaArray) && $this->session->userdata('company_code')!="INKN"){
                    $recordListing[ $i ][++$j]  = $delivery_status;
                }
                if(in_array($company_code,$australiaArray) || $this->session->userdata('company_code')=="INKN"){
                    if(!empty($delivered_time) && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0"){
                        $recordListing[ $i ][++$j]= date("d M Y", strtotime($delivered_time));
                    }else{
                        $recordListing[ $i ][++$j]  ='';
                    }
                }else{
                    $recordListing[ $i ][++$j]  = $delivery_date;
                }

                $recordListing[ $i ][++$j]  = $last_status_name;
                $recordListing[ $i ][++$j]  = $last_loc;
                $recordListing[ $i ][++$j]  = $pod_available;
                if(in_array($company_code,$australiaArray)){
                    $recordListing[ $i ][++$j]  = $receiver_name;
                }
                $remarks = '';
                if($this->session->userdata('company_code') == 'INKN'){
                    $recordListing[ $i ][++$j]  = $remarks;
                    $recordListing[ $i ][++$j]  = $trackingLink;
                }
                $recordListing[ $i ][++$j]  = $podAction;
                if($this->session->userdata('company_code') != 'INKN'){
                    $recordListing[ $i ][++$j]  = $podDocs;
                }

                $i ++;
                $cntr++;
            }

            $content    .= ']';
            $final_data = json_encode( $recordListing );
        } else {
            $final_data = '[]';
        }
        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }
    private function getOrdersRefNum(string $orderId): string
    {
        $refData = $this->common->gettbldata([
            "order_id" => $orderId,
            'status' => 1,
            'reference_id' => 'PO',
        ], 'ref_value', 'tb_order_references', 0, 0);
        $refData = implode(", ", array_column($refData, 'ref_value'));
        return (!empty($refData)) ? $refData : '';
    }

}




