<?php

use App\Models\BillingmodelGetroletypelistInput;

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Billing extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['common','Order','billingmodel']);
        if (!checkUrlAccessForUser('BILLING')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(): void
    {
        $data = $post = $billIds = $where = $secondWhere = [];
        $data['page_title'] = $this->lang->line('billing');
        $data['sub_title'] = $this->lang->line('billing');
        $aconStatus = $toBeBilled = $totalRevAmount = 0;
        $formPost = $this->input->post(null, true);
        if (isset($formPost['searchsubmit']) && $formPost['searchsubmit'] === "Search") {
            $post = $formPost;
        }
        $orderJfr = $post['order_jfr'] ?? "";
        if (strlen($orderJfr) === 14) {
            $getBillingIds = $this->common->gettbldata(
                [
                    'type' => '0',
                    'debtor_jfr' => $orderJfr,
                    'invoice_status>' => '0',
                    'status' => '1',
                    'bill_id>' => '0',
                ],
                'bill_id',
                'tb_reveneus',
                0,
                0
            );
            $billIds[] = 0;
            foreach ($getBillingIds as $bill) {
                if ($bill['bill_id'] > 0) {
                    $billIds[] = $bill['bill_id'];
                }
            }
        } else {
            $billIds[] = 0;
        }
        if (!empty($post)) {
            $where = $this->searchbills($post);
            if (isset($post['search_billed']) && trim($post['search_billed']) !== "") {
                $toBeBilled = (int) $post['search_billed'];
            }
            if (isset($post['search_billparty']) && trim($post['search_billparty']) !== "") {
                $secondWhere['r.recipient_name'] = $post['search_billparty'];
            }
        }
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $data['bstatus'] = $data['bgroups'] = $data['bills'] = [];
        $getStatus = $this->billingmodel->getbillmasters('tb_billstatus_master');
        if ($getStatus->num_rows() > 0) {
            foreach ($getStatus->result() as $res) {
                $data['bstatus'][] = ['id' => $res->id, 'name' => $res->name];
            }
        }
        $getBillingGroups = $this->billingmodel->getbillmasters('tb_billgroup_master');
        if ($getBillingGroups->num_rows() > 0) {
            foreach ($getBillingGroups->result() as $grp) {
                $data['bgroups'][] = ['id' => $grp->id, 'name' => $grp->name];
            }
        }
        if ($toBeBilled === 1) {
            $getBilledId = $this->db->select("id")->get_where("tb_billstatus_master", ['name' => "Billed"]);
            if ($getBilledId->num_rows() > 0) {
                $where['b.invoice_status'] = $getBilledId->row()->id;
            }
        }
        if ($toBeBilled === 2) {
            $getBills = $this->billingmodel->gettobebilled($userId, $secondWhere);
        } elseif ($orderJfr !== "") {
            $getBills = $this->billingmodel->getbilldata($userId, $billIds, $where);
        } else {
            $getBills = $this->billingmodel->getbilldata($userId, [], $where);
        }

        if (!empty($getBills) && $toBeBilled !== 2) {
            foreach ($getBills as $bill) {
                $aconStatus = 0;
                $billsType = "";
                if ((int)$bill['bill_type'] === 1) {
                    $billsType = "Single";
                } elseif ((int)$bill['bill_type'] === 2) {
                    $billsType = "Bulk";
                }

                if ((int)$bill['acon_invoice_status'] === 1 || (int)$bill['acon_accrual_status'] === 1) {
                    $aconStatus = 1;
                }
                $aconInvoiceStatus = $bill['acon_invoice_status'];
                $aconAccrualStatus = $bill['acon_accrual_status'];
                $accrualRevtblSts = "";
                $billid = $bill['id'];
                if ($billid > 0) {
                    $getTotalAmount = $this->common->gettblrowdata(
                        ["bill_id" => $billid, 'status' => '1'],
                        "sum(amount) as amount",
                        "tb_reveneus",
                        0,
                        0
                    );
                    if (!empty($getTotalAmount)) {
                        $totalRevAmount = $getTotalAmount['amount'];
                    }
                    if ((int)$aconAccrualStatus === 0) {
                        $accrualRevtblSts = $this->billingmodel->getcoststatusfromrevenuetbl($billid);

                    }
                }
                $data['bills'][] = [
                    'id' => $bill['id'],
                    'tracking_no' => $bill['tracking_no'],
                    'bill_party' => $bill['bill_party'],
                    'bill_type' => $billsType,
                    'bill_group' => $bill['billgroup'],
                    'recipient_type' => $bill['recipient_type'],
                    'invoice_no' => $bill['invoice_no'],
                    'invoice_date' => $bill['invoice_date'],
                    'invoice_status' => $bill['billstatus'],
                    'acon_code' => $bill['acon_code'],
                    'currency' => $bill['currency'],
                    'customer_code' => $bill['customer_code'],
                    'code' => $bill['code'],
                    'company_code' => $bill['company_code'],
                    'branch_code' => $bill['branch_code'],
                    'department_code' => $bill['department_code'],
                    'status' => $bill['status'],
                    'acon_status' => $aconStatus,
                    'billedtype' => '0',
                    'acon_accrual_status' => $aconAccrualStatus,
                    'acon_invoice_status' => $aconInvoiceStatus,
                    'accrual_revtbl_sts' => $accrualRevtblSts,
                    'totalRevAmount' => $totalRevAmount,
                ];
            }
        } elseif (!empty($getBills) && $toBeBilled === 2) {
            foreach ($getBills as $bill) {
                $data['bills'][] = [
                    'id' => $bill['revcosid'],
                    'tracking_no' => $bill['order_id'],
                    'bill_party' => $bill['recipient_name'],
                    'bill_type' => "",
                    'bill_group' => "",
                    'recipient_type' => $bill['recipient_role'],
                    'invoice_no' => "",
                    'invoice_date' => "",
                    'invoice_status' => "",
                    'acon_code' => $bill['debtor_jfr'],
                    'currency' => $bill['currency'],
                    'customer_code' => "",
                    'code' => "",
                    'company_code' => $bill['company_code'],
                    'branch_code' => $bill['branch_code'],
                    'department_code' => "",
                    'status' => $bill['status'],
                    'acon_status' => 1,
                    'billedtype' => '2',
                    'acon_invoice_status' => '0',
                    'acon_accrual_status' => '0',
                    'accrual_revtbl_sts' => "",
                    'totalRevAmount' => $bill['amount'],
                ];
            }
        }

        $data['company_code'] = $companyCode;
        $data['branch_code'] = $branchCode;
        $data['master_billtype'] = "Svkonekt";
        $getMasterBillType = $this->db->select("bill_type")->get_where(
            "tb_branch_master",
            ['branch_code' => $branchCode, 'company_code' => $companyCode]
        );
        if ($getMasterBillType->num_rows() > 0) {
            $data['master_billtype'] = $getMasterBillType->row()->bill_type;
        }
        $this->newtemplate->dashboard("billing/index", $data);
    }

    public function searchbills(array $post): array
    {
        $whr = [];
        if (isset($post['search_billparty']) && $post['search_billparty'] != "") {
            $whr['b.bill_party'] = $post['search_billparty'];
        }
        if (isset($post['adv_billparty']) && $post['adv_billparty'] != "") {
            $whr['b.bill_party'] = $post['adv_billparty'];
        }
        if (isset($post['search_billtype']) && $post['search_billtype'] != "") {
            $whr['b.bill_type'] = $post['search_billtype'];
        }
        if (isset($post['search_invoiceno']) && $post['search_invoiceno'] != "") {
            $whr['b.invoice_no'] = $post['search_invoiceno'];
        }
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate = date('Y-m-d', strtotime($post['fromdate']));
            $whr['b.invoice_date >='] = $fromdate;
        }
        if (isset($post['todate']) && $post['todate'] != "") {
            $todate = date('Y-m-d', strtotime($post['todate']));
            $whr['b.invoice_date <='] = $todate;
        }
        if (isset($post['adv_shipmentno']) && $post['adv_shipmentno'] != "") {
            $whr['b.tracking_no'] = $post['adv_shipmentno'];
        }
        if (isset($post['adv_billtype']) && $post['adv_billtype'] != "") {
            $whr['b.bill_type'] = $post['adv_billtype'];
        }
        if (isset($post['bill_group']) && $post['bill_group'] != "") {
            $whr['b.bill_group'] = $post['bill_group'];
        }
        if (isset($post['adv_invoiceno']) && $post['adv_invoiceno'] != "") {
            $whr['b.invoice_no'] = $post['adv_invoiceno'];
        }
        if (isset($post['bill_status']) && $post['bill_status'] != "") {
            $whr['b.invoice_status'] = $post['bill_status'];
        }
        if (isset($post['customer_code']) && $post['customer_code'] != "") {
            $whr['b.customer_code'] = $post['customer_code'];
        }
        if (isset($post['cid']) && $post['cid'] != "") {
            $whr['b.code'] = $post['cid'];
        }
        if (isset($post['debitor_code']) && $post['debitor_code'] != "") {
            $whr['b.acon_code'] = $post['debitor_code'];
        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['b.company_code'] = $post['company_code'];
        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['b.branch_code'] = $post['branch_code'];
        }
        return $whr;
    }

    public function insertbilldata() {
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $data['status'] = 0;
        $curdt = date('Y-m-d H:i:s');
        $uid = $this->session->userdata('user_id');
        $bill_type = isset($post['bill_type']) ? $post['bill_type'] : 0;
        $bill_group = isset($post['bill_group']) ? $post['bill_group'] : 0;
        $customercode = isset($post['customercode']) ? $post['customercode'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        $partner_cid = isset($post['partner_cid']) ? $post['partner_cid'] : "";
        $debitor_code = isset($post['partner_debitor_code']) ? $post['partner_debitor_code'] : "";
        $department_code = isset($post['department_code']) ? $post['department_code'] : "";
        $invoice_no = isset($post['invoice_no']) ? $post['invoice_no'] : 1;
        $invoice_date = isset($post['invoice_date']) ? $post['invoice_date'] : "";
        $bill_status = isset($post['bill_status']) ? $post['bill_status'] : 0;
        $trackingno = isset($post['trackingno']) ? $post['trackingno'] : 0;
        $tracking_no = (isset($post['tracking_no']) && !empty($post['tracking_no'])) ? ($post['tracking_no']) : array();
        $recipienttype = isset($post['recipienttype']) ? $post['recipienttype'] : "";
        $currency = isset($post['currency']) ? $post['currency'] : "";
        $status = isset($post['status']) ? $post['status'] : 1;
        $name = isset($post['name']) ? $post['name'] : "";
        $bill_id = isset($post['billid']) ? $post['billid'] : ""; /* for credit and debit note */
        $full_amount = (isset($post['full_amount']) && !empty($post['full_amount'])) ? $post['full_amount'] : 0;
        $invoice_description = $this->input->post('invoice_description',TRUE);
        $groupname = "";
        $invoiceno = 0;
        if ($bill_group > 0) {
            $groupname = $this->billingmodel->getgroupname($bill_group);
        }
        if ($invoice_date != "") {
            $invoice_date = date("Y-m-d", strtotime($invoice_date));
        }
        $invoice_statusname = "";
        $getinvsts_name = $this->db->select("name")->get_where("tb_billstatus_master", array('id' => $bill_status));
        if ($getinvsts_name->num_rows() > 0) {
            $invoice_statusname = $getinvsts_name->row()->name;
        }
        if ($status > 1 && $invoice_statusname == "Open") {
            $get_billedid = $this->db->select("id")->get_where("tb_billstatus_master", array('name' => "Billed"));
            if ($get_billedid->num_rows() > 0) {
                $bill_status = $get_billedid->row()->id;
            }
        }
        if ($bill_id == "") {
            if ($trackingno > 0 || !empty($tracking_no)) {
                $insdata = array('revenue_id' => 0, 'tracking_no' => 0, 'bill_party' => $name, 'bill_type' => $bill_type, 'bill_group' => $bill_group, 'recipient_type' => $groupname, 'invoice_date' => $invoice_date, 'invoice_status' => $bill_status, 'acon_code' => $debitor_code, 'total_amount' => 0, 'currency' => $currency, 'customer_code' => $customercode, 'code' => $partner_cid, 'company_code' => $company_code, 'branch_code' => $branch_code, 'department_code' => $department_code, 'user_id' => $uid, 'status' => $status, 'created_on' => $curdt, 'updated_on' => $curdt,'invoice_description'=>$invoice_description);
                $ins = $this->db->insert("tbl_bills", $insdata);
                $billid = $this->db->insert_id();
                $invoiceno = $this->generateinvoiceno($billid, $uid);
                $upd = array('invoice_no' => $invoiceno);
                $updatecode = $this->billingmodel->updatedata('tbl_bills', $billid, $upd);
                $data['status'] = 1;
            }
        } else if ($bill_id > 0) {
            $chkparentbillid = $this->billingmodel->chkparentbillid($bill_id);
            if ($chkparentbillid > 0) {
                $insdata = array('revenue_id' => 0, 'tracking_no' => 0, 'bill_party' => $name, 'bill_type' => $bill_type, 'bill_group' => $bill_group, 'recipient_type' => $groupname, 'invoice_date' => $invoice_date, 'invoice_status' => $bill_status, 'acon_code' => $debitor_code, 'total_amount' => 0, 'currency' => $currency, 'customer_code' => $customercode, 'code' => $partner_cid, 'company_code' => $company_code, 'branch_code' => $branch_code, 'department_code' => $department_code, 'parent_billid' => $bill_id, 'user_id' => $uid, 'status' => $status, 'created_on' => $curdt, 'updated_on' => $curdt,'invoice_description'=>$invoice_description);
                $ins = $this->db->insert("tbl_bills", $insdata);
                $billid = $this->db->insert_id();
                $invoiceno = $this->generateinvoiceno($billid, $uid);
                $upd = array('invoice_no' => $invoiceno);
                $updatecode = $this->billingmodel->updatedata('tbl_bills', $billid, $upd);
                $upd = array('status' => 3); /* for parent bill */
                $updatests = $this->billingmodel->updatedata('tbl_bills', $bill_id, $upd);
                $data['status'] = 1;
            } else if ($chkparentbillid == 0) {
                $billid = $bill_id;
                $upd = array('invoice_date' => $invoice_date, 'status' => $status);
                $updatecode = $this->billingmodel->updatedata('tbl_bills', $billid, $upd);
                $invoiceno = $this->billingmodel->getinvoiceno($billid);
            }
        }
        if ($billid > 0) {
            if ($bill_id == "") {
                $updata = array("invoice_number" => $invoiceno, "invoice_date" => $invoice_date, "invoice_creation_date" => $curdt, "invoice_status" => "2", "bill_id" => $billid);
                if ($trackingno > 0 && $bill_type == "1") {
                    $updaterev = $this->db->where(array("id" => $trackingno))->update("tb_reveneus", $updata);
                } else if (!empty($tracking_no) && $bill_type == "2") {
                    foreach ($tracking_no as $ex) {
                        $ntrackingno[] = explode("_", $ex)[0];
                    }
                    $updaterev = $this->db->where_in("id", $ntrackingno)->update("tb_reveneus", $updata);
                }
            } else if ($bill_id > 0) {
                if ($status == 3 || $status == 4) {
                    $info = array('uid' => $uid, 'bill_id' => $bill_id, "invoiceno" => $invoiceno, 'name' => $name, 'billid' => $billid, 'status' => $status);
                    $generatenote = $this->generateCreditDebitnote($info);
                }
            }
        }
        echo json_encode($data);
    }

    public function generateinvoiceno($billid, $uid) {
        /* $countrynocode = $this->billingmodel->getcountrycode($uid); */

        $invoiceno = "";
        $company_code = $this->session->userdata('company_code');
        if ($company_code == "RUKN") {
            $countrynocode = $this->session->userdata("usr_tzone")['phone_code'];
            $idlength = strlen($billid);
            $id = $billid;
            if ($idlength == '1') {
                $id = "00000" . $id;
            } else if ($idlength == '2') {
                $id = "0000" . $id;
            } else if ($idlength == '3') {
                $id = "000" . $id;
            } else if ($idlength == '4') {
                $id = "00" . $id;
            } else if ($idlength == '5') {
                $id = "0" . $id;
            } else {
                $id = $id;
            }
            $invoiceno = $countrynocode . "9" . date('y') . date('W') . $id;
        } else {
            $invoiceno = $this->generatecountryinvoicenos($billid);
        }

        return $invoiceno;
    }

    public function generatecountryinvoicenos($id) {

        $invoiceno = "";
        $btype = "I";
        $chkbill_type = $this->common->gettblrowdata(array("id" => $id), "bill_group", "tbl_bills", 0, 0);
        if (!empty($chkbill_type)) {
            $bill_group = $chkbill_type['bill_group'];
            if ($bill_group > 0) {
                $chkbl_group = $this->common->gettblrowdata(array('id' => $bill_group, 'status' => '1'), "name", "tb_billgroup_master", 0, 0);
                if (!empty($chkbl_group)) {
                    $type = $chkbl_group['name'];
                    if (strtolower($type) == "invoice") {
                        $btype = "I";
                    } else if (strtolower($type) == "bill") {
                        $btype = "I";
                    } else if (strtolower($type) == "credit note") {
                        $btype = "C";
                    } else if (strtolower($type) == "debit note") {
                        $btype = "D";
                    }
                }
            }
        }
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if ($company_code != "") {
            $cntry_code = substr($company_code, 0, 2);
            $branch_officeno = "";
            $chkbno = $this->common->gettblrowdata(array('branch_code' => $branch_code, 'status' => '1'), "branch_officeno", "tb_branch_master", 0, 0);
            $nobo_no = "00";
            if (!empty($chkbno)) {
                $branch_officeno = $chkbno['branch_officeno'];
            }
            if ($branch_officeno != "" && $branch_officeno != 0) {
                $nobo_no = substr($branch_officeno, -2);
            }
            $bno = $nobo_no . $btype;
            $year = date('y');
            $mnth = date('m');
            /* series numbers */
            $series = "";
            $general = $cntry_code . $bno . $year . $mnth;
            $chk_recent = $this->db->query(
                "SELECT invoice_no
                        FROM tbl_bills
                        WHERE id < ? AND (invoice_no LIKE  ? AND company_code LIKE ?)
                        ORDER BY id DESC
                        LIMIT 1",
                [ $id, $general.'%', $company_code ]
            );
            if ($chk_recent->num_rows() > 0) {
                $inv_no = $chk_recent->row()->invoice_no;
                $prev_series = substr($inv_no, 9, 5);
                $nozeros = ltrim($prev_series, 0);
                $serieslength = strlen($nozeros);
                $nozeros++;
                $series = $nozeros;
                $newserieslength = strlen($series);
                if ($newserieslength == '1') {
                    $series = "0000" . $nozeros;
                } else if ($newserieslength == '2') {
                    $series = "000" . $nozeros;
                } else if ($newserieslength == '3') {
                    $series = "00" . $nozeros;
                } else if ($newserieslength == '4') {
                    $series = "0" . $nozeros;
                } else {
                    $series = $nozeros;
                }
            } else {
                $series = "00001";
            }
            $invoiceno = $general . $series;
            $chkinv = $this->billingmodel->getrecentorinvoiceid($company_code,$invoiceno);
            if($chkinv->num_rows() >0){
                $inv_no = $chkinv->row()->invoice_no;
                $prev_series = substr($inv_no, 9, 5);
                $nozeros = ltrim($prev_series, 0);
                $serieslength = strlen($nozeros);
                $nozeros++;
                $series = $nozeros;
                $newserieslength = strlen($series);
                if ($newserieslength == '1') {
                    $series = "0000" . $nozeros;
                } else if ($newserieslength == '2') {
                    $series = "000" . $nozeros;
                } else if ($newserieslength == '3') {
                    $series = "00" . $nozeros;
                } else if ($newserieslength == '4') {
                    $series = "0" . $nozeros;
                } else {
                    $series = $nozeros;
                }
                $invoiceno = $general . $series;
            }
        }
        return $invoiceno;

    }

    public function editbill($id) {

        if ($id != "") {
            $data = $tobebilled = $whr = $billed = array();
            $data['page_title'] = $this->lang->line('billing');
            $data['sub_title'] = $this->lang->line('general_edit');
            $data['company_code'] = $this->session->userdata('company_code');
            $data['branch_code'] = $this->session->userdata('branch_code');
            $userid = $this->session->userdata("user_id");
            $custid = $this->session->userdata("cust_id");
            $country_userids = $this->session->userdata("country_user_ids");
            $data['bstatus'] = $data['bgroups'] = array();
            $billtype = 1;
            $status = 1;
            $getstatus = $this->billingmodel->getbillmasters('tb_billstatus_master');
            if ($getstatus->num_rows() > 0) {
                foreach ($getstatus->result() as $res) {
                    $data['bstatus'][] = array('id' => $res->id, 'name' => $res->name);
                }
            }
            $getbgroups = $this->billingmodel->getbillmasters('tb_billgroup_master');
            if ($getbgroups->num_rows() > 0) {
                foreach ($getbgroups->result() as $grp) {
                    if (in_array($grp->name, ['Invoice', 'Bill'])) {
                        $data['bgroups'][] = array('id' => $grp->id, 'name' => $grp->name);
                    }
                }
            }
            $getbilled = $this->billingmodel->getbilleddata($id, $userid);
            $code = "";
            if (!empty($getbilled)) {
                $code = $getbilled['code'];
                $status = $getbilled['status'];
                $billtype = $getbilled['bill_type'];
                $billed = array('billid' => $getbilled['id'], 'revenue_id' => $getbilled['revenue_id'], 'tracking_no' => $getbilled['tracking_no'], 'bill_party' => $getbilled['bill_party'], 'bill_type' => $getbilled['bill_type'], 'bill_group' => $getbilled['bill_group'], 'recipient_type' => $getbilled['recipient_type'], 'invoice_no' => $getbilled['invoice_no'], 'invoice_date' => $getbilled['invoice_date'], 'invoice_status' => $getbilled['invoice_status'], 'acon_code' => $getbilled['acon_code'], 'customer_code' => $getbilled['customer_code'], 'code' => $code, 'company_code' => $getbilled['company_code'], 'branch_code' => $getbilled['branch_code'], 'department_code' => $getbilled['department_code'], 'status' => $status,'invoice_description'=>$getbilled['invoice_description']);
            }
            $whr['status'] = $status;
            $whr['bill_id'] = $id;
            $whr['code'] = $code;
            $gettobebilled = $this->billingmodel->gettobebilledandbilled($userid, $custid, $country_userids, $whr);
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    $tripsts = "";
                    $cross_leg_id = 0;
                    $trip_id = isset($res['trip_id']) ? $res['trip_id'] : "0";
                    $shift_id = isset($res['shift_id']) ? $res['shift_id'] : "0";
                    if($trip_id == 0){
                        $getshift = $this->common->gettbldata(array('shift_leg_id' => $shift_id), 'id', 'tb_shifts', 0, 0);
                        if(!empty($getshift)){
                            $leg_ids = array();
                            foreach($getshift as $shft){
                                $leg_ids[] = $shft['id'];
                            }
                            if(!empty($leg_ids)){
                                $cross_leg_id = 1;
                                $gettripsids = $this->billingmodel->checkdriveracceptsfornewtrips($leg_ids);
                                if(!empty($gettripsids)){
                                    $acceptence = 1;
                                    $new_trip_id = 0;
                                    foreach ($gettripsids as $trps){
                                        $trip_row_id = $trps['trip_id'];
                                        if($trip_row_id >0){
                                            $new_trip_id = $trip_row_id;
                                        }else{
                                            $acceptence = 0;
                                        }
                                    }
                                    if($acceptence == 0){
                                        $tripsts = "<input type='hidden' name='noorder_trip_sts' id='".$res['revcosid']."' class='noorder_trip_sts' value='".$new_trip_id."'>";
                                    }else{
                                        $tripsts = "<input type='hidden' name='order_trip_sts' id='".$res['revcosid']."' class='order_trip_sts' value='".$new_trip_id."'>";
                                    }
                                }
                            }
                        }
                    }
                    if ($res['bill_id'] == $id) {
                        $tobebilled[] = array('revcosid' => $res['revcosid'], 'recipient_role' => $res['recipient_role'], 'billtype' => $billtype, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'bill_id' => $res['bill_id'], 'trip_id'=>$trip_id, 'createdon' => date("Y-m-d", strtotime($res['createdon'])),'cross_leg_id'=>$cross_leg_id,'tripsts'=>$tripsts);
                    }
                    if ($res['bill_id'] == 0 && $res['invoice_status'] == 1) {
                        $tobebilled[] = array('revcosid' => $res['revcosid'], 'recipient_role' => $res['recipient_role'], 'billtype' => $billtype, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'bill_id' => $res['bill_id'],'trip_id'=>$trip_id,  'createdon' => date("Y-m-d", strtotime($res['createdon'])),'cross_leg_id'=>$cross_leg_id,'tripsts'=>$tripsts);
                    }
                }
            }
            $data['tobebilled'] = $tobebilled;
            $data['billed'] = $billed;
            $data['ref_names_arr'] = $this->Order->getrefnums();
            $this->load->view('billing/editbill',$data);
            //$this->newtemplate->dashboard("billing/editbill", $data);
        } else {
            redirect('billing');
        }

    }

    public function viewbill($id) {
        if ($id != "") {
            $data = $tobebilled = $whr = $billed = array();
            $data['page_title'] = $this->lang->line('billing');
            $data['sub_title'] = $this->lang->line('general_view');
            $data['company_code'] = $this->session->userdata('company_code');
            $data['branch_code'] = $this->session->userdata('branch_code');
            $userid = $this->session->userdata("user_id");
            $custid = $this->session->userdata("cust_id");
            $country_userids = $this->session->userdata("country_user_ids");
            $data['bstatus'] = $data['bgroups'] = array();
            $billtype = 1;
            $status = 1;
            $parent_billid = 0;
            $getstatus = $this->billingmodel->getbillmasters('tb_billstatus_master');
            if ($getstatus->num_rows() > 0) {
                foreach ($getstatus->result() as $res) {
                    $data['bstatus'][] = array('id' => $res->id, 'name' => $res->name);
                }
            }
            $getbgroups = $this->billingmodel->getbillmasters('tb_billgroup_master');
            if ($getbgroups->num_rows() > 0) {
                foreach ($getbgroups->result() as $grp) {
                    $data['bgroups'][] = array('id' => $grp->id, 'name' => $grp->name);
                }
            }
            $getbilled = $this->billingmodel->getbilleddata($id, $userid);
            $code = "";
            if (!empty($getbilled)) {
                $code = $getbilled['code'];
                $status = $getbilled['status'];
                $billtype = $getbilled['bill_type'];
                $parent_billid = $getbilled['parent_billid'];
                $billed = array('billid' => $getbilled['id'], 'revenue_id' => $getbilled['revenue_id'], 'tracking_no' => $getbilled['tracking_no'], 'bill_party' => $getbilled['bill_party'], 'bill_type' => $getbilled['bill_type'], 'bill_group' => $getbilled['bill_group'], 'recipient_type' => $getbilled['recipient_type'], 'invoice_no' => $getbilled['invoice_no'], 'invoice_date' => $getbilled['invoice_date'], 'invoice_status' => $getbilled['invoice_status'], 'acon_code' => $getbilled['acon_code'], 'customer_code' => $getbilled['customer_code'], 'code' => $code, 'company_code' => $getbilled['company_code'], 'branch_code' => $getbilled['branch_code'], 'department_code' => $getbilled['department_code'], 'status' => $status,'invoice_description'=>$getbilled['invoice_description']);
            }
            if ($parent_billid == 0) {
                $parent_billid = $id;
            }
            $whr['status'] = $status;
            $whr['bill_id'] = $parent_billid;
            $whr['code'] = $code;
            $gettobebilled = $this->billingmodel->gettobebilledandbilled($userid, $custid, $country_userids, $whr);
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    if ($res['bill_id'] == $parent_billid) {
                        $tobebilled[] = array('revcosid' => $res['revcosid'], 'recipient_role' => $res['recipient_role'], 'billtype' => $billtype, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'bill_id' => $res['bill_id'], 'createdon' => date("Y-m-d", strtotime($res['createdon'])));
                    }
                }
            }
            $data['tobebilled'] = $tobebilled;
            $data['billed'] = $billed;
            //$this->newtemplate->dashboard("billing/viewdetails", $data);
            $this->load->view('billing/viewdetails',$data);
        } else {
            redirect('billing');
        }
    }

    public function updatebill() {
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $data['status'] = 0;
        $curdt = date('Y-m-d H:i:s');
        $uid = $this->session->userdata('user_id');
        $bill_type = isset($post['bill_type']) ? $post['bill_type'] : 0;
        $bill_group = isset($post['bill_group']) ? $post['bill_group'] : 0;
        $customercode = isset($post['customercode']) ? $post['customercode'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        $partner_cid = isset($post['partner_cid']) ? $post['partner_cid'] : "";
        $debitor_code = isset($post['partner_debitor_code']) ? $post['partner_debitor_code'] : "";
        $department_code = isset($post['department_code']) ? $post['department_code'] : "";
        $invoice_no = isset($post['invoice_no']) ? $post['invoice_no'] : 1;
        $invoice_date = isset($post['invoice_date']) ? $post['invoice_date'] : "";
        $bill_status = isset($post['bill_status']) ? $post['bill_status'] : 0;
        $trackingno = isset($post['trackingno']) ? $post['trackingno'] : 0;
        $tracking_no = (isset($post['tracking_no']) && !empty($post['tracking_no'])) ? ($post['tracking_no']) : array();
        $recipienttype = isset($post['recipienttype']) ? $post['recipienttype'] : "";
        $currency = isset($post['currency']) ? $post['currency'] : "";
        /* $countrycode = $this->billingmodel->getcountrycode($uid); */
        $countrynocode = $this->session->userdata("usr_tzone")['phone_code'];
        $name = isset($post['name']) ? $post['name'] : "";
        $billid = isset($post['billid']) ? $post['billid'] : 0;
        $status = isset($post['status']) ? $post['status'] : 1;
        $invoice_description = $this->input->post("invoice_description",TRUE);
        $groupname = "";
        if ($billid > 0 && $invoice_no == 1) {
            $checkbill = $this->common->gettblrowdata(array('id' => $billid), 'invoice_no', 'tbl_bills', 0, 0);
            if (!empty($checkbill)) {
                $invoice_no = $checkbill['invoice_no'];
            }
        }
        if ($bill_group > 0) {
            $groupname = $this->billingmodel->getgroupname($bill_group);
        }
        if ($invoice_date != "") {
            $invoice_date = date("Y-m-d", strtotime($invoice_date));
        }
        $invoice_statusname = "";
        $getinvsts_name = $this->db->select("name")->get_where("tb_billstatus_master", array('id' => $bill_status));
        if ($getinvsts_name->num_rows() > 0) {
            $invoice_statusname = $getinvsts_name->row()->name;
        }
        if ($status > 1 && $invoice_statusname == "Open") {
            $get_billedid = $this->db->select("id")->get_where("tb_billstatus_master", array('name' => "Billed"));
            if ($get_billedid->num_rows() > 0) {
                $bill_status = $get_billedid->row()->id;
            }
        }
        if ($trackingno > 0 || !empty($tracking_no)) {
            $insdata = array('revenue_id' => 0, 'tracking_no' => 0, 'bill_party' => $name, 'bill_type' => $bill_type, 'bill_group' => $bill_group, 'recipient_type' => $groupname, 'invoice_date' => $invoice_date, 'invoice_status' => $bill_status, 'acon_code' => $debitor_code, 'total_amount' => 0, 'currency' => $currency, 'customer_code' => $customercode, 'code' => $partner_cid, 'company_code' => $company_code, 'branch_code' => $branch_code, 'department_code' => $department_code, 'user_id' => $uid, 'status' => $status, 'updated_on' => $curdt,'invoice_description'=>$invoice_description);

            $update = $this->db->where(array("id" => $billid))->update("tbl_bills", $insdata);
            if ($billid > 0) {
                $this->db->where(array("bill_id" => $billid))->update("tb_reveneus", array("invoice_number" => "", "invoice_date" => "", "invoice_creation_date" => "", "invoice_creation_date" => "", "invoice_status" => 1, "bill_id" => 0));
                if ($trackingno > 0 && $bill_type == "1") {
                    $this->db->where(array("id" => $trackingno))->update("tb_reveneus", array("invoice_number" => $invoice_no, "invoice_date" => $invoice_date, "invoice_creation_date" => $curdt, "invoice_status" => 2, "bill_id" => $billid));
                } else if (!empty($tracking_no) && $bill_type == "2") {
                    foreach ($tracking_no as $ex) {
                        $ntrackingno[] = explode("_", $ex)[0];
                    }
                    $this->db->where_in("id", $ntrackingno)->update("tb_reveneus", array("invoice_number" => $invoice_no, "invoice_date" => $invoice_date, "invoice_creation_date" => $curdt, "invoice_status" => 2, "bill_id" => $billid));
                }
            }
            $data['status'] = 1;
        }
        echo json_encode($data);
    }

    public function updatecreditdebitnote() {
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $data['status'] = $parent_billid = 0;
        $curdt = date('Y-m-d H:i:s');
        $uid = $this->session->userdata('user_id');
        $invoice_date = isset($post['invoice_date']) ? $post['invoice_date'] : "";
        $billid = isset($post['billid']) ? $post['billid'] : 0;
        $status = isset($post['status']) ? $post['status'] : 3;
        $invoice_no = $bill_party = "";
        $checkbill = $this->common->gettblrowdata(array('id' => $billid), 'invoice_no,parent_billid,bill_party', 'tbl_bills', 0, 0);
        if (!empty($checkbill)) {
            $invoice_no = $checkbill['invoice_no'];
            $parent_billid = $checkbill['parent_billid'];
            $bill_party = $checkbill['bill_party'];
        }
        if ($invoice_date != "") {
            $invoice_date = date("Y-m-d", strtotime($invoice_date));
        }
        if ($billid > 0) {
            $insdata = array('invoice_date' => $invoice_date, 'user_id' => $uid, 'status' => $status, 'updated_on' => $curdt);
            $update = $this->db->where(array("id" => $billid))->update("tbl_bills", $insdata);
            if ($parent_billid > 0) {
                if ($status == 3 || $status == 4) {
                    $info = array('uid' => $uid, 'bill_id' => $billid, "invoiceno" => $invoice_no, 'name' => $bill_party, 'billid' => $billid, 'status' => $status);
                    $generatenote = $this->generateCreditDebitnote($info);
                }
            }
            $data['status'] = 1;
        }
        echo json_encode($data);
    }

    public function newbill() {
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $data = $tobebilled = $whr = array();
        $data['page_title'] = $this->lang->line('billing');
        $data['sub_title'] = $this->lang->line('general_new');
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $data['bstatus'] = $data['bgroups'] = array();
        $getstatus = $this->billingmodel->getbillmasters('tb_billstatus_master');
        if ($getstatus->num_rows() > 0) {
            foreach ($getstatus->result() as $res) {
                $data['bstatus'][] = array('id' => $res->id, 'name' => $res->name);
            }
        }
        $getbgroups = $this->billingmodel->getbillmasters('tb_billgroup_master');
        if ($getbgroups->num_rows() > 0) {
            foreach ($getbgroups->result() as $grp) {
                if (in_array($grp->name, ['Invoice', 'Bill'])) {
                    $data['bgroups'][] = array('id' => $grp->id, 'name' => $grp->name);
                }
            }
        }
        $data['ref_names_arr'] = $this->Order->getrefnums();
        $this->load->view('billing/addbill',$data);
        //$this->newtemplate->dashboard("billing/addbill", $data);
    }

    public function creditdebitnote($id) {
        if ($id != "") {
            $data = $tobebilled = $whr = $billed = array();
            $data['page_title'] = "Credit/Debit Note";
            $data['sub_title'] = "Bill";
            $data['company_code'] = $this->session->userdata('company_code');
            $data['branch_code'] = $this->session->userdata('branch_code');
            $userid = $this->session->userdata("user_id");
            $custid = $this->session->userdata("cust_id");
            $country_userids = $this->session->userdata("country_user_ids");
            $data['bstatus'] = $data['bgroups'] = array();
            $billtype = 1;
            $status = 1;
            $parent_billid = 0;
            $getstatus = $this->billingmodel->getbillmasters('tb_billstatus_master');
            if ($getstatus->num_rows() > 0) {
                foreach ($getstatus->result() as $res) {
                    $data['bstatus'][] = array('id' => $res->id, 'name' => $res->name);
                }
            }
            $getbgroups = $this->billingmodel->getbillmasters('tb_billgroup_master');
            if ($getbgroups->num_rows() > 0) {
                foreach ($getbgroups->result() as $grp) {
                    $data['bgroups'][] = array('id' => $grp->id, 'name' => $grp->name);
                }
            }
            $recipient_type = "";
            $chkchildnoteid = $this->billingmodel->getchildnoteid($id);
            if ($chkchildnoteid > 0) {
                $id = $chkchildnoteid;
            }
            $getbilled = $this->billingmodel->getbilleddata($id, $userid);
            $code = "";
            if (!empty($getbilled)) {
                $code = $getbilled['code'];
                $status = $getbilled['status'];
                $billtype = $getbilled['bill_type'];
                $parent_billid = $getbilled['parent_billid'];
                $recipient_type = $getbilled['recipient_type'];
                $billed = array('billid' => $getbilled['id'], 'revenue_id' => $getbilled['revenue_id'], 'tracking_no' => $getbilled['tracking_no'], 'bill_party' => $getbilled['bill_party'], 'bill_type' => $getbilled['bill_type'], 'bill_group' => $getbilled['bill_group'], 'recipient_type' => $getbilled['recipient_type'], 'invoice_no' => $getbilled['invoice_no'], 'invoice_date' => $getbilled['invoice_date'], 'invoice_status' => $getbilled['invoice_status'], 'acon_code' => $getbilled['acon_code'], 'customer_code' => $getbilled['customer_code'], 'code' => $code, 'company_code' => $getbilled['company_code'], 'branch_code' => $getbilled['branch_code'], 'department_code' => $getbilled['department_code'], 'status' => $status);
            }
            if ($parent_billid == 0) {
                $parent_billid = $id;
            }
            $whr['status'] = $status;
            $whr['bill_id'] = $parent_billid;
            $whr['code'] = $code;
            $data['order_id'] = array();
            $gettobebilled = $this->billingmodel->gettobebilledandbilled($userid, $custid, $country_userids, $whr); /*
              log_message("error","query2 -".$this->db->last_query()); */
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    $data['order_id'][] = $res['order_id'];
                    if ($res['bill_id'] == $parent_billid) {
                        $tobebilled[] = array('revcosid' => $res['revcosid'], 'recipient_role' => $res['recipient_role'], 'billtype' => $billtype, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'bill_id' => $res['bill_id'], 'createdon' => date("Y-m-d", strtotime($res['createdon'])));
                    }
                }
            }
            $data['groupname'] = "";
            if ($recipient_type != "") {
                if ($recipient_type == "Customer") {
                    $data['groupname'] = "Credit Note";
                } else {
                    $data['groupname'] = "Debit Note";
                }
            }
            $data['tobebilled'] = $tobebilled;
            $data['billed'] = $billed;
            if ($status >= 2) {
                $this->load->view('billing/creditdebitnote',$data);
                //$this->newtemplate->dashboard("billing/creditdebitnote", $data);
            } else {
                redirect('billing');
            }
        } else {
            redirect('billing');
        }
    }

    public function deletebill($id) {
        if ($id != '' || $id != 0) {
            $chk = $this->db->select('id')->get_where("tbl_bills", array('id' => $id, 'parent_billid' => 0));
            $chkparent = $this->db->select('id,parent_billid')->get_where("tbl_bills", array('id' => $id, 'parent_billid >' => 0));
            if ($chk->num_rows() > 0) {
                $upd = $this->db->where(array('id' => $id))->update('tbl_bills', array('status' => 0));
                $upd_revenue = $this->db->where(array('bill_id' => $id))->update('tb_reveneus', array('invoice_number' => 0, 'invoice_date' => "0000-00-00 00:00:00", 'invoice_creation_date' => "0000-00-00 00:00:00", 'invoice_receivdon_date' => "0000-00-00 00:00:00", 'invoice_status' => 1, 'bill_id' => 0));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else if ($chkparent->num_rows() > 0) {
                $parent_billid = $chkparent->row()->parent_billid;
                $upd = $this->db->where(array('id' => $parent_billid))->update('tbl_bills', array('status' => 2));
                $upd = $this->db->where(array('id' => $id))->update('tbl_bills', array('parent_billid' => 0, 'status' => 0));
                $upd_revenue = $this->db->where(array('bill_id' => $id))->update('tb_reveneus', array('status' => 0));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        }
    }

public function getcharges_old(){
 $rev_costid = $this->input->post('rev_costid',TRUE);
 $result = $chargecodeids =array();
 $getcharges = $this->billingmodel->getcharges($rev_costid);
 $chargeid_amount = array();
 if(!empty($getcharges)){
     foreach ($getcharges as $charge) {
         $chargecodeids[] = $charge['chargecodeid'];
         $chargeid = $charge['chargecodeid'];
         $chargeid_amount[$chargeid] = $charge['amount']."||".$charge['currency'];
         $result[] = array('charge_code'=>$charge['charge_code'],'description'=>$charge['description'],'amount'=>$charge['amount'],'currency'=>$charge['currency']);
     }
     $this->db->select("r.recipient_role,r.recipient_code,od.pickup_country,od.delivery_country");
     $this->db->from("tb_reveneus r");
     $this->db->join('tb_orders od', 'od.id = r.order_id', 'left');
     $this->db->where("r.id", $rev_costid);
     $this->db->where("r.status", 1);
     $this->db->limit(1);
     $getorderdetails = $this->db->get();
     if($getorderdetails->num_rows() >0){
         $orderdetails = $getorderdetails->row_array();
     }
     if(!empty($orderdetails)){
         $custidentifier = $this->billingmodel->gettblrowdata(array("code"=>$orderdetails['recipient_code']),"customeridentifier","tbl_party_master",0,0);
         if(!empty($custidentifier)){
             if($orderdetails['recipient_role'] == "Customer"){
                 $where = array("v.customeridentifier"=>$custidentifier['customeridentifier'],"l.source_country"=>$orderdetails['pickup_country'],"l.destination_country"=>$orderdetails['delivery_country']);
             }else{
                 $where = array("v.vendoridentifier"=>$custidentifier['customeridentifier'],"l.source_country"=>$orderdetails['pickup_country'],"l.destination_country"=>$orderdetails['delivery_country']);
             }
             $vatdetails = array();
             $this->db->select("v.name,lv.charge_id,lv.vat,c.charge_code");
             $this->db->from("tbl_vat_master v");
             $this->db->join('tbl_lanes l', 'l.vatid = v.id', 'left');
             $this->db->join('tbl_lane_vat lv', 'lv.lane_id = l.id', 'left');
             $this->db->join('tb_charge_codes c', 'c.id = lv.charge_id', 'left');
             $this->db->where($where);
             $this->db->where_in("c.id", $chargecodeids);
             $this->db->where("v.status", 1);
             $this->db->where("l.status", 1);
             $this->db->where("lv.status", 1);
             $getvatdetails = $this->db->get();
             if($getvatdetails->num_rows() > 0){
                 $vatdetails = $getvatdetails->result_array();
             }
                  /* log_message("error","vatdetails --".json_encode($vatdetails));
                  log_message("error","Query --".$this->db->last_query());*/
                  if(!empty($vatdetails)){
                     foreach ($vatdetails as $vatdata) {
                         $vatchargeid = $vatdata['charge_id'];
                         if(isset($chargeid_amount[$vatchargeid])){
                             $vatamt_currency = explode("||",$chargeid_amount[$vatchargeid]);
                             $vat_amount = 0;
                             $vat_currency = "";
                             if(isset($vatamt_currency[0])){
                                 $vat_amount = $vatamt_currency[0];
                             }
                             if(isset($vatamt_currency[1])){
                                 $vat_currency = $vatamt_currency[1];
                             }
                             $description = $vatdata['name']." ".$vatdata['vat']." %";
                             $amount = ($vatdata['vat'] * $vat_amount)/100;
                             $result[] = array('charge_code'=>"TAX",'description'=>$description,'amount'=>$amount ,'currency'=>$vat_currency);
                         }
                     }
                  }
              }
          }
      }
      echo json_encode($result);
  }

    public function getcharges() {
        $post_row_id = $this->input->post('rev_costid', TRUE);
        $result = $chargecodeids = array();
        $session_companycode = $this->session->userdata('company_code');
        $rev_costid[] = $post_row_id;
        $getcharges = $this->billingmodel->getchargeswithorder_ids($rev_costid);
        $chargeid_amount = array();
        if (!empty($getcharges)) {
            foreach ($getcharges as $charge) {
                $local_amount = $charge['local_amount'];
                $final_amount = $charge['amount'];
                $final_currency = $charge['currency'];
                $order_id       = $charge['order_id'];
                if($local_amount >0){
                    $final_amount = $local_amount;
                    $final_currency = $charge['local_currency'];
                }
                if ($charge['amount'] > 0) {
                    $result[] = array('charge_code' => $charge['charge_code'], 'description' => $charge['description'], 'amount' => $final_amount, 'currency' => $final_currency,'order_id'=>$order_id);
                }
                if ($charge['vat_percentage'] > 0 && $charge['vat_amount'] > 0) {
                    $final_amount = $charge['local_vat_amount'];
                    if($final_amount >0){
                    }else{
                        $final_amount = $charge['vat_amount'];
                    }
                    $description = $charge['charge_code'] . " " . $charge['vat_percentage'] . " %";
                    $vat_name = "VAT";
                    if($session_companycode == "SGKN"){
                        $vat_name = "GST";
                    }
                    $result[] = array('charge_code' => $vat_name, 'description' => $description, 'amount' => $final_amount, 'currency' => $final_currency,'order_id'=>$order_id);
                }
            }
        }
        echo json_encode($result);
    }

    public function getchargesfornotes() {
        $rev_costid = $this->input->post('rev_costid', TRUE);
        $status = $this->input->post('status', TRUE);
        $result = array();
        $getcharges = $this->billingmodel->getcharges($rev_costid);
        if (!empty($getcharges)) {
            foreach ($getcharges as $charge) {
                if ($status == 2 || $status == 3) {
                    $amount = "<input type='number' class='revisedamount' name='revisedamount' id='revisedamount' value='" . $charge['revised_amount'] . "' min='0.1' onkeypress='return isNumber(event,this)'>";
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'><a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='chargesave' type='button' class='btn btn-sm btn-default'  ><span class='glyphicon glyphicon-ok'></span>save</a></li></ul></li></ul>";
                } else {
                    $amount = $charge['revised_amount'];
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'><a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a></li></ul>";
                }
                $result[] = array('id' => $charge['id'], 'charge_code' => $charge['charge_code'], 'description' => $charge['description'], 'amount' => $charge['amount'], 'revisedamount' => $amount, 'currency' => $charge['currency'], 'action' => $action);
            }
        }
        echo json_encode($result);
    }

    public function updatecharges() {
        $session_companycode = $this->session->userdata('company_code');
        $user_currency = $this->session->userdata("usr_tzone")['currency'];
        $chargeid = $this->input->post('chargeid', TRUE);
        $revisedamount = $this->input->post('revisedamount', TRUE);
        if ($revisedamount == "0") {
            $revisedamount = 0;
        }
        $result = array();
        $result['status'] = 0;
        if ($chargeid > 0) {
            $charge_amount = round($revisedamount,4);
            if($session_companycode == "VNKN"){
                $getcharges = $this->common->gettblrowdata(array('id'=>$chargeid),"currency",'tb_charges',0,0);
                if(!empty($getcharges)){
                    $charge_currency = $getcharges['currency'];
                    if($charge_currency == $user_currency){
                        $charge_amount = round($revisedamount);
                    }
                }
            }
            $update = $this->db->where(array("id" => $chargeid))->update("tb_charges", array("revised_amount" => $charge_amount));
            if ($update) {
                $result['status'] = 1;
            }
        }
        echo json_encode($result);
    }

    public function updatenotestatus() {
        $billid = $this->input->post('billid', TRUE);
        $result = array();
        $result['status'] = 0;
        if ($billid > 0) {
            $update = $this->db->where(array("id" => $billid))->update("tbl_bills", array("status" => 3));
            if ($update) {
                $result['status'] = 1;
            }
        }
        echo json_encode($result);
    }

    public function getcustomercodes() {
        $custcode = isset($_REQUEST["custcode"]) ? $_REQUEST["custcode"] : "";
        $partytype = isset($_REQUEST["type"]) ? $_REQUEST["type"] : "";
        $data = array();
        if ($custcode != "" && $partytype != "") {
            $uid = $this->session->userdata('user_id');
            $company_code = $this->session->userdata('company_code');
            $this->db->select("m.customer_code");
            $this->db->from("tbl_party_master m");
            $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
            $this->db->where("p.name", $partytype);
            $this->db->like("m.customer_code", $custcode);
            $this->db->where("m.user_id", $uid);
            $this->db->where("p.user_id", $uid);
            $getcustcode = $this->db->get();
            if ($getcustcode->num_rows() > 0) {
                foreach ($getcustcode->result() as $custcodes) {
                    $data[] = $custcodes->customer_code;
                }
            }
        }
        echo json_encode($data);
    }

    public function getcustomerdetails() {
        $data = $tobebilled = array();
        $custcode = $this->input->post('id', TRUE);
        $type = $this->input->post('type', TRUE);
        $customer_code = 0;
        $user_id = $this->session->userdata('user_id');
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $company_code = $this->session->userdata('company_code');
        $chkqry = $this->db->select("name,code,branch_code,department_code,acon_debitor_code")->get_where("tbl_party_master", array('customer_code' => $custcode, 'user_id' => $user_id));

        if ($chkqry->num_rows() > 0) {
            $customer_code = $chkqry->row()->code;
            $data = array('name' => $chkqry->row()->name, 'code' => $chkqry->row()->code, 'branch_code' => $chkqry->row()->branch_code, 'department_code' => $chkqry->row()->department_code, 'acon_debitor_code' => $chkqry->row()->acon_debitor_code);
        }
        if ($customer_code != "") {
            $whr = array();
            $whr['r.recipient_role'] = $type;
            $whr['r.recipient_code'] = $customer_code;
            $gettobebilled = $this->billingmodel->gettobebilled($user_id, $whr);
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    $concatid = $res['revcosid'] . "_" . $res['recipient_role'] . "_" . $res['currency'];
                    $recipient_role = $res['recipient_role'];
                    $currency = $res['currency'];
                    $rev_cosid = $res['revcosid'];
                    $tdvalue = "<input type='hidden' form='bill_data' name='recipienttype' class='recipienttype' value='" . $recipient_role . "' ><input type='hidden' form='bill_data' name='currency' class='currency' value='" . $currency . "' ><input type='checkbox' form='bill_data' name='tracking_no[]' class='tracking_no' value='" . $concatid . "' style='display:none;'><input type='radio' form='bill_data' name='trackingno' class='trackingno' value= '" . $rev_cosid . "'' >";
                    $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency);
                }
            }
        }
        $data['tobebilled'] = $tobebilled;
        echo json_encode($data);
    }

    /**
     * @deprecated
     */
    public function viewroletypelist2() {
        $data = array();
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $type = isset($post['type']) ? $post['type'] : "";
        if ($type != "") {
            $user_id = $this->session->userdata('user_id');
            if ($user_id != '0') {
                if ($type == "Customer") {
                    $getroles = $this->db->query(
                        "SELECT id,name,code,email_id,company_code,branch_code
                                FROM tb_customers
                                WHERE user_id =?
                                ORDER by id DESC",
                        [$user_id]
                    );
                    if ($getroles->num_rows() > 0) {
                        foreach ($getroles->result() as $res) {
                            $data[] = array('check' => "<input class='rolelist' type='radio' name='selectrole' id='rolelist_" . $res->id . "' value='" . $res->code . "' onchange=selectrolebyid(" . $res->id . ")>", 'id' => $res->id, 'code' => $res->code, 'name' => $res->name, 'email_id' => $res->email_id, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code);
                        }
                    }
                } else if ($type == "Vendor") {
                    $getroles = $this->db->query(
                        "SELECT id,name,email,code,company_code,branch_code
                                FROM tb_vendors
                                WHERE user_id = ?
                                ORDER by id DESC",
                        [$user_id]
                    );
                    if ($getroles->num_rows() > 0) {
                        foreach ($getroles->result() as $res) {
                            $data[] = array('check' => "<input class='vendorlist' type='radio' name='selectvendor' id='vendorlist_" . $res->id . "' value='" . $res->code . "' onchange=selectvendorbyid(" . $res->id . ")>", 'id' => $res->id, 'code' => $res->code, 'name' => $res->name, 'email_id' => $res->email, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code);
                        }
                    }
                } else if ($type == "Overseas OL" || $type == "Internal BU") {
                    $this->db->select("m.id,m.name,m.email,m.code,m.company_code,m.branch_code");
                    $this->db->from("tbl_party_master m");
                    $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
                    $this->db->like("p.name", $type);
                    $this->db->where("m.user_id", $user_id);
                    $getroles = $this->db->get();
                    if ($getroles->num_rows() > 0) {
                        foreach ($getroles->result() as $res) {
                            $data[] = array('check' => "<input class='twopartieslist' type='radio' name='selectparties' id='twopartieslist_" . $res->id . "' value='" . $res->code . "' onchange=selectpartiesbyid(" . $res->id . ")>", 'id' => $res->id, 'code' => $res->code, 'name' => $res->name, 'email_id' => $res->email, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code);
                        }
                    }
                }
            }
        }
        echo json_encode($data);
    }

    public function getshipperdetailsbyID() {
        $parties = array();
        $code = $this->input->post('id', TRUE);
        $customer_id = "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $parties['customer_details'] = array();
        $chkqry = $this->db->select("id,name,code,company_code,branch_code")->get_where("tb_customers", array('code' => $code, 'user_id' => $user_id));
        if ($chkqry->num_rows() > 0) {
            $customer_id = $chkqry->row()->id;
            $parties['customer_details'] = array('id' => $chkqry->row()->id, 'name' => $chkqry->row()->name, 'code' => $chkqry->row()->code, 'company_code' => $chkqry->row()->company_code, 'branch_code' => $chkqry->row()->branch_code);
        }

        echo json_encode($parties);
    }

    public function getvendordetailsbyID() {
        $list = array();
        $code = $this->input->post('id', TRUE);
        if ($code != "") {
            $getvendordetails = $this->db->query(
                "SELECT name,code,company_code,branch_code
                        FROM tb_vendors
                        WHERE code LIKE ? AND status = ? ",
                [ $code, 1 ]
            );

            if ($getvendordetails->num_rows() > 0) {
                $list = array('name' => $getvendordetails->row()->name, 'code' => $getvendordetails->row()->code, 'company_code' => $getvendordetails->row()->company_code, 'branch_code' => $getvendordetails->row()->branch_code);
            }
        }
        echo json_encode($list);
    }

    public function getpartnerdetailsbyID() {

        $user_id = $this->session->userdata('user_id');
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $data = $tobebilled = array();
        $code = $this->input->post('id', TRUE);
        $type = $this->input->post('type', TRUE);
        $branch_code = $this->input->post('branch_code', TRUE); 
		$customer_company = $this->input->post('customer_company', TRUE);
        $getpartnerdetails = $this->billingmodel->getpartnerdetailsbycode($code,$customer_company);
        if (!empty($getpartnerdetails)) {
            //$data = array('id' => $getpartnerdetails['id'], 'name' => $getpartnerdetails['name'], 'code' => $getpartnerdetails['code'], 'acon' => $getpartnerdetails['acon_debitor_code'], 'company_code' => $getpartnerdetails['company_code'], 'branch_code' => $getpartnerdetails['branch_code'], 'customer_code' => $getpartnerdetails['customeridentifier']);
            $data = array('id' => $getpartnerdetails['id'], 'name' => $getpartnerdetails['name'], 'code' => $getpartnerdetails['code'], 'acon' => $getpartnerdetails['acon_debitor_code'], 'company_code' => $getpartnerdetails['company_code'], 'branch_code' => $branch_code, 'customer_code' => $getpartnerdetails['customeridentifier'], 'invoice_type' => $getpartnerdetails['invoice_type']);
        }
        if ($code != "") {
            $whr = array();
            $whr['r.recipient_code'] = $code;
            $whr['r.recipient_role'] = $type;
            $gettobebilled = $this->billingmodel->gettobebilled($user_id, $whr, [], $branch_code); 
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    $tripsts ="";
                    $chk_status = 0;
                    $invoice_status = $res['invoice_status'];
                    $trip_id = isset($res['trip_id']) ? $res['trip_id'] : "0";
                    $sts = $res['status'];
                    if ($invoice_status == 1 && $sts == 1) {
                        $chk_status = 1;
                    }
                    $shift_id = isset($res['shift_id']) ? $res['shift_id'] : "0";
                    if($shift_id >0){
                        $getshift = $this->common->gettbldata(array('shift_leg_id' => $shift_id), 'id', 'tb_shifts', 0, 0);
                        if(!empty($getshift)){
                            $leg_ids = array();
                            foreach($getshift as $shft){
                                $leg_ids[] = $shft['id'];
                            }
                            if(!empty($leg_ids)){
                                $gettripsids = $this->billingmodel->checkdriveracceptsfornewtrips($leg_ids);
                                if(!empty($gettripsids)){
                                    $acceptence = 1;
                                    $new_trip_id = 0;
                                    foreach ($gettripsids as $trps){
                                        $trip_row_id = $trps['trip_id'];
                                        if($trip_row_id >0){
                                            $new_trip_id = $trip_row_id;
                                        }else{
                                            $acceptence = 0;
                                        }
                                    }
                                    if($acceptence == 0){
                                        $tripsts = "<input type='hidden' name='noorder_trip_sts' id='".$res['revcosid']."' class='noorder_trip_sts' value='".$new_trip_id."'>";
                                    }else{
                                        $tripsts = "<input type='hidden' name='order_trip_sts' id='".$res['revcosid']."' class='order_trip_sts' value='".$new_trip_id."'>";
                                    }
                                }
                            }
                        }else{
                            if($trip_id == 0){
                                $tripsts = "<input type='hidden' name='noorder_trip_sts' id='".$res['revcosid']."' class='noorder_trip_sts' value='".$trip_id."'>";
                            }else{
                                $tripsts = "<input type='hidden' name='order_trip_sts' id='".$res['revcosid']."' class='order_trip_sts' value='".$trip_id."'>";
                            }
                        }
                    }else{
                        $tripsts = "<input type='hidden' name='noorder_trip_sts' id='".$res['revcosid']."' class='noorder_trip_sts' value='".$trip_id."'>";
                    }

                    if ($chk_status == 1) {
                        $concatid = $res['revcosid'] . "_" . $res['recipient_role'] . "_" . $res['currency'];
                        $recipient_role = $res['recipient_role'];
                        $currency = $res['currency'];
                        $rev_cosid = $res['revcosid'];
                        $tdvalue = "<input type='hidden' form='bill_data' name='recipienttype' class='recipienttype' value='" . $recipient_role . "' ><input type='hidden' form='bill_data' name='currency' class='currency' value='" . $currency . "' ><input type='checkbox' form='bill_data' name='tracking_no[]' class='tracking_no' id='".$res['revcosid']."' value='" . $concatid . "' style='display:none;'><input type='radio' form='bill_data' name='trackingno' class='trackingno' value= '" . $rev_cosid . "' >".$tripsts;
                        $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => date("Y-m-d", strtotime($res['createdon'])));
                    }
                }
            }
        }
        $data['tobebilled'] = $tobebilled;
        echo json_encode($data);

    }

    public function viewroletypelist() {
        $data = array();
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $type = isset($post['type']) ? $post['type'] : "";
        if ($type != "") {
            $user_id = $this->session->userdata('user_id');
            $company_code = $this->session->userdata('company_code');

            if ($company_code == "KNAU") {
                $company_code = "AUKN";
            }

            if ($user_id != '0') {
                $info =  new BillingmodelGetroletypelistInput($user_id, $company_code, $type);
                $getroletypelist = $this->billingmodel->getroletypelist($info);
                if (!empty($getroletypelist)) {
                    foreach ($getroletypelist as $list) {
                        $data[] = array('check' => "<input class='twopartieslist' type='radio' name='selectparties' id='twopartieslist_" . $list['id'] . "' value='" . $list['code'] . "' onchange=selectpartiesbyid(" . $list['id'] . ")> <input type='hidden' id='customer_company_" . $list['id'] . "' name='customer_company_" . $list['id'] . "' value='" . $list['company_code'] . "' >", 'id' => $list['id'], 'code' => $list['code'], 'name' => $list['name'], 'email_id' => $list['email'], 'company_code' => $list['company_code'], 'branch_code' => $list['branch_code']);
                    }
                }
            }
        }
        echo json_encode($data);
    }

    public function weekfilter() {
        $user_id = $this->session->userdata('user_id');
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $data = $tobebilled = array();
        $code = $this->input->post('customercode', TRUE);
        $type = $this->input->post('type', TRUE);
        $week = $this->input->post('week', TRUE);
        $billid = $this->input->post('billid', TRUE);
        $bill_type = $this->input->post('bill_type', TRUE);
        if ($billid != "" && $billid > 0) {
            $billdata = array("code" => $code, "type" => $type, "week" => $week, "billid" => $billid, "bill_type" => $bill_type, "pickupfrom" => "", "pickupto" => "", "deliveryfrom" => "", "deliveryto" => "", "order_status" => "", "doc_status" => "");
            $tobebilled = $this->getbilledandtobebilled($billdata);
        } else if ($code != "" && $week != "" && $billid == "") {
            $whr = array();
            $whr['r.recipient_code'] = $code;
            $whr['r.recipient_role'] = $type;
            $gettobebilled = $this->billingmodel->gettobebilled($user_id, $whr);
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    $createdonweek = date("W", strtotime($res['createdon']));
                    if ($createdonweek == $week) {
                        $createdon = date("Y-m-d", strtotime($res['createdon']));
                        $concatid = $res['revcosid'] . "_" . $res['recipient_role'] . "_" . $res['currency'];
                        $recipient_role = $res['recipient_role'];
                        $currency = $res['currency'];
                        $rev_cosid = $res['revcosid'];
                        $tdvalue = "<input type='hidden' form='bill_data' name='recipienttype' class='recipienttype' value='" . $recipient_role . "' ><input type='hidden' form='bill_data' name='currency' class='currency' value='" . $currency . "' ><input type='checkbox' form='bill_data' name='tracking_no[]' class='tracking_no' value='" . $concatid . "' style='display:none;'><input type='radio' form='bill_data' name='trackingno' class='trackingno' value= '" . $rev_cosid . "'' >";
                        $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                    } else if ($week == "All") {
                        $createdon = date("Y-m-d", strtotime($res['createdon']));
                        $concatid = $res['revcosid'] . "_" . $res['recipient_role'] . "_" . $res['currency'];
                        $recipient_role = $res['recipient_role'];
                        $currency = $res['currency'];
                        $rev_cosid = $res['revcosid'];
                        $tdvalue = "<input type='hidden' form='bill_data' name='recipienttype' class='recipienttype' value='" . $recipient_role . "' ><input type='hidden' form='bill_data' name='currency' class='currency' value='" . $currency . "' ><input type='checkbox' form='bill_data' name='tracking_no[]' class='tracking_no' value='" . $concatid . "' style='display:none;'><input type='radio' form='bill_data' name='trackingno' class='trackingno' value= '" . $rev_cosid . "'' >";
                        $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                    }
                }
            }
        }
        $data['tobebilled'] = $tobebilled;
        echo json_encode($data);
    }

    public function getbilledandtobebilled($billdata) {
        $tobebilled = array();
        $user_id = $this->session->userdata('user_id');
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $week = $billdata['week'];
        $type = $billdata['type'];
        $bill_type = $billdata['bill_type'];
        $billid = $billdata['billid'];
        $week = $billdata['week'];
        $whr = array('code' => $billdata['code'], 'bill_id' => $billid, 'pickupfrom' => $billdata['pickupfrom'], 'pickupto' => $billdata['pickupto'], 'deliveryfrom' => $billdata['deliveryfrom'], 'deliveryto' => $billdata['deliveryto'], 'order_status' => $billdata['order_status'], 'doc_status' => $billdata['doc_status'], 'status' => 1, 'order_reftype' => $billdata['order_reftype'], 'ref_val' => $billdata['ref_val'], 'department_code' => $billdata['department_code'], 'earlypickupfrom' => $billdata['earlypickupfrom'], 'earlypickupto' => $billdata['earlypickupto'], 'earlydeliveryfrom' => $billdata['earlydeliveryfrom'], 'earlydeliveryto' => $billdata['earlydeliveryto'], 'bookingid' => $billdata['bookingid']);
        $gettobebilled = $this->billingmodel->gettobebilledandbilled($user_id, $custid, $country_userids, $whr);
        if (!empty($gettobebilled)) {
            foreach ($gettobebilled as $res) {
                if ($billdata['code'] == $res['recipient_code']) {
                    $tdvalue = "";
                    $concatid = $res['revcosid'] . "_" . $res['recipient_role'] . "_" . $res['currency'];
                    $recipient_role = $res['recipient_role'];
                    $currency = $res['currency'];
                    $rev_cosid = $res['revcosid'];
                    if ($bill_type == 1) {
                        $radiostyle = "";
                        $checkboxstyle = "display:none;";
                    } else {
                        $radiostyle = "display:none;";
                        $checkboxstyle = "";
                    }
                    if ($res['bill_id'] > 0) {
                        $checked = "checked";
                    } else {
                        $checked = "";
                    }
                    $tdvalue = "<input type='hidden' form='bill_data' name='recipienttype' class='recipienttype' value='" . $recipient_role . "' ><input type='hidden' form='bill_data' name='currency' class='currency' value='" . $currency . "' ><input type='checkbox' form='bill_data' name='tracking_no[]' class='tracking_no' value='" . $concatid . "' style='" . $checkboxstyle . "' $checked ><input type='radio' form='bill_data' name='trackingno' class='trackingno' style='" . $radiostyle . "' value= '" . $rev_cosid . "'' $checked >";
                    $createdon = date("Y-m-d", strtotime($res['createdon']));
                    $createdonweek = date("W", strtotime($res['createdon']));
                    if ($createdonweek == $week) {
                        if ($res['bill_id'] == $billid) {
                            $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                        }
                        if ($res['bill_id'] == 0 && $res['invoice_status'] == 1) {
                            $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                        }
                    } else if ($week == "All") {
                        if ($res['bill_id'] == $billid) {
                            $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                        }
                        if ($res['bill_id'] == 0 && $res['invoice_status'] == 1) {
                            $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                        }
                    }
                }
            }
        }

        return $tobebilled;
    }
     
    public function billsfilter() {
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $user_id = $this->session->userdata('user_id');
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $data = $tobebilled = array();
        $code = $post['customercode'];
        $type = $post['type'];
        $week = "All";
        $billid = isset($post['billid']) ? $post['billid'] : "";
        if ($billid == "undefined") {
            $billid = "";
        }
        $bill_type = isset($post['bill_type']) ? $post['bill_type'] : "";
        $earlypickupfrom = isset($post['earlypickupfrom']) ? $post['earlypickupfrom'] : "";
        $earlypickupto = isset($post['earlypickupto']) ? $post['earlypickupto'] : "";
        $earlydeliveryfrom = isset($post['earlydeliveryfrom']) ? $post['earlydeliveryfrom'] : "";
        $earlydeliveryto = isset($post['earlydeliveryto']) ? $post['earlydeliveryto'] : "";
        $pickupfrom = isset($post['pickupfrom']) ? $post['pickupfrom'] : "";
        $pickupto = isset($post['pickupto']) ? $post['pickupto'] : "";
        $deliveryfrom = isset($post['deliveryfrom']) ? $post['deliveryfrom'] : "";
        $deliveryto = isset($post['deliveryto']) ? $post['deliveryto'] : "";
        $order_status = isset($post['order_status']) ? $post['order_status'] : "";
        $doc_status = isset($post['doc_status']) ? $post['doc_status'] : "";
        $order_reftype = isset($post['order_reftype']) ? $post['order_reftype'] : "";
        $ref_val = isset($post['ref_val']) ? $post['ref_val'] : "";
        $department_code = isset($post['department_code']) ? $post['department_code'] : "";
        $bookingid = (isset($post['bookingid']) && !empty($post['bookingid'])) ? $post['bookingid'] : array();
        if ($billid != "" && $billid > 0) {
            $billdata = array('code' => $code, 'type' => $type, 'week' => $week, 'billid' => $billid, 'bill_type' => $bill_type, 'pickupfrom' => $pickupfrom, 'pickupto' => $pickupto, 'deliveryfrom' => $deliveryfrom, 'deliveryto' => $deliveryto, 'order_status' => $order_status, 'doc_status' => $doc_status, 'order_reftype' => $order_reftype, 'ref_val' => $ref_val, 'department_code' => $department_code, 'earlypickupfrom' => $earlypickupfrom, 'earlypickupto' => $earlypickupto, 'earlydeliveryfrom' => $earlydeliveryfrom, 'earlydeliveryto' => $earlydeliveryto, 'bookingid' => $bookingid);
            $tobebilled = $this->getbilledandtobebilled($billdata);
        } else if ($code != "" && $billid == "") {
            $whr = $whr2 = $dates = array();
            $whr['r.recipient_code'] = $code;
            $whr['r.recipient_role'] = $type;
            if ($department_code != "") {
                $whr['d.department_code'] = $department_code;
            }
            if ($earlypickupfrom != "") {
                $earlypickupfrom = date('Y-m-d', strtotime($earlypickupfrom));
                $dates["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $earlypickupfrom;
            }
            if (!empty($bookingid)) {
                $whr2['bookingid'] = $bookingid;
            }
            if ($earlypickupto != "") {
                $earlypickupto = date('Y-m-d', strtotime($earlypickupto));
                $dates["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $earlypickupto;
            }
            if ($earlydeliveryfrom != "") {
                $earlydeliveryfrom = date('Y-m-d', strtotime($earlydeliveryfrom));
                $dates["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') >="] = $earlydeliveryfrom;
            }
            if ($earlydeliveryto != "") {
                $earlydeliveryto = date('Y-m-d', strtotime($earlydeliveryto));
                $dates["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') <="] = $earlydeliveryto;
            }
            if ($pickupfrom != "") {
                $pickupfrom = date('Y-m-d', strtotime($pickupfrom));
                $dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') >="] = $pickupfrom;
                $whr2['pickup'] = array('tps.stop_type' => "P", 'tps.status_code' => "0500");
            }
            if ($pickupto != "") {
                $pickupto = date('Y-m-d', strtotime($pickupto));
                $dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') <="] = $pickupto;
                $whr2['pickup'] = array('tps.stop_type' => "P", 'tps.status_code' => "0500");
            }
            if ($deliveryfrom != "") {
                $deliveryfrom = date('Y-m-d', strtotime($deliveryfrom));
                $dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') >="] = $deliveryfrom;
                $whr2['delivery'] = array('tps.stop_type' => "D", 'tps.status_code' => "2300");
            }
            if ($deliveryto != "") {
                $deliveryto = date('Y-m-d', strtotime($deliveryto));
                $dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') <="] = $deliveryto;
                $whr2['delivery'] = array('tps.stop_type' => "D", 'tps.status_code' => "2300");
            }
            if ($order_status != "") {
                if ($order_status == "pickup") {
                    $stop_type = "P";
                    $status_code = "0500";
                } else {
                    $stop_type = "D";
                    $status_code = "2300";
                }
                $whr2['stop_type'] = $stop_type;
                $whr2['status_code'] = $status_code;
            }
            if ($doc_status == 'yes') {
                $whr2['doc'] = "d.docs_received_datetime  IS NOT NULL AND d.docs_received_datetime !=''";
            }
            if ($doc_status == 'no') {
                $whr2['doc'] = "d.docs_received_datetime  IS NULL OR d.docs_received_datetime =''";
            }
            $whr2['dates'] = $dates;
            if ($order_reftype != "" && $ref_val != "'") {
                $whr2['order_reftype'] = $order_reftype;
                $whr2['ref_val'] = $ref_val;
            }
            $gettobebilled = $this->billingmodel->gettobebilled($user_id, $whr, $whr2);
            if (!empty($gettobebilled)) {
                foreach ($gettobebilled as $res) {
                    $chk_status = 0;
                    $invoice_status = $res['invoice_status'];
                    $sts = $res['status'];
                    if ($invoice_status == 1 && $sts == 1) {
                        $chk_status = 1;
                    }
                    if ($res['recipient_code'] == $code && $chk_status == 1) {
                        $createdon = date("Y-m-d", strtotime($res['createdon']));
                        $concatid = $res['revcosid'] . "_" . $res['recipient_role'] . "_" . $res['currency'];
                        $recipient_role = $res['recipient_role'];
                        $currency = $res['currency'];
                        $rev_cosid = $res['revcosid'];
                        $tdvalue = "<input type='hidden' form='bill_data' name='recipienttype' class='recipienttype' value='" . $recipient_role . "' ><input type='hidden' form='bill_data' name='currency' class='currency' value='" . $currency . "' ><input type='checkbox' form='bill_data' name='tracking_no[]' class='tracking_no' value='" . $concatid . "' style='display:none;'><input type='radio' form='bill_data' name='trackingno' class='trackingno' value= '" . $rev_cosid . "'' >";
                        $tobebilled[] = array('rev_cosid' => $rev_cosid, 'tdvalue' => $tdvalue, 'order_id' => $res['order_id'], 'shipper' => $res['shipper'], 'pickup_city' => $res['pickup_city'], 'pickup_pincode' => $res['pickup_pincode'], 'pickup_country' => $res['pickup_country'], 'consignee' => $res['consignee'], 'delivery_city' => $res['delivery_city'], 'delivery_pincode' => $res['delivery_pincode'], 'delivery_country' => $res['delivery_country'], 'transport_mode' => $res['transport_mode'], 'amount' => $res['amount'], 'currency' => $currency, 'createdon' => $createdon);
                    }
                }
            }
        }
        $data['tobebilled'] = $tobebilled;
        echo json_encode($data);
    }

    function generateCreditDebitnote($info) {
        /* generate Credit note/ debit note */
        $curdt = date('Y-m-d H:i:s');
        $user_currency = $this->session->userdata("usr_tzone")['currency'];
        $bill_id = $info['bill_id'];
        $uid = $info['uid'];
        $invoiceno = $info['invoiceno'];
        $name = $info['name'];
        $billid = $info['billid'];
        $status = $info['status'];
        $session_companycode = $this->session->userdata('company_code');
        $getparentbillid = $this->billingmodel->getparentbillid($bill_id);
        if ($getparentbillid > 0) {
            $bill_id = $getparentbillid;
        }
        $getbilled = $this->billingmodel->getbilleddata($bill_id, $uid);
        if (!empty($getbilled)) {
            $recipient_type = "Customer";
            $checkbill = $this->common->gettblrowdata(array('id' => $bill_id), 'recipient_type', 'tbl_bills', 0, 0);
            if (!empty($checkbill)) {
                $recipient_type = $checkbill['recipient_type'];
            }
            if ($recipient_type == "Customer") {
                $type = 0;
            } else {
                $type = 1;
            }
            $foreign_currency = "";
            $exchange_rate = $local_revised_amount = $local_vat_amount = $local_total_amount = 0;
            $revenue = $this->billingmodel->gettbldata(array('type' => $type, 'bill_id' => $bill_id, 'invoice_status' => '2', 'status' => 1), 'id,order_id,debtor_jfr,exchange_rate,foreign_currency', 'tb_reveneus', 0, 0);
            if (!empty($revenue)) {
                foreach ($revenue as $res) {
                    $amount = 0;
                    $order_id = $res['order_id'];
                    $parent_billid = $getbilled['parent_billid'];
                    $recipient_type = $getbilled['recipient_type'];
                    $foreign_currency = $res['foreign_currency'];
                    $exchange_rate    = $res['exchange_rate'];
                    $parent_revid = $res['id'];
                    if ($recipient_type == "Customer") {
                        $type = 0;
                        $desc = "Credit note";
                    } else {
                        $type = 1;
                        $desc = "Debit note";
                    }
                    $revenue_ar = array();
                    $revenueamt = $revenue_id = 0;
                    $getcharges = $this->billingmodel->getcharges($res['id']);
                    if (!empty($getcharges)) {
                        $i = 0;
                        foreach ($getcharges as $charge) {
                            $parent_chrgid = $charge['id'];
                            $charge_currency = $charge['currency'];
                            if ($charge['revised_amount'] > 0) {
                                if ($i == 0) {
                                    $check_rev = array();
                                    $rev_amount = round($amount,4);
                                    if($session_companycode == "VNKN"){
                                        if($user_currency == $charge_currency){
                                            $rev_amount = round($amount);
                                        }
                                    }
                                    $check_rev = $this->common->gettblrowdata(array('parent_id' => $parent_revid), 'id', 'tb_reveneus', 0, 0);
                                    $revenue_ar = array('type' => $type, 'order_id' => $order_id, 'recipient_role' => $recipient_type, 'recipient_code' => $getbilled['code'], 'recipient_name' => $name, 'debtor_jfr' => $res['debtor_jfr'], 'invoice_number' => $getbilled['invoice_no'], 'credit_note_number' => $invoiceno, 'invoice_date' => $getbilled['invoice_date'], 'invoice_creation_date' => $curdt, 'invoice_receivdon_date' => $curdt, 'amount' => $rev_amount, 'currency' => $getbilled['currency'], 'invoice_status' => 2, 'bill_id' => $billid, 'parent_id' => $parent_revid, 'status' => 1, 'user_id' => $uid,'foreign_currency'=>$foreign_currency,'exchange_rate'=>$exchange_rate);
                                    if (!empty($check_rev)) {
                                        $revenue_id = $check_rev['id'];
                                        $revenue_ar['updatedon'] = $curdt;
                                        $upda_rev_tb = $this->billingmodel->updatedata('tb_reveneus', $revenue_id, $revenue_ar);
                                    } else {
                                        $revenue_ar['createdon'] = $revenue_ar['updatedon'] = $curdt;
                                        $revenue_id = $this->common->insertTableData("tb_reveneus", $revenue_ar);
                                    }
                                }
                                $revisedamount = ($charge['revised_amount'] * -1);
                                $each_chrg_tot = $vat_amt = $vat_percentage = 0;
                                if ($charge['vat_percentage'] > 0) {
                                    $vat_percentage = $charge['vat_percentage'];
                                    $vat_amt = $vat_percentage * $revisedamount * 0.01;
                                } else {
                                    $vat_percentage = 0;
                                }
                                $each_chrg_tot = $revisedamount + $vat_amt;
                                $charge_ar = $check_chrg = array();
                                $charge_revisedamount = round($revisedamount,2);
                                $charge_vatamount = round($vat_amt,4);
                                $charge_eachtotal = round($each_chrg_tot,4);
                                $session_companycode = $this->session->userdata('company_code');
                                if($session_companycode == "VNKN"){
                                    if($user_currency == $charge_currency){
                                        $charge_revisedamount = round($revisedamount);
                                        $charge_eachtotal = round($each_chrg_tot);
                                    }
                                }
                                $local_revised_amount = $charge_revisedamount;
                                $local_vat_amount = $charge_vatamount;
                                $local_total_amount = $charge_eachtotal;
                                if(is_numeric($exchange_rate)){
                                    if($exchange_rate != "0"){
                                        if(strtoupper($charge['currency']) == strtoupper($foreign_currency)){
                                            $local_revised_amount = $exchange_rate * $revisedamount;
                                            if(is_numeric($charge_vatamount)){
                                                $local_vat_amount = $charge_vatamount * $exchange_rate;
                                            }
                                            if(is_numeric($local_revised_amount)){
                                                $local_total_amount = $local_vat_amount + $local_revised_amount;
                                            }
                                            if(is_numeric($local_revised_amount) && is_numeric($local_vat_amount)){
                                                $each_chrg_tot = $local_revised_amount + $local_vat_amount;
                                            }
                                        }
                                    }
                                }
                                $revenueamt += $each_chrg_tot;
                                if($session_companycode == "VNKN"){
                                    $local_revised_amount = round($local_revised_amount);
                                    $local_total_amount   = round($local_total_amount);
                                }
                                $charge_ar = array('revenue_id' => $revenue_id, 'charge_code' => $charge['chargecodeid'], 'description' => $charge['description'], 'quantity_unit' => $charge['quantity_unit'], 'value' => $charge['value'], 'rate_id' => $charge['rate_id'], 'amount' => $charge_revisedamount, 'currency' => $charge['currency'], 'local_amount' =>$local_revised_amount, 'local_currency' => $charge['local_currency'],'local_total_amount'=>$local_total_amount,'local_vat_amount'=>$local_vat_amount, 'vat_percentage' => $vat_percentage, 'vat_amount' => $charge_vatamount, 'total_amount' => $charge_eachtotal, 'cat_id' => $charge['cat_id'], 'cat_val' => $charge['cat_val'], 'parent_id' => $parent_chrgid, 'status' => 1, 'user_id' => $uid);
                                $check_chrg = $this->common->gettblrowdata(array('parent_id' => $parent_chrgid), 'id', 'tb_charges', 0, 0);
                                if (!empty($check_chrg)) {
                                    $charge_id = $check_chrg['id'];
                                    $charge_ar['updatedon'] = $curdt;
                                    $upda_chrg_tb = $this->billingmodel->updatedata('tb_charges', $charge_id, $charge_ar);
                                } else {
                                    $charge_ar['createdon'] = $charge_ar['updatedon'] = $curdt;
                                    $inscharges = $this->common->insertTableData("tb_charges", $charge_ar);
                                }
                                $i++;
                            } else {
                                $check_chrg = $this->common->gettblrowdata(array('parent_id' => $parent_chrgid, 'status' => 1), 'id,revenue_id', 'tb_charges', 0, 0);
                                if (!empty($check_chrg)) {
                                    $chargid = $check_chrg['id'];
                                    $revid = $check_chrg['revenue_id'];
                                    $check_chrg_count = $this->common->gettblrowdata(array('revenue_id' => $revid, 'status' => 1), 'id,revenue_id', 'tb_charges', 0, 0);
                                    if (!empty($check_chrg_count) && count($check_chrg_count) == 1) {
                                        $upda_rev_tb = $this->billingmodel->updatedata('tb_reveneus', $revid, array('status' => 0));
                                        $upda_rev_tb = $this->billingmodel->updatedata('tb_charges', $chargid, array('status' => 0));
                                    } else {
                                        $upda_rev_tb = $this->billingmodel->updatedata('tb_charges', $chargid, array('status' => 0));
                                    }
                                }
                            }
                        }
                    }
                    if ($revenue_id > 0) {
                        $final_amount = round($revenueamt,4);
                        if($session_companycode == "VNKN"){
                            $final_amount = round($revenueamt);
                        }
                        $update = $this->db->where(array("id" => $revenue_id))->update("tb_reveneus", array('amount' => $final_amount));
                    } else {
                        $update = $this->db->where(array("parent_id" => $parent_revid))->update("tb_reveneus", array('amount' => 0, 'status' => 0));
                    }
                }
            }
        }
        return true;
    }

    function savefullamount($bill_id) {
        $data['status'] = 0;
        $session_companycode = $this->session->userdata('company_code');
        $user_currency = $this->session->userdata("usr_tzone")['currency'];
        if ($bill_id > 0) {
            $getparentbillid = $this->billingmodel->getparentbillid($bill_id);
            if ($getparentbillid > 0) {
                $bill_id = $getparentbillid;
            }
            $recipient_type = "Customer";
            $checkbill = $this->common->gettblrowdata(array('id' => $bill_id), 'recipient_type', 'tbl_bills', 0, 0);
            if (!empty($checkbill)) {
                $recipient_type = $checkbill['recipient_type'];
            }
            if ($recipient_type == "Customer") {
                $type = 0;
            } else {
                $type = 1;
            }
            $revenue = $this->billingmodel->gettbldata(array('type' => $type, 'bill_id' => $bill_id, 'invoice_status' => '2', 'status' => 1), 'id', 'tb_reveneus', 0, 0);
            if (!empty($revenue)) {
                foreach ($revenue as $res) {
                    $getcharges = $this->billingmodel->getcharges($res['id']);
                    if (!empty($getcharges)) {
                        foreach ($getcharges as $charge) {
                            $charge_currency = $charge['currency'];
                            $charge_amnt = round($charge['amount'],4);
                            if($session_companycode == "VNKN"){
                                if($user_currency == $session_companycode){
                                    $charge_amnt = round($charge['amount']);
                                }
                            }
                            $upd = $this->common->updatetbledata("tb_charges", array('revised_amount' => $charge_amnt), array('id' => $charge['id']));
                        }
                    }
                    $data['status'] = 1;
                }
            }
            echo json_encode($data);
        }
    }

    public function getorderids() {
        $data = $country_userids = array();
        $user_id = $this->session->userdata('user_id');
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        $country_userids = $this->session->userdata("country_user_ids");
        if ($user_id != "") {
            if (!empty($country_userids)) {
                $getorderids = $this->Order->getcountryuserorderids($user_id, $country_userids, $searchTerm);
                if ($getorderids->num_rows() > 0) {
                    foreach ($getorderids->result() as $res) {
                        $data[] = array("id" => $res->order_id, "text" => $res->order_id);
                    }
                }
            } else {
                $getorderids = $this->Order->getorderids($user_id, array(), $searchTerm);
                if ($getorderids->num_rows() > 0) {
                    foreach ($getorderids->result() as $res) {
                        $data[] = array("id" => $res->order_id, "text" => $res->order_id);
                    }
                }
            }
        }
        echo json_encode($data);
    }

    public function gettrackingno_detailsbyrev(){
        $post =  $response = array();
        $post = $this->input->post(NULL, TRUE);  /* id='36' */
        /* $post['billid'] = $billid; */
        if(!empty($post)){
            $revid = $post['revid'];
            if($revid > '0'){
                $get_revdetails = $this->common->gettbldata(array('id'=>$revid,'status' => '1'),"order_id,debtor_jfr","tb_reveneus",0,0);
                if(!empty($get_revdetails)){
                    foreach($get_revdetails as $res){
                        $order_row_id = $res['order_id'];
                        $booking_id = "";
                        $get_orderdetails = $this->common->gettblrowdata(array('id'=>$order_row_id,'status>'=>'0'),"order_id","tb_orders",0,0);
                        if(!empty($get_orderdetails)){
                            $booking_id = $get_orderdetails['order_id'];
                        }
                        $response[] = array('jfr'=>$res['debtor_jfr'],'order_id'=>$booking_id);
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function gettrackingno_details(){
        $post = $order_ids = $result = $booking_ids = $response = array();
        $post = $this->input->post(NULL, TRUE);  /* id='36' */
        /* $post['billid'] = $billid; */
        if(!empty($post)){
            $bill_id = isset($post['billid']) ? $post['billid'] : "0";
            if($bill_id >0){
                $get_billids = $this->common->gettbldata(array('bill_id'=>$bill_id,'status' => '1'),"order_id,debtor_jfr","tb_reveneus",0,0);
                if(!empty($get_billids)){
                    foreach($get_billids as $res){
                        if(empty($order_ids)){
                            $order_ids[] = $res['order_id'];
                            $result[$res['order_id']] = $res['debtor_jfr'];
                        }else{
                            if(in_array($res['order_id'],$order_ids)){
                            }else{
                                $order_ids[] = $res['order_id'];
                                $result[$res['order_id']] =$res['debtor_jfr'];
                            }
                        }

                    }
                }
                if(!empty($order_ids)){
                    $booking_ids = $this->billingmodel->getbookingids($order_ids);
                }
                if(!empty($booking_ids)){
                    if(!empty($result)){
                        foreach($booking_ids as $row){
                            $order_row_id = $row['id'];
                            $jfr = $result[$order_row_id];
                            $response[] = array('jfr'=>$jfr,'order_id'=>$row['order_id']);
                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }
    
    public function getchargeswithorder(){
        $session_companycode = $this->session->userdata('company_code');
        $rev_costids = $this->input->post('rev_costids', TRUE);
            $result = $chargecodeids = array();
            if(!empty($rev_costids)){
                array_unique($rev_costids);
                $getcharges = $this->billingmodel->getchargeswithorder_ids($rev_costids);
                $chargeid_amount = array();
                if (!empty($getcharges)) {
                    foreach ($getcharges as $charge) {
                        $local_amount = $charge['local_amount'];
                        $final_amount = $charge['amount'];
                        $final_currency = $charge['currency'];
                        $order_id       = $charge['order_id'];
                        if($local_amount >0){
                            $final_amount = $local_amount;
                            $final_currency = $charge['local_currency'];
                        }
                        if ($charge['amount'] > 0) {
                            $result[] = array('order_id'=>$order_id,'charge_code' => $charge['charge_code'], 'description' => $charge['description'], 'amount' => $final_amount, 'currency' => $final_currency);
                        }
                        if ($charge['vat_percentage'] > 0 && $charge['vat_amount'] > 0) {
                            $final_amount = $charge['local_vat_amount'];
                            if($final_amount >0){
                            }else{
                                $final_amount = $charge['vat_amount'];
                            }
                            $description = $charge['charge_code'] . " " . $charge['vat_percentage'] . " %";
                            $vat_name = "VAT";
                            if($session_companycode == "SGKN"){
                                $vat_name = "GST";
                            }
                            $result[] = array('order_id'=>$order_id,'charge_code' => $vat_name, 'description' => $description, 'amount' => $final_amount, 'currency' => $final_currency);
                        }
                    }
                }
            }
           echo json_encode($result);
    }
    
}
