<?php

defined('BASEPATH') or exit('No direct script access allowed');

class BillingControlReport extends CI_Controller
{

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("BillingControlReportModel");
        if (!checkUrlAccessForUser('BILLINGCONTROLREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $data = $finacial_data = $order_data = $finacialdata= array();
        $whr = $post = $data['book_list']= $data["cus_list"] = array();
        $data['page_title']=$this->lang->line('menu_billingcontrolreport');
        $data['sub_title']=$this->lang->line('general_search');
        $user_id = $this->session->userdata("user_id");
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');

        $data["cus_list"] = $this->BillingControlReportModel->getcustomerlist($company_code,$branch_code);

        /* advanced search order id */
        $order_id_list = $this->BillingControlReportModel->getorderidslist();
        if ($order_id_list->num_rows() > 0) {
            $data["book_list"] = $order_id_list->result_array();
        }

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }

        if (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $post = $_POST;
        }

        if (!empty($post)) {
            $whr = $this->searchsubmitdata($post);
            $whr_ids=$ids=$whr_id=array();
            if($company_code == "RUKN"){
            $whr_id = $this->common->gettbldata(array('company_code'=>$company_code), 'id','tb_users', 0, 0);

            foreach($whr_id as $ids){
               $whr_ids[]=$ids['id'];
            }

            } else{
                $whr['user_id']=$user_id;
            }
            $finacialdata = $this->BillingControlReportModel->getsearchdata($whr,$whr_ids);
        }

         /* get Revene data Revene Table */
         if (! empty($finacialdata)) {
            foreach ($finacialdata as $res) {
                /* order data get */
                $whr_or = array(
                    'o.id' => $res['order_id']
                );
                $order_data = $this->BillingControlReportModel->getorderdata($whr_or);

                $pickup_date_status = $delivery_datestatus = $delivery_status = "";
                $bookingid = $res['order_id'];
                $early_pickup = $order_data['pickup_datetime'];
                $early_delivery = $order_data['delivery_datetime'];
                $curtz = $this->session->userdata("usr_tzone")['timezone'];

                /** pickupdate and delivery date **/
                $sql4 = $this->BillingControlReportModel->getpickupdetails($bookingid);

                if($sql4->num_rows() > 0) {
                    $pickupdate_time = $sql4->row()->createdon;
                    if($pickupdate_time != "" && $pickupdate_time != "0000-00-00 00:00:00"){
                        $pickup_date_status = date("Y-m-d H:i A",strtotime($pickupdate_time));
                    } else {
                        $pickup_date_status = "";
                    }
                } else {
                    if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                        $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                        $early_pickup = $epickup['datetime'];
                        $pickup_date_status = $early_pickup;
                    } else {
                        $pickup_date_status = "";
                    }
                }

                $sql5 = $this->BillingControlReportModel->getdeliverydetails($bookingid);

                if($sql5->num_rows() > 0) {
                    $status_id = $sql5->row()->status_id;
                    if($status_id == "3") {
                        $delivery_status = "Delivered";
                    }
                    $delivery_datetime = $sql5->row()->createdon;
                    if($delivery_datetime != "" && $delivery_datetime != "0000-00-00 00:00:00"){
                        $delivery_datestatus = date("Y-m-d H:i A",strtotime($delivery_datetime));
                    } else {
                        $delivery_datestatus = "";
                    }
                } else {
                    if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                        $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                        $early_delivery = $edelivery['datetime'];
                        $delivery_datestatus = $early_delivery;
                    } else {
                        $delivery_datestatus = "";
                    }
                }

                $trip_id = $order_data['trip_id'];
                $trip_sts = $order_data['trip_sts'];

                if(($trip_id !=0) && ($trip_sts == 1)) {
                    $delivery_status = "Delivered";
                }

                /** original documents received and sent **/
                $docssent_status = $docsreceive_status = "";
                $docs_sent_datetime = $order_data['docs_sent_datetime'];
                if($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00" && !is_null($docs_sent_datetime)){
                        $sentdatetime = getdatetimebytimezone($curtz,$docs_sent_datetime,DFLT_TZ);
                        $docssent_status = $sentdatetime['datetime'];
                    } else {
                        $docssent_status = "";
                    }
                $docs_received_datetime = $order_data['docs_received_datetime'];
                if($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00" && !is_null($docs_received_datetime)){
                        $received_datetime = getdatetimebytimezone($curtz,$docs_received_datetime,DFLT_TZ);
                        $docsreceive_status = $received_datetime['datetime'];
                    } else {
                        $docsreceive_status = "";
                    }

                /** get invocies_exists or not **/
                $invocies_exists = "No";
                if($res['invoice_status'] > 1) {
                    $invocies_exists = "Yes";
                }
                $finacial_data[] = array(
                    'id' => $res['id'],
                    'customer_id' => $res['recipient_code'],
                    'booking_id' => $order_data['order_id'],
                    'delivery_status' => $delivery_status,
                    'pickup_date' => $pickup_date_status,
                    'delivery_date' => $delivery_datestatus,
                    'pickupdate_time' => $order_data['pickup_datetime'],
                    'delivery_datetime' => $order_data['delivery_datetime'],
                    'docsreceive_status' => $docsreceive_status,
                    'docssent_status' => $docssent_status,
                    'invocies_exists' => $invocies_exists
                );
            }
        }
        $data["finacialdata"] = $finacial_data;

        $this->newtemplate->dashboard('billingcontrolreport/index',$data);
    }

    public function searchsubmitdata($post)
    {
        $whr = array();

        $whr = array(
            'status' => 1,
            'type'=>0
        );
        $whr['order_id >'] = 0;

        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
            $fromdate_search = date('Y-m-d', strtotime($post['fromdate_search']));
            $whr["DATE_FORMAT(updatedon,'%Y-%m-%d') >="] = $fromdate_search;
        }

        if (isset($post['todate_search']) && $post['todate_search'] != "") {
            $todate_search = date('Y-m-d', strtotime($post['todate_search']));
            $whr["DATE_FORMAT(updatedon,'%Y-%m-%d') <="] = $todate_search;
        }

        if (isset($post['revene_type']) && $post['revene_type'] != "" && $post['revene_type'] != "ALL") {
            $r_type = $post['revene_type'];
            if ($r_type == 10) {
                $r_type = 0;
            }

            $whr['invoice_status'] = $r_type;
        }

        if (isset($post['cus_id_r']) && $post['cus_id_r'] != "") {

            $whr['recipient_code'] = $post['cus_id_r'];
        }

        if (isset($post['bookiing_id']) && $post['bookiing_id'] != "") {

            $whr['order_id'] = $post['bookiing_id'];
        }

        return $whr;
    }
}

?>
