<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Bonds extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        $this->load->model("common");
        $this->load->model('truckwaybillmodel');
    }

    function getUserTimeZone($uid,$cmpcode){
        $getqry = $this->db->query(
            "SELECT country_code,cntry_timezone,cntry_hrs,currency
                    FROM tbl_country_master
                    WHERE (country_code= ?  OR country_name= ? ) AND status= ?
                    LIMIT 1",
            [$cmpcode, $cmpcode, 1]
        );
        $res = array("currency"=>"SGD","timezone"=>"Asia/Singapore","hrs"=>"+08.00","country"=>"SG");
        if($getqry->num_rows()>0){
          $res = array("currency"=>$getqry->row()->currency,"timezone"=>$getqry->row()->cntry_timezone,"hrs"=>$getqry->row()->cntry_hrs,'country'=>$getqry->row()->country_code);
        }
        return $res;
    }

    /**
     * @deprecated
     */
    public function labelcron(){
        $query = $this->db->query(
            "select order_id,job_id,line_no
                    from tb_bondscar_edi
                    where job_id NOT IN (select job_id from tb_bondscar_edi where msg_type = 'JOBLABEL' and msg_status ='CONFIRMED')
                      AND order_id NOT IN (select order_id from tb_bondscar_edi where msg_type='JOBLABEL' AND msg_status='ERROR')
                      AND msg_type='BOOKING' and msg_status='CONFIRMED'
                    group by order_id,job_id"
        );
        if($query->num_rows() >0){
            foreach($query->result() as $res){
                $this->labelupload($res->order_id,$res->job_id);
            }
        } else {
            log_message("error","Bonds all job labels already updated");
        }
    }

    public function statuscron(){
        $query = $this->db->query(
            "select order_id,job_id,line_no
                    from tb_bondscar_edi
                    where job_id NOT IN (select job_id from tb_bondscar_edi where msg_type = 'STATUS' and msg_status ='DELIVERED')
                      AND order_id NOT IN (select order_id from tb_bondscar_edi where msg_type='STATUS' AND msg_status='ERROR')
                      AND msg_type='BOOKING' and msg_status='CONFIRMED'
                    group by order_id,job_id"
        );
        if($query->num_rows() >0){
            foreach($query->result() as $res){
                $this->statusupdate($res->order_id,$res->job_id);
            }
        } else {
            log_message("error","Bonds all job Status already updated");
        }

    }

    /**
     * @deprecated
     */
    public function trackcron(){
        $query = $this->db->query(
            "select order_id,job_id,line_no
                    from tb_bondscar_edi
                    where job_id NOT IN (select job_id from tb_bondscar_edi where msg_type = 'STATUS' and msg_status ='DELIVERED')
                      AND order_id NOT IN (select order_id from tb_bondscar_edi where msg_type='TRACKING' AND msg_status='ERROR')
                      AND msg_type='STATUS' and msg_status ='PICKUP'
                    group by order_id,job_id"
        );
        if($query->num_rows() >0){
            foreach($query->result() as $res){
                $ordinfo = $this->db->query(
                    'SELECT o.id,o.trip_id,t.vehicle_id,t.driver_id,t.start_imei
                            from tb_orders o
                                LEFT JOIN tb_trips t on t.id = o.trip_id
                            WHERE o.id = ? ',
                    [ $res->order_id ]
                )->row_array();
                $ordinfo['job_id'] = $res->job_id;
                $this->trackjob($ordinfo);
            }
        } else {
            log_message("error","Bonds all job Track already updated");
        }
    }

    public function statusupdate($order_row_id,$job_id){
        $this->load->library("statusintigration");
        $info = $this->db->query(
            'select msg_status
                from tb_bondscar_edi
                WHERE order_id = ? AND job_id = ?
                ORDER BY id DESC
                limit 1',
            [$order_row_id, $job_id ]
        )->row_array();
        if($info['msg_status'] != 'DELIVERED'){
            $orderdata = $this->common->gettblrowdata(array('id'=>$order_row_id),'branch_code','tb_orders',0,0);
            $branch = substr($orderdata['branch_code'],2);
            $account = $this->accountinfo($branch);
            $request = '';
            $request .='<?xml version="1.0" encoding="ISO-8859-1"?>';
            $request .='<job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond-status.xsd">';
            $request .='<job_action>STATUS</job_action>';
            $request .='<job_id>'.$job_id.'</job_id>';
            $request .='<account>'.$account['account'].'</account>';
            $request .='<authorization_code>'.$account['auth_code'].'</authorization_code>';
            $request .='</job>';
            $resname=date("Ymdhis");
            $filenm ="statusreq".$resname.".xml";
            $dom = new DOMDocument;
            $dom->preserveWhiteSpace = FALSE;
            $dom->loadXML($request);
            $dom->save('xml/borderapi/'.$filenm);
           $fileName = FCPATH."/xml/borderapi/".$filenm;

            //$finfo = finfo_open(FILEINFO_MIME_TYPE);
            //$finfo = finfo_file($finfo, $fileName);

            //$cFile = new CURLFile($fileName, $finfo, basename($fileName));
            $cFile = new CURLFile($fileName);
            $postdata = array( "uploadfile"=>$cFile);
            $serviceurl = BONDS_URL;
            $headers = array('Content-Type: multipart/form-data');
            $res = bordercarriercurl($serviceurl,$headers,$postdata);
            $response = json_decode(json_encode(simplexml_load_string($res)), true);
            if($response){
                $job_id = (isset($response['job_details']['job_id']))?$response['job_details']['job_id']:0;
                $line_no = (isset($response['job_details']['line_no']))?$response['job_details']['line_no']:0;
                $order = $this->common->gettblrowdata(array('id'=> $order_row_id),'order_id,shift_id,trip_id,pickup_pincode,delivery_pincode,plat,plng,dlat,dlng,vendor_id,user_id','tb_orders',0,0);
                if($response['msg_status'] != 'ERROR'){
                    if(empty($response['job_details']['time_allocated']) && empty($response['job_details']['time_picked_up']) && empty($response['job_details']['time_delivered'])){
                        $status = "BOOKED"; //"Job is booked";
                        $status_name='Booked by Supplier';
                        $stop_type = "P";
                    } else if(!empty($response['job_details']['time_allocated']) && empty($response['job_details']['time_picked_up']) && empty($response['job_details']['time_delivered'])){
                        $status = "ALLOCATED"; //"Job is allocated to a driver";
                        $status_name = "Accepted by Driver";
                        $stop_type = "P";
                        //$drivercreate = $this->driver_creation($order_row_id,$order['user_id'],$order['shift_id'],$sloc='',$order);
                    } else if(!empty($response['job_details']['time_allocated']) && !empty($response['job_details']['time_picked_up']) && empty($response['job_details']['time_delivered'])){
                        $status = "PICKUP";//"Job is picked up";
                        $status_name = 'Pickup Or Drop';
                        $stop_type = "P";
                        /* if(isset($response['job_tracking'])){
                            if(isset($response['job_tracking']['coordinates'])){
                                $trk = array("latlng"=>$response['job_tracking']['coordinates'],"trkurl"=>$response['job_tracking']['url']);
                                $this->trackjob($trk,$order_row_id,$job_id);
                            }
                        } */
                    } else if(!empty($response['job_details']['time_allocated']) && !empty($response['job_details']['time_picked_up']) && !empty($response['job_details']['time_delivered'])){
                        $status = "DELIVERED"; //"Job is delivered";
                        $status_name = 'Delivered to Consignee';
                        $stop_type = "D";
                    }
                } else {
                    $status = 'ERROR';
                }
                 $res_array=array('order_id'=>$order_row_id,'msg_type'=>$response['msg_type'],'msg_status'=>$status,'request_path'=>$filenm,'response'=>$res,'job_id'=>$job_id,'line_no'=>$line_no);
                $check = $this->common->gettblrowdata(array('order_id'=>$order_row_id,'job_id'=>$job_id,'msg_status'=>$status,'msg_type'=>$response['msg_type']),'id,request_path','tb_bondscar_edi',0,0);
                if($check){
                    $this->common->updatetbledata("tb_bondscar_edi",array('request_path'=>$filenm,'response'=>$res),array("id"=>$check['id']));
                    unlink(FCPATH."/xml/borderapi/".$check['request_path']);
                } else {
                    $this->common->insertTableData('tb_bondscar_edi',$res_array);
                    if($response['msg_status'] != 'ERROR'){
                    $code='000';
                    $createdon=date('Y-m-d H:i:s');
                    $location = '';
                    $shipment_id=$stop_id=$stop_detail_id=$trip_id=$status_id=$lat=$lng=$status_code=$status=$driver_id=$vehicle_id=0;

                    /* getting status code and id from status master */
                      $select = "id,status_code";
                      $table = "tb_status_master";
                      $where=array("status_name"=>$status_name);
                      $statusinfo = $this->common->gettblrowdata($where,$select,$table,0,0);
                      if(count($statusinfo)>0){
                        $status_id=$statusinfo['id'];
                        $code = $statusinfo['status_code'];
                      } else {
                          log_message('error','No status master data');
                      }

                    $reason='From Bonds Express';

                    /* Getting vehicle and driver from trips table */
                    $where = array('shift_id'=>$order['shift_id']);
                      $select = "vehicle_id,driver_id";
                      $table = "tb_trips";
                      $dvinfo = $this->common->gettblrowdata($where,$select,$table,0,0);
                      if(count($dvinfo)>0){
                        $driver_id=$dvinfo['driver_id'];
                        $vehicle_id=$dvinfo['vehicle_id'];
                      }

                      /* if($location!=''){
                        $data  = getlatlngsbyplace($location);
                        $lat  = @$data[0];
                        $lng  = @$data[1];
                      } */

                      /* getting stop data */
                      $select = "id";
                      $table = "tb_shiporder_stops";
                      $where=array("shipment_id"=>$order['shift_id'],'stoptype'=>$stop_type,"status"=>1);
                      $stopidinfo = $this->common->gettblrowdata($where,$select,$table,0,0);
                      if(count($stopidinfo)>0){
                        $stop_id=$stopidinfo['id'];
                      }

                      // get the recent lat lng values from tb_trucks_data
                      if(!empty($vehicle_id)){
                        $veh_qry = $this->db->query(
                            "SELECT latitude,longitude
                                from tb_trucks_data
                                WHERE id = ?",
                            [$vehicle_id ]
                        );
                        if($veh_qry->num_rows() == 0){
                            $lat = $veh_qry->row()->latitude;
                            $lng = $veh_qry->row()->longitude;
                        }
                      }

                    if($status_name != "Accepted by Driver") { // bcz we have added stop status in driver creation in driver accept case
                        $innr_array=array('order_id'=>$order_row_id,'shipment_id'=>$order['shift_id'],'stop_id'=>$stop_id,'stop_detail_id'=>$stop_detail_id,'stop_type'=>$stop_type,'trip_id'=>$order['trip_id'],'status_id'=>$status_id,'status_code'=>$code,'status'=>1,'reason'=>$reason,'latitude'=>$lat,'longitude'=>$lng,'createdon'=>$createdon,'loc_name'=>$location,'driver_id'=>$driver_id,'vehicle_id'=>$vehicle_id);
                        $check_array=array('order_id'=>$order_row_id,'shipment_id'=>$order['shift_id'],'stop_id'=>$stop_id,'stop_detail_id'=>$stop_detail_id,'stop_type'=>$stop_type,'trip_id'=>$order['trip_id'],'status_id'=>$status_id,'status_code'=>$code,'loc_name'=>$location,'driver_id'=>$driver_id,'vehicle_id'=>$vehicle_id);
                        $chk_qry = $this->db->select("id")->get_where('tb_stop_status',$check_array);
                        if($chk_qry->num_rows() == 0){
                        $stsins = $this->db->insert('tb_stop_status',$innr_array);
                        }else{
                        $stsins = $this->db->where_in("id",array("id"=>$chk_qry->row()->id))->update("tb_stop_status",$innr_array);
                        }
                    }

                    /*check trip close*/
                    if($status_name == "Delivered to Consignee"){
                        $upd = $this->common->updatetbledata("tb_bondscar_edi",array("status"=>0),array("order_id"=>$order_row_id,'job_id'=>$job_id));
                        $upd = $this->common->updatetbledata("tb_orders",array("trip_sts"=>1),array("id"=>$order_row_id));
                        $upd = $this->common->updatetbledata("tb_shifts",array("status"=>0),array("id"=>$order['shift_id']));
                        $upd = $this->common->updatetbledata("tb_trips",array("status"=>0),array("id"=>$order['trip_id']));
                        /* Generated Summary */
                        $curtz = "";
                        $user = $this->db->select("id,country_code")->get_where("tb_users",array("id"=>$order['user_id']),1,0)->row_array();
                        $tz = $this->getUserTimeZone($user['id'],$user['country_code']);
                        $curtz = $tz['timezone'];
                        $gensum = $this->generatesummary($order['trip_id'],$curtz);
                    }
                }

                }
            }
        } else {
            log_message('error','already delivered this order :'.$order_row_id);
        }
    }

    public function labelupload($order_row_id,$job_id){
        $orderdata = $this->common->gettblrowdata(array('id'=>$order_row_id),'branch_code','tb_orders',0,0);
        $branch = substr($orderdata['branch_code'],2);
        $account = $this->accountinfo($branch);
        $req = '';
        $req .= '<?xml version="1.0" encoding="ISO-8859-1"?>';
        $req .= '<job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond-joblabel.xsd">';
        $req .= '<job_action>JOBLABEL</job_action>';
        $req .= '<job_id>'.$job_id.'</job_id>';
        $req .= '<account>'.$account['account'].'</account>';
        $req .= '<authorization_code>'.$account['auth_code'].'</authorization_code>';
        $req .= '</job>';
        $resname=date("Ymdhis");
        $filenm ="labelreq".$resname.".xml";
        $dom = new DOMDocument;
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($req);
        $dom->save('xml/borderapi/'.$filenm);
        $fileName = FCPATH."/xml/borderapi/".$filenm;

        #$finfo = finfo_open(FILEINFO_MIME_TYPE);
        #$finfo = finfo_file($finfo, $fileName);

        #$cFile = new CURLFile($fileName, $finfo, basename($fileName));
        $cFile = new CURLFile($fileName);
        $postdata = array( "uploadfile"=>$cFile);
        $serviceurl = BONDS_URL;
        $headers = array('Content-Type: multipart/form-data');
        $res = bordercarriercurl($serviceurl,$headers,$postdata);
        $response = json_decode(json_encode(simplexml_load_string($res)), true);
       print_r($response); exit; //TODO: What is this??
        if($response){
            $job_id = (isset($response['job_details']['job_id']))?$response['job_details']['job_id']:0;
            $line_no = (isset($response['job_details']['line_no']))?$response['job_details']['line_no']:0;
            $res_array=array('order_id'=>$order_row_id,'msg_type'=>$response['msg_type'],'msg_status'=>$response['msg_status'],'request_path'=>$filenm,'response'=>$res,'job_id'=>$job_id,'line_no'=>$line_no);
            $this->common->insertTableData('tb_bondscar_edi',$res_array);
            if($response['msg_status'] == 'ERROR'){
                log_message('error','Border label api error order_id '.$order_row_id);
            } else {
                $orderinfo = $this->common->gettblrowdata(array('id'=> $order_row_id),'id,user_id,plat,plng,trip_id,shift_id','tb_orders',0,0);
                $doctype = $this->common->gettblrowdata(array('type_name'=> 'Others'),'id','tb_document_types',0,0);
                $lbname = 'lbl'.date("Ymdhis").'.pdf';
                copy($response['job_label_file'], NEW_POD_PATH.$lbname);
                $insert['order_id'] = $orderinfo['id'];
                $insert['trip_id'] = $orderinfo['trip_id'];
                $insert['shipment_id'] = $orderinfo['shift_id'];
                $insert['stop_id'] = 0;
                $insert['stop_detail_id'] = 0;
                $insert['stop_type']= 'P';
                $insert['doc_type'] = $doctype['id'];
                $insert['latitude'] = $orderinfo['plat'];
                $insert['longitude'] = $orderinfo['plng'];
                $insert['user_id'] = $orderinfo['user_id'];
                $insert['status']= 1;
                $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
                $insert['imgpath'] = $lbname;
                $insertid = $this->common->insertTableData("tb_pod_uploads",$insert);
            }
        } else {
            log_message('error','border edi label request failed');
        }
    }

    public function trackjob($ordinfo){
        $orderdata = $this->common->gettblrowdata(array('id'=>$ordinfo['id']),'branch_code','tb_orders',0,0);
        $branch = substr($orderdata['branch_code'],2);
        $account = $this->accountinfo($branch);
        $jobid = $ordinfo['job_id'];
        $track = array();
        $request = '';
        $request .= '<?xml version="1.0" encoding="ISO-8859-1"?>';
        $request .= '<job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond-tracking.xsd">';
        $request .= '<job_action>TRACKING</job_action>';
        $request .= '<job_id>'.$jobid.'</job_id>';
        $request .= '<account>'.$account['account'].'</account>';
        $request .= '<authorization_code>'.$account['auth_code'].'</authorization_code>';
        $request .= '</job>';
        $resname=date("Ymdhis");
        $filenm ="trackreq".$resname.".xml";
        $dom = new DOMDocument;
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($request);
        $dom->save('xml/borderapi/'.$filenm);
        $fileName = FCPATH."/xml/borderapi/".$filenm;

        #$finfo = finfo_open(FILEINFO_MIME_TYPE);
        #$finfo = finfo_file($finfo, $fileName);

        #$cFile = new CURLFile($fileName, $finfo, basename($fileName));
        $cFile = new CURLFile($fileName);
        $postdata = array( "uploadfile"=>$cFile);
        $serviceurl = BONDS_URL;
        $headers = array('Content-Type: multipart/form-data');
        $res = bordercarriercurl($serviceurl,$headers,$postdata);
        $response = json_decode(json_encode(simplexml_load_string($res)), true);
        print_r($response); exit;
        if($response){
            $job_id = (isset($response['job_details']['job_id']))?$response['job_details']['job_id']:0;
            $line_no = (isset($response['job_details']['line_no']))?$response['job_details']['line_no']:0;
            $res_array=array('order_id'=>$ordinfo['id'],'msg_type'=>$response['msg_type'],'msg_status'=>$response['msg_status'],'request_path'=>$filenm,'response'=>$res,'job_id'=>$job_id,'line_no'=>$line_no);
            $this->common->insertTableData('tb_bondscar_edi',$res_array);
                /*  store lat lng in tb_rtdrive_locations and update lat,lng , current date in tb_trucks_data  */
            if($response['msg_status'] != 'ERROR'){
                $trip_id = $ordinfo['trip_id'];
                $vehicle_id = $ordinfo['vehicle_id'];
                $driver_id = $ordinfo['driver_id'];
                $mobile_imei = $ordinfo['start_imei'];
                if(empty($mobile_imei)){
                    $mobile_imei = "0000000000";
                }
                $coordinates = explode(',',$response['job_tracking']['coordinates']);
                $lat1 = $coordinates[0];
                $lng1 = $coordinates[1];
                if($vehicle_id!=''){
                    $createdon=date('Y-m-d H:i:s');
                    $drive_loc=array('driver_id'=>$driver_id,'vehicle_id'=>$vehicle_id,'trip_id'=>$trip_id,'latitude'=>$lat1,'longitude'=>$lng1,'accuracy'=>50,'speed'=>0,'battery'=>0,'bearing'=>50,'timestamp'=>$createdon,'mobileimei'=>$mobile_imei);
                    $check_drive_loc=array('driver_id'=>$driver_id,'vehicle_id'=>$vehicle_id,'trip_id'=>$trip_id,'latitude'=>$lat1,'longitude'=>$lng1);
                     /* store in tb_rtdrive_locations */
                    if($lat1!='' && $lat1!=0){
                        $chk_qry = $this->db->select("id")->get_where('tb_rtdrive_locations',$check_drive_loc);
                        if($chk_qry->num_rows() == 0){
                            $vehins = $this->db->insert('tb_rtdrive_locations',$drive_loc);
                        }else{
                            $vehins = $this->db->where_in("id",array("id"=>$chk_qry->row()->id))->update("tb_rtdrive_locations",$drive_loc);
                        }
                    }
                    /* tb_trucks_data updating */
                    $veh_info=array('latitude'=>$lat1,'longitude'=>$lng1,'speed'=>0,'battery'=>0,'bearing'=>50,'receivedon'=>$createdon);
                    if($lat1!='' && $lat1!=0){
                        $vehins = $this->db->where_in("id",array("id"=>$vehicle_id))->update("tb_trucks_data",$veh_info);
                    }
                }
            }
        }
        /* else {
            log_message('error','Border EDI trackurl error for order id:'.$ordinfo['id']);
        } */
    }

    public function accountinfo($branch){
        if($branch == 'VIC'){
            $branch = 'MEL';
            $account= "V01138";
            $auth_code= "UXzEh0a@Z4v@";
        } elseif($branch == 'QLD'){
            $branch = 'BNE';
            $account= "Q00333";
            $auth_code= "gFA5JR]C[[hi";
        } elseif($branch == 'NSW'){
            $branch = 'SYD';
            $account= "19088";
            $auth_code= "yBE]n,JJYTrT";
        } elseif($branch == 'WA'){
            $branch = 'PER';
            $account= "P00054";
            $auth_code= "OE[tk,KYXzoH";
        }
        return array('account'=>$account,'auth_code'=>$auth_code);
    }

    function driver_creation($ordid,$userid,$shift_id,$sloc,$order){
        $vehicle_id=$driver_id='';
        $plat = $order['plat'];
        $plng = $order['plng'];
        $dlat = $order['dlat'];
        $dlng = $order['dlng'];
        $vendor_id = $order['vendor_id'];
        $curdt=date('Y-m-d H:i:s');
        $where = array('truck_number'=>'VEHICLE', 'register_number'=>'BONDSVEHICLE','user_id'=>$userid);
        $select = "id";
        $table = "tb_trucks_data";
        $chkemp = $this->common->gettblrowdata($where,$select,$table,0,0);
        if(count($chkemp) == 0){
            $inn_arr=array('truck_number'=>'VEHICLE','truck_type'=>1,'register_number'=>'BONDSVEHICLE','route'=>'VEHICLE','user_id'=>$userid,'status'=>'Active','createdon'=>$curdt);
            $vehicle_id = $this->common->insertTableData("tb_trucks_data",$inn_arr);
        }else{
            $vehicle_id = $chkemp['id'];
        }
        $where = array('name'=>'BONDSdriver', 'user_id'=>$userid);
        $select = "id";
        $table = "tb_truck_drivers";
        $dricheck = $this->common->gettblrowdata($where,$select,$table,0,0);
        if(count($dricheck) == 0){
            $inn_arr=array('name'=>'BONDSdriver','password'=>'TVRJek5EVTI=','user_id'=>$userid,'createdby'=>$userid,'status'=>'Active','createdon'=>$curdt);
            $driver_id = $this->common->insertTableData("tb_truck_drivers",$inn_arr);
        }else{
            $driver_id = $dricheck['id'];
        }
        if($vehicle_id != "" && $driver_id != ""){
            $stid=10;
            $stcode = "0212";
            $chqry = $this->db->select("id")->get_where("tb_trips",array('shift_id'=>$shift_id, 'vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id),1,0);
            if($chqry->num_rows() == 0){
                $latitude = $plat;
                $longitude = $plng;
                $triparr = array('shift_id'=>$shift_id, 'vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'stime'=>$curdt,  'splace'=>"", 'eplace'=>"", 'start_reading'=>0, 'end_reading'=>0, 'created_on'=>$curdt, 'updated_on'=>$curdt, 'status'=>1, 'trip_type'=>0, 'transit_status'=>0,"plat"=>$latitude,"plng"=>$longitude);
                $tripid = $this->common->insertTableData('tb_trips', $triparr);
                $insarry = array("shipment_id"=>$shift_id,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>$tripid,"status_id"=>$stid,"latitude"=>$latitude,"longitude"=>$longitude,"status"=>1,"reason"=>"From Spoton","vehicle_id"=>$vehicle_id,"driver_id"=>$driver_id,"status_code"=>$stcode,"createdon"=>$curdt,'loc_name'=>$sloc);
                $ins = $this->db->insert("tb_stop_status",$insarry);
                /* update orders table */
                $ordwhr = array("shift_id"=>$shift_id);
                $ordset = array("trip_id"=>$tripid);
                $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
            }
            $where = array('shft_id'=>$shift_id,'user_id'=>$userid,"status"=>1);
            $select = "id";
            $table = "tb_shft_veh";
            $shiftcheck = $this->common->gettblrowdata($where,$select,$table,0,0);
            if(count($shiftcheck) > 0){
                $upd = $this->db->where(array("shft_id"=>$shift_id))->update("tb_shft_veh",array("vehicle_id"=>$vehicle_id));
            }
            $where = array('vendor_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id,"status"=>1);
            $select = "id";
            $table = "tb_vendor_vehicles";
            $ven_veh_check = $this->common->gettblrowdata($where,$select,$table,0,0);
            if(count($ven_veh_check) == 0){
                $arr = array('vehicle_id'=>$vehicle_id, 'vendor_id'=>$vendor_id, 'status'=>1, 'createdon'=>$curdt);
                $ins = $this->common->insertTableData("tb_vendor_vehicles",$arr);
            }
            $chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicle_id));
            if($chk->num_rows()>0){
                if($driver_id == $chk->row()->driver_id){
                    $upd = $this->db->where(array("id"=>$chk->row()->id))->update("tb_vehicles_drivers",array("status"=>1));
                }else{
                    $arr = array('vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
                    $ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
                }
            }else{
                $arr = array('vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
                $ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
            }
            $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id),1,0);
            if($chk11->num_rows()>0){
                $upd = $this->db->where(array("id"=>$chk11->row()->id))->update("tbl_assigned_drivers",array("status"=>"1",'updated_on'=>$curdt));
            }else{
                $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id <>"=>$driver_id,"vehicle_id"=>$vehicle_id,"status"=>1),1,0);
                if($chk111->num_rows() == 0){
                    $ins = $this->common->insertTableData("tbl_assigned_drivers",array("vehicle_id"=>$vehicle_id,"user_id"=>$userid,"driver_id"=>$driver_id,"mobile_no"=>$driver_id,"from_time"=>$curdt,"to_time"=>$curdt,"status"=>"1",'created_on'=>$curdt));
                }else{
                    $upd = $this->db->where(array("id"=>$chk111->row()->id))->update("tbl_assigned_drivers",array("driver_id"=>$driver_id,'updated_on'=>$curdt));
                }
            }
        }
    }

    public function generatesummary(int $tripId = null, string $timeZone = null): void
    {
        if (empty($tripId)) {
            return;
        }
        if ($timeZone === "") {
            $timeZone = date_default_timezone_get();
        }
        $logDate = date('Y-m-d H:i:s');
        $getActual = getdatetimebytimezone(DFLT_TZ, $logDate, $timeZone);
        $currentDate = $getActual['datetime'];
        $getTripDetails = $this->db->query(
            "SELECT shift_id,vehicle_id,driver_id,
                convertToClientTZ(etime,'" . $timeZone . "') as etime,
                etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng
                FROM tb_trips
                WHERE id= ? AND status=0
                LIMIT 1",
            [$tripId]
        );
        if (!$getTripDetails->num_rows()) {
            return;
        }
        $data = [];
        $data['driver_name'] = $data['driver_num'] = "";
        $shift = $getTripDetails->row()->shift_id;
        $getShitDetails = $this->db->query(
            "SELECT user_id,stime as setime,
                    convertToClientTZ(startdate,'" . $timeZone . "') as startdate,
                    convertToClientTZ(enddate,'" . $timeZone . "') as enddate,
                    splace,eplace,elat,elng
                    FROM tb_shifts
                    WHERE id = ?
                    LIMIT 1",
            [$shift]
        );
        $data["trip"] = $getShitDetails->row();
        $getTripEmployeeData = $this->db->query(
            "SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt
                            FROM  tb_trip_employee e
                            WHERE e.trip_id= ? ",
            [$tripId]
        );
        $imei = $getTripDetails->row()->start_imei;
        $endImei = $getTripDetails->row()->end_imei;
        $driverId = $getTripDetails->row()->driver_id;
        $vehicleId = $getTripDetails->row()->vehicle_id;
        $starteTime = $getShitDetails->row()->startdate;
        $endTime = $getShitDetails->row()->enddate;
        $userId = $getShitDetails->row()->user_id;
        $tripType = $getTripDetails->row()->trip_type;
        $vendorId = 0;
        $dlat = $dlng = "";
        $trucksQuery = $this->db->query(
            "select truck_capacity,vendor_id,latitude,longitude
                            from tb_trucks_data
                            WHERE id=?
                            LIMIT 1",
            [$vehicleId]
        );
        $cabCapacity = 0;
        if ($trucksQuery->num_rows() > 0) {
            $cabCapacity = $trucksQuery->row()->truck_capacity;
            $vendorId = $trucksQuery->row()->vendor_id;
            $dlat = $trucksQuery->row()->latitude;
            $dlng = $trucksQuery->row()->longitude;
        }
        if ($dlat == "") {
            $dlat = $getTripDetails->row()->plat;
            $dlng = $getTripDetails->row()->plng;
        }
        if ($dlat == $getTripDetails->row()->plat) {
            $dlat = $getShitDetails->row()->elat;
            $dlng = $getShitDetails->row()->elng;
        }
        $this->common->updatetbledata("tb_trips", ["dlat" => $dlat, "dlng" => $dlng], ["id" => $tripId]);
        $vehicleTripInfo = ["plat" => $getTripDetails->row()->plat, "plng" => $getTripDetails->row()->plng, "dlat" => $dlat, "dlng" => $dlng];
        $data['tripinfo'] = (object)$vehicleTripInfo;
        if ($cabCapacity == "") {
            $cabCapacity = 0;
        }
        $getDriversData = $this->db->query(
            "select name,contact_num,vendor_id
                            from tb_truck_drivers
                            WHERE id=$driverId
                            LIMIT 1"
        );
        if ($getDriversData->num_rows() > 0) {
            $data['driver_name'] = $getDriversData->row()->name;
            $data['driver_num'] = $getDriversData->row()->contact_num;
            $vnid = $getDriversData->row()->vendor_id;
            if ($vendorId == 0 && $vnid != 0) {
                $vendorId = $vnid;
            }
        }
        $getRtDriverlocations = $this->db->query(
            "select latitude,longitude
                    FROM tb_rtdrive_locations
                    WHERE trip_id= ?
                    order by timestamp DESC",
            [$tripId]
        );
        $lat = $lng = $distance = $flag = 0;
        $queryResult = $getRtDriverlocations->result_array();
        $finalResult = array_reverse($queryResult);
        foreach ($finalResult as $row) {
            if ($flag == 0) {
                $flag = 1;
            } else {
                $a = calculateDistance12($lat, $lng, $row['latitude'], $row['longitude']);
                $distance += $a;
            }
            $lat = $row['latitude'];
            $lng = $row['longitude'];
        }
        $attendemp = 1;
        $totalEmployeeCount = getempcount($tripId);
        if ($getTripEmployeeData->num_rows() > 0) {
            $attendemp = $getTripEmployeeData->row()->attcnt;
        }
        $data["noofemp"] = $totalEmployeeCount;
        $driverLate = 0.00;
        $setime = date("Y-m-d H:i:s", strtotime($getShitDetails->row()->setime));
        $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($getTripDetails->row()->tetime))));
        $toTime = strtotime($setime);
        $fromTime = strtotime($tetime);
        if ($fromTime > $toTime) {
            $driverLate = round(abs($fromTime - $toTime) / 60, 2);
        }
        $checkTrip = $this->common->gettblrowdata(["trip_id" => $tripId], "id", "tb_trip_summary", 0, 0);
        if (empty($checkTrip)) {
            $this->common->insertTableData(
                "tb_trip_summary",
                ['trip_id' => $tripId, 'vehicle_id' => $vehicleId, 'driver_id' => $driverId, 'vendor_id' => $vendorId, 'trip_distance' => $distance, 'no_of_emp' => $totalEmployeeCount, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $endImei, 'start_time' => $starteTime, 'end_time' => $endTime, 'user_id' => $userId, 'cab_capacity' => $cabCapacity, 'trip_status' => 1, 'trip_type' => $tripType, 'ship_delay' => $driverLate, 'createdon' => $currentDate]
            );
        }
    }

    public function bordersapi($ordid){
        $this->load->helper('border_helper');
        borderconsignment(array('ordid'=>$ordid));
    }

}
