<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}
class Broadcomreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}

        $this->load->model('common');
        $this->load->model('aquaticamodel');
        $this->load->model('truckwaybillmodel');
        $this->load->model('broadcomreportmodel');
        if (!checkUrlAccessForUser('BROADCOMREPORT')) {
            redirect("Forbiddenaccess");
        }

    }
	
    public function index()
    {

        $data = array();
		$data["page_title"] = $this->lang->line('broadcom_inbound');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["broadcomdata"]= $data["customername"]=array();

        $where='';
            if ($_POST) {
                 if (!empty($this->input->post('trackingnumber',true)) || !empty($this->input->post('trackingnumber_a',true)) ) {
                     $trackingnumber=$this->input->post('trackingnumber',true)==""?$this->input->post('trackingnumber_a',true):$this->input->post('trackingnumber',true);

                     $where.=" AND tor.`ref_value`='".$trackingnumber."'";
                 }

                if (!empty($this->input->post('status',true))) {
                     $status=$this->input->post('status',true);
                     if($status=='PENDING'){
                        $where.=" AND tod.status != 0 AND tod.trip_id=0";
                     }
                     if($status=='ACTIVE'){
                         $where.=" AND tod.status != 0 AND tod.trip_id !=0 AND tod.trip_sts=0";
                     }
                     if($status=='CLOSED'){
                         $where.="AND tod.status != 0 AND tod.trip_id !=0 AND tod.trip_sts=1";
                     }

                 }
                 if (!empty($this->input->post('fromDate',true)) || !empty($this->input->post('fromDate_a',true))) {
                     $fromDate=$this->input->post('fromDate',true)==""?$this->input->post('fromDate_a',true):$this->input->post('fromDate',true);
                     $where.=" AND  (DATE_FORMAT(tod.createdon,'%Y-%m-%d') >='".date('Y-m-d', strtotime($fromDate))."')";
                 }

                if (!empty($this->input->post('toDate',true)) || !empty($this->input->post('toDate_a',true))) {
                     $toDate=$this->input->post('toDate',true)==""?$this->input->post('toDate_a',true):$this->input->post('toDate',true);
                    $where.=" AND  (DATE_FORMAT(tod.createdon,'%Y-%m-%d') <='".date('Y-m-d', strtotime($toDate))."')";

                 }

                if (!empty($this->input->post('customer_name',true)) || !empty($this->input->post('cusomerid',true))) {
                      $customercode=$this->input->post('customer_name',true)==""?$this->input->post('cusomerid',true):$this->input->post('customer_name',true);
                      $where.=" AND tc.code='".$customercode."'";
                 }
                 $reports=$this->broadcomreportmodel->getorderdata($where);

                 $data['broadcomdata']=$reports[0]['broadcomdata'];
            }

			$data['customername']=$this->broadcomreportmodel->getcustomernames();

        $this->newtemplate->dashboard("broadcomreport/index", $data);
    }

    public function getrefdetails(){
        $data =  array();
        $user_id = $this->session->userdata('user_id');
        $post = $this->input->post(null,true);
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        if($user_id != "" && $searchTerm != ""){
            $where='AND ((tor.reference_id="INN" AND tor.ref_value LIKE "%'.$searchTerm.'%") OR (tor.reference_id="DQ" AND tor.ref_value LIKE "%'.$searchTerm.'%"))';
            $reports=$this->broadcomreportmodel->getrefdetails($where);
             $data=$reports;
        }
        echo json_encode($data);
    }

    public function getcustomerdetails(){
        $data =  array();
        $user_id = $this->session->userdata('user_id');
        $post = $this->input->post(null,true);
        $searchTerm = isset($post['customercode']) ? $post['customercode'] : "";
        if($user_id != "" && $searchTerm != ""){
            $where=' AND (tc.code  LIKE "%'.$searchTerm.'%")';
            $reports=$this->broadcomreportmodel->getcustomerdetails($where);
            $data=$reports;
        }
        echo json_encode($data);
    }
}
