<?php if (!defined('BASEPATH')) { exit('No direct script access allowed'); }
class CNKNReports extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('user_id')===NULL) {
			redirect('login');
		}
	}

	public function index():void {
		$this->getSearchResults();
	}

	private function getSearchResults():void {
		$this->newtemplate->dashboard("cnkn-reports/index", []);
	}

	public function ajaxListing(): void {
		$this->load->model('DataArrayFormatter_model');
		$this->load->model('DataQueryFormatter_model');
		$this->load->model('Datatables_model');
		$whereCondition = $post = [];
		$draw  = $this->input->post( 'draw',TRUE );
		$start = $this->input->post( 'start',TRUE );
		$limit =  $this->input->post('length',TRUE );
		$orderBy =  $this->input->post('order',TRUE );
		$indexColumn = 'o.id';
		$post   = $this->input->post( 'data',TRUE );
		$custid = $status_search = $epodp_date = $pod_status_date = $status_date = $wherecondition="";
		$curtz = $this->session->userdata("usr_tzone")['timezone'];
		$userid = $this->session->userdata("user_id");
		if(!empty($this->session->userdata("cust_id"))) {
			$custid = $this->session->userdata("cust_id");
		}
		$aquorder = $where = $wherein =  $subcusts  = [];
		$business_type = $this->session->userdata('business_type');
		$companyCode   = $this->session->userdata('company_code');
		$branchCode   = $this->session->userdata('branch_code');
		$whereCondition = $this->searchFilter($post);
		if(!empty($custid)) {
			if($this->session->userdata('sub_cust') !== FALSE) {
				$subcusts = $this->session->userdata('sub_cust');
				if(!empty($subcusts)){
					array_push($subcusts, $custid);
				} else {
					$subcusts = [$custid];
				}
			} else {
				$subcusts = [$custid];
			}
		}
		$orderTableCondition=[];
		$bindings = [];
		$orderTableCondition[]='o.status != ? ';
		$bindings[] = 0;
		if (!empty($whereCondition)) {
			foreach ($whereCondition as $key=>$value) {
				if ($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=") {
					$orderTableCondition[]= $key." ? ";
					$bindings[] = $value;
				} else {
					$orderTableCondition[]= $key." = ? ";
					$bindings[] = $value;
				}
			}
		}
		if (!empty($subcusts) && count($subcusts) > 0) {
			$bindings[] = $subcusts;
			$orderTableCondition[]=" o.customer_id IN ?";
		} else {
			if ($custid != "") {
				$bindings[] = $custid;
				$orderTableCondition[]=" o.customer_id = ? ";
			}
		}
		if (!empty($branchCode) && (int) $this->session->userdata('user_role_id') === 2) {
            $bindings[] = $branchCode;
            $orderTableCondition[] = " o.branch_code = ? ";
        }
		$orderTableWhere = implode(' AND ',$orderTableCondition);
		if ($orderTableWhere!='') {
			$orderTableWhere=" AND $orderTableWhere ";
		}

		$orderByCondition='';
		if (isset($orderBy[0])) {
			if ($orderBy[0]!='') {
				$ordColIndex= $orderBy[0]['column'];
				$ordColDir= $orderBy[0]['dir'];
				if ($ordColDir=='') {
					$ordColDir = 'asc';
				}
				if (isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex]!='' ) {
					$orderByCondition='  '.$dataTableSortOrdering[$ordColIndex].' '.$ordColDir.' ';
				}
			}
		}
		$compiledCount=0;
		$resultSet=$this->db->query("SELECT count(o.id) as count
			FROM tb_orders o
			LEFT JOIN tb_order_details d ON o.id = d.order_row_id
			WHERE 1 $orderTableWhere
			", $bindings);

		if ($resultSet->num_rows()>0) {
			$resdata = $resultSet->result_array();
			if (isset($resdata[0]['count'])) {
				$compiledCount=$resdata[0]['count'];
			}
		} else {
			$compiledCount=0;
		}
		$currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
		$selectColumns = [
			"o.id,o.order_id,convertToClientTZ(o.pickup_datetime,'{$currentTimeZone}') as early_pickup_datetime,o.chargeable_weight,o.chargeable_weight_uom,o.status,o.createdon,o.shift_id,o.quantity,o.weight,o.volume,(SELECT quantity_type FROM tb_order_cargodetails WHERE order_id = o.id AND `status` = 1 LIMIT 1) AS quantity_type,ct.name as customer_name"
		];
		$tableName='tb_orders o';
		$indexColumn='o.id';
		$groupBy='o.id';
		$excludeCountQuery='Yes';
		$wherecondition = $indexColumn . "!='' " . $orderTableWhere;
		$timeZone = $curtz;
		$joinsArray[]=['table_name'=>'tb_order_details as d','condition'=>"o.id=d.order_row_id",'join_type'=>'left'];
		$joinsArray[]=['table_name'=>'tb_customers as ct','condition'=>"o.customer_id=ct.id",'join_type'=>'left'];
		foreach ($bindings as $param) {
			$wherecondition = preg_replace(
				'#\?#',
				is_array($param) ? " (" . implode(", ", array_map(function($item) {
					return $this->db->escape($item);
				}, $param)).") " : $this->db->escape($param),
				$wherecondition,
				true
			);
		}
		$dataTableSortOrdering=[];
		$getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $tableName, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );

		$reqData=['id','shift_id'];
		$this->db->query('SET SESSION  group_concat_max_len=10240');
		$formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
		if(isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id']!=''){
			$reqStatus="0500,3000";
			$refCodes = "'SAD','REM','XSR','SAC','SLA','DLA'";
			$formattedData = $this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$refCodes);
		}
		if ($excludeCountQuery=='Yes') {
			$totalRecords     = $compiledCount;
			$recordsFiltered  = $compiledCount;
		} else {
			$totalRecords     = $getRecordListing['recordsTotal'];
			$recordsFiltered  = $getRecordListing['recordsFiltered'];
		}
		$getRecordListing=[];
		if (isset($formattedData['orders'])) {
			$getRecordListing=$formattedData['orders'];
			krsort($getRecordListing);
		}
		$recordListing    = [];
		$content          = '[';
		$i                 = 0;
		$srNumber = $start;
		if (!empty($getRecordListing)) {
			$actionContent = '';
			$cntr=1;
			foreach ($getRecordListing as $res) {
				$salogSAD = $salog_ref = $salogREM = $salog_SAC = $salog_SLA = $salog_DLA = $referenceData = "";
				if (isset($res['reference_value'])) {
					$referenceData = $res['reference_value'];
				}
				if ($referenceData != '') {
					$arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
					$salogSAD = isset($arrayData['SAD']) ? $arrayData['SAD'] : '';
					$salog_ref = isset($arrayData['XSR']) ? $arrayData['XSR']: '';
					$salogREM = isset($arrayData['REM']) ? $arrayData['REM'] : '';
					$salog_SAC = isset($arrayData['SAC']) ? $arrayData['SAC'] : '';
					$salog_SLA = isset($arrayData['SLA']) ? $arrayData['SLA'] : '';
					$salog_DLA = isset($arrayData['DLA']) ? $arrayData['DLA'] : '';
				}
				$earlyPickupDateTime = (!empty($res['early_pickup_datetime'])) ? $res['early_pickup_datetime'] :  "" ;
				$content .= '[';
				$j=0;
				$recordListing[$i][0]  = '';
				$recordListing[$i][++$j]  = $res['customer_name'];
				$recordListing[$i][++$j]  = $res['order_id'];
				$recordListing[$i][++$j]  = $salog_SAC;
				$recordListing[$i][++$j]  = $salog_ref;
				$recordListing[$i][++$j]  = number_format($res['quantity']);
				$recordListing[$i][++$j]  = $res['quantity_type'];
				$recordListing[$i][++$j]  = number_format($res['weight']);
				$recordListing[$i][++$j]  = $res['volume'];
				$recordListing[$i][++$j]  = $salogSAD;
				$recordListing[$i][++$j]  = date('d-m-Y',strtotime($earlyPickupDateTime));
				$recordListing[$i][++$j]  = date('H:i:s',strtotime($earlyPickupDateTime));
				$recordListing[$i][++$j]  = $salogREM;
				$recordListing[$i][++$j]  = $salog_SLA;
				$recordListing[$i][++$j]  = $salog_DLA;
                $recordListing[$i][++$j]  = $res['chargeable_weight']. " ".$res['chargeable_weight_uom'];
				$i ++;
				$cntr++;
			}
			$content    .= ']';
			$final_data = json_encode( $recordListing );
		} else {
			$final_data = '[]';
		}
		echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
	}

	public function searchFilter(array $post = []) : array {
		$whereCondition = [];
		$whereCondition["o.company_code"] = $this->session->userdata('company_code');
		$whereCondition["o.created_source"] = 5;
		if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
			$fromdate_search = date('Y-m-d', strtotime($post['fromdate_search']));
			$whereCondition["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
		}

		if (isset($post['todate_search']) && $post['todate_search'] != "") {
			$todate_search = date('Y-m-d', strtotime($post['todate_search']));
			$whereCondition["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate_search;
		}
		return $whereCondition;
	}
}
