<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cabreports extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('cabmodel');
        if (!checkUrlAccessForUser('CABREPORTS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->slareports();
    }

    public function slareports()
    {
        $data["table_search"] = $whr = "";
        $userid = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $enddt = date('Y-m-d');
        $getactual = getdatetimebytimezone(DFLT_TZ, $enddt, $curtz);
        $enddt = $getactual['date'];
        $startdt = date('Y-m-d', strtotime('-7 days'));
        $getactual = getdatetimebytimezone(DFLT_TZ, $startdt, $curtz);
        $startdt = $getactual['datetime'];
        $post = [
            'fromdate_search' => $startdt,
            'todate_search' => $enddt,
            'driver_search' => '',
            'vehicle_search' => '',
            'shift_search' => [],
            'user_id' => $userid,
            'zone_search' => '',
            'type_search' => ''
        ];
        if ($_POST) {
            $post = $_POST;
            if (isset($post["todate_search"]) && strlen($post["todate_search"]) > 0) {
                $enddt = date('Y-m-d H:i:s', strtotime($post["todate_search"]));
                $getactual = getdatetimebytimezone(DFLT_TZ, $enddt, $curtz);
                $post["todate_search"] = $getactual['date'];
            }
            if (isset($post["fromdate_search"]) && strlen($post["fromdate_search"]) > 0) {
                $startdt = date('Y-m-d H:i:s', strtotime($post["fromdate_search"]));
                $getactual = getdatetimebytimezone(DFLT_TZ, $startdt, $curtz);
                $post["fromdate_search"] = $getactual['date'];
            }
        }
        $post['user_id'] = $userid;
        $data['page_title'] = $this->lang->line('menu_reports');
        $data['sub_title'] = $this->lang->line('menu_slaoccupancy_reports');
        $tripscount = $this->cabmodel->getslareports($post, 0, 0)->num_rows();
        $data['tripscount'] = $tripscount;
        $config = [];
        $config["base_url"] = base_url() . "cabreports/slareports";
        $config["total_rows"] = $tripscount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['tripsdata'] = $this->cabmodel->getslareports($post, $config["per_page"], $page);
        $data['post'] = $post;
        $data['tripsummarydata'] = $this->cabmodel->getslasummary($post);
        $whr = ["id >" => 0];
        $select = "id,stime,etime,splace,eplace,created_on";
        $zwhr = ["id >" => 0, "status" => 'Active', "user_id" => $userid];
        $zselect = "id,zone_name,splace,eplace";
        if ($this->session->userdata("business_type") != "Carrier") {
            $data['shifts'] = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where user_id=? and status=? ORDER BY startdate DESC",[$userid,0])->result_array();
        } else {
            $userid = $this->session->userdata('id');
            $data['shifts'] = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where vendor_id=? and status=? ORDER BY startdate DESC",[$userid,0])->result_array();
        }
        $data['zones'] = $this->cabmodel->getTableData('tb_shift_zones', $zwhr, $zselect);
        $this->settemplate->dashboard("cabreports/slareports", $data);
    }

    public function shiftreports()
    {
        $data["table_search"] = $whr = "";
        $userid = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $enddt = date('Y-m-d');
        $startdt = date('Y-m-d', strtotime('-7 days'));
        $post = [
            'fromdate_search' => $startdt,
            'todate_search' => $enddt,
            'driver_search' => '',
            'vehicle_search' => '',
            'shift_search' => '',
            'user_id' => $userid,
            'zone_search' => '',
            'type_search' => ''
        ];
        if ($_POST) {
            $post = $_POST;
        }
        $post['user_id'] = $userid;
        $data['page_title'] = $this->lang->line('menu_reports');
        $data['sub_title'] = $this->lang->line('shipment_reports');
        $tripscount = $this->cabmodel->getshiftreports($post, 0, 0)->num_rows();
        $data['tripscount'] = $tripscount;
        $config = [];
        $config["base_url"] = base_url() . "cabreports/shiftreports";
        $config["total_rows"] = $tripscount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['tripsdata'] = $this->cabmodel->getshiftreports($post, $config["per_page"], $page);
        $data['post'] = $post;
        if ($this->session->userdata("business_type") != "Carrier") {
            $data['shifts'] = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where user_id=? and status=? ORDER BY startdate DESC",[$userid,0])->result_array();
        } else {
            $userid = $this->session->userdata('id');
            $data['shifts'] = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where vendor_id=? and status=? ORDER BY startdate DESC",[$userid,0])->result_array();
        }
        $this->settemplate->dashboard("cabreports/shiftreports", $data);
    }

    public function emplevel()
    {
        $data["table_search"] = $whr = "";
        $userid = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $enddt = date('Y-m-d');
        $getactual = getdatetimebytimezone(DFLT_TZ, $enddt, $curtz);
        $enddt = $getactual['date'];
        $startdt = date('Y-m-d', strtotime('-7 days'));
        $getactual = getdatetimebytimezone(DFLT_TZ, $startdt, $curtz);
        $startdt = $getactual['datetime'];
        $post = [
            'fromdate_search' => $startdt,
            'todate_search' => $enddt,
            'vehicle_search' => '',
            'shift_search' => [],
            'emp_search' => '',
            'user_id' => $userid,
            'zone_search' => '',
            'type_search' => ''
        ];
        if ($_POST) {
            if (isset($_POST['searchsubmit'])) {
                $post = $_POST;
                if (isset($post["todate_search"]) && strlen($post["todate_search"]) > 0) {
                    $enddt = date('Y-m-d H:i:s', strtotime($post["todate_search"]));
                    $getactual = getdatetimebytimezone(DFLT_TZ, $enddt, $curtz);
                    $post["todate_search"] = $getactual['date'];
                }
                if (isset($post["fromdate_search"]) && strlen($post["fromdate_search"]) > 0) {
                    $startdt = date('Y-m-d H:i:s', strtotime($post["fromdate_search"]));
                    $getactual = getdatetimebytimezone(DFLT_TZ, $startdt, $curtz);
                    $post["fromdate_search"] = $getactual['date'];
                }
            } else {
                if (isset($_POST['searchexportsubmit'])) {
                    $post = $_POST;
                    if (isset($post["todate_search"]) && strlen($post["todate_search"]) > 0) {
                        $enddt = date('Y-m-d H:i:s', strtotime($post["todate_search"]));
                        $getactual = getdatetimebytimezone(DFLT_TZ, $enddt, $curtz);
                        $post["todate_search"] = $getactual['date'];
                    }
                    if (isset($post["fromdate_search"]) && strlen($post["fromdate_search"]) > 0) {
                        $startdt = date('Y-m-d H:i:s', strtotime($post["fromdate_search"]));
                        $getactual = getdatetimebytimezone(DFLT_TZ, $startdt, $curtz);
                        $post["fromdate_search"] = $getactual['date'];
                    }
                    $this->dwnslareport($post);
                }
            }
        }
        $post['user_id'] = $userid;
        $data['page_title'] = "Reports";
        $data['sub_title'] = "Shipment Level Reports";
        $tripscount = $this->cabmodel->getempreports($post, 0, 0)->num_rows();
        $data['tripscount'] = $tripscount;
        $config = [];
        $config["base_url"] = base_url() . "cabreports/emplevel";
        $config["total_rows"] = $tripscount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['tripsdata'] = $this->cabmodel->getempreports($post, $config["per_page"], $page);
        /*echo $this->db->last_query();
        exit;*/
        $data['post'] = $post;
        $data['empdelaysummarydata'] = $this->cabmodel->getempsummary($post);
        /*echo $this->db->last_query();
        exit;*/
        $whr = ["id >" => 0];
        $select = "id,stime,etime,splace,eplace,created_on";
        //$data['shifts'] = $this->cabmodel->getTableData('tb_shifts',$whr,$select);
        if ($this->session->userdata("business_type") != "Carrier") {
            $data['shifts'] = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where user_id=? and status=? ORDER BY startdate DESC",[$userid,0])->result_array();
        } else {
            $userid = $this->session->userdata('id');
            $data['shifts'] = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where vendor_id=? and status=? ORDER BY startdate DESC",[$userid,0])->result_array();
        }
        $zwhr = ["id >" => 0, "status" => 'Active', "user_id" => $userid];
        $zselect = "id,zone_name,splace,eplace";
        $data['zones'] = $this->cabmodel->getTableData('tb_shift_zones', $zwhr, $zselect);
        $this->settemplate->dashboard("cabreports/emplevelreports", $data);
    }

    public function dwnslareport($search = null)
    {
        $post = $_POST;
        $data["table_search"] = $whr = "";
        $userid = $this->session->userdata('user_id');
        $post['user_id'] = $userid;
        $data['page_title'] = "Reports";
        $data['post'] = $post;
        $data['sub_title'] = "Emp. Level Reports";
        $data['searchtype'] = $search;
        if ($search == "" || $search == 1) {
            $data['tripsummarydata'] = $this->cabmodel->getslasummary($post);
        } else {
            $data['tripsdata'] = $this->cabmodel->getslareports($post, 0, 0);
        }
        $file = 'SLAReport' . date("Ymdhis") . '.xls';
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        header('Content-type: application/x-msexcel');
        header("Content-Disposition: attachment; filename=$file");
        $this->load->view('excelexport/slareport', $data);
    }

    public function dwnshiftreport($search = null)
    {
        $post = $_POST;
        $data["table_search"] = $whr = "";
        $userid = $this->session->userdata('user_id');
        $post['user_id'] = $userid;
        $data['page_title'] = "Reports";
        $data['post'] = $post;
        $data['sub_title'] = "Shipment Reports";
        $data['searchtype'] = $search;
        $data['tripsdata'] = $this->cabmodel->getshiftreports($post, 0, 0);
        $file = 'ShipmentReport' . date("Ymdhis") . '.xls';
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        header('Content-type: application/x-msexcel');
        header("Content-Disposition: attachment; filename=$file");
        $this->load->view('excelexport/shiftexport', $data);
    }

    public function dwnempreport($search = null)
    {
        $post = $_POST;
        $data["table_search"] = $whr = "";
        $userid = $this->session->userdata('user_id');
        $post['user_id'] = $userid;
        $data['page_title'] = "Reports";
        $data['post'] = $post;
        $data['sub_title'] = "Emp. Level Reports";
        $data['searchtype'] = $search;
        if ($search == "" || $search == 1) {
            $data['empdelaysummarydata'] = $this->cabmodel->getempsummary($post);
        } else {
            $data['tripsdata'] = $this->cabmodel->getempreports($post, 0, 0);
        }
        $file = 'Shipment_Report' . date("Ymdhis") . '.xls';
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        header('Content-type: application/x-msexcel');
        header("Content-Disposition: attachment; filename=$file");
        $this->load->view('excelexport/empreport', $data);
    }

    public function unfinishtrips()
    {
        $curdt = date('Y-m-d H:i:s');
        $gettrips = $this->cabmodel->getunfinishtrips();
        if ($gettrips->num_rows() > 0) {
            foreach ($gettrips->result() as $rw) {
                $tripid = $rw->id;
                $set = ["status" => 0, 'updated_on' => $curdt];
                $where = ["id" => $rw->id];
                $update = $this->db->set($set)->where($where)->update("tb_trips");
                $e = str_replace('.', ':', $rw->etime);
                $start = $rw->tripstart;
                $st = date('Y-m-d', strtotime($rw->tripstart));
                $e = $st . " " . str_replace('.', ':', $e) . ":00";
                $etime = strtotime($e);
                $addetime = date('Y-m-d H:i:s', strtotime("+1 hours", $etime));
                $end = $addetime;
                $vehicleid = $rw->vehicle_id;
                $driverid = $rw->driver_id;
                $shift = $rw->shift_id;
                $imei = $rw->start_imei;
                $data = [];
                $this->db->select('latitude,longitude,timestamp');
                $this->db->from('tb_rtdrive_locations');
                $this->db->where('mobileimei', $imei);
                $this->db->where('timestamp>=', $start);
                $this->db->where('timestamp<=', $end);
                $llDetails = $this->db->get();

                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($llDetails->num_rows() > 0) {
                    foreach ($llDetails->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $uid = $cab_capacity = $attendemp = $totalemp = 0;
                $emp = $this->db->query(
                    "SELECT IFNULL(t.truck_capacity,0) AS capacity, IFNULL(SUM( IF( e.status = '1', 1, 0 ) ),0) AS attcnt, count(e.employee_id) AS totcnt FROM tb_trips p, tb_trip_employee e, tb_trucks_data t WHERE p.vehicle_id = t.id AND p.status =0 AND e.trip_id = p.id AND p.id=" . $tripid
                );
                if ($emp->num_rows() > 0) {
                    $cab_capacity = $emp->row()->capacity;
                    $attendemp = $emp->row()->attcnt;
                    $totalemp = $emp->row()->totcnt;
                }
                $uids = $this->cabmodel->getuserbytrip(["t.id" => $tripid]);
                if ($uids->num_rows() > 0) {
                    $uid = $uids->row()->user_id;
                }
                $arr = [
                    'trip_id' => $tripid,
                    'vehicle_id' => $vehicleid,
                    'driver_id' => $driverid,
                    'trip_distance' => $dist,
                    'no_of_emp' => $totalemp,
                    'attended_emp' => $attendemp,
                    'start_imei' => $imei,
                    'end_imei' => $imei,
                    'start_time' => $start,
                    'end_time' => $end,
                    'user_id' => $uid,
                    'cab_capacity' => $cab_capacity,
                    'trip_status' => 1,
                    'createdon' => $curdt
                ];
                $chktrip = $this->db->select("id")->get_where(
                    "tb_trip_summary",
                    ["trip_id" => $tripid],
                    1,
                    0
                )->num_rows();
                if ($chktrip == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
            }
        }
    }

    public function getZoneShifts()
    {
        $zone = $_POST["zone"];
        $user_id = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if (count($zone) == 0) {
            $shifts = $this->db->select(
                "id,splace,eplace,convertToClientTZ(startdate,'" . $curtz . "') as stime,convertToClientTZ(enddate,'" . $curtz . "') as etime"
            )->where(["user_id" => $user_id])->get("tb_shifts");
        } else {
            $shifts = $this->db->select(
                "id,splace,eplace,convertToClientTZ(startdate,'" . $curtz . "') as stime,convertToClientTZ(enddate,'" . $curtz . "') as etime"
            )->where(["zone_id" => $zone, "user_id" => $user_id])->get("tb_shifts");
        }
        if ($shifts->num_rows() > 0) {
            echo json_encode($shifts->result_array());
        }
    }

    public function getpoints($trip_id = 'null')
    {
        $data = ["latlngs" => "", "trip" => ""];
        if ($trip_id != 'null') {
            $a = 0;
            $this->db->select('l.* ');
            $this->db->from('tb_trips t');
            $this->db->join("tb_rtdrive_locations l", "t.start_imei=l.mobileimei", "INNER");
            $this->db->where('l.timestamp > t.stime');
            $this->db->where('l.timestamp < t.etime');
            $this->db->where('t.id', 1);
            $this->db->order_by('l.id', 'ASC');
            $latlngs = $this->db->get();
            $data["trip"] = $this->db->where("id", $trip_id)->get("tb_trips");
            $data["latlngs"] = $latlngs;
        } else {
            $a = 1;
        }
        if ($a == 1) {
            redirect("cabreports/slareports");
        }
        $this->settemplate->dashboardtemp("getpoints", $data);
    }

    public function getAttachments()
    {
        $trip_id = $_POST["trip_id"];
        $stop = isset($_POST["tstop"]) ? $_POST["tstop"] : '';
        if ($stop != "") {
            $this->db->select('pu.*,dt.type_name');
            $this->db->from('tb_pod_uploads pu');
            $this->db->join("tb_document_types dt", "pu.doc_type=dt.id", "INNER");
            $this->db->where('pu.trip_id', $trip_id);
            $this->db->where('pu.stop_id', $stop);
            $data["docs"] = $this->db->get();
        } else {
            $this->db->select('pu.*,dt.type_name');
            $this->db->from('tb_pod_uploads pu');
            $this->db->join("tb_document_types dt", "pu.doc_type=dt.id", "INNER");
            $this->db->where('pu.trip_id', $trip_id);
            $data["docs"] = $this->db->get();
        }
        echo $this->load->view("cabreports/attachements", $data, true);
    }
}

?>
