<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
use phpseclib\Net\SFTP;
class Carrier extends CI_Controller
{
    private const  KNLOGIN_EPOD_PATH = "/pub/inbound/D3/FO";
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id')) {
        } else {
            redirect("login");
        }
        $this->load->library('uuid');
        $this->load->helper("log_helper");
        $this->load->library(['sendpodtoknservice','StatusRemappingService']);
        $this->load->model(['ShipmentVisibilityModel', 'common','Completedordersmodel','Order_details']);
        if (!checkUrlAccessForUser('CARRIER')) {
            redirect("Forbiddenaccess");
        }
    }

    public function dashboard()
    {
        $data = array();
        $pdate = $ddate = array();
        $curtz1 = $this->session->userdata('usr_tzone');
        $curtz = $curtz1['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $cdate = $getactual['date'];
        $btype = $this->session->userdata("business_type");
        $whr = "";
        $userid = 0;
        $cid = $this->session->userdata('id');
        if ($cid != "") {
            $carrierCondition = $this->getCarrierCondition($cid);
            $carrierIds = implode("','", $carrierCondition);
            $whr .= "e.vendor_id IN ('" . $carrierIds . "')";
            /*active bookings*/
            $this->db->select('e.id');
            $this->db->where('e.status != 0');
            $this->db->where('e.trip_id != 0');
            $this->db->group_start();
            $this->db->where('e.trip_id != 0');
            $this->db->or_group_start();
            $this->db->where('e.trip_id = 0');
            $this->db->where('(SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=e.order_id) > 0');
            $this->db->group_end();
            $this->db->group_end();
            $this->db->where('e.trip_sts = 0');
            $this->db->where($whr);
            $this->db->group_by('e.order_id');
            $activeBookings = $this->db->get('tb_orders e');
            $data['activebooks'] = $activeBookings->num_rows();

            /*pending bookings*/
            $this->db->select('e.id');
            $this->db->where('e.status != 0');
            $this->db->where('e.trip_id = 0');
            $this->db->group_start();
            $this->db->where('e.trip_id = 0');
            $this->db->where('(SELECT COUNT(trip_id) FROM tb_employee WHERE order_id = e.order_id) = 0');
            $this->db->group_end();
            $this->db->where('e.trip_sts = 0');
            $this->db->where($whr);
            $this->db->group_by('e.order_id');
            $pendingBookings = $this->db->get('tb_orders e');
            $data['pendbooks'] = $pendingBookings->num_rows();

            /*completed bookings*/
            $this->db->select('e.id');
            $this->db->where('e.trip_sts = 1');
            $this->db->where($whr);
            $completedBookings = $this->db->get('tb_orders e');
            $data['donebooks'] = $completedBookings->num_rows();

            /*alerts*/
            $data['alertbooks'] = 0;
            $sql = "SELECT COUNT(a.id) AS ordcount, DATE_FORMAT(merge_date, '%Y-%m-%d') AS ordtime
                    FROM (SELECT DATE(now()) AS merge_date
                          UNION
                          SELECT DATE_ADD(NOW(), INTERVAL 1 DAY) AS merge_date
                          UNION
                          SELECT DATE_ADD(NOW(), INTERVAL 2 DAY) AS merge_date
                          UNION
                          SELECT DATE_ADD(NOW(), INTERVAL 3 DAY) AS merge_date
                          UNION
                          SELECT DATE_ADD(NOW(), INTERVAL 4 DAY) AS merge_date
                          UNION
                          SELECT DATE_ADD(NOW(), INTERVAL 5 DAY) AS merge_date
                          UNION
                          SELECT DATE_ADD(NOW(), INTERVAL 6 DAY) AS merge_date) AS m
                          LEFT JOIN tb_orders a ON DATE(m.merge_date) = DATE(a.pickup_datetime)
                          AND a.vendor_id IN ?  AND a.trip_id != 0 AND DATE(a.pickup_datetime) >= ? AND a.trip_sts = 0
                    GROUP BY m.merge_date
                    ORDER BY 1 + 1
                    LIMIT 7";
            $ordersIdsPerDays = $this->db->query($sql, [$carrierCondition, $cdate]);
            $data['forcat'] = array();
            if ($ordersIdsPerDays->num_rows() > 0) {
                foreach ($ordersIdsPerDays->result() as $rs) {
                    $ordt = $rs->ordtime;
                    $getactual = getdatetimebytimezone($curtz, $rs->ordtime, DFLT_TZ);
                    $ordtime = $getactual['date'];

                    $this->db->select('e.id');
                    $this->db->where('e.trip_id != 0');
                    $this->db->where('e.trip_sts = 0');
                    $this->db->where("DATE(e.delivery_datetime)", $ordt);
                    $this->db->where($whr);
                    $ordersIds = $this->db->get('tb_orders e');

                    if ($ordersIds->num_rows() > 0) {
                        $data['forcat'][] = array(
                            "pickup" => $rs->ordcount,
                            "tdate" => $ordtime,
                            "deliver" => $ordersIds->num_rows()
                        );
                    } else {
                        $data['forcat'][] = array(
                            "pickup" => '0',
                            "tdate" => $ordtime,
                            "deliver" => $ordersIds->num_rows()
                        );
                    }
                }
            }

            /*customers for chat*/
            $country = $curtz1['country'];
            $data['chatusers'] = array();

            $this->db->select('id, name, mobile_no as phone, "Admin" as utype');
            $this->db->where('status="Active"');
            $this->db->where("country_code", $country);
            $this->db->order_by('online', 'DESC');
            $this->db->limit(20);
            $users = $this->db->get('tb_users');

            if ($users->num_rows() > 0) {
                $data['chatusers'] = $users->result_array();
            }
            if ($this->session->userdata('company_code') === "CNKN") {
                $this->settemplate->dashboard("carrier/dashboard_china", $data);
            } elseif ($this->session->userdata("map_type") == 0) {
                $this->settemplate->dashboard("carrier/dashboard", $data);
            } else {
                if ($this->session->userdata("map_type") == 1) {
                    $this->settemplate->dashboard("carrier/dashboard", $data);
                } else {
                    $this->settemplate->dashboard("carrier/dashboard", $data);
                }
            }
        } else {
            redirect("login");
        }
    }

    public function getActiveTrips()
    {
        $input = $this->input->post();
        $uid = $this->session->userdata('user_id');
        $cid = $this->session->userdata('id');
        $trips = [];
        $whr = "";
        if (isset($input['shipment_id']) && $input['shipment_id'] != "") {
            $sh = trim($input['shipment_id']);
            $whr .= " AND s.shipmentid LIKE '%" . $sh . "%' ";
        }
        
        $sql = $this->common->carriergetactivetripids($whr, $cid);
        if (!empty($sql)) {
            foreach ($sql as $row) {
                $trips[] = array(
                    "id" => $row['id'],
                    "name" => "<div class='btn btn-xs btn-primary' onclick='openTripMap(\"" . $row['id'] . "\",\"" . $row['shipmentid'] . " - " . $row['splace'] . " - " . $row['eplace'] . "\")'>" . $row['shipmentid'] . "</div> " . $row['splace'] . " - " . $row['eplace'],
                );
            }
        }
        echo json_encode($trips);
    }

    public function loadMapVehicles()
    {
        $cid = $this->session->userdata('id');
        $data = array();
        $this->db->select('d.id, d.name, t.id as vehicle_id,t.register_number, tr.id as trip_id');
        $this->db->from('tb_shifts s');
        $this->db->join("tb_trips tr", "tr.shift_id=s.id");
        $this->db->join("tb_trucks_data t", "t.id=tr.vehicle_id", "LEFT");
        $this->db->join("tb_truck_drivers d", "d.id=tr.driver_id", "LEFT");
        $this->db->where('s.vendor_id', $cid);
        $this->db->where('t.status', 'Active');
        $this->db->order_by('t.register_number', 'ASC');
        $this->db->group_by('t.id');
        $shifts = $this->db->get();

        $data["data"] = [];
        if ($shifts->num_rows() > 0) {
            foreach ($shifts->result() as $row) {
                $d = [];
                $d[] = $row->name;
                $d[] = $row->register_number;
                $currentdate = date("Y-m-d");

                $tripgpsinfo = $this->common->getgpslocationbyorder($row->vehicle_id, $currentdate);
                if (!empty($tripgpsinfo)) {
                    $d[] = getLocationName(
                            $tripgpsinfo['latitude'],
                            $tripgpsinfo['longitude']
                        ) . "<input type='hidden' id='position' value='" . $tripgpsinfo['latitude'] . "," . $tripgpsinfo['longitude'] . "'>
                    <input type='hidden' id='speed' value='" . $tripgpsinfo['speed'] . "'><input type='hidden' id='imei' value='" . $tripgpsinfo['mobileimei'] . "'><input type='hidden' id='fuel' value='" . $tripgpsinfo['fuel'] . "'>";
                    if (strlen($tripgpsinfo['speed']) > 0) {
                        $d[] = $tripgpsinfo['speed'] . " KMPH";
                    } else {
                        $d[] = "";
                    }
                    $d[] = (strlen(trim($tripgpsinfo['battery'])) > 0 ? $tripgpsinfo['battery'] . " %" : "");
                    $d[] = getShipDetailByVeh($row->id);
                    if (strlen($tripgpsinfo['receivedon']) > 0) {
                        $d[] = date('d M,Y H:i a', strtotime($tripgpsinfo['receivedon']));
                    } else {
                        $d[] = "";
                    }
                    $data["data"][] = $d;
                }
            }
        }
        echo json_encode($data);
    }

    public function livecabdetails()
    {
        $data['page_title'] = "Dashboard";
        $data['sub_title'] = "Vehicles Live Track Details";
        $this->settemplate->dashboard("carrier/livecabdetails", $data);
    }

    public function ajaxdashboard()
    {
        $userid = $this->session->userdata('user_id');
        $cid = $this->session->userdata('id');
        $this->db->select(
            'v.route_id, v.vehicle_id, v.register_number, ifnull(t.status, 0) as status, ifnull(t.id, 0) as tripid'
        );
        $this->db->from('tb_shifts s');
        $this->db->join("tb_shft_veh v", "v.shft_id = s.id", "INNER");
        $this->db->join("tb_trips t", "t.vehicle_id = v.vehicle_id AND t.status = 1", "LEFT OUTER");
        $this->db->where("v.status = s.status");
        $this->db->where("v.user_id = s.user_id");
        $this->db->where('s.user_id', $userid);
        $this->db->where('s.status', 1);
        $this->db->group_by('v.vehicle_id');
        $this->db->order_by('tripid', 'DESC');
        $this->db->order_by('register_number', 'DESC');
        $data["vehicles"] = $this->db->get();

        $this->db->select(
            's.id,s.stime,s.etime,s.empshift_start,s.startdate,s.trip_type,s.splace,s.eplace,v.id as shft_veh_id,v.route_id,v.vehicle_id,v.register_number,ifnull(t.status,0) as status,ifnull(t.id,0) as tripid,ifnull(t.driver_id,0) as driver_id'
        );
        $this->db->from('tb_shifts s');
        $this->db->join("tb_shft_veh v", "v.shft_id = s.id", "INNER");
        $this->db->join(
            "tb_trips t",
            "t.shift_id = v.shft_id AND t.vehicle_id = v.vehicle_id AND t.status = 1",
            "LEFT OUTER"
        );
        $this->db->where('s.user_id', $userid);
        $this->db->where('v.user_id = s.user_id');
        $this->db->where('s.vendor_id', $cid);
        $this->db->where('s.status', 1);
        $this->db->where('v.status = s.status');
        $this->db->order_by('tripid', 'DESC');
        $this->db->group_by('shft_veh_id');
        $data["vshiftsdata"] = $this->db->get();

        echo $this->load->view("carrier/livecabdetails2", $data, true);
    }

    public function changestatus()
    {
        $trip_id = $_POST["trip_id"];
        $emp_id = $_POST["emp_id"];
        $status = $_POST["status"];
        $this->db->where(array("trip_id" => $trip_id, "employee_id" => $emp_id))->update(
            "tb_trip_employee",
            array(
                "status" => $status,
                "absent_reason" => "Updated by Transport Team"
            )
        );
        $this->ajaxdashboard();
    }

    public function ajax_shifttripdetails()
    {
        $shiftid = isset($_POST['shiftid']) ? $_POST['shiftid'] : '';
        $tripid = isset($_POST['tripid']) ? $_POST['tripid'] : '';
        $temp = array();
        $result['emplist'] = array();
        if ($shiftid != "" && $tripid != "") {
            $this->db->select(
                't.id as tripid, t.vehicle_id, d.name, d.contact_num, s.stime, s.etime,s.splace,s.eplace,v.register_number'
            );
            $this->db->from('tb_trips t');
            $this->db->join('tb_shifts s', 's.id=t.shift_id', 'INNER');
            $this->db->join('tb_truck_drivers d', 't.driver_id=d.id', 'INNER');
            $this->db->join('tb_shft_veh v', 'v.shft_id=s.id AND t.vehicle_id=v.vehicle_id', 'INNER');
            $this->db->where('s.id', $shiftid);
            $this->db->where('t.id', $tripid);
            $this->db->where('t.status', 1);
            $this->db->where('v.status', 1);
            $this->db->order_by('v.id', 'DESC');
            $this->db->limit(1);
            $trips = $this->db->get();

            $temp["employee"] = array();
            $temp["driver"] = $temp["time"] = $temp["trip"] = "";
            $veh = $vehid = "";
            if ($trips->num_rows() > 0) {
                $t = $trips->row();
                $temp["vdriver"] = "<b>Driver : </b>" . $t->name . " - " . $t->contact_num;
                $temp["driver"] = $t->name . " - " . $t->contact_num;
                $temp["trip"] = explode(",", $t->splace)[0] . " - " . explode(",", $t->eplace)[0];
                $temp["vehicle"] = "<a href='" . base_url() . "cab/track/" . encryptIt(
                        $temp["driver"],
                        $temp["trip"]
                    ) . "' target='_blank'>$t->register_number</a>";
                $veh = $t->register_number;
                $vehid = $t->vehicle_id;
            }
            $this->db->select('e.id,e.name,e.phone,e.pickup,e.drop,e.assoc_id,e.ship_type');
            $this->db->from('tb_employee e');
            $this->db->join('tb_shft_veh_emp ve', 'e.id = ve.emp_id', 'INNER');
            $this->db->join('tb_shft_veh vh', 've.shft_veh_id = vh.id', 'INNER');
            $this->db->where('vh.shft_id', $shiftid);
            $this->db->where('vh.vehicle_id', $vehid);
            $this->db->where('vh.status', 1);
            $this->db->where('ve.status', 1);
            $this->db->order_by('ve.priority', 'ASC');
            $emp = $this->db->get();

            if ($emp->num_rows() > 0) {
                $temp["employee"] = array();
                foreach ($emp->result() as $emps) {
                    $checkattend = $this->db->select("status")->get_where(
                        "tb_trip_employee",
                        array(
                            "trip_id" => $tripid,
                            "employee_id" => $emps->id
                        ),
                        1,
                        0
                    );
                    $pickdrop = $emps->pickup;
                    if ($emps->ship_type == 'D') {
                        $pickdrop = $emps->drop;
                    }
                    if ($checkattend->num_rows() > 0) {
                        if ($checkattend->row()->status == "1") {
                            $temp["employee"][] = "<span style='color:black;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                        } else {
                            $temp["employee"][] = "<span style='color:red;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                        }
                    } else {
                        $temp["employee"][] = "<span style='color:black;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                    }
                }
            }
        }
        $result['emplist'] = $temp;
        echo json_encode($result);
    }

    public function ajax_shiftdetails()
    {
        $shiftid = isset($_POST['shiftid']) ? $_POST['shiftid'] : '';
        $vehicle = isset($_POST['tripid']) ? $_POST['tripid'] : '';
        $temp = array();
        $result['emplist'] = array();
        if ($shiftid != "" && $vehicle != "") {
            $this->db->select('d.name, d.contact_num, s.stime, s.etime, s.splace, s.eplace, v.register_number');
            $this->db->from('tb_shifts s');
            $this->db->join('tb_shft_veh v', 's.id=v.shft_id', 'INNER');
            $this->db->join('tb_trucks_data t', 't.register_number=v.register_number', 'INNER');
            $this->db->join('tbl_assigned_drivers a', 'a.vehicle_id=t.id', 'INNER');
            $this->db->join('tb_truck_drivers d', 'd.id=a.driver_id', 'INNER');
            $this->db->where('s.id', $shiftid);
            $this->db->where('v.register_number', $vehicle);
            $this->db->where('v.status', 1);
            $this->db->where('s.status', 1);
            $this->db->order_by('v.id', 'DESC');
            $this->db->limit(1);
            $trips = $this->db->get();

            $temp["employee"] = array();
            $temp["driver"] = $temp["time"] = $temp["trip"] = "";
            if ($trips->num_rows() > 0) {
                $t = $trips->row();
                $temp["vdriver"] = "<b>Driver : </b>" . $t->name . " - " . $t->contact_num;
                $temp["driver"] = $t->name . " - " . $t->contact_num;
                $temp["trip"] = explode(",", $t->splace)[0] . " - " . explode(",", $t->eplace)[0];
                $temp["vehicle"] = "<a href='" . base_url() . "cab/track/" . encryptIt(
                        $temp["driver"],
                        $temp["trip"]
                    ) . "' target='_blank'>$t->register_number</a>";
            }
            $this->db->select('s.id,e.name,e.phone,e.pickup,e.drop,e.assoc_id,e.status,e.ship_type');
            $this->db->from('tb_shifts s');
            $this->db->join('tb_shft_veh sh', 's.id = sh.shft_id', 'INNER');
            $this->db->join('tb_shft_veh_emp ve', 'sh.id = ve.shft_veh_id', 'INNER');
            $this->db->join('tb_employee e', 'e.id = ve.emp_id', 'INNER');
            $this->db->where('s.id', $shiftid);
            $this->db->where('sh.register_number', $vehicle);
            $this->db->where('sh.status', 1);
            $this->db->where('ve.status', 1);
            $this->db->order_by('ve.priority', 'ASC');
            $emp = $this->db->get();
            if ($emp->num_rows() > 0) {
                $temp["employee"] = array();
                foreach ($emp->result() as $emps) {
                    $pickdrop = $emps->pickup;
                    if ($emps->ship_type == 'D') {
                        $pickdrop = $emps->drop;
                    }
                    if ($emps->status == "1") {
                        $temp["employee"][] = "<span style='color:black;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                    } else {
                        $temp["employee"][] = "<span style='color:red;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                    }
                }
            }
        }
        $result['emplist'] = $temp;
        echo json_encode($result);
    }

    public function tripreports()
    {
        $data["table_search"] = $whr = "";
        $cid = $this->session->userdata('id');
        $enddt = date('Y-m-d');
        $startdt = date('Y-m-d', strtotime('-7 days'));
        $post = array(
            'fromdate_search' => $startdt,
            'todate_search' => $enddt,
            'driver_search' => '',
            'vehicle_search' => '',
            'shift_search' => '',
            'zone_search' => '',
            'type_search' => ''
        );
        if ($_POST) {
            $post = $_POST;
        }
        $data['page_title'] = "Reports";
        $data['sub_title'] = "Shipment Reports";
        $tripscount = $this->getshiftreports($post, 0, 0)->num_rows();
        $data['tripscount'] = $tripscount;
        $config = array();
        $config["base_url"] = base_url() . "carrier/tripreports";
        $config["total_rows"] = $tripscount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['tripsdata'] = $this->getshiftreports($post, $config["per_page"], $page);
        $data['post'] = $post;
        $this->db->select('id,scity,dcity,shipmentid');
        $this->db->from('tb_shifts');
        $this->db->where('vendor_id', $cid);
        $this->db->where('status', 0);
        $this->db->order_by('startdate', 'DESC');
        $shifts = $this->db->get();
        $data['shifts'] = $shifts->result_array();
        $this->settemplate->dashboard("carrier/tripreports", $data);
    }

    public function getshiftreports($post, $limit, $offset)
    {
        $where = " where tr.trip_status = 1 ";
        $cid = $this->session->userdata('id');
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }

        if (isset($post['type_search']) && !empty(trim($post['type_search']))) {
            $getlocid = $this->getTripsByTypeSearch($post['type_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzzs[] = $ld['id'];
                }
                $ts = implode(",", $zzzs);
            } else {
                $ts = 0;
            }
            $where .= " and tr.trip_id IN (" . $ts . ")";
        }

        if (isset($post['shift_search']) && $post['shift_search'] != "") {
            if (!empty($post['shift_search'])) {
                $dd = $post['shift_search'];
                $where .= " AND trip.shift_id=$dd ";
            }
        }
        $query = "select trip.shift_id,t.register_number,IFNULL(t.truck_capacity,0) as tcapacity,tr.*,us.name,us.contact_num,(select ish.etime from tb_trips it,tb_shifts ish where it.id=tr.trip_id and ish.id=it.shift_id) as dvrlate from tb_trip_summary as tr, tb_truck_drivers as us,tb_trucks_data t,tb_trips trip,tb_shifts s " . $where . " AND s.id=trip.shift_id AND s.vendor_id='$cid' AND tr.vehicle_id=t.id AND us.id = tr.driver_id AND trip.id = tr.trip_id order by tr.createdon DESC";
        if ($limit > 0) {
            $query .= " limit " . $offset . "," . $limit;
        }
        return $this->db->query($query);
    }

    public function profile()
    {
        $data['page_title1'] = 'Profile';
        $sql = "select * from tb_vendors where id=" . $this->session->userdata('id');
        $data['usrdetails'] = $this->db->query($sql);
        $data['countrydata'] = $this->db->get_where("tbl_country_master", array("status" => "1"));
        $this->settemplate->dashboard('carrier/userprofile', $data);
    }

    public function updateprofile()
    {
        $com = $this->input->get_post('country');
        $nam = $this->input->get_post('name');
        $mob = $this->input->get_post('mobile_no');
        $ema = $this->input->get_post('email_id');
        $id = $this->session->userdata('id');
        $password = $this->input->get_post('password');
        $cnf_password = $this->input->get_post('confirm_password');
        $this->form_validation->set_rules('country', 'Country Name', 'trim|required');
        $this->form_validation->set_rules('name', 'User name', 'trim|required');
        //$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required|min_length[5]|max_length[12]');
        $this->form_validation->set_rules('email_id', 'Email', 'trim|required|valid_email');
        if ($password != $cnf_password) {
            $this->session->set_flashdata('error_msg', "Password and confirm password does not match");
            redirect("carrier/profile");
        } elseif ($this->form_validation->run() == false) {
            $this->session->set_flashdata('error_msg', "Please enter valid details");
            redirect("carrier/profile");
        } else {
            if ($_POST["ispwdedit"] == "1") {
                $password = $this->passwordEncrypt($password);
                $sql = "update tb_vendors set country='" . $com . "', name='" . $nam . "', email='" . $ema . "', password='" . $password . "',mobile='$mob' where id=" . $id;
                $this->db->query($sql);
                $this->session->set_flashdata('success_msg', "Updated Successfully");
                redirect('carrier/profile');
            } else {
                if ($_POST["ispwdedit"] == "0") {
                    $sql = "update tb_vendors set country='" . $com . "', name='" . $nam . "', email='" . $ema . "',mobile='$mob' where id=" . $id;
                    $this->db->query($sql);
                    $this->session->set_flashdata('success_msg', "Updated Successfully");
                    redirect('carrier/profile');
                }
            }
        }
    }

    public function activeorders()
    {
        $data['page_title'] = $this->lang->line('general_active');
        $data['sub_title'] = $this->lang->line('active_bookings');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $cid = $this->session->userdata('id');
        $input = $this->input->post();
        $whr = "";
        $inp = 0;
        if (!empty($input)) {
            if (!empty($input['bookingid'])) {
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('" . $bookids . "')";
            }
            if (isset($input['pickup'])) {
                if ($input['pickup'] != "") {
                    $inp = 1;
                    $whr .= " AND (o.pickup_country LIKE '%" . $input['pickup'] . "%' OR o.pickup_city LIKE '%" . $input['pickup'] . "%') ";
                }
            }
            if (isset($input['drop'])) {
                if ($input['drop'] != "") {
                    $inp = 1;
                    $whr .= " AND (o.delivery_country LIKE '%" . $input['drop'] . "%' OR o.delivery_city LIKE '%" . $input['drop'] . "%') ";
                }
            }
            if (isset($input['fromdate_search'])) {
                if ($input['fromdate_search'] != "") {
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['fromdate_search'], $curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.pickup_datetime)>='" . $input['fromdate_search'] . "' ";
                }
            }
            if (isset($input['todate_search'])) {
                if ($input['todate_search'] != "") {
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['todate_search'], $curtz);
                    $input['todate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.delivery_datetime)<='" . $input['todate_search'] . "' ";
                }
            }
            $getords = array();
            if (isset($input['reference'])) {
                if (!empty($input['reference'])) {
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getAllOrdersbyRef($reference);
                }
            }


            if (isset($input['order_type'])) {
                if (!empty($input['order_type'])) {
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getActiveOrdersbyRefOT("OT", $ordtye);
                    if (!empty($getords1)) {
                        $getords = array_merge($getords, $getords1);
                    } else {
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if (!empty($getords2)) {
                            $getords = array_merge($getords, $getords2);
                        }
                    }
                }
            }


            if (!empty($getords)) {
                $gords = implode("','", $getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if ($inp == 1 && $whr == "") {
            $whr .= " AND o.id IN(0) ";
        }
        $carrierCondition = $this->getCarrierCondition($cid);
        $orderIds = $this->order_details->getActiveOrderIdsByCarrier(['whereCondition' => $whr, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')])['orderIds'];
        $pageCount = count($orderIds);
        $config = [];
        $config["base_url"] = base_url() . "carrier/activeorders";
        $config["total_rows"] = $pageCount;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['orders'] = $this->order_details->getOrderDetailsByCarrier(['orderIds' => $orderIds, 'start' => $page, 'limit' => $config["per_page"], 'timeZone' => $curtz]);
        $this->newtemplate->dashboard('carrier/activeorders', $data);
    }

    public function getActiveOrdersdetailsType($otype)
    {
        $res = array();
        $cid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if (!empty($otype)) {
            $ordertype_id = 0;
            $getordertype_id = $this->db->select('id')->get_where(
                "tb_order_types",
                array(
                    'ordtype_code' => $otype,
                    'company_code' => $company_code,
                    'status' => '1'
                )
            );
            if ($getordertype_id->num_rows() > 0) {
                $ordertype_id = $getordertype_id->row()->id;
            } else {
                $getordertype = $this->db->select('id')->get_where(
                    "tb_order_types",
                    array(
                        'ordtype_code' => $otype,
                        'company_code' => 'SGKN',
                        'status' => '1'
                    )
                );
                if ($getordertype->num_rows() > 0) {
                    $ordertype_id = $getordertype->row()->id;
                }
            }
            if ($ordertype_id != 0) {
                $order_qry = $this->db->query(
                    "select o.id FROM tb_orders o, tb_order_details d where d.order_type='" . $ordertype_id . "' AND o.user_id= '" . $cid . "' AND o.id=d.order_row_id"
                );
                if ($order_qry->num_rows() > 0) {
                    foreach ($order_qry->result() as $res1) {
                        $res[] = $res1->id;
                    }
                }
            }
        }

        return $res;
    }

    public function getActiveOrdersbyRefOT($refnum, $refval)
    {
        $res = array();
        $cid = $this->session->userdata("id");
        $carrierCondition = $this->getCarrierCondition($cid);
        if (!empty($refval)) {
            $qry = $this->db->query(
                "select r.order_id FROM tb_order_references r,tb_orders o WHERE r.order_id=o.id AND o.vendor_id IN ? AND o.trip_id != 0 AND o.trip_sts=0 AND r.reference_id=? AND r.ref_value IN(?) AND r.status=1", [$carrierCondition, $refnum, $refval]
            );
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    public function getAllOrdersbyRef(string $referenceId): array
    {
        if ($referenceId != "") {
            $getOrders = $this->common->getjointbldata('tb_order_references r', 'tb_orders o', 'r.order_id=o.id', "r.ref_value IN('" . $referenceId . "') AND r.status=1", 'r.order_id', 0, 0);
            foreach ($getOrders as $eachRow) {
                $response[] = $eachRow['order_id'];
            }
        }
        return $response ?? [];
    }

    public function getPendingOrdersbyRefOT($refnum, $refval)
    {
        $res = array();
        $cid = $this->session->userdata("id");
        $carrierCondition = $this->getCarrierCondition($cid);
        if (!empty($refval)) {
            $qry = $this->db->query(
                "select r.order_id FROM tb_order_references r,tb_orders o WHERE r.order_id=o.i AND o.vendor_id IN ? AND o.trip_id=0 AND o.trip_sts=0 AND r.reference_id=? AND r.ref_value IN(?) AND r.status=1", [$carrierCondition, $refnum, $refval]
            );
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    public function getCompletedOrdersbyRefOT($refnum, $refval)
    {
        $res = array();
        $cid = $this->session->userdata("id");
        $carrierCondition = $this->getCarrierCondition($cid);
        if (!empty($refval)) {
            $qry = $this->db->query(
                "select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.vendor_id IN ? AND o.trip_sts=1 AND r.reference_id=? AND r.ref_value IN(?) AND r.status=1", [$carrierCondition, $refnum, $refval]
            );
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    public function pendingorders()
    {
        $data['page_title'] = $this->lang->line('menu_pending');
        $data['sub_title'] = $this->lang->line('menu_pending') . " " . $this->lang->line('bookings');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $cid = $this->session->userdata('id');
        $input = $this->input->post();
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $inp = 0;
        $whr = "";
        if (!empty($input)) {
            if (!empty($input['bookingid'])) {
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('" . $bookids . "')";
            }
            if (isset($input['pickup'])) {
                if ($input['pickup'] != "") {
                    $inp = 1;
                    $whr .= " AND (o.pickup_country LIKE '%" . $input['pickup'] . "%' OR o.pickup_city LIKE '%" . $input['pickup'] . "%') ";
                }
            }
            if (isset($input['drop'])) {
                if ($input['drop'] != "") {
                    $inp = 1;
                    $whr .= " AND (o.delivery_country LIKE '%" . $input['drop'] . "%' OR o.delivery_city LIKE '%" . $input['drop'] . "%') ";
                }
            }
            if (isset($input['fromdate_search'])) {
                if ($input['fromdate_search'] != "") {
                    $inp = 1;
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['fromdate_search'], $curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $whr .= " AND DATE(o.pickup_datetime)>='" . $input['fromdate_search'] . "' ";
                }
            }
            if (isset($input['todate_search'])) {
                if ($input['todate_search'] != "") {
                    $inp = 1;
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['todate_search'], $curtz);
                    $input['todate_search'] = $getactual['date'];
                    $whr .= " AND DATE(o.delivery_datetime)<='" . $input['todate_search'] . "' ";
                }
            }

            $getords = array();
            if (isset($input['reference'])) {
                if (!empty($input['reference'])) {
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getAllOrdersbyRef($reference);
                }
            }
            if (isset($input['order_type'])) {
                if (!empty($input['order_type'])) {
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getPendingOrdersbyRefOT("OT", $ordtye);
                    if (!empty($getords1)) {
                        $getords = array_merge($getords, $getords1);
                    } else {
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if (!empty($getords2)) {
                            $getords = array_merge($getords, $getords2);
                        }
                    }
                }
            }
            if (!empty($getords)) {
                $gords = implode("','", $getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if ($inp == 1 && $whr == "") {
            $whr .= " AND o.id IN(0) ";
        }
        $carrierCondition = $this->getCarrierCondition($cid);
        $orderIds = $this->order_details->getPendingOrderIdsByCarrier(['whereCondition' => $whr, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')])['orderIds'];
        $pageCount = count($orderIds);
        $config = [];
        $config["base_url"] = base_url() . "carrier/pendingorders";
        $config["total_rows"] = $pageCount;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['orders'] = $this->order_details->getOrderDetailsByCarrier(['orderIds' => $orderIds, 'start' => $page, 'limit' => $config["per_page"], 'timeZone' => $curtz]);
        $this->newtemplate->dashboard('carrier/pendingorders', $data);
    }

    public function doneorders()
    {
        $data['page_title'] = $this->lang->line('menu_completed');
        $data['sub_title'] = $this->lang->line('menu_completed') . " " . $this->lang->line('bookings');
        $data['ord_type'] = "done";
        $data['orders'] = array();
        $cid = $this->session->userdata('id');
        $inp = 0;
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if (!empty($input)) {
            if (!empty($input['bookingid'])) {
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('" . $bookids . "')";
            }
            if (isset($input['pickup'])) {
                if ($input['pickup'] != "") {
                    $inp = 1;
                    $whr .= " AND (o.pickup_country LIKE '%" . $input['pickup'] . "%' OR o.pickup_city LIKE '%" . $input['pickup'] . "%') ";
                }
            }
            if (isset($input['drop'])) {
                if ($input['drop'] != "") {
                    $inp = 1;
                    $whr .= " AND (o.delivery_country LIKE '%" . $input['drop'] . "%' OR o.delivery_city LIKE '%" . $input['drop'] . "%') ";
                }
            }
            if (isset($input['fromdate_search'])) {
                if ($input['fromdate_search'] != "") {
                    $inp = 1;
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['fromdate_search'], $curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $whr .= " AND DATE(o.pickup_datetime)>='" . $input['fromdate_search'] . "' ";
                }
            }
            if (isset($input['todate_search'])) {
                if ($input['todate_search'] != "") {
                    $inp = 1;
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['todate_search'], $curtz);
                    $input['todate_search'] = $getactual['date'];
                    $whr .= " AND DATE(o.delivery_datetime)<='" . $input['todate_search'] . "' ";
                }
            }
            $getords = array();
            if (isset($input['reference'])) {
                if (!empty($input['reference'])) {
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getAllOrdersbyRef($reference);
                }
            }
            if (isset($input['order_type'])) {
                if (!empty($input['order_type'])) {
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getCompletedOrdersbyRefOT("OT", $ordtye);
                    if (!empty($getords1)) {
                        $getords = array_merge($getords, $getords1);
                    } else {
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if (!empty($getords2)) {
                            $getords = array_merge($getords, $getords2);
                        }
                    }
                }
            }

            if (isset($input['trip_no'])) {
                if (!empty($input['trip_no'])) {
                    $inp = 1;
                    $getords = $this->Completedordersmodel->getCompletedOrdersbyTrip($input['trip_no']);
                }
            }
           
            if (!empty($getords)) {
                $gords = implode("','", $getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if ($inp == 1 && $whr == "") {
            $whr .= " AND o.id IN(0) ";
        }
        $carrierCondition = $this->getCarrierCondition($cid);
        $orderIds = $this->order_details->getClosedOrderIdsByCarrier(['whereCondition' => $whr, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')])['orderIds'];
        $pageCount = count($orderIds);
        $config = [];
        $config["base_url"] = base_url() . "carrier/doneorders";
        $config["total_rows"] = $pageCount;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['orders'] = $this->order_details->getOrderDetailsByCarrier(['orderIds' => $orderIds, 'start' => $page, 'limit' => $config["per_page"], 'timeZone' => $curtz]);
        $this->newtemplate->dashboard('carrier/doneorders', $data);
    }

    public function kpireports()
    {
        $data['page_title'] = 'KPI Reports';
        $this->settemplate->dashboard('carrier/kpireports', $data);
    }

    public function orderdetails()
    {
        $data['ord_type'] = "done";
        if ($this->input->post("order_id")) {
            $order_id = $this->input->post("order_id");
            $userid = $this->session->userdata('id');
            $data['ord_type'] = $this->input->post("type");
            $data['userid'] = $userid;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data["order"] = $this->db->where(array("id" => $order_id))->get("tb_orders")->row();
            $this->db->select('r.id,r.reference_id,r.ref_value,t.description');
            $this->db->from('tb_order_references r');
            $this->db->join('tb_reference_master t', 'r.reference_id=t.name', 'INNER');
            $this->db->where('r.order_id', $order_id);
            $this->db->where('r.status', 1);
            $this->db->group_by('r.id');
            $data["orderref"]=$this->db->get();
            echo $this->load->view("carrier/vieworderdetails", $data, true);
        }
    }

    public function testingtext()
    {
        $fn = fopen("./statuscodes.txt", "r");
        $dt = date("Y-m-d H:i:s");
        $qry = "";
        while (!feof($fn)) {
            $result = fgets($fn);
            $chk = explode(";", $result);
            if (count($chk) > 0) {
                $code = $chk[0];
                $name = $chk[1];
                $qry .= "INSERT INTO `tbl_status_codes`(`status_name`, `description`, `status_type`, `status_code`, `target_system`, `status`, `createdon`) VALUES ('" . $name . "','" . $name . "','yes','" . $code . "','SG',1,'" . $dt . "'); <br/>";
            }
        }
        echo $qry;
        fclose($fn);
    }

    public function trackviewmap($ord)
    {
        $data["page_title"] = "MAP";
        if ($ord != "") {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $tripinfo = $this->common->gettblrowdata(
                array("order_id" => $ord, "trip_id !=" => 0),
                "trip_id",
                "tb_orders",
                0,
                0
            );
            if (count($tripinfo) > 0) {
                $trip_id = $tripinfo['trip_id'];
                $data["trip_id"] = $trip_id;
                $chktrip = $this->db->select(
                    "id,shift_id,vehicle_id,driver_id,status,dlat as latitude,dlng as longitude"
                )->get_where("tb_trips", array("id" => $trip_id), 1, 0);
                if ($chktrip->num_rows() > 0) {
                    $data["trip"] = $trip = $chktrip->row();
                    $driver_row = $this->db->select("id,name,track_type")->where("id", $trip->driver_id)->get(
                        "tb_truck_drivers"
                    )->row();
                    $data["stops"] = $this->db->query(
                        "SELECT id,stopname,stopcity,address,stoptype,convertToClientTZ(startdate,'" . $curtz . "') as startdate,weight,volume,ship_units from tb_shiporder_stops where shipment_id = " . $trip->shift_id . " AND status='1' ORDER BY ordernumber ASC"
                    );
                    $data["details"] = [];
                    foreach ($data["stops"]->result() as $stop) {
                        $det = $this->db->query(
                            "SELECT id,plat,plng,pickup,stop_id,convertToClientTZ(pickup_datetime,'" . $curtz . "') as pickup_datetime,dlat,dlng,`drop`,convertToClientTZ(drop_datetime,'" . $curtz . "') as drop_datetime, shipment_weight, shipment_volume, order_id from tb_employee where (stop_id = " . $stop->id . " OR drop_stopid = " . $stop->id . ") AND status = '1'"
                        );
                        foreach ($det->result() as $row) {
                            $details = [];
                            if ($row->stop_id == $stop->id) {
                                $details["lat"] = $row->plat;
                                $details["lng"] = $row->plng;
                                $details["name"] = $row->pickup;
                                $details["time"] = $row->pickup_datetime;
                                $details["type"] = "P";
                            } else {
                                $details["lat"] = $row->dlat;
                                $details["lng"] = $row->dlng;
                                $details["name"] = $row->drop;
                                $details["time"] = $row->drop_datetime;
                                $details["type"] = "D";
                            }
                            $details["weight"] = $row->shipment_weight;
                            $details["volume"] = $row->shipment_volume;

                            $details["stop_id"] = $stop->id;
                            $details["id"] = $row->id;
                            $details["order_id"] = $row->order_id;
                            $details["alphabet"] = getColName(count($data["details"]) + 1);
                            $details["status"] = "0";
                            $done = $this->db->query(
                                "SELECT ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,'" . $curtz . "') as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=" . $trip->shift_id . " AND ss.stop_id = " . $stop->id . " AND ss.stop_detail_id = " . $row->id . " AND ss.status='1' ORDER BY ss.createdon ASC"
                            );
                            $status_row = [];
                            if ($done->num_rows() > 0) {
                                foreach ($done->result() as $status) {
                                    $status_row["detail_id"] = $row->id;
                                    $status_row["status_id"] = $status->status_id;
                                    $status_row["status_name"] = $status->status_name;
                                    $status_row["in_lat"] = $status->latitude;
                                    $status_row["in_lng"] = $status->longitude;
                                    $status_row["in_time"] = $status->createdon;
                                    $details["statuses"][] = (object)$status_row;
                                }
                                $details["status"] = "1";
                            } else {
                                $details["statuses"][] = (object)$status_row;
                            }
                            $data["details"][] = (object)$details;
                        }
                    }
                    $data["drivers"] = $this->db->query(
                        "SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'" . $curtz . "') as createdon,d.track_type,td.travelled_km from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status ='1' GROUP BY d.id ORDER BY td.createdon ASC"
                    )->result_array();
                    $data["drivers"][] = array(
                        "id" => $driver_row->id,
                        "name" => $driver_row->name,
                        "contact_num" => $driver_row->name,
                        "createdon" => null,
                        "track_type" => $driver_row->track_type,
                        "travelled_km" => 0
                    );
                    $sts = $trip->status;
                    if ($sts == 1) {
                        $data["record"] = $this->db->query(
                            "SELECT latitude,longitude FROM tb_trucks_data WHERE id = '$trip->vehicle_id' limit 1"
                        )->row();
                    } else {
                        $data["record"] = $trip;
                    }
                    $data["isSimBased"] = "false";
                    if (count($data["drivers"]) > 0) {
                        if ($data["drivers"][count($data["drivers"]) - 1]["track_type"] == "1") {
                            $data["isSimBased"] = "true";
                        }
                    }
                    if ($data["isSimBased"]) {
                        $this->db->select('latitude,longitude,speed,timestamp');
                        $this->db->from('tb_rtdrive_locations');
                        $this->db->where('trip_id', $trip_id);
                        $this->db->order_by('timestamp', 'ASC');
                        $data["records"] = $this->db->get();
                    }
                    $this->settemplate->dashboardtemp('carrier/tripMap', $data);
                } else {
                    echo "";
                }
            } else {
                echo "";
            }
        } else {
            echo "";
        }
    }

    public function statusviewdetails()
    {
        $ord = $this->input->post("order_id");
        if ($ord != "") {
            $tripinfo = $this->order_details->getOrderRouteDetails($ord);
            if (count($tripinfo) > 0) {
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $shift_id = $tripinfo['shift_id'];
                $whr = " AND status = 1";
                $dlat = $tripinfo['dlat'];
                $dlng = $tripinfo['dlng'];
                $slat = $tripinfo['plat'];
                $slng = $tripinfo['plng'];
                $order_row_id = $tripinfo['id'];
                $data["drivers"] = array();
                $trip_id = $tripinfo['trip_id'];
                if ($trip_id != 0) {
                    $qry = $this->db->query(
                        "SELECT id,vehicle_id,status,dlat as latitude,dlng as longitude FROM tb_trips WHERE id='$trip_id' ORDER BY id DESC LIMIT 1"
                    );
                    if ($qry->num_rows() > 0) {
                        $sts = $qry->row()->status;
                        if ($sts == 1) {
                            $rec = $this->db->query(
                                "SELECT latitude,longitude from tb_trucks_data WHERE id = '" . $qry->row(
                                )->vehicle_id . "' LIMIT 1"
                            );
                            if ($rec->num_rows() > 0) {
                                $slat = $rec->row()->latitude;
                                $slng = $rec->row()->longitude;
                            }
                        } else {
                            $slat = $qry->row()->latitude;
                            $slng = $qry->row()->longitude;
                        }
                        $drivers = $this->db->query(
                            "SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'" . $curtz . "') as createdon from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id = $trip_id AND td.status =1 GROUP BY d.id ORDER BY td.createdon ASC"
                        );
                        if ($drivers->num_rows() > 0) {
                            $data["drivers"] = $drivers->result_array();
                        }
                    }
                }
                $data["history"] = $this->statusremappingservice->getOrderStatuses([
                    'timeZone' => $curtz,
                    'bookingId' => $ord,
                    'shiftId' => $shift_id,
                    'carrierName' => $tripinfo['name'],
                    'companyCode' => $this->session->userdata('company_code'),
                    'orderRowId'=>$order_row_id
                ]);
                $data["slat"] = $slat;
                $data["slng"] = $slng;
                $data["dlat"] = $dlat;
                $data["dlng"] = $dlng;
                $data['epod'] = array();
                $data['epodp'] = array();
                $docs = $this->db->select(
                    "id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon"
                )->get_where(
                    "tb_pod_uploads",
                    array("stop_type" => "D", "doc_type" => 3, "order_id" => $order_row_id, "status" => 1),
                    1,
                    0
                );
                if ($docs->num_rows() > 0) {
                    $data['epod'] = array(
                        "status_code" => "3060",
                        "status_name" => "ePOD Available",
                        "stop_id" => $docs->row()->stop_id,
                        "stop_type" => $docs->row()->stop_type,
                        "location" => getLocationName($docs->row()->latitude, $docs->row()->longitude),
                        "createdon" => $docs->row()->createdon
                    );
                }
                $docs = $this->db->query(
                    "SELECT id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon FROM tb_pod_uploads WHERE stop_type='P' AND (doc_type=3 OR doc_type=4) AND order_id=$order_row_id AND status=1 LIMIT 1"
                );
                if ($docs->num_rows() > 0) {
                    $data['epodp'] = array(
                        "status_code" => "2490",
                        "status_name" => "Goods Loaded for Delivery",
                        "stop_id" => $docs->row()->stop_id,
                        "stop_type" => $docs->row()->stop_type,
                        "location" => getLocationName($docs->row()->latitude, $docs->row()->longitude),
                        "createdon" => $docs->row()->createdon
                    );
                }
                echo $this->load->view("carrier/statusview", $data, true);
            }
        }
    }

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata(
            array("order_id" => $ord),
            "id,order_id,company_code,branch_code,shift_id,trip_id",
            "tb_orders",
            0,
            0
        );
        if (!empty($tripinfo)) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data['ord_type'] = $this->input->post("type");
            $data['ship_id'] = $tripinfo['shift_id'] ?? 0;
            $data['trip_id'] = $tripinfo['trip_id'] ?? 0;
            $orderRowId = $tripinfo['id'];
            $sql1 = $this->db->query(
                "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,ts.hash,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.order_id = ? AND ts.status = ? GROUP BY ts.id",[$orderRowId,1]);
            if ($sql1->num_rows() > 0) {
                $i = 1;
                foreach ($sql1->result_array() as $eachRow) {
                    $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    $pods[] = [
                        'sno' => $i,
                        'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                        'type_name' => $eachRow['type_name'],
                        'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                        'stop_id' => $eachRow['stop_id'],
                        'stop_type' => $eachRow['stop_type'],
                        'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                        'extention' => $base64DocumentData['extention'],
                        'file_content' => $base64DocumentData['file_content'],
                    ];
                    $i++;
                }
            }
            $data["pods"] = $pods ?? [];
            $data['order_id'] = $ord;
            $data['document_types'] = $this->db->select("id,type_name")->get_where(
                "tb_document_types",
                array("status" => 1)
            )->result_array();
            $data['stops'] = array();
            $this->db->select('o.id,o.stopname ');
            $this->db->from('tb_shiporder_stops o');
            $this->db->join('tb_employee e', 'o.shipment_id=e.shift_id', 'INNER');
            $this->db->where('e.order_id', $ord);
            $this->db->order_by('o.ordernumber', 'ASC');
            $stops = $this->db->get();
            if ($stops->num_rows() > 0) {
                $data['stops'] = $stops->result_array();
            }
            $data['order'] = (object)$tripinfo;
            echo $this->load->view("carrier/managedocuments", $data, true);
        }
    }

    public function savenewpod()
    {
        $order_id = $this->input->post("order_id", true);
        $order_number = $this->input->post("order_number", true);
        $company_code = $this->input->post("company_code", true);
        $branch_code = $this->input->post("branch_code", true);
        $ship_id = $this->input->post("ship_id", true);
        $trip_id = $this->input->post("trip_id", true);
        $stop_id = $this->input->post("stop_id", true);
        $doc_type = $this->input->post("doc_type", true);
        $sts = "no";
        $pdfName = $fileName = "";
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt = $getactual['datetime'];
        if (isset($_FILES)) {
            if (isset($_FILES['file_name']['name'])) {
                $config = array(
                    'upload_path' => NEW_POD_PATH,
                    'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
                );
                $file_name = $_FILES['file_name']['name'];
                $file_name = str_replace(" ","",$file_name);
                $file_ext = @strtolower(end(explode('.', $_FILES['file_name']['name'])));
                $expensions = array("jpeg", "jpg", "png", "gif", "pdf");
                if (in_array($file_ext, $expensions)) {
                    if ($file_ext == "pdf") {
                        $imgtype = "pdf";
                        $config['file_name'] = "RL" . $order_number . ".pdf";
                        $this->load->library('upload', $config);
                        if ($this->upload->do_upload('file_name')) {
                            $imgname = $this->upload->data();
                            $imgtype = $imgname['image_type'];
                            $fileName = $imgname['file_name'];
                            $filePath = NEW_POD_PATH . $fileName;
                        }
                    } else {
                        $fileName = date('dmyhis') . '' . $file_name;
                        $filePath = NEW_POD_PATH . $fileName;
                        $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                        if ($imgsize == false) {
                        } else {
                            /*log_message("error","imgupload ".json_encode($_FILES));*/
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if ($file_ext == "png") {
                                $top = @imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            } else {
                                $top = @imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if ($file_ext == "jpg" || $file_ext == "jpeg") {
                                    $imgtype = "jpeg";
                                } else {
                                    $imgtype = $file_ext;
                                }
                            }
                            if ($top) {
                                header('Content-Type: image/jpeg');
                                @imagejpeg($top, $filePath, $quality);
                                @imagedestroy($top);
                            } else {
                                $fileName = "";
                                $sts = "2";
                            }
                        }
                    }
                    if ($fileName != "" && $doc_type != "") {
                        $stoptype = $this->db->select("stoptype")->get_where(
                            "tb_shiporder_stops",
                            array(
                                "id" => $stop_id,
                                "stoptype" => "D",
                                "status" => 1
                            ),
                            1,
                            0
                        );
                        $stype = "P";
                        if ($stoptype->num_rows() > 0) {
                            $stype = "D";
                        }
                        if ($stop_id == "") {
                            $stop_id = 0;
                        }
                        $imageSize = filesize(NEW_POD_PATH.$fileName);
                        $newUuid = $this->uuid->v4();
                        $filedata = [
                            'stop_id' => $stop_id,
                            "shipment_id" => $ship_id,
                            'trip_id' => $trip_id,
                            'doc_type' => $doc_type,
                            'imgpath' => $fileName,
                            'stop_type' => $stype,
                            'order_id' => $order_id,
                            'status' => 1,
                            'createdon' => $curdt,
                            'filesize' => $imageSize,
                            'hash' => $newUuid
                        ];
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        /*send mail to specific party*/
                        $chkref = "XSR";
                        $whrin = " AND reference_id in('XSR','SD') ";
                        $chkordtypeqry = $this->db->query(
                            "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$order_id $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1"
                        );
                        $refval = $refvalue = "";
                        $iofeof = "EOF";
                        if ($chkordtypeqry->num_rows() > 1) {
                            /*$nums = $refs = array();*/
                            foreach ($chkordtypeqry->result() as $oref) {
                                if ($oref->reference_id = "XSR") {
                                    $refvalue = $oref->ref_value;
                                }
                                if ($oref->reference_id = "SD" && $oref->ref_value == "2") {
                                    $iofeof = "IOF";
                                }
                            }

                            $this->db->select('party_id,partycontact_id,customer_id,email_note,emailid,party_name');
                            $this->db->from('tb_contact_notifys');
                            $this->db->where('status', 1);
                            $this->db->group_start();
                            $this->db->where('pod_note', 1);
                            $this->db->or_where('all_note', 1);
                            $this->db->group_end();
                            $this->db->group_by('emailid');
                            $chkparty = $this->db->get();
                            if ($chkparty->num_rows() > 0) {
                                $this->load->library('email');
                                foreach ($chkparty->result() as $pmails) {
                                    /*$parties = $this->db->where(array("code"=>$pmails->partycontact_id))->get("tbl_party_master");
                                     if($parties->num_rows()>0){*/
                                    $receivename = $pmails->party_name;
                                    $receivemail = $pmails->emailid;
                                    $orders = $this->db->get_where("tb_orders", array("id" => $order_id), 1, 0);
                                    if ($orders->num_rows() > 0) {
                                        $orddata = $orders->row_array();
                                        if ($orddata['created_source'] != 5) {
                                            $data['order'] = $orddata;
                                            $data['page_title'] = "Booking ePOD";
                                            $data['receivemail'] = $receivemail;
                                            $data['receivename'] = $receivename;
                                            /*$sub = "svkonekt::Booking ePOD ".$chkref.":".$refvalue."#746#".$iofeof);*/
                                            $sub = $refvalue . "#746#" . $iofeof;
                                            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                            $this->email->to($receivemail, $receivename);
                                            /*$this->email->cc('kambhamramachandra@gmail.com', 'RCREDDY K');*/
                                            /*$this->email->subject("svkonekt :: Booking ePOD ".$chkref.":".$refval."#IOF/EOF".$orddata['order_id']);*/
                                            $this->email->subject($sub);
                                            $this->email->set_mailtype("html");
                                            $body = $this->load->view('mail_forms/bookepod', $data, true);
                                            $this->email->message($body);
                                            $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                                            $this->email->attach($epodpath);

                                            if(!$this->email->send()){
                                                log_message("error",$this->email->print_debugger());
                                            }

                                            $this->email->clear(true);
                                        }
                                    }
                                }
                            }
                        }
                        if ($doc_type == "3") {
                            if($file_ext != "pdf"){
                                $newPdfPath = './assets/trippods/RL' . $order_number . '.pdf';
                                $podFilePath = $this->sendpodtoknservice->imageToPdf($filePath, $file_ext, $newPdfPath);
                            }else{
                                $podFilePath = $filePath;
                            }
                            $pages = $this->sendpodtoknservice->getNumPagesPdf($podFilePath);
                            $unique_id = "RL" . $order_number . "." . date("Ymd") . "." . date("his");
                            $jplData = [
                                "country" => substr($company_code, 0, -2),
                                "branch" => substr($branch_code, 2),
                                "order_id" => $order_number,
                                "time" => date("hi"),
                                "unique_id" => $unique_id,
                                "date" => date("d.m.Y"),
                                "pages" => $pages
                            ];
                            $jplFilePath = $this->sendpodtoknservice->saveJPF($jplData);
                            $this->sendpodtoknservice->uploadKNFile($jplFilePath);
                            $this->sendpodtoknservice->uploadKNFile($podFilePath);
                        }
                        $sts = "1";
                    }
                } else {
                    $sts = "format";
                }
            }
        }
        echo $sts;
    }

    public function getNumPagesPdf($filepath)
    {
        $fp = @fopen(preg_replace("/\[(.*?)\]/i", "", $filepath), "r");
        $max = 0;
        if (!$fp) {
            return "Could not open file: $filepath";
        } else {
            while (!@feof($fp)) {
                $line = @fgets($fp, 255);
                if (preg_match('/\/Count [0-9]+/', $line, $matches)) {
                    preg_match('/[0-9]+/', $matches[0], $matches2);
                    if ($max < $matches2[0]) {
                        $max = trim($matches2[0]);
                        break;
                    }
                }
            }
            @fclose($fp);
        }
        return $max;
    }

    public function visibility() {
        $data["page_title"] = $this->lang->line('shipment_visibility');
        $carrierId = $this->session->userdata('id');
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $shiftsData = $data["orders"] = [];
        $post = $this->input->post(null, true);
        if ($carrierId != "") {
            $carrierIds = $this->getCarrierCondition($carrierId);
            $tableName = 'tb_shifts s';
            $indexColumn = $groupBy = 's.id';
            $excludeCountQuery = 'Yes';
            $userWhere = " s.vendor_id IN (" . implode(",", $carrierIds) . ") ";
            $finalShiftIds = $this->ShipmentVisibilityModel->getNormalTripsFroVisibility($post, [], $userWhere, $tableName, $indexColumn, $groupBy, $excludeCountQuery);
            if(!empty($finalShiftIds)){
                $finalShiftIds = array_unique($finalShiftIds);
                $pageCount = count($finalShiftIds);
                $config = [];
                $config["base_url"] = base_url() . "carrier/visibility";
                $config["total_rows"] = $pageCount;
                $config["per_page"] = 10;
                $config["uri_segment"] = 3;
                $config['display_pages'] = true;
                $this->pagination->initialize($config);
                $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
                if (!is_numeric($page)) {
                    $page = 0;
                }
                $shiftsData = $this->ShipmentVisibilityModel->getFinalTripsList($finalShiftIds, $page, $config['per_page'], $tableName, $indexColumn, $groupBy, $excludeCountQuery);
            }
            $vehicleIds = $shiftsIdsData = $vehicleRegisterNumbers = [];
            $shiftsIdsData = array_unique(array_column($shiftsData, 'id'));
            $condition1 = 'vehicle_id'; $condition2 = 'register_number';
            $filteredVehicles = array_filter($shiftsData, function($eachRow) use ($condition1, $condition2) {
                return !empty($eachRow[$condition1]) && empty($eachRow[$condition2]);
            });
            $vehicleIds = array_column($filteredVehicles, 'id');
            if (!empty($vehicleIds ?? [])) {
                $getVehicleRegisterNumbers = $this->common->gettbldata_where_in([], ["col" => "id", "arr" => $vehicleIds], 'id,register_number', 'tb_trucks_data');
                $vehicleRegisterNumbers = array_column($getVehicleRegisterNumbers, 'register_number', 'id');
            }
            if (!empty($shiftsIdsData ?? [])) {
                $shipmentStops = $this->Order_details->getShipmentStops($shiftsIdsData);
            }
            foreach ($shiftsData as $row) {
                if (isset($row['startdate'])) {
                    $startdate = getdatetimebytimezone($currentTimeZone, $row['startdate'], DFLT_TZ);
                    $row['startdate'] = $startdate['datetime'];
                }
                if (isset($row['enddate'])) {
                    $enddate = getdatetimebytimezone($currentTimeZone, $row['enddate'], DFLT_TZ);
                    $row['enddate'] = $enddate['datetime'];
                }
                if ($row['vehicle_id'] != "" && $row['register_number'] == "") {
                    $row['register_number'] = $vehicleRegisterNumbers[$row['vehicle_id']] ?? "";
                }
                $row['stops'] = $shipmentStops[$row['id']] ?? [];
                foreach ($shipmentStops[$row['id']] as $eachStopId){
                    $stopIds[] = $eachStopId['id'];
                    $row['total_volume'] = $eachStopId['shipment_volume'];
                }
                $data["orders"][] = $row;
            }
            $getBookingIdsAndEmployeeData = $this->ShipmentVisibilityModel->getBookingIdsAndEmployeeData(array_unique($stopIds ?? []));
            $data["orderIdsWithStopIds"] = $getBookingIdsAndEmployeeData['bookingIds'] ?? [];
            $data["isEmployeeDataAvailable"] = $getBookingIdsAndEmployeeData['isEmployeeDataAvailable'] ?? [];
            $this->settemplate->dashboard("carrier/visibility", $data);
        } else {
            redirect("login");
        }
    }


    private function fetchContainerNumbers($shipment): string
    {
        if (!$shipment) {
            return "";
        }

        $getcontainer_no = $this->getReferenceValues($order_row_id);
        if (empty($getcontainer_no)) {
            return "";
        }

        $containers = [];
        foreach ($getcontainer_no as $ctr) {
            if ($ctr->reference_id === 'CTR') {
                $containers[] = $ctr->ref_value;
            } elseif ($ctr->reference_id === 'SCAC') {
                $shipment->SCAC = $ctr->ref_value;
            }
        }

        return implode(',', $containers);
    }

    //new code by team for ajax loading dropdowns.
    public function getrefinfo($type)
    {
        $cid = $this->session->userdata("id");
        $carrierCondition = $this->getCarrierCondition($cid);
        $data = [];
        $post = $this->input->post();
        $searchTerm = $post['searchTerm'] ?? "";

        if ($type == 'pending') {
            $this->db->select(' r.id,r.reference_id,r.ref_value');
            $this->db->from('tb_order_references r');
            $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
            $this->db->where('o.trip_id', 0);
            $this->db->where('o.trip_sts', 0);
            $this->db->where('r.status', 1);
            $this->db->where_in('o.vendor_id',$carrierCondition);
            if ($searchTerm != "") {
                $this->db->where_in('r.ref_value', $searchTerm);
            }
            $this->db->where_in('r.reference_id', ['DQ', 'XSR', 'AWB', 'MAWB']);
            $this->db->group_by('r.id');
            $orderref = $this->db->get();
            $customBarrierData = $this->Order_details->getCustomBarrierPendingOrders(['searchTerm' => $searchTerm, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')]);
            foreach ($customBarrierData as $eachRow) {
                $data[] = ["id" => $eachRow['ref_value'], "text" => $eachRow['ref_value']];
            }
        } elseif ($type == 'active') {
            $this->db->select('r.id,r.reference_id,r.ref_value');
            $this->db->from('tb_order_references r');
            $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
            $this->db->where('o.trip_id!=', 0);
            $this->db->where('o.trip_sts', 0);
            $this->db->where('r.status', 1);
            $this->db->where_in('o.vendor_id',$carrierCondition);
            if ($searchTerm != "") {
                $this->db->where_in('r.ref_value', $searchTerm);
            }
            $this->db->where_in('r.reference_id', ['DQ', 'XSR', 'AWB', 'MAWB']);
            $this->db->group_by('r.id');
            $orderref = $this->db->get();
            $customBarrierData = $this->Order_details->getCustomBarrierActiveOrders(['searchTerm' => $searchTerm, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')]);
            foreach ($customBarrierData as $eachRow) {
                $data[] = ["id" => $eachRow['ref_value'], "text" => $eachRow['ref_value']];
            }
        } elseif ($type == 'done') {
            $this->db->select('r.id,r.reference_id,r.ref_value');
            $this->db->from('tb_order_references r');
            $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
            $this->db->where('o.trip_sts', 1);
            $this->db->where('r.status', 1);
            $this->db->where_in('o.vendor_id',$carrierCondition);
            if ($searchTerm != "") {
                $this->db->where_in('r.ref_value', $searchTerm);
            }
            $this->db->where_in('r.reference_id', ['DQ', 'XSR', 'AWB', 'MAWB']);
            $this->db->group_by('r.id');
            $this->db->order_by('r.updatedon', 'ASC');
            $orderref = $this->db->get();
            $customBarrierData = $this->Order_details->getCustomBarrierClosedOrders(['searchTerm' => $searchTerm, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')]);
            foreach ($customBarrierData as $eachRow) {
                $data[] = ["id" => $eachRow['ref_value'], "text" => $eachRow['ref_value']];
            }
        }elseif ($type == 'massstatus') {
            $this->db->select('r.id,r.reference_id,r.ref_value');
            $this->db->from('tb_order_references r');
            $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
            $this->db->join('tb_shft_veh sv', 'o.shift_id=sv.shft_id', 'INNER');
            $this->db->join('tbl_assigned_drivers ad', 'sv.vehicle_id=ad.vehicle_id', 'INNER');
            $this->db->where_in('o.vendor_id',$carrierCondition);
            $this->db->where('o.status!=', 0);
            $this->db->where('o.shift_id!=', 0);
            $this->db->where('sv.status!=', 0);
            $this->db->where('ad.status!=', 0);
            $this->db->where('o.trip_sts', 0);
            if ($searchTerm != "") {
                $this->db->where_in('r.ref_value', $searchTerm);
            }
            $this->db->where_in('r.reference_id', ['DQ','XSR']);
            $this->db->group_by('r.id');
            $this->db->order_by('r.updatedon', 'ASC');
            $orderref = $this->db->get();
        }
        if ($orderref->num_rows() > 0) {
            foreach ($orderref->result_array() as $ores) {
                $data[] = array("id" => $ores['ref_value'], "text" => $ores['ref_value']);
            }
        }
        echo json_encode($data);
    }

    public function getbookinfo($type)
    {
        $cid = $this->session->userdata("id");
        $post = $this->input->post();
        $searchTerm = $post['searchTerm'] ?? "";
        $where = " ";
        if ($searchTerm != "") {
            $where .= " AND o.order_id LIKE '" . $searchTerm . "%' ";
        }
        $carrierCondition = $this->getCarrierCondition($cid);
        if ($type === "active") {
            $data = $this->order_details->getActiveOrderIdsByCarrier(['whereCondition' => $where, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')])['orderData'];
        } elseif ($type === "pending") {
            $data = $this->order_details->getPendingOrderIdsByCarrier(['whereCondition' => $where, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')])['orderData'];
        } else {
            $data = $this->order_details->getClosedOrderIdsByCarrier(['whereCondition' => $where, 'carrierCondition' => $carrierCondition, 'carrierCode' => $this->session->userdata('carrier_code'), 'companyCode' => $this->session->userdata('company_code')])['orderData'];
        }
        echo json_encode($data ?? []);
    }

    public function getordertypeinfo()
    {
        $data = array();
        $ordertypes = $this->db->select("type_name,ordtype_code")->group_by("type_name")->get_where(
            "tb_order_types",
            array("status" => 1)
        );
        foreach ($ordertypes->result_array() as $ores) {
            $data[] = array("id" => $ores['ordtype_code'], "text" => $ores['type_name']);
        }
        echo json_encode($data);
    }

    public function gettripinfo($type)
    {
        $cid = $this->session->userdata("id");
        $data = array();
        $post = $this->input->post();
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        $whr1 = "";
        if ($searchTerm != "") {
            $whr1 .= "o.order_id LIKE '" . $searchTerm . "%' AND ";
        }
        if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
            $carrierIds = getCarrierids($this->session->userdata("carrier_code"));
            if (count($carrierIds) > 1) {
                $carrierIdValues = implode("','", $carrierIds);
                $whr1 .= "vendor_id IN ('" . $carrierIdValues . "')";
            } else {
                $whr1 .= " vendor_id=" . $cid . " ";
            }
        } else {
            $whr1 .= " vendor_id=" . $cid . " ";
        }

        if ($type == 'done') {
            $this->db->select('id, shipmentid');
            $this->db->from('tb_orders');
            $this->db->where($whr1);
            $this->db->where(['trip_sts' => 1]);
            $this->db->group_by('order_id');
            $this->db->order_by('updatedon', 'DESC');
            $orderref = $this->db->get();
        }
        if ($orderref->num_rows() > 0) {
            foreach ($orderref->result_array() as $ores) {
                $data[] = array("id" => $ores['shipmentid'], "text" => $ores['shipmentid']);
            }
        }
        echo json_encode($data);
    }

    private function getCarrierCondition(int $cid): array
    {
        $carrierIdValues = "";
        if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
            $carrierIds = getCarrierids($this->session->userdata("carrier_code"));
            //log_message("error", "Commnon Carrier IDs " . json_encode($carrierIds));
            if (count($carrierIds) > 1) {
                $carrierIdValues = $carrierIds;
            } else {
                $carrierIdValues = [$cid];
            }
        } else {
            $carrierIdValues = [$cid];
        }
        return $carrierIdValues;
    }
}
