<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class CarrierLiveKPI extends CI_Controller
{
    private const REPORT_COUNTRY_CODE = 'VN';
    private const REPORT_COUNTRY_COMPANY_CODE = 'VNKN';
    private const REPORT_EMAIL_TO = 'ai.duong@kuehne-nagel.com';

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['CarrierLiveKPIModel','common']);
    }

    public function index(): void
    {
        if (null === $this->session->userdata('user_role_id') || (null !== $this->session->userdata('user_role_id') && (int)$this->session->userdata('user_role_id') !== 2)) {
            redirect('login');
        }
        $this->CarrierLiveKPIReport();
    }

    private function CarrierLiveKPIReport(): void
    {
        $businessType = $this->session->userdata("business_type");
        $data['page_title'] = $this->lang->line('carrier_kpi_report');
        $data["table_search"] = $whr = "";
        $userId = $this->session->userdata('user_id');
        $id = $this->session->userdata('id');
        $data = [];
        if ($_POST) {
            $post = $_POST;
            $post['user_id'] = $userId;
            $post['company_code'] = $this->session->userdata('company_code');
            $post['timezone'] = $this->session->userdata("usr_tzone")['timezone'];
            $config = [];
            $config["base_url"] = base_url() . "CarrierLiveKPI";
            $config["total_rows"] = count($this->CarrierLiveKPIModel->getReports($post, 0, 0));
            $config["per_page"] = count($this->CarrierLiveKPIModel->getReports($post, 0, 0));
            $config["uri_segment"] = 2;
            $config['display_pages'] = true;
            $this->pagination->initialize($config);
            $data['page'] = $page = $this->uri->segment(2) ?? 0;
            $data['orderReportData'] = $this->CarrierLiveKPIModel->getReports($post, $config["per_page"], $page);
            $data['post'] = $post;
        }
        $carrierListWhere = ["user_id" => $userId, "status" => 1];
        $data['carrierList'] = $this->common->gettbldata($carrierListWhere, "id,name", "tb_vendors", 0, 0);
        $this->settemplate->dashboard("carrierlivekpi/CarrierLiveKPIreport", $data);
    }

    public function generateExcelReport(string $reportType='W'): void
    {
        require_once APPPATH . "/third_party/PHPExcel.php";
        $countryInfo = $this->common->gettblrowdata(["country_code" => SELF::REPORT_COUNTRY_CODE, "status" => 1], "cntry_timezone", "tbl_country_master", 0, 0);
        $fromDate = date('Y-m-d', strtotime('last week monday'));
        $toDate = date('Y-m-d', strtotime('last week sunday'));
        $reportLabel = 'Weekly';
        if ( $reportType ==='M' ) {
            $fromDate = date('Y-m-d', strtotime('first day of last month'));
            $toDate = date('Y-m-d', strtotime('last day of last month'));
            $reportLabel = 'Monthly';
        }
        $searchData = [
            'fromdate_search' => $fromDate,
            'todate_search' => $toDate,
            'timezone' => $countryInfo['cntry_timezone'],
            'company_code' => SELF::REPORT_COUNTRY_COMPANY_CODE
        ];
        $orderReportData = $this->CarrierLiveKPIModel->getReports($searchData, 0, 0);
        if (count($orderReportData) > 0) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:AF1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', '#');
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Booking ID');
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'SALOG Ref');
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Trip No');
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Status');
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Created On');
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Customer');
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Pickup Address');
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Delivery Address');
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Carrier Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Truck No');
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Driver Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Booked by Supplier');
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Accept');
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Gate IN');
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Pickup');
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'Gate Out');
            $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'In Transit');
            $objPHPExcel->getActiveSheet()->SetCellValue('Z1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('AA1', 'DROP Gate In');
            $objPHPExcel->getActiveSheet()->SetCellValue('AB1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('AC1', 'Delivery');
            $objPHPExcel->getActiveSheet()->SetCellValue('AD1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('AE1', 'DROP Gate Out');
            $objPHPExcel->getActiveSheet()->SetCellValue('AF1', 'Executed By');
            $objPHPExcel->getActiveSheet()->SetCellValue('AG1', 'POD Status');
            $objPHPExcel->getActiveSheet()->SetCellValue('AH1', 'Branch Code');
            $objPHPExcel->getActiveSheet()->getStyle('A1:AH1')->applyFromArray($styleArray);

            $rowCount = 2;
            foreach ($orderReportData as $i => $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $i + 1);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['delivery_note']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['salog_ref']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['shipmentid']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['order_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, date('d-m-Y h:i A',strtotime($result['createdon'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['customer_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['pickup_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['delivery_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['carrier_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['register_number'] ? $result['register_number'] : $result['truck']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['driver_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['pickup_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['delivery_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $result['supplier_booked'] ? date('d-m-Y h:i A', strtotime($result['supplier_booked'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $result['accepted_date'] ? date('d-m-Y h:i A', strtotime($result['accepted_date'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $result['accepted_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $result['o_gatein'] ? date('d-m-Y h:i A', strtotime($result['o_gatein'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $result['o_gatein_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $result['pickup_date'] ? date('d-m-Y h:i A', strtotime($result['pickup_date'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $result['pickup_date_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, $result['pickup_gateout'] ? date('d-m-Y h:i A', strtotime($result['pickup_gateout'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('X' . $rowCount, $result['pickup_gateout_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Y' . $rowCount, $result['in_transit'] ? date('d-m-Y h:i A', strtotime($result['in_transit'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('Z' . $rowCount, $result['in_transit_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AA' . $rowCount, $result['d_gatein'] ? date('d-m-Y h:i A', strtotime($result['d_gatein'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('AB' . $rowCount, $result['d_gatein_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AC' . $rowCount, $result['delivery'] ? date('d-m-Y h:i A', strtotime($result['delivery'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('AD' . $rowCount, $result['delivery_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AE' . $rowCount, $result['d_gateout'] ? date('d-m-Y h:i A', strtotime($result['d_gateout'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('AF' . $rowCount, $result['d_gateout_reason']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AG' . $rowCount, $result['pod_uploaded'] ? date('d-m-Y h:i A', strtotime($result['pod_uploaded'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('AH' . $rowCount, $result['branch_code']);
                $rowCount++;
            }
            $fileName = 'carrier_live_kpi_' . "_" . date("Ymdhis") . '.xlsx';
            @ob_end_clean();
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $objWriter->save(str_replace(__FILE__, $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/{$fileName}", __FILE__));

            $this->load->library('PhpMailerLibrary');
            $this->load->helper('email_templates');
            $receiverName = 'Duong, Ai';
            $recipient = SELF::REPORT_EMAIL_TO;
            try {
                $subject = "Carrier Live KPI {$reportLabel} Report from {$fromDate} - {$toDate}";
                $filePath = sprintf('%s/assets/%s', FCPATH, $fileName);
                $data = [
                    'fromDate' => $fromDate,
                    'toDate' => $toDate,
                    'receiverName' => $receiverName,
                    'reportLabel'=>$reportLabel
                ];
                $files = [$filePath];
                $body = $this->load->view('mail_forms/autoreports/carrier_live_kpi_mail_body', $data, true);
                if ( !$this->phpmailerlibrary->sendmail($recipient, $subject, $body, [], $files) ) {
                    log_message("error", "Unable to send the email of carrier live KPI monthly report");
                } else {
                    log_message("error", "Email of carrier live KPI monthly report has been sent successfully");
                    if ( !unlink($filePath) ) {
                        log_message("error", "Unable to delete the attachment file ".$filePath);
                    } else {
                        log_message("error", "Carrier live KPI monthly report has been deleted successfully");
                    }
                }
            } catch (Exception $e) {
                log_message("error", "Monthly carrier Live KPI report not send on " . date('d-m-Y h:i A') . " - " . $e->getMessage());
            }
        }
    }

    public function generateExcelReportDailyForCarrier(): void {
        $fromDate = $toDate = date('Y-m-d',strtotime("-1 days"));
        $carrierList = $this->CarrierLiveKPIModel->getVNKNCarriers(SELF::REPORT_COUNTRY_COMPANY_CODE, $fromDate, $toDate);
        if (!empty($carrierList)) {
            require_once APPPATH . "/third_party/PHPExcel.php";
            $this->load->library('PhpMailerLibrary');
            $this->load->helper('email_templates');
            $countryInfo = $this->common->gettblrowdata(["country_code" => SELF::REPORT_COUNTRY_CODE, "status" => 1], "cntry_timezone", "tbl_country_master", 0, 0);
            foreach ($carrierList as $carrier) {
                $searchData = [
                    'fromdate_search'   => $fromDate,
                    'todate_search'     => $toDate,
                    'timezone'          => $countryInfo['cntry_timezone'],
                    'company_code'      => SELF::REPORT_COUNTRY_COMPANY_CODE,
                    'carrier_search'    => $carrier['id'],
                ];
                $orderReportData = $this->CarrierLiveKPIModel->getReports($searchData, 0, 0);
                if (count($orderReportData) > 0) {
                    $styleArray = [
                        'font' => [
                            'bold' => true,
                            'color' => ['rgb' => 'FFFFFF'],
                            'size' => 10,
                            'name' => 'Verdana'
                        ]
                    ];
                    $objPHPExcel = new PHPExcel();
                    $objPHPExcel->setActiveSheetIndex(0);
                    $objPHPExcel->getActiveSheet()
                        ->getStyle('A1:AF1')
                        ->applyFromArray(
                            [
                                'fill' => [
                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                    'color' => ['rgb' => '0c3b81']
                                ]
                            ]
                        );
                    $objPHPExcel->getActiveSheet()->SetCellValue('A1', '#');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Booking ID');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Delivery Note');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'SALOG Ref');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Trip No');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Status');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Created On');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Customer');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Pickup Address');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Delivery Address');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Carrier Name');
                    $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Truck No');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Driver Name');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Shipper Name');
                    $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Consignee Name');
                    $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Booked by Supplier');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Accept');
                    $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Gate IN');
                    $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Pickup');
                    $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'Gate Out');
                    $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'In Transit');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AA1', 'DROP Gate In');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AB1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AC1', 'Delivery');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AD1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AE1', 'DROP Gate Out');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AF1', 'Executed By');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AG1', 'POD Status');
                    $objPHPExcel->getActiveSheet()->getStyle('A1:AG1')->applyFromArray($styleArray);

                    $rowCount = 2;
                    foreach ($orderReportData as $i => $result) {
                        $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $i + 1);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['order_id']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['delivery_note']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['salog_ref']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['shipmentid']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['order_status']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, date('d-m-Y h:i A',strtotime($result['createdon'])));
                        $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['customer_name']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['pickup_address']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['delivery_address']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['carrier_name']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['register_number'] ? $result['register_number'] : $result['truck']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['driver_name']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['pickup_company']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['delivery_company']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $result['supplier_booked'] ? date('d-m-Y h:i A', strtotime($result['supplier_booked'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $result['accepted_date'] ? date('d-m-Y h:i A', strtotime($result['accepted_date'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $result['accepted_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $result['o_gatein'] ? date('d-m-Y h:i A', strtotime($result['o_gatein'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $result['o_gatein_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $result['pickup_date'] ? date('d-m-Y h:i A', strtotime($result['pickup_date'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $result['pickup_date_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, $result['pickup_gateout'] ? date('d-m-Y h:i A', strtotime($result['pickup_gateout'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('X' . $rowCount, $result['pickup_gateout_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('Y' . $rowCount, $result['in_transit'] ? date('d-m-Y h:i A', strtotime($result['in_transit'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('Z' . $rowCount, $result['in_transit_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('AA' . $rowCount, $result['d_gatein'] ? date('d-m-Y h:i A', strtotime($result['d_gatein'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('AB' . $rowCount, $result['d_gatein_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('AC' . $rowCount, $result['delivery'] ? date('d-m-Y h:i A', strtotime($result['delivery'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('AD' . $rowCount, $result['delivery_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('AE' . $rowCount, $result['d_gateout'] ? date('d-m-Y h:i A', strtotime($result['d_gateout'])) : '');
                        $objPHPExcel->getActiveSheet()->SetCellValue('AF' . $rowCount, $result['d_gateout_reason']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('AG' . $rowCount, $result['pod_uploaded'] ? date('d-m-Y h:i A', strtotime($result['pod_uploaded'])) : '');
                        $rowCount++;
                    }
                    $fileName = 'carrier_live_kpi_'."_".date("Ymdhis").'.xlsx';
                    @ob_end_clean();
                    $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
                    $objWriter->save(str_replace(__FILE__, $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/{$fileName}", __FILE__));
                    $receiverName = $carrier['name'];
                    $recipient = $carrier['email'];
                    try {
                        $subject = "svkonekt Daily report for Carrier";
                        $filePath = sprintf('%s/assets/%s', FCPATH, $fileName);
                        $files = [$filePath];
                        $body = $this->load->view('mail_forms/autoreports/carrier_live_kpi_daily_mail_body', [], true);
                        if ( !$this->phpmailerlibrary->sendmail($recipient, $subject, $body, [], $files) ) {
                            log_message("error", "Unable to send the email of carrier live KPI daily report");
                        } else {
                            log_message("error", "Email of carrier live KPI daily report has been sent successfully");
                            if ( !unlink($filePath) ) {
                                log_message("error", "Unable to delete the attachment file ".$filePath);
                            } else {
                                log_message("error", "Carrier live KPI daily report has been deleted successfully");
                            }
                        }
                    } catch (Exception $e) {
                        log_message("error", "Daily carrier Live KPI report not send on " . date('d-m-Y h:i A') . " - " . $e->getMessage());
                    }
                }
                
            }
        }
    }
}