<?php

use App\Models\CarrierModeModel;

if ( !defined( 'BASEPATH' ) )
exit( 'No direct script access allowed' );

class CarrierMode extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model( 'common' );
        $this->load->library(['uuid','InspectPdfLibrary']);
        date_default_timezone_set( 'UTC' );

    }

    /*
    *  To use as service for mobile web application to get secure link.
    *  Method : POST
    *  @param ship_id
    *  return json
    */

    public function getsecureLink( $ship_id, $carrier_party_identifier ) {
        $this->load->helper( 'jwt' );

        // exp date
        $expDate = strtotime( '+30 days' );

        $jwt_claim = array( 'iss' => 'kn' . $carrier_party_identifier, 'sub' => $ship_id, );
        $get_jwt = generate_jwt_carrier( $jwt_claim );
        $link_id = base_url() . 'driverapp/' . $get_jwt;

        return $link_id;
        if ( $link_id != '' ) {
            echo json_encode( array( 'status' => '1', 'secure_link' => $link_id ) );
        } else {
            echo json_encode( array( 'status' => '0', 'secure_link' => $link_id ) );
        }
    }

    public function verify_jwt(string $jwt): void
    {
        $this->load->helper('jwt');
        $response = validate_jwt_carrier($jwt);
        $code = $response['code'];
        if (200 === $code) {
            if (isset($response['token']['sub']) && isset($response['token']['iss'])) {
                $this->load->library('user_agent');
                if ($this->agent->is_mobile()) {
                    $driverLinkJWT = generate_jwt([
                        "sub" => $response['token']['sub'],
                        "exp" => strtotime('+' . JWT_TOKEN_VALID_DAYS . ' days'),
                    ]);
                    redirect('driverappv3/' . $driverLinkJWT);
                }
                $this->massstatus($response['token']['sub'], substr($response['token']['iss'], 2), $jwt);
            } else {
                show_error(
                    'Carrier Mode/ Invalid jwt response is received.',
                    500,
                    'An Error Was Encountered during secure link validation'
                );
            }
        } else {
            if (400 === $code) {
                redirect('CarrierMode/invalid/sigin');
            } elseif (403 === $code) {
                redirect('CarrierMode/invalid/tokenexp');
            } else {
                show_error(
                    $response['error_message'],
                    $response['code'],
                    'An Error Was Encountered during secure link validation'
                );
            }
        }
    }

    public function secureLink(string $shipmentId, string $vendorCode): string
    {
        $this->load->helper('jwt');
        return base_url() . 'driverappv3/' . generate_jwt(['sub' => $shipmentId, 'exp' => strtotime('+10 days'), 'iss' => 'kn' . $vendorCode]);
    }

    /**
     * Get matching cariers for trip create
     */
    private function massstatus(string $shiftId, string $carrier, string $urlcode): void
    {
        if (false === $this->validateMassStatus($shiftId, $carrier, $urlcode)) {
            show_error('This Secure link does not have valid details.');
        }
        $check_shift_status = $this->common->gettblrowdata(['shipmentid' => $shiftId, 'status' => 1], 'vendor_id', 'tb_shifts', 0, 0);
        if (isset($check_shift_status['vendor_id']) && $check_shift_status['vendor_id'] != '') {
            $carrierInfo = $this->common->gettblrowdata(['code' => $carrier, 'status' => 1, 'id' => $check_shift_status['vendor_id']], 'id,code,country', 'tb_vendors', 0, 0);
            if (!$carrierInfo) {
                show_error('This Secure link is invalid.');
            }
            $data = [];
            $vendorCode = $carrierInfo['code'];
            $countryCode = $carrierInfo['country'];

            $data['page_title'] = $this->lang->line('menu_massstsupd');
            $data['sub_title'] = $this->lang->line('general_search');
            $ordersList = $this->common->gettbldata(
                [
                    'shipmentid' => $shiftId,
                    'status !=' => 0
                ],
                'id,order_id,trip_id,shift_id,shipmentid,pickup_city,delivery_city,company_code,
                    pickup_pincode,pickup_country,pickup_company,delivery_company,vendor_id,
                    delivery_pincode,createdon,pickup_datetime,quantity,branch_code',
                'tb_orders',
                0,
                0
            );
            $carriermodemodel = new CarrierModeModel($this->db);
            foreach ($ordersList as $res) {
                $orderRowId = $res['id'];
                $companyCode = $res['company_code'];
                $pickupPincode = $res['pickup_pincode'];
                $pickupCompany = $res['pickup_company'];
                $deliveryCompany = $res['delivery_company'];
                $deliveryPincode = $res['delivery_pincode'];
                $createdonRecord = $res['createdon'];
                $pickupDateTime = $res['pickup_datetime'];
                $pickupCountry = $res['pickup_country'];
                $shiftNo = $res['shift_id'];
                $quantity = $res['quantity'];
                $tripId = $res['trip_id'];
                $pickupCity = $res['pickup_city'];
                $deliveryCity = $res['delivery_city'];
                $statusCode = $pickupStopDateTime = $statusCodePickup = $statusStagePickup = '';
                $source = self::formatPinCode($countryCode, $pickupPincode, $pickupCity);
                $destination = self::formatPinCode($countryCode, $deliveryPincode, $deliveryCity);

                $picupcheck1 = [
                    'shipment_id' => $shiftNo,
                    'trip_id' => $tripId,
                    'order_id' => $res['id'],
                    'stop_type' => 'P',
                    'status_code !=' => '0191',
                    'status_code !=' => '0420',
                    'status_stage !=' => 'PICKUP_GATE_IN',
                    'status' => 1
                ];
                $picupcheck2 = ['status_stage !=' => 'PICKUP_GATE_OUT'];
                $select = 'id,status_code,createdon,stop_type,status_stage';
                $pickupStopStatusResponse = $carriermodemodel->getStopStatusInformation($select, $picupcheck1, $picupcheck2, 'tb_stop_status');
                if ($pickupStopStatusResponse) {
                    $statusCode = $pickupStopStatusResponse['status_code'];
                    $statusCodePickup = $pickupStopStatusResponse['status_code'];
                    $statusStagePickup = $pickupStopStatusResponse['status_stage'];
                    $pickupStopDateTime = $pickupStopStatusResponse['createdon'];
                }
                $refValue = '';
                $voyageNumber = $this->common->gettblrowdata(['order_id' => $orderRowId, 'ref_belongs_to' => 'VOYAGE NUMBER'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0)['ref_value'] ?? '';
                $orderTrackingNumber = $this->common->gettblrowdata(['order_id' => $orderRowId, 'ref_belongs_to' => 'ORDER TRACKING NUMBER'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0)['ref_value'] ?? '';
                $podPath = $this->common->gettblrowdata(['order_id' => $orderRowId, 'doc_type' => 3, 'stop_type' => 'D'], 'id,imgpath', 'tb_pod_uploads', 0, 0)['imgpath'] ?? '';
                $statusCodeDelivery = $stopTypeDelivery = $deliveryStopDateTime = $statusStageDelivery = '';
                $checkststdel = [
                    'shipment_id' => $shiftNo,
                    'order_id' => $res['id'],
                    'stop_type' => 'D',
                    'status_stage !=' => 'DELIVERY_GATE_IN',
                    'status' => 1
                ];
                $checkststde2 = ['status_stage !=' => 'DELIVERY_GATE_OUT', 'status' => 1];
                $deliveryStopStatusResponse = $carriermodemodel->getStopStatusInformation('id,status_code,createdon,stop_type,createdon,status_stage', $checkststdel, $checkststde2, 'tb_stop_status');
                if ($deliveryStopStatusResponse) {
                    $statusCodeDelivery = $deliveryStopStatusResponse['status_code'];
                    $stopTypeDelivery = $deliveryStopStatusResponse['stop_type'];
                    $deliveryStopDateTime = $deliveryStopStatusResponse['createdon'];
                    $statusStageDelivery = $deliveryStopStatusResponse['status_stage'];
                }
                $docs = $this->common->gettbldata(['order_id' => $res['id'], 'doc_type' => 2, 'stop_type' => 'D', 'status' => 1], 'id,doc_type,imgpath,stop_type', 'tb_pod_uploads', 0, 0);
                $driverlink = $this->secureLink($res['shipmentid'], $vendorCode);
                $pickupDateTime = self::getDateTime($pickupDateTime, $this->dettimezonedate(), 'Y-m-d H:i:s');
                if ($pickupStopDateTime != '') {
                    $pickupStopDateTime = self::getDateTime($pickupStopDateTime, $this->dettimezonedate(), 'Y-m-d H:i:s');
                }
                if ($deliveryStopDateTime != '') {
                    $deliveryStopDateTime = self::getDateTime($deliveryStopDateTime, $this->dettimezonedate(), 'Y-m-d H:i:s');
                }

                $data['tripsdata'][] = [
                    'trip_id' => $res['trip_id'],
                    'ship_id' => $res['shift_id'],
                    'ord_id' => $res['id'],
                    'shipmentid' => $res['shipmentid'],
                    'order_id' => $res['order_id'],
                    'pickup_city' => $res['pickup_city'],
                    'delivery_city' => $res['delivery_city'],
                    'pstpid' => $res['id'],
                    'stop_type_d' => $stopTypeDelivery,
                    'status_code' => $statusCode,
                    'status_code_d' => $statusCodeDelivery,
                    'status_code_p' => $statusCodePickup,
                    'quantity' => $quantity,
                    'pickdt' => $pickupStopDateTime,
                    'dt_d' => $deliveryStopDateTime,
                    'doc_files' => $docs,
                    'driverlink' => $driverlink,
                    'source' => $source,
                    'destination' => $destination,
                    'voyanumber' => $voyageNumber,
                    'podpath' => $podPath,
                    'ref_value' => $refValue,
                    'company_code' => $companyCode,
                    'status_stage_p' => $statusStagePickup,
                    'pickup_pincode' => $pickupPincode,
                    'delivery_pincode' => $deliveryPincode,
                    'pickup_country' => $pickupCountry,
                    'status_stage_d' => $statusStageDelivery,
                    'pickup_company' => $pickupCompany,
                    'delivery_company' => $deliveryCompany,
                    'pickup_datetime' => $pickupDateTime,
                    'orderreaching_no' => $orderTrackingNumber,
                    'createdonrecord' => $createdonRecord,
                    'jwt_shiftid' => $shiftId,
                    'jwt_carrer' => $carrier,
                    'urlcode' => $urlcode,
                    'trip_status' => 'open'
                ];
            }
            $this->newtemplate->dashboard_carrier('admin/massstatus_etn', $data);
        } else {
            $data['tripsdata'][] = ['trip_status' => 'cancel'];
            $this->newtemplate->dashboard_carrier('admin/massstatus_etn', $data);
        }
    }

        public function update_order_status() {
            date_default_timezone_set( 'UTC' );
            $randomnumber = rand();

            $tzone = $this->input->post( 'tzone', true );

            $row_id_hid = $this->input->post( 'row_id_hid', true );
            $pickupstatus = $this->input->post( 'pickupstatus', true );
            $ord_id = $this->input->post( 'ordid', true );
            $pickupdate = $this->input->post( 'selected_pickdt', true );

            /* convert date to send xml */
            $pickup_datetime_convrt = date( 'Y-m-d H:i:s', strtotime( getdatetimebytimezone( DFLT_TZ, $pickupdate, $this->dettimezonedate() )['datetime'] ) );

            $pickupdate = $pickup_datetime_convrt;

            $splitTimeStamp_convrt = explode( ' ', $pickup_datetime_convrt );
            $pickdate_convrt = $splitTimeStamp_convrt[0];
            $picktime_convrt = $splitTimeStamp_convrt[1];

            $order_id = $this->input->post( 'order_id_' . $row_id_hid, true );

            $shipmentid = $this->input->post( 'shipmentid_hid', true );
            $stop_id = $stopdetails_id = $vehicle_id = $driver_id = 0;
            $pick_comments = $this->input->post( 'pick_comments', true );
            $urlcode = $this->input->post( 'urlcode', true );

            $backurl = 'knmcdbkg/' . $urlcode;

            $createdon = date( 'Y-m-d H:i:s' );

            $getorderinfo = $this->common->gettblrowdata( array( 'id' => $ord_id, 'shipmentid' => $shipmentid ), 'id,order_id,user_id,shift_id,trip_id,shipment_id,vendor_id,createdon,pickup_city,branch_code,
            physicalreceiver,logicalsender,physicalsender,logicalreceiver,created_source', 'tb_orders', 0, 0 );

            if ( count( $getorderinfo ) > 0 ) {

                $idd = $getorderinfo['id'];
                $trip_id = $getorderinfo['trip_id'];
                $ship_id = $getorderinfo['shift_id'];
                $shipment_id = $getorderinfo['shipment_id'];

                $CrtDate = $getorderinfo['createdon'];
                $user_id = $getorderinfo['user_id'];
                $vendor_id = $getorderinfo['vendor_id'];
                $pickup_city = $getorderinfo['pickup_city'];
                $order_id = $getorderinfo['order_id'];
                $branch_code = $getorderinfo['branch_code'];
                $physicalreceiver = $getorderinfo['physicalreceiver'];
                $logicalsender = $getorderinfo['logicalsender'];
                $physicalsender = $getorderinfo['physicalsender'];
                $logicalreceiver = $getorderinfo['logicalreceiver'];
                $created_source = $getorderinfo['created_source'];

                $stsdate = $pickupdate;
                $stsdate = date( 'Y-m-d H:i:s', strtotime( $pickupdate ) );

                $kn_office = '';
                $knofficrefval = $this->common->gettblrowdata( array( 'order_id' => $idd, 'ref_belongs_to' => 'KN OFFICE' ), 'id,reference_id,ref_value', 'tb_order_references', 0, 0 );

                if ( count( $knofficrefval ) > 0 ) {

                    $kn_office = $knofficrefval['ref_value'];
                }

                $voyag_no = '';
                $voyagno = $this->common->gettblrowdata( array( 'order_id' => $idd, 'ref_belongs_to' => 'VOYAGE NUMBER' ), 'id,reference_id,ref_value', 'tb_order_references', 0, 0 );

                if ( count( $voyagno ) > 0 ) {

                    $voyag_no = $voyagno['ref_value'];
                }

                $orderreaching_no = '';
                $orderno = $this->common->gettblrowdata( array( 'order_id' => $idd, 'ref_belongs_to' => 'ORDER TRACKING NUMBER' ), 'id,reference_id,ref_value', 'tb_order_references', 0, 0 );

                if ( count( $voyagno ) > 0 ) {

                    $orderreaching_no = $orderno['ref_value'];
                }

                $getstops = $this->common->gettblrowdata( array( 'shift_id' => $ship_id, 'order_id' => $order_id ), 'id,
                stop_id,drop_stopid', 'tb_employee', 0, 0 );

                if ( count( $getstops ) > 0 ) {
                    $stopdetails_id = $getstops['id'];

                    $stop_type = 'P';
                    $stop_id = $getstops['stop_id'];

                    $drop_stopid = $getstops['drop_stopid'];
                }

                $where = array( 'shift_id' => $ship_id );
                $select = 'vehicle_id,driver_id';
                $table = 'tb_trips';
                $dvinfo = $this->common->gettblrowdata( $where, $select, $table, 0, 0 );

                if ( count( $dvinfo ) > 0 ) {
                    $driver_id = $dvinfo['driver_id'];
                    $vehicle_id = $dvinfo['vehicle_id'];
                }

                if ( $pickupstatus == 'DONE' || $pickupstatus == 'DAMAGED' || $pickupstatus == 'NOT DONE' ) {

                    if ( $pickupstatus == 'DONE' ) {
                        $status_code = '0500';
                        //320
                        $stop_type = 'P';
                        $pickupdate = $pickupdate;
                        $status_string = 'PICKUP_OK';
                        $stat_id = 1;
                    }

                    if ( $pickupstatus == 'DAMAGED' ) {
                        $status_code = '0502';
                        //321
                        $stop_type = 'P';
                        $pickupdate = $pickupdate;
                        $status_string = 'PICKUP_BROKEN';
                        $stat_id = 12;
                    }
                    if ( $pickupstatus == 'NOT DONE' ) {
                        $status_code = '0501';
                        $stop_type = 'P';
                        $pickupdate = $pickupdate;
                        $status_string = 'PICKUP_NOT_DONE';
                        $stat_id = 13;
                    }

                    $wherechck = array(
                        'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_type' => 'D', 'trip_id' => $trip_id,
                        'status_stage !=' => 'PICKUP_GATE_IN', 'status_id' => 1
                    );
                    $wherechck2 = array(
                        'status_stage !=' => 'PICKUP_GATE_OUT'
                    );
                    $wherechck3 = array(
                        'status_stage !=' => 'PICKUP_NOT_DONE'
                    );
                    $this->db->select( 'id' );
                    $this->db->from( 'tb_stop_status' );
                    $this->db->where( $wherechck );
                    $this->db->where( $wherechck2 );
                    $this->db->where( $wherechck3 );
                    $this->db->limit( 1 );
                    $res = $this->db->get();


                    if ( $res->num_rows() == 0 ) {

                        $checktrpid = $this->common->gettblrowdata(
                            array( 'shift_id' => $ship_id, 'status' => 1 ), 'id', 'tb_trips', 0, 0
                        );

                        if ( count( $checktrpid ) == 0 ) {
                            $savtrip = array(
                                'shift_id' => $ship_id, 'driver_id' => $driver_id,
                                'vehicle_id' => $vehicle_id, 'stime' => $stsdate, 'created_on' => $createdon
                            );
                            $this->common->insertTableData( 'tb_trips', $savtrip );
                            $trip_id = $this->db->insert_id();
                        } else {

                            $trip_id = $checktrpid['id'];
                        }

                        $vehwhr = array( 'id' => $ord_id );
                        $vehset = array( 'trip_id' => $trip_id );
                        $upd = $this->db->where( $vehwhr )->update( 'tb_orders', $vehset );

                        $vesh = array(
                            'user_id' => $user_id, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id,
                            'vehicle_id' => $vehicle_id, 'register_number' => 'FRANCE', 'created_on' => $pickupdate
                        );
                        $this->common->insertTableData( 'tb_shft_veh', $vesh );

                        $gatin = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => 2, 'loc_name' => "$pickup_city", 'status' => 1, 'reason' => 'Carrier Mode', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => '0420', 'reason' => 'Carrier', 'status_stage' => 'PICKUP_GATE_IN', 'createdon' => $pickupdate );
                        $this->common->insertTableData( 'tb_stop_status', $gatin );

                        $gatout = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $stat_id, 'loc_name' => "$pickup_city", 'status' => 1, 'reason' => 'Carrier Mode', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => $status_code, 'reason' => 'Carrier', 'status_stage' => "$status_string", 'createdon' => $pickupdate );
                        $this->common->insertTableData( 'tb_stop_status', $gatout );

                        $intransist = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => 3, 'loc_name' => "$pickup_city", 'status' => 1, 'reason' => 'Carrier Mode', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => '0191', 'reason' => 'Carrier', 'status_stage' => 'PICKUP_GATE_OUT', 'createdon' => $pickupdate );
                        $this->common->insertTableData( 'tb_stop_status', $intransist );

                        // $intransist = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => 1, 'loc_name' => $pickup_city, 'status' => 1, 'reason' => '', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => $status_code, 'createdon' => $pickupdate );
                        // $this->common->insertTableData( 'tb_stop_status', $intransist );
                        //Image Upload pickup
                        //comments save

                        if ( $pick_comments != '' ) {

                            $piccomm = array( 'order_id' => $ord_id, 'remark_id' => 22, 'description' => $pick_comments, 'createdon' => $pickupdate );
                            $this->common->insertTableData( 'tb_order_remarks', $piccomm );
                        }

                        $file_id = '';
                        $filepath = '';

                        if ( $_FILES['my_file_pickup']['name'] != '' ) {

                            $res = $this->uploadimage( $_FILES['my_file_pickup'], $randomnumber );

                            //                            if ( $res['errors'] == 0 ) {
                            if ( $res['errors'] == 1 ) {

                                $this->session->set_flashdata( 'msg', $res['err'] );
                                redirect( $backurl );
                            } else {
                                $imageSize = filesize(NEW_POD_PATH.$res['filename']);
                                $newUuid = $this->uuid->v4();
                                $doc = ['order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => 'P', 'trip_id' => $trip_id, 'imgpath' => $res['filename'], 'doc_type' => 2, 'createdon' => $pickupdate,'filesize'=>$imageSize,'hash'=>$newUuid];
                                $this->common->insertTableData( 'tb_pod_uploads', $doc );

                                $this->load->helper( 'user' );

                                $filepath = NEW_POD_PATH .$res['filename'];

                                $input = array(
                                    'physical_receiver'=> $physicalreceiver,
                                    'logical_receiver'=> $logicalreceiver,
                                    'physical_sender'=> $physicalsender,
                                    'logical_sender'=> $logicalsender,
                                    'order_id' => $orderreaching_no, // Tracking number
                                    'assoc_id' => $voyag_no, //voyag umber
                                    'ref_value_kn_office' => $kn_office, //kn refernce number
                                    'upload_type' => 'Image', // pic || POD
                                    'file_path' => $filepath, //img full path
                                    'branch_code' => $branch_code, // branch code ex. FNBVV
                                    'created_source'=>$created_source
                                );

                                $file_id = macadam_d3_dms( $input );
                            }
                        }

                        $input = array(
                            'physicalreceiver' => $physicalreceiver,
                            'logicalreceiver' => $logicalreceiver,
                            'physicalsender' => $physicalsender,
                            'logicalsender' => $logicalsender,
                            'order_id' => $orderreaching_no,
                            'assoc_id' => $voyag_no,
                            'ref_value_kn_office' => $kn_office,
                            'city' => $pickup_city,
                            'current_date_time' => $pickdate_convrt . 'T' . $picktime_convrt . 'Z', // date( 'Y-m-d\TH:i:s\Z', strtotime( $pickupdate ) ),
                            'current_time' => $picktime_convrt . 'Z', //date( 'H:i:s\Z', strtotime( $pickupdate ) ),
                            'current_date' => $pickdate_convrt, //date( 'Y-m-d', strtotime( $pickupdate ) ),
                            'document_id' => '',
                            'picture_id' => $file_id,
                            'remark' => $pick_comments,
                            'missing_qty' => '',
                            'status_code' => $status_code,
                            'upload_type' => 'Image',
                            'exception_code' => '',
                            'pod_signee' => '',
                            'stop_type' => 'P',
                            'pickup_city' => $pickup_city,
                            'tracking_ref' => $orderreaching_no,
                            'file_path' => $filepath,
                            'created_source'=>$created_source
                        );

                        macadam_status_send( $input, $status_string, 'Carrier' );

                        $this->session->set_flashdata( 'msg2', $this->lang->line( 'status_updated_successfully' ) );
                        redirect( $backurl );
                    } else {
                        $this->session->set_flashdata( 'msg', ' Pickup Status already exists.  ' );
                        redirect( $backurl );
                    }

                    $this->session->set_flashdata( 'msg2',  $this->lang->line( 'status_updated_successfully' ) );
                    redirect( $backurl );
                }
            }
        }

        /**
        * update_order_status_delivery

        */
        /*  Status delivery update*/

        public function update_order_status_delivery() {

            $arr = array();

            $row_id_hid = $this->input->post( 'row_id_hid', true );

            $jwt_shiftid = $this->input->post( 'jwt_shiftid', true );
            $jwt_carrer = $this->input->post( 'jwt_carrer', true );

            $ord_id = $this->input->post( 'ordid', true );

            $delivrydt1 = $this->input->post( 'delivrydt', true );
            $tzone = $this->input->post( 'tzone', true );

            $splitTimeStamp = explode( ' ', $delivrydt1 );
            $delvdate = $splitTimeStamp[0];
            $delvtime = $splitTimeStamp[1];

            /* convert date to send xml */
            $delv_datetime_convrt = date( 'Y-m-d H:i:s', strtotime( getdatetimebytimezone( DFLT_TZ, $delivrydt1,  $this->dettimezonedate() )['datetime'] ) );
            $splitTimeStamp_convrt = explode( ' ', $delv_datetime_convrt );
            $delvdate_convrt = $splitTimeStamp_convrt[0];
            $delvtime_convrt = $splitTimeStamp_convrt[1];

            $delivrydt = $this->input->post( 'delivrydt', true );
            // $delivrydt = date( 'Y-m-d H:i:s', strtotime( $delivrydt ) );

            $delivrydt = $delv_datetime_convrt;
            $order_id = $this->input->post( 'order_id_' . $row_id_hid, true );

            $delivstatus = $this->input->post( 'delivstatus', true );

            $shipmentid = $this->input->post( 'shipmentid_hid', true );
            $stop_id = $stopdetails_id = $vehicle_id = $driver_id = 0;

            $deliv_commnts = $this->input->post( 'deliv_commnts', true );
            $delivstatus = $this->input->post( 'delivstatus', true );
            $signatur = $this->input->post( 'signatur', true );
            $short = $this->input->post( 'short', true );
            $urlcode = $this->input->post( 'urlcode', true );
            $trackingno = $this->input->post( 'tracking', true );

            $backurl = 'knmcdbkg/' . $urlcode;

            $getorderinfo = $this->common->gettblrowdata( array( 'id' => $ord_id, 'shipmentid' => $shipmentid ), 'id,order_id,user_id,shift_id,trip_id,shipment_id,vendor_id,createdon,pickup_city,branch_code,
            physicalreceiver,logicalsender,logicalreceiver,physicalsender,delivery_city,created_source', 'tb_orders', 0, 0 );

            if ( count( $getorderinfo ) > 0 ) {

                $idd = $getorderinfo['id'];
                $trip_id = $getorderinfo['trip_id'];
                $ship_id = $getorderinfo['shift_id'];
                $shipment_id = $getorderinfo['shipment_id'];
                $CrtDate = $getorderinfo['createdon'];
                $user_id = $getorderinfo['user_id'];
                $vendor_id = $getorderinfo['vendor_id'];
                $pickup_city = $getorderinfo['pickup_city'];
                $delivery_city = $getorderinfo['delivery_city'];
                $order_id = $getorderinfo['order_id'];
                $branch_code = $getorderinfo['branch_code'];
                $physicalreceiver = $getorderinfo['physicalreceiver'];
                $logicalsender = $getorderinfo['logicalsender'];
                $physicalsender = $getorderinfo['physicalsender'];
                $logicalreceiver = $getorderinfo['physicalsender'];
                $created_source = $getorderinfo['created_source'];

                $kn_office = '';
                $knofficrefval = $this->common->gettblrowdata( array( 'order_id' => $idd, 'ref_belongs_to' => 'KN OFFICE' ), 'id,reference_id,ref_value', 'tb_order_references', 0, 0 );

                if ( count( $knofficrefval ) > 0 ) {

                    $kn_office = $knofficrefval['ref_value'];
                }

                $voyag_no = '';
                $voyagno = $this->common->gettblrowdata( array( 'order_id' => $idd, 'ref_belongs_to' => 'VOYAGE NUMBER' ), 'id,reference_id,ref_value', 'tb_order_references', 0, 0 );

                if ( count( $voyagno ) > 0 ) {

                    $voyag_no = $voyagno['ref_value'];
                }

                $orderreaching_no = '';
                $orderno = $this->common->gettblrowdata( array( 'order_id' => $idd, 'ref_belongs_to' => 'ORDER TRACKING NUMBER' ), 'id,reference_id,ref_value', 'tb_order_references', 0, 0 );

                if ( count( $voyagno ) > 0 ) {

                    $orderreaching_no = $orderno['ref_value'];
                }

                $getstops = $this->common->gettblrowdata( array( 'shift_id' => $ship_id, 'order_id' => $order_id ), 'id,stop_id,drop_stopid', 'tb_employee', 0, 0 );

                if ( count( $getstops ) > 0 ) {
                    $stopdetails_id = $getstops['id'];

                    $stop_type = 'P';
                    $stop_id = $getstops['stop_id'];

                    $stop_id = $getstops['drop_stopid'];
                }
            }

            $where = array( 'shift_id' => $shipment_id );
            $select = 'vehicle_id,driver_id';
            $table = 'tb_trips';
            $dvinfo = $this->common->gettblrowdata( $where, $select, $table, 0, 0 );

            if ( count( $dvinfo ) > 0 ) {
                $driver_id = $dvinfo['driver_id'];
                $vehicle_id = $dvinfo['vehicle_id'];
            }

            //comments save

            if ( $delivstatus == 'DONE_del' || $delivstatus == 'DAMAGED_del' || $delivstatus == 'SHORT_del' || $delivstatus == 'NOT DONE_del' || $delivstatus == 'REFUSED_del' ) {

                $stop_type = 'D';
                $CompleteDate = $delivrydt;

                if ( $delivstatus == 'DONE_del' ) {
                    //$status_code = '3000';
                    $status_code = '2300';
                    $ststus_id = '1';
                    $status_string = 'DELIVERED';
                }

                if ( $delivstatus == 'DAMAGED_del' ) {
                    // $status_code = '3002';
                    $status_code = '0502';
                    $ststus_id = '12';

                    $status_string = 'DELIVERED_WITH_DAMAGE';
                }

                if ( $delivstatus == 'SHORT_del' ) {
                    // $status_code = '3002';
                    $status_code = '0503';
                    $ststus_id = '13';

                    $status_string = 'DELIVERY_SHORT';
                }
                if ( $delivstatus == 'NOT DONE_del' ) {
                    // $status_code = '3001';
                    $status_code = '0504';
                    $ststus_id = '14';

                    $status_string = 'DELIVERY_NOT_DONE';
                }
                if ( $delivstatus == 'REFUSED_del' ) {
                    // $status_code = '3001';
                    $status_code = '0505';
                    $status_string = 'DELIVERY_REFUSED';
                    $ststus_id = '15';
                    //db  null value is not accepting changed to 0
                }

                /*
                *  check image size and formate ( Validation )
                */

                $typ = 'validate';

                if ( $_FILES['my_file_delv']['name'] != '' ) {

                    $res_1 = $this->uploadimage( $_FILES['my_file_delv'], $typ );
                    if ( $res_1['errors'] == 1 ) {

                        $this->session->set_flashdata( 'msg', $res_1['err'] );
                        redirect( $backurl );

                    }

                }

                /*
                *  check POD size and formate ( Validation )
                */
                if ( $_FILES['pod_file_dilv']['name'] != '' ) {

                    $res_2 = $this->uploadimage( $_FILES['pod_file_dilv'], $typ );
                    if ( $res_2['errors'] == 1 ) {

                        $this->session->set_flashdata( 'msg',  $res_2['err'] );
                        redirect( $backurl );

                    }

                }

                $wherechck = array(
                    'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id,
                    'stop_detail_id' => $stopdetails_id, 'stop_type' => 'D', 'trip_id' => $trip_id,
                    'status_stage !=' => 'DELIVERY_GATE_IN'
                );
                $wherechck2 = array(
                    'status_stage !=' => 'DELIVERY_GATE_OUT'
                );
                $wherechck3 = array(
                    'status_stage !=' => 'DELIVERY_NOT_DONE'
                );
                $this->db->select( 'id' );
                $this->db->from( 'tb_stop_status' );
                $this->db->where( $wherechck );
                $this->db->where( $wherechck2 );
                $this->db->where( $wherechck3 );
                $this->db->limit( 1 );
                $res = $this->db->get();

                if ( $res->num_rows() == 0 ) {

                    /*  status Image Upload */

                    // if ( $pickupstatus == 'DONE_del' ) {

                    $delvdatout = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => 'D', 'trip_id' => $trip_id, 'status_id' => 2, 'loc_name' => $pickup_city, 'status' => 1, 'reason' => 'Carrier', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => '0192', 'status_stage' => 'DELIVERY_GATE_IN', 'createdon' => $CompleteDate );
                    $this->common->insertTableData( 'tb_stop_status', $delvdatout );

                    $delvdatin = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => 'D', 'trip_id' => $trip_id, 'status_id' => $ststus_id, 'loc_name' => $pickup_city, 'status' => 1, 'reason' => 'Carrier', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => $status_code, 'status_stage' => "$status_string", 'createdon' => $CompleteDate );
                    $this->common->insertTableData( 'tb_stop_status', $delvdatin );

                    $delvdatde = array( 'order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => 'D', 'trip_id' => $trip_id, 'status_id' => 3, 'loc_name' => $pickup_city, 'status' => 1, 'reason' => 'Carrier', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status_code' => '3000', 'status_stage' => 'DELIVERY_GATE_OUT', 'createdon' => $CompleteDate );
                    $this->common->insertTableData( 'tb_stop_status', $delvdatde );

                    if ( $delivstatus == 'DONE_del' ) {

                        // $ci->common->updatetbledata( 'tb_orders', array( 'trip_sts' => 1 ), array( 'id' => $ord_id ) );
                        // $this->generatesummary( $trip_id, '' )
                    }

                    if ( $deliv_commnts != '' ) {
                        $delicomm = array( 'order_id' => $ord_id, 'remark_id' => 23, 'description' => $deliv_commnts, 'createdon' => $delivrydt );
                        $this->common->insertTableData( 'tb_order_remarks', $delicomm );
                    }
                    if ( $signatur != '' ) {
                        $sig = array( 'order_id' => $ord_id, 'remark_id' => 24, 'description' => $signatur, 'createdon' => $delivrydt );
                        $this->common->insertTableData( 'tb_order_remarks', $sig );
                    }
                    if ( $short != '' ) {
                        $shortt = array( 'order_id' => $ord_id, 'remark_id' => 25, 'description' => $short, 'createdon' => $delivrydt );
                        $this->common->insertTableData( 'tb_order_remarks', $shortt );
                    }

                    /*  image Upload */
                    $file_id = '';
                    $doc_id = '';

                    if ( $_FILES['my_file_delv']['name'] != '' ) {

                        $res2 = $this->uploadimage( $_FILES['my_file_delv'] );
                        $delvimg_filpath =  NEW_POD_PATH . $res2['filename'];

                        if ( $res2['errors'] == 0 ) {
                            $imageSize = filesize(NEW_POD_PATH.$res2['filename']);
                            $newUuid = $this->uuid->v4();
                            $doc = ['order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => 'D', 'trip_id' => $trip_id, 'imgpath' => $res2['filename'], 'doc_type' => 33, 'createdon' => $delivrydt, 'filesize' => $imageSize, 'hash' => $newUuid];
                            $this->common->insertTableData( 'tb_pod_uploads', $doc );

                            $this->load->helper( 'user' );

                            $input = array(
                                'physical_receiver'=> $physicalreceiver,
                                'logical_receiver'=> $logicalreceiver,
                                'physical_sender'=> $physicalsender,
                                'logical_sender'=> $logicalsender,
                                'order_id' => $orderreaching_no, // Tracking number
                                'assoc_id' => $voyag_no, //voyag umber
                                'ref_value_kn_office' => $kn_office, //kn refernce number
                                'upload_type' => 'IMAGE', // pic || POD
                                'file_path' => $delvimg_filpath, //img full path
                                'branch_code' => $branch_code, // branch code ex. FNBVV
                                'created_source'=>$created_source
                            );

                            $file_id = macadam_d3_dms( $input );
                        }
                    }

                    //pod upload

                    $podfilpath = '';

                    if ( $_FILES['pod_file_dilv']['name'] != '' ) {

                        $res3 = $this->uploadimage( $_FILES['pod_file_dilv'] );

                        if ( $res3['errors'] == 0 ) {
                            $newUuid = $this->uuid->v4();
                            $imageSize = filesize(NEW_POD_PATH.$res3['filename']);
                            $doc = ['order_id' => $ord_id, 'shipment_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stopdetails_id, 'stop_type' => 'D', 'trip_id' => $trip_id, 'imgpath' => $res3['filename'], 'doc_type' => 3, 'createdon' => $delivrydt,'filesize'=>$imageSize,'hash'=>$newUuid];
                            $this->common->insertTableData( 'tb_pod_uploads', $doc );

                            $this->load->helper( 'user' );

                            $podfilpath = NEW_POD_PATH. $res3['filename'];

                            $input = array(
                                'physical_receiver'=> $physicalreceiver,
                                'logical_receiver'=> $logicalreceiver,
                                'physical_sender'=> $physicalsender,
                                'logical_sender'=> $logicalsender,
                                'order_id' => $orderreaching_no, // Tracking number
                                'assoc_id' => $voyag_no, //voyag umber
                                'ref_value_kn_office' => $kn_office, //kn refernce number
                                'upload_type' => 'POD', // pic || POD
                                'file_path' =>  $podfilpath, //img full path
                                'branch_code' => $branch_code, // branch code ex. FNBVV
                                'created_source'=>$created_source
                            );
                            $doc_id = macadam_d3_dms( $input );
                        }
                    }

                    // push status xml to esb

                    $input = array(
                        'physicalreceiver' => $physicalreceiver,
                        'logicalreceiver' => $logicalreceiver,
                        'physicalsender' => $physicalsender,
                        'logicalsender' => $logicalsender,
                        'order_id' => $orderreaching_no,
                        'assoc_id' => $voyag_no,
                        'ref_value_kn_office' => $kn_office,
                        'city' => $pickup_city,
                        'current_date_time' => $delvdate_convrt . 'T' . $delvtime_convrt . 'Z', //date( 'Y-m-d\TH:i:s\Z', strtotime( $delivrydt1 ) ),
                        'current_time' => $delvtime_convrt . 'Z', //date( 'H:i:s\Z', strtotime( $delivrydt1 ) ),
                        'current_date' => $delvdate_convrt, //date( 'Y-m-d', strtotime( $delivrydt1 ) ),
                        'document_id' => $doc_id,
                        'picture_id' => $file_id,
                        'remark' => $deliv_commnts,
                        'missing_qty' => $short,
                        'status_code' => $status_code,
                        'upload_type' => 'Image',
                        'exception_code' => '',
                        'pod_signee' => $signatur,
                        'stop_type' => 'D',
                        'pickup_city' => $pickup_city,
                        'delivery_city' => $delivery_city,
                        'tracking_ref' => $orderreaching_no,
                        'file_path' => $podfilpath,
                        'created_source'=>$created_source
                    );

                    macadam_status_send( $input, $status_string, 'Carrier' );

                    $this->session->set_flashdata( 'msg2',   $this->lang->line( 'status_updated_successfully' ) );
                    redirect( $backurl );
                } else {

                    $this->session->set_flashdata( 'msg', 'Status already exists.' );
                    redirect( $backurl );
                }
            }
        }

        public function getorderinfo() {

            $orderid = $this->input->post( 'orderid', TRUE );

            $getordetails = [];
            $orderinfo = [];
            $cargoinfo = [];
            $dangercargoinfo = [];

            $data = array();

            $order_trackin_no = '';
            $pick_contact_person = '';
            $shipper_ref = '';
            $shipper_phone = '';
            $pickupnote = '';
            $delivery_contact_person = '';
            $delivery_phone = '';
            $consinee_ref = '';
            $delivery_note = '';
            $europalet = '';
            $transport_condition = '';
            $vehicle_char = '';
            $stop_order = '';

            $ref_val = $this->common->gettbldata(
                array(
                    'order_id' => $orderid
                ), 'id, order_id, reference_id, ref_value, ref_belongs_to, order_shortNo', 'tb_order_references', 0, 0 );

                foreach ( $ref_val as $res ) {
                    // $data['getordetails'] = $orderinfo;

                    $ref_belongs_to = $res['ref_belongs_to'];

                    if ( $ref_belongs_to == 'ORDER TRACKING NUMBER' ) {
                        $order_trackin_no = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'PUP CONTACT NAME' ) {
                        $pick_contact_person = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'SHIPPER' ) {
                        $shipper_ref = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'TRUCKINGWAYPOINT PUP CT TE' ) {
                        $shipper_phone = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'ADDITIONAL PICKUP INFO' ) {
                        $pickupnote = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'DEL CONTACT NAME' ) {
                        $delivery_contact_person = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'TRUCKINGWAYPOINT DEL CT TE' ) {
                        $delivery_phone = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'CONSIGNEE' ) {
                        $consinee_ref = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'ADDITIONAL DELIVERY INFO' ) {
                        $delivery_note = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'EFP' ) {
                        $europalet = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'TRANS_COND_TRIP_NOTE' ) {
                        $transport_condition = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'VEHICLE_TRIP_NOTE' ) {
                        $vehicle_char = $res['ref_value'];
                    }
                    if ( $ref_belongs_to == 'STOP_ORDER_TRIP_NOTE' ) {
                        $stop_order = $res['ref_value'];
                    }
                }

                $data['order_trackin_no'] = $order_trackin_no;
                $data['pick_contact_person'] = $pick_contact_person;
                $data['shipper_ref'] = $shipper_ref;
                $data['shipper_phone'] = $shipper_phone;
                $data['pickupnote'] = $pickupnote;
                $data['delivery_contact_person'] = $delivery_contact_person;
                $data['delivery_phone'] = $delivery_phone;
                $data['consinee_ref'] = $consinee_ref;
                $data['delivery_note'] = $delivery_note;
                $data['europalet'] = $europalet;
                $data['transport_condition'] = $transport_condition;
                $data['vehicle_char'] = $vehicle_char;
                $data['stop_order'] = $stop_order;

                $orderinfo = $this->common->gettblrowdata( array( 'id' => $orderid ), 'id,order_id,pickup_company,delivery_company,pickup_country,pickup_city,pickup_address1,pickup_address2,delivery_city,delivery_address1,delivery_address1,delivery_address2,delivery_pincode,company_code,
                 pickup_pincode,pickup_country,pickup_company,delivery_company,delivery_country, delivery_datetime,
                 delivery_pincode,createdon,pickup_datetime,quantity,branch_code', 'tb_orders', 0, 0 );

                if ( isset( $orderinfo['pickup_datetime'] ) ) {
                    $pickup_datetime = $orderinfo['pickup_datetime'];
                    $delivery_datetime = $orderinfo['delivery_datetime'];
                    $orderinfo['pickup_datetime'] = date( 'Y-m-d H:i:s', strtotime( getdatetimebytimezone( $this->dettimezonedate(),  $pickup_datetime, DFLT_TZ )['datetime'] ) );
                    $orderinfo['delivery_datetime'] = date( 'Y-m-d H:i:s', strtotime( getdatetimebytimezone( $this->dettimezonedate(), $delivery_datetime, DFLT_TZ )['datetime'] ) );
                }

                $data['getordetails'] = $orderinfo;
                $cargoinfo = $this->common->gettbldata( array( 'order_id' => $orderid, 'status' => '1' ), 'id, order_id, cargo_id, handling_unit, length, width, height, weight, second_weight, volumetric_weight, volweight_uom, ldm, volume, second_volume, quantity, scanned_quantity, quantity_type, cargo_content', 'tb_order_cargodetails', 0, 0 );

                $weight = 0;
                $quantity = 0;
                $weight_unit = '';
                $pcs = '';
                $ldm = 0;
                $ldm_uom = '';
                if ( count( $cargoinfo ) > 0 ) {
                    foreach ( $cargoinfo as $resc ) {
                        $cargoid = $resc['cargo_id'];

                        $we = $this->common->gettbldata( array( 'id' => $cargoid, 'status' => '1' ), 'id,weight, weight_unit,ldm,ldm_uom', 'tb_cargo_details', 0, 0 );
                        if ( count( $cargoinfo ) > 0 ) {
                            foreach ( $we as $w ) {
                                $weight_unit = $w['weight_unit'];

                                $ldm_uom =  $w['ldm_uom'];

                                if ( is_numeric( $w['weight'] ) ) {
                                    $weight +=  $w['weight'];
                                }

                                if ( is_numeric( $w['ldm'] ) ) {
                                    $ldm += $w['ldm'];
                                }

                            }

                        }

                    }

                }

                $data['cargoinfo'] = $cargoinfo;

                $dangercargoinfo = $this->common->gettbldata( array( 'order_id' => $orderid ), 'id, db_class,org_number,description,mainrisk,limitqty_flag,exceptqty_flag', 'tb_order_dg_goods', 0, 0 );
                $data['dangercargoinfo'] = $dangercargoinfo;

                $data['units'] = array( 'weight_unit'=>$weight_unit, 'weight'=>$weight, 'ldm'=>$ldm, 'ldm_uom'=>$ldm_uom );

                $this->load->view( 'admin/infopage', $data );
            }

            /**
            * uploadimage

            */
            /*  Upload filoe validation*/

            public function uploadimage( $file, $validate = '' ) {

                $errors = array();
                $nm = time();
                //uniqid();

                $file_size = $file['size'];
                $file_tmp = $file['tmp_name'];
                $tmp = explode( '.', $file['name'] );

                $newfile = $nm . '_' . str_replace(" ","",$file['name']);
                $file_ext = strtolower( end( $tmp ) );

                $extensions = array( 'jpeg', 'jpg', 'png', 'bmp', 'pdf', 'tif', 'tiff' );

                if ( in_array( $file_ext, $extensions ) === false ) {
                    $errors['err'] = 'Extension not allowed, please choose  jpeg, jpg, png,bmp, pdf, tif, tiff file.';
                }

                if ( $file_size > 5000000 ) {
                    $errors['err'] = 'File size should not be greater than 5 mb.';
                }

                if ($file_ext == "pdf") {
                    if (!($this->inspectpdflibrary->validatepdf($file_tmp))) {
                        $errors['err'] = 'Malicious files are not accepted';
                    }
                }

                if ( ! $errors ) {
                    if ( $validate != 'validate' ) {
                        move_uploaded_file( $file_tmp, NEW_POD_PATH. $newfile );
                    }

                    return $errors = array( 'errors' => 0, 'filename' => $newfile );
                } else {

                    $errors['errors'] = 1;
                    $errors['filename'] = '';

                    return $errors;
                }
            }

            public function sent_secure_link_email()
            {
                $message = $this->input->post('message', true);
                $recipient = $this->input->post('recipient', true);
                $response = '0';
                if (strlen($message) > 5 && strlen($recipient) > 5) {
                    $this->load->library('PhpMailerLibrary');
                    $this->load->helper('email_templates');
                    $voyage_number = $this->input->post('voyage_number', true);
                    $body_eng = driverapp_securelink_email_template($message, $voyage_number);
                    $separator = "<p style='font-weight:bold;overflow-x: hidden;'>---------------------------------------------------------------------------------------</p>";
                    $body_france = driverapp_securelink_email_template_france($message, $voyage_number);
                    $body = $body_france . $separator . $body_eng;
                    try {
                        if ($this->phpmailerlibrary->sendmail($recipient, 'Shared trip ' . $voyage_number, $body)) {
                            $response = '1';
                        } else {
                            log_message("error", "CarrierMode Secure Link email failed");
                        }
                    } catch (Exception $e) {
                        log_message("error", "CarrierMode Secure Link email failed - " . $e->getMessage());
                    }
                }
                echo $response;
            }

            /*
            *  Purpose : To Share Driver link With driver over sms api
            */

            function driver_link_sharing() {
                $_POST = $this->input->post( NULL, TRUE );
                $mobile_numbers = $this->input->post( 'mobile_numbers', TRUE );
                // driver url
                $message = $this->input->post( 'message', TRUE );
                $voyage_number = $this->input->post( 'voyage_number', TRUE );
                $pickup_first_stop = $this->input->post( 'pickup_first_stop', TRUE );
                $response = '0';
                if ( isset( $mobile_numbers ) && isset( $message ) && isset( $voyage_number ) ) {
                    $phone_numbers = array();
                    $phone_numbers = explode( ',', $mobile_numbers );
                    if ( sizeof( $phone_numbers ) > 0 && strlen( $mobile_numbers )>5 ) {
                        $trip_info = $this->get_trip_info($voyage_number);
                        $this->load->library( 'shorturl_l' );
                        $short_message = $this->shorturl_l->urlToShortCode( $message );
                        $completed_msg = 'Your Trip ' . $voyage_number . ' '.$pickup_first_stop.'-'. $trip_info['source'] . ' / ' . $trip_info['destination'] .' '. base_url( 'shurl/' . $short_message );
                        $this->load->library( 'Sms' );
                        $response = $this->sms->share_secure_link( $completed_msg, $phone_numbers );
                        //                        $response = '1';
                    }
                } else {
                    $response = '0';
                }
                echo $response;
            }

            /**
            * dettimezonedate
            *
            * set timezone for carriermode FR because no login

            * @return string
            */

            function dettimezonedate() {
                return $curtz = 'Europe/paris';
            }

            /**
            * deduct_onehr_fromdatetime
            *
            * deduct -1 from date and time for france

            * @return datevalue
            */

            function deduct_onehr_fromdatetime( $dt ) {

                $DateTime = new DateTime( $dt );
                $DateTime->modify( '-1 hours' );
                $newTime =  $DateTime->format( 'Y-m-d H:i:s' );

                return $newTime;

            }

            /**
            * add_onehr_fromdatetime
            *
            * add 1 from date and time for france to display

            * @return datevalue
            */

            function add_onehr_fromdatetime( $dt ) {

                $DateTime = new DateTime( $dt );
                $DateTime->modify( '+1 hours' );
                $newTime =  $DateTime->format( 'Y-m-d H:i:s' );

                return $newTime;

            }

            function privacy_policy() {
                $data['page_title'] = $this->lang->line( 'privacy_policy' );
                $this->newtemplate->dashboard_carrier( 'admin/privacy_policy', $data );
            }

            public function get_trip_info($trip_id):array{
                $response = array("source"=>'','destination'=>'');
                if(strlen($trip_id)>2){
                    $trip_info= $this->common->gettblrowdata(array('status'=>1,'txnid'=>$trip_id),array('source','destination'),'tb_shipments',0,0);
                    if(isset($trip_info['source']) && $trip_info['source']!=''){
                        $source = $destination ='';
                        $source_array = explode('-',$trip_info['source']);
                        $source =$source_array[0].'-'.$source_array[2];
                        $destination_array = explode('-',$trip_info['destination']);
                        $destination =$destination_array[0].'-'.$destination_array[2];
                        $response = array("source"=>$source,'destination'=>$destination);
                    }
                }
                return $response;
            }

    function invalid($val) {
        $data['page_title'] = $this->lang->line( 'This trip is not available anymore' );
        $data['err'] = $val;
        $this->newtemplate->dashboard_carrier( 'admin/invalid', $data );
    }

    private static function validateMassStatus(string $shipmentId, string $carrier, string $urlcode): bool
    {
        if (empty($shipmentId)) {
            return self::error('Carrier Mode : Shipment ID should not be empty.');
        }

        if (empty($carrier)) {
            return self::error('Carrier Mode : Carrier should not be empty');
        }

        if (empty($urlcode)) {
            return self::error('Carrier Mode : Link should not be empty.');
        }
        return true;
    }

    private static function error(string $message): bool
    {
        log_message('error', 'Carrier Mode: ' . $message . '.');
        return false;
    }

    private static function formatPinCode(string $prefix, string $pinCode, string $suffix): string
    {
        return $prefix . '-' . substr($pinCode, 0, 2) . '-' . $suffix;
    }

    private static function getDateTime(string $dateTime, string $timeZone, string $dateFormat = 'Y-m-d H:i:s'): string
    {
        if (false === strtotime($dateTime)) {
            log_message("error","Carrier Mode: Datetime is invalid./".$dateTime);
            throw new RuntimeException("DateTime is invalid.");
        }
        return date($dateFormat, strtotime(getdatetimebytimezone($timeZone, $dateTime, DFLT_TZ)['datetime']));
    }
}

