<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Pagination\GetArgumentsResolver;
use App\Models\OrderList\Search\Search;
use App\Models\OrderList\Search\Properties;
use App\Models\OrderList\Search\AdvancedSearch;
use App\Pagination\Pagination;

class CarrierOrders extends CI_Controller
{
    public const IGNORED_ARGUMENT_KEYS = ['limit', 'page', 'searchsubmit'];
    private const GRAMS_ARRAY = ["G", "Gms", "gms", "grm"];
    private const KILOGRAMS_ARRAY = ["Kg", "kg"];
    private const TONS_ARRAY = ["Tons", "tons"];

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('business_type') != "Carrier") {
            redirect('welcome/logout');
        }
        $this->load->model(['Order']);
    }

    public function index(): void
    {
        $data['page_title'] = $this->lang->line('order_list');
        $data['sub_title'] = $this->lang->line('menu_orders');
        $data['refNamesArray'] = $this->Order->getrefnums();
        $userId = $this->session->userdata("user_id");
        $custId = $this->session->userdata("cust_id");
        $countryUserIds = $this->session->userdata("country_user_ids");
        $branchCode = $this->session->userdata('branch_code');
        $companyCode = $this->session->userdata('company_code');
        $roleId = $this->session->userdata('user_role_id');
        $subcusts = $this->session->userdata('sub_cust');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $getArguments = [];
        $conditions = [];
        $whr = [];
        $properties = new Properties($this->db);

        $getArguments = (new GetArgumentsResolver())->resolve(
            $this->getDefaultFilters(),
            $getArguments,
            self::IGNORED_ARGUMENT_KEYS
        );

        if (isset($getArguments['search_type']) && $getArguments['search_type'] === 'advanced') {
            $search = new AdvancedSearch($this->db, $getArguments);
            $conditions = $search->buildWhereClause($this->input, $roleId, $userId, $companyCode);
        } else {
            $search = new Search($this->db, $getArguments);
        }

        $field = $properties->getDateFieldName($getArguments);
        $search->fromDate($field, $whr);
        $search->toDate($field, $whr);
        if (isset($getArguments['advpickupfrom_date']) && !empty($getArguments['advpickupfrom_date'])) {
            $post_advpickupfrom_date = $this->db->escape_str($getArguments['advpickupfrom_date']);
            $advpickupfrom_date = date('Y-m-d', strtotime($post_advpickupfrom_date));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $advpickupfrom_date;
        }
        if (isset($getArguments['advpickupto_date']) && !empty($getArguments['advpickupto_date'])) {
            $post_advpickupto_date = $this->db->escape_str($getArguments['advpickupto_date']);
            $advpickupto_date = date('Y-m-d', strtotime($post_advpickupto_date));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $advpickupto_date;
        }
        if (isset($getArguments['advdeliveryfrom_date']) && !empty($getArguments['advdeliveryfrom_date'])) {
            $post_advdeliveryfrom_date = $this->db->escape_str($getArguments['advdeliveryfrom_date']);
            $advdeliveryfrom_date = date('Y-m-d', strtotime($post_advdeliveryfrom_date));
            $whr["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') >="] = $advdeliveryfrom_date;
        }
        if (isset($getArguments['advdeliveryto_date']) && !empty($getArguments['advdeliveryto_date'])) {
            $post_advdeliveryto_date = $this->db->escape_str($getArguments['advdeliveryto_date']);
            $advdeliveryto_date = date('Y-m-d', strtotime($post_advdeliveryto_date));
            $whr["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') <="] = $advdeliveryto_date;
        }

        $whr = array_merge($whr, $conditions);

        $orderStatus = isset($getArguments['status']) ? $this->db->escape_str($getArguments['status']) : "";
        $adOrderStatus = isset($getArguments['order_status']) ? $this->db->escape_str($getArguments['order_status']) : "";

        $statusSearch = $orderStatus;

        if ($statusSearch == "") {
            $statusSearch = $adOrderStatus;
        }

        $searchIds = isset($getArguments['bookingid']) ? $this->db->escape_str($getArguments['bookingid']) : [];
        if (empty($searchIds) && isset($getArguments['container_no']) && !empty($getArguments['container_no'])) {
            $searchIds = $this->GetContainernum($userId, $countryUserIds, $branchCode);
        } elseif (!empty($searchIds) && isset($getArguments['container_no']) && !empty($getArguments['container_no'])) {
            $container_num_arr = $this->GetContainernum($userId, $countryUserIds, $branchCode);
            $searchIds = array_intersect($container_num_arr, $searchIds);
        }
        if (isset($getArguments['order_reftype']) && $getArguments['order_reftype'] != "") {
            $advancedids = $this->getrefnum($userId, $getArguments);

            if (!empty($advancedids)) {
                $searchIds = $advancedids;
            } else {
                $whr['o.id'] = '0';
            }
        }

        if (isset($getArguments['salog_ref']) && $getArguments['salog_ref'] != "") {
            $advancedids = getSalogRefNum($userId, $getArguments, $companyCode);
            if (!empty($advancedids)) {
                $searchIds = $advancedids;
            } else {
                $whr['o.id'] = '0';
            }
        }
        $vendorId = $this->session->userdata("id");
        $whr['o.vendor_id'] = $vendorId;

        $wildcardSearch = isset($getArguments['wildcard_order_id']) ? $getArguments['wildcard_order_id'] : "";

        if (isset($getArguments['order_id']) && !empty($getArguments['order_id'])) {
            $searchIds = [$getArguments['order_id']];
        }

        $orderIdsMap = $properties->getOrderIdsMapping($wildcardSearch, $searchIds, $companyCode, $userId, $countryUserIds);
        if (isset($getArguments['order_references']) && !empty($getArguments['order_references'])) {
            $referenceResults = $this->Order->getOrderIdsByReferenceValues($getArguments['order_references']);
            $searchIds = empty($referenceResults) ? [0] : $referenceResults;
        }
        $orderdataQuery = $this->Order->indexQuery($userId, $searchIds, $statusSearch, $custId, $countryUserIds, $whr, $subcusts, $orderIdsMap);
        $this->db->query("SET SESSION group_concat_max_len = 1000000");
        $pagination = new Pagination(
            $orderdataQuery,
            isset($_GET['limit']) ? (int)$_GET['limit'] : 10,
            isset($_GET['page']) ? (int)$_GET['page'] : 1,
            $getArguments
        );

        $paginationResponse = $pagination->paginate();

        if ($paginationResponse->hasItems()) {
            $au_i = -1;
        }
        foreach ($paginationResponse->items() as $res) {
            $au_i++;
            $orderStatus = $properties->getStatusName($res);
            $referenceData = $properties->getReferences($res);
            $chkdate = '2020-07-01 00:00:00';
            $createdon = isset($res['createdon']) ? $res['createdon'] : '0000-00-00';
            $orderStr = strtotime($createdon);
            $chkStr = strtotime($chkdate);
            $earlyPickup = $res['pickup_datetime'];

            if ($orderStr > $chkStr) {
                if ($earlyPickup != "" && $earlyPickup != "0000-00-00 00:00:00") {
                    $epickup = getdatetimebytimezone($curtz, $earlyPickup, DFLT_TZ);
                    $earlyPickup = $epickup['datetime'];
                }
            }

            $POD = $res['pod'];
            $weightUnit = (isset($res['weight_unit']) && $res['weight_unit'] != "") ? $this->getWeightHigherUnit(
                $res['weight_unit']
            ) : "kg";

            $order[] = [
                'order_id' => $res['order_id'],
                'pickup' => $res['pickup'],
                'delivery' => $res['delivery'],
                'weight' => $this->calculateWeight($res['totwg'], $weightUnit),
                'gross_weight' => $res['weight'],
                'gross_weight_uom' => $res['gross_weight_uom'],
                'volume' => $res['totvol'],
                'pickup_date' => $earlyPickup,
                'deliverycity' => $res['delivery_city'],
                'salog_ref' => $referenceData['salog_ref'],
                'order_status' => $orderStatus,
                'createdon' => $createdon,
                'total_packages' => round(floatval($res['totqty'])),
                'weight_unit' => $weightUnit,
                'vendor_id' => $res['vendor_id'] ?? '',
                'POD' => $POD
            ];
            $paginationResponse->updateItems($order);
            $data['pagination'] = $paginationResponse ?? [];
        }
        $this->newtemplate->dashboard("carrierorders/index", $data);
    }

    private function getDefaultFilters(): array
    {
        return [
            "fromdate" => (new DateTime())->format('d-m-Y'),
            "todate" => (new DateTime())->format('d-m-Y')
        ];
    }

    private function getWeightHigherUnit($weightUnit): string
    {
        $weightUnitArray = explode(",", $weightUnit);

        if (array_intersect(self::TONS_ARRAY, $weightUnitArray)) {
            return 'tons';
        } elseif (array_intersect(self::KILOGRAMS_ARRAY, $weightUnitArray)) {
            return 'kg';
        } elseif (array_intersect(self::GRAMS_ARRAY, $weightUnitArray)) {
            return 'g';
        }

        return 'kg';
    }

    private function calculateWeight($weight, string $weightUnit)
    {
        if ($weightUnit == 'tons') {
            return $weight / 1000;
        } elseif ($weightUnit == 'g') {
            return $weight * 1000;
        }

        return $weight;
    }
}
