<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Carrierratios extends CI_Controller
{
    
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model('common');
        $this->load->model('Uniqlomodel');
        $this->load->helper('drop_down');
        $this->load->helper('log_helper');
        if (! checkUrlAccessForUser('CARRIERRATIOS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('trip_allocation_ratio');
        $data['sub_title']  = $this->lang->line('general_search');
        $company_code       = $this->session->userdata('company_code');

        $where['tc.status'] = 1;
        $whr                = [];
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $fdate            = $this->input->post('fromdate');
            $edate            = $this->input->post('todate');
            $searchcarrier_id = $this->input->post('searchcarrier_id');
            $searchorder_type = $this->input->post('searchorder_type');

            /*if (isset($fdate) && $fdate != "") {
                // $where["DATE(tc.createdon) >="] = $fdate;
                $whr['tc.startdate'] = $fdate;
            }
            if (isset($edate) && $edate != "") {
                // $where["DATE(tc.createdon) <="] = $edate;
                $whr['tc.enddate'] = $edate;
            }*/
            
            if (isset($fdate) && $fdate != "") {
                $from_date_obj = DateTime::createFromFormat('d-m-Y', $fdate);
                if ($from_date_obj !== false) {
                    $where["DATE(tc.startdate) >="] = $from_date_obj->format('Y-m-d');
                }
            }
            //log_message("error","endate:".$edate);
            if (isset($edate) && $edate != "") {
                $to_date_obj = DateTime::createFromFormat('d-m-Y', $edate);
                if ($to_date_obj !== false) {
                    $where["DATE(tc.enddate) <="] = $to_date_obj->format('Y-m-d');
                }
            }
            
            if (isset($searchcarrier_id) && $searchcarrier_id != "") {
                $whr['tc.carrier_id'] = $searchcarrier_id;
            }
            if (isset($searchorder_type) && $searchorder_type != "") {
                $whr['tc.order_type'] = $searchorder_type;
            }
        }

        $data['vendors'] = $this->common->gettbldata(
            ['status' => '1', 'company_code' => $this->session->userdata('company_code')],
            "id,name",
            "tb_vendors",
            0,
            0
        );
        $ratios = [];
        /*if (! empty($_POST)) {
            $ratios = $this->Uniqlomodel->carrierratios($where, $whr);
        }*/
        $ratios = $this->Uniqlomodel->carrierratios($where, $whr);
        //log_message("error","Qry::".$this->db->last_query());
        $data['ratios'] = $ratios;
        log_error(UNIQLO_LOG_PREFIX . "Carrierratios outbound data for carrierratios/index: " . json_encode($data));

        $this->newtemplate->dashboard("carrierratios/index", $data);
    }

    public function add()
    {
        $data['page_title'] = $this->lang->line('trip_allocation_ratio');
        $data['sub_title']  = $this->lang->line('general_add');
        $data['vendors']    = $this->common->gettbldata(
            ['status' => '1', 'company_code' => $this->session->userdata('company_code')],
            "id,name",
            "tb_vendors",
            0,
            0
        );

        //log_error(UNIQLO_LOG_PREFIX . "Carrierratios|add outbound data for carrierratios/add: " . implode(', ', $data));
        log_error(UNIQLO_LOG_PREFIX . "Carrierratios|add outbound data for carrierratios/add: " . json_encode($data));

        //$this->newtemplate->dashboard("carrierratios/add", $data);
        $this->load->view("carrierratios/add", $data);
    }

    public function insertcarrierratios()
    {
        $post = $this->input->post();
        extract($post);
        $res = [
            'sequence_no'      => $sequence_no,
            'startdate'        => $startdate,
            'enddate'          => $enddate,
            'order_type'       => $order_type,
            'allocate_percent' => $allocate_percent,
            'user_id'          => $this->session->userdata('user_id'),
            'carrier_id'       => $carrier_id,
            'createdby'        => $this->session->userdata('user_id'),
            'createdon'        => date('Y-m-d H:i:s'),
            'user_type'        => 0,
            'status'           => 1,

        ];

        /*log_error(
            UNIQLO_LOG_PREFIX .
            "Carrierratios insertpreferencerules inserted data in a tb_allocate_ratio_batch: " . implode(', ', $res)
        );*/
        
        log_error(
            UNIQLO_LOG_PREFIX .
            "Carrierratios insertpreferencerules inserted data in a tb_allocate_ratio_batch: " . json_encode($res)
        );

        $result = $this->common->insertTableData('tb_allocate_ratio_batch', $res);

        log_error(UNIQLO_LOG_PREFIX . "Carrierratios insertpreferencerules outbound data: " . json_encode($result));

        echo json_encode($result);
    }

    public function edit($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Carrierratios|edit inbound data: " . $id);

        $user_id            = $this->session->userdata('user_id');
        $data['user_id']    = $user_id;
        $data['page_title'] = $this->lang->line('trip_allocation_ratio');
        $data['sub_title']  = $this->lang->line('general_edit');
        $where1             = [
            'id' => $id,
        ];

        $table1            = "tb_allocate_ratio_batch";
        $edit_data         = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_data'] = $edit_data;
        $data['vendors']   = $this->common->gettbldata(
            ['status' => '1', 'company_code' => $this->session->userdata('company_code')],
            "id,name",
            "tb_vendors",
            0,
            0
        );
        $data['vendor']    = $this->common->gettblrowdata(
            ['id' => $edit_data['carrier_id']],
            "id,name",
            "tb_vendors",
            0,
            0
        );

        /*log_error(
            UNIQLO_LOG_PREFIX .
            "Carrierratios|edit outbound data for carrierratios/editpincode: " . implode(', ', json_encode($data))
        );*/
        log_error(
            UNIQLO_LOG_PREFIX .
            "Carrierratios|edit outbound data for carrierratios/editpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("carrierratios/edit", $data);
        $this->load->view("carrierratios/edit", $data);
    }

    public function updatecarrierratio()
    {
        $id = $this->input->post('id');
        if (isset($id)) {
            $user_id = $this->session->userdata('user_id');
            $post    = $this->input->post();
            extract($post);
            $res = [
                'carrier_id'       => $carrier_id,
                'sequence_no'      => $sequence_no,
                'startdate'        => $startdate,
                'enddate'          => $enddate,
                'order_type'       => $order_type,
                'allocate_percent' => $allocate_percent,
                'updatedby'        => $this->session->userdata('user_id'),
                'updatedon'        => date('Y-m-d H:i:s'),

            ];

            $table = 'tb_allocate_ratio_batch';
            $whr   = [
                'id' => $id,
            ];
            $result = $this->common->updatetbledata($table, $res, $whr);

            log_error(UNIQLO_LOG_PREFIX . "Carrierratios updatecarrierratio outbound data: " . json_encode($result));

            echo json_encode($result);
        }
    }

    public function view($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Carrierratios|view inbound data: " . $id);

        $user_id            = $this->session->userdata('user_id');
        $data['user_id']    = $user_id;
        $data['page_title'] = $this->lang->line('trip_allocation_ratio');
        $data['sub_title']  = $this->lang->line('general_view');
        $where1             = [
            'id' => $id,
        ];

        $table1            = "tb_allocate_ratio_batch";
        $edit_data         = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_data'] = $edit_data;
        $data['vendor']    = $this->common->gettblrowdata(
            ['id' => $edit_data['carrier_id']],
            "id,name",
            "tb_vendors",
            0,
            0
        );

        /*log_error(
            UNIQLO_LOG_PREFIX .
            "Carrierratios|view outbound data for carrierratios/viewpincode: " . implode(', ', $data)
        );*/
        
        log_error(
            UNIQLO_LOG_PREFIX .
            "Carrierratios|view outbound data for carrierratios/viewpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("carrierratios/view", $data);
        $this->load->view("carrierratios/view", $data);
    }

    public function delete($id)
    {
        $table  = "tb_allocate_ratio_batch";
        $result = $this->Uniqlomodel->delete($id, $table);
        if ($result) {
            log_error(UNIQLO_LOG_PREFIX . "Carrierratios|delete outbound data: 1");

            echo "1";
        } else {
            log_error(UNIQLO_LOG_PREFIX . "Carrierratios|delete outbound data: 0");

            echo "0";
        }
    }

    public function checkduplicatedata()
    {
        $post_data            = $this->input->post();
        $result               = $this->Uniqlomodel->checkratiodata($post_data);
        $cnt                  = count($result);
        $sequence_no_found    = 0;
        $allocate_percent_sum = 0;
        $carrier_id_found     = 0;
        if ($cnt > 0) {
            foreach ($result as $value) {
                if ($value['sequence_no'] == $post_data['sequence_no']) {
                    $sequence_no_found = 1;
                }
                if ($value['carrier_id'] == $post_data['carrier_id']) {
                    $carrier_id_found = 1;
                }

                $allocate_percent_sum += $value['allocate_percent'];
            }

            $total_a_p = $allocate_percent_sum + $post_data['allocate_percent'];

            if ($carrier_id_found == 1) {
                $json_array = [
                    'status'     => 'Error',
                    'coloumn_id' => 'carrier_id',
                    'message'    => 'Carrier already existed for these dates',
                ];
            } elseif ($sequence_no_found == 1) {
                $json_array = [
                    'status'     => 'Error',
                    'coloumn_id' => 'sequence_no',
                    'message'    => 'sequence no already existed for these dates',
                ];
            } elseif ($carrier_id_found == 0 && $sequence_no_found == 0 && ($allocate_percent_sum == '100' || $allocate_percent_sum == '100.00')) {
                $json_array = [
                    'status'     => 'Error',
                    'coloumn_id' => 'allocate_percent',
                    'message'    => 'Allocation percentage is not available. Please check the old records for these dates',
                ];
            } elseif ($carrier_id_found == 0 && $sequence_no_found == 0 && $total_a_p > '100.00') {
                $total_available_a_p = 100 - $allocate_percent_sum;
                $message             = "Available allocation percentage is less than or equal to " . $total_available_a_p;
                $json_array          = [
                    'status'     => 'Error',
                    'coloumn_id' => 'allocate_percent',
                    'message'    => $message,
                ];
            } else {
                $json_array = [
                    'status' => 'Success',
                ];
            }
        } else {
            $json_array = [
                'status' => 'Success',
            ];
        }

        log_error(UNIQLO_LOG_PREFIX . "Carrierratios checkduplicatedata outbound data: " . json_encode($json_array));

        echo json_encode($json_array);
    }

    public function deleteById()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $tableName = $this->input->post('table');
            $idArray   = $this->input->post('deleteids');
            $this->common->deleteStatus($idArray, $tableName);
        }
    }

}
