<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class CipAuthorization extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model("common");
        $this->load->library(["cip","cipPortal"]);
    }

    public function updateAuthorizationKey():void {
        $this->cip->request_url = CIP_AUTHORIZATION_URL;
        $this->cip->updateAuthorizationKey();
    }

    public function generateCID() {
        $data = []; $status = 5; $cid = '';
        $post = $this->input->post(NULL, true);
        $isCipPortalCustomer = (int) $post['isCipPortalCustomer'];
        $data['entityName'] = $data['entityNameLocal']    = (string) $post['addrs_name'];
        $data['thoroughfare1']  = (string) $post['addrs_street'];
        $data['thoroughfare2']  = (string) $post['street_2'];
        $data['thoroughfare3']  = (string) $post['street_3'];
        $data['postcode']       = (string) $post['postal_code'];
        $data['plot']           = $post['house_number'] ? (string) $post['house_number'] : '1';
        $data['building']       = (string) $post['addrs_building'];
        $data['province']       = (string) $post['addrs_province'];
        $data['locality']       = $data['dependentLocality'] = (string) $post['addrs_city'];
        $data['countryIso2Code'] = "";
        $country  = (string) $post['addrs_country'];
        if ( !empty($country) ) {
            $sqlQuery = "SELECT country_code FROM tbl_country_master WHERE (country_code = ? OR country_name = ? ) AND status=1 ORDER BY id DESC LIMIT 1";
            $bindParams = [$country, $country];
            $countryInfo = $this->common->fetchRecordsByCustomQry($sqlQuery,$bindParams, false);
            if (!empty($countryInfo)) {
                $data['countryIso2Code'] = $countryInfo['country_code'];
            }
        }
        $lookupResponse = [];
        if ($isCipPortalCustomer === 0) {
            $lookupResponse = $this->cip->createLookupSuggesstions($data);
        }
        $lookUpCustomers = [];
        if ($lookupResponse && $lookupResponse['status'] === 1 && isset($lookupResponse['data']['results']) && !empty($lookupResponse['data']['results'])) {
            $matchingResults = $lookupResponse['data']['results'];
            foreach ($matchingResults as $customer) {
                $customer     = (object) $customer;
                $sqlQuery     = "SELECT p.id FROM tbl_party_master p WHERE p.`code` = ? UNION ALL SELECT c.id FROM tb_customers c WHERE c.`code` = ? UNION ALL SELECT v.id FROM tb_vendors v WHERE v.`code` = ?";
                $bindParams   = [$customer->cid, $customer->cid, $customer->cid];
                $customerInfo = $this->common->fetchRecordsByCustomQry($sqlQuery,$bindParams, false);
                if (empty($customerInfo)) {
                    $countryIso2Code = $customer->countryIso2Code;
                    $sqlQuery    = "SELECT country_name FROM tbl_country_master WHERE (country_code = ? OR country_name = ? ) AND status=1 ORDER BY id DESC LIMIT 1";
                    $bindParams  = [$countryIso2Code, $countryIso2Code];
                    $countryInfo = $this->common->fetchRecordsByCustomQry($sqlQuery,$bindParams, false);
                    $countryName = $countryInfo ? $countryInfo['country_name'] : $countryIso2Code;
                    $address = [
                        (string) $customer->plot,
                        (string) $customer->building,
                        (string) $customer->thoroughfare1,
                        (string) $customer->locality,
                        (string) $customer->province,
                        (string) $countryName,
                        (string) $customer->postcode,
                    ];
                    $address = array_filter($address);
                    $lookUpCustomers[] = [
                        'cid'       =>  $customer->cid,
                        'entityName'=>  $customer->entityName,
                        'address'=>  implode(', ', $address)
                    ];
                }
            }
        }
        if (empty($lookUpCustomers)) {
            $response = $this->cip->generateCIDinCIPPortal($data);
            $status = $response['status'];
            $cid    = $response['cid'];
        }
        $customers = $lookUpCustomers;
        echo json_encode(compact('status','cid','customers'));
    }

    public function generateCID_V1() {
        $data = []; $status = 5; $cid = '';
        $post = $this->input->post(NULL, true);
        $isCipPortalCustomer = (int) $post['isCipPortalCustomer'];
        $isDuplicateCustomer = (int) $post['isDuplicateCustomer'];
        $data['entityName'] = $data['entityNameLocal'] = (string) $post['addrs_name'];
        $data['thoroughfare1']  = (string) $post['addrs_street'];
        $data['thoroughfare2']  = (string) $post['street_2'];
        $data['thoroughfare3']  = (string) $post['street_3'];
        $data['postcode']       = (string) $post['postal_code'];
        $data['plot']           = $post['house_number'] ? (string) $post['house_number'] : '1';
        $data['building']       = (string) $post['addrs_building'];
        $data['province']       = (string) $post['addrs_province'];
        $data['locality']       = $data['dependentLocality'] = (string) $post['addrs_city'];
        $data['countryIso2Code'] = "";
        $country  = (string) $post['addrs_country'];
        if ( !empty($country) ) {
            $sqlQuery = "SELECT country_code FROM tbl_country_master WHERE (country_code = ? OR country_name = ? ) AND status=1 ORDER BY id DESC LIMIT 1";
            $bindParams = [$country, $country];
            $countryInfo = $this->common->fetchRecordsByCustomQry($sqlQuery,$bindParams, false);
            if (!empty($countryInfo)) {
                $data['countryIso2Code'] = $countryInfo['country_code'];
            }
        }
        $lookupResponse = [];
        if ($isCipPortalCustomer === 0) {
            $lookupResponse = $this->cipportal->createLookupSuggesstions($data);
        }
        $lookUpCustomers = [];
        if ($isDuplicateCustomer === 0 && $lookupResponse && $lookupResponse['status'] === 1 && isset($lookupResponse['data']['results']) && !empty($lookupResponse['data']['results'])) {
            $matchingResults = $lookupResponse['data']['results'];
            foreach ($matchingResults as $customer) {
                $customer = (object) $customer;
                $cid = $customer->externalId;
                $sqlQuery     = "SELECT p.id FROM tbl_party_master p WHERE p.`code` = ? UNION ALL SELECT c.id FROM tb_customers c WHERE c.`code` = ? UNION ALL SELECT v.id FROM tb_vendors v WHERE v.`code` = ?";
                $bindParams   = [$cid, $cid, $cid];
                $customerInfo = $this->common->fetchRecordsByCustomQry($sqlQuery,$bindParams, false);
                if (empty($customerInfo)) {
                    $countryIso2Code = $customer->countryIso2Code;
                    $sqlQuery    = "SELECT country_name FROM tbl_country_master WHERE (country_code = ? OR country_name = ? ) AND status=1 ORDER BY id DESC LIMIT 1";
                    $bindParams  = [$countryIso2Code, $countryIso2Code];
                    $countryInfo = $this->common->fetchRecordsByCustomQry($sqlQuery,$bindParams, false);
                    $countryName = $countryInfo ? $countryInfo['country_name'] : $countryIso2Code;
                    $address = [
                        (string) $customer->plot,
                        (string) $customer->building,
                        (string) $customer->thoroughfare1,
                        (string) $customer->locality,
                        (string) $customer->province,
                        (string) $countryName,
                        (string) $customer->postcode,
                    ];
                    $address = array_filter($address);
                    $lookUpCustomers[] = [
                        'cid'       =>  $cid,
                        'entityName'=>  $customer->addressee,
                        'address'=>  implode(', ', $address)
                    ];
                }
            }
        }
        $message = 'Unable to generate Customer. Please try again later.';
        $errorMessage = '';
        if (empty($lookUpCustomers)) {
            $response = $this->cipportal->generateCIDinCIPPortal($data);
            $status = $response['status'];
            $cid    = $response['cid'];
            $message = ($status === 6 && isset($response['message'])) ? $response['message'] : $message;
            $errorMessage = isset($response['message']) ? $response['message'] : '';
        }
        $customers = $lookUpCustomers;
        echo json_encode(compact('status','cid','customers','errorMessage','message'));
    }
}