<?php if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

class Consolidation extends CI_Controller
{

	/**
	 * Consolidation constructor.
	 *
	 * It checks for the user logged in or not
	 * and also loads all the models and libraries
	 */
	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('common');
		$this->load->model('Order');
		$this->load->model('consolidationmodel');
        if (!checkUrlAccessForUser('CONSOLIDATION')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index()
	{
		$data['page_title']    = $this->lang->line('menu_consolidation');
		$data['sub_title']     = "Rules";
		$company_code = $this->session->userdata('company_code');
		$consolidation_rule_id = $consolidation_rule_name = $consolidation_rule_basement = $consolidation_uom = '';
		$post = $whr = $list_val = array();
		$post1 = $this->input->post(NULL, TRUE);
		if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
			$post = $post1;
		}
		$whr = ['company_code' => $company_code, 'status' => '1'];
		if (!empty($post)) {
			if (isset($post['consolidation_rule_id']) && $post['consolidation_rule_id'] != "") {
				$whr['consolidation_id'] = $consolidation_rule_id = $post['consolidation_rule_id'];
			}
			if (isset($post['consolidation_rule_name']) && $post['consolidation_rule_name'] != "") {
				$whr['consolidation_name'] = $consolidation_rule_name = $post['consolidation_rule_name'];
			}
			if (isset($post['tariff_type']) && $post['tariff_type'] != "") {
				$whr['tariff_type'] = $consolidation_rule_basement = $post['tariff_type'];
			}
			if (isset($post['consolidation_uom']) && $post['consolidation_uom'] != "") {
				$whr['consolidation_uom'] = $consolidation_uom = $post['consolidation_uom'];
			}
			$getalldata = $this->common->gettbldata($whr, "id,consolidation_id,consolidation_name,tariff_type,consolidation_uom", "tb_consolidation_rules", 0, 0);
		} else {
			$getalldata = $this->common->gettbldata($whr, "id,consolidation_id,consolidation_name,tariff_type,consolidation_uom", "tb_consolidation_rules", 0, 0);
		}
		if (!empty($getalldata)) {
			foreach ($getalldata as $res) {
				$tariff_type = (($res['tariff_type'] == 0)  ? "SELL" : (($res['tariff_type'] == 1) ? "BUY" : ''));
				$list_val[] = [
					'id'                 => $res['id'],
					'consolidation_id'   => $res['consolidation_id'],
					'consolidation_name' => $res['consolidation_name'],
					'tariff_type' 		 => $tariff_type,
					'consolidation_uom'  => $res['consolidation_uom'],
				];
			}
		}

		$data['list_val']                    = $list_val;
		$data['consolidation_rule_id']       = $consolidation_rule_id;
		$data['consolidation_rule_name']     = $consolidation_rule_name;
		$data['consolidation_rule_basement'] = $consolidation_rule_basement;
		$data['consolidation_uom'] 			 = $consolidation_uom;
		$this->newtemplate->dashboard("consolidation/index", $data);
	}
	public function add()
	{
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$user_id = $this->session->userdata('user_id');
		$data['ref_names_arr'] = array();
		$data['company_code'] = $company_code;
		$data['branch_code'] = $branch_code;
		$data['user_id'] = $user_id;
		$data["page_title"] = $this->lang->line('menu_consolidation');
		$data["sub_title"] = $this->lang->line('general_add');
		$where1 = array('status' => 1, 'company_code' => $company_code);
		$getrefnums = $this->Order->getrefnums();
		if (!empty($getrefnums)) {
			foreach ($getrefnums as $refnums) {
				$data['ref_names_arr'][] = array('name' => htmlentities($refnums['name'], ENT_COMPAT, 'UTF-8'));
			}
		}
		//$this->newtemplate->dashboard("consolidation/add", $data);
		$this->load->view("consolidation/add", $data);
	}
	public function edit($id)
	{
		$data = $data['consolidationdata'] = $data['ref_names_arr'] = array();
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$data['company_code'] = $company_code;
		$data['branch_code'] = $branch_code;
		$data["page_title"] = $this->lang->line('menu_consolidation');
		$data["sub_title"] = $this->lang->line('general_edit');
		$getrefnums = $this->Order->getrefnums();
		if (!empty($getrefnums)) {
			foreach ($getrefnums as $refnums) {
				$data['ref_names_arr'][] = array('name' => htmlentities($refnums['name'], ENT_COMPAT, 'UTF-8'));
			}
		}
		$whr = array('id' => $id, 'status' => 1, 'company_code' => $company_code);
		$getconsolidationdata = $this->common->gettblrowdata($whr, '*', 'tb_consolidation_rules', 0, 0);
		if (!empty($getconsolidationdata)) {
			$data['consolidationdata'] = $getconsolidationdata;
		}
		if (($id > 0) && !empty($data['consolidationdata'])) {
			//$this->newtemplate->dashboard("consolidation/edit", $data);
			$this->load->view("consolidation/edit", $data);
		}
	}
	public function view($id)
	{
		$data = $data['consolidationdata'] = array();
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$data['company_code'] = $company_code;
		$data['branch_code'] = $branch_code;
		$data["page_title"] = $this->lang->line('menu_consolidation');
		$data["sub_title"] = $this->lang->line('general_view');
		$data['ref_names_arr'] = $this->Order->getrefnums();
		$whr = array('id' => $id, 'status' => 1, 'company_code' => $company_code);
		$getconsolidationdata = $this->common->gettblrowdata($whr, '*', 'tb_consolidation_rules', 0, 0);
		if (!empty($getconsolidationdata)) {
			$data['consolidationdata'] = $getconsolidationdata;
		}
		if (($id > 0) && !empty($data['consolidationdata'])) {
			//$this->newtemplate->dashboard("consolidation/view", $data);
			$this->load->view("consolidation/view", $data);
		}
	}
	public function save()
	{
		$data['status'] = 0;
		$consolidation_data = [];
		$post = $this->input->post(NULL, TRUE);
		$user_id = $this->session->userdata('user_id');
		$id = $post['consolidation_id'] ?? 0;
		$consolidation_data['consolidation_name'] = $post['consolidation_name'] ?? "";
		$consolidation_data['tariff_type'] = $post['consolidation_base'] ?? 0;
		$consolidation_data['company_code'] = $post['company_code'] ?? "";
		$consolidation_data['consolidation_uom'] = $post['consolidation_uom'] ?? "";
		$consolidation_data['branch_code'] = $post['branch_code'] ?? "";
		$consolidation_data['customer_cid'] = $post['customer_cid'] ?? 0;
		$consolidation_data['early_pickup'] = $post['early_pickup'] ?? 0;
		$consolidation_data['early_delivery'] = $post['early_delivery'] ?? 0;
		$consolidation_data['shipper_cid'] = $post['shipper_cid'] ?? 0;
		$consolidation_data['shipper_city'] = $post['shipper_city'] ?? 0;
		$consolidation_data['shipper_zipcode'] = $post['shipper_zipcode'] ?? 0;
		$consolidation_data['consignee_cid'] = $post['consignee_cid'] ?? 0;
		$consolidation_data['consignee_city'] = $post['consignee_city'] ?? 0;
		$consolidation_data['consignee_zipcode'] = $post['consignee_zipcode'] ?? 0;
		$consolidation_data['reference_1'] = $post['reference_1'] ?? 0;
		$consolidation_data['reference_1_val'] = $post['reference_1_val'] ?? "";
		if ($consolidation_data['reference_1'] == 0) {
			$consolidation_data['reference_1_val'] = "";
		}
		$consolidation_data['reference_2'] = $post['reference_2'] ?? 0;
		$consolidation_data['reference_2_val'] = $post['reference_2_val'] ?? "";
		if ($consolidation_data['reference_2'] == 0) {
			$consolidation_data['reference_2_val'] = "";
		}
		$consolidation_data['reference_3'] = $post['reference_3'] ?? 0;
		$consolidation_data['reference_3_val'] = $post['reference_3_val'] ?? "";
		if ($consolidation_data['reference_3'] == 0) {
			$consolidation_data['reference_3_val'] = "";
		}
		$consolidation_data['trip_no'] = $post['trip_no'] ?? 0;
		if ($id == 0) {
			$consolidation_data['consolidation_id '] = $this->generateid();
			$consolidation_data['user_id'] = $user_id;
			$consolidation_data['status'] = 1;
			$cr_id = $this->common->insertTableData("tb_consolidation_rules", $consolidation_data);
			if ($cr_id > 0) {
				$data['status'] = 1;
			}
		} else {
			$consolidation_data['user_id'] = $user_id;
			$update = $this->common->updatetbledata('tb_consolidation_rules', $consolidation_data, array(
				'id' => $id
			));
			if ($update) {
				$data['status'] = 1;
			}
		}
		echo json_encode($data);
	}
	public function generateid()
	{
		$year = date('y');
		$week = date('W');
		$gen_id = "";
		$getlatest_consolidation_id = $this->common->gettblrowdata(array(), "consolidation_id", "tb_consolidation_rules", 0, 0);
		if (!empty($getlatest_consolidation_id)) {
			$get_id = $getlatest_consolidation_id['consolidation_id'];
			$get_id_c = strlen($get_id);
			if ($get_id_c > 7) {
				$previous_weeknumber = substr($get_id, 4, 2);
				$get_id1 = substr($get_id, 6);
				$get_id2 = ltrim($get_id1, 0);
				if ($previous_weeknumber < $week) {
					$ii_d = '0001';
				} else {
					$i_id = $get_id2;
					$i_id++;
					$ii_d = str_pad($i_id, 4, '0', STR_PAD_LEFT);
				}
			} else {
				$ii_d = '0001';
			}
			$gen_id = "CR" . $year . $week . $ii_d;
			$check_consolidation_id = $this->common->gettblrowdata(array("consolidation_id" => $gen_id), "consolidation_id", "tb_consolidation_rules", 0, 0);
			if (!empty($check_consolidation_id)) {
				$iid = $ii_d;
				$iid++;
				$ii_d = str_pad($iid, 4, '0', STR_PAD_LEFT);
				$gen_id = "CR" . $year . $week . $ii_d;
			} else {
				$gen_id = $gen_id;
			}
		} else {
			$i_id = 1;
			$id1 = '000' . $i_id;
			$gen_id = "CR" . $year . $week . $id1;
		}
		return $gen_id;
	}
	public function deleteconsolidation($id)
	{
		if ($id != '0') {
			$check = $this->common->gettblrowdata(array('id' => $id), 'status', 'tb_consolidation_rules', 0, 0);
			if (!empty($check)) {
				$update = $this->common->updatetbledata('tb_consolidation_rules', array('status' => 0), array('id' => $id));
				if ($update) {
					echo "1";
				} else {
					echo "0";
				}
			} else {
				echo "0";
			}
		} else {
			echo "0";
		}
	}
	
	public function applyconsolidation()
	{
		$post = $this->input->post(NULL, TRUE);
		$status = 0;
		$consolidationdata = $charge_lines = $update_charges = $revenue =
		$filtered_orders = $selected_orderids  = [];
		$order_ids = $post['order_ids'] ?? [];
		$consolidation_id = $post['consolidation_id'] ?? 0;
		$getconsolidationdata = $this->common->gettblrowdata(array('id' => $consolidation_id), '*', 'tb_consolidation_rules', 0, 0);
		if (!empty($getconsolidationdata)) {
			$consolidationdata = $getconsolidationdata;
		}
		$tariff_type = $consolidationdata['tariff_type'] ?? 0;
		$uom = $consolidationdata['consolidation_uom'] ?? "";
		$consolidation_uom = "";
		if ($uom != "") {
			$consolidation_uom = strtoupper($uom);
		}
		$customer_cid = $consolidationdata['customer_cid'] ?? 0;
		$early_pickup = $consolidationdata['early_pickup'] ?? 0;
		$early_delivery = $consolidationdata['early_delivery'] ?? 0;
		$shipper_cid = $consolidationdata['shipper_cid'] ?? 0;
		$shipper_city = $consolidationdata['shipper_city'] ?? 0;
		$shipper_postalcode = $consolidationdata['shipper_zipcode'] ?? 0;
		$consignee_cid = $consolidationdata['consignee_cid'] ?? 0;
		$consignee_city = $consolidationdata['consignee_city'] ?? 0;
		$consignee_postalcode = $consolidationdata['consignee_zipcode'] ?? 0;
		$reference_1 = $consolidationdata['reference_1'] ?? 0;
		$reference_1_val = $consolidationdata['reference_1_val'] ?? "";
		$reference_2 = $consolidationdata['reference_2'] ?? 0;
		$reference_2_val = $consolidationdata['reference_2_val'] ?? "";
		$reference_3 = $consolidationdata['reference_3'] ?? 0;
		$reference_3_val = $consolidationdata['reference_3_val'] ?? "";
		$trip_no = $consolidationdata['trip_no'] ?? 0;
		$reference_codes = array();
		if ($reference_1 > 0 && $reference_1_val != "") {
			$reference_codes[] = $reference_1_val;
		}
		if ($reference_2 > 0 && $reference_2_val != "") {
			$reference_codes[] = $reference_2_val;
		}
		if ($reference_3 > 0 && $reference_3_val != "") {
			$reference_codes[] = $reference_3_val;
		}

		$order_key = $order['pickup_datetime'] = $order['delivery_datetime'] = $order['pickup_city'] = $order['delivery_city']
			= $order['pickup_pincode'] = $order['delivery_pincode'] = $order['customer_id']
			= $order['pickup_custid'] = $order['drop_custid'] = $order['shipmentid'] = null;
		// $this->db->query('SET SESSION  group_concat_max_len=10240');
		// $getordid = $this->db->query("SELECT GROUP_CONCAT(id) AS id FROM (
		// 	SELECT id FROM `tb_orders`
		//  where company_code='RUKN' order by id desc limit 1000) AS id");
		// if ($getordid->num_rows() > 0) {
		// 	$order_ids = $getordid->result_array();
		// }
		// $order_ids = explode(",", $order_ids[0]['id']);
		$company_code = $this->session->userdata("company_code");
		$whr = ['company_code' => $company_code, 'status' => 1];
		$geotierids = [];
		$getgeotierids = $this->common->gettbldata($whr, 'id,geo_tier_id,uom1,geo_hierarchy', 'tb_geo_tier', 0, 0);
		if (!empty($getgeotierids)) {
			foreach ($getgeotierids as $geotierid) {
				$index = $geotierid['geo_tier_id'];
				$geotierids[$index] =  ['id' => $geotierid['id'],'uom' => $geotierid['uom1'], 'geo_hierarchy' => $geotierid['geo_hierarchy']];
			}
		}
		$data['orders'] =  [];
		if (!empty($geotierids)) {
		$status = 1;
		$order_details = $this->consolidationmodel->getOrderDetails("o.id,DATE_FORMAT(pickup_datetime,'%Y-%m-%d') as pickup_datetime,
        DATE_FORMAT(delivery_datetime ,'%Y-%m-%d') as delivery_datetime,pickup_country,delivery_country,
        pickup_city,delivery_city,pickup_pincode,delivery_pincode,customer_id,pickup_custid,
        drop_custid,shipmentid,r.order_id, r.amount,c.id as chargeid,c.revenue_id,c.rate_id,c.amount as chargeamt,
        c.vat_percentage,c.vat_amount,c.total_amount,c.source_created,IFNULL(b.status,1) as status", $order_ids, $tariff_type);
		if (!empty($order_details)) {
			$status = 2;
			for ($i = 0; $i < count($order_details); $i++) {
				if ($order_details[$i]['status'] == 1) {
					$index = $selected_orderids[] = $order_details[$i]['id'];
					$data['orders'][$index] = array(
						'id' => $order_details[$i]['id'],
						'pickup_datetime' => $order_details[$i]['pickup_datetime'],
						'delivery_datetime' => $order_details[$i]['delivery_datetime'],
						'pickup_city' => $order_details[$i]['pickup_city'],
						'delivery_city' => $order_details[$i]['delivery_city'],
						'pickup_pincode' => $order_details[$i]['pickup_pincode'],
						'delivery_pincode' => $order_details[$i]['delivery_pincode'],
						'customer_id' => $order_details[$i]['customer_id'],
						'pickup_custid' => $order_details[$i]['pickup_custid'],
						'drop_custid' => $order_details[$i]['drop_custid'],
						'shipmentid' => $order_details[$i]['shipmentid'],
						'reference_id' => "",
						'total_uom' => 0,
						'revenue_id' => $order_details[$i]['revenue_id'],
						'charge_id' => $order_details[$i]['chargeid'],
						'rate_id' => $order_details[$i]['rate_id']
					);
					if (isset($geotierids[$order_details[$i]['rate_id']])) {
						$status = 3;
						$charge_lines[] = [
							'order_id' => $index,
							'pickup_country' => $order_details[$i]['pickup_country'],
							'delivery_country' => $order_details[$i]['delivery_country'],
							'pickup_city' => $order_details[$i]['pickup_city'],
							'delivery_city' => $order_details[$i]['delivery_city'],
							'pickup_pincode' => $order_details[$i]['pickup_pincode'],
							'delivery_pincode' => $order_details[$i]['delivery_pincode'],
							'revenue_id' => $order_details[$i]['revenue_id'],
							'amount' => $order_details[$i]['amount'],
							'chargeid' => $order_details[$i]['chargeid'],
							'rate_id' => $order_details[$i]['rate_id'],
							'geotier_id' => $geotierids[$order_details[$i]['rate_id']]['id'],
							'uom' => $geotierids[$order_details[$i]['rate_id']]['uom'],
							'geo_hierarchy' => $geotierids[$order_details[$i]['rate_id']]['geo_hierarchy'],
							'chargeamt' => $order_details[$i]['chargeamt'],
							'vat_percentage' => $order_details[$i]['vat_percentage'],
							'vat_amount' => $order_details[$i]['vat_amount'],
							'total_amount' => $order_details[$i]['total_amount']
						];
					}
				}
			}
		$data['orders']['charge_lines'] = $charge_lines;
		$check_reference_string = "";
		if (!empty($reference_codes) && !empty($selected_orderids)) {
			$get_order_references = $this->consolidationmodel->get_order_references($selected_orderids, $reference_codes);
			if (!empty($get_order_references)){
			$status = 4;
			for ($i = 0; $i < count($get_order_references); $i++) {
				$index = $get_order_references[$i]['order_id'];
				$data['orders'][$index]['reference_id'] = $get_order_references[$i]['reference_id'];
			}
		  }
			sort($reference_codes);
			$check_reference_string = implode("??", $reference_codes);
		}
		switch ($uom) {
			case 'Quantity':
				$select_uom = "order_id,sum(cd.quantity) as total_uom";
				break;
			case 'Volume':
				$select_uom = "order_id,sum(cd.second_volume) as total_uom";
				break;
			case 'Weight':
				$select_uom = "order_id,sum(cd.second_weight) as total_uom";
				break;
			case 'Actual Volume':
				$select_uom = "order_id,sum(cd.volume) as total_uom";
				break;
			case 'Actual Weight':
				$select_uom = "order_id,sum(cd.weight) as total_uom";
				break;
			case 'Volumetric Weight':
				$select_uom = "order_id,sum(cd.volumetric_weight) as total_uom";
				break;
			default:
				$select_uom = "";
		}
		if ($select_uom != "" && !empty($selected_orderids)) {
			$get_cargo_uom = $this->consolidationmodel->get_cargo_uom($selected_orderids, $select_uom);
			if (!empty($get_cargo_uom)) {
			$status = 5;
			for ($i = 0; $i < count($get_cargo_uom); $i++) {
				$index = $get_cargo_uom[$i]['order_id'];
				$data['orders'][$index]['total_uom'] = $get_cargo_uom[$i]['total_uom'];
			}
		 }
		}
		if (!empty($data['orders'])) {
		foreach ($data['orders'] as  $order) {
			if (isset($order['id'])) {
				$index = $order['id'];
				$order_key = "";
				if ($customer_cid == 1) {
					$order_key .= $order['customer_id'] . "???";
				}
				if ($early_pickup == 1) {
					$order_key .= $order['pickup_datetime'] . "???";
				}
				if ($early_delivery == 1) {
					$order_key .= $order['delivery_datetime'] . "???";
				}
				if ($shipper_cid == 1) {
					$order_key .= $order['pickup_custid'] . "???";
				}
				if ($shipper_city == 1) {
					$order_key .= $order['pickup_city'] . "???";
				}
				if ($shipper_postalcode == 1) {
					$order_key .= $order['pickup_pincode'] . "???";
				}
				if ($consignee_cid == 1) {
					$order_key .= $order['drop_custid'] . "???";
				}
				if ($consignee_city == 1) {
					$order_key .= $order['delivery_city'] . "???";
				}
				if ($consignee_postalcode == 1) {
					$order_key .= $order['delivery_pincode'] . "???";
				}
				if ($trip_no == 1) {
					$order_key .= $order['shipmentid'] . "???";
				}
				if ($check_reference_string != "") {
					$order_key .= $check_reference_string;
				}
				$order_details = [
					'id' => $order['id'],
					'pickup_datetime' => $order['pickup_datetime'],
					'delivery_datetime' => $order['delivery_datetime'],
					'pickup_city' => $order['pickup_city'],
					'delivery_city' => $order['delivery_city'],
					'pickup_pincode' => $order['pickup_pincode'],
					'delivery_pincode' => $order['delivery_pincode'],
					'customer_id' => $order['customer_id'],
					'pickup_custid' => $order['pickup_custid'],
					'drop_custid' => $order['drop_custid'],
					'shipmentid' => $order['shipmentid'],
					'reference_id' => $order['reference_id'],
					'total_uom' => $order['total_uom'],
					'revenue_id' => $order['revenue_id'],
					'charge_id' => $order['charge_id'],
					'rate_id' => $order['rate_id']
				];
				if ($check_reference_string != "") {
					if ($check_reference_string == $order['reference_id']) {
						$filtered_orders[$order_key][] = $order_details;
					}
				} else {
					$filtered_orders[$order_key][] = $order_details;
				}
			}
		}
	}
		if (!empty($filtered_orders)) {
			$status = 6;
			$grouped_orderids = [];
			$i = 1;
			foreach ($filtered_orders as  $eachgroup) {
				if (count($eachgroup) > 1) {
					$group_uom_sum = array_sum(array_column($eachgroup, 'total_uom'));
					foreach ($eachgroup as  $each) {
						$index = $each['id'];
						$data['orders'][$index]['group_no'] = $i;
						$data['orders'][$index]['group_uom_sum'] = $group_uom_sum;
						$grouped_orderids[] = $each['id'];
					}
					$i++;
				}
			}
		}
		if (!empty($data['orders']['charge_lines']) && !empty($grouped_orderids)) {
			$status = 7;
			foreach ($data['orders']['charge_lines'] as $eachline) {
				if (in_array($eachline['order_id'], $grouped_orderids) && ($eachline['uom'] == $consolidation_uom)) {
					if ($eachline['geo_hierarchy'] == "COUNTRY") {
						$geo_from = $eachline['pickup_country'];
						$geo_to = $eachline['delivery_country'];
					} else if ($eachline['geo_hierarchy'] == "CITY") {
						$geo_from = $eachline['pickup_city'];
						$geo_to = $eachline['delivery_city'];
					} else if ($eachline['geo_hierarchy'] == "POSTAL CODE") {
						$geo_from = $eachline['pickup_pincode'];
						$geo_to = $eachline['delivery_pincode'];
					}
					$uom = $data['orders'][$eachline['order_id']]['group_uom_sum'];
					$tier_id = $eachline['geotier_id'];
					$cost = $this->consolidationmodel->getgeotierunitcharges($tier_id, $geo_from, $geo_to, $uom);
					if ($cost > 0) {
						$status = 8;
						$total_uom = $data['orders'][$eachline['order_id']]['total_uom'];
						$newcost = $total_uom * $cost;
						$vat_amount = 0;
						if ($eachline['vat_percentage'] > 0) {
							$vat_amount = ($newcost * $eachline['vat_percentage']) / 100;
						}
						$total_amount = $newcost + $vat_amount;
						$previous_total = $eachline['total_amount'];
						$difference = $total_amount - $previous_total;
						$revenue[$eachline['revenue_id']][] = $difference;
						$update_charges[] = array(
							'id' => $eachline['chargeid'],
							'amount' => $newcost,
							'vat_amount' => $vat_amount,
							'total_amount' => $total_amount,
							'local_amount' => $newcost,
							'local_vat_amount' => $vat_amount,
							'local_total_amount' => $total_amount
						);
					}
				}
			}
		}
		if (!empty($revenue) && $status == 8) {
			$revenue_ids = array();
			$qry = "UPDATE tb_reveneus SET  amount = CASE";
			foreach ($revenue as $key => $value) {
				$amount = array_sum($value);
				$qry .= " WHEN id = $key THEN amount + $amount ";
				$revenue_ids[] = $key;
			}
			$revenue_ids_string = implode(',', $revenue_ids);
			$qry .= " ELSE amount END WHERE id IN ($revenue_ids_string)";
			if (!empty($revenue_ids)) {
				$this->db->query($qry);
				$status = 9;
			}
		}
		if (!empty($update_charges) && $status == 9) {
			$this->db->update_batch('tb_charges', $update_charges, 'id');
			$status = 10;
		}
	}
}
		echo $status;
	}
	
	public function validateconsolidation()
	{
		$post = $this->input->post(NULL, TRUE);
		$status = 0;
		$order_ids = $post['order_ids'] ?? array();
		$branches = array();
		if(!empty($order_ids)){
			$select  = "id,shift_id,branch_code";
            $getdata = $this->common->gettbldata_where_in(['status !=' => 0], ['col' => 'id', 'arr' => $order_ids], $select, 'tb_orders', 0, 0);
            if(!empty($getdata)){
				foreach($getdata as $data){
                     if($data['shift_id'] == 0){
						$status = 1;
					 }
					 if (!in_array($data['branch_code'], $branches)) {
						$branches[] =  $data['branch_code'];
						}
				}
			}
			if(count($branches) > 1){
				$status = 2;
			  }
		}
		echo $status;
	}
}
