<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";

class Containerweeklyreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->model('aureportsmodel');
        $this->load->library(['email', 'envelope']);
    }

    public function index()
    {
        $whr = ['o.status !=' => 0, 'o.company_code' => 'AUKN'];
        $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = date('Y-m-01');
        $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = date('Y-m-d');
        $order_res = $this->aureportsmodel->getcontainers($whr);
        if (!empty($order_res)) {
            $file_name = $this->excelExport($order_res);
            if (!empty($file_name)) {
                $this->sendmail($file_name);
            }
        }
    }

    public function excelExport($data)
    {
        $fileName = '';

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:AH1')
            ->applyFromArray([
                'fill' => [
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => [
                        'rgb' => '0c3b81'
                    ]
                ]
            ]);
        $styleArray = [
            'font' => [
                'bold' => true,
                'color' => ['rgb' => 'FFFFFF'],
                'size' => 10,
                'name' => 'Verdana'
            ]
        ];
        if (!empty($data)) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', ' Container Number');
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1')
                ->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Total Cartons');
            $objPHPExcel->getActiveSheet()
                ->getStyle('B1')
                ->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Date');
            $objPHPExcel->getActiveSheet()
                ->getStyle('C1')
                ->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'KN Origin Reference');
            $objPHPExcel->getActiveSheet()
                ->getStyle('D1')
                ->applyFromArray($styleArray);


            $rowCount = 2;
            if (count($data) > 0) {
                foreach ($data as $getdata) {
                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $getdata['container_no']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $getdata['total_cartons']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, date("Y-m-d", strtotime($getdata['createdon'])));
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $getdata['kn_origin_ref']);
                    $rowCount++;
                }
            }
            $fileName = 'Container-Report-' . date("YmdHis") . '.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save(str_replace(__FILE__,'assets/aucustreports/'.$fileName,__FILE__));

        }

        return $fileName;

    }

    public function sendmail($attachment)
    {
        $this->envelope->from(SVKONEKT_EMAIL, 'svkonekt');
        $base_url = base_url();
        $rec_mail = $cc_mail = [];
        if (SYS_TYPE == 'TMS') {
            $rec_mail = ["enes.sadinlija@Kuehne-Nagel.com", "support@auroadlogistics.zendesk.com", "jfoster@consortiumclemenger.com.au"];
            $cc_mail = ["daniel.grote@kuehne-nagel.com", "ivan.feng@kuehne-nagel.com", "external.shweta.chinchanikar@kuehne-nagel.com"];
        } else {
            $rec_mail = ["external.shweta.chinchanikar@kuehne-nagel.com"];
        }
        if (!empty($rec_mail)) {
            $this->envelope->to($rec_mail);
            $sub = "SRG Weekly Container Report";
            $message = "Hi All,<br>";
            $message .= "Rolling SRG Weekly eTN container report - " . date('d-M') . "<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
            if (!empty($cc_mail)) {
                $this->envelope->cc($cc_mail);
            }
            $this->envelope->subject($sub);
            $this->envelope->set_mailtype("html");
            $this->envelope->message($message);
            $epodpath = sprintf('%s/assets/aucustreports/%s', FCPATH, $attachment);
            $this->envelope->attach($epodpath);

            if (!$this->envelope->send()) {
                log_message("error", $this->envelope->print_debugger());
            }

            $this->envelope->clear(true);
        }
    }

}
