<?php if ( ! defined( 'BASEPATH' ) ) {
	exit( 'No direct script access allowed' );
}

class Countries extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if ( $this->session->userdata( 'user_id' ) == '' ) {
			redirect( 'login' );
		}
		$this->load->library( 'form_validation' );
		$this->load->model( 'common' );
		$this->load->helper( 'generic' );
        if (!checkUrlAccessForUser('COUNTRIES')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index() {
		$data['page_title'] = $this->lang->line( 'countries' );
		$data['sub_title']  = $this->lang->line( 'countries' );
		//$where = array('status'=>1);
		$where = array();
		if ( $this->input->post( 'country_name' ) ) {
			$where['country_name'] = $this->input->post( 'country_name' );
		}
		if ( $this->input->post( 'country_code' ) ) {
			$where['country_code'] = $this->input->post( 'country_code' );
		}
		$data['countries'] = $this->common->gettbldata( $where, '*', 'tbl_country_master', 0, 0 );
		$this->newtemplate->dashboard( "countries/index", $data );
	}

	public function checkCountryCode( $country_code ) {
		if ( empty( $country_code ) ) {
			$this->form_validation->set_message( 'checkCountryCode', 'Country Code  Required' );

			return FALSE;
		} else {
			$id    = $this->uri->segment( 3 );
			$where = array( 'country_code' => $country_code );
			if ( $id ) {
				$where['id !='] = $id;
			}
			$countryCode = $this->common->gettblrowdata( $where, 'country_code', 'tbl_country_master', 0, 0 );
			if ( empty( $countryCode ) ) {
				return TRUE;
			} else {
				$this->form_validation->set_message( 'checkCountryCode', "Already this Country Code existed" );

				return FALSE;
			}
		}
	}

	public function checkCountryName( $country_name ) {
		if ( empty( $country_name ) ) {
			$this->form_validation->set_message( 'checkCountryName', 'Country Name  Required' );

			return FALSE;
		} else {
			$id    = $this->uri->segment( 3 );
			$where = array( 'country_name' => $country_name );
			if ( $id ) {
				$where['id !='] = $id;
			}
			$country = $this->common->gettblrowdata( $where, 'country_name', 'tbl_country_master', 0, 0 );
			if ( empty( $country ) ) {
				return TRUE;
			} else {
				$this->form_validation->set_message( 'checkCountryName', "Already this Country existed" );

				return FALSE;
			}
		}
	}

	public function add() {
		$data['page_title'] = $this->lang->line( 'countries' );
		$data['sub_title']  = $this->lang->line( 'countries' );
		/*$company_code         = $this->session->userdata( 'company_code' );
		$branch_code          = $this->session->userdata( 'branch_code' );
		$data['company_code'] = $company_code;
		$data['branch_code']  = $branch_code;*/
		$post = array();
        $post = $this->input->post(NULL,TRUE);
		if ( !empty($post) ) {

			$this->form_validation->set_rules( 'country_name', 'country name', 'required|callback_checkCountryName' );
			$this->form_validation->set_rules( 'country_code', 'country Code', 'required|callback_checkCountryCode' );
			if ( $this->form_validation->run() == FALSE ) {
				$data['error']['country_name'] = form_error( 'country_name' );
				$data['error']['country_code'] = form_error( 'country_code' );
				$this->form_validation->set_error_delimiters( '<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>' );
				$this->newtemplate->dashboard( 'countries/add', $data );
			} else {
				$array['country_name']           = $this->input->post( 'country_name',true );
				$array['country_code']           = $this->input->post( 'country_code',true );
				$array['currency']               = $this->input->post( 'currency',true );
				$array['cntry_timezone']         = $this->input->post( 'cntry_timezone',true );
				$array['cntry_hrs']              = $this->input->post( 'cntry_hrs',true );
				$array['phone_code']             = $this->input->post( 'phone_code',true );
				$array['lang_code']              = $this->input->post( 'lang_code',true );
				$array['annual_shipment_target'] = (!empty($post['annual_shipment_target']))?$post['annual_shipment_target']:0;
				$array['annual_gp_target']       = isset( $post['annual_gp_target'] ) ?  $post['annual_gp_target'] : 0;
				$array['shipment_gp']            = isset( $post['shipment_gp'] ) ?  $post['shipment_gp']  : 0;
				$array['updated_at']             = date( 'Y-m-d H:i:s' );
				$array['status']                 = $this->input->post( 'status',true );
				$array['user_id']                = $this->session->userdata( 'user_id' );
				$array['created_at'] = date( 'Y-m-d H:i:s' );
				$this->common->insertTableData( 'tbl_country_master', $array );
				redirect( 'countries' );
			}
		} else {
			$this->newtemplate->dashboard( 'countries/add', $data );
		}
	}

	public function edit( $id ) {
		$data['page_title'] = $this->lang->line( 'countries' );
		$data['sub_title']  = $this->lang->line( 'countries' );
		$data['country']    = $this->common->gettblrowdata( array( 'id' => $id ), 'id, country_name, country_code, user_id, currency, cntry_timezone, cntry_hrs, phone_code, lang_code, annual_shipment_target, annual_gp_target, shipment_gp, status, created_at', 'tbl_country_master', 0, 0 );

		if ( isset( $data['country']['id'] ) ) {
			$post = array();
			$post = $this->input->post(NULL,TRUE);
			if ( !empty($post) ) {
				
				$this->form_validation->set_rules( 'country_name', 'country name', 'required|callback_checkCountryName' );
				$this->form_validation->set_rules( 'country_code', 'country Code', 'required|callback_checkCountryCode' );
				if ( $this->form_validation->run() == FALSE ) {
					$data['error']['country_name'] = form_error( 'country_name' );
					$data['error']['country_code'] = form_error( 'country_code' );
					$this->form_validation->set_error_delimiters( '<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>' );
					$this->newtemplate->dashboard( 'countries/edit', $data );
				} else {
					$array['country_name']           = $this->input->post( 'country_name',true );
					$array['country_code']           = $this->input->post( 'country_code',true );
					$array['currency']               = $this->input->post( 'currency',true );
					$array['cntry_timezone']         = $this->input->post( 'cntry_timezone',true );
					$array['cntry_hrs']              = $this->input->post( 'cntry_hrs',true );
					$array['phone_code']             = $this->input->post( 'phone_code',true );
					$array['lang_code']              = $this->input->post( 'lang_code',true );
					$array['annual_shipment_target'] = (!empty($post['annual_shipment_target']))?$post['annual_shipment_target']:0;
					$array['annual_gp_target']       = isset( $post['annual_gp_target'] ) ? $post['annual_gp_target']: 0;
					$array['shipment_gp']            = isset($post['shipment_gp']) ? $post['shipment_gp'] : 0;
					$array['updated_at']             = date( 'Y-m-d H:i:s' );
					$array['user_id']                = $this->session->userdata( 'user_id' );
					$array['status']                 = $this->input->post( 'status',true );
					$this->common->updatetbledata( 'tbl_country_master', $array, array( 'id' => $id ) );
					redirect( 'countries' );
				}
			} else {
				$this->newtemplate->dashboard( 'countries/edit', $data );
			}
		} else {
			show_error( 'The Country you are trying to Edit does not exist.' );
		}
	}

	public function deleteCountry( $id ) {
		if ( $id != '' || $id != 0 ) {
			$chk = $this->common->gettblrowdata( array( 'id' => $id ), 'id', 'tbl_country_master', 0, 0 );
			if ( $chk ) {
				$upd = $this->common->updatetbledata( 'tbl_country_master', array( 'status' => 0 ), array( 'id' => $id ) );
				if ( $upd ) {
					echo "1";
				} else {
					echo "0";
				}
			} else {
				echo "0";
			}
		}
	}

	public function view( $id ) {
		$data['page_title'] = $this->lang->line( 'countries' );
		$data['sub_title']  = $this->lang->line( 'countries' );
		$data['country']    = $this->common->gettblrowdata( array( 'id' => $id ), 'id, country_name, country_code, user_id, currency, cntry_timezone, cntry_hrs, phone_code, lang_code, annual_shipment_target, annual_gp_target, shipment_gp, status, created_at', 'tbl_country_master', 0, 0 );
		$this->newtemplate->dashboard( 'countries/view', $data );
	}

}

