<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";
class Custapprovalexcel extends CI_Controller
{

	public function __Construct()
	{
		parent::__Construct();
		$this->load->library('session');
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('common');
		$this->load->model('Order');
		$this->load->model('truckwaybillmodel');
	}
	public function index($invoice)
	{
		ini_set('max_execution_time', 300);
		$data =  array();
		require 'vendor/autoload.php';
		$zonecode = $this->session->userdata("usr_tzone");
		$curtz = $zonecode['timezone'];
		$add_info = array();
		$orderinfo = $orders_data = array();
		$company_code = $this->session->userdata('company_code');
		$recipient_code = "";
		$invoiceno = 0;
		if ($invoice != '') {
			$where = array('id' => $invoice);
			$invoiceinfo = $this->common->gettblrowdata($where, 'invoice_no,invoice_date,acon_code,customer_code,branch_code', 'tbl_bills', 0, 0);
			if (!empty($invoiceinfo)) {
				$add_info['invoice_no'] = $invoiceno = $invoiceinfo['invoice_no'];
				$add_info['invoice_date'] = date("d.m.Y", strtotime($invoiceinfo['invoice_date']));
				$add_info['customer_code'] = $invoiceinfo['customer_code'];
				$add_info['acon_code'] = $invoiceinfo['acon_code'];
				$branchcode = $invoiceinfo['branch_code'];
				$where = array('bill_id' => $invoice, 'type' => 0, 'status' => 1);
				$reveninfo = $this->common->gettbldata($where, '*', 'tb_reveneus', 0, 0);
				if (!empty($reveninfo)) {
					foreach ($reveninfo as $eachreveninfo) {
						$order_id = "";
						$revenue_id = $eachreveninfo['id'];
						$recipient_code = $eachreveninfo['recipient_code'];
						$order_id = $eachreveninfo['order_id'];
						$rev_debtor_jfr = $eachreveninfo['debtor_jfr'];
						$rev_bu_jfr = $eachreveninfo['bu_jfr'];
						$rev_exchange_rate = $eachreveninfo['exchange_rate'];
						if ($rev_exchange_rate == 0) {
							$rev_exchange_rate = "";
						}
						$rev_foreign_currency = $eachreveninfo['foreign_currency'];
						$rev_invoiceno = $eachreveninfo['invoice_number'];
						$rev_invoicedate = $eachreveninfo['invoice_date'];
						if ($rev_invoicedate != "") {
							$rev_invoicedate = date("d.m.Y", strtotime($rev_invoicedate));
						}
						$rev_creditnote = $eachreveninfo['credit_note_number'];
						$invoice_creation_date = $eachreveninfo['invoice_creation_date'];
						$invoice_receivdon_date = $eachreveninfo['invoice_receivdon_date'];
						if ($invoice_receivdon_date == "0000-00-00 00:00:00") {
							$invoice_receivdon_date = "";
						}
						if ($invoice_creation_date != "") {
							$invoice_creation_date = date("d.m.Y H:i", strtotime($invoice_creation_date));
						}
						if ($invoice_receivdon_date != "") {
							$invoice_receivdon_date = date("d.m.Y H:i", strtotime($invoice_receivdon_date));
						}
						$invoice_status = $eachreveninfo['invoice_status'];
						if ($invoice_status == 1) {
							$invoice_status = "Ready to Invoiced";
						} else {
							$invoice_status = "Billed";
						}
						$getcostcharges = $this->get_cost_charges($order_id, $invoice);
						$getcharges = $this->getcharges($revenue_id);
						if ($order_id != "") {
							$chkorder = $this->Order->getordertoedit($order_id);
							if ($chkorder->num_rows() > 0) {
								$customer_details = $payer_details = $drop_details = $shipper_details = array('id' => "", 'name' => "", 'phone' => "", 'email' => "", 'fax' => "", 'code' => "", 'street' => "", 'state' => "", 'city' => "", 'country' => "", 'pincode' => "", 'acon' => "", 'kn_login' => "", 'vat_reg_no' => "", 'tax_payer_no' => "", 'contract_no' => "", 'contract_date' => "");
								$inco_term = $delivery_term =  $delivery_note = $delivery_inst = $pickup_inst = $purchase_order = "";
								$gene_order_id = $chkorder->row()->order_id;
								$ordwhere = array("order_row_id" => $order_id);
								$inco_term = $chkorder->row()->incoterm;
								$deliveryterm = $chkorder->row()->delivery_term;
								$where = array("term_id" => $deliveryterm);
								$delivery_incoterms = $this->common->gettblrowdata($where, "name", "tb_delivery_terms", 0, 0);
								if (!empty($delivery_incoterms)) {
									$delivery_term = $delivery_incoterms['name'];
								}
								$service = $chkorder->row()->service;
								$service_name = "";
								if ($service > 0) {
									$getservice = $this->common->gettblrowdata(array("id" => $service, "status" => 1), "name", "tb_service_master", 0, 0);
									if (!empty($getservice)) {
										$service_name = $getservice['name'];
									}
								}
								$getcargodetails = $this->getcargodetails($order_id);
								$notify_party = $this->truckwaybillmodel->notify_party($gene_order_id);
								$notify_address['name'] = "";
								if ($notify_party->num_rows() > 0) {
									$notify_address['name'] = $notify_party->row()->name;
								}
								$department_code = $chkorder->row()->department_code;
							}
							$pickup_datetime = $chkorder->row()->pickup_datetime;
							$delivery_datetime = $chkorder->row()->delivery_datetime;
							$getactual = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
							$pickup_datetime = date("d.m.Y H:i", strtotime($getactual['datetime']));
							$getactual = getdatetimebytimezone($curtz, $delivery_datetime, DFLT_TZ);
							$delivery_datetime = date("d.m.Y H:i", strtotime($getactual['datetime']));

							$get_references = $this->truckwaybillmodel->getorderreferences($order_id);
							$ref_1_name = $ref_1_description = $ref_1_value = $ref_2_name = $ref_2_description = $ref_2_value = $ref_3_name = $ref_3_description = $ref_3_value = $ref_4_name = $ref_4_description = $ref_4_value = $ref_5_name = $ref_5_description = $ref_5_value = "";
							if (!empty($get_references)) {
								$i = 1;
								foreach ($get_references as $ref) {
									$ref_id = $ref['reference_id'];
									if (!in_array($ref_id, array('ORD_DLVINST', 'ORD_PIKINST', 'DQ', 'PO'))) {
										if ($i == 1) {
											$ref_1_name = $ref_id;
											$ref_1_description = $ref['description'];
											$ref_1_value = $ref['ref_value'];
										} else if ($i == 2) {
											$ref_2_name = $ref_id;
											$ref_2_description = $ref['description'];
											$ref_2_value = $ref['ref_value'];
										} else if ($i == 3) {
											$ref_3_name = $ref_id;
											$ref_3_description = $ref['description'];
											$ref_3_value = $ref['ref_value'];
										} else if ($i == 4) {
											$ref_4_name = $ref_id;
											$ref_4_description = $ref['description'];
											$ref_4_value = $ref['ref_value'];
										} else if ($i == 5) {
											$ref_5_name = $ref_id;
											$ref_5_description = $ref['description'];
											$ref_5_value = $ref['ref_value'];
										}
										$i++;
									}
									if ($ref_id == 'DQ') {
										$delivery_note = $ref['ref_value'];
									}
									if ($ref_id == 'PO') {
										$purchase_order = $ref['ref_value'];
									}
									if ($ref_id == 'ORD_DLVINST') {
										$delivery_inst = $ref['ref_value'];
									}
									if ($ref_id == 'ORD_PIKINST') {
										$pickup_inst = $ref['ref_value'];
									}
								}
							}
							$getvasdetails = $this->truckwaybillmodel->getvasdetails($order_id);
							$vas_1_name = $vas_1_quantity = $vas_2_name = $vas_2_quantity = $vas_3_name = $vas_3_quantity = $vas_4_name = $vas_4_quantity = $vas_5_name = $vas_5_quantity = "";
							if (!empty($getvasdetails)) {
								$v = 1;
								foreach ($getvasdetails as $vas) {
									if ($v == 1) {
										$vas_1_name = $vas['vas_name'];
										$vas_1_quantity = $vas['quantity'];
									} else if ($v == 2) {
										$vas_2_name = $vas['vas_name'];
										$vas_2_quantity = $vas['quantity'];
									} else if ($v == 3) {
										$vas_3_name = $vas['vas_name'];
										$vas_3_quantity = $vas['quantity'];
									} else if ($v == 4) {
										$vas_4_name = $vas['vas_name'];
										$vas_4_quantity = $vas['quantity'];
									} else if ($v == 5) {
										$vas_5_name = $vas['vas_name'];
										$vas_5_quantity = $vas['quantity'];
									}
									$v++;
								}
							}
							$ord_type = $chkorder->row()->order_type;
							$order_type = "";
							if ($ord_type > 0) {
								$getordertype = $this->db->select("type_name")->get_where("tb_order_types", array('id' => $ord_type, 'status' => '1', 'company_code' => $chkorder->row()->company_code));
								if ($getordertype->num_rows() > 0) {
									$order_type = $getordertype->row()->type_name;
								}
							}
							$customer_id = $chkorder->row()->customer_id;
							$getcustdetails = $this->truckwaybillmodel->getcustomerdetails($customer_id);
							$customer_details = array('id' => "", 'name' => "", 'phone' => "", 'email' => "", 'fax' => "", 'code' => "", 'street' => "", 'state' => "", 'city' => "", 'country' => "", 'pincode' => "", 'acon' => "", 'kn_login' => "", 'vat_reg_no' => "", 'tax_payer_no' => "", 'contract_no' => "", 'contract_date' => "");
							if (!empty($getcustdetails)) {
								if ($getcustdetails['contract_date'] == "0000-00-00") {
									$getcustdetails['contract_date'] = "";
								}
								if ($getcustdetails['contract_date'] != "") {
									$getcustdetails['contract_date'] = date("d.m.Y", strtotime($getcustdetails['contract_date']));
								}
								$street = $getcustdetails['street'];
								if ($getcustdetails['house_number'] != "") {
									$street .= $getcustdetails['house_number'];
								}
								$customer_details = array('id' => $getcustdetails['customeridentifier'], 'name' => $getcustdetails['name'], 'phone' => $getcustdetails['mobile'], 'email' => $getcustdetails['email'], 'fax' => $getcustdetails['fax'], 'code' => $getcustdetails['code'], 'street' => $street, 'state' => $getcustdetails['state'], 'city' => $getcustdetails['location_id'], 'country' => $getcustdetails['country'], 'pincode' => $getcustdetails['pincode'], 'acon' => $getcustdetails['acon_debitor_code'], 'kn_login' => $getcustdetails['kn_login_account'], 'vat_reg_no' => $getcustdetails['vat_reg_no'], 'tax_payer_no' => $getcustdetails['tax_payer_no'], 'contract_no' => $getcustdetails['contract_no'], 'contract_date' => $getcustdetails['contract_date']);
							}
							$getpayer = $this->getpayerdetails($recipient_code);

							$getpartydetails = $this->truckwaybillmodel->getpartydetails($order_id);
							$drop_details = $shipper_details =  array('id' => "", 'name' => "", 'phone' => "", 'email' => "", 'fax' => "", 'code' => "", 'acon' => "", 'kn_login' => "", 'vat_reg_no' => "", 'tax_payer_no' => "", 'contract_no' => "", 'contract_date' => "", 'house_number' => "");
							if (!empty($getpartydetails)) {
								foreach ($getpartydetails as $rr) {
									$ptype = $rr['party_type_id'];
									$chktype = $this->db->select("name")->get_where("tbl_party_types", array("id" => $ptype), 1, 0);
									if ($chktype->num_rows() > 0) {
										if ($rr['contract_date'] != "") {
											$rr['contract_date'] = date("d.m.Y", strtotime($rr['contract_date']));
										}
										if ($chktype->row()->name == "Consignee") {
											$drop_details = array('id' => $rr['customeridentifier'], 'name' => $rr['name'], 'phone' => $rr['mobile'], 'email' => $rr['email'], 'fax' => $rr['fax'], 'code' => $rr['code'], 'acon' => $rr['acon_debitor_code'], 'kn_login' => $rr['kn_login_account'], 'vat_reg_no' => $rr['vat_reg_no'], 'tax_payer_no' => $rr['tax_payer_no'], 'contract_no' => $rr['contract_no'], 'contract_date' => $rr['contract_date'], 'house_number' => $rr['house_number']);
										} else if ($chktype->row()->name == "Shipper") {
											$shipper_details = array('id' => $rr['customeridentifier'], 'name' => $rr['name'], 'phone' => $rr['mobile'], 'email' => $rr['email'], 'fax' => $rr['fax'], 'code' => $rr['code'], 'acon' => $rr['acon_debitor_code'], 'kn_login' => $rr['kn_login_account'], 'vat_reg_no' => $rr['vat_reg_no'], 'tax_payer_no' => $rr['tax_payer_no'], 'contract_no' => $rr['contract_no'], 'contract_date' => $rr['contract_date'], 'house_number' => $rr['house_number']);
										}
									}
								}
							}
							/*Shipper ACON Debitor Code	Shipper KN Login Account	Shipper VAT Registration Number	Shipper Tax Payer ID*/
							$shipper_details['name'] = $chkorder->row()->pickup;
							$shipper_details['street'] = $chkorder->row()->pickup_address1;
							if (isset($shipper_details['house_number'])) {
								if ($shipper_details['house_number'] != "") {
									$shipper_details['street'] .= $shipper_details['house_number'];
								}
							}
							$shipper_details['state'] = $chkorder->row()->pickup_address2;
							$shipper_details['city'] = $chkorder->row()->pickup_city;
							$shipper_details['country'] = $chkorder->row()->pickup_country;
							$shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

							$drop_details['name'] = $chkorder->row()->delivery;
							$drop_details['street'] = $chkorder->row()->delivery_address1;
							if (isset($drop_details['house_number'])) {
								if ($drop_details['house_number'] != "") {
									$drop_details['street'] .= $drop_details['house_number'];
								}
							}
							$drop_details['state'] = $chkorder->row()->delivery_address2;
							$drop_details['city'] = $chkorder->row()->delivery_city;
							$drop_details['country'] = $chkorder->row()->delivery_country;
							$drop_details['pincode'] = $chkorder->row()->delivery_pincode;

							$tripno = $chkorder->row()->shipmentid;
							$info['shift_id'] = $chkorder->row()->shift_id;
							$info['trip_id'] = $chkorder->row()->trip_id;
							$tripinfo = $this->tripinfo($info);
							$carrier_details = $tripinfo['carrier_details'];
							$vehicle_type = $tripinfo['vehicle_type'];
							$trailer_no = $tripinfo['trailer_no'];
							$register_number = $tripinfo['register_number'];
							$driver_name = $tripinfo['driver_name'];
							$driver_licence_number = $tripinfo['driver_licence_number'];
							$driver_address = $tripinfo['driver_address'];
							$getstatusdates = $this->getstatusdates($gene_order_id);
							if ($getstatusdates['statuspickupdate'] != "") {
								$getstatusdates['statuspickupdate'] = date("d.m.Y H:i", strtotime($getstatusdates['statuspickupdate']));
							}
							if ($getstatusdates['statusdeliverydate'] != "") {
								$getstatusdates['statusdeliverydate'] = date("d.m.Y H:i", strtotime($getstatusdates['statusdeliverydate']));
							}
							$docs_sent_datetime = $chkorder->row()->docs_sent_datetime;
							if ($docs_sent_datetime != "" && $docs_sent_datetime != null) {
								$getactual = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
								$docs_sent_datetime = date("d.m.Y H:i", strtotime($getactual['datetime']));
							}
							$docs_received_datetime = $chkorder->row()->docs_received_datetime;
							if ($docs_received_datetime != "" && $docs_received_datetime != null) {
								$getactual = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);
								$docs_received_datetime = date("d.m.Y H:i", strtotime($getactual['datetime']));
							}
							$order_creationon = date("d.m.Y H:i", strtotime($chkorder->row()->createdon));
							$count_revenue_charges = count($getcharges);
							$count_cost_charges = count($getcostcharges);
							if (!empty($getcharges)) {
								$i=0;
								foreach ($getcharges as $getcharge) {
									$orders_data[] = array(
										'ord_id' => $gene_order_id,
										'delivery_ord_no' => $delivery_note, 'purchase_ord_no' => $purchase_order,
										'ord_creation_dttme' => $order_creationon, 'ord_pickup_dttme' => $pickup_datetime,
										'ord_delivery_dttme' => $delivery_datetime, 'shipr_id' => $shipper_details['id'],
										'shipr_cid' => $shipper_details['code'], 'shipr_acon_debtor_code' => $shipper_details['acon'],
										'shipr_kn_login_account' => $shipper_details['kn_login'], 'shipr_vat_reg_no' => $shipper_details['vat_reg_no'],
										'shipr_tax_payer_id' => $shipper_details['tax_payer_no'], 'shipr_name' => $shipper_details['name'],
										'shipr_steeet_and_house_no' => $shipper_details['street'], 'shipr_city' => $shipper_details['city'],
										'shipr_postal_code' => $shipper_details['pincode'], 'shippper_country_name' => $shipper_details['country'],
										'shipr_phone' => $shipper_details['phone'], 'shipr_email' => $shipper_details['email'],
										'consignee_id' => $drop_details['id'], 'consignee_cid' => $drop_details['code'],
										'consignee_acon_debtor_code' => $drop_details['acon'], 'consignee_kn_login_account' => $drop_details['kn_login'],
										'consignee_vat_reg_no' => $drop_details['vat_reg_no'], 'consignee_tax_payer_id' => $drop_details['tax_payer_no'],
										'consignee_name' => $drop_details['name'], 'consignee_steeet_and_house_no' => $drop_details['street'],
										'consignee_city' => $drop_details['city'], 'consignee_postal_code' => $drop_details['pincode'],
										'consignee_country_name' => $drop_details['country'], 'consignee_phone' => $drop_details['phone'],
										'consignee_email' => $drop_details['email'], 'customer_id' => $customer_details['id'],
										'customer_cid' => $customer_details['code'], 'customer_acon_debtor_code' => $customer_details['acon'],
										'customer_kn_login_account' => $customer_details['kn_login'], 'customer_vat_reg_no' => $customer_details['vat_reg_no'],
										'customer_tax_payer_id' => $customer_details['tax_payer_no'], 'customer_name' => $customer_details['name'],
										'customer_steeet_and_house_no' => $customer_details['street'], 'customer_postal_code' => $customer_details['pincode'],
										'customer_country_name' => $customer_details['country'], 'customer_phone' => $customer_details['phone'],
										'customer_email' => $customer_details['email'], 'country' => $customer_details['country'],
										'branch' => $chkorder->row()->branch_code, 'department_code' => $department_code,
										'product' => $chkorder->row()->product, 'service' => $service_name, 'incoterms' => $inco_term,
										'delivery_terms' => $delivery_term, 'delivery_note' => $delivery_note, 'notify_party' => $notify_address['name'],
										'ord_type' => $order_type, 'mode_of_transport' => $chkorder->row()->transport_mode, 'purchase_ord' => $purchase_order,
										'qty' => $getcargodetails['quantity'], 'package_type' => $getcargodetails['package_type'],
										'length' => $getcargodetails['length'], 'length_unit' => $getcargodetails['length_unit'],
										'width' => $getcargodetails['width'], 'width_unit' => $getcargodetails['width_unit'],
										'height' => $getcargodetails['height'], 'height_unit' => $getcargodetails['height_unit'],
										'weight' => $getcargodetails['second_weight'], 'weight_unit' => $getcargodetails['weight_unit'],
										'volume' => $getcargodetails['second_volume'], 'volume_unit' => $getcargodetails['volume_unit'],
										'ldm' => $getcargodetails['ldm'], 'volumetric_weight' => $getcargodetails['volumetric_weight'],
										'volumetric_weight_unit' => $getcargodetails['volweight_uom'], 'stackable' => $getcargodetails['stackable'],
										'dg_goods' => $getcargodetails['dg_goods'], 'actual_weight' => $getcargodetails['weight'],
										'actual_weight_unit' => $getcargodetails['weight_unit'], 'actual_volume' => $getcargodetails['volume'], 'actual_volume_unit' => $getcargodetails['volume_unit'], 'vas_1_name' => "-", 'vas_1_qty' => "-",
										'vas_2_name' => "-", 'vas_2_qty' => "-", 'vas_3_name' => "-", 'vas_3_qty' => "-", 'vas_4_name' => "-",
										'vas_4_qty' => "-", 'vas_5_name' => "-", 'vas_5_qty' => "-", 'ref_1_name' => $ref_1_name,
										'ref_1_desc' => $ref_1_description, 'ref_1_value' => $ref_1_value, 'ref_2_name' => $ref_2_name,
										'ref_2_desc' => $ref_2_description, 'ref_2_value' => $ref_2_value, 'ref_3_name' => $ref_3_name,
										'ref_3_desc' => $ref_3_description, 'ref_3_value' => $ref_3_value, 'ref_4_name' => $ref_4_name,
										'ref_4_desc' => $ref_4_description, 'ref_4_value' => $ref_4_value, 'ref_5_name' => $ref_5_name,
										'ref_5_desc' => $ref_5_description, 'ref_5_value' => $ref_5_value, 'driver_pickup_inst' => $pickup_inst,
										'driver_delivery_inst' => $delivery_inst, 'status_pickedup' => $getstatusdates['statuspickupdate'],
										'status_delivered' => $getstatusdates['statusdeliverydate'], 'org_doc_received' => $docs_received_datetime,
										'org_doc_sent' => $docs_sent_datetime, 'trip_id' => $tripno, 'carrier' => $carrier_details['suppier_name'],
										'vehicle_no' => $register_number, 'trailer_no' => $trailer_no, 'vehicle_type' => $vehicle_type,
										'driver_name' => $driver_name, 'driver_licence_no' => $driver_licence_number,
										'driver_address' => $driver_address, 'payer_role' => "N/A", 'payer_id' => $getpayer['id'],
										'payer_name' => $getpayer['name'], 'payer_cid' => $getpayer['code'],
										'payer_acon_debtor_code' => $getpayer['acon'], 'payer_kn_login_account' => $getpayer['kn_login'],
										'payer_vat_reg_no' => $getpayer['vat_reg_no'], 'payer_tax_payer_id' => $getpayer['tax_payer_no'],
										'payer_steeet_and_house_no' => $getpayer['payer_steeet_house'], 'payer_postal_code' => $getpayer['payer_postal'],
										'payer_country_name' => $getpayer['payer_country'], 'payer_phone' => $getpayer['phone'], 'payer_email' => $getpayer['email'],
										'rev_chrg_code' => $getcharge['chargecode'], 'rev_chrg_name' => $getcharge['chargecodename'], 'rev_chrg_qty' => $getcharge['quantity'],
										'rev_chrg_value' => $getcharge['value'], 'rev_chrg_rate_id' => $getcharge['rate_id'], 'rev_chrg_amount' => $getcharge['amount'],
										'rev_chrg_currency' => $getcharge['currency'], 'rev_chrg_vat' => $getcharge['vat_percentage'], 'rev_chrg_vat_amount' => $getcharge['vat_amount'],
										'rev_chrg_total' => $getcharge['total_amount'], 'rev_bu_jfr' => $rev_bu_jfr, 'rev_jfr' => $rev_debtor_jfr, 'rev_exchange_rate' => $rev_exchange_rate,
										'rev_foreign_currency' => $rev_foreign_currency, 'rev_invoice_no' => $rev_invoiceno, 'rev_invoice_date' => $rev_invoicedate,
										'rev_credit_note_no' => $rev_creditnote, 'rev_credit_note_date' => "-", 'rev_invoice_creation_date' => $invoice_creation_date,
										'rev_invoice_received_date' => $invoice_receivdon_date, 'rev_status' => $invoice_status, 'customer_contract_no' => $customer_details['contract_no'],
										'customer_contract_date' => $customer_details['contract_date'], 'invoice_status' => $invoice_status, 'suppier_role' => "-",
										'suppier_id' => "-", 'suppier_name' => "-", 'suppier_steeet_and_house_no' => "-", 'suppier_postal_code' => "-", 'suppier_country_name' => "-",
										'suppier_phone' => "-",'suppier_email' => "-",'cost_chrg_code' => $getcostcharges[$i]['chargecode'] ?? '',
										 'cost_chrg_name' => $getcostcharges[$i]['chargecodename'] ?? '', 'cost_chrg_qty' => $getcostcharges[$i]['quantity'] ?? '',
										'cost_chrg_value' => $getcostcharges[$i]['value'] ?? '', 'cost_chrg_rate_id' => $getcostcharges[$i]['rate_id'] ?? '', 'cost_chrg_amount' => $getcostcharges[$i]['amount'] ?? '', 'cost_chrg_currency' => $getcostcharges[$i]['currency'] ?? '',
										'cost_chrg_vat' => $getcostcharges[$i]['vat_percentage'] ?? '', 'cost_chrg_vat_amount' => $getcostcharges[$i]['vat_amount'] ?? '', 'cost_bu_jfr' => $getcostcharges[$i]['bu_jfr'] ?? '', 'cost_jfr' => $getcostcharges[$i]['debtor_jfr'] ?? '',
										'cost_exchange_rate' => $getcostcharges[$i]['exchange_rate'] ?? '', 'cost_foreign_currency' => $getcostcharges[$i]['foreign_currency'] ?? ''
									);
								}
								$i++;
							}
							if($count_cost_charges > $count_revenue_charges){
								for($j=$i;$j<=$count_revenue_charges;$j++){
									$orders_data[] = array(
										'ord_id' => $gene_order_id,
										'delivery_ord_no' => $delivery_note, 'purchase_ord_no' => $purchase_order,
										'ord_creation_dttme' => $order_creationon, 'ord_pickup_dttme' => $pickup_datetime,
										'ord_delivery_dttme' => $delivery_datetime, 'shipr_id' => $shipper_details['id'],
										'shipr_cid' => $shipper_details['code'], 'shipr_acon_debtor_code' => $shipper_details['acon'],
										'shipr_kn_login_account' => $shipper_details['kn_login'], 'shipr_vat_reg_no' => $shipper_details['vat_reg_no'],
										'shipr_tax_payer_id' => $shipper_details['tax_payer_no'], 'shipr_name' => $shipper_details['name'],
										'shipr_steeet_and_house_no' => $shipper_details['street'], 'shipr_city' => $shipper_details['city'],
										'shipr_postal_code' => $shipper_details['pincode'], 'shippper_country_name' => $shipper_details['country'],
										'shipr_phone' => $shipper_details['phone'], 'shipr_email' => $shipper_details['email'],
										'consignee_id' => $drop_details['id'], 'consignee_cid' => $drop_details['code'],
										'consignee_acon_debtor_code' => $drop_details['acon'], 'consignee_kn_login_account' => $drop_details['kn_login'],
										'consignee_vat_reg_no' => $drop_details['vat_reg_no'], 'consignee_tax_payer_id' => $drop_details['tax_payer_no'],
										'consignee_name' => $drop_details['name'], 'consignee_steeet_and_house_no' => $drop_details['street'],
										'consignee_city' => $drop_details['city'], 'consignee_postal_code' => $drop_details['pincode'],
										'consignee_country_name' => $drop_details['country'], 'consignee_phone' => $drop_details['phone'],
										'consignee_email' => $drop_details['email'], 'customer_id' => $customer_details['id'],
										'customer_cid' => $customer_details['code'], 'customer_acon_debtor_code' => $customer_details['acon'],
										'customer_kn_login_account' => $customer_details['kn_login'], 'customer_vat_reg_no' => $customer_details['vat_reg_no'],
										'customer_tax_payer_id' => $customer_details['tax_payer_no'], 'customer_name' => $customer_details['name'],
										'customer_steeet_and_house_no' => $customer_details['street'], 'customer_postal_code' => $customer_details['pincode'],
										'customer_country_name' => $customer_details['country'], 'customer_phone' => $customer_details['phone'],
										'customer_email' => $customer_details['email'], 'country' => $customer_details['country'],
										'branch' => $chkorder->row()->branch_code, 'department_code' => $department_code,
										'product' => $chkorder->row()->product, 'service' => $service_name, 'incoterms' => $inco_term,
										'delivery_terms' => $delivery_term, 'delivery_note' => $delivery_note, 'notify_party' => $notify_address['name'],
										'ord_type' => $order_type, 'mode_of_transport' => $chkorder->row()->transport_mode, 'purchase_ord' => $purchase_order,
										'qty' => $getcargodetails['quantity'], 'package_type' => $getcargodetails['package_type'],
										'length' => $getcargodetails['length'], 'length_unit' => $getcargodetails['length_unit'],
										'width' => $getcargodetails['width'], 'width_unit' => $getcargodetails['width_unit'],
										'height' => $getcargodetails['height'], 'height_unit' => $getcargodetails['height_unit'],
										'weight' => $getcargodetails['second_weight'], 'weight_unit' => $getcargodetails['weight_unit'],
										'volume' => $getcargodetails['second_volume'], 'volume_unit' => $getcargodetails['volume_unit'],
										'ldm' => $getcargodetails['ldm'], 'volumetric_weight' => $getcargodetails['volumetric_weight'],
										'volumetric_weight_unit' => $getcargodetails['volweight_uom'], 'stackable' => $getcargodetails['stackable'],
										'dg_goods' => $getcargodetails['dg_goods'], 'actual_weight' => $getcargodetails['weight'],
										'actual_weight_unit' => $getcargodetails['weight_unit'], 'actual_volume' => $getcargodetails['volume'], 'actual_volume_unit' => $getcargodetails['volume_unit'], 'vas_1_name' => "-", 'vas_1_qty' => "-",
										'vas_2_name' => "-", 'vas_2_qty' => "-", 'vas_3_name' => "-", 'vas_3_qty' => "-", 'vas_4_name' => "-",
										'vas_4_qty' => "-", 'vas_5_name' => "-", 'vas_5_qty' => "-", 'ref_1_name' => $ref_1_name,
										'ref_1_desc' => $ref_1_description, 'ref_1_value' => $ref_1_value, 'ref_2_name' => $ref_2_name,
										'ref_2_desc' => $ref_2_description, 'ref_2_value' => $ref_2_value, 'ref_3_name' => $ref_3_name,
										'ref_3_desc' => $ref_3_description, 'ref_3_value' => $ref_3_value, 'ref_4_name' => $ref_4_name,
										'ref_4_desc' => $ref_4_description, 'ref_4_value' => $ref_4_value, 'ref_5_name' => $ref_5_name,
										'ref_5_desc' => $ref_5_description, 'ref_5_value' => $ref_5_value, 'driver_pickup_inst' => $pickup_inst,
										'driver_delivery_inst' => $delivery_inst, 'status_pickedup' => $getstatusdates['statuspickupdate'],
										'status_delivered' => $getstatusdates['statusdeliverydate'], 'org_doc_received' => $docs_received_datetime,
										'org_doc_sent' => $docs_sent_datetime, 'trip_id' => $tripno, 'carrier' => $carrier_details['suppier_name'],
										'vehicle_no' => $register_number, 'trailer_no' => $trailer_no, 'vehicle_type' => $vehicle_type,
										'driver_name' => $driver_name, 'driver_licence_no' => $driver_licence_number,
										'driver_address' => $driver_address, 'payer_role' => "N/A", 'payer_id' => $getpayer['id'],
										'payer_name' => $getpayer['name'], 'payer_cid' => $getpayer['code'],
										'payer_acon_debtor_code' => $getpayer['acon'], 'payer_kn_login_account' => $getpayer['kn_login'],
										'payer_vat_reg_no' => $getpayer['vat_reg_no'], 'payer_tax_payer_id' => $getpayer['tax_payer_no'],
										'payer_steeet_and_house_no' => $getpayer['payer_steeet_house'], 'payer_postal_code' => $getpayer['payer_postal'],
										'payer_country_name' => $getpayer['payer_country'], 'payer_phone' => $getpayer['phone'], 'payer_email' => $getpayer['email'],
										'rev_chrg_code' => '', 'rev_chrg_name' => '', 'rev_chrg_qty' =>'',
										'rev_chrg_value' => '', 'rev_chrg_rate_id' => '', 'rev_chrg_amount' => '',
										'rev_chrg_currency' => '', 'rev_chrg_vat' => '', 'rev_chrg_vat_amount' => '',
										'rev_chrg_total' => '', 'rev_bu_jfr' => '', 'rev_jfr' => '', 'rev_exchange_rate' => '',
										'rev_foreign_currency' => '', 'rev_invoice_no' => '', 'rev_invoice_date' => '',
										'rev_credit_note_no' => '', 'rev_credit_note_date' => "-", 'rev_invoice_creation_date' => '',
										'rev_invoice_received_date' => '', 'rev_status' => '', 'customer_contract_no' => $customer_details['contract_no'],
										'customer_contract_date' => $customer_details['contract_date'], 'invoice_status' => $invoice_status, 'suppier_role' => "-",
										'suppier_id' => "-", 'suppier_name' => "-", 'suppier_steeet_and_house_no' => "-", 'suppier_postal_code' => "-", 'suppier_country_name' => "-",
										'suppier_phone' => "-",'suppier_email' => "-",'cost_chrg_code' => $getcostcharges[$j]['chargecode'] ?? '',
										 'cost_chrg_name' => $getcostcharges[$j]['chargecodename'] ?? '', 'cost_chrg_qty' => $getcostcharges[$j]['quantity'] ?? '',
										'cost_chrg_value' => $getcostcharges[$j]['value'] ?? '', 'cost_chrg_rate_id' => $getcostcharges[$j]['rate_id'] ?? '', 'cost_chrg_amount' => $getcostcharges[$j]['amount'] ?? '', 'cost_chrg_currency' => $getcostcharges[$j]['currency'] ?? '',
										'cost_chrg_vat' => $getcostcharges[$j]['vat_percentage'] ?? '', 'cost_chrg_vat_amount' => $getcostcharges[$j]['vat_amount'] ?? '', 'cost_bu_jfr' => $getcostcharges[$j]['bu_jfr'] ?? '', 'cost_jfr' => $getcostcharges[$j]['debtor_jfr'] ?? '',
										'cost_exchange_rate' => $getcostcharges[$j]['exchange_rate'] ?? '', 'cost_foreign_currency' => $getcostcharges[$j]['foreign_currency'] ?? ''
									);

								}

							}
						}
					}
				}
			}
		}
		$this->getexcelreport($orders_data, $recipient_code, $invoiceno);
	}
	public function getexcelreport($orders_data, $code, $invoiceno)
	{
		$columns = array('ord_id' => 'Order ID', 'delivery_ord_no' => 'Delivery Order No.', 'purchase_ord_no' => 'Purchase Order No.', 'ord_creation_dttme' => 'Order Creation date and time', 'ord_pickup_dttme' => 'Order Pick-up date and time', 'ord_delivery_dttme' => 'Order Delivery date and time', 'shipr_id' => 'Shipper ID', 'shipr_cid' => 'Shipper CID', 'shipr_acon_debtor_code' => 'Shipper ACON Debitor Code', 'shipr_kn_login_account' => 'Shipper KN Login Account', 'shipr_vat_reg_no' => 'Shipper VAT Registration Number', 'shipr_tax_payer_id' => 'Shipper Tax Payer ID', 'shipr_name' => 'Shipper Name', 'shipr_steeet_and_house_no' => 'Shipper Street and house number', 'shipr_city' => 'Shipper City', 'shipr_postal_code' => 'Shipper Postal code', 'shippper_country_name' => 'Shipper Country Name', 'shipr_phone' => 'Shipper Phone', 'shipr_email' => 'Shipper Email', 'consignee_id' => 'Consignee ID', 'consignee_cid' => 'Consignee CID', 'consignee_acon_debtor_code' => 'Consignee ACON Debitor Code', 'consignee_kn_login_account' => 'Consignee KN Login Account', 'consignee_vat_reg_no' => 'Consignee VAT Registration Number', 'consignee_tax_payer_id' => 'Consignee Tax Payer ID', 'consignee_name' => 'Consignee Name', 'consignee_steeet_and_house_no' => 'Consignee Street and house number', 'consignee_city' => 'Consignee City', 'consignee_postal_code' => 'Consignee Postal code', 'consignee_country_name' => 'Consignee Country Name', 'consignee_phone' => 'Consignee Phone', 'consignee_email' => 'Consignee Email', 'customer_id' => 'Customer ID', 'customer_cid' => 'Customer CID', 'customer_acon_debtor_code' => 'Customer ACON Debitor Code', 'customer_kn_login_account' => 'Customer KN Login Account', 'customer_vat_reg_no' => 'Customer VAT Registration Number', 'customer_tax_payer_id' => 'Customer Tax Payer ID', 'customer_name' => 'Customer Name', 'customer_steeet_and_house_no' => 'Customer Street and house number', 'customer_postal_code' => 'Customer Postal code', 'customer_country_name' => 'Customer Country Name', 'customer_phone' => 'Customer Phone', 'customer_email' => 'Customer Email', 'country' => 'Country', 'branch' => 'Branch', 'department_code' => 'Department Code', 'product' => 'Product', 'service' => 'Service', 'incoterms' => 'Incoterms', 'delivery_terms' => 'Delivery Terms', 'delivery_note' => 'Delivery Note', 'notify_party' => 'Notify Party', 'ord_type' => 'Booking Type', 'mode_of_transport' => 'Mode of Transport', 'purchase_ord' => 'Purchase Order', 'qty' => 'Quantity', 'package_type' => 'Package Type', 'length' => 'Length', 'length_unit' => 'Length Unit', 'width' => 'Width', 'width_unit' => 'Width Unit', 'height' => 'Height', 'height_unit' => 'Height Unit', 'weight' => 'Weight', 'weight_unit' => 'Weight Unit', 'volume' => 'Volume', 'volume_unit' => 'Volume Unit', 'ldm' => 'LDM', 'volumetric_weight' => 'Volumetric Weight', 'volumetric_weight_unit' => 'Volumetric Weight Unit', 'stackable' => 'Stackable', 'dg_goods' => 'DG Goods', 'actual_weight' => 'Actual Weight', 'actual_weight_unit' => 'Actual Weight Unit', 'actual_volume' => 'Actual Volume', 'actual_volume_unit' => 'Actual Volume Unit', 'vas_1_name' => 'Value added Service  1 Name', 'vas_1_qty' => 'Value added Service 1 - Quantity', 'vas_2_name' => 'Value added Service 2 Name', 'vas_2_qty' => 'Value added Service 2 - Quantity', 'vas_3_name' => 'Value added Service 3 Name', 'vas_3_qty' => 'Value added Service 3 - Quantity', 'vas_4_name' => 'Value added Service 4 Name ', 'vas_4_qty' => 'Value added Service 4 - Quantity', 'vas_5_name' => 'Value added Service 5 Name', 'vas_5_qty' => 'Value added Service 5 - Quantity', 'ref_1_name' => 'Reference 1 Name', 'ref_1_desc' => 'Reference 1 Description', 'ref_1_value' => 'Reference 1 Value', 'ref_2_name' => 'Reference 2 Name', 'ref_2_desc' => 'Reference 2 Description', 'ref_2_value' => 'Reference 2 Value', 'ref_3_name' => 'Reference 3 Name', 'ref_3_desc' => 'Reference 3 Description', 'ref_3_value' => 'Reference 3 Value', 'ref_4_name' => 'Reference 4 Name', 'ref_4_desc' => 'Reference 4 Description', 'ref_4_value' => 'Reference 4 Value', 'ref_5_name' => 'Reference 5 Name', 'ref_5_desc' => 'Reference 5 Description', 'ref_5_value' => 'Reference 5 Value', 'driver_pickup_inst' => 'Driver Pickup Instructions', 'driver_delivery_inst' => 'Driver Delivery Instructions', 'status_pickedup' => 'Status "Picked-up" Date and Time', 'status_delivered' => 'Status "Delivered" Date and Time', 'org_doc_received' => 'Original Documents Received Date and Time', 'org_doc_sent' => 'Original Documents Sent Date and Time', 'trip_id' => 'Trip ID', 'carrier' => 'Carrier', 'vehicle_no' => 'Vehicle Number', 'trailer_no' => 'Trailer Number', 'vehicle_type' => 'Vehicle Type', 'driver_name' => 'Driver Name', 'driver_licence_no' => 'Driver Licence Number', 'driver_address' => 'Driver Address', 'payer_role' => 'Payer Role', 'payer_id' => 'Payer ID', 'payer_name' => 'Payer Name', 'payer_cid' => 'Payer CID', 'payer_acon_debtor_code' => 'Payer ACON Debitor Code', 'payer_kn_login_account' => 'Payer KN Login Account', 'payer_vat_reg_no' => 'Payer VAT Registration Number', 'payer_tax_payer_id' => 'Payer Tax payer ID', 'payer_steeet_and_house_no' => 'Payer Street and house number', 'payer_postal_code' => 'Payer Postal code', 'payer_country_name' => 'Payer Country Name', 'payer_phone' => 'Payer Phone', 'payer_email' => 'Payer Email', 'rev_chrg_code' => 'Revenue Charge Code', 'rev_chrg_name' => 'Revenue Charge Name', 'rev_chrg_qty' => 'Revenue Charge Quantity', 'rev_chrg_value' => 'Revenue Charge Value', 'rev_chrg_rate_id' => 'Revenue  Charge Rate ID', 'rev_chrg_amount' => 'Revenue  Charge Amount', 'rev_chrg_currency' => 'Revenue Charge Currency', 'rev_chrg_vat' => 'Revenue Charge VAT %', 'rev_chrg_vat_amount' => 'Revenue Charge VAT Amount', 'rev_chrg_total' => 'Revenue Charge Total', 'rev_bu_jfr' => 'Revenue BU JFR', 'rev_jfr' => 'Revenue JFR', 'rev_exchange_rate' => 'Revenue Exchange Rate', 'rev_foreign_currency' => 'Revenue Foreign Currency', 'rev_invoice_no' => 'Revenue Invoice No.', 'rev_invoice_date' => 'Revenue Invoice Date', 'rev_credit_note_no' => 'Revenue Credit Note Number', 'rev_credit_note_date' => 'Revenue Credit Note Date', 'rev_invoice_creation_date' => 'Revenue Invoice Creation Date', 'rev_invoice_received_date' => 'Revenue Invoice Received Date', 'rev_status' => 'Revenue Status', 'customer_contract_no' => 'Customer Contract Number', 'customer_contract_date' => 'Customer Contract Date', 'invoice_status' => 'Invoice Status', 'suppier_role' => 'Supplier Role', 'suppier_id' => 'Supplier ID', 'suppier_name' => 'Supplier Name', 'suppier_steeet_and_house_no' => 'Supplier Street and house number', 'suppier_postal_code' => 'Supplier Postal code', 'suppier_country_name' => 'Supplier Country Name', 'suppier_phone' => 'Supplier Phone', 'suppier_email' => 'Supplier Email', 'cost_chrg_code' => 'Cost Charge Code', 'cost_chrg_name' => 'Cost Charge Name', 'cost_chrg_qty' => 'Cost Charge Quantity', 'cost_chrg_value' => 'Cost Charge Value', 'cost_chrg_rate_id' => 'Cost  Charge Rate ID', 'cost_chrg_amount' => 'Cost  Charge Amount', 'cost_chrg_currency' => 'Cost Charge Currency', 'cost_chrg_vat' => 'Cost Charge VAT %', 'cost_chrg_vat_amount' => 'Cost Charge VAT Amount', 'cost_bu_jfr' => 'Cost BU JFR', 'cost_jfr' => 'Cost JFR', 'cost_exchange_rate' => 'Cost Exchange Rate', 'cost_foreign_currency' => 'Cost Foreign Currency');
		$cust_cols = $select_sequence = array();
		if ($code != "") {
			$select = "ord_id, delivery_ord_no, purchase_ord_no, ord_creation_dttme, ord_pickup_dttme, ord_delivery_dttme, shipr_id, shipr_cid, shipr_acon_debtor_code, shipr_kn_login_account, shipr_vat_reg_no, shipr_tax_payer_id, shipr_name, shipr_steeet_and_house_no, shipr_city, shipr_postal_code, shippper_country_name, shipr_phone, shipr_email, consignee_id, consignee_cid, consignee_acon_debtor_code, consignee_kn_login_account, consignee_vat_reg_no, consignee_tax_payer_id, consignee_name, consignee_steeet_and_house_no, consignee_city, consignee_postal_code, consignee_country_name, consignee_phone, consignee_email, customer_id, customer_cid, customer_acon_debtor_code, customer_kn_login_account, customer_vat_reg_no, customer_tax_payer_id, customer_name, customer_steeet_and_house_no, customer_postal_code, customer_country_name, customer_phone, customer_email, country, branch, department_code, product, service, incoterms, delivery_terms, delivery_note, notify_party, ord_type, mode_of_transport, purchase_ord, qty, package_type, length, length_unit, width, width_unit, height, height_unit, weight, weight_unit, volume, volume_unit, ldm, volumetric_weight, volumetric_weight_unit, stackable, dg_goods,actual_weight,actual_weight_unit,actual_volume,actual_volume_unit,vas_1_name, vas_1_qty, vas_2_name, vas_2_qty, vas_3_name, vas_3_qty, vas_4_name, vas_4_qty, vas_5_name, vas_5_qty, ref_1_name, ref_1_desc, ref_1_value, ref_2_name, ref_2_desc, ref_2_value, ref_3_name, ref_3_desc, ref_3_value, ref_4_name, ref_4_desc, ref_4_value, ref_5_name, ref_5_desc, ref_5_value, driver_pickup_inst, driver_delivery_inst, status_pickedup, status_delivered, org_doc_received, org_doc_sent, trip_id, carrier, vehicle_no, trailer_no, vehicle_type, driver_name, driver_licence_no, driver_address, payer_role, payer_id, payer_name, payer_cid, payer_acon_debtor_code, payer_kn_login_account, payer_vat_reg_no, payer_tax_payer_id, payer_steeet_and_house_no, payer_postal_code, payer_country_name, payer_phone, payer_email, rev_chrg_code, rev_chrg_name, rev_chrg_qty, rev_chrg_value, rev_chrg_rate_id, rev_chrg_amount, rev_chrg_currency, rev_chrg_vat, rev_chrg_vat_amount,rev_chrg_total, rev_bu_jfr, rev_jfr, rev_exchange_rate, rev_foreign_currency, rev_invoice_no, rev_invoice_date, rev_credit_note_no, rev_credit_note_date, rev_invoice_creation_date, rev_invoice_received_date, rev_status, customer_contract_no, customer_contract_date, invoice_status, suppier_role, suppier_id, suppier_name, suppier_steeet_and_house_no, suppier_postal_code, suppier_country_name, suppier_phone, suppier_email, cost_chrg_code, cost_chrg_name, cost_chrg_qty, cost_chrg_value, cost_chrg_rate_id, cost_chrg_amount, cost_chrg_currency, cost_chrg_vat, cost_chrg_vat_amount, cost_bu_jfr, cost_jfr, cost_exchange_rate, cost_foreign_currency";
			$get_cust_cols = $this->common->gettblrowdata(array("code" => $code, "status" => 1), $select, "tb_custaprl_cols", 0, 0);
			if (!empty($get_cust_cols)) {
				foreach ($get_cust_cols as $key => $value) {
					/* echo $key."<br>";*/
					$col_val = explode("_", $value);
					if (isset($col_val[0])) {
						$cust_cols[] = $col_val[0];
					}
					if (isset($col_val[1])) {
						if ($col_val[0] == 1 && $col_val[1]) {
							$select_sequence[$key] = $col_val[1];
						}
					}
				}
				/*$cust_cols = array_values($get_cust_cols);*/
			}
		}
		if (!empty($select_sequence)) {
			asort($select_sequence);
		}
		$cell = "A";
		$i = 0;
		$cellno = "";
		foreach ($columns as $col) {
			$cellno = $cell . "1";
			if (!empty($cust_cols)) {
				if ($cust_cols[$i] == 1) {
					$cell++;
				}
			} else {
				$cell++;
			}
			$i++;
		}
		$range = "A1:" . $cellno;
		$styleArray = array(
			'font'  => array(
				'bold'  => true,
				'color' => array('rgb' => 'FFFFFF'),
				'size'  => 10,
				'name'  => 'Verdana'
			)
		);
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()
			->getStyle($range)
			->applyFromArray(
				array(
					'fill' => array(
						'type' => PHPExcel_Style_Fill::FILL_SOLID,
						'color' => array('rgb' => '0c3b81')
					)
				)
			);
		$stylecells = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '9ab5d0')
			), 'font'  => array(
				'bold'  => true,
				'color' => array('rgb' => 'FFFFFF'),
				'size'  => 10,
				'name'  => 'Verdana'
			)
		);
		$cell = "A";
		$cellno = "";
		$i = 0;
		if (!empty($select_sequence)) {
			foreach ($select_sequence as $key => $value) {
				$cellno = $cell . "1";
				if (isset($columns[$key])) {
					$objPHPExcel->getActiveSheet()->SetCellValue($cellno, $columns[$key]);
					$objPHPExcel->getActiveSheet()->getStyle($cellno)->applyFromArray($styleArray);
					$objPHPExcel->getActiveSheet()->getColumnDimension($cell)->setAutoSize(true);
					$cell++;
					$i++;
				}
			}
		} else {
			foreach ($columns as $key => $value) {
				$cellno = $cell . "1";
				$objPHPExcel->getActiveSheet()->SetCellValue($cellno, $value);
				$objPHPExcel->getActiveSheet()->getStyle($cellno)->applyFromArray($styleArray);
				$objPHPExcel->getActiveSheet()->getColumnDimension($cell)->setAutoSize(true);
				$cell++;
				$i++;
			}
		}
		$range = "A1:" . $cellno;
		$rowCount = 2;
		foreach ($orders_data as $orderdata) {
			$cell = "A";
			$i = 0;
			if (!empty($select_sequence)) {
				foreach ($select_sequence as $key => $value) {
					$cellno = $cell . $rowCount;
					$coldata = $orderdata[$key];
					$objPHPExcel->getActiveSheet()->setCellValueExplicit($cellno, $coldata, PHPExcel_Cell_DataType::TYPE_STRING);
					$objPHPExcel->getActiveSheet()->getStyle($cellno);
					$cell++;
				}
			} else {
				foreach ($orderdata as $coldata) {
					$cellno = $cell . $rowCount;
					$objPHPExcel->getActiveSheet()->setCellValueExplicit($cellno, $coldata, PHPExcel_Cell_DataType::TYPE_STRING);
					$objPHPExcel->getActiveSheet()->getStyle($cellno);
					$cell++;
				}
			}
			$rowCount++;
		}
		$fileName = 'Customer approval_' . $invoiceno . "_" . date("Ymdhis") . '.xlsx';
		ob_end_clean();
		header('Content-Type: application/vnd.ms-excel'); /*mime type*/
		header('Content-Disposition: attachment;filename="' . $fileName . '"'); /*tell browser what's the file name*/
		header('Cache-Control: max-age=0'); /*no cache*/
		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
		$objWriter->save('php://output');
	}
	public function tripinfo($data)
	{
		$result = array();
		$carrier_details = array('suppier_role' => "", 'suppier_id' => "", 'suppier_name' => "", 'suppier_steeet_house' => "", 'suppier_postalcode' => "", 'suppier_country' => "", 'suppier_phone' => "", 'suppier_email' => "");
		$result = array('carrier_details' => $carrier_details, 'vehicle_type' => '', 'trailer_no' => '', 'register_number' => '', 'driver_name' => '', 'driver_licence_number' => '', 'driver_address' => '', 'driver_contact_num' => '');
		$shift_id = $data['shift_id'];
		$trip_id = $data['trip_id'];
		if ($shift_id > 0) {
			$getshiftinfo = $this->common->gettblrowdata(array('id' => $shift_id), "vendor_id,vehicle_type,carrier_instructions", "tb_shifts", 0, 0);
			if (!empty($getshiftinfo)) {
				$vendor_id = $getshiftinfo['vendor_id'];
				$result['vehicle_type']  = $getshiftinfo['vehicle_type'];
				$carrier_instructions  = $getshiftinfo['carrier_instructions'];
				if ($vendor_id > 0) {
					$getcarrierinfo = $this->common->gettblrowdata(array('id' => $vendor_id, 'status' => 1), "name,mobile,location,address,pincode,country,email,code", "tb_vendors", 0, 0);
					if (!empty($getcarrierinfo)) {
						$result['carrier_details'] = array('suppier_role' => "Supplier Role", 'suppier_id' => $getcarrierinfo['code'], 'suppier_name' => $getcarrierinfo['name'], 'suppier_steeet_house' => $getcarrierinfo['address'], 'suppier_postalcode' => $getcarrierinfo['pincode'], 'suppier_country' => $getcarrierinfo['country'], 'suppier_phone' => $getcarrierinfo['mobile'], 'suppier_email' => $getcarrierinfo['email']);
					}
				}
			}
			$getvehicleinfo =  $this->truckwaybillmodel->vehicelinfo($shift_id);
			if (!empty($getvehicleinfo)) {
				$result['trailer_no']  = $getvehicleinfo['truck_number'];
				$result['register_number']  = $getvehicleinfo['register_number'];
				$result['vehicle_type']  = $getvehicleinfo['trucktype'];
			}
			if ($trip_id > 0) {
				$getdriverinfo = $this->truckwaybillmodel->driverinfo($trip_id);
				if ($getdriverinfo->num_rows() > 0) {
					$result['driver_name']  = $getdriverinfo->row()->name;
					$result['driver_contact_num']  = $getdriverinfo->row()->contact_num;
					$result['driver_licence_number'] = $getdriverinfo->row()->driving_licence_num;
				}
			}
		}
		return $result;
	}
	public function getcargodetails($order_id)
	{
		$getcargodetails = $this->truckwaybillmodel->getcargodetails($order_id);
		$quantity =  $package_type  = $length = $length_unit = $width = $width_unit = $height = $height_unit = $weight =  $weight_unit =  $volume = $volume_unit =  $ldm = $volumetric_weight = $volweight_uom =  $stackable = $dg_goods = $second_weight = $second_volume = array();
		$result_cargodetails = array('quantity' => $quantity, 'package_type' => $package_type, 'length' => $length, 'length_unit' => $length_unit, 'width' => $width, 'width_unit' => $width_unit, 'height' => $height, 'height_unit' => $height_unit, 'weight' => $weight,  'weight_unit' => $weight_unit,  'volume' => $volume, 'volume_unit' => $volume_unit,  'ldm' => $ldm, 'volumetric_weight' => $volumetric_weight, 'volweight_uom' => $volweight_uom,  'stackable' => $stackable, 'dg_goods' => $dg_goods, 'second_weight' => $second_weight, 'second_volume' => $second_volume);
		if (!empty($getcargodetails)) {
			foreach ($getcargodetails as $cargodetails) {
				if (is_numeric($cargodetails['length'])) {
					$cargodetails['length'] = number_format($cargodetails['length'], 3, ',', '');
				}
				if (is_numeric($cargodetails['width'])) {
					$cargodetails['width'] = number_format($cargodetails['width'], 3, ',', '');
				}
				if (is_numeric($cargodetails['height'])) {
					$cargodetails['height'] = number_format($cargodetails['height'], 3, ',', '');
				}
				$quantity[] = $cargodetails['quantity'];
				$package_type[] = $cargodetails['cargo_type'];
				$length[] = $cargodetails['length'];
				$length_unit[] = $cargodetails['length_unit'];
				$width[] = $cargodetails['width'];
				$width_unit[] = $cargodetails['width_unit'];
				$height[] = $cargodetails['height'];
				$height_unit[] = $cargodetails['height_unit'];
				$weight[] = $cargodetails['weight'];
				$weight_unit[] = $cargodetails['weight_unit'];
				$volume[] = $cargodetails['volume'];
				$volume_unit[] = $cargodetails['volume_unit'];
				$ldm[] = $cargodetails['ldm'];
				$volumetric_weight[] = $cargodetails['volumetric_weight'];
				$volweight_uom[] = $cargodetails['volweight_uom'];
				if ($cargodetails['stackable'] == 0) {
					$stackable1 = "No";
				} else {
					$stackable1 = "Yes";
				}
				$stackable[] = $stackable1;
				if ($cargodetails['dg_goods'] == 0) {
					$dg_goods1 = "No";
				} else {
					$dg_goods1 = "Yes";
				}
				$dg_goods[] = $dg_goods1;
				$second_weight[] = $cargodetails['second_weight'];
				$second_volume[] = $cargodetails['second_volume'];
			}
		}
		if (!empty($quantity)) {
			$quantity = array_sum($quantity);
		} else {
			$quantity = "-";
		}
		if (!empty($package_type)) {
			$package_type = implode(',', $package_type);
		} else {
			$package_type = "-";
		}
		if (!empty($length) && sizeof($length) == 1) {
			$length = implode(',', $length);
		} else {
			$length = "-";
		}
		if (!empty($length_unit)) {
			$length_unit = implode(',', $length_unit);
		} else {
			$length_unit = "-";
		}
		if (!empty($width) && sizeof($width) == 1) {
			$width = implode(',', $width);
		} else {
			$width = "-";
		}
		if (!empty($width_unit)) {
			$width_unit = implode(',', $width_unit);
		} else {
			$width_unit = "-";
		}
		if (!empty($height) && sizeof($height) == 1) {
			$height = implode(',', $height);
		} else {
			$height = "-";
		}
		if (!empty($height_unit)) {
			$height_unit = implode(',', $height_unit);
		} else {
			$height_unit = "-";
		}
		if (!empty($weight)) {
			$weight = array_sum($weight);
		} else {
			$weight = "-";
		}
		if (!empty($weight_unit)) {
			$weight_unit = implode(',', $weight_unit);
		} else {
			$weight_unit = "-";
		}
		if (!empty($volume)) {
			$volume = array_sum($volume);
		} else {
			$volume = "-";
		}
		if (!empty($volume_unit)) {
			$volume_unit = implode(',', $volume_unit);
		} else {
			$volume_unit = "-";
		}
		if (!empty($ldm)) {
			$ldm = array_sum($ldm);
		} else {
			$ldm = "-";
		}
		if (!empty($volumetric_weight)) {
			$volumetric_weight = array_sum($volumetric_weight);
		} else {
			$volumetric_weight = "-";
		}
		if (!empty($volweight_uom)) {
			$volweight_uom = implode(',', $volweight_uom);
		} else {
			$volweight_uom = "-";
		}
		if (!empty($stackable)) {
			$stackable = implode(',', $stackable);
		} else {
			$stackable = "-";
		}
		if (!empty($dg_goods)) {
			$dg_goods = implode(',', $dg_goods);
		} else {
			$dg_goods = "-";
		}
		if (!empty($second_volume)) {
			$second_volume = array_sum($second_volume);
		} else {
			$second_volume = "-";
		}
		if (!empty($second_weight)) {
			$second_weight = array_sum($second_weight);
		} else {
			$second_weight = "-";
		}
		if (is_numeric($volume)) {
			$volume = number_format($volume, 3, ',', '');
		}
		if (is_numeric($weight)) {
			$weight = number_format($weight, 3, ',', '');
		}
		if (is_numeric($volumetric_weight)) {
			$volumetric_weight = number_format($volumetric_weight, 3, ',', '');
		}
		if (is_numeric($second_weight)) {
			$second_weight = number_format($second_weight, 3, ',', '');
		}
		if (is_numeric($second_volume)) {
			$second_volume = number_format($second_volume, 3, ',', '');
		}
		if (is_numeric($ldm)) {
			$ldm = number_format($ldm, 3, ',', '');
		}
		$result_cargodetails = array('quantity' => $quantity, 'package_type' => $package_type, 'length' => $length, 'length_unit' => $length_unit, 'width' => $width, 'width_unit' => $width_unit, 'height' => $height, 'height_unit' => $height_unit, 'weight' => $weight,  'weight_unit' => $weight_unit,  'volume' => $volume, 'volume_unit' => $volume_unit,  'ldm' => $ldm, 'volumetric_weight' => $volumetric_weight, 'volweight_uom' => $volweight_uom,  'stackable' => $stackable, 'dg_goods' => $dg_goods, 'second_weight' => $second_weight, 'second_volume' => $second_volume);
		return $result_cargodetails;
	}
	public function getpayerdetails($recipient_code)
	{
		$company_code = $this->session->userdata('company_code');
		$payer_details = array('id' => "", 'name' => "", 'phone' => "", 'email' => "", 'code' => "", 'acon' => "", 'kn_login' => "", 'vat_reg_no' => "", 'tax_payer_no' => "", 'payer_postal' => "", 'payer_steeet_house' => "", 'payer_country' => "");
		$select = "id,name,mobile,email,code,customeridentifier,country,street,pincode,house_number,acon_debitor_code,kn_login_account,vat_reg_no,tax_payer_no";
		$getpayer = $this->common->gettblrowdata(array("code" => $recipient_code, "company_code" => $company_code, "status" => 1), $select, "tbl_party_master", 0, 0);
		if (!empty($getpayer)) {
			$payer_details = array('id' => $getpayer['customeridentifier'], 'name' => $getpayer['name'], 'phone' => $getpayer['mobile'], 'email' => $getpayer['email'], 'code' => $getpayer['code'], 'payer_country' => $getpayer['country'], 'acon' => $getpayer['acon_debitor_code'], 'kn_login' => $getpayer['kn_login_account'], 'vat_reg_no' => $getpayer['vat_reg_no'], 'tax_payer_no' => $getpayer['tax_payer_no'], 'payer_postal' => $getpayer['pincode'], 'payer_steeet_house' => $getpayer['street'] . " " . $getpayer['house_number']);
		}
		return $payer_details;
	}
	public function getcharges($revenue_id)
	{
		$charges = array();
		$getcharges = $this->truckwaybillmodel->getchargesbyrevid($revenue_id);
		if (!empty($getcharges)) {
			foreach ($getcharges as $getcharge) {
				if (is_numeric($getcharge['amount'])) {
					$getcharge['amount'] = number_format($getcharge['amount'], 4, ',', '');
				}
				if (is_numeric($getcharge['vat_percentage'])) {
					$getcharge['vat_percentage'] = number_format($getcharge['vat_percentage'], 2, ',', '');
				}
				if (is_numeric($getcharge['vat_amount'])) {
					$getcharge['vat_amount'] = number_format($getcharge['vat_amount'], 4, ',', '');
				}
				if (is_numeric($getcharge['total_amount'])) {
					$getcharge['total_amount'] = number_format($getcharge['total_amount'], 4, ',', '');
				}
				$charges[] = array('chargecode' => $getcharge['chargecode'], 'chargecodename' => $getcharge['chargecodename'], 'quantity' => $getcharge['quantity_unit'], 'value' => $getcharge['value'], 'rate_id' => $getcharge['rate_id'], 'amount' => $getcharge['amount'], 'currency' => $getcharge['currency'], 'vat_percentage' => $getcharge['vat_percentage'], 'vat_amount' => $getcharge['vat_amount'], 'total_amount' => $getcharge['total_amount']);
			}
		}
		return $charges;
	}
	public function getstatusdates($gene_order_id)
	{
		$zonecode = $this->session->userdata("usr_tzone");
		$curtz = $zonecode['timezone'];
		$data = array('statuspickupdate' => "", 'statusdeliverydate' => "");
		$getpicanddeldates = $this->truckwaybillmodel->getpicanddeldates($gene_order_id);
		if (!empty($getpicanddeldates)) {
			foreach ($getpicanddeldates as $getpicanddeldate) {
				if ($getpicanddeldate['stop_type'] == "P") {
					if ($getpicanddeldate['createdon'] != "") {
						$getactual = getdatetimebytimezone($curtz, $getpicanddeldate['createdon'], DFLT_TZ);
						$data['statuspickupdate'] = $getactual['datetime'];
					}
				}
				if ($getpicanddeldate['stop_type'] == "D") {
					if ($getpicanddeldate['createdon'] != "") {
						$getactual = getdatetimebytimezone($curtz, $getpicanddeldate['createdon'], DFLT_TZ);
						$data['statusdeliverydate'] = $getactual['datetime'];
					}
				}
			}
		}
		return $data;
	}
	
	public function get_cost_charges($order_id, $invoice)
	{
		$charges = array();
		$getcharges = $this->truckwaybillmodel->getcost_charges($order_id, $invoice);
		if (!empty($getcharges)) {
			foreach ($getcharges as $getcharge) {
				if (is_numeric($getcharge['amount'])) {
					$getcharge['amount'] = number_format($getcharge['amount'], 2, ',', '');
				}
				if (is_numeric($getcharge['vat_percentage'])) {
					$getcharge['vat_percentage'] = number_format($getcharge['vat_percentage'], 2, ',', '');
				}
				if (is_numeric($getcharge['vat_amount'])) {
					$getcharge['vat_amount'] = number_format($getcharge['vat_amount'], 4, ',', '');
				}
				if (is_numeric($getcharge['total_amount'])) {
					$getcharge['total_amount'] = number_format($getcharge['total_amount'], 4, ',', '');
				}
				$charges[] = array(
					'chargecode' => $getcharge['chargecode'],
					'chargecodename' => $getcharge['chargecodename'],
					'quantity' => $getcharge['quantity_unit'],
					'value' => $getcharge['value'],
					'rate_id' => $getcharge['rate_id'],
					'amount' => $getcharge['amount'],
					'currency' => $getcharge['currency'],
					'vat_percentage' => $getcharge['vat_percentage'],
					'vat_amount' => $getcharge['vat_amount'],
					'total_amount' => $getcharge['total_amount'],
					'debtor_jfr' => $getcharge['debtor_jfr'],
					'bu_jfr' => $getcharge['bu_jfr'],
					'exchange_rate' => $getcharge['exchange_rate'],
					'foreign_currency' => $getcharge['foreign_currency']
				);
			}
		}
		return $charges;
	}
}
