<?php

defined('BASEPATH') or exit('No direct script access allowed');

class CustomReportSetting extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        if (!checkUrlAccessForUser('CUSTOMREPORTSETTING')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(): void
    {
		$data = ['page_title' => $this->lang->line('custom_report_setting'), 'sub_title' => $this->lang->line('cust_search')];
        $whr = [];
		$where = [];
		$post = $this->input->post(NULL, TRUE);
        $whr['crs.company_code'] = $this->session->userdata('company_code');
        if (isset($post['searchsubmit']) && 'Search' === $post['searchsubmit']) {
			$where = $this->searchprofile($post);
            if (isset($post['reportname1']) && $post['reportname1'] != "") {
                $reportname1 = $post['reportname1'];
                $whr["crs.name"] = $reportname1;
            }
        }
        // getCustReportSettings uses Query Builder
        $data['cust_rprt_setgs'] = $this->common->getCustReportSettings($where, $whr);
        $this->newtemplate->dashboard("customreports/index", $data);
    }

    public function searchprofile(array $post)
    {
        $whr = array();
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(crs.created_on,'%Y-%m-%d') >="] = $fromdate;
        }
        if (isset($post['todate']) && $post['todate'] != "") {
            $todate = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(crs.created_on,'%Y-%m-%d') <="] = $todate;
        }
        if (isset($post['reportname']) && $post['reportname'] != "") {
            $reportname = $post['reportname'];
            $whr["crs.name="] = $reportname;
        }
        return $whr;
    }

    public function add(): void
    {
        $data["page_title"] = $this->lang->line('custom_report_setting');
        $data["sub_title"] = $this->lang->line('general_add');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        if ($company_code == "NZKN") {
            $data["selected_columns"] = [
                'Order ID',
                'Delivery Order No.',
                'Purchase Order No.',
                'Shipper Name',
                'Shipper Street and house number',
                'Shipper Province',
                'Shipper City',
                'Shipper Postal code',
                'Consignee Name',
                'Consignee Street and house number',
                'Consignee Province',
                'Consignee City',
                'Consignee Postal code',
                'Product',
                'Quantity',
                'Package Type',
                'Weight',
                'Weight Unit',
                'Volume',
                'Volume Unit',
                'Volumetric Weight',
                'Volumetric Weight Unit',
                'Reference 1 Name',
                'Reference 1 Description',
                'Reference 1 Value',
                'Reference 2 Name',
                'Reference 2 Description',
                'Reference 2 Value',
                'Reference 3 Name',
                'Reference 3 Description',
                'Reference 3 Value',
                'Reference 4 Name',
                'Reference 4 Description',
                'Reference 4 Value',
                'Reference 5 Name',
                'Reference 5 Description',
                'Reference 5 Value',
                'Status Picked-up Date and Time',
                'Status Delivered Date and Time',
                'Vehicle Number',
                'Trailer Number',
                'Vehicle Type',
                'Driver Name',
                'Revenue Charge Name',
                'Revenue Charge Quantity',
                'Revenue Charge Value',
                'Revenue  Charge Amount',
                'Revenue Charge Currency',
                'Revenue Charge VAT %',
                'Revenue Charge VAT Amount',
                'rev_chrg_total' => "Revenue Charge Total",
                'Revenue Invoice No.',
                'Revenue Invoice Date',
                'Revenue Credit Note Number',
                'Revenue Credit Note Date',
                'Customer Contract Number',
                'Customer Contract Date',
                'Last Status',
                'Last Status Location',
                'Last Status Time',
                'Accept status timestamp',
                'Gate in Pickup status timestamp',
                'Gate out status timestamp',
                'In transit status timestamp',
                'Gate in delivery status timestamp',
                'Gate out status timestamp'
            ];
            $data["columns"] = [
                'ord_id' => "Order ID",
                'delivery_ord_no' => "Delivery Order No.",
                'purchase_ord_no' => "Purchase Order No.",
                'ord_creation_dttme' => "Order Creation Date And Time",
                'ord_pickup_dttme' => "Order Pickup Date And Time",
                'ord_delivery_dttme' => "Order Delivery Date And Time",
                'shipr_id' => "Shipper ID",
                'shipr_cid' => "Shipper CID",
                'shipr_acon_debtor_code' => "Shipper ACON Debitor Code",
                'shipr_kn_login_account' => "Shipper KN Login Account",
                'shipr_vat_reg_no' => "Shipper VAT Registration Number",
                'shipr_tax_payer_id' => "Shipper Tax Payer ID",
                'shipr_name' => "Shipper Name",
                'shipr_steeet_and_house_no' => "Shipper Street and house number",
                'shipper_province' => "Shipper Province",
                'shipr_city' => "Shipper City",
                'shipr_postal_code' => "Shipper Postal code",
                'shippper_country_name' => "Shipper Country Name",
                'shipr_phone' => "Shipper Phone",
                'shipr_email' => "Shipper Email",
                'consignee_id' => "Consignee ID",
                'consignee_cid' => "Consignee CID",
                'consignee_acon_debtor_code' => "Consignee ACON Debitor Code",
                'consignee_kn_login_account' => "Consignee KN Login Account",
                'consignee_vat_reg_no' => "Consignee VAT Registration Number",
                'consignee_tax_payer_id' => "Consignee Tax Payer ID",
                'consignee_name' => "Consignee Name",
                'consignee_steeet_and_house_no' => "Consignee Street and house number",
                'consignee_province' => "Consignee Province",
                'consignee_city' => "Consignee City",
                'consignee_postal_code' => "Consignee Postal code",
                'consignee_country_name' => "Consignee Country Name",
                'consignee_phone' => "Consignee Phone",
                'consignee_email' => "Consignee Email",
                'customer_id' => "Customer ID",
                'customer_cid' => "Customer CID",
                'customer_acon_debtor_code' => "Customer ACON Debitor Code",
                'customer_kn_login_account' => "Customer KN Login Account",
                'customer_vat_reg_no' => "Customer VAT Registration Number",
                'customer_tax_payer_id' => "Customer Tax Payer ID",
                'customer_name' => "Customer Name",
                'customer_steeet_and_house_no' => "Customer Street and house number",
                'customer_postal_code' => "Customer Postal code",
                'customer_country_name' => "Customer Country Name",
                'customer_phone' => "Customer Phone",
                'customer_email' => "Customer Email",
                'country' => "Country",
                'branch' => "Branch",
                'department_code' => "Department Code",
                'product' => "Product",
                'service' => "Service",
                'incoterms' => "Incoterms",
                'delivery_terms' => "Delivery Terms",
                'delivery_note' => "Delivery Note",
                'notify_party' => "Notify Party",
                'ord_type' => "Booking Type",
                'mode_of_transport' => "Mode of Transport",
                'purchase_ord' => "Purchase Order",
                'qty' => "Quantity",
                'package_type' => "Package Type",
                'length' => "Length",
                'length_unit' => "Length Unit",
                'width' => "Width",
                'width_unit' => "Width Unit",
                'height' => "Height",
                'height_unit' => "Height Unit",
                'weight' => "Weight",
                'weight_unit' => "Weight Unit",
                'volume' => "Volume",
                'volume_unit' => "Volume Unit",
                'ldm' => "LDM",
                'volumetric_weight' => "Volumetric Weight",
                'volumetric_weight_unit' => "Volumetric Weight Unit",
                'stackable' => "Stackable",
                'dg_goods' => "DG Goods",
                'actual_weight' => "Actual Weight",
                'actual_weight_unit' => "Actual Weight Unit",
                'actual_volume' => "Actual Volume",
                'actual_volume_unit' => "Actual Volume Unit",
                'vas_1_name' => "Value added Service  1 Name",
                'vas_1_qty' => "Value added Service 1 - Quantity",
                'vas_2_name' => "Value added Service  2 Name",
                'vas_2_qty' => "Value added Service 2 - Quantity",
                'vas_3_name' => "Value added Service  3 Name",
                'vas_3_qty' => "Value added Service 3 - Quantity",
                'vas_4_name' => "Value added Service  4 Name",
                'vas_4_qty' => "Value added Service 4 - Quantity",
                'vas_5_name' => "Value added Service  5 Name",
                'vas_5_qty' => "Value added Service 5 - Quantity",
                'ref_1_name' => "Reference 1 Name",
                'ref_1_desc' => "Reference 1 Description",
                'ref_1_value' => "Reference 1 Value",
                'ref_2_name' => "Reference 2 Name",
                'ref_2_desc' => "Reference 2 Description",
                'ref_2_value' => "Reference 2 Value",
                'ref_3_name' => "Reference 3 Name",
                'ref_3_desc' => "Reference 3 Description",
                'ref_3_value' => "Reference 3 Value",
                'ref_4_name' => "Reference 4 Name",
                'ref_4_desc' => "Reference 4 Description",
                'ref_4_value' => "Reference 4 Value",
                'ref_5_name' => "Reference 5 Name",
                'ref_5_desc' => "Reference 5 Description",
                'ref_5_value' => "Reference 5 Value",
                'driver_pickup_inst' => "Driver Pickup Instructions",
                'driver_delivery_inst' => "Driver Delivery Instructions",
                'status_pickedup' => "Status Picked-up Date and Time",
                'status_delivered' => "Status Delivered Date and Time",
                'org_doc_received' => "Original Documents Received Date and Time",
                'org_doc_sent' => "Original Documents Sent Date and Time",
                'trip_id' => "Trip ID",
                'carrier' => "Carrier",
                'vehicle_no' => "Vehicle Number",
                'trailer_no' => "Trailer Number",
                'vehicle_type' => "Vehicle Type",
                'driver_name' => "Driver Name",
                'driver_number'=>"Driver Phone Number",
                'driver_licence_no' => "Driver Licence Number",
                'driver_address' => "Driver Address",
                'payer_role' => "Payer Role",
                'payer_id' => "Payer ID",
                'payer_name' => "Payer Name",
                'payer_cid' => "Payer CID",
                'payer_acon_debtor_code' => "Payer ACON Debitor Code",
                'payer_kn_login_account' => "Payer KN Login Account",
                'payer_vat_reg_no' => "Payer VAT Registration Number",
                'payer_tax_payer_id' => "Payer Tax payer ID",
                'payer_steeet_and_house_no' => "Payer Street and house number",
                'payer_postal_code' => "Payer Postal code",
                'payer_country_name' => "Payer Country Name",
                'payer_phone' => "Payer Phone",
                'payer_email' => "Payer Email",
                'rev_chrg_code' => "Revenue Charge Code",
                'rev_chrg_name' => "Revenue Charge Name",
                'rev_chrg_qty' => "Revenue Charge Quantity",
                'rev_chrg_value' => "Revenue Charge Value",
                'rev_chrg_rate_id' => "Revenue  Charge Rate ID",
                'rev_chrg_amount' => "Revenue  Charge Amount",
                'rev_chrg_currency' => "Revenue Charge Currency",
                'rev_chrg_vat' => "Revenue Charge VAT %",
                'rev_chrg_vat_amount' => "Revenue Charge VAT Amount",
                'rev_chrg_total' => "Revenue Charge Total",
                'rev_bu_jfr' => "Revenue BU JFR",
                'rev_jfr' => "Revenue JFR",
                'rev_exchange_rate' => "Revenue Exchange Rate",
                'rev_foreign_currency' => "Revenue Foreign Currency",
                'rev_invoice_no' => "Revenue Invoice No.",
                'rev_invoice_date' => "Revenue Invoice Date",
                'rev_credit_note_no' => "Revenue Credit Note Number",
                'rev_credit_note_date' => "Revenue Credit Note Date",
                'rev_invoice_creation_date' => "Revenue Invoice Creation Date",
                'rev_invoice_received_date' => "Revenue Invoice Received Date",
                'rev_status' => "Revenue Status",
                'customer_contract_no' => "Customer Contract Number",
                'customer_contract_date' => "Customer Contract Date",
                'invoice_status' => "Invoice Status",
                'suppier_role' => "Supplier Role",
                'suppier_id' => "Supplier ID",
                'suppier_name' => "Supplier Name",
                'suppier_steeet_and_house_no' => "Supplier Street and house number",
                'suppier_postal_code' => "Supplier Postal code",
                'suppier_country_name' => "Supplier Country Name",
                'suppier_phone' => "Supplier Phone",
                'suppier_email' => "Supplier Email",
                'cost_chrg_code' => "Cost Charge Code",
                'cost_chrg_name' => "Cost Charge Name",
                'cost_chrg_qty' => "Cost Charge Quantity",
                'cost_chrg_value' => "Cost Charge Value",
                'cost_chrg_rate_id' => "Cost  Charge Rate ID",
                'cost_chrg_amount' => "Cost  Charge Amount",
                'cost_chrg_currency' => "Cost Charge Currency",
                'cost_chrg_vat' => "Cost Charge VAT %",
                'cost_chrg_vat_amount' => "Cost Charge VAT Amount",
                'cost_bu_jfr' => "Cost BU JFR",
                'cost_jfr' => "Cost JFR",
                'cost_exchange_rate' => "Cost Exchange Rate",
                'cost_foreign_currency' => "Cost Foreign Currency",
                'salog_ref' => "Salog Ref No",
                'actual_pickup_date_time' => "Actual Pickup Date Time",
                'actual_delivery_date_time' => "Actual Delivery Date Time",
                'pod_status' => "POD",
                'order_status' => "Order Status",
                'last_status' => "Last Status",
                'last_status_location' => "Last Status Location",
                'last_status_time' => "Last Status Time",
                'trip_created_date' => "Trip Created Date and Time",
                'accept' => "Accept status timestamp",
                'gate_in_origin' => "Gate in Pickup status timestamp",
                'gate_out_origin' => "Gate out status timestamp",
                'in_transit' => "In transit status timestamp",
                'gate_in_dest' => "Gate in delivery status timestamp",
                'gate_out_dest' => "Gate out status timestamp",
                'transit_time_in_hours' => "Transit Time (Hours)",
                'rap_date' => "RAP Date",
                'rap_status' => "RAP",
                'bap' => "BAP",
                'remarks_issues' => "Remarks or Issues"
            ];
        }
        else {
            $data["selected_columns"] = [
                'Order ID',
                'Delivery Order No.',
                'Purchase Order No.',
                'Shipper Name',
                'Shipper Street and house number',
                'Shipper City',
                'Shipper Postal code',
                'Consignee Name',
                'Consignee Street and house number',
                'Consignee City',
                'Consignee Postal code',
                'Product',
                'Quantity',
                'Package Type',
                'Weight',
                'Weight Unit',
                'Volume',
                'Volume Unit',
                'Volumetric Weight',
                'Volumetric Weight Unit',
                'Reference 1 Name',
                'Reference 1 Description',
                'Reference 1 Value',
                'Reference 2 Name',
                'Reference 2 Description',
                'Reference 2 Value',
                'Reference 3 Name',
                'Reference 3 Description',
                'Reference 3 Value',
                'Reference 4 Name',
                'Reference 4 Description',
                'Reference 4 Value',
                'Reference 5 Name',
                'Reference 5 Description',
                'Reference 5 Value',
                'Status Picked-up Date and Time',
                'Status Delivered Date and Time',
                'Vehicle Number',
                'Trailer Number',
                'Vehicle Type',
                'Driver Name',
                'Revenue Charge Name',
                'Revenue Charge Quantity',
                'Revenue Charge Value',
                'Revenue  Charge Amount',
                'Revenue Charge Currency',
                'Revenue Charge VAT %',
                'Revenue Charge VAT Amount',
                'rev_chrg_total' => "Revenue Charge Total",
                'Revenue Invoice No.',
                'Revenue Invoice Date',
                'Revenue Credit Note Number',
                'Revenue Credit Note Date',
                'Customer Contract Number',
                'Customer Contract Date',
                'Last Status',
                'Last Status Location',
                'Last Status Time',
                'Accept status timestamp',
                'Gate in Pickup status timestamp',
                'Gate out status timestamp',
                'In transit status timestamp',
                'Gate in delivery status timestamp',
                'Gate out status timestamp'
            ];
            $data["columns"] = [
                'ord_id' => "Order ID",
                'delivery_ord_no' => "Delivery Order No.",
                'purchase_ord_no' => "Purchase Order No.",
                'ord_creation_dttme' => "Order Creation Date And Time",
                'ord_pickup_dttme' => "Order Pickup Date And Time",
                'ord_delivery_dttme' => "Order Delivery Date And Time",
                'shipr_id' => "Shipper ID",
                'shipr_cid' => "Shipper CID",
                'shipr_acon_debtor_code' => "Shipper ACON Debitor Code",
                'shipr_kn_login_account' => "Shipper KN Login Account",
                'shipr_vat_reg_no' => "Shipper VAT Registration Number",
                'shipr_tax_payer_id' => "Shipper Tax Payer ID",
                'shipr_name' => "Shipper Name",
                'shipr_steeet_and_house_no' => "Shipper Street and house number",
                'shipr_city' => "Shipper City",
                'shipr_postal_code' => "Shipper Postal code",
                'shippper_country_name' => "Shipper Country Name",
                'shipr_phone' => "Shipper Phone",
                'shipr_email' => "Shipper Email",
                'consignee_id' => "Consignee ID",
                'consignee_cid' => "Consignee CID",
                'consignee_acon_debtor_code' => "Consignee ACON Debitor Code",
                'consignee_kn_login_account' => "Consignee KN Login Account",
                'consignee_vat_reg_no' => "Consignee VAT Registration Number",
                'consignee_tax_payer_id' => "Consignee Tax Payer ID",
                'consignee_name' => "Consignee Name",
                'consignee_steeet_and_house_no' => "Consignee Street and house number",
                'consignee_city' => "Consignee City",
                'consignee_postal_code' => "Consignee Postal code",
                'consignee_country_name' => "Consignee Country Name",
                'consignee_phone' => "Consignee Phone",
                'consignee_email' => "Consignee Email",
                'customer_id' => "Customer ID",
                'customer_cid' => "Customer CID",
                'customer_acon_debtor_code' => "Customer ACON Debitor Code",
                'customer_kn_login_account' => "Customer KN Login Account",
                'customer_vat_reg_no' => "Customer VAT Registration Number",
                'customer_tax_payer_id' => "Customer Tax Payer ID",
                'customer_name' => "Customer Name",
                'customer_steeet_and_house_no' => "Customer Street and house number",
                'customer_postal_code' => "Customer Postal code",
                'customer_country_name' => "Customer Country Name",
                'customer_phone' => "Customer Phone",
                'customer_email' => "Customer Email",
                'country' => "Country",
                'branch' => "Branch",
                'department_code' => "Department Code",
                'product' => "Product",
                'service' => "Service",
                'incoterms' => "Incoterms",
                'delivery_terms' => "Delivery Terms",
                'delivery_note' => "Delivery Note",
                'notify_party' => "Notify Party",
                'ord_type' => "Booking Type",
                'mode_of_transport' => "Mode of Transport",
                'purchase_ord' => "Purchase Order",
                'qty' => "Quantity",
                'package_type' => "Package Type",
                'length' => "Length",
                'length_unit' => "Length Unit",
                'width' => "Width",
                'width_unit' => "Width Unit",
                'height' => "Height",
                'height_unit' => "Height Unit",
                'weight' => "Weight",
                'weight_unit' => "Weight Unit",
                'volume' => "Volume",
                'volume_unit' => "Volume Unit",
                'ldm' => "LDM",
                'volumetric_weight' => "Volumetric Weight",
                'volumetric_weight_unit' => "Volumetric Weight Unit",
                'stackable' => "Stackable",
                'dg_goods' => "DG Goods",
                'actual_weight' => "Actual Weight",
                'actual_weight_unit' => "Actual Weight Unit",
                'actual_volume' => "Actual Volume",
                'actual_volume_unit' => "Actual Volume Unit",
                'vas_1_name' => "Value added Service  1 Name",
                'vas_1_qty' => "Value added Service 1 - Quantity",
                'vas_2_name' => "Value added Service  2 Name",
                'vas_2_qty' => "Value added Service 2 - Quantity",
                'vas_3_name' => "Value added Service  3 Name",
                'vas_3_qty' => "Value added Service 3 - Quantity",
                'vas_4_name' => "Value added Service  4 Name",
                'vas_4_qty' => "Value added Service 4 - Quantity",
                'vas_5_name' => "Value added Service  5 Name",
                'vas_5_qty' => "Value added Service 5 - Quantity",
                'ref_1_name' => "Reference 1 Name",
                'ref_1_desc' => "Reference 1 Description",
                'ref_1_value' => "Reference 1 Value",
                'ref_2_name' => "Reference 2 Name",
                'ref_2_desc' => "Reference 2 Description",
                'ref_2_value' => "Reference 2 Value",
                'ref_3_name' => "Reference 3 Name",
                'ref_3_desc' => "Reference 3 Description",
                'ref_3_value' => "Reference 3 Value",
                'ref_4_name' => "Reference 4 Name",
                'ref_4_desc' => "Reference 4 Description",
                'ref_4_value' => "Reference 4 Value",
                'ref_5_name' => "Reference 5 Name",
                'ref_5_desc' => "Reference 5 Description",
                'ref_5_value' => "Reference 5 Value",
                'driver_pickup_inst' => "Driver Pickup Instructions",
                'driver_delivery_inst' => "Driver Delivery Instructions",
                'status_pickedup' => "Status Picked-up Date and Time",
                'status_delivered' => "Status Delivered Date and Time",
                'org_doc_received' => "Original Documents Received Date and Time",
                'org_doc_sent' => "Original Documents Sent Date and Time",
                'trip_id' => "Trip ID",
                'carrier' => "Carrier",
                'vehicle_no' => "Vehicle Number",
                'trailer_no' => "Trailer Number",
                'vehicle_type' => "Vehicle Type",
                'driver_name' => "Driver Name",
                'driver_number' => "Driver Phone Number",
                'driver_licence_no' => "Driver Licence Number",
                'driver_address' => "Driver Address",
                'payer_role' => "Payer Role",
                'payer_id' => "Payer ID",
                'payer_name' => "Payer Name",
                'payer_cid' => "Payer CID",
                'payer_acon_debtor_code' => "Payer ACON Debitor Code",
                'payer_kn_login_account' => "Payer KN Login Account",
                'payer_vat_reg_no' => "Payer VAT Registration Number",
                'payer_tax_payer_id' => "Payer Tax payer ID",
                'payer_steeet_and_house_no' => "Payer Street and house number",
                'payer_postal_code' => "Payer Postal code",
                'payer_country_name' => "Payer Country Name",
                'payer_phone' => "Payer Phone",
                'payer_email' => "Payer Email",
                'rev_chrg_code' => "Revenue Charge Code",
                'rev_chrg_name' => "Revenue Charge Name",
                'rev_chrg_qty' => "Revenue Charge Quantity",
                'rev_chrg_value' => "Revenue Charge Value",
                'rev_chrg_rate_id' => "Revenue  Charge Rate ID",
                'rev_chrg_amount' => "Revenue  Charge Amount",
                'rev_chrg_currency' => "Revenue Charge Currency",
                'rev_chrg_vat' => "Revenue Charge VAT %",
                'rev_chrg_vat_amount' => "Revenue Charge VAT Amount",
                'rev_chrg_total' => "Revenue Charge Total",
                'rev_bu_jfr' => "Revenue BU JFR",
                'rev_jfr' => "Revenue JFR",
                'rev_exchange_rate' => "Revenue Exchange Rate",
                'rev_foreign_currency' => "Revenue Foreign Currency",
                'rev_invoice_no' => "Revenue Invoice No.",
                'rev_invoice_date' => "Revenue Invoice Date",
                'rev_credit_note_no' => "Revenue Credit Note Number",
                'rev_credit_note_date' => "Revenue Credit Note Date",
                'rev_invoice_creation_date' => "Revenue Invoice Creation Date",
                'rev_invoice_received_date' => "Revenue Invoice Received Date",
                'rev_status' => "Revenue Status",
                'customer_contract_no' => "Customer Contract Number",
                'customer_contract_date' => "Customer Contract Date",
                'invoice_status' => "Invoice Status",
                'suppier_role' => "Supplier Role",
                'suppier_id' => "Supplier ID",
                'suppier_name' => "Supplier Name",
                'suppier_steeet_and_house_no' => "Supplier Street and house number",
                'suppier_postal_code' => "Supplier Postal code",
                'suppier_country_name' => "Supplier Country Name",
                'suppier_phone' => "Supplier Phone",
                'suppier_email' => "Supplier Email",
                'cost_chrg_code' => "Cost Charge Code",
                'cost_chrg_name' => "Cost Charge Name",
                'cost_chrg_qty' => "Cost Charge Quantity",
                'cost_chrg_value' => "Cost Charge Value",
                'cost_chrg_rate_id' => "Cost  Charge Rate ID",
                'cost_chrg_amount' => "Cost  Charge Amount",
                'cost_chrg_currency' => "Cost Charge Currency",
                'cost_chrg_vat' => "Cost Charge VAT %",
                'cost_chrg_vat_amount' => "Cost Charge VAT Amount",
                'cost_bu_jfr' => "Cost BU JFR",
                'cost_jfr' => "Cost JFR",
                'cost_exchange_rate' => "Cost Exchange Rate",
                'cost_foreign_currency' => "Cost Foreign Currency",
                'salog_ref' => "Salog Ref No",
                'actual_pickup_date_time' => "Actual Pickup Date Time",
                'actual_delivery_date_time' => "Actual Delivery Date Time",
                'pod_status' => "POD",
                'order_status' => "Order Status",
                'last_status' => "Last Status",
                'last_status_location' => "Last Status Location",
                'last_status_time' => "Last Status Time",
                'trip_created_date' => "Trip Created Date and Time",
                'accept' => "Accept status timestamp",
                'gate_in_origin' => "Gate in Pickup status timestamp",
                'gate_out_origin' => "Gate out status timestamp",
                'in_transit' => "In transit status timestamp",
                'gate_in_dest' => "Gate in delivery status timestamp",
                'gate_out_dest' => "Gate out status timestamp",
                'transit_time_in_hours' => "Transit Time (Hours)",
                'rap_date' => "RAP Date",
                'rap_status' => "RAP",
                'bap' => "BAP",
                'remarks_issues' => "Remarks or Issues"
            ];
        }
        $this->newtemplate->dashboard("customreports/add", $data);
    }


    public function edit(int $id)
    {
        $data["page_title"] = $this->lang->line('custom_report_setting');
        $data["sub_title"] = $this->lang->line('cutomer_edit');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['name'] = "";
        $data["custrprtsetng"] = array();
        $getcustrprtsetng = $this->common->gettblrowdata(array('id' => $id), '*', 'tb_custom_report_settings', 0, 0);
        if (!empty($getcustrprtsetng)) {
            $data['custrprtsetng'] = $getcustrprtsetng;
        }
        if ($company_code == "NZKN"){
            $data["columns"] = [
                'ord_id' => "Order ID",
                'delivery_ord_no' => "Delivery Order No.",
                'purchase_ord_no' => "Purchase Order No",
                'ord_creation_dttme' => "Order Creation Date And Time",
                'ord_pickup_dttme' => "Order Pickup Date And Time",
                'ord_delivery_dttme' => "Order Delivery Date And Time",
                'shipr_id' => "Shipper ID",
                'shipr_cid' => "Shipper CID",
                'shipr_acon_debtor_code' => "Shipper ACON Debitor Code",
                'shipr_kn_login_account' => "Shipper KN Login Account",
                'shipr_vat_reg_no' => "Shipper VAT Registration Number",
                'shipr_tax_payer_id' => "Shipper Tax Payer ID",
                'shipr_name' => "Shipper Name",
                'shipr_steeet_and_house_no' => "Shipper Street and house number",
                'shipper_province' => "Shipper Province",
                'shipr_city' => "Shipper City",
                'shipr_postal_code' => "Shipper Postal code",
                'shippper_country_name' => "Shipper Country Name",
                'shipr_phone' => "Shipper Phone",
                'shipr_email' => "Shipper Email",
                'consignee_id' => "Consignee ID",
                'consignee_cid' => "Consignee CID",
                'consignee_acon_debtor_code' => "Consignee ACON Debitor Code",
                'consignee_kn_login_account' => "Consignee KN Login Account",
                'consignee_vat_reg_no' => "Consignee VAT Registration Number",
                'consignee_tax_payer_id' => "Consignee Tax Payer ID",
                'consignee_name' => "Consignee Name",
                'consignee_steeet_and_house_no' => "Consignee Street and house number",
                'consignee_province' => "Consignee Province",
                'consignee_city' => "Consignee City",
                'consignee_postal_code' => "Consignee Postal code",
                'consignee_country_name' => "Consignee Country Name",
                'consignee_phone' => "Consignee Phone",
                'consignee_email' => "Consignee Email",
                'customer_id' => "Customer ID",
                'customer_cid' => "Customer CID",
                'customer_acon_debtor_code' => "Customer ACON Debitor Code",
                'customer_kn_login_account' => "Customer KN Login Account",
                'customer_vat_reg_no' => "Customer VAT Registration Number",
                'customer_tax_payer_id' => "Customer Tax Payer ID",
                'customer_name' => "Customer Name",
                'customer_steeet_and_house_no' => "Customer Street and house number",
                'customer_postal_code' => "Customer Postal code",
                'customer_country_name' => "Customer Country Name",
                'customer_phone' => "Customer Phone",
                'customer_email' => "Customer Email",
                'country' => "Country",
                'branch' => "Branch",
                'department_code' => "Department Code",
                'product' => "Product",
                'service' => "Service",
                'incoterms' => "Incoterms",
                'delivery_terms' => "Delivery Terms",
                'delivery_note' => "Delivery Note",
                'notify_party' => "Notify Party",
                'ord_type' => "Booking Type",
                'mode_of_transport' => "Mode of Transport",
                'purchase_ord' => "Purchase Order",
                'qty' => "Quantity",
                'package_type' => "Package Type",
                'length' => "Length",
                'length_unit' => "Length Unit",
                'width' => "Width",
                'width_unit' => "Width Unit",
                'height' => "Height",
                'height_unit' => "Height Unit",
                'weight' => "Weight",
                'weight_unit' => "Weight Unit",
                'volume' => "Volume",
                'volume_unit' => "Volume Unit",
                'ldm' => "LDM",
                'volumetric_weight' => "Volumetric Weight",
                'volumetric_weight_unit' => "Volumetric Weight Unit",
                'stackable' => "Stackable",
                'dg_goods' => "DG Goods",
                'actual_weight' => "Actual Weight",
                'actual_weight_unit' => "Actual Weight Unit",
                'actual_volume' => "Actual Volume",
                'actual_volume_unit' => "Actual Volume Unit",
                'vas_1_name' => "Value added Service  1 Name",
                'vas_1_qty' => "Value added Service 1 - Quantity",
                'vas_2_name' => "Value added Service  2 Name",
                'vas_2_qty' => "Value added Service 2 - Quantity",
                'vas_3_name' => "Value added Service  3 Name",
                'vas_3_qty' => "Value added Service 3 - Quantity",
                'vas_4_name' => "Value added Service  4 Name",
                'vas_4_qty' => "Value added Service 4 - Quantity",
                'vas_5_name' => "Value added Service  5 Name",
                'vas_5_qty' => "Value added Service 5 - Quantity",
                'ref_1_name' => "Reference 1 Name",
                'ref_1_desc' => "Reference 1 Description",
                'ref_1_value' => "Reference 1 Value",
                'ref_2_name' => "Reference 2 Name",
                'ref_2_desc' => "Reference 2 Description",
                'ref_2_value' => "Reference 2 Value",
                'ref_3_name' => "Reference 3 Name",
                'ref_3_desc' => "Reference 3 Description",
                'ref_3_value' => "Reference 3 Value",
                'ref_4_name' => "Reference 4 Name",
                'ref_4_desc' => "Reference 4 Description",
                'ref_4_value' => "Reference 4 Value",
                'ref_5_name' => "Reference 5 Name",
                'ref_5_desc' => "Reference 5 Description",
                'ref_5_value' => "Reference 5 Value",
                'driver_pickup_inst' => "Driver Pickup Instructions",
                'driver_delivery_inst' => "Driver Delivery Instructions",
                'status_pickedup' => "Status Picked-up Date and Time",
                'status_delivered' => "Status Delivered Date and Time",
                'org_doc_received' => "Original Documents Received Date and Time",
                'org_doc_sent' => "Original Documents Sent Date and Time",
                'trip_id' => "Trip ID",
                'carrier' => "Carrier",
                'vehicle_no' => "Vehicle Number",
                'trailer_no' => "Trailer Number",
                'vehicle_type' => "Vehicle Type",
                'driver_name' => "Driver Name",
                'driver_number'=>"Driver Phone Number",
                'driver_licence_no' => "Driver Licence Number",
                'driver_address' => "Driver Address",
                'payer_role' => "Payer Role",
                'payer_id' => "Payer ID",
                'payer_name' => "Payer Name",
                'payer_cid' => "Payer CID",
                'payer_acon_debtor_code' => "Payer ACON Debitor Code",
                'payer_kn_login_account' => "Payer KN Login Account",
                'payer_vat_reg_no' => "Payer VAT Registration Number",
                'payer_tax_payer_id' => "Payer Tax payer ID",
                'payer_steeet_and_house_no' => "Payer Street and house number",
                'payer_postal_code' => "Payer Postal code",
                'payer_country_name' => "Payer Country Name",
                'payer_phone' => "Payer Phone",
                'payer_email' => "Payer Email",
                'rev_chrg_code' => "Revenue Charge Code",
                'rev_chrg_name' => "Revenue Charge Name",
                'rev_chrg_qty' => "Revenue Charge Quantity",
                'rev_chrg_value' => "Revenue Charge Value",
                'rev_chrg_rate_id' => "Revenue  Charge Rate ID",
                'rev_chrg_amount' => "Revenue  Charge Amount",
                'rev_chrg_currency' => "Revenue Charge Currency",
                'rev_chrg_vat' => "Revenue Charge VAT %",
                'rev_chrg_vat_amount' => "Revenue Charge VAT Amount",
                'rev_chrg_total' => "Revenue Charge Total",
                'rev_bu_jfr' => "Revenue BU JFR",
                'rev_jfr' => "Revenue JFR",
                'rev_exchange_rate' => "Revenue Exchange Rate",
                'rev_foreign_currency' => "Revenue Foreign Currency",
                'rev_invoice_no' => "Revenue Invoice No.",
                'rev_invoice_date' => "Revenue Invoice Date",
                'rev_credit_note_no' => "Revenue Credit Note Number",
                'rev_credit_note_date' => "Revenue Credit Note Date",
                'rev_invoice_creation_date' => "Revenue Invoice Creation Date",
                'rev_invoice_received_date' => "Revenue Invoice Received Date",
                'rev_status' => "Revenue Status",
                'customer_contract_no' => "Customer Contract Number",
                'customer_contract_date' => "Customer Contract Date",
                'invoice_status' => "Invoice Status",
                'suppier_role' => "Supplier Role",
                'suppier_id' => "Supplier ID",
                'suppier_name' => "Supplier Name",
                'suppier_steeet_and_house_no' => "Supplier Street and house number",
                'suppier_postal_code' => "Supplier Postal code",
                'suppier_country_name' => "Supplier Country Name",
                'suppier_phone' => "Supplier Phone",
                'suppier_email' => "Supplier Email",
                'cost_chrg_code' => "Cost Charge Code",
                'cost_chrg_name' => "Cost Charge Name",
                'cost_chrg_qty' => "Cost Charge Quantity",
                'cost_chrg_value' => "Cost Charge Value",
                'cost_chrg_rate_id' => "Cost  Charge Rate ID",
                'cost_chrg_amount' => "Cost  Charge Amount",
                'cost_chrg_currency' => "Cost Charge Currency",
                'cost_chrg_vat' => "Cost Charge VAT %",
                'cost_chrg_vat_amount' => "Cost Charge VAT Amount",
                'cost_bu_jfr' => "Cost BU JFR",
                'cost_jfr' => "Cost JFR",
                'cost_exchange_rate' => "Cost Exchange Rate",
                'cost_foreign_currency' => "Cost Foreign Currency",
                'salog_ref' => "Salog Ref No",
                'actual_pickup_date_time' => "Actual Pickup Date Time",
                'actual_delivery_date_time' => "Actual Delivery Date Time",
                'pod_status' => "POD",
                'order_status' => "Order Status",
                'last_status' => "Last Status",
                'last_status_location' => "Last Status Location",
                'last_status_time' => "Last Status Time",
                'trip_created_date' => "Trip Created Date and Time",
                'accept' => "Accept status timestamp",
                'gate_in_origin' => "Gate in Pickup status timestamp",
                'gate_out_origin' => "Gate out status timestamp",
                'in_transit' => "In transit status timestamp",
                'gate_in_dest' => "Gate in delivery status timestamp",
                'gate_out_dest' => "Gate out status timestamp",
                'transit_time_in_hours' => "Transit Time (Hours)",
                'rap_date' => "RAP Date",
                'rap_status' => "RAP",
                'bap' => "BAP",
                'remarks_issues' => "Remarks or Issues"
            ];
        }
        else {
            $data["columns"] = [
                'ord_id' => "Order ID",
                'delivery_ord_no' => "Delivery Order No.",
                'purchase_ord_no' => "Purchase Order No",
                'ord_creation_dttme' => "Order Creation Date And Time",
                'ord_pickup_dttme' => "Order Pickup Date And Time",
                'ord_delivery_dttme' => "Order Delivery Date And Time",
                'shipr_id' => "Shipper ID",
                'shipr_cid' => "Shipper CID",
                'shipr_acon_debtor_code' => "Shipper ACON Debitor Code",
                'shipr_kn_login_account' => "Shipper KN Login Account",
                'shipr_vat_reg_no' => "Shipper VAT Registration Number",
                'shipr_tax_payer_id' => "Shipper Tax Payer ID",
                'shipr_name' => "Shipper Name",
                'shipr_steeet_and_house_no' => "Shipper Street and house number",
                'shipr_city' => "Shipper City",
                'shipr_postal_code' => "Shipper Postal code",
                'shippper_country_name' => "Shipper Country Name",
                'shipr_phone' => "Shipper Phone",
                'shipr_email' => "Shipper Email",
                'consignee_id' => "Consignee ID",
                'consignee_cid' => "Consignee CID",
                'consignee_acon_debtor_code' => "Consignee ACON Debitor Code",
                'consignee_kn_login_account' => "Consignee KN Login Account",
                'consignee_vat_reg_no' => "Consignee VAT Registration Number",
                'consignee_tax_payer_id' => "Consignee Tax Payer ID",
                'consignee_name' => "Consignee Name",
                'consignee_steeet_and_house_no' => "Consignee Street and house number",
                'consignee_city' => "Consignee City",
                'consignee_postal_code' => "Consignee Postal code",
                'consignee_country_name' => "Consignee Country Name",
                'consignee_phone' => "Consignee Phone",
                'consignee_email' => "Consignee Email",
                'customer_id' => "Customer ID",
                'customer_cid' => "Customer CID",
                'customer_acon_debtor_code' => "Customer ACON Debitor Code",
                'customer_kn_login_account' => "Customer KN Login Account",
                'customer_vat_reg_no' => "Customer VAT Registration Number",
                'customer_tax_payer_id' => "Customer Tax Payer ID",
                'customer_name' => "Customer Name",
                'customer_steeet_and_house_no' => "Customer Street and house number",
                'customer_postal_code' => "Customer Postal code",
                'customer_country_name' => "Customer Country Name",
                'customer_phone' => "Customer Phone",
                'customer_email' => "Customer Email",
                'country' => "Country",
                'branch' => "Branch",
                'department_code' => "Department Code",
                'product' => "Product",
                'service' => "Service",
                'incoterms' => "Incoterms",
                'delivery_terms' => "Delivery Terms",
                'delivery_note' => "Delivery Note",
                'notify_party' => "Notify Party",
                'ord_type' => "Booking Type",
                'mode_of_transport' => "Mode of Transport",
                'purchase_ord' => "Purchase Order",
                'qty' => "Quantity",
                'package_type' => "Package Type",
                'length' => "Length",
                'length_unit' => "Length Unit",
                'width' => "Width",
                'width_unit' => "Width Unit",
                'height' => "Height",
                'height_unit' => "Height Unit",
                'weight' => "Weight",
                'weight_unit' => "Weight Unit",
                'volume' => "Volume",
                'volume_unit' => "Volume Unit",
                'ldm' => "LDM",
                'volumetric_weight' => "Volumetric Weight",
                'volumetric_weight_unit' => "Volumetric Weight Unit",
                'stackable' => "Stackable",
                'dg_goods' => "DG Goods",
                'actual_weight' => "Actual Weight",
                'actual_weight_unit' => "Actual Weight Unit",
                'actual_volume' => "Actual Volume",
                'actual_volume_unit' => "Actual Volume Unit",
                'vas_1_name' => "Value added Service  1 Name",
                'vas_1_qty' => "Value added Service 1 - Quantity",
                'vas_2_name' => "Value added Service  2 Name",
                'vas_2_qty' => "Value added Service 2 - Quantity",
                'vas_3_name' => "Value added Service  3 Name",
                'vas_3_qty' => "Value added Service 3 - Quantity",
                'vas_4_name' => "Value added Service  4 Name",
                'vas_4_qty' => "Value added Service 4 - Quantity",
                'vas_5_name' => "Value added Service  5 Name",
                'vas_5_qty' => "Value added Service 5 - Quantity",
                'ref_1_name' => "Reference 1 Name",
                'ref_1_desc' => "Reference 1 Description",
                'ref_1_value' => "Reference 1 Value",
                'ref_2_name' => "Reference 2 Name",
                'ref_2_desc' => "Reference 2 Description",
                'ref_2_value' => "Reference 2 Value",
                'ref_3_name' => "Reference 3 Name",
                'ref_3_desc' => "Reference 3 Description",
                'ref_3_value' => "Reference 3 Value",
                'ref_4_name' => "Reference 4 Name",
                'ref_4_desc' => "Reference 4 Description",
                'ref_4_value' => "Reference 4 Value",
                'ref_5_name' => "Reference 5 Name",
                'ref_5_desc' => "Reference 5 Description",
                'ref_5_value' => "Reference 5 Value",
                'driver_pickup_inst' => "Driver Pickup Instructions",
                'driver_delivery_inst' => "Driver Delivery Instructions",
                'status_pickedup' => "Status Picked-up Date and Time",
                'status_delivered' => "Status Delivered Date and Time",
                'org_doc_received' => "Original Documents Received Date and Time",
                'org_doc_sent' => "Original Documents Sent Date and Time",
                'trip_id' => "Trip ID",
                'carrier' => "Carrier",
                'vehicle_no' => "Vehicle Number",
                'trailer_no' => "Trailer Number",
                'vehicle_type' => "Vehicle Type",
                'driver_name' => "Driver Name",
                'driver_number'=>"Driver Phone Number",
                'driver_licence_no' => "Driver Licence Number",
                'driver_address' => "Driver Address",
                'payer_role' => "Payer Role",
                'payer_id' => "Payer ID",
                'payer_name' => "Payer Name",
                'payer_cid' => "Payer CID",
                'payer_acon_debtor_code' => "Payer ACON Debitor Code",
                'payer_kn_login_account' => "Payer KN Login Account",
                'payer_vat_reg_no' => "Payer VAT Registration Number",
                'payer_tax_payer_id' => "Payer Tax payer ID",
                'payer_steeet_and_house_no' => "Payer Street and house number",
                'payer_postal_code' => "Payer Postal code",
                'payer_country_name' => "Payer Country Name",
                'payer_phone' => "Payer Phone",
                'payer_email' => "Payer Email",
                'rev_chrg_code' => "Revenue Charge Code",
                'rev_chrg_name' => "Revenue Charge Name",
                'rev_chrg_qty' => "Revenue Charge Quantity",
                'rev_chrg_value' => "Revenue Charge Value",
                'rev_chrg_rate_id' => "Revenue  Charge Rate ID",
                'rev_chrg_amount' => "Revenue  Charge Amount",
                'rev_chrg_currency' => "Revenue Charge Currency",
                'rev_chrg_vat' => "Revenue Charge VAT %",
                'rev_chrg_vat_amount' => "Revenue Charge VAT Amount",
                'rev_chrg_total' => "Revenue Charge Total",
                'rev_bu_jfr' => "Revenue BU JFR",
                'rev_jfr' => "Revenue JFR",
                'rev_exchange_rate' => "Revenue Exchange Rate",
                'rev_foreign_currency' => "Revenue Foreign Currency",
                'rev_invoice_no' => "Revenue Invoice No.",
                'rev_invoice_date' => "Revenue Invoice Date",
                'rev_credit_note_no' => "Revenue Credit Note Number",
                'rev_credit_note_date' => "Revenue Credit Note Date",
                'rev_invoice_creation_date' => "Revenue Invoice Creation Date",
                'rev_invoice_received_date' => "Revenue Invoice Received Date",
                'rev_status' => "Revenue Status",
                'customer_contract_no' => "Customer Contract Number",
                'customer_contract_date' => "Customer Contract Date",
                'invoice_status' => "Invoice Status",
                'suppier_role' => "Supplier Role",
                'suppier_id' => "Supplier ID",
                'suppier_name' => "Supplier Name",
                'suppier_steeet_and_house_no' => "Supplier Street and house number",
                'suppier_postal_code' => "Supplier Postal code",
                'suppier_country_name' => "Supplier Country Name",
                'suppier_phone' => "Supplier Phone",
                'suppier_email' => "Supplier Email",
                'cost_chrg_code' => "Cost Charge Code",
                'cost_chrg_name' => "Cost Charge Name",
                'cost_chrg_qty' => "Cost Charge Quantity",
                'cost_chrg_value' => "Cost Charge Value",
                'cost_chrg_rate_id' => "Cost  Charge Rate ID",
                'cost_chrg_amount' => "Cost  Charge Amount",
                'cost_chrg_currency' => "Cost Charge Currency",
                'cost_chrg_vat' => "Cost Charge VAT %",
                'cost_chrg_vat_amount' => "Cost Charge VAT Amount",
                'cost_bu_jfr' => "Cost BU JFR",
                'cost_jfr' => "Cost JFR",
                'cost_exchange_rate' => "Cost Exchange Rate",
                'cost_foreign_currency' => "Cost Foreign Currency",
                'salog_ref' => "Salog Ref No",
                'actual_pickup_date_time' => "Actual Pickup Date Time",
                'actual_delivery_date_time' => "Actual Delivery Date Time",
                'pod_status' => "POD",
                'order_status' => "Order Status",
                'last_status' => "Last Status",
                'last_status_location' => "Last Status Location",
                'last_status_time' => "Last Status Time",
                'trip_created_date' => "Trip Created Date and Time",
                'accept' => "Accept status timestamp",
                'gate_in_origin' => "Gate in Pickup status timestamp",
                'gate_out_origin' => "Gate out status timestamp",
                'in_transit' => "In transit status timestamp",
                'gate_in_dest' => "Gate in delivery status timestamp",
                'gate_out_dest' => "Gate out status timestamp",
                'transit_time_in_hours' => "Transit Time (Hours)",
                'rap_date' => "RAP Date",
                'rap_status' => "RAP",
                'bap' => "BAP",
                'remarks_issues' => "Remarks or Issues"
            ];
        }

        $this->newtemplate->dashboard("customreports/edit", $data);
    }

    public function view(int $id)
    {
        $data["page_title"] = $this->lang->line('custom_report_setting');
        $data["sub_title"] = $this->lang->line('cutomer_edit');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['name'] = "";
        $data["custrprtsetng"] = array();
        $getcustrprtsetng = $this->common->gettblrowdata(array('id' => $id), '*', 'tb_custom_report_settings', 0, 0);
        if (!empty($getcustrprtsetng)) {
            $data['custrprtsetng'] = $getcustrprtsetng;
        }
        if ($company_code == "NZKN") {
            $data["columns"] = [
                'ord_id' => "Order ID",
                'delivery_ord_no' => "Delivery Order No.",
                'purchase_ord_no' => "Purchase Order No",
                'ord_creation_dttme' => "Order Creation Date And Time",
                'ord_pickup_dttme' => "Order Pickup Date And Time",
                'ord_delivery_dttme' => "Order Delivery Date And Time",
                'shipr_id' => "Shipper ID",
                'shipr_cid' => "Shipper CID",
                'shipr_acon_debtor_code' => "Shipper ACON Debitor Code",
                'shipr_kn_login_account' => "Shipper KN Login Account",
                'shipr_vat_reg_no' => "Shipper VAT Registration Number",
                'shipr_tax_payer_id' => "Shipper Tax Payer ID",
                'shipr_name' => "Shipper Name",
                'shipr_steeet_and_house_no' => "Shipper Street and house number",
                'shipper_province' => "Shipper Province",
                'shipr_city' => "Shipper City",
                'shipr_postal_code' => "Shipper Postal code",
                'shippper_country_name' => "Shipper Country Name",
                'shipr_phone' => "Shipper Phone",
                'shipr_email' => "Shipper Email",
                'consignee_id' => "Consignee ID",
                'consignee_cid' => "Consignee CID",
                'consignee_acon_debtor_code' => "Consignee ACON Debitor Code",
                'consignee_kn_login_account' => "Consignee KN Login Account",
                'consignee_vat_reg_no' => "Consignee VAT Registration Number",
                'consignee_tax_payer_id' => "Consignee Tax Payer ID",
                'consignee_name' => "Consignee Name",
                'consignee_steeet_and_house_no' => "Consignee Street and house number",
                'consignee_province' => "Consignee Province",
                'consignee_city' => "Consignee City",
                'consignee_postal_code' => "Consignee Postal code",
                'consignee_country_name' => "Consignee Country Name",
                'consignee_phone' => "Consignee Phone",
                'consignee_email' => "Consignee Email",
                'customer_id' => "Customer ID",
                'customer_cid' => "Customer CID",
                'customer_acon_debtor_code' => "Customer ACON Debitor Code",
                'customer_kn_login_account' => "Customer KN Login Account",
                'customer_vat_reg_no' => "Customer VAT Registration Number",
                'customer_tax_payer_id' => "Customer Tax Payer ID",
                'customer_name' => "Customer Name",
                'customer_steeet_and_house_no' => "Customer Street and house number",
                'customer_postal_code' => "Customer Postal code",
                'customer_country_name' => "Customer Country Name",
                'customer_phone' => "Customer Phone",
                'customer_email' => "Customer Email",
                'country' => "Country",
                'branch' => "Branch",
                'department_code' => "Department Code",
                'product' => "Product",
                'service' => "Service",
                'incoterms' => "Incoterms",
                'delivery_terms' => "Delivery Terms",
                'delivery_note' => "Delivery Note",
                'notify_party' => "Notify Party",
                'ord_type' => "Booking Type",
                'mode_of_transport' => "Mode of Transport",
                'purchase_ord' => "Purchase Order",
                'qty' => "Quantity",
                'package_type' => "Package Type",
                'length' => "Length",
                'length_unit' => "Length Unit",
                'width' => "Width",
                'width_unit' => "Width Unit",
                'height' => "Height",
                'height_unit' => "Height Unit",
                'weight' => "Weight",
                'weight_unit' => "Weight Unit",
                'volume' => "Volume",
                'volume_unit' => "Volume Unit",
                'ldm' => "LDM",
                'volumetric_weight' => "Volumetric Weight",
                'volumetric_weight_unit' => "Volumetric Weight Unit",
                'stackable' => "Stackable",
                'dg_goods' => "DG Goods",
                'actual_weight' => "Actual Weight",
                'actual_weight_unit' => "Actual Weight Unit",
                'actual_volume' => "Actual Volume",
                'actual_volume_unit' => "Actual Volume Unit",
                'vas_1_name' => "Value added Service  1 Name",
                'vas_1_qty' => "Value added Service 1 - Quantity",
                'vas_2_name' => "Value added Service  2 Name",
                'vas_2_qty' => "Value added Service 2 - Quantity",
                'vas_3_name' => "Value added Service  3 Name",
                'vas_3_qty' => "Value added Service 3 - Quantity",
                'vas_4_name' => "Value added Service  4 Name",
                'vas_4_qty' => "Value added Service 4 - Quantity",
                'vas_5_name' => "Value added Service  5 Name",
                'vas_5_qty' => "Value added Service 5 - Quantity",
                'ref_1_name' => "Reference 1 Name",
                'ref_1_desc' => "Reference 1 Description",
                'ref_1_value' => "Reference 1 Value",
                'ref_2_name' => "Reference 2 Name",
                'ref_2_desc' => "Reference 2 Description",
                'ref_2_value' => "Reference 2 Value",
                'ref_3_name' => "Reference 3 Name",
                'ref_3_desc' => "Reference 3 Description",
                'ref_3_value' => "Reference 3 Value",
                'ref_4_name' => "Reference 4 Name",
                'ref_4_desc' => "Reference 4 Description",
                'ref_4_value' => "Reference 4 Value",
                'ref_5_name' => "Reference 5 Name",
                'ref_5_desc' => "Reference 5 Description",
                'ref_5_value' => "Reference 5 Value",
                'driver_pickup_inst' => "Driver Pickup Instructions",
                'driver_delivery_inst' => "Driver Delivery Instructions",
                'status_pickedup' => "Status Picked-up Date and Time",
                'status_delivered' => "Status Delivered Date and Time",
                'org_doc_received' => "Original Documents Received Date and Time",
                'org_doc_sent' => "Original Documents Sent Date and Time",
                'trip_id' => "Trip ID",
                'carrier' => "Carrier",
                'vehicle_no' => "Vehicle Number",
                'trailer_no' => "Trailer Number",
                'vehicle_type' => "Vehicle Type",
                'driver_name' => "Driver Name",
                'driver_number'=>"Driver Phone Number",
                'driver_licence_no' => "Driver Licence Number",
                'driver_address' => "Driver Address",
                'payer_role' => "Payer Role",
                'payer_id' => "Payer ID",
                'payer_name' => "Payer Name",
                'payer_cid' => "Payer CID",
                'payer_acon_debtor_code' => "Payer ACON Debitor Code",
                'payer_kn_login_account' => "Payer KN Login Account",
                'payer_vat_reg_no' => "Payer VAT Registration Number",
                'payer_tax_payer_id' => "Payer Tax payer ID",
                'payer_steeet_and_house_no' => "Payer Street and house number",
                'payer_postal_code' => "Payer Postal code",
                'payer_country_name' => "Payer Country Name",
                'payer_phone' => "Payer Phone",
                'payer_email' => "Payer Email",
                'rev_chrg_code' => "Revenue Charge Code",
                'rev_chrg_name' => "Revenue Charge Name",
                'rev_chrg_qty' => "Revenue Charge Quantity",
                'rev_chrg_value' => "Revenue Charge Value",
                'rev_chrg_rate_id' => "Revenue  Charge Rate ID",
                'rev_chrg_amount' => "Revenue  Charge Amount",
                'rev_chrg_currency' => "Revenue Charge Currency",
                'rev_chrg_vat' => "Revenue Charge VAT %",
                'rev_chrg_vat_amount' => "Revenue Charge VAT Amount",
                'rev_chrg_total' => "Revenue Charge Total",
                'rev_bu_jfr' => "Revenue BU JFR",
                'rev_jfr' => "Revenue JFR",
                'rev_exchange_rate' => "Revenue Exchange Rate",
                'rev_foreign_currency' => "Revenue Foreign Currency",
                'rev_invoice_no' => "Revenue Invoice No.",
                'rev_invoice_date' => "Revenue Invoice Date",
                'rev_credit_note_no' => "Revenue Credit Note Number",
                'rev_credit_note_date' => "Revenue Credit Note Date",
                'rev_invoice_creation_date' => "Revenue Invoice Creation Date",
                'rev_invoice_received_date' => "Revenue Invoice Received Date",
                'rev_status' => "Revenue Status",
                'customer_contract_no' => "Customer Contract Number",
                'customer_contract_date' => "Customer Contract Date",
                'invoice_status' => "Invoice Status",
                'suppier_role' => "Supplier Role",
                'suppier_id' => "Supplier ID",
                'suppier_name' => "Supplier Name",
                'suppier_steeet_and_house_no' => "Supplier Street and house number",
                'suppier_postal_code' => "Supplier Postal code",
                'suppier_country_name' => "Supplier Country Name",
                'suppier_phone' => "Supplier Phone",
                'suppier_email' => "Supplier Email",
                'cost_chrg_code' => "Cost Charge Code",
                'cost_chrg_name' => "Cost Charge Name",
                'cost_chrg_qty' => "Cost Charge Quantity",
                'cost_chrg_value' => "Cost Charge Value",
                'cost_chrg_rate_id' => "Cost  Charge Rate ID",
                'cost_chrg_amount' => "Cost  Charge Amount",
                'cost_chrg_currency' => "Cost Charge Currency",
                'cost_chrg_vat' => "Cost Charge VAT %",
                'cost_chrg_vat_amount' => "Cost Charge VAT Amount",
                'cost_bu_jfr' => "Cost BU JFR",
                'cost_jfr' => "Cost JFR",
                'cost_exchange_rate' => "Cost Exchange Rate",
                'cost_foreign_currency' => "Cost Foreign Currency",
                'salog_ref' => "Salog Ref No",
                'actual_pickup_date_time' => "Actual Pickup Date Time",
                'actual_delivery_date_time' => "Actual Delivery Date Time",
                'pod_status' => "POD",
                'order_status' => "Order Status",
                'last_status' => "Last Status",
                'last_status_location' => "Last Status Location",
                'last_status_time' => "Last Status Time",
                'trip_created_date'=>"Trip Created Date and Time",
                'accept' => "Accept status timestamp",
                'gate_in_origin' => "Gate in Pickup status timestamp",
                'gate_out_origin' => "Gate out status timestamp",
                'in_transit' => "In transit status timestamp",
                'gate_in_dest' => "Gate in delivery status timestamp",
                'gate_out_dest' => "Gate out status timestamp"
            ];

        }
        else {
            $data["columns"] = [
                'ord_id' => "Order ID",
                'delivery_ord_no' => "Delivery Order No.",
                'purchase_ord_no' => "Purchase Order No",
                'ord_creation_dttme' => "Order Creation Date And Time",
                'ord_pickup_dttme' => "Order Pickup Date And Time",
                'ord_delivery_dttme' => "Order Delivery Date And Time",
                'shipr_id' => "Shipper ID",
                'shipr_cid' => "Shipper CID",
                'shipr_acon_debtor_code' => "Shipper ACON Debitor Code",
                'shipr_kn_login_account' => "Shipper KN Login Account",
                'shipr_vat_reg_no' => "Shipper VAT Registration Number",
                'shipr_tax_payer_id' => "Shipper Tax Payer ID",
                'shipr_name' => "Shipper Name",
                'shipr_steeet_and_house_no' => "Shipper Street and house number",
                'shipr_city' => "Shipper City",
                'shipr_postal_code' => "Shipper Postal code",
                'shippper_country_name' => "Shipper Country Name",
                'shipr_phone' => "Shipper Phone",
                'shipr_email' => "Shipper Email",
                'consignee_id' => "Consignee ID",
                'consignee_cid' => "Consignee CID",
                'consignee_acon_debtor_code' => "Consignee ACON Debitor Code",
                'consignee_kn_login_account' => "Consignee KN Login Account",
                'consignee_vat_reg_no' => "Consignee VAT Registration Number",
                'consignee_tax_payer_id' => "Consignee Tax Payer ID",
                'consignee_name' => "Consignee Name",
                'consignee_steeet_and_house_no' => "Consignee Street and house number",
                'consignee_city' => "Consignee City",
                'consignee_postal_code' => "Consignee Postal code",
                'consignee_country_name' => "Consignee Country Name",
                'consignee_phone' => "Consignee Phone",
                'consignee_email' => "Consignee Email",
                'customer_id' => "Customer ID",
                'customer_cid' => "Customer CID",
                'customer_acon_debtor_code' => "Customer ACON Debitor Code",
                'customer_kn_login_account' => "Customer KN Login Account",
                'customer_vat_reg_no' => "Customer VAT Registration Number",
                'customer_tax_payer_id' => "Customer Tax Payer ID",
                'customer_name' => "Customer Name",
                'customer_steeet_and_house_no' => "Customer Street and house number",
                'customer_postal_code' => "Customer Postal code",
                'customer_country_name' => "Customer Country Name",
                'customer_phone' => "Customer Phone",
                'customer_email' => "Customer Email",
                'country' => "Country",
                'branch' => "Branch",
                'department_code' => "Department Code",
                'product' => "Product",
                'service' => "Service",
                'incoterms' => "Incoterms",
                'delivery_terms' => "Delivery Terms",
                'delivery_note' => "Delivery Note",
                'notify_party' => "Notify Party",
                'ord_type' => "Booking Type",
                'mode_of_transport' => "Mode of Transport",
                'purchase_ord' => "Purchase Order",
                'qty' => "Quantity",
                'package_type' => "Package Type",
                'length' => "Length",
                'length_unit' => "Length Unit",
                'width' => "Width",
                'width_unit' => "Width Unit",
                'height' => "Height",
                'height_unit' => "Height Unit",
                'weight' => "Weight",
                'weight_unit' => "Weight Unit",
                'volume' => "Volume",
                'volume_unit' => "Volume Unit",
                'ldm' => "LDM",
                'volumetric_weight' => "Volumetric Weight",
                'volumetric_weight_unit' => "Volumetric Weight Unit",
                'stackable' => "Stackable",
                'dg_goods' => "DG Goods",
                'actual_weight' => "Actual Weight",
                'actual_weight_unit' => "Actual Weight Unit",
                'actual_volume' => "Actual Volume",
                'actual_volume_unit' => "Actual Volume Unit",
                'vas_1_name' => "Value added Service  1 Name",
                'vas_1_qty' => "Value added Service 1 - Quantity",
                'vas_2_name' => "Value added Service  2 Name",
                'vas_2_qty' => "Value added Service 2 - Quantity",
                'vas_3_name' => "Value added Service  3 Name",
                'vas_3_qty' => "Value added Service 3 - Quantity",
                'vas_4_name' => "Value added Service  4 Name",
                'vas_4_qty' => "Value added Service 4 - Quantity",
                'vas_5_name' => "Value added Service  5 Name",
                'vas_5_qty' => "Value added Service 5 - Quantity",
                'ref_1_name' => "Reference 1 Name",
                'ref_1_desc' => "Reference 1 Description",
                'ref_1_value' => "Reference 1 Value",
                'ref_2_name' => "Reference 2 Name",
                'ref_2_desc' => "Reference 2 Description",
                'ref_2_value' => "Reference 2 Value",
                'ref_3_name' => "Reference 3 Name",
                'ref_3_desc' => "Reference 3 Description",
                'ref_3_value' => "Reference 3 Value",
                'ref_4_name' => "Reference 4 Name",
                'ref_4_desc' => "Reference 4 Description",
                'ref_4_value' => "Reference 4 Value",
                'ref_5_name' => "Reference 5 Name",
                'ref_5_desc' => "Reference 5 Description",
                'ref_5_value' => "Reference 5 Value",
                'driver_pickup_inst' => "Driver Pickup Instructions",
                'driver_delivery_inst' => "Driver Delivery Instructions",
                'status_pickedup' => "Status Picked-up Date and Time",
                'status_delivered' => "Status Delivered Date and Time",
                'org_doc_received' => "Original Documents Received Date and Time",
                'org_doc_sent' => "Original Documents Sent Date and Time",
                'trip_id' => "Trip ID",
                'carrier' => "Carrier",
                'vehicle_no' => "Vehicle Number",
                'trailer_no' => "Trailer Number",
                'vehicle_type' => "Vehicle Type",
                'driver_name' => "Driver Name",
                'driver_number'=>"Driver Phone Number",
                'driver_licence_no' => "Driver Licence Number",
                'driver_address' => "Driver Address",
                'payer_role' => "Payer Role",
                'payer_id' => "Payer ID",
                'payer_name' => "Payer Name",
                'payer_cid' => "Payer CID",
                'payer_acon_debtor_code' => "Payer ACON Debitor Code",
                'payer_kn_login_account' => "Payer KN Login Account",
                'payer_vat_reg_no' => "Payer VAT Registration Number",
                'payer_tax_payer_id' => "Payer Tax payer ID",
                'payer_steeet_and_house_no' => "Payer Street and house number",
                'payer_postal_code' => "Payer Postal code",
                'payer_country_name' => "Payer Country Name",
                'payer_phone' => "Payer Phone",
                'payer_email' => "Payer Email",
                'rev_chrg_code' => "Revenue Charge Code",
                'rev_chrg_name' => "Revenue Charge Name",
                'rev_chrg_qty' => "Revenue Charge Quantity",
                'rev_chrg_value' => "Revenue Charge Value",
                'rev_chrg_rate_id' => "Revenue  Charge Rate ID",
                'rev_chrg_amount' => "Revenue  Charge Amount",
                'rev_chrg_currency' => "Revenue Charge Currency",
                'rev_chrg_vat' => "Revenue Charge VAT %",
                'rev_chrg_vat_amount' => "Revenue Charge VAT Amount",
                'rev_chrg_total' => "Revenue Charge Total",
                'rev_bu_jfr' => "Revenue BU JFR",
                'rev_jfr' => "Revenue JFR",
                'rev_exchange_rate' => "Revenue Exchange Rate",
                'rev_foreign_currency' => "Revenue Foreign Currency",
                'rev_invoice_no' => "Revenue Invoice No.",
                'rev_invoice_date' => "Revenue Invoice Date",
                'rev_credit_note_no' => "Revenue Credit Note Number",
                'rev_credit_note_date' => "Revenue Credit Note Date",
                'rev_invoice_creation_date' => "Revenue Invoice Creation Date",
                'rev_invoice_received_date' => "Revenue Invoice Received Date",
                'rev_status' => "Revenue Status",
                'customer_contract_no' => "Customer Contract Number",
                'customer_contract_date' => "Customer Contract Date",
                'invoice_status' => "Invoice Status",
                'suppier_role' => "Supplier Role",
                'suppier_id' => "Supplier ID",
                'suppier_name' => "Supplier Name",
                'suppier_steeet_and_house_no' => "Supplier Street and house number",
                'suppier_postal_code' => "Supplier Postal code",
                'suppier_country_name' => "Supplier Country Name",
                'suppier_phone' => "Supplier Phone",
                'suppier_email' => "Supplier Email",
                'cost_chrg_code' => "Cost Charge Code",
                'cost_chrg_name' => "Cost Charge Name",
                'cost_chrg_qty' => "Cost Charge Quantity",
                'cost_chrg_value' => "Cost Charge Value",
                'cost_chrg_rate_id' => "Cost  Charge Rate ID",
                'cost_chrg_amount' => "Cost  Charge Amount",
                'cost_chrg_currency' => "Cost Charge Currency",
                'cost_chrg_vat' => "Cost Charge VAT %",
                'cost_chrg_vat_amount' => "Cost Charge VAT Amount",
                'cost_bu_jfr' => "Cost BU JFR",
                'cost_jfr' => "Cost JFR",
                'cost_exchange_rate' => "Cost Exchange Rate",
                'cost_foreign_currency' => "Cost Foreign Currency",
                'salog_ref' => "Salog Ref No",
                'actual_pickup_date_time' => "Actual Pickup Date Time",
                'actual_delivery_date_time' => "Actual Delivery Date Time",
                'pod_status' => "POD",
                'order_status' => "Order Status",
                'last_status' => "Last Status",
                'last_status_location' => "Last Status Location",
                'last_status_time' => "Last Status Time",
                'trip_created_date'=>"Trip Created Date and Time",
                'accept' => "Accept status timestamp",
                'gate_in_origin' => "Gate in Pickup status timestamp",
                'gate_out_origin' => "Gate out status timestamp",
                'in_transit' => "In transit status timestamp",
                'gate_in_dest' => "Gate in delivery status timestamp",
                'gate_out_dest' => "Gate out status timestamp"
            ];
        }

        $this->newtemplate->dashboard("customreports/view", $data);
    }

    public function delete(int $id): void
    {
        if ($id != '' && is_numeric($id)) {
            $update = $this->db->where(array('id' => $id))->update('tb_custom_report_settings', array('status' => 0));
            if ($update) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function save(): void
    {
        $post = $this->input->post(null, true);
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $curdt = date('Y-m-d H:i:s');
        $custaprl_id = $post['custaprl_id'] ?? 0;
        $reporter_name = $post['reporter_name'] ?? 0;
        $ord_id = $post['ord_id'] ?? 0;
        $delivery_ord_no = $post['delivery_ord_no'] ?? 0;
        $purchase_ord_no = $post['purchase_ord_no'] ?? 0;
        $ord_creation_dttme = $post['ord_creation_dttme'] ?? 0;
        $ord_pickup_dttme = $post['ord_pickup_dttme'] ?? 0;
        $ord_delivery_dttme = $post['ord_delivery_dttme'] ?? 0;
        $shipr_id = $post['shipr_id'] ?? 0;
        $shipr_cid = $post['shipr_cid'] ?? 0;
        $shipr_acon_debtor_code = $post['shipr_acon_debtor_code'] ?? 0;
        $shipr_kn_login_account = $post['shipr_kn_login_account'] ?? 0;
        $shipr_vat_reg_no = $post['shipr_vat_reg_no'] ?? 0;
        $shipr_tax_payer_id = $post['shipr_tax_payer_id'] ?? 0;
        $shipr_name = $post['shipr_name'] ?? 0;
        $shipr_steeet_and_house_no = $post['shipr_steeet_and_house_no'] ?? 0;
        $shipper_province = $post['shipper_province'] ?? 0;
        $shipr_city = $post['shipr_city'] ?? 0;
        $shipr_postal_code = $post['shipr_postal_code'] ?? 0;
        $shippper_country_name = $post['shippper_country_name'] ?? 0;
        $shipr_phone = $post['shipr_phone'] ?? 0;
        $shipr_email = $post['shipr_email'] ?? 0;
        $consignee_id = $post['consignee_id'] ?? 0;
        $consignee_cid = $post['consignee_cid'] ?? 0;
        $consignee_acon_debtor_code = $post['consignee_acon_debtor_code'] ?? 0;
        $consignee_kn_login_account = $post['consignee_kn_login_account'] ?? 0;
        $consignee_vat_reg_no = $post['consignee_vat_reg_no'] ?? 0;
        $consignee_tax_payer_id = $post['consignee_tax_payer_id'] ?? 0;
        $consignee_name = $post['consignee_name'] ?? 0;
        $consignee_steeet_and_house_no = $post['consignee_steeet_and_house_no'] ?? 0;
        $consignee_province = $post['consignee_province'] ?? 0;
        $consignee_city = $post['consignee_city'] ?? 0;
        $consignee_postal_code = $post['consignee_postal_code'] ?? 0;
        $consignee_country_name = $post['consignee_country_name'] ?? 0;
        $consignee_phone = $post['consignee_phone'] ?? 0;
        $consignee_email = $post['consignee_email'] ?? 0;
        $customer_id = $post['customer_id'] ?? 0;
        $customer_cid = $post['customer_cid'] ?? 0;
        $customer_acon_debtor_code = $post['customer_acon_debtor_code'] ?? 0;
        $customer_kn_login_account = $post['customer_kn_login_account'] ?? 0;
        $customer_vat_reg_no = $post['customer_vat_reg_no'] ?? 0;
        $customer_tax_payer_id = $post['customer_tax_payer_id'] ?? 0;
        $customer_name = $post['customer_name'] ?? 0;
        $customer_steeet_and_house_no = $post['customer_steeet_and_house_no'] ?? 0;
        $customer_postal_code = $post['customer_postal_code'] ?? 0;
        $customer_country_name = $post['customer_country_name'] ?? 0;
        $customer_phone = $post['customer_phone'] ?? 0;
        $customer_email = $post['customer_email'] ?? 0;
        $country = $post['country'] ?? 0;
        $branch = $post['branch'] ?? 0;
        $department_code = $post['department_code'] ?? 0;
        $product = $post['product'] ?? 0;
        $service = $post['service'] ?? 0;
        $incoterms = $post['incoterms'] ?? 0;
        $delivery_terms = $post['delivery_terms'] ?? 0;
        $delivery_note = $post['delivery_note'] ?? 0;
        $notify_party = $post['notify_party'] ?? 0;
        $ord_type = $post['ord_type'] ?? 0;
        $mode_of_transport = $post['mode_of_transport'] ?? 0;
        $purchase_ord = $post['purchase_ord'] ?? 0;
        $qty = $post['qty'] ?? 0;
        $package_type = $post['package_type'] ?? 0;
        $length = $post['length'] ?? 0;
        $length_unit = $post['length_unit'] ?? 0;
        $width = $post['width'] ?? 0;
        $width_unit = $post['width_unit'] ?? 0;
        $height = $post['height'] ?? 0;
        $height_unit = $post['height_unit'] ?? 0;
        $weight = $post['weight'] ?? 0;
        $weight_unit = $post['weight_unit'] ?? 0;
        $volume = $post['volume'] ?? 0;
        $volume_unit = $post['volume_unit'] ?? 0;
        $ldm = $post['ldm'] ?? 0;
        $volumetric_weight = $post['volumetric_weight'] ?? 0;
        $volumetric_weight_unit = $post['volumetric_weight_unit'] ?? 0;
        $stackable = $post['stackable'] ?? 0;
        $dg_goods = $post['dg_goods'] ?? 0;
        $actual_weight = $post['actual_weight'] ?? 0;
        $actual_weight_unit = $post['actual_weight_unit'] ?? 0;
        $actual_volume = $post['actual_volume'] ?? 0;
        $actual_volume_unit = $post['actual_volume_unit'] ?? 0;
        $vas_1_name = $post['vas_1_name'] ?? 0;
        $vas_1_qty = $post['vas_1_qty'] ?? 0;
        $vas_2_name = $post['vas_2_name'] ?? 0;
        $vas_2_qty = $post['vas_2_qty'] ?? 0;
        $vas_3_name = $post['vas_3_name'] ?? 0;
        $vas_3_qty = $post['vas_3_qty'] ?? 0;
        $vas_4_name = $post['vas_4_name'] ?? 0;
        $vas_4_qty = $post['vas_4_qty'] ?? 0;
        $vas_5_name = $post['vas_5_name'] ?? 0;
        $vas_5_qty = $post['vas_5_qty'] ?? 0;
        $ref_1_name = $post['ref_1_name'] ?? 0;
        $ref_1_desc = $post['ref_1_desc'] ?? 0;
        $ref_1_value = $post['ref_1_value'] ?? 0;
        $ref_2_name = $post['ref_2_name'] ?? 0;
        $ref_2_desc = $post['ref_2_desc'] ?? 0;
        $ref_2_value = $post['ref_2_value'] ?? 0;
        $ref_3_name = $post['ref_3_name'] ?? 0;
        $ref_3_desc = $post['ref_3_desc'] ?? 0;
        $ref_3_value = $post['ref_3_value'] ?? 0;
        $ref_4_name = $post['ref_4_name'] ?? 0;
        $ref_4_desc = $post['ref_4_desc'] ?? 0;
        $ref_4_value = $post['ref_4_value'] ?? 0;
        $ref_5_name = $post['ref_5_name'] ?? 0;
        $ref_5_desc = $post['ref_5_desc'] ?? 0;
        $ref_5_value = $post['ref_5_value'] ?? 0;
        $driver_pickup_inst = $post['driver_pickup_inst'] ?? 0;
        $driver_delivery_inst = $post['driver_delivery_inst'] ?? 0;
        $status_pickedup = $post['status_pickedup'] ?? 0;
        $status_delivered = $post['status_delivered'] ?? 0;
        $org_doc_received = $post['org_doc_received'] ?? 0;
        $org_doc_sent = $post['org_doc_sent'] ?? 0;
        $trip_id = $post['trip_id'] ?? 0;
        $carrier = $post['carrier'] ?? 0;
        $vehicle_no = $post['vehicle_no'] ?? 0;
        $trailer_no = $post['trailer_no'] ?? 0;
        $vehicle_type = $post['vehicle_type'] ?? 0;
        $driver_name = $post['driver_name'] ?? 0;
        $driver_number = $post['driver_number'] ?? 0;
        $driver_licence_no = $post['driver_licence_no'] ?? 0;
        $driver_address = $post['driver_address'] ?? 0;
        $payer_role = $post['payer_role'] ?? 0;
        $payer_id = $post['payer_id'] ?? 0;
        $payer_name = $post['payer_name'] ?? 0;
        $payer_cid = $post['payer_cid'] ?? 0;
        $payer_acon_debtor_code = $post['payer_acon_debtor_code'] ?? 0;
        $payer_kn_login_account = $post['payer_kn_login_account'] ?? 0;
        $payer_vat_reg_no = $post['payer_vat_reg_no'] ?? 0;
        $payer_tax_payer_id = $post['payer_tax_payer_id'] ?? 0;
        $payer_steeet_and_house_no = $post['payer_steeet_and_house_no'] ?? 0;
        $payer_postal_code = $post['payer_postal_code'] ?? 0;
        $payer_country_name = $post['payer_country_name'] ?? 0;
        $payer_phone = $post['payer_phone'] ?? 0;
        $payer_email = $post['payer_email'] ?? 0;
        $rev_chrg_code = $post['rev_chrg_code'] ?? 0;
        $rev_chrg_name = $post['rev_chrg_name'] ?? 0;
        $rev_chrg_qty = $post['rev_chrg_qty'] ?? 0;
        $rev_chrg_value = $post['rev_chrg_value'] ?? 0;
        $rev_chrg_rate_id = $post['rev_chrg_rate_id'] ?? 0;
        $rev_chrg_amount = $post['rev_chrg_amount'] ?? 0;
        $rev_chrg_currency = $post['rev_chrg_currency'] ?? 0;
        $rev_chrg_vat = $post['rev_chrg_vat'] ?? 0;
        $rev_chrg_vat_amount = $post['rev_chrg_vat_amount'] ?? 0;
        $rev_chrg_total = $post['rev_chrg_total'] ?? 0;
        $rev_bu_jfr = $post['rev_bu_jfr'] ?? 0;
        $rev_jfr = $post['rev_jfr'] ?? 0;
        $rev_exchange_rate = $post['rev_exchange_rate'] ?? 0;
        $rev_foreign_currency = $post['rev_foreign_currency'] ?? 0;
        $rev_invoice_no = $post['rev_invoice_no'] ?? 0;
        $rev_invoice_date = $post['rev_invoice_date'] ?? 0;
        $rev_credit_note_no = $post['rev_credit_note_no'] ?? 0;
        $rev_credit_note_date = $post['rev_credit_note_date'] ?? 0;
        $rev_invoice_creation_date = $post['rev_invoice_creation_date'] ?? 0;
        $rev_invoice_received_date = $post['rev_invoice_received_date'] ?? 0;
        $rev_status = $post['rev_status'] ?? 0;
        $customer_contract_no = $post['customer_contract_no'] ?? 0;
        $customer_contract_date = $post['customer_contract_date'] ?? 0;
        $invoice_status = $post['invoice_status'] ?? 0;
        $suppier_role = $post['suppier_role'] ?? 0;
        $suppier_id = $post['suppier_id'] ?? 0;
        $suppier_name = $post['suppier_name'] ?? 0;
        $suppier_steeet_and_house_no = $post['suppier_steeet_and_house_no'] ?? 0;
        $suppier_postal_code = $post['suppier_postal_code'] ?? 0;
        $suppier_country_name = $post['suppier_country_name'] ?? 0;
        $suppier_phone = $post['suppier_phone'] ?? 0;
        $suppier_email = $post['suppier_email'] ?? 0;
        $cost_chrg_code = $post['cost_chrg_code'] ?? 0;
        $cost_chrg_name = $post['cost_chrg_name'] ?? 0;
        $cost_chrg_qty = $post['cost_chrg_qty'] ?? 0;
        $cost_chrg_value = $post['cost_chrg_value'] ?? 0;
        $cost_chrg_rate_id = $post['cost_chrg_rate_id'] ?? 0;
        $cost_chrg_amount = $post['cost_chrg_amount'] ?? 0;
        $cost_chrg_currency = $post['cost_chrg_currency'] ?? 0;
        $cost_chrg_vat = $post['cost_chrg_vat'] ?? 0;
        $cost_chrg_vat_amount = $post['cost_chrg_vat_amount'] ?? 0;
        $cost_bu_jfr = $post['cost_bu_jfr'] ?? 0;
        $cost_jfr = $post['cost_jfr'] ?? 0;
        $cost_exchange_rate = $post['cost_exchange_rate'] ?? 0;
        $cost_foreign_currency = $post['cost_foreign_currency'] ?? 0;
        $salog_ref = $post['salog_ref'] ?? 0;
        $actual_pickup_date_time = $post['actual_pickup_date_time'] ?? 0;
        $actual_delivery_date_time = $post['actual_delivery_date_time'] ?? 0;
        $pod_status = $post['pod_status'] ?? 0;
        $order_status = $post['order_status'] ?? 0;
        $trip_created_date = $post['trip_created_date'] ?? 0;
        $accept = $post['accept'] ?? 0;
        $gate_in_origin = $post['gate_in_origin'] ?? 0;
        $gate_out_origin = $post['gate_out_origin'] ?? 0;
        $in_transit = $post['in_transit'] ?? 0;
        $gate_in_dest = $post['gate_in_dest'] ?? 0;
        $gate_out_dest = $post['gate_out_dest'] ?? 0;
        $last_Status = $post['last_status'] ?? 0;
        $last_Status_Location = $post['last_status_location'] ?? 0;
        $last_Status_Time = $post['last_status_time'] ?? 0;
        $transit_time_in_hours  = $post['transit_time_in_hours'] ?? 0;
        $rap_date               = $post['rap_date'] ?? 0;
        $rap_status             = $post['rap_status'] ?? 0;
        $bap                    = $post['bap'] ?? 0;
        $remarks_issues         = $post['remarks_issues'] ?? 0;

        /*sequence fields */
        $ord_id_seq = $post['ord_id_seq'] ?? 0;
        $delivery_ord_no_seq = $post['delivery_ord_no_seq'] ?? 0;
        $purchase_ord_no_seq = $post['purchase_ord_no_seq'] ?? 0;
        $ord_creation_dttme_seq = $post['ord_creation_dttme_seq'] ?? 0;
        $ord_pickup_dttme_seq = $post['ord_pickup_dttme_seq'] ?? 0;
        $ord_delivery_dttme_seq = $post['ord_delivery_dttme_seq'] ?? 0;
        $shipr_id_seq = $post['shipr_id_seq'] ?? 0;
        $shipr_cid_seq = $post['shipr_cid_seq'] ?? 0;
        $shipr_acon_debtor_code_seq = $post['shipr_acon_debtor_code_seq'] ?? 0;
        $shipr_kn_login_account_seq = $post['shipr_kn_login_account_seq'] ?? 0;
        $shipr_vat_reg_no_seq = $post['shipr_vat_reg_no_seq'] ?? 0;
        $shipr_tax_payer_id_seq = $post['shipr_tax_payer_id_seq'] ?? 0;
        $shipr_name_seq = $post['shipr_name_seq'] ?? 0;
        $shipr_steeet_and_house_no_seq = $post['shipr_steeet_and_house_no_seq'] ?? 0;
        $shipper_province_seq = $post['shipper_province_seq'] ?? 0;
        $shipr_city_seq = $post['shipr_city_seq'] ?? 0;
        $shipr_postal_code_seq = $post['shipr_postal_code_seq'] ?? 0;
        $shippper_country_name_seq = $post['shippper_country_name_seq'] ?? 0;
        $shipr_phone_seq = $post['shipr_phone_seq'] ?? 0;
        $shipr_email_seq = $post['shipr_email_seq'] ?? 0;
        $consignee_id_seq = $post['consignee_id_seq'] ?? 0;
        $consignee_cid_seq = $post['consignee_cid_seq'] ?? 0;
        $consignee_acon_debtor_code_seq = $post['consignee_acon_debtor_code_seq'] ?? 0;
        $consignee_kn_login_account_seq = $post['consignee_kn_login_account_seq'] ?? 0;
        $consignee_vat_reg_no_seq = $post['consignee_vat_reg_no_seq'] ?? 0;
        $consignee_tax_payer_id_seq = $post['consignee_tax_payer_id_seq'] ?? 0;
        $consignee_name_seq = $post['consignee_name_seq'] ?? 0;
        $consignee_steeet_and_house_no_seq = $post['consignee_steeet_and_house_no_seq'] ?? 0;
        $consignee_province_seq = $post['consignee_province_seq'] ?? 0;
        $consignee_city_seq = $post['consignee_city_seq'] ?? 0;
        $consignee_postal_code_seq = $post['consignee_postal_code_seq'] ?? 0;
        $consignee_country_name_seq = $post['consignee_country_name_seq'] ?? 0;
        $consignee_phone_seq = $post['consignee_phone_seq'] ?? 0;
        $consignee_email_seq = $post['consignee_email_seq'] ?? 0;
        $customer_id_seq = $post['customer_id_seq'] ?? 0;
        $customer_cid_seq = $post['customer_cid_seq'] ?? 0;
        $customer_acon_debtor_code_seq = $post['customer_acon_debtor_code_seq'] ?? 0;
        $customer_kn_login_account_seq = $post['customer_kn_login_account_seq'] ?? 0;
        $customer_vat_reg_no_seq = $post['customer_vat_reg_no_seq'] ?? 0;
        $customer_tax_payer_id_seq = $post['customer_tax_payer_id_seq'] ?? 0;
        $customer_name_seq = $post['customer_name_seq'] ?? 0;
        $customer_steeet_and_house_no_seq = $post['customer_steeet_and_house_no_seq'] ?? 0;
        $customer_postal_code_seq = $post['customer_postal_code_seq'] ?? 0;
        $customer_country_name_seq = $post['customer_country_name_seq'] ?? 0;
        $customer_phone_seq = $post['customer_phone_seq'] ?? 0;
        $customer_email_seq = $post['customer_email_seq'] ?? 0;
        $country_seq = $post['country_seq'] ?? 0;
        $branch_seq = $post['branch_seq'] ?? 0;
        $department_code_seq = $post['department_code_seq'] ?? 0;
        $product_seq = $post['product_seq'] ?? 0;
        $service_seq = $post['service_seq'] ?? 0;
        $incoterms_seq = $post['incoterms_seq'] ?? 0;
        $delivery_terms_seq = $post['delivery_terms_seq'] ?? 0;
        $delivery_note_seq = $post['delivery_note_seq'] ?? 0;
        $notify_party_seq = $post['notify_party_seq'] ?? 0;
        $ord_type_seq = $post['ord_type_seq'] ?? 0;
        $mode_of_transport_seq = $post['mode_of_transport_seq'] ?? 0;
        $purchase_ord_seq = $post['purchase_ord_seq'] ?? 0;
        $qty_seq = $post['qty_seq'] ?? 0;
        $package_type_seq = $post['package_type_seq'] ?? 0;
        $length_seq = $post['length_seq'] ?? 0;
        $length_unit_seq = $post['length_unit_seq'] ?? 0;
        $width_seq = $post['width_seq'] ?? 0;
        $width_unit_seq = $post['width_unit_seq'] ?? 0;
        $height_seq = $post['height_seq'] ?? 0;
        $height_unit_seq = $post['height_unit_seq'] ?? 0;
        $weight_seq = $post['weight_seq'] ?? 0;
        $weight_unit_seq = $post['weight_unit_seq'] ?? 0;
        $volume_seq = $post['volume_seq'] ?? 0;
        $volume_unit_seq = $post['volume_unit_seq'] ?? 0;
        $ldm_seq = $post['ldm_seq'] ?? 0;
        $volumetric_weight_seq = $post['volumetric_weight_seq'] ?? 0;
        $volumetric_weight_unit_seq = $post['volumetric_weight_unit_seq'] ?? 0;
        $stackable_seq = $post['stackable_seq'] ?? 0;
        $dg_goods_seq = $post['dg_goods_seq'] ?? 0;
        $actual_weight_seq = $post['actual_weight_seq'] ?? 0;
        $actual_weight_unit_seq = $post['actual_weight_unit_seq'] ?? 0;
        $actual_volume_seq = $post['actual_volume_seq'] ?? 0;
        $actual_volume_unit_seq = $post['actual_volume_unit_seq'] ?? 0;
        $vas_1_name_seq = $post['vas_1_name_seq'] ?? 0;
        $vas_1_qty_seq = $post['vas_1_qty_seq'] ?? 0;
        $vas_2_name_seq = $post['vas_2_name_seq'] ?? 0;
        $vas_2_qty_seq = $post['vas_2_qty_seq'] ?? 0;
        $vas_3_name_seq = $post['vas_3_name_seq'] ?? 0;
        $vas_3_qty_seq = $post['vas_3_qty_seq'] ?? 0;
        $vas_4_name_seq = $post['vas_4_name_seq'] ?? 0;
        $vas_4_qty_seq = $post['vas_4_qty_seq'] ?? 0;
        $vas_5_name_seq = $post['vas_5_name_seq'] ?? 0;
        $vas_5_qty_seq = $post['vas_5_qty_seq'] ?? 0;
        $ref_1_name_seq = $post['ref_1_name_seq'] ?? 0;
        $ref_1_desc_seq = $post['ref_1_desc_seq'] ?? 0;
        $ref_1_value_seq = $post['ref_1_value_seq'] ?? 0;
        $ref_2_name_seq = $post['ref_2_name_seq'] ?? 0;
        $ref_2_desc_seq = $post['ref_2_desc_seq'] ?? 0;
        $ref_2_value_seq = $post['ref_2_value_seq'] ?? 0;
        $ref_3_name_seq = $post['ref_3_name_seq'] ?? 0;
        $ref_3_desc_seq = $post['ref_3_desc_seq'] ?? 0;
        $ref_3_value_seq = $post['ref_3_value_seq'] ?? 0;
        $ref_4_name_seq = $post['ref_4_name_seq'] ?? 0;
        $ref_4_desc_seq = $post['ref_4_desc_seq'] ?? 0;
        $ref_4_value_seq = $post['ref_4_value_seq'] ?? 0;
        $ref_5_name_seq = $post['ref_5_name_seq'] ?? 0;
        $ref_5_desc_seq = $post['ref_5_desc_seq'] ?? 0;
        $ref_5_value_seq = $post['ref_5_value_seq'] ?? 0;
        $driver_pickup_inst_seq = $post['driver_pickup_inst_seq'] ?? 0;
        $driver_delivery_inst_seq = $post['driver_delivery_inst_seq'] ?? 0;
        $status_pickedup_seq = $post['status_pickedup_seq'] ?? 0;
        $status_delivered_seq = $post['status_delivered_seq'] ?? 0;
        $org_doc_received_seq = $post['org_doc_received_seq'] ?? 0;
        $org_doc_sent_seq = $post['org_doc_sent_seq'] ?? 0;
        $trip_id_seq = $post['trip_id_seq'] ?? 0;
        $carrier_seq = $post['carrier_seq'] ?? 0;
        $vehicle_no_seq = $post['vehicle_no_seq'] ?? 0;
        $trailer_no_seq = $post['trailer_no_seq'] ?? 0;
        $vehicle_type_seq = $post['vehicle_type_seq'] ?? 0;
        $driver_name_seq = $post['driver_name_seq'] ?? 0;
        $driver_number_seq = $post['driver_number_seq'] ?? 0;
        $driver_licence_no_seq = $post['driver_licence_no_seq'] ?? 0;
        $driver_address_seq = $post['driver_address_seq'] ?? 0;
        $payer_role_seq = $post['payer_role_seq'] ?? 0;
        $payer_id_seq = $post['payer_id_seq'] ?? 0;
        $payer_name_seq = $post['payer_name_seq'] ?? 0;
        $payer_cid_seq = $post['payer_cid_seq'] ?? 0;
        $payer_acon_debtor_code_seq = $post['payer_acon_debtor_code_seq'] ?? 0;
        $payer_kn_login_account_seq = $post['payer_kn_login_account_seq'] ?? 0;
        $payer_vat_reg_no_seq = $post['payer_vat_reg_no_seq'] ?? 0;
        $payer_tax_payer_id_seq = $post['payer_tax_payer_id_seq'] ?? 0;
        $payer_steeet_and_house_no_seq = $post['payer_steeet_and_house_no_seq'] ?? 0;
        $payer_postal_code_seq = $post['payer_postal_code_seq'] ?? 0;
        $payer_country_name_seq = $post['payer_country_name_seq'] ?? 0;
        $payer_phone_seq = $post['payer_phone_seq'] ?? 0;
        $payer_email_seq = $post['payer_email_seq'] ?? 0;
        $rev_chrg_code_seq = $post['rev_chrg_code_seq'] ?? 0;
        $rev_chrg_name_seq = $post['rev_chrg_name_seq'] ?? 0;
        $rev_chrg_qty_seq = $post['rev_chrg_qty_seq'] ?? 0;
        $rev_chrg_value_seq = $post['rev_chrg_value_seq'] ?? 0;
        $rev_chrg_rate_id_seq = $post['rev_chrg_rate_id_seq'] ?? 0;
        $rev_chrg_amount_seq = $post['rev_chrg_amount_seq'] ?? 0;
        $rev_chrg_currency_seq = $post['rev_chrg_currency_seq'] ?? 0;
        $rev_chrg_vat_seq = $post['rev_chrg_vat_seq'] ?? 0;
        $rev_chrg_vat_amount_seq = $post['rev_chrg_vat_amount_seq'] ?? 0;
        $rev_chrg_total_seq = $post['rev_chrg_total_seq'] ?? 0;
        $rev_bu_jfr_seq = $post['rev_bu_jfr_seq'] ?? 0;
        $rev_jfr_seq = $post['rev_jfr_seq'] ?? 0;
        $rev_exchange_rate_seq = $post['rev_exchange_rate_seq'] ?? 0;
        $rev_foreign_currency_seq = $post['rev_foreign_currency_seq'] ?? 0;
        $rev_invoice_no_seq = $post['rev_invoice_no_seq'] ?? 0;
        $rev_invoice_date_seq = $post['rev_invoice_date_seq'] ?? 0;
        $rev_credit_note_no_seq = $post['rev_credit_note_no_seq'] ?? 0;
        $rev_credit_note_date_seq = $post['rev_credit_note_date_seq'] ?? 0;
        $rev_invoice_creation_date_seq = $post['rev_invoice_creation_date_seq'] ?? 0;
        $rev_invoice_received_date_seq = $post['rev_invoice_received_date_seq'] ?? 0;
        $rev_status_seq = $post['rev_status_seq'] ?? 0;
        $customer_contract_no_seq = $post['customer_contract_no_seq'] ?? 0;
        $customer_contract_date_seq = $post['customer_contract_date_seq'] ?? 0;
        $invoice_status_seq = $post['invoice_status_seq'] ?? 0;
        $suppier_role_seq = $post['suppier_role_seq'] ?? 0;
        $suppier_id_seq = $post['suppier_id_seq'] ?? 0;
        $suppier_name_seq = $post['suppier_name_seq'] ?? 0;
        $suppier_steeet_and_house_no_seq = $post['suppier_steeet_and_house_no_seq'] ?? 0;
        $suppier_postal_code_seq = $post['suppier_postal_code_seq'] ?? 0;
        $suppier_country_name_seq = $post['suppier_country_name_seq'] ?? 0;
        $suppier_phone_seq = $post['suppier_phone_seq'] ?? 0;
        $suppier_email_seq = $post['suppier_email_seq'] ?? 0;
        $cost_chrg_code_seq = $post['cost_chrg_code_seq'] ?? 0;
        $cost_chrg_name_seq = $post['cost_chrg_name_seq'] ?? 0;
        $cost_chrg_qty_seq = $post['cost_chrg_qty_seq'] ?? 0;
        $cost_chrg_value_seq = $post['cost_chrg_value_seq'] ?? 0;
        $cost_chrg_rate_id_seq = $post['cost_chrg_rate_id_seq'] ?? 0;
        $cost_chrg_amount_seq = $post['cost_chrg_amount_seq'] ?? 0;
        $cost_chrg_currency_seq = $post['cost_chrg_currency_seq'] ?? 0;
        $cost_chrg_vat_seq = $post['cost_chrg_vat_seq'] ?? 0;
        $cost_chrg_vat_amount_seq = $post['cost_chrg_vat_amount_seq'] ?? 0;
        $cost_bu_jfr_seq = $post['cost_bu_jfr_seq'] ?? 0;
        $cost_jfr_seq = $post['cost_jfr_seq'] ?? 0;
        $cost_exchange_rate_seq = $post['cost_exchange_rate_seq'] ?? 0;
        $cost_foreign_currency_seq = $post['cost_foreign_currency_seq'] ?? 0;

        $salog_ref_seq = $post['salog_ref_seq'] ?? 0;
        $actual_pickup_date_time_seq = $post['actual_pickup_date_time_seq'] ?? 0;
        $actual_delivery_date_time_seq = $post['actual_delivery_date_time_seq'] ?? 0;
        $pod_status_seq = $post['pod_status_seq'] ?? 0;
        $order_status_seq = $post['order_status_seq'] ?? 0;

        $last_Status_Seq = $post['last_status_seq'] ?? 0;
        $last_Status_Location_Seq = $post['last_status_location_seq'] ?? 0;
        $last_Status_Time_Seq = $post['last_status_time_seq'] ?? 0;
        $trip_created_date_seq = $post['trip_created_date_seq'] ?? 0;
        $accept_seq = $post['accept_seq'] ?? 0;
        $gate_in_origin_seq = $post['gate_in_origin_seq'] ?? 0;
        $gate_out_origin_seq = $post['gate_out_origin_seq'] ?? 0;
        $in_transit_seq = $post['in_transit_seq'] ?? 0;
        $gate_in_dest_seq = $post['gate_in_dest_seq'] ?? 0;
        $gate_out_dest_seq = $post['gate_out_dest_seq'] ?? 0;

        $transit_time_in_hours_seq  = $post['transit_time_in_hours_seq'] ?? 0;
        $rap_date_seq               = $post['rap_date_seq'] ?? 0;
        $rap_status_seq             = $post['rap_status_seq'] ?? 0;
        $bap_seq                    = $post['bap_seq'] ?? 0;
        $remarks_issues_seq         = $post['remarks_issues_seq'] ?? 0;

        $insdata = [
            'name' => $reporter_name,
            'ord_id' => $ord_id . "_" . $ord_id_seq,
            'delivery_ord_no' => $delivery_ord_no . "_" . $delivery_ord_no_seq,
            'purchase_ord_no' => $purchase_ord_no . "_" . $purchase_ord_no_seq,
            'ord_creation_dttme' => $ord_creation_dttme . "_" . $ord_creation_dttme_seq,
            'ord_pickup_dttme' => $ord_pickup_dttme . "_" . $ord_pickup_dttme_seq,
            'ord_delivery_dttme' => $ord_delivery_dttme . "_" . $ord_delivery_dttme_seq,
            'shipr_id' => $shipr_id . "_" . $shipr_id_seq,
            'shipr_cid' => $shipr_cid . "_" . $shipr_cid_seq,
            'shipr_acon_debtor_code' => $shipr_acon_debtor_code . "_" . $shipr_acon_debtor_code_seq,
            'shipr_kn_login_account' => $shipr_kn_login_account . "_" . $shipr_kn_login_account_seq,
            'shipr_vat_reg_no' => $shipr_vat_reg_no . "_" . $shipr_vat_reg_no_seq,
            'shipr_tax_payer_id' => $shipr_tax_payer_id . "_" . $shipr_tax_payer_id_seq,
            'shipr_name' => $shipr_name . "_" . $shipr_name_seq,
            'shipr_steeet_and_house_no' => $shipr_steeet_and_house_no . "_" . $shipr_steeet_and_house_no_seq,
            'shipper_province' => $shipper_province . "_" . $shipper_province_seq,
            'shipr_city' => $shipr_city . "_" . $shipr_city_seq,
            'shipr_postal_code' => $shipr_postal_code . "_" . $shipr_postal_code_seq,
            'shippper_country_name' => $shippper_country_name . "_" . $shippper_country_name_seq,
            'shipr_phone' => $shipr_phone . "_" . $shipr_phone_seq,
            'shipr_email' => $shipr_email . "_" . $shipr_email_seq,
            'consignee_id' => $consignee_id . "_" . $consignee_id_seq,
            'consignee_cid' => $consignee_cid . "_" . $consignee_cid_seq,
            'consignee_acon_debtor_code' => $consignee_acon_debtor_code . "_" . $consignee_acon_debtor_code_seq,
            'consignee_kn_login_account' => $consignee_kn_login_account . "_" . $consignee_kn_login_account_seq,
            'consignee_vat_reg_no' => $consignee_vat_reg_no . "_" . $consignee_vat_reg_no_seq,
            'consignee_tax_payer_id' => $consignee_tax_payer_id . "_" . $consignee_tax_payer_id_seq,
            'consignee_name' => $consignee_name . "_" . $consignee_name_seq,
            'consignee_steeet_and_house_no' => $consignee_steeet_and_house_no . "_" . $consignee_steeet_and_house_no_seq,
            'consignee_province' => $consignee_province . "_" . $consignee_province_seq,
            'consignee_city' => $consignee_city . "_" . $consignee_city_seq,
            'consignee_postal_code' => $consignee_postal_code . "_" . $consignee_postal_code_seq,
            'consignee_country_name' => $consignee_country_name . "_" . $consignee_country_name_seq,
            'consignee_phone' => $consignee_phone . "_" . $consignee_phone_seq,
            'consignee_email' => $consignee_email . "_" . $consignee_email_seq,
            'customer_id' => $customer_id . "_" . $customer_id_seq,
            'customer_cid' => $customer_cid . "_" . $customer_cid_seq,
            'customer_acon_debtor_code' => $customer_acon_debtor_code . "_" . $customer_acon_debtor_code_seq,
            'customer_kn_login_account' => $customer_kn_login_account . "_" . $customer_kn_login_account_seq,
            'customer_vat_reg_no' => $customer_vat_reg_no . "_" . $customer_vat_reg_no_seq,
            'customer_tax_payer_id' => $customer_tax_payer_id . "_" . $customer_tax_payer_id_seq,
            'customer_name' => $customer_name . "_" . $customer_name_seq,
            'customer_steeet_and_house_no' => $customer_steeet_and_house_no . "_" . $customer_steeet_and_house_no_seq,
            'customer_postal_code' => $customer_postal_code . "_" . $customer_postal_code_seq,
            'customer_country_name' => $customer_country_name . "_" . $customer_country_name_seq,
            'customer_phone' => $customer_phone . "_" . $customer_phone_seq,
            'customer_email' => $customer_email . "_" . $customer_email_seq,
            'country' => $country . "_" . $country_seq,
            'branch' => $branch . "_" . $branch_seq,
            'department_code' => $department_code . "_" . $department_code_seq,
            'product' => $product . "_" . $product_seq,
            'service' => $service . "_" . $service_seq,
            'incoterms' => $incoterms . "_" . $incoterms_seq,
            'delivery_terms' => $delivery_terms . "_" . $delivery_terms_seq,
            'delivery_note' => $delivery_note . "_" . $delivery_note_seq,
            'notify_party' => $notify_party . "_" . $notify_party_seq,
            'ord_type' => $ord_type . "_" . $ord_type_seq,
            'mode_of_transport' => $mode_of_transport . "_" . $mode_of_transport_seq,
            'purchase_ord' => $purchase_ord . "_" . $purchase_ord_seq,
            'qty' => $qty . "_" . $qty_seq,
            'package_type' => $package_type . "_" . $package_type_seq,
            'length' => $length . "_" . $length_seq,
            'length_unit' => $length_unit . "_" . $length_unit_seq,
            'width' => $width . "_" . $width_seq,
            'width_unit' => $width_unit . "_" . $width_unit_seq,
            'height' => $height . "_" . $height_seq,
            'height_unit' => $height_unit . "_" . $height_unit_seq,
            'weight' => $weight . "_" . $weight_seq,
            'weight_unit' => $weight_unit . "_" . $weight_unit_seq,
            'volume' => $volume . "_" . $volume_seq,
            'volume_unit' => $volume_unit . "_" . $volume_unit_seq,
            'ldm' => $ldm . "_" . $ldm_seq,
            'volumetric_weight' => $volumetric_weight . "_" . $volumetric_weight_seq,
            'volumetric_weight_unit' => $volumetric_weight_unit . "_" . $volumetric_weight_unit_seq,
            'stackable' => $stackable . "_" . $stackable_seq,
            'dg_goods' => $dg_goods . "_" . $dg_goods_seq,
            'actual_weight' => $actual_weight . "_" . $actual_weight_seq,
            'actual_weight_unit' => $actual_weight_unit . "_" . $actual_weight_unit_seq,
            'actual_volume' => $actual_volume . "_" . $actual_volume_seq,
            'actual_volume_unit' => $actual_volume_unit . "_" . $actual_volume_unit_seq,
            'vas_1_name' => $vas_1_name . "_" . $vas_1_name_seq,
            'vas_1_qty' => $vas_1_qty . "_" . $vas_1_qty_seq,
            'vas_2_name' => $vas_2_name . "_" . $vas_2_name_seq,
            'vas_2_qty' => $vas_2_qty . "_" . $vas_2_qty_seq,
            'vas_3_name' => $vas_3_name . "_" . $vas_3_name_seq,
            'vas_3_qty' => $vas_3_qty . "_" . $vas_3_qty_seq,
            'vas_4_name' => $vas_4_name . "_" . $vas_4_name_seq,
            'vas_4_qty' => $vas_4_qty . "_" . $vas_4_qty_seq,
            'vas_5_name' => $vas_5_name . "_" . $vas_5_name_seq,
            'vas_5_qty' => $vas_5_qty . "_" . $vas_5_qty_seq,
            'ref_1_name' => $ref_1_name . "_" . $ref_1_name_seq,
            'ref_1_desc' => $ref_1_desc . "_" . $ref_1_desc_seq,
            'ref_1_value' => $ref_1_value . "_" . $ref_1_value_seq,
            'ref_2_name' => $ref_2_name . "_" . $ref_2_name_seq,
            'ref_2_desc' => $ref_2_desc . "_" . $ref_2_desc_seq,
            'ref_2_value' => $ref_2_value . "_" . $ref_2_value_seq,
            'ref_3_name' => $ref_3_name . "_" . $ref_3_name_seq,
            'ref_3_desc' => $ref_3_desc . "_" . $ref_3_desc_seq,
            'ref_3_value' => $ref_3_value . "_" . $ref_3_value_seq,
            'ref_4_name' => $ref_4_name . "_" . $ref_4_name_seq,
            'ref_4_desc' => $ref_4_desc . "_" . $ref_4_desc_seq,
            'ref_4_value' => $ref_4_value . "_" . $ref_4_value_seq,
            'ref_5_name' => $ref_5_name . "_" . $ref_5_name_seq,
            'ref_5_desc' => $ref_5_desc . "_" . $ref_5_desc_seq,
            'ref_5_value' => $ref_5_value . "_" . $ref_5_value_seq,
            'driver_pickup_inst' => $driver_pickup_inst . "_" . $driver_pickup_inst_seq,
            'driver_delivery_inst' => $driver_delivery_inst . "_" . $driver_delivery_inst_seq,
            'status_pickedup' => $status_pickedup . "_" . $status_pickedup_seq,
            'status_delivered' => $status_delivered . "_" . $status_delivered_seq,
            'org_doc_received' => $org_doc_received . "_" . $org_doc_received_seq,
            'org_doc_sent' => $org_doc_sent . "_" . $org_doc_sent_seq,
            'trip_id' => $trip_id . "_" . $trip_id_seq,
            'carrier' => $carrier . "_" . $carrier_seq,
            'vehicle_no' => $vehicle_no . "_" . $vehicle_no_seq,
            'trailer_no' => $trailer_no . "_" . $trailer_no_seq,
            'vehicle_type' => $vehicle_type . "_" . $vehicle_type_seq,
            'driver_name' => $driver_name . "_" . $driver_name_seq,
            'driver_number' => $driver_number . "_" . $driver_number_seq,
            'driver_licence_no' => $driver_licence_no . "_" . $driver_licence_no_seq,
            'driver_address' => $driver_address . "_" . $driver_address_seq,
            'payer_role' => $payer_role . "_" . $payer_role_seq,
            'payer_id' => $payer_id . "_" . $payer_id_seq,
            'payer_name' => $payer_name . "_" . $payer_name_seq,
            'payer_cid' => $payer_cid . "_" . $payer_cid_seq,
            'payer_acon_debtor_code' => $payer_acon_debtor_code . "_" . $payer_acon_debtor_code_seq,
            'payer_kn_login_account' => $payer_kn_login_account . "_" . $payer_kn_login_account_seq,
            'payer_vat_reg_no' => $payer_vat_reg_no . "_" . $payer_vat_reg_no_seq,
            'payer_tax_payer_id' => $payer_tax_payer_id . "_" . $payer_tax_payer_id_seq,
            'payer_steeet_and_house_no' => $payer_steeet_and_house_no . "_" . $payer_steeet_and_house_no_seq,
            'payer_postal_code' => $payer_postal_code . "_" . $payer_postal_code_seq,
            'payer_country_name' => $payer_country_name . "_" . $payer_country_name_seq,
            'payer_phone' => $payer_phone . "_" . $payer_phone_seq,
            'payer_email' => $payer_email . "_" . $payer_email_seq,
            'rev_chrg_code' => $rev_chrg_code . "_" . $rev_chrg_code_seq,
            'rev_chrg_name' => $rev_chrg_name . "_" . $rev_chrg_name_seq,
            'rev_chrg_qty' => $rev_chrg_qty . "_" . $rev_chrg_qty_seq,
            'rev_chrg_value' => $rev_chrg_value . "_" . $rev_chrg_value_seq,
            'rev_chrg_rate_id' => $rev_chrg_rate_id . "_" . $rev_chrg_rate_id_seq,
            'rev_chrg_amount' => $rev_chrg_amount . "_" . $rev_chrg_amount_seq,
            'rev_chrg_currency' => $rev_chrg_currency . "_" . $rev_chrg_currency_seq,
            'rev_chrg_vat' => $rev_chrg_vat . "_" . $rev_chrg_vat_seq,
            'rev_chrg_vat_amount' => $rev_chrg_vat_amount . "_" . $rev_chrg_vat_amount_seq,
            'rev_chrg_total' => $rev_chrg_total . "_" . $rev_chrg_total_seq,
            'rev_bu_jfr' => $rev_bu_jfr . "_" . $rev_bu_jfr_seq,
            'rev_jfr' => $rev_jfr . "_" . $rev_jfr_seq,
            'rev_exchange_rate' => $rev_exchange_rate . "_" . $rev_exchange_rate_seq,
            'rev_foreign_currency' => $rev_foreign_currency . "_" . $rev_foreign_currency_seq,
            'rev_invoice_no' => $rev_invoice_no . "_" . $rev_invoice_no_seq,
            'rev_invoice_date' => $rev_invoice_date . "_" . $rev_invoice_date_seq,
            'rev_credit_note_no' => $rev_credit_note_no . "_" . $rev_credit_note_no_seq,
            'rev_credit_note_date' => $rev_credit_note_date . "_" . $rev_credit_note_date_seq,
            'rev_invoice_creation_date' => $rev_invoice_creation_date . "_" . $rev_invoice_creation_date_seq,
            'rev_invoice_received_date' => $rev_invoice_received_date . "_" . $rev_invoice_received_date_seq,
            'rev_status' => $rev_status . "_" . $rev_status_seq,
            'customer_contract_no' => $customer_contract_no . "_" . $customer_contract_no_seq,
            'customer_contract_date' => $customer_contract_date . "_" . $customer_contract_date_seq,
            'invoice_status' => $invoice_status . "_" . $invoice_status_seq,
            'suppier_role' => $suppier_role . "_" . $suppier_role_seq,
            'suppier_id' => $suppier_id . "_" . $suppier_id_seq,
            'suppier_name' => $suppier_name . "_" . $suppier_name_seq,
            'suppier_steeet_and_house_no' => $suppier_steeet_and_house_no . "_" . $suppier_steeet_and_house_no_seq,
            'suppier_postal_code' => $suppier_postal_code . "_" . $suppier_postal_code_seq,
            'suppier_country_name' => $suppier_country_name . "_" . $suppier_country_name_seq,
            'suppier_phone' => $suppier_phone . "_" . $suppier_phone_seq,
            'suppier_email' => $suppier_email . "_" . $suppier_email_seq,
            'cost_chrg_code' => $cost_chrg_code . "_" . $cost_chrg_code_seq,
            'cost_chrg_name' => $cost_chrg_name . "_" . $cost_chrg_name_seq,
            'cost_chrg_qty' => $cost_chrg_qty . "_" . $cost_chrg_qty_seq,
            'cost_chrg_value' => $cost_chrg_value . "_" . $cost_chrg_value_seq,
            'cost_chrg_rate_id' => $cost_chrg_rate_id . "_" . $cost_chrg_rate_id_seq,
            'cost_chrg_amount' => $cost_chrg_amount . "_" . $cost_chrg_amount_seq,
            'cost_chrg_currency' => $cost_chrg_currency . "_" . $cost_chrg_currency_seq,
            'cost_chrg_vat' => $cost_chrg_vat . "_" . $cost_chrg_vat_seq,
            'cost_chrg_vat_amount' => $cost_chrg_vat_amount . "_" . $cost_chrg_vat_amount_seq,
            'cost_bu_jfr' => $cost_bu_jfr . "_" . $cost_bu_jfr_seq,
            'cost_jfr' => $cost_jfr . "_" . $cost_jfr_seq,
            'cost_exchange_rate' => $cost_exchange_rate . "_" . $cost_exchange_rate_seq,
            'cost_foreign_currency' => $cost_foreign_currency . "_" . $cost_foreign_currency_seq,
            'salog_ref' => $salog_ref . "_" . $salog_ref_seq,
            'actual_pickup_date_time' => $actual_pickup_date_time . "_" . $actual_pickup_date_time_seq,
            'actual_delivery_date_time' => $actual_delivery_date_time . "_" . $actual_delivery_date_time_seq,
            'pod_status' => $pod_status . "_" . $pod_status_seq,
            'order_status' => $order_status . "_" . $order_status_seq,
            'last_Status' => $last_Status . "_" . $last_Status_Seq,
            'last_status_location' => $last_Status_Location . "_" . $last_Status_Location_Seq,
            'last_status_time' => $last_Status_Time . "_" . $last_Status_Time_Seq,
            'trip_created_date' => $trip_created_date . "_" . $trip_created_date_seq,
            'accept' => $accept . "_" . $accept_seq,
            'gate_in_origin' => $gate_in_origin . "_" . $gate_in_origin_seq,
            'gate_out_origin' => $gate_out_origin . "_" . $gate_out_origin_seq,
            'in_transit' => $in_transit . "_" . $in_transit_seq,
            'gate_in_dest' => $gate_in_dest . "_" . $gate_in_dest_seq,
            'gate_out_dest' => $gate_out_dest . "_" . $gate_out_dest_seq,
            'transit_time_in_hours'=>$transit_time_in_hours . "_" . $transit_time_in_hours_seq,
            'rap_date'=>$rap_date . "_" . $rap_date_seq,
            'rap_status'=>$rap_status . "_" . $rap_status_seq,
            'bap'=>$bap . "_" . $bap_seq,
            'remarks_issues'=>$remarks_issues . "_" . $remarks_issues_seq,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status' => 1,
            'updated_on' => $curdt            
        ];
        if ($custaprl_id > 0) {
            $update = $this->common->updatetbledata("tb_custom_report_settings", $insdata, ['id' => $custaprl_id]);
            $caprl_id = $custaprl_id;
        } else {
            $insdata['created_on'] = $curdt;
            $caprl_id = $this->common->insertTableData("tb_custom_report_settings", $insdata);
        }
        echo $caprl_id;
    }

    public function getreportname()
    {
        $uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $post = $this->input->post(NULL, TRUE);
        $reportname = isset($post["reportname"]) ? $post["reportname"] : "";
        $reportname = addslashes($reportname);

        $get_data = $this->db->query("
            SELECT name
            FROM tb_custom_report_settings
            WHERE
                name like ?
                AND company_code = ?
        ", [
            '%'.$this->db->escape_like_str($reportname).'%',
            $company_code
        ]);
        $data = array();
        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->name;
            }
        }
        echo json_encode($data);
    }
}
