<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";
class Customer extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if($this->session->userdata('cust_id') == ""){
            redirect("login");
        }
        $this->load->model(['ShipmentVisibilityModel', 'common','Order_details','Cabmodel']);
        $this->load->library(['StatusRemappingService']);
        if (!checkUrlAccessForUser('CUSTOMER')) {
            redirect("Forbiddenaccess");
        }
    }
    public function login()
    {
        if ($this->session->userdata('cust_id')) {
            redirect('customer/dashboard');
        }else{
            redirect("login");
        }
        $data['page_title'] = "Login";
        $this->load->view('customer/login', $data);

    }
    public function submitlogin()
    {
        $data['phone']    = $this->input->get_post('adminlogin-email');
        $data['password'] = password_hash($this->input->get_post('adminlogin-password'), PASSWORD_DEFAULT);
        $data['status']   = "1";
        $user = $this->db->select('id,name,phone,email_id,user_id')->get_where('tb_customers', $data);
        if ($user->num_rows() > 0) {
            $userID = $user->row_array();
            $this->session->set_userdata('cust_id', $userID['id']);
            $this->session->set_userdata('user_id', $userID['user_id']);
            $this->session->set_userdata('companyname', $userID['name']);
            $this->session->set_userdata('phone', $userID['phone']);
            $this->session->set_userdata('email_id', $userID['email_id']);
            $this->session->set_userdata('business_type', "Customer");
            $this->session->set_userdata('site_lang', 'english');
            redirect("customer/dashboard");
        } else {
            $this->session->set_flashdata('error_msg', 'invalid Mobile No./ Password');
            redirect('customer/login');
        }
    }

    public function dashboard()
    {
        $this->load->helper('log');
        $data = array();
        $curtz1 = $this->session->userdata("usr_tzone");
        $curtz = $curtz1['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $cdate = $getactual['date'];
        $pdate= $ddate = array();
        $btype = $this->session->userdata("business_type");
        $whr = $whr1 = $whr2 = "";
        if($btype == "Super Admin"){
            $userids = getsuperadminusers($this->session->userdata("user_id"));
            $whr .= " AND e.user_id IN(".implode(",", $userids).") ";
            $whr1 .= " AND o.user_id IN(".implode(",", $userids).") ";
            $whr2 .= " user_id IN(".implode(",", $userids).") ";
        }else if($btype == "Truck_Owner"){
            $userid = $this->session->userdata("user_id");
            $whr .= " AND e.user_id=$userid ";
            $whr1 .= " AND o.user_id=$userid ";
            $whr2 .= " user_id=$userid ";
        }else{
            $cuserid = $this->session->userdata("user_id");
            $cid = $this->session->userdata("cust_id");
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                    $whr .= " AND e.customer_id IN(".implode(",", $subcusts).") ";
                    $whr1 .= " AND o.customer_id IN(".implode(",", $subcusts).") ";
                    $whr2 .= " user_id=$cuserid ";
                }else{
                    $whr .= " AND e.customer_id=$cid ";
                    $whr1 .= " AND o.customer_id=$cid ";
                    $whr2 .= " user_id=$cuserid ";
                }
            }else{
                $cid = $this->session->userdata("cust_id");
                $whr .= " AND e.customer_id=$cid ";
                $whr1 .= " AND o.customer_id=$cid ";
                $whr2 .= " user_id=$cuserid ";
            }
        }
        $mainqry = "SELECT e.order_id FROM tb_orders e WHERE e.status!=0 AND (e.trip_id!=0 OR (e.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=e.order_id)>0)) AND e.trip_sts=0 $whr GROUP BY e.order_id";
        $actbk = $this->db->query($mainqry);
        $data['activebooks'] = $actbk->num_rows();
        /*pending bookings*/
        $mainqry = "SELECT e.id FROM tb_orders e WHERE e.status!=0 AND e.trip_id=0 AND (e.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=e.order_id) =0) AND e.trip_sts=0 $whr GROUP BY e.order_id";
        $pendbk = $this->db->query($mainqry);
        $data['pendbooks'] = $pendbk->num_rows();
        /*completed bookings*/
        $mainqry = "SELECT e.id FROM tb_orders e WHERE e.trip_sts=1 $whr";
        $donebk = $this->db->query($mainqry);
        $data['donebooks'] = $donebk->num_rows();
        /*alerts*/
        /*$mainqry = "SELECT a.id FROM tb_trip_alerts a,tb_orders e WHERE a.trip_id=e.trip_id $whr GROUP BY a.id";
        $alertbk = $this->db->query($mainqry);*/
        $data['alertbooks'] = 0;
        $mainqry2 = $this->db->query("
                                SELECT COUNT(e.id) AS ordcount,
                                       DATE_FORMAT(merge_date,'%Y-%m-%d') AS ordtime
                                FROM (
                                    SELECT DATE(now()) AS merge_date
                                      UNION SELECT DATE_ADD(NOW(), INTERVAL 1 DAY) AS merge_date
                                      UNION SELECT DATE_ADD(NOW(), INTERVAL 2 DAY) AS merge_date
                                      UNION SELECT DATE_ADD(NOW(), INTERVAL 3 DAY) AS merge_date
                                      UNION SELECT DATE_ADD(NOW(), INTERVAL 4 DAY) AS merge_date
                                      UNION SELECT DATE_ADD(NOW(), INTERVAL 5 DAY) AS merge_date
                                      UNION SELECT DATE_ADD(NOW(), INTERVAL 6 DAY) AS merge_date
                                    ) AS m
                                LEFT JOIN tb_orders e ON DATE(m.merge_date) = DATE(e.pickup_datetime)
                                    AND e.trip_id!=0
                                    AND DATE(e.pickup_datetime)>='".$cdate."'
                                    AND e.trip_sts=0 $whr
                                  GROUP BY m.merge_date ORDER BY m.merge_date LIMIT 7");
        $data['forcat'] = array();
        if($mainqry2->num_rows()>0){
            foreach($mainqry2->result() as $rs){
                $mainqry1 = $this->db->query("SELECT e.trip_id FROM tb_orders e WHERE e.trip_id!=0 AND e.trip_sts=0 AND DATE(e.delivery_datetime)='".$rs->ordtime."' $whr");
                $forcastData = array("pickup" => $rs->ordcount?:0, "tdate" => $rs->ordtime, "deliver" => $mainqry1->num_rows()?:0);
                $data['forcat'][] = $forcastData;
            }
        }
        /*customers for chat*/
        $country = $curtz1['country'];
        $data['chatusers'] = array();
        $cusers = $this->db->query("SELECT id,name,mobile_no as phone,'Admin' as utype FROM tb_users WHERE status='Active' and country_code='".$country."' ORDER BY online DESC");
        if($cusers->num_rows()>0){
            $data['chatusers'] = $cusers->result_array();
        }
        if ($this->session->userdata('company_code') === "CNKN") {
            $this->settemplate->dashboard("customer/dashboard_china", $data);
        } elseif ($this->session->userdata('company_code') === "TWKN") {
            $this->settemplate->dashboard("customer/dashboard_taiwan", $data);
        }else{
            $this->settemplate->dashboard("customer/dashboard", $data);
        }

    }

    public function getActiveTrips()
    {
        $input = $this->input->post();
        $cid = $this->session->userdata("cust_id");
        $trips = [];
        $whr = "";
        if(isset($input['shipment_id']) && $input['shipment_id'] != ""){
            $sh = trim($input['shipment_id']);
            $whr .= " AND s.shipmentid LIKE '%".$sh."%' ";
        }
        
        $sql = $this->common->getactivetripids($whr,$cid);
        if(!empty($sql)){
            foreach ($sql as $row) {
                $trips[] = array(
                    "id"   => $row['id'],
                    "name" => "<div class='btn btn-xs btn-primary' onclick='openTripMap(\"" . $row['id'] . "\",\"" . $row['shipmentid'] . " - " . $row['splace'] . " - " . $row['eplace'] . "\")'>" . $row['shipmentid'] . "</div> " . $row['splace'] . " - " . $row['eplace'],
                );
            }
        }
        echo json_encode($trips);
    }

    public function loadMapVehicles()
    {
        $cid  = $this->session->userdata("cust_id");
        $data = array();
        $companyCode = $this->session->userdata('company_code');
        $checkAccessConditions = checkAccessConditions('RELATED_2_TW_CN', $companyCode);
        $sql  = "SELECT d.id, d.name, t.id as vehicle_id,t.register_number, tr.id as trip_id
        FROM tb_shifts s
        JOIN tb_trips tr ON tr.shift_id = s.id
        LEFT JOIN tb_trucks_data t ON t.id = tr.vehicle_id
        LEFT JOIN tb_truck_drivers d ON d.id = tr.driver_id
        WHERE s.customer_id = '$cid' AND s.status=1 AND tr.status=1 AND t.status='Active'
        GROUP BY t.id
        ORDER BY t.register_number";
        $qr   = $this->db->query($sql);
        $data["data"] = array();
        $currentdate = $checkAccessConditions ? date("Y-m-d H:i:s") : date("Y-m-d");
        if ($qr->num_rows() > 0) {
            foreach ($qr->result() as $row) {
                $d   = array();
                $d[] = $row->name;
                $d[] = $row->register_number;

                
                $tripgpsinfo = $this->common->getgpslocationbyorder($row->vehicle_id,$currentdate);
                if(!empty($tripgpsinfo)){
                    $tripgpsinfo = current($tripgpsinfo);
                    if($checkAccessConditions){
                        $d[] = getLocationName($tripgpsinfo['latitude'],$tripgpsinfo['longitude']) . "<input type='hidden' id='position' value='" . $tripgpsinfo['latitude'] . "," . $tripgpsinfo['longitude']. "'>
                        <input type='hidden' id='imei' value='" . $tripgpsinfo['mobileimei'] . "'><input type='hidden' id='shipmentid' value='" . $tripgpsinfo['shipmentid'] . "'><input type='hidden' id='orderid' value='" . $tripgpsinfo['orderId'] . "'><input type='hidden' id='tripid' value='" . $tripgpsinfo['tripid'] . "'>";
                    }else{
                        $d[] = getLocationName($tripgpsinfo['latitude'],$tripgpsinfo['longitude']) . "<input type='hidden' id='position' value='" . $tripgpsinfo['latitude'] . "," . $tripgpsinfo['longitude']. "'>
                        <input type='hidden' id='speed' value='" . $tripgpsinfo['speed'] . "'><input type='hidden' id='imei' value='" . $tripgpsinfo['mobileimei'] . "'><input type='hidden' id='fuel' value='" . $tripgpsinfo['fuel'] . "'><input type='hidden' id='shipmentid' value='" . $tripgpsinfo['shipmentid'] . "'><input type='hidden' id='orderid' value='" . $tripgpsinfo['orderId'] . "'><input type='hidden' id='tripid' value='" . $tripgpsinfo['tripid'] . "'>";
                        if (strlen($tripgpsinfo['speed'] ) > 0) {
                            $d[] = $tripgpsinfo['speed'] . " KMPH";
                        } else {
                            $d[] = "";
                        }
                        $d[] = (strlen(trim($tripgpsinfo['battery'])) > 0 ? $tripgpsinfo['battery'] . " %" : "");
                        $d[] = getShipDetailByVeh($row->id);
                    }
                    if (strlen($tripgpsinfo['receivedon']) > 0) {
                        $d[] = date('d M,Y H:i a', strtotime($tripgpsinfo['receivedon']));
                    } else {
                        $d[] = "";
                    }
                    $data["data"][] = $d;
                }
            }
        }
        if($checkAccessConditions){
            $this->db->select("o.id,o.order_id as orderid,o.plat as latitude,o.plng as longitude,o.trip_sts");
            $this->db->from("tb_orders o");
            $where = "o.customer_id IN (".$cid.") AND o.trip_id=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.status!=0 AND o.trip_sts=0 AND o.plat!='' AND o.plng!=''";
            $this->db->where($where);
            $this->db->group_by('o.order_id');
            $this->db->order_by('o.pickup_datetime','DESC');
            $results = $this->db->get();
            if($results->num_rows() > 0) {
                foreach ($results->result() as $orderData) {
                    $ordersData =  array();
                    $ordersData[] = $orderData->id;
                    $ordersData[] = $orderData->trip_sts;
                    $ordersData[] = getLocationName($orderData->latitude, $orderData->longitude) . "<input type='hidden' id='position' value='" . $orderData->latitude . "," . $orderData->longitude. "'>
                        <input type='hidden' id='imei' value='0'><input type='hidden' id='shipid' value=''><input type='hidden' id='orderid' value='" . $orderData->orderid. "'><input type='hidden' id='tripid' value='0'>";
                    $ordersData[] = "";
                    $data["data"][] = $ordersData;
                }

            }

        }
        echo json_encode($data);
    }

    public function getNextStop($trip_id,$lat,$lng)
    {
        $temp = $this->db->query("SELECT employee_id,stop_id FROM tb_trip_employee where trip_id = '$trip_id' ORDER BY stime DESC limit 1");
        $next_stop = null;
        if($temp->num_rows()>0){
            $trip = $this->db->query("SELECT shift_id FROM tb_trips where id = '$trip_id' limit 1");
            $emp = $temp->row()->employee_id;
            $stop_id = $temp->row()->stop_id;
            $shift_id = $trip->row()->shift_id;
            $next_stop = $this->db->query("SELECT stopname,plat,plng FROM tb_shiporder_stops WHERE shipment_id = '$shift_id' AND id > '$stop_id' ORDER BY ordernumber ASC")->row();
        }
        if($next_stop!=null){
            $res = distancemetrixship($lat,$lng,$next_stop->plat,$next_stop->plng);
            return "<input type='hidden' id='next_stop' value='".implode(" - ", [$next_stop->stopname,$res["disttext"],$res["duratext"]])."'>";
        }else{
            return "";
        }
    }

    public function livecabdetails()
    {
        $data['page_title'] = $this->lang->line('dashboard_page_title');
        $data['sub_title'] = $this->lang->line('vehicles_live_track_details');
        $this->settemplate->dashboard("customer/livecabdetails", $data);
    }
    public function ajaxdashboard()
    {
        $userid = $this->session->userdata('user_id');
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $data["vehicles"] = $this->db->query("select v.route_id,v.vehicle_id,v.register_number,t.status,t.id as tripid from tb_shifts s,tb_shft_veh v,tb_trips t where s.id=v.shft_id AND v.vehicle_id=t.vehicle_id AND s.id=t.shift_id AND v.status=s.status AND s.customer_id=$cid AND t.status=1 AND s.status=1 group by vehicle_id order by tripid desc,register_number desc");
        $data['vshiftsdata'] = $this->db->query("select s.id,convertToClientTZ(s.startdate,'".$curtz."') as stime,convertToClientTZ(s.enddate,'".$curtz."') as etime,convertToClientTZ(s.startdate,'".$curtz."') as startdate,s.trip_type,s.splace,s.eplace,v.id as shft_veh_id, v.route_id, v.vehicle_id, v.register_number,t.status,t.id as tripid,t.driver_id from tb_shifts s,tb_shft_veh v,tb_trips t where s.id=v.shft_id AND v.vehicle_id=t.vehicle_id AND s.id=t.shift_id AND v.status=s.status AND s.customer_id=$cid AND t.status=1 AND s.status=1 group by shft_veh_id order by tripid desc");
        echo $this->load->view("customer/livecabdetails2", $data, true);
    }
    public function changestatus()
    {
        $trip_id = $_POST["trip_id"];
        $emp_id  = $_POST["emp_id"];
        $status  = $_POST["status"];
        $this->db->where(array("trip_id" => $trip_id, "employee_id" => $emp_id))->update("tb_trip_employee", array("status" => $status, "absent_reason" => "Updated by Transport Team"));
        $this->ajaxdashboard();
    }
    public function ajax_shifttripdetails()
    {
        $shiftid = isset($_POST['shiftid']) ? $_POST['shiftid'] : '';
        $tripid = isset($_POST['tripid']) ? $_POST['tripid'] : '';
        $temp = array();
        $result['emplist'] = array();
        if ($shiftid != "" && $tripid != "") {
            $trips = $this->db->query("select t.id as tripid, t.vehicle_id, d.name, d.contact_num, s.splace, s.eplace,v.register_number from tb_trips t,tb_shifts s,tb_truck_drivers d,tb_shft_veh v where t.driver_id=d.id and s.id=t.shift_id and v.shft_id=s.id AND s.id=$shiftid AND t.id=$tripid and t.status='1' and t.vehicle_id=v.vehicle_id and v.status=1 ORDER BY v.id DESC LIMIT 1");
            $temp["employee"] = array();
            $temp["driver"] = $temp["time"] = $temp["trip"] = "";
            $veh = $vehid = "";
            if ($trips->num_rows() > 0) {
                $t = $trips->row();
                $temp["vdriver"] = "<b>Driver : </b>" . $t->name . " - " . $t->contact_num;
                $temp["driver"] = $t->name . " - " . $t->contact_num;
                $temp["trip"] = explode(",", $t->splace)[0] . " - " . explode(",", $t->eplace)[0];
                $temp["vehicle"] = "<a href='" . base_url() . "cab/track/" . encryptIt($temp["driver"], $temp["trip"]) . "' target='_blank'>$t->register_number</a>";
                $veh = $t->register_number;
                $vehid = $t->vehicle_id;
            }
            $emp = $this->db->query("SELECT e.id,e.name,e.phone,e.pickup,e.drop,e.assoc_id,e.ship_type FROM tb_employee e,tb_shft_veh vh,tb_shft_veh_emp ve WHERE vh.shft_id=$shiftid AND ve.shft_veh_id=vh.id AND e.id=ve.emp_id AND vh.status=1 and ve.status=1 AND vh.vehicle_id='" . $vehid . "' ORDER BY `ve`.`priority` ASC");
            if ($emp->num_rows() > 0) {
                $temp["employee"] = array();
                foreach ($emp->result() as $emps) {
                    $checkattend = $this->db->select("status")->get_where("tb_trip_employee", array("trip_id" => $tripid, "employee_id" => $emps->id), 1, 0);
                    $pickdrop    = $emps->pickup;
                    if ($emps->ship_type == 'D') {
                        $pickdrop = $emps->drop;
                    }
                    if ($checkattend->num_rows() > 0) {
                        if ($checkattend->row()->status == "1") {
                            $temp["employee"][] = "<span style='color:black;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                        } else {
                            $temp["employee"][] = "<span style='color:red;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                        }
                    } else {
                        $temp["employee"][] = "<span style='color:black;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                    }
                }
            }
        }
        $result['emplist'] = $temp;
        echo json_encode($result);
    }

    public function ajax_shiftdetails()
    {
        $shiftid = isset($_POST['shiftid']) ? $_POST['shiftid'] : '';
        $vehicle = isset($_POST['tripid']) ? $_POST['tripid'] : '';
        $temp = array();
        $result['emplist'] = array();
        if ($shiftid != "" && $vehicle != "") {
            $trips = $this->db->query("select d.name,d.contact_num,s.splace,s.eplace,v.register_number from tb_shifts s,tb_shft_veh v,tb_trucks_data t,tb_truck_drivers d,tbl_assigned_drivers a where s.id=v.shft_id and s.id=$shiftid AND s.status='1' AND t.register_number=v.register_number AND v.register_number='" . $vehicle . "' AND a.vehicle_id=t.id AND d.id=a.driver_id and v.status=1 ORDER BY v.id DESC LIMIT 1");
            $temp["employee"] = array();
            $temp["driver"]   = $temp["time"]   = $temp["trip"]   = "";
            if ($trips->num_rows() > 0) {
                $t = $trips->row();
                $temp["vdriver"] = "<b>Driver : </b>" . $t->name . " - " . $t->contact_num;
                $temp["driver"]  = $t->name . " - " . $t->contact_num;
                $temp["trip"]    = explode(",", $t->splace)[0] . " - " . explode(",", $t->eplace)[0];
                $temp["vehicle"] = "<a href='" . base_url() . "cab/track/" . encryptIt($temp["driver"], $temp["trip"]) . "' target='_blank'>$t->register_number</a>";
            }
            $emp = $this->db->query("SELECT s.id,e.name,e.phone,e.pickup,e.drop,e.assoc_id,e.status,e.ship_type FROM tb_shifts s,tb_shft_veh sh,tb_shft_veh_emp ve,tb_employee e WHERE s.id=sh.shft_id AND sh.id=ve.shft_veh_id AND e.id=ve.emp_id AND s.status='1' AND sh.register_number='$vehicle' AND s.id='$shiftid' AND ve.status='1' AND sh.status=1 ORDER BY `ve`.`priority` ASC");
            if ($emp->num_rows() > 0) {
                $temp["employee"] = array();
                foreach ($emp->result() as $emps) {
                    $pickdrop = $emps->pickup;
                    if ($emps->ship_type == 'D') {
                        $pickdrop = $emps->drop;
                    }
                    if ($emps->status == "1") {
                        $temp["employee"][] = "<span style='color:black;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                    } else {
                        $temp["employee"][] = "<span style='color:red;'>" . $pickdrop . "<br/>" . $emps->name . " - (" . $emps->phone . ") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>" . $emps->ship_type . "</span> </span>";
                    }
                }
            }
        }
        $result['emplist'] = $temp;
        echo json_encode($result);
    }
    
    public function tripreports()
    {
        $data["table_search"] = $whr = "";
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $enddt = date('Y-m-d');
        $startdt = date('Y-m-d', strtotime('-7 days'));
        $post = array('fromdate_search' => $startdt, 'todate_search' => $enddt, 'driver_search' => '', 'vehicle_search' => '', 'shift_search' => '', 'zone_search' => '', 'type_search' => '');
        if ($_POST) {
            $post = $_POST;
        }
        $data['page_title']      = "Reports";
        $data['sub_title']       = "Shipment Reports";
        $tripscount              = $this->getshiftreports($post, 0, 0)->num_rows();
        $data['tripscount']      = $tripscount;
        $config                  = array();
        $config["base_url"]      = base_url() . "customer/tripreports";
        $config["total_rows"]    = $tripscount;
        $config["per_page"]      = 10;
        $config["uri_segment"]   = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['tripsdata'] = $this->getshiftreports($post, $config["per_page"], $page);
        $data['post']      = $post;
        $data['shifts']    = $this->db->query("select id,scity,dcity,shipmentid from tb_shifts where customer_id='$cid' AND status=0 ORDER BY startdate DESC")->result_array();
        $this->settemplate->dashboard("customer/tripreports", $data);
    }

    public function getshiftreports($post, $limit, $offset)
    {
        $where = " where tr.trip_status = 1 ";
        $cid = $this->session->userdata("cust_id");
        //log_message("error","Qry:".json_encode($post));
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->Cabmodel->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }

        if (isset($post['type_search']) && !empty(trim($post['type_search']))) {
            $getlocid = $this->getTripsByTypeSearch($post['type_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzzs[] = $ld['id'];
                }
                $ts = implode(",", $zzzs);
            } else {
                $ts = 0;
            }
            $where .= " and tr.trip_id IN (" . $ts . ")";
        }

        if (isset($post['shift_search']) && $post['shift_search'] != "") {

            if (!empty($post['shift_search'])) {
                $dd = $post['shift_search'];
                /*$where .= " AND trip.shift_id=$dd ";*/
                $where .= " AND s.shipmentid = '$dd' ";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $query = "select trip.shift_id,t.register_number,IFNULL(t.truck_capacity,0) as tcapacity,tr.trip_id,convertToClientTZ(tr.start_time,'".$curtz."') as start_time,convertToClientTZ(tr.end_time,'".$curtz."') as end_time,us.name,us.contact_num,(select ish.etime from tb_trips it,tb_shifts ish where it.id=tr.trip_id and ish.id=it.shift_id) as dvrlate from tb_trip_summary as tr, tb_truck_drivers as us,tb_trucks_data t,tb_trips trip,tb_shifts s " . $where . " AND s.id=trip.shift_id AND s.customer_id='$cid' AND tr.vehicle_id=t.id AND us.id = tr.driver_id AND trip.id = tr.trip_id order by tr.createdon DESC";
        if ($limit > 0) {
            $query .= " limit " . $offset . "," . $limit;
        }
        //log_message("error","query:".$this->db->last_query());
        return $this->db->query($query);
    }

    public function profile()
    {
        $data['page_title1']='Profile';
        if($this->session->userdata('child_id') != ""){
            $sql="select id,name,countrycode as country,code as phone,email_id,password from tb_customer_logins where id=".$this->session->userdata('child_id');
        }else{
            $sql="select id,name,country,phone,email_id,password from tb_customers where id=".$this->session->userdata('cust_id');
        }
        $data['usrdetails'] = $this->db->query($sql);
        $data['countrydata'] = $this->db->get_where("tbl_country_master",array("status"=>"1"));
        $this->settemplate->dashboard('customer/userprofile',$data);
    }

    public function updateprofile()
    {
        $com=$this->input->get_post('country');
        $nam=$this->input->get_post('name');
        $mob=$this->input->get_post('mobile_no');
        $ema=$this->input->get_post('email_id');
        $id=$this->session->userdata('cust_id');
        $password=$this->input->get_post('password');
        $cnf_password=$this->input->get_post('confirm_password');
        $this->form_validation->set_rules('country', 'Country Name', 'trim|required');
        $this->form_validation->set_rules('name', 'User name', 'trim|required');
        //$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required|min_length[5]|max_length[12]');
        $this->form_validation->set_rules('email_id', 'Email', 'trim|required|valid_email');
        if($password!=$cnf_password)
        {
            $this->session->set_flashdata('error_msg',"Password and confirm password does not match");
            redirect("customer/profile");
        }
        elseif ($this->form_validation->run() == FALSE)
        {
            $this->session->set_flashdata('error_msg',"Please enter valid details");
            redirect("customer/profile");
        }else{
            if($_POST["ispwdedit"]=="1"){
                $password=$this->passwordEncrypt($password);
                if($this->session->userdata('child_id') != ""){
                    $id = $this->session->userdata('child_id');
                    $sql="update tb_customer_logins set countrycode='".$com."', name='".$nam."', email_id='".$ema."', password='".$password."' where id=".$id;
                }else{
                    $sql="update tb_customers set country='".$com."', name='".$nam."', email_id='".$ema."', password='".$password."' where id=".$id;
                }
                $upd = $this->db->query($sql);
                $this->session->set_flashdata('success_msg',"Updated Successfully");
                redirect('customer/profile');
            }else if($_POST["ispwdedit"]=="0"){
                if($this->session->userdata('child_id') != ""){
                    $id = $this->session->userdata('child_id');
                    $sql="update tb_customer_logins set countrycode='".$com."', name='".$nam."', email_id='".$ema."' where id=".$id;
                }else{
                    $sql="update tb_customers set country='".$com."', name='".$nam."', email_id='".$ema."' where id=".$id;
                }
                $upd = $this->db->query($sql);
                $this->session->set_flashdata('success_msg',"Updated Successfully");
                redirect('customer/profile');
            }
        }
    }

    function passwordEncrypt($str)
    {
        return password_hash($str, PASSWORD_DEFAULT);
    }

    public function activeorders(){
        $data['page_title']=$this->lang->line('menu_active');
        $data['sub_title']=$this->lang->line('active_bookings');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $inp = 0;
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if(!empty($input)){
            if(!empty($input['bookingid'])){
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('".$bookids."')";
            }
            if(isset($input['pickup']) && !empty($input['pickup'])){
                $inp = 1;
                $whr .= " AND (o.pickup_country LIKE '%".$input['pickup']."%' OR o.pickup_city LIKE '%".$input['pickup']."%') ";
            }
            if(isset($input['drop']) && !empty($input['drop'])){
                $inp = 1;
                $whr .= " AND (o.delivery_country LIKE '%".$input['drop']."%' OR o.delivery_city LIKE '%".$input['drop']."%') ";
            }
            if(isset($input['fromdate_search'])){
                if($input['fromdate_search'] != ""){
                    $inp = 1;
                    $input['fromdate_search'] = date("Y-m-d",strtotime($input['fromdate_search']));
                    $whr .= " AND DATE(o.createdon) >='".$input['fromdate_search']."' ";
                }
            }
            if(isset($input['todate_search'])){
                if($input['todate_search'] != ""){
                    $inp = 1;
                    $input['todate_search'] = date("Y-m-d",strtotime($input['todate_search']));
                    $whr .= " AND DATE(o.createdon) <='".$input['todate_search']."' ";
                }
            }

            $getords = array();
            if(isset($input['reference'])){
                if(!empty($input['reference'])){
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getActiveOrdersbyRef($reference);
                }
            }
            if(isset($input['order_type'])){
                if(!empty($input['order_type'])){
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getActiveOrdersbyRefOT("OT",$ordtye);
                    if(!empty($getords1)){
                        $getords = array_merge($getords,$getords1);
                    }else{
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if(!empty($getords2)){
                            $getords = array_merge($getords,$getords2);
                        }
                    }
                }
            }
            if(!empty($getords)){
                $gords = implode("','",$getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if($inp == 1 && $whr == ""){
            $whr .= " AND o.id IN(0) ";
        }
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $whr1 = $whr2 = "";
        if(!empty($subcusts)){
            $whr1 .= " AND e.customer_id IN (".implode(',', $subcusts).") ";
            $whr2 .= " o.customer_id IN (".implode(',', $subcusts).") ";
        }else{
            $whr1 = " AND e.customer_id=".$cid;
            $whr2 = " o.customer_id=".$cid." ";
        }
        $mainqry = "SELECT o.id FROM tb_orders o WHERE o.status !=0 AND (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.trip_sts=0 AND $whr2 $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $custord1 = $this->db->query($mainqry);
        $pgcnt = $custord1->num_rows();
        $config = array();
        $config["base_url"] = base_url() . "customer/activeorders";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $mainqry = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.plat,o.plng FROM tb_orders o WHERE $whr2 AND o.status != 0 AND o.trip_sts=0 AND (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
        $custord = $this->db->query($qry);
        if($custord->num_rows()>0){
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('customer/activeorders',$data);
    }

    function getActiveOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refid)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.trip_id!=0 AND o.trip_sts=0 AND r.ref_value IN('".$refid."') $whr AND r.status=1");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    function getActiveOrdersbyRefOT($refnum,$refval){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refval)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.trip_id!=0 AND o.trip_sts=0 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') $whr AND r.status=1");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    function getPendingOrdersbyRef($refid){

        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refid)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            if($this->session->userdata('company_code') == 'NZKN'){
                $whr .= ' AND o.order_status != "READY"';
            }
            $qry = $this->db->query("select o.id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.trip_id=0 AND o.trip_sts=0 AND r.ref_value IN('".$refid."') $whr AND r.status=1");

            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;

    }

    function getPendingOrdersbyRefOT($refnum,$refval){

        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refval)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            if($this->session->userdata('company_code') == 'NZKN'){
                $whr .= ' AND o.order_status != "READY" ';
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.trip_id=0 AND o.trip_sts=0 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') $whr AND r.status=1");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;

    }

    function getCompletedOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refid)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select o.id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id $whr AND o.trip_sts=1 AND r.ref_value IN('".$refid."') AND r.status=1");

            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }

    function getCompletedOrdersbyRefOT($refnum,$refval){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refval)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id $whr AND o.trip_sts=1 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') AND r.status=1");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    public function pendingorders(){

        $data['page_title']=$this->lang->line('menu_pending');
        $data['sub_title']=$this->lang->line('menu_pending')." ".$this->lang->line('bookings');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $inp = 0;
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if(!empty($input)){
            if(!empty($input['bookingid'])){
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('".$bookids."')";
            }
            if(isset($input['pickup'])){
                if($input['pickup'] != ""){
                    $inp = 1;
                    $whr .= " AND (o.pickup_country LIKE '%".$input['pickup']."%' OR o.pickup_city LIKE '%".$input['pickup']."%') ";
                }
            }
            if(isset($input['drop'])){
                if($input['drop'] != ""){
                    $inp = 1;
                    $whr .= " AND (o.delivery_country LIKE '%".$input['drop']."%' OR o.delivery_city LIKE '%".$input['drop']."%') ";
                }
            }
            if(isset($input['fromdate_search'])){
                if($input['fromdate_search'] != ""){
                    $inp = 1;
                    $input['fromdate_search'] = date("Y-m-d",strtotime($input['fromdate_search']));
                    $whr .= " AND DATE(o.createdon) >='".$input['fromdate_search']."' ";
                }
            }
            if(isset($input['todate_search'])){
                if($input['todate_search'] != ""){
                    $inp = 1;
                    $input['todate_search'] = date("Y-m-d",strtotime($input['todate_search']));
                    $whr .= " AND DATE(o.createdon) <='".$input['todate_search']."' ";
                }
            }

            $getords = array();
            if(isset($input['reference'])){
                if(!empty($input['reference'])){
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getPendingOrdersbyRef($reference);
                }
            }
            if(isset($input['order_type'])){
                if(!empty($input['order_type'])){
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getPendingOrdersbyRefOT("OT",$ordtye);
                    if(!empty($getords1)){
                        $getords = array_merge($getords,$getords1);
                    }else{
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if(!empty($getords2)){
                            $getords = array_merge($getords,$getords2);
                        }
                    }
                }
            }

            if(!empty($getords)){
                $gords = implode("','",$getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if($inp == 1 && $whr == ""){
            $whr .= " AND o.id IN(0) ";
        }
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $whr2 = "";
        if(!empty($subcusts)){
            $whr2 .= " o.customer_id IN (".implode(',', $subcusts).") AND ";
        }else{
            $whr2 = " o.customer_id=".$cid." AND ";
        }
        if($this->session->userdata('company_code') == 'NZKN'){
            $whr .= ' AND o.order_status != "READY" ';
        }
        $custord1 = $this->db->query("SELECT o.id FROM tb_orders o WHERE o.status !=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND $whr2 o.trip_sts=0 $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC");
        $pgcnt = $custord1->num_rows();
        $config = array();
        $config["base_url"] = base_url() . "customer/pendingorders";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $mainqry = "SELECT o.id,o.order_id,convertToClientTZ(o.pickup_datetime,'".$curtz."') as pickup_datetime, o.pickup_city, o.pickup_country, convertToClientTZ(o.delivery_datetime,'".$curtz."') as delivery_datetime,o.delivery_city,o.delivery_country FROM tb_orders o WHERE $whr2 o.trip_sts=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.status!=0 $whr GROUP BY o.order_id";
        $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
        $custord = $this->db->query($qry);
        if($custord->num_rows()>0){
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('customer/pendingorders',$data);

    }

    public function readyorders(){
        if (!checkUrlAccessForUser('READYORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data['page_title']=$this->lang->line('menu_ready');
        $data['sub_title']=$this->lang->line('ready_orders');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $inp = 0;
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if(!empty($input)){
            if(!empty($input['bookingid'])){
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('".$bookids."')";
            }
            if(isset($input['pickup'])){
                if($input['pickup'] != ""){
                    $inp = 1;
                    $whr .= " AND (o.pickup_country LIKE '%".$input['pickup']."%' OR o.pickup_city LIKE '%".$input['pickup']."%') ";
                }
            }
            if(isset($input['drop'])){
                if($input['drop'] != ""){
                    $inp = 1;
                    $whr .= " AND (o.delivery_country LIKE '%".$input['drop']."%' OR o.delivery_city LIKE '%".$input['drop']."%') ";
                }
            }
            if(isset($input['fromdate_search'])){
                if($input['fromdate_search'] != ""){
                    $inp = 1;
                    $getactual = getdatetimebytimezone(DFLT_TZ,$input['fromdate_search'],$curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $whr .= " AND DATE(o.pickup_datetime)='".$input['fromdate_search']."' ";
                }
            }
            if(isset($input['todate_search'])){
                if($input['todate_search'] != ""){
                    $inp = 1;
                    $getactual = getdatetimebytimezone(DFLT_TZ,$input['todate_search'],$curtz);
                    $input['todate_search'] = $getactual['date'];
                    $whr .= " AND DATE(o.delivery_datetime)='".$input['todate_search']."' ";
                }
            }

            $getords = array();
            if(isset($input['reference'])){
                if(!empty($input['reference'])){
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getReadyOrdersbyRef($reference);
                }
            }
            if(isset($input['order_type'])){
                if(!empty($input['order_type'])){
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getReadyOrdersbyRefOT("OT",$ordtye);
                    if(!empty($getords1)){
                        $getords = array_merge($getords,$getords1);
                    }else{
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if(!empty($getords2)){
                            $getords = array_merge($getords,$getords2);
                        }
                    }
                }
            }

            if(!empty($getords)){
                $gords = implode("','",$getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if($inp == 1 && $whr == ""){
            $whr .= " AND o.id IN(0) ";
        }
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $whr2 = "";
        if(!empty($subcusts)){
            $whr2 .= " o.customer_id IN (".implode(',', $subcusts).") AND ";
        }else{
            $whr2 = " o.customer_id=".$cid." AND ";
        }
        $whr2 .= " o.order_status ='READY' AND ";
        $custord1 = $this->db->query("SELECT count(o.id) as cnt FROM tb_orders o WHERE o.status !=0 AND o.trip_id=0 AND $whr2 o.trip_sts=0 $whr");
        $pgcnt = $custord1->row()->cnt;
        $config = array();
        $config["base_url"] = base_url() . "customer/pendingorders";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $mainqry = "SELECT o.id,o.order_id,convertToClientTZ(o.pickup_datetime,'".$curtz."') as pickup_datetime, o.pickup_city, o.pickup_country, convertToClientTZ(o.delivery_datetime,'".$curtz."') as delivery_datetime,o.delivery_city,o.delivery_country FROM tb_orders o WHERE $whr2 o.trip_sts=0 AND o.trip_id=0 AND o.status!=0 $whr";
        $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
        $custord = $this->db->query($qry);
        if($custord->num_rows()>0){
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('customer/readyorders',$data);
    }
    function getReadyOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refid)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select o.id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.trip_id=0 AND o.trip_sts=0 AND r.ref_value IN('".$refid."') $whr AND r.status=1 AND o.order_status = 'READY' ");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }

    function getReadyOrdersbyRefOT($refnum,$refval){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refval)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select o.id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND o.trip_id=0 AND o.trip_sts=0 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') $whr AND r.status=1 AND o.order_status = 'READY' ");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    public function doneorders(){
        $data['page_title']=$this->lang->line('menu_completed');
        $data['sub_title']=$this->lang->line('menu_completed')." ".$this->lang->line('bookings');
        $data['ord_type'] = "done";
        $data['orders'] = array();
        $inp = 0;
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if(!empty($input)){
            if(!empty($input['bookingid'])){
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('".$bookids."')";
            }
            if(isset($input['pickup'])){
                if($input['pickup'] != ""){
                    $inp = 1;
                    $whr .= " AND (o.pickup_country LIKE '%".$input['pickup']."%' OR o.pickup_city LIKE '%".$input['pickup']."%') ";
                }
            }
            if(isset($input['drop'])){
                if($input['drop'] != ""){
                    $inp = 1;
                    $whr .= " AND (o.delivery_country LIKE '%".$input['drop']."%' OR o.delivery_city LIKE '%".$input['drop']."%') ";
                }
            }
            if(isset($input['fromdate_search'])){
                if($input['fromdate_search'] != ""){
                    $inp = 1;
                    $input['fromdate_search'] = date("Y-m-d",strtotime($input['fromdate_search']));
                    $whr .= " AND DATE(o.createdon) >='".$input['fromdate_search']."' ";
                }
            }
            if(isset($input['todate_search'])){
                if($input['todate_search'] != ""){
                    $inp = 1;
                    $input['todate_search'] = date("Y-m-d",strtotime($input['todate_search']));
                    $whr .= " AND DATE(o.createdon) <='".$input['todate_search']."' ";
                }
            }

            $getords = array();
            if(isset($input['reference'])){
                if(!empty($input['reference'])){
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getCompletedOrdersbyRef($reference);
                }
            }
            if(isset($input['order_type'])){
                if(!empty($input['order_type'])){
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getCompletedOrdersbyRefOT("OT",$ordtye);
                    if(!empty($getords1)){
                        $getords = array_merge($getords,$getords1);
                    }else{
                        $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                        if(!empty($getords2)){
                            $getords = array_merge($getords,$getords2);
                        }
                    }
                }
            }

            if(!empty($getords)){
                $gords = implode("','",$getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if($inp == 1 && $whr == ""){
            $whr .= " AND o.id IN(0) ";
        }
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $whr2 = "";
        if(!empty($subcusts)){
            $whr2 .= " o.customer_id IN (".implode(',', $subcusts).") AND ";
        }else{
            $whr2 = " o.customer_id=".$cid." AND ";
        }
        $mainqry = "SELECT count(o.id) as cnt FROM tb_orders o WHERE ".$whr2." (o.trip_sts=1 OR (o.trip_sts = 0 AND o.status = 3)) $whr ORDER BY o.id DESC";
        $custord1 = $this->db->query($mainqry);
        $pgcnt = $custord1->row()->cnt;
        $config = array();
        $config["base_url"] = base_url() . "customer/doneorders";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $mainqry2 = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.shift_id,o.trip_id FROM tb_orders o WHERE ".$whr2." (o.trip_sts=1 OR (o.trip_sts = 0 AND o.status = 3)) $whr GROUP BY o.order_id ORDER BY o.id DESC";
        $qry = $mainqry2 . ' LIMIT ' . $page . ',' . $config["per_page"];
        $custord = $this->db->query($qry);
        if($custord->num_rows()>0){
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('customer/doneorders',$data);
    }

    public function downloadepod($order_id = '', $pdf = "0")
    {
        $data['ord_type'] = "done";
        if (strlen($order_id) > 0) {
            $order_id = $order_id;
            $userid = $this->session->userdata('user_id');
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $data['order_id'] = $order_id;
            $data['userid'] = $userid;
            $curdt = date('Y-m-d H:i:s');
            $data["order"] = $this->db->select("id,order_id,pickup_datetime,delivery_datetime,pickup_address1,delivery_address1")->get_where("tb_orders", ["id" => $order_id], 1, 0)->row();
            $data["pod"] = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,ts.hash,dt.type_name,ts.createdby,ts.createdon,ts.imgpath,e.address,e.order_id,e.pickup,e.drop,e.order_id from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE ts.order_id=? AND ts.status=? GROUP BY ts.id ORDER BY ts.createdon ASC",[$order_id,1]);

            $data["orderref"] = $this->db->query("SELECT group_concat(ref_value) as reference_id FROM tb_order_references WHERE order_id=$order_id AND status=1");

            $statuses = $this->common->gettbldata([
                'order_id' => $order_id,
                'status_id' => 1,
                "stop_type IN ('P', 'D')"
            ], ['id', 'stop_type', 'comment'], 'tb_stop_status', 2, 0);
            $keys = array_column($statuses, 'stop_type');
            $values = array_column($statuses, 'comment');
            $statuses = array_combine($keys, $values);
            $data['comments'] = $statuses;
            $getDates = $this->Order_details->getPickupAndDeliveryDates($order_id);
            $data['pickup_delivery'] = $getDates;
            if ($pdf == "1") {
                $this->load->view("customer/downloadepod", $data);
            } else {
                $this->load->library('m_pdf');
                $html = $this->load->view('customer/downloadepod', $data, true);
                $this->m_pdf->pdf->WriteHTML($html);
                /*$this->m_pdf->pdf->Output();*/
                $this->m_pdf->pdf->Output('epod' . $data['order']->order_id . '.pdf', 'D');
            }
        }
    }

    public function kpireports(){
        $data['page_title']='KPI Reports';
        $this->settemplate->dashboard('customer/kpireports',$data);
    }

    public function orderdetails(){
        $data['ord_type'] = "done";
        if($this->input->post("order_id")){
            $order_id = $this->input->post("order_id");
            $userid = $this->session->userdata('cust_id');
            $data['userid'] = $userid;
            $data["order"] = $this->db->where(array("id"=>$order_id))->get("tb_orders")->row();
            $data["orderref"] = $this->db->query("SELECT r.reference_id,r.ref_value,t.description FROM tb_order_references r,tb_reference_master t WHERE r.reference_id=t.name AND r.order_id=$order_id AND r.status=1");
            echo $this->load->view("customer/vieworderdetails",$data,TRUE);
        }
    }

    public function getActiveOrdersdetailsType($otype){
        $res = array();
        $cid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if(!empty($otype)){
            $ordertype_id = 0;
            $getordertype_id = $this->db->select('id')->get_where("tb_order_types",array('ordtype_code'=>$otype,'company_code'=>$company_code,'status'=>'1'));
            if($getordertype_id->num_rows()>0){
                $ordertype_id = $getordertype_id->row()->id;
            }else{
                $getordertype = $this->db->select('id')->get_where("tb_order_types",array('ordtype_code'=>$otype,'company_code'=>'SGKN','status'=>'1'));
                if($getordertype->num_rows()>0){
                    $ordertype_id = $getordertype->row()->id;
                }
            }
            if($ordertype_id != 0){
                $order_qry = $this->db->query("select o.id FROM tb_orders o, tb_order_details d where d.order_type='".$ordertype_id."' AND o.user_id= '".$cid."' AND o.id=d.order_row_id");
                if($order_qry->num_rows()>0){
                    foreach ($order_qry->result() as $res1) {
                        $res[] = $res1->id;
                    }
                }
            }

        }

        return $res;
    }

    public function testingtext(){
        $fn = fopen("./statuscodes.txt","r");
        $dt = date("Y-m-d H:i:s");
        $qry = "";
        while(! feof($fn))  {
            $result = fgets($fn);
            $chk = explode(";", $result);
            if(!empty($chk)){
                $code = $chk[0];
                $name = $chk[1];
                $qry .= "INSERT INTO `tbl_status_codes`(`status_name`, `description`, `status_type`, `status_code`, `target_system`, `status`, `createdon`) VALUES ('".$name."','".$name."','yes','".$code."','SG',1,'".$dt."'); <br/>";
            }
        }
        echo $qry;
        fclose($fn);
    }

    public function trackviewmap($ord){
        $data["page_title"] = "MAP";
        if($ord != ""){
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $tripinfo = $this->common->gettblrowdata(array("order_id"=>$ord,"trip_id !="=>0),"trip_id","tb_orders",0,0);
            if(!empty($tripinfo)){
                $trip_id = $tripinfo['trip_id'];
                $data["trip_id"] = $trip_id;
                $chktrip = $this->db->select("id,shift_id,vehicle_id,driver_id,status,dlat as latitude,dlng as longitude")->get_where("tb_trips",array("id"=>$trip_id),1,0);
                if($chktrip->num_rows()>0){
                    $data["trip"]= $trip = $chktrip->row();
                    $driver_row = $this->db->select("id,name,track_type")->where("id",$trip->driver_id)->get("tb_truck_drivers")->row();
                    $data["stops"] = $this->db->query("SELECT id,stopname,stopcity,address,stoptype,convertToClientTZ(startdate,'".$curtz."') as startdate,weight,volume,ship_units from tb_shiporder_stops where shipment_id = ".$trip->shift_id." AND status='1' ORDER BY ordernumber ASC");
                    $data["details"] = [];
                    foreach($data["stops"]->result() as $stop){
                        $det = $this->db->query("SELECT id,plat,plng,pickup,stop_id,convertToClientTZ(pickup_datetime,'".$curtz."') as pickup_datetime,dlat,dlng,`drop`,convertToClientTZ(drop_datetime,'".$curtz."') as drop_datetime, shipment_weight, shipment_volume, order_id from tb_employee where (stop_id = ".$stop->id." OR drop_stopid = ".$stop->id.") AND status = '1'");
                        foreach($det->result() as $row){
                            $details=[];
                            if($row->stop_id == $stop->id){
                                $details["lat"] = $row->plat;
                                $details["lng"] = $row->plng;
                                $details["name"] = $row->pickup;
                                $details["time"] = $row->pickup_datetime;
                                $details["type"] = "P";
                            }else{
                                $details["lat"] = $row->dlat;
                                $details["lng"] = $row->dlng;
                                $details["name"] = $row->drop;
                                $details["time"] = $row->drop_datetime;
                                $details["type"] = "D";
                            }
                            $details["weight"] = $row->shipment_weight;
                            $details["volume"] = $row->shipment_volume;

                            $details["stop_id"] = $stop->id;
                            $details["id"] = $row->id;
                            $details["order_id"] = $row->order_id;
                            $details["alphabet"] = getColName(count($data["details"])+1);
                            $details["status"] = "0";
                            $done = $this->db->query("SELECT ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,'".$curtz."') as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=".$trip->shift_id." AND ss.stop_id = ".$stop->id." AND ss.stop_detail_id = ".$row->id." AND ss.status='1' ORDER BY ss.createdon ASC");
                            $status_row=[];
                            if($done->num_rows()>0){
                                foreach($done->result() as $status){
                                    $status_row["detail_id"] = $row->id;
                                    $status_row["status_id"] = $status->status_id;
                                    $status_row["status_name"] = $status->status_name;
                                    $status_row["in_lat"] = $status->latitude;
                                    $status_row["in_lng"] = $status->longitude;
                                    $status_row["in_time"] = $status->createdon;
                                    $details["statuses"][] = (Object) $status_row;
                                }
                                $details["status"] = "1";
                            }else{
                                $details["statuses"][] = (Object) $status_row;
                            }
                            $data["details"][] = (Object)$details;
                        }
                    }
                    $data["drivers"] = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'".$curtz."') as createdon,d.track_type,td.travelled_km from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status ='1' GROUP BY d.id ORDER BY td.createdon ASC")->result_array();
                    $data["drivers"][] = array("id"=>$driver_row->id,"name"=>$driver_row->name,"contact_num"=>$driver_row->name,"createdon"=>null,"track_type"=>$driver_row->track_type,"travelled_km"=>0);
                    $sts = $trip->status;
                    if($sts == 1){
                        $data["record"] = $this->db->query("SELECT latitude,longitude FROM tb_trucks_data WHERE id = '$trip->vehicle_id' limit 1")->row();
                    }else{
                        $data["record"] = $trip;
                    }
                    $data["isSimBased"] = "false";
                    if (!empty($data["drivers"])){
                        if($data["drivers"][count($data["drivers"])-1]["track_type"] == "1"){
                            $data["isSimBased"] = "true";
                        }
                    }
                    if($data["isSimBased"]){
                        $data["records"] = $this->db->query("SELECT latitude,longitude,speed,`timestamp` FROM tb_rtdrive_locations WHERE trip_id = '$trip_id' order by `timestamp`");
                    }
                    $this->settemplate->dashboardtemp('customer/tripMap',$data);
                }else{
                    echo "";
                }
            }else{
                echo "";
            }
        }else{
            echo "";
        }
    }

    public function statusviewdetails(){
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        if($ord != ""){
            $tripinfo = $this->order_details->getOrderRouteDetails($ord);
            if(!empty($tripinfo)){
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $shift_id = $tripinfo['shift_id'];
                $whr = " AND status = 1";
                $dlat = $tripinfo['dlat'];
                $dlng = $tripinfo['dlng'];
                $slat = $tripinfo['plat'];
                $slng = $tripinfo['plng'];
                $order_row_id = $tripinfo['id'];
                $data["drivers"] = array();
                $trip_id = $tripinfo['trip_id'];
                if($trip_id != 0){
                    $qry = $this->db->query("SELECT id,vehicle_id,status,dlat as latitude,dlng as longitude FROM tb_trips WHERE id='$trip_id' ORDER BY id DESC LIMIT 1");
                    if($qry->num_rows() > 0){
                        $sts = $qry->row()->status;
                        if ( $slat == '' && $slng == '' ) {
                            if($sts == 1){
                                $rec = $this->db->query("SELECT latitude,longitude from tb_trucks_data WHERE id = '".$qry->row()->vehicle_id."' LIMIT 1");
                                if($rec->num_rows()>0){
                                    $slat = $rec->row()->latitude;
                                    $slng = $rec->row()->longitude;
                                }
                            }else{
                                $slat = $qry->row()->latitude;
                                $slng = $qry->row()->longitude;
                            }
                        }
                        $drivers = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'".$curtz."') as createdon from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id = $trip_id AND td.status =1 GROUP BY d.id ORDER BY td.createdon ASC");
                        if($drivers->num_rows()>0){
                            $data["drivers"] = $drivers->result_array();
                        }
                    }
                }
                $order_status=array();
                if($this->session->userdata('company_code') == 'AUKN'){
                    $order_where=array('s.order_id'=>$ordid);
                    $order_status=$this->orderStatus($order_where);
                    /* log_message('error',"order status :::".$this->db->last_query()."<--"."array ::".json_encode($order_status)); */
                }
                $data["history1"] = $order_status;
                $data["history"] = $this->statusremappingservice->getOrderStatuses([
                    'timeZone' => $curtz,
                    'bookingId' => $ord,
                    'shiftId' => $shift_id,
                    'carrierName' => $tripinfo['name'],
                    'companyCode' => $this->session->userdata('company_code'),
                    'orderRowId'=>$order_row_id
                ]);
                $data["slat"] = $slat;
                $data["slng"] = $slng;
                $data["dlat"] = $dlat;
                $data["dlng"] = $dlng;
                $data['epod'] = array();
                $data['epodp'] = array();
                if (!checkAccessConditions('RELATED_2_NZPG', $this->session->userdata('company_code'))) {
                    $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", ["stop_type" => "D", "doc_type" => 3, "order_id" => $order_row_id, "status" => 1], 1, 0);
                    if ($docs->num_rows() > 0) {
                        $data['epod'] = ["status_code" => "3060", "status_name" => "ePOD Available", "stop_id" => $docs->row()->stop_id, "stop_type" => $docs->row()->stop_type, "location" => getLocationName($docs->row()->latitude, $docs->row()->longitude), "createdon" => $docs->row()->createdon];
                    }
                    $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", ["stop_type" => "P", "doc_type" => 3, "order_id" => $order_row_id, "status" => 1], 1, 0);
                    if ($docs->num_rows() > 0) {
                        $data['epodp'] = ["status_code" => "2490", "status_name" => "Goods Loaded for Delivery", "stop_id" => $docs->row()->stop_id, "stop_type" => $docs->row()->stop_type, "location" => getLocationName($docs->row()->latitude, $docs->row()->longitude), "createdon" => $docs->row()->createdon];
                    }
                }
                echo $this->load->view("customer/statusview",$data,TRUE);
            }
        }
    }

    private function orderStatus($where){
        $result = array();
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $this->db->select("s.status_id,s.latitude,s.longitude,s.status_code,convertToClientTZ(s.status_date,'".$curtz."') as status_date,sm.status_name");
        $this->db->from('tb_order_status s');
        $this->db->join('tb_status_master sm', 'sm.id=s.status_id', 'LEFT');
        $this->db->where($where);
        $this->db->group_by('s.status_code');
        $this->db->order_by('s.id','ASC');
        $res = $this->db->get();
        if($res){
            if($res->num_rows() > 0){
                $result = $res->result_array();
            }
        }
        return $result;
    }

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata(["order_id" => $ord], "id,order_id,company_code,branch_code,shift_id,trip_id", "tb_orders", 0, 0);
        if (!empty($tripinfo)) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data['ord_type'] = $this->input->post("type");
            $data['ship_id'] = $tripinfo['shift_id'] ?? 0;
            $data['trip_id'] = $tripinfo['trip_id'] ?? 0;
            $orderRowId = $tripinfo['id'];
            $sql1 = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.order_id = ? ANd ts.status =? GROUP BY ts.id",[$orderRowId,1]);
            if ($sql1->num_rows() > 0) {
                $i = 1;
                foreach ($sql1->result_array() as $eachRow) {
                    $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    $pods[] = [
                        'sno' => $i,
                        'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                        'type_name' => $eachRow['type_name'],
                        'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                        'stop_id' => $eachRow['stop_id'],
                        'stop_type' => $eachRow['stop_type'],
                        'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                        'extention' => $base64DocumentData['extention'],
                        'file_content' => $base64DocumentData['file_content'],
                    ];
                    $i++;
                }
            }
            $data["pods"] = $pods ?? [];
            echo $this->load->view("customer/managedocuments", $data, true);
        }
    }

    public function visibility()
    {
        $data["page_title"] = $this->lang->line('shipment_visibility');
        $customerId = $this->session->userdata('cust_id');
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $data["orders"] = $shiftsData = [];
        $post = $this->input->post(null, true);
        $tableName = 'tb_shifts s';
        $indexColumn = $groupBy = 's.id';
        $excludeCountQuery = 'Yes';
        $userWhere = " s.customer_id = '" . $customerId . "' ";
        $finalShiftIds = $this->ShipmentVisibilityModel->getNormalTripsFroVisibility($post, [], $userWhere, $tableName, $indexColumn, $groupBy, $excludeCountQuery);
        if (!empty($finalShiftIds)) {
            $finalShiftIds = array_unique($finalShiftIds);
            $pageCount = count($finalShiftIds);
            $config = [];
            $config["base_url"] = base_url() . "customer/visibility";
            $config["total_rows"] = $pageCount;
            $config["per_page"] = 10;
            $config["uri_segment"] = 3;
            $config['display_pages'] = true;
            $this->pagination->initialize($config);
            $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if (!is_numeric($page)) {
                $page = 0;
            }
            $shiftsData = $this->ShipmentVisibilityModel->getFinalTripsList($finalShiftIds, $page, $config['per_page'], $tableName, $indexColumn, $groupBy, $excludeCountQuery);
        }
        foreach ($shiftsData as $row) {
            if (isset($row['startdate'])) {
                $startdate = getdatetimebytimezone($currentTimeZone, $row['startdate'], DFLT_TZ);
                $row['startdate'] = $startdate['datetime'];
            }
            if (isset($row['enddate'])) {
                $enddate = getdatetimebytimezone($currentTimeZone, $row['enddate'], DFLT_TZ);
                $row['enddate'] = $enddate['datetime'];
            }
            if ($row['register_number'] == "") {
                if ($row['vehicle_id'] != "") {
                    $getRegisterNumber = $this->db->query("SELECT register_number FROM tb_trucks_data WHERE id = ? LIMIT 1", [$row['vehicle_id']]);
                    if ($getRegisterNumber->num_rows() > 0) {
                        $row['register_number'] = $getRegisterNumber->row()->register_number;
                    }
                }
            }
            $dd = gettripstopdetails($row, $rej = false);
            $data["orders"][] = $dd;
        }
        $this->settemplate->dashboard("customer/visibility", $data);
    }

    public function fleetview()
    {
        $uid = $this->session->userdata('user_id');
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $data["page_title"] = $this->lang->line('fleet_view');
        $data["sub_title"]  = $this->lang->line('menu_visibility');
        if (isset($_POST["todate_search"]) && strlen($_POST["todate_search"]) > 0) {
            $enddt = date('Y-m-d H:i:s', strtotime($_POST["todate_search"]));
            $getactual = getdatetimebytimezone(DFLT_TZ,$enddt,$curtz);
            $enddt = $getactual['datetime'];
        } else {
            $enddt = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ,$enddt,$curtz);
            $enddt = $getactual['datetime'];
        }
        if (isset($_POST["fromdate_search"]) && strlen($_POST["fromdate_search"]) > 0) {
            $startdt = date('Y-m-d H:i:s', strtotime($_POST["fromdate_search"]));
            $getactual = getdatetimebytimezone(DFLT_TZ,$startdt,$curtz);
            $startdt = $getactual['datetime'];
        } else {
            $startdt = date('Y-m-d H:i:s', strtotime('-7 days'));
            $getactual = getdatetimebytimezone(DFLT_TZ,$startdt,$curtz);
            $startdt = $getactual['datetime'];
        }
        $post = array('fromdate_search' => date('Y-m-d', strtotime($startdt)), 'todate_search' => date('Y-m-d', strtotime($enddt)), 'dbsearchvehicle' => '', 'durationwise' => 1);
        if (isset($_POST['durationwise'])) {
            $post = $_POST;
            if ($post['fromdate_search'] != "") {
                $startdt = trim($post['fromdate_search']);
            }
            if ($post['todate_search'] != "") {
                $enddt = trim($post['todate_search']);
            }
        }
        $data['post'] = $post;
        $mainqry = "SELECT e.order_id FROM tb_orders e WHERE e.customer_id=$cid AND e.trip_id!=0 AND e.trip_sts=0 GROUP BY e.order_id";
        $data["intransit"] = $this->db->query($mainqry);
        $mainqry2 = "SELECT id FROM tb_orders WHERE customer_id=$cid AND trip_id=0 AND trip_sts=0 AND status!=0";
        /*log_message("error",$mainqry2);*/
        $data["pending"] = $this->db->query($mainqry2);

        $mainqry = "SELECT id FROM tb_orders WHERE customer_id=$cid AND trip_sts=1";
        /*AND t.stime >= '$startdt' AND t.stime <= '$enddt' */
        $data["completed"] = $this->db->query($mainqry);
        /*$mainqry = "SELECT a.id FROM tb_trip_alerts a,tb_orders e WHERE a.trip_id=e.trip_id AND e.customer_id=$cid GROUP BY a.id ORDER BY a.id DESC";*/
        /*AND t.stime >= '$startdt' AND t.stime <= '$enddt' */
        $data["notifys"] = 0;
        if ($this->session->userdata('company_code') === "CNKN") {
            $this->settemplate->dashboard("customer/fleetview_china", $data);
        }elseif ($this->session->userdata("map_type") == 0) {
            $this->settemplate->dashboard("customer/fleetview", $data);
        } else if ($this->session->userdata("map_type") == 1) {
            $this->settemplate->dashboard("customer/fleetview_eu", $data);
        } else {
            $this->settemplate->dashboard("customer/fleetview", $data);
        }
    }

    public function trackbyship()
    {
        $uid = $this->session->userdata('user_id');
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $data["page_title"] = $this->lang->line('track_by_shipment');
        $data["sub_title"]  = $this->lang->line('menu_visibility');
        if (isset($_POST["todate_search"]) && strlen($_POST["todate_search"]) > 0) {
            $enddt = date('Y-m-d H:i:s', strtotime($_POST["todate_search"]));
            $getactual = getdatetimebytimezone(DFLT_TZ,$enddt,$curtz);
            $enddt = $getactual['datetime'];
        } else {
            $enddt = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ,$enddt,$curtz);
            $enddt = $getactual['datetime'];
        }
        if (isset($_POST["fromdate_search"]) && strlen($_POST["fromdate_search"]) > 0) {
            $startdt = date('Y-m-d H:i:s', strtotime($_POST["fromdate_search"]));
            $getactual = getdatetimebytimezone(DFLT_TZ,$startdt,$curtz);
            $startdt = $getactual['datetime'];
        } else {
            $startdt = date('Y-m-d H:i:s', strtotime('-7 days'));
            $getactual = getdatetimebytimezone(DFLT_TZ,$startdt,$curtz);
            $startdt = $getactual['datetime'];
        }
        $post = array('fromdate_search' => date('Y-m-d', strtotime($startdt)), 'todate_search' => date('Y-m-d', strtotime($enddt)), 'dbsearchvehicle' => '', 'durationwise' => 1);
        if (isset($_POST['durationwise'])) {
            $post = $_POST;
        }
        $data['post'] = $post;
        /*$data["intransit"] = $this->db->query("SELECT t.id as trip_id,s.* FROM tb_trips t LEFT JOIN tb_shifts s ON s.id = t.shift_id WHERE t.status='1' AND s.customer_id='$cid' AND t.stime >= '$startdt' AND t.stime <= '$enddt'");
        $data["all"] = $this->db->query("SELECT t.id as trip_id,s.* FROM tb_trips t LEFT JOIN tb_shifts s ON s.id = t.shift_id WHERE s.customer_id='$cid' AND t.stime >= '$startdt' AND t.stime <= '$enddt'");*/
        if ($this->session->userdata('company_code') == "CNKN") {
            $this->settemplate->dashboard("customer/trackbyship_china", $data);
        }elseif ($this->session->userdata("map_type") == 0) {
            $this->settemplate->dashboard("customer/trackbyship", $data);
        } else if ($this->session->userdata("map_type") == 1) {
            $this->settemplate->dashboard("customer/trackbyship_eu", $data);
        } else {
            $this->settemplate->dashboard("customer/trackbyship", $data);
        }
    }

    function downloadexcel() {
        ini_set("memory_limit","256M");
        $data['page_title']='Completed';
        $data['sub_title']='Completed Bookings';
        $data['orders'] = $orderIds = [];
        $inputdt = $this->input->post();
        if (isset($inputdt['excel_export'])) {
            for ($i = 0; $i < count($inputdt['excel_export']); $i++) {
                $orderIds[] = $inputdt['excel_export'][$i];
            }
        }
        if(!empty($orderIds)){
            $whr = "AND o.id IN(".implode(',', $orderIds).")";
            $d = $s= $t = 0;
            $cid = $this->session->userdata("cust_id");
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $mainqry = "SELECT o.id,o.order_id,o.pickup_company,o.pickup_country,o.pickup_city,o.pickup_pincode,o.pickup_address1,o.delivery_company,o.delivery_country,o.delivery_city,o.delivery_pincode,o.delivery_address1,convertToClientTZ(o.pickup_datetime,'".$curtz."') as pickup_datetime, t.shift_id, convertToClientTZ(t.etime,'".$curtz."') as act_etime,c.phone as custid FROM tb_trips t,tb_orders o,tb_customers c WHERE t.shift_id=o.shift_id AND o.customer_id=$cid AND o.`trip_sts`=1 $whr AND o.customer_id=c.id GROUP BY o.order_id ORDER BY t.id DESC";
            $result = $this->db->query($mainqry);
            if($result->num_rows()>0){
                foreach($result->result() as $res){
                    $epods['pod'] = $epods['signature'] = $epods['others'] = array();
                    $pods = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,ts.doc_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'".$curtz."') as createdon,ts.imgpath,e.stopname from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type LEFT JOIN tb_shiporder_stops e ON e.id = ts.stop_id WHERE ts.shipment_id = '".$res->shift_id."' AND ts.status=1 GROUP BY ts.id ORDER BY ts.createdon ASC");
                    if($pods->num_rows()>0){
                        foreach($pods->result() as $pres){
                            if($pres->doc_type == '3'){
                                $epods['pod'][] = array("id"=>$pres->id,"stopname"=>$pres->stopname,"createdon"=>$pres->createdon,"type_name"=>$pres->type_name,"imgpath"=>$pres->imgpath,"latitude"=>$pres->latitude,"longitude"=>$pres->longitude);
                            }
                            if($pres->doc_type == '1'){
                                $epods['signature'][] = array("id"=>$pres->id,"stopname"=>$pres->stopname,"createdon"=>$pres->createdon,"type_name"=>$pres->type_name,"imgpath"=>$pres->imgpath,"latitude"=>$pres->latitude,"longitude"=>$pres->longitude);
                            }
                            if($pres->doc_type == '2'){
                                $epods['others'][] = array("id"=>$pres->id,"stopname"=>$pres->stopname,"createdon"=>$pres->createdon,"type_name"=>$pres->type_name,"imgpath"=>$pres->imgpath,"latitude"=>$pres->latitude,"longitude"=>$pres->longitude);
                            }
                        }
                    }

                    $data['orders'][] = array("id"=>$res->id,"order_id"=>$res->order_id,"ref_num"=>getQRrefsbyorderId($res->order_id),"custid"=>$res->custid,"pickup_company"=>$res->pickup_company,"pickup_country"=>$res->pickup_country,"pickup_city"=>$res->pickup_city,"pickup_pincode"=>$res->pickup_pincode,"pickup_address"=>$res->pickup_address1,"delivery_company"=>$res->delivery_company,"delivery_country"=>$res->delivery_country,"delivery_city"=>$res->delivery_city,"delivery_pincode"=>$res->delivery_pincode,"delivery_address"=>$res->delivery_address1,"pickup_datetime"=>$res->pickup_datetime,"delivery_datetime"=>$res->act_etime,"epods"=>$epods);
                }
            }
            $styleArray = array(
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                ));
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:M1')
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => '0c3b81')
                        )
                    )
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'ID');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CUSTOMER ID');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'BOOKING ID');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Ref Num');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Pickup Location');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Pickup Address');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Pickup Date');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Delivery Location');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Delivery Address');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Delivered Date');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'ePOD');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Signature');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Others');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $rowCount = 2;
            if(count($data['orders'])>0){
                $i = 1;
                foreach($data['orders'] as $orderData){
                    showDocumentsInExcel($orderData, $i, $objPHPExcel, $rowCount);
                    $rowCount++;
                    $i++;
                }
            }
            $fileName = 'ORDERS-'.date("Ymdhis").'.xlsx';
            if ( headers_sent() ) die("**Error: headers sent");
            ob_clean();
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$fileName.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            ob_end_clean();
            $objWriter->save('php://output');
        }else{
            redirect("customer/doneorders");
        }
    }

    public function getrefinfo($type = '')
    {
        $customerIds = [];
        $customerIds[] = $this->session->userdata("cust_id");
        if ($this->session->userdata('sub_cust') !== false) {
            $subCustomerIds = $this->session->userdata('sub_cust');
            if (!empty($subCustomerIds)) {
                $customerIds = array_merge($customerIds, $subCustomerIds);
            }
        }
        $searchTerm = $_POST['searchTerm'] ?? "";
        if (empty($customerIds) || strlen($searchTerm) < 4) {
            echo json_encode([]);
            return;
        }
        $referenceValues = $this->Order_details->getCustomerReferencesBySearchTerm($type, $customerIds, $searchTerm);
        
        echo json_encode($referenceValues);
    }

    public function getbookinfo($type){
        $cid = $this->session->userdata("cust_id");
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $data = array();
        $whr1 = "";
        $post = $this->input->post();
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";

        if(!empty($subcusts)){
            $whr1 .= " o.customer_id IN (".implode(',', $subcusts).") ";
        }else{
            $whr1 .= " o.customer_id=".$cid." ";
        }
        if($searchTerm != ""){
            $whr1 .= " AND o.order_id LIKE '".$searchTerm."%'";
        }
        if($type=='active'){
            $orderref = $this->db->query("SELECT o.order_id FROM tb_orders o WHERE $whr1 AND o.trip_id!=0 AND o.trip_sts=0 GROUP BY o.order_id");
        }else if($type=='ready'){
            $whr1 .= 'AND  o.order_status = "READY" ';
            $orderref = $this->db->query("SELECT o.order_id FROM tb_orders o WHERE $whr1 AND o.trip_id=0 AND o.trip_sts=0 GROUP BY o.order_id");
        }else if($type=='pending'){
            $orderref = $this->db->query("SELECT o.order_id FROM tb_orders o WHERE $whr1 AND o.trip_id=0 AND o.trip_sts=0 GROUP BY o.order_id");
        }else if($type=='done'){
            $orderref = $this->db->query("SELECT o.id,o.order_id FROM tb_orders o WHERE $whr1 AND (o.trip_sts=1 OR (o.trip_sts = 0 AND o.status = 3)) GROUP BY o.order_id ORDER BY o.updatedon DESC");
        }
        if($orderref->num_rows() >0){
            foreach($orderref->result_array() as $ores){
                $data[] = array("id"=>$ores['order_id'], "text"=>$ores['order_id']);
            }
        }
        echo json_encode($data);
    }
    public function getordertypeinfo(){
        $cid = $this->session->userdata("cust_id");
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $data = array();
        $whr1 = "";
        if(!empty($subcusts)){
            $whr1 .= " customer_id IN (".implode(',', $subcusts).") ";
            $ordertypes = $this->db->query("SELECT type_name,ordtype_code FROM tb_order_types WHERE $whr1 AND status=1 GROUP BY type_name");
        }else{
            $whr1 .= " customer_id=".$cid." ";
            $ordertypes = $this->db->query("SELECT type_name,ordtype_code FROM tb_order_types WHERE $whr1 AND status=1 GROUP BY type_name");
        }
        if($ordertypes->num_rows() >0){
            foreach($ordertypes->result_array() as $ores){
                $data[] = array("id"=>$ores['ordtype_code'], "text"=>$ores['type_name']);
            }
        }else{
            $ordertypes = $this->db->select("type_name,ordtype_code")->group_by("type_name")->get_where("tb_order_types",array("status"=>1));
            foreach($ordertypes->result_array() as $ores){
                $data[] = array("id"=>$ores['ordtype_code'], "text"=>$ores['type_name']);
            }
        }
        echo json_encode($data);
    }
    
    public function getVehiclesBySearch($vehicle)
    {
        $result = array();
        $this->db->select('t.id');
        $this->db->from('tb_trip_summary s');
        $this->db->join('tb_trucks_data t', 's.vehicle_id=t.id', 'INNER');
        $this->db->like('t.register_number', $vehicle);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        log_message("error","Inn:".$this->db->last_query());
        return $result;
    }

    public function getTripsByZoneSearch($zone)
    {
        $result = array();
        $shift  = array();
        $this->db->select('s.id');
        $this->db->from('tb_shifts s');
        $this->db->join('tb_shift_zones z', 's.zone_id=z.id', 'INNER');
        $this->db->where('z.id', $zone);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $rw) {
                array_push($shift, $rw->id);
            }
        }
        $this->db->select('id');
        $this->db->from('tb_trips');
        if (!empty($shift)) {
            $this->db->where_in('shift_id', $shift);
        } else {
            $this->db->where('shift_id', 0);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }


    public function getTripsByTypeSearch($shifttype)
    {
        $result = array();
        $this->db->select('t.id');
        $this->db->from('tb_trips t');
        $this->db->join('tb_shifts s', 't.shift_id=s.id', 'INNER');
        $this->db->where('s.trip_type', $shifttype);
        $this->db->group_by('t.id');
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
}