<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";

class CustomerDailyReportForPhilippines extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('CustomerDailyReportModel');
        $this->load->library(['PhpMailerLibrary']);
    }

    public function index()
    {
        $ordersData = $this->CustomerDailyReportModel->getCarrierOrdersReport();
        $orderIds = array_column($ordersData, 'id');
        $cargoDetails = $this->CustomerDailyReportModel->getCargoDetails($orderIds);
        $pendingOrdersGroupedByCustomerCode = $activeOrdersGroupedByCustomerCode = [];
        $customerEmails = $carrierEmails = [];
        foreach ($ordersData as $eachOrderData) {
            $customerEmails[$eachOrderData['customer_code']] = ['email_id' => $eachOrderData['customer_email_id'],'name' => $eachOrderData['customer_name']];
            if ($eachOrderData['shift_id'] > 0) {
                $carrierEmails[$eachOrderData['carrier_code']] = $eachOrderData['carrier_email_id'];
                $activeOrdersGroupedByCustomerCode[$eachOrderData['customer_code']][$eachOrderData['carrier_code']][] = $eachOrderData;
            } else {
                $pendingOrdersGroupedByCustomerCode[$eachOrderData['customer_code']][] = $eachOrderData;
            }
        }
        if (empty($pendingOrdersGroupedByCustomerCode) && empty($activeOrdersGroupedByCustomerCode)) {
            return false;
        }
        $mailData = [
            'cc_mail_ids' => ['m.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com'],
            'to_mail_ids' => ['angelie.omes@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com']
        ];
        foreach ($pendingOrdersGroupedByCustomerCode as $key => $value) {
            $customerName = '';
            $mailData['to_mail_ids'] = [];
            $bccMailIds = ['sol.ignacio@kuehne-nagel.com'];
            if (isset($customerEmails[$key])) {
                $bccMailIds[] = $customerEmails[$key]['email_id'];
                $customerName = $customerEmails[$key]['name'];
            }
            $mailData['bcc_mail_ids'] = $bccMailIds;
            $mailData['subject'] = 'AUTOEMAIL OF PENDING BOOKINGS ('.$customerName.")";
            $fileName = $this->generateExcelReport($key, $value, $cargoDetails, 'pending');
            if ($fileName != '') {
                $this->sendMail($fileName, $mailData);
            }
        }
        foreach ($activeOrdersGroupedByCustomerCode as $customerKey => $carrierWiseDate) {
            foreach ($carrierWiseDate as $key => $value) {
                $customerName = '';
                $mailData['to_mail_ids'] = [];
                $bccMailIds = ['sol.ignacio@kuehne-nagel.com'];
                if (isset($customerEmails[$customerKey])) {
                    $bccMailIds[] = $customerEmails[$customerKey]['email_id'];
                    $customerName = $customerEmails[$customerKey]['name'];
                }
                if (isset($carrierEmails[$key])) {
                    $bccMailIds = array_merge($bccMailIds,explode("; ",$carrierEmails[$key]));
                }
                $mailData['bcc_mail_ids'] = $bccMailIds;
                $mailData['subject'] = 'AUTOEMAIL OF ACTIVE BOOKINGS ('.$customerName .")";
                $fileName = $this->generateExcelReport($customerKey, $value, $cargoDetails, 'active');
                if ($customerKey == '1005751990') {
                    $mailData['to_mail_ids'] = ['angelie.omes@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com'];
                }
                if ($fileName != '') {
                    $this->sendMail($fileName, $mailData);
                }
            }
        }
        return true;
    }

    private function generateExcelReport(string $customerCode, array $ordersData, array $cargoDetails, string $bookingStatus): string
    {
        if (!empty($ordersData)) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = ['memoryCacheSize' => '512MB'];
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:AD1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Customer Name');
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Booking ID');
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Trip ID');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'PickUp Address');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Delivery Address');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'PickUp Status Date & Time');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Delivery Date / Time');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Status');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Actual Pick-Up');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Actual Delivery');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(25);
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'POD Status');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Cargo Type');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(25);
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Goods Description');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Quantity');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Weight');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $activeWorksheet = $objPHPExcel->getActiveSheet();
            $rowCount = 2;
            try {
                foreach ($ordersData as $eachOrderData) {
                    $carrierCode = $eachOrderData['carrier_code'];
                    $status = $eachOrderData['shift_id'] > 0 ? 'ACTIVE' : 'PENDING';
                    $references = explode('?????', $eachOrderData['order_references']);
                    $DQReferenceValue = '';
                    foreach ($references as $eachReference) {
                        $reference = explode(' - ', $eachReference);
                        if (isset($reference[0]) && $reference[0] == 'DQ') {
                            $DQReferenceValue = $reference[1];
                        }
                    }
                    $activeWorksheet->SetCellValue('A' . $rowCount, $eachOrderData['customer_name']);
                    $activeWorksheet->SetCellValue('B' . $rowCount, $eachOrderData['order_id']);
                    $activeWorksheet->SetCellValue('C' . $rowCount, $eachOrderData['shipmentid']);
                    $activeWorksheet->SetCellValue('D' . $rowCount, $eachOrderData['pickupAddress']);
                    $activeWorksheet->SetCellValue('E' . $rowCount, $eachOrderData['deliveryAddress']);
                    $activeWorksheet->SetCellValue('F' . $rowCount, $eachOrderData['early_pickup_datetime']);
                    $activeWorksheet->SetCellValue('G' . $rowCount, $eachOrderData['early_drop_datetime']);
                    $activeWorksheet->SetCellValue('H' . $rowCount, $DQReferenceValue);
                    $activeWorksheet->SetCellValue('I' . $rowCount, $eachOrderData['pickup_company']);
                    $activeWorksheet->SetCellValue('J' . $rowCount, $eachOrderData['delivery_company']);
                    $activeWorksheet->SetCellValue('K' . $rowCount, $status);
                    $activeWorksheet->SetCellValue('L' . $rowCount, $eachOrderData['actual_pickup_datetime']);
                    $activeWorksheet->SetCellValue('M' . $rowCount, $eachOrderData['actual_delivery_datetime']);
                    $activeWorksheet->SetCellValue('N' . $rowCount, $eachOrderData['pod_status']);
                    $activeWorksheet->SetCellValue('O' . $rowCount, $cargoDetails[$eachOrderData['id']]['cargo_type'] ?? '');
                    $activeWorksheet->SetCellValue('P' . $rowCount, $cargoDetails[$eachOrderData['id']]['goods_description'] ?? '');
                    $activeWorksheet->SetCellValue('Q' . $rowCount, $cargoDetails[$eachOrderData['id']]['quantity'] ?? '');
                    $activeWorksheet->SetCellValue('R' . $rowCount, $cargoDetails[$eachOrderData['id']]['weight'] ? $cargoDetails[$eachOrderData['id']]['weight'] . " " . $cargoDetails[$eachOrderData['id']]['weight_unit'] : '');
                    $rowCount++;
                }
            } catch (\Throwable $exception) {
                log_message("error", "Philippines Customer report cannot set cell value - " . $exception->getMessage());
            }
            $fileName = 'Philippines_Customer_Report_' . date("dM_") . $customerCode."_".$bookingStatus."_".($carrierCode ?? ''). '.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if (!file_exists('assets/HKDailyReport')) {
                mkdir('assets/HKDailyReport', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/HKDailyReport/' . $fileName, __FILE__));
                return $fileName;
            } catch (PHPExcel_Writer_Exception $e) {
                log_message("error", "Philippines Customer report PHPExel_Writer_Exception - " . $e->getMessage());
            }
        }
        return '';
    }

    private function sendMail(string $filename, array $mailData): bool
    {
        //log_message("error", "Philippines Customer report data - " . json_encode($mailData));
        $message = "Hello,<br>";
        $message .= "Please find attached for above mentioned subject. " . "<br><br>";
        $message .= "Sincerely,<br>";
        $message .= "Road Logistics<br>";
        $attachmentPath = sprintf('%s/assets/HKDailyReport/%s', FCPATH, $filename);
        $status = false;
        try {
            if ($this->phpmailerlibrary->sendMultipleToMail($mailData['to_mail_ids'], $mailData['subject'], $message, $mailData['cc_mail_ids'], [$attachmentPath], $mailData['bcc_mail_ids'])) {
                $status = true;
            }
        } catch (Exception $e) {
            log_message("error", "Philippines Customer report email failed - " . $e->getMessage());
        }
        return $status;
    }

}
