<?php defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');
class Customerapi extends CI_Controller
{
    /*
     * Android Page for this controller.
     *
     * Maps to the following URL
     *         https://elog360.app/svkonekt_test/customerapi
     *
     */
    public function __construct()
    {
        parent::__construct();
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400'); /*cache for 1 day*/
        }
        /* Access-Control headers are received during OPTIONS requests*/
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }

        }
        // decoding the json array
        $post = json_decode(file_get_contents("php://input"), true);
        //Codiginite helpers
        $this->load->helper('date');
        $this->load->model('cabmodel');
        $this->load->library('sendfirebase');
    }
    public function index()
    {
        //$this->load->view('welcome_message');
        echo "Welcome to Svkonekt Android services";
        //echo "getServices<br>";
        $data['user'] = "";
    }

    public function login()
    {
        $response = [];
        $response = ["status" => 0, "data" => "Not Found"];
        if ($_POST) {
            $mobile = isset($_POST["mobile"]) ? $_POST["mobile"] : '';
            $pwd    = isset($_POST["password"]) ? $_POST["password"] : '';
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            if ($mobile != "" && $pwd != "") {
                $password = password_hash($pwd, PASSWORD_DEFAULT);
                $whr1     = ["phone" => $mobile, "password" => $password, "status" => "1"];
                $sql      = $this->db->get_where("tb_customers", $whr1, 1, 0);
                //log_message("error",$this->db->last_query());
                $cnt     = $sql->num_rows();
                $insdata = ["mobile" => $mobile, "password" => $_POST["password"], "status" => $cnt];
                $res     = $this->db->insert("tb_employee_login_logs", $insdata);
                if ($cnt > 0) {
                    $id = $sql->row()->id;
                    $this->db->where("id", $id)->update("tb_customers", ["gcm_id" => $gcm_id, "updatedon" => date("Y-m-d H:i:s")]);
                    $response = ["status" => 1, "data" => $sql->row_array()];
                } else {
                    $response = ["status" => 0, "data" => "Not Found"];
                }
            } else {
                $response = ["status" => 0, "data" => "Not Found"];
            }
        }
        echo json_encode($response);
    }
    public function updateGCM()
    {
        $response = [
            "status" => 0,
            "data"   => "Not Found",
        ];
        $emp_id = isset($_POST["emp_id"]) ? $_POST["emp_id"] : "";
        $token  = isset($_POST["token"]) ? $_POST["token"] : "";
        if ($emp_id != "" && $token != "") {
            $this->db->where("id", $emp_id)->update("tb_customers", ["gcm_id" => $token]);
            $response = [
                "status" => 1,
                "data"   => "Sucessfully Changed!",
            ];
        } else {
            $response = [
                "status" => 0,
                "data"   => "Invalid Input",
            ];
        }
        echo json_encode($response);
    }
    public function shipments()
    {
        $user_id = $_REQUEST["user_id"];
        $data    = $this->db->query("SELECT s.elat, s.elng, s.etime, s.splace as `from`, s.id, s.shipment_name as name, s.shipment_id as shipmentId, s.slat, s.slng, IF(s.status=1,'Active','Inactive') as status, s.stime, s.eplace as `to`, s.transport_mode as transportMode
from tb_shifts s
WHERE s.customer_id='$user_id'
GROUP BY s.id order by s.status desc,s.stime asc");
        $response = [
            "status" => 1,
            "data"   => $data->result_array(),
        ];
        echo json_encode($response);
    }
    public function shipmentstops()
    {
        $shipment_id = $_REQUEST["shipment_id"];
        $user_id     = $_REQUEST["user_id"];
        $data        = $this->db->query("SELECT e.address,e.capacity,e.drop AS destination,e.dlat,e.dlng,e.enddate,e.id,e.information,l.material,e.name,e.phone,e.shipment_id AS shipmentId,e.ship_type AS shipType,e.plat,e.plng,e.pickup AS `source`, IF(e.status='1','Active','Inactive') AS STATUS,e.startdate,e.stop_order AS stopOrder,e.shipment_volume AS volume,e.shipment_weight AS weight
FROM tb_employee e
JOIN tb_shft_veh_emp sve ON sve.emp_id=e.id AND sve.status=1
JOIN tb_shft_veh sv ON sv.id=sve.shft_veh_id AND sv.status=1
JOIN tb_shifts s ON s.id=sv.shft_id AND s.id=$shipment_id
LEFT JOIN tb_materials l ON l.id=e.material_id
WHERE e.customer_id='$user_id'
GROUP BY e.id
ORDER BY e.status ASC,e.startdate ASC");
        $response = [
            "status" => 1,
            "data"   => $data->result_array(),
        ];
        echo json_encode($response);
    }
    public function notifications()
    {
        $user_id  = $_REQUEST["user_id"];
        $data     = $this->db->query("SELECT * FROM tb_firebase_notifications where emp_id='$user_id' and status=1 and notify_type='Employee' order by created_on desc");
        $response = ["status" => 1, "data" => []];
        foreach ($data->result() as $i => $row) {
            $response["data"][] = ["id" => $row->id, "time" => date("h:i A jS M", strtotime($row->created_on)), "message" => $row->message, "status" => $row->status];
        }
        echo json_encode($response);
    }
    public function clearnotifications()
    {
        $user_id = $_REQUEST["user_id"];
        $this->db->where(["emp_id" => $user_id, "notify_type" => "Employee"])->update("tb_firebase_notifications", ["status" => "0"]);
    }
    public function setshipmentstopstatus()
    {
        $id      = $_REQUEST["id"]; //shipment stop id
        $user_id = $_REQUEST["user_id"];
        $status  = $_REQUEST["status"];
        $this->db->where("id", $id)->update("tb_employee", ["status" => $status]);
        echo '{"status":"1","data":[]}';
    }
    public function setshipmentstatus()
    {
        $id      = $_REQUEST["id"]; //shipment id
        $user_id = $_REQUEST["user_id"];
        $status  = $_REQUEST["status"];
        $this->db->where("id", $id)->update("tb_shifts", ["status" => $status]);
        echo '{"status":"1","data":[]}';
    }
    public function stophistory()
    {
        $user_id  = $_REQUEST["user_id"];
        $stop_id  = $_REQUEST["stop_id"];
        $data     = $this->db->query("SELECT ss.id,ss.createdon,sm.status_name as message FROM tb_stop_status ss JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.stop_id='$stop_id' AND ss.status=1");
        $response = ["status" => 1, "data" => []];
        foreach ($data->result() as $i => $row) {
            $status = 0;
            if ($i == 0) {
                $status = 1;
            }
            $response["data"][] = ["id" => $row->id, "time" => date("h:i A jS F, Y", strtotime($row->createdon)), "message" => $row->message, "status" => $status];
        }
        echo json_encode($response);
    }
    public function testmsg()
    {
        //for sending single user firebse message
        echo $this->sendfirebase->sendSinglePush(["title" => "Test", "message" => "Mesage", "emp_id" => 71, 'type' => 'Customer']);
        //for sending all trip employee firebse message
        echo $this->sendfirebase->sendMultiplePush(["title" => "Test", "message" => "Mesage", "trip_id" => 546, 'type' => 'Customer']);
    }
    public function dashboard()
    {
        $user_id        = $_REQUEST["user_id"];
        $a              = [];
        $a["live"]      = $this->db->query("SELECT * FROM tb_shifts s INNER JOIN tb_trips t on t.shift_id=s.id where t.status='1' and s.customer_id='$user_id'")->num_rows();
        $a["closed"]    = $this->db->query("SELECT * FROM tb_shifts s INNER JOIN tb_trips t on t.shift_id=s.id where t.status='0' and s.customer_id='$user_id'")->num_rows();
        $a["all"]       = $this->db->query("SELECT * FROM tb_shifts s where s.customer_id='$user_id'")->num_rows();
        $a["open"]      = $this->db->query("SELECT * FROM tb_shifts s LEFT JOIN tb_trips t on t.shift_id=s.id and t.status='1' where s.customer_id='$user_id' and t.shift_id is null")->num_rows();
        $data["data"]   = $a;
        $data["status"] = "1";
        echo json_encode($data);
    }

    public function etntestloginold()
    {
        $serviceurl = "https://etra-uat.kuehne-nagel.com/api/v1/auth/login";
        $headers    = [];
        $cookies    = [];
        $headers[]  = 'Content-Type: application/json';
        $headers[]  = 'Accept: application/json, text/plain, */*';
        $headers[]  = 'Authorization: Bearer a3BtZy1jbGllbnQ6S1BNR0AxMjM=';
        $request    = ["username" => "knshipper.02@gmail.com", "password" => "ETNTEST@123", "typeRole" => "ROLE_KNS"];
        $ch         = curl_init($serviceurl);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        /*curl_setopt($ch, CURLOPT_HEADERFUNCTION, "curlResponseHeaderCallback");*/
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if (ENVIRONMENT !== "development") {
            curl_setopt($ch, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
        }
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            print_r($error_msg);
        }
        curl_close($ch);
        print_r($result);
    }

    public function etntestlogin($post = [])
    {
        $cookfile = './assets/tmp/cookies.txt';
        $input    = json_encode($post);
        $curl     = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL            => "https://etra-uat.kuehne-nagel.com/api/v1/auth/login",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => "POST",
            CURLOPT_POSTFIELDS     => $input,
            CURLOPT_HTTPHEADER     => [
                "Accept: application/json, text/plain, */*",
                "Authorization: Basic a3BtZy1jbGllbnQ6S1BNR0AxMjM=",
                "Content-Type: application/json",
            ],
            CURLOPT_COOKIEJAR      => $cookfile,
            CURLOPT_COOKIEFILE     => $cookfile,
        ]);
        if (ENVIRONMENT !== "development") {
            curl_setopt($curl, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
        }
        $result = curl_exec($curl);
        curl_close($curl);
        $res                  = json_decode($result, true);
        $readfile             = file_get_contents($cookfile);
        $res['refresh_token'] = $res['access_token'] = "";
        $cookdata             = explode("\n", $readfile);
        if (! empty($cookdata)) {
            foreach ($cookdata as $resarr) {
                if (strpos($resarr, 'refresh_token') !== false) {
                    $chk = explode("refresh_token", $resarr);
                    log_message("error", "r " . $chk[1]);
                    $res['refresh_token'] = trim($chk[1]);
                }
                if (strpos($resarr, 'access_token') !== false) {
                    $chk1                = explode("access_token", $resarr);
                    $res['access_token'] = trim($chk1[1]);
                }
            }
        }
        unlink($cookfile);
        return $res;
    }

    public function getetnpricedata($post = [])
    {
        $input    = $post;
        $res      = $reqinput      = [];
        $sessdata = "";
        if (! empty($input)) {
            if ($input['refresh_token'] != "" && $input['access_token'] != "") {
                $sessdata .= "refresh_token=" . $input['refresh_token'] . ";";
                $sessdata .= "access_token=" . $input['access_token'];
            }
            $reqinput  = $input['routedata'];
            $jsoninput = json_encode($reqinput);
        }
        if ($sessdata != "") {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL            => "https://etra-uat.kuehne-nagel.com/api/v1/booking/quick-book/get-price",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING       => "",
                CURLOPT_MAXREDIRS      => 10,
                CURLOPT_TIMEOUT        => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST  => "POST",
                CURLOPT_POSTFIELDS     => $jsoninput,
                CURLOPT_HTTPHEADER     => [
                    "Accept: application/json, text/plain, */*",
                    "Authorization: Basic a3BtZy1jbGllbnQ6S1BNR0AxMjM=",
                    "Content-Type: application/json;charset=UTF-8",
                    "Cookie: " . $sessdata,
                ],
            ]);
            if (ENVIRONMENT !== "development") {
                curl_setopt($curl, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
            }
            $response = curl_exec($curl);
            curl_close($curl);
            $res = json_decode($response);
        }
        return $res;
    }

    public function getetnusrdetails()
    {
        $post['username']      = "knshipper.02@gmail.com";
        $post['password']      = "ETNTEST@123";
        $post['typeRole']      = "ROLE_KNS";
        $response              = $this->etntestlogin($post);
        $response1['routings'] = [
            "PICK_UP"  => ["addressLine1" => "999 Soi Mu Ban Nakhon Thong 1", "city" => "Nong Prue", "company" => "Suvarnabhumi Airport", "country" => 66, "district" => "Bang Phli", "fromDateTime" => "2019-11-11T08:00", "latitude" => "13.6899991", "longitude" => "100.75011239999999", "portalCode" => "10540", "province" => "Nong Prue", "toDateTime" => "2019-11-11T17:00"],
            "DELIVERY" => ["addressLine1" => "2034 Phetchaburi Rd, Khwaeng Bang Kapi", "city" => "Nong Prue", "company" => "Italthai Tower (ITD)", "country" => 66, "district" => "Huai Khwang", "fromDateTime" => "2019-11-13T08:00", "latitude" => "13.746495399999999", "longitude" => "100.57380739999999", "portalCode" => "10310", "province" => "Nong Prue", "toDateTime" => "2019-11-13T17:00"]];
        $response1['addons']   = [];
        $response1['contacts'] = ["CONSIGNEE" => ["area" => 2, "code" => 66, "comments" => "", "email" => "sdfe@sdfs.dg", "fullName" => "b", "phoneNo" => "765443"],
            "CONSIGNOR"                                => ["area" => 2, "code" => 66, "comments" => "", "email" => "dasd@sdfs.sfds", "fullName" => "a", "phoneNo" => "123456554"],
        ];
        $response1['vehicle']  = ["title" => "4 Wheeler Cabinet"];
        $response['routedata'] = $response1;
        $getprices             = $this->getetnpricedata($response);
        print_r($getprices);
    }

    public function etntestlogout($post = [])
    {
        $input = $post;
        $curl  = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL            => "https://etra-uat.kuehne-nagel.com/api/v1/auth/logout",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => "POST",
            CURLOPT_POSTFIELDS     => $input,
            CURLOPT_HTTPHEADER     => [
                "Accept: application/json, text/plain, */*",
                "Authorization: Basic a3BtZy1jbGllbnQ6S1BNR0AxMjM=",
                "Content-Type: application/json;charset=UTF-8",
            ],
        ]);
        if (ENVIRONMENT !== "development") {
            curl_setopt($curl, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
        }
        $response = curl_exec($curl);
        curl_close($curl);
        $res = json_decode($response);
        return $res;
    }
}
