<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class CustomerdailystatusReport extends CI_Controller
{

    public function __construct()
    {
      parent::__construct();
      if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
      $this->load->model('customerdailystatusreportmodel');
      $this->load->model('common');
        if (!checkUrlAccessForUser('CUSTOMERDAILYSTATUSREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->getsearchresult();
    }
    public function getsearchresult()
    {
        $business_type = $this->session->userdata('business_type');

        $custid = $status_search = $epodp_date = $pod_status_date = $status_date = $vendor_id = "";

        $data['page_title'] = $this->lang->line('customer_dailystatus');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $userid = $this->session->userdata("user_id");
        if(!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        if(!empty($this->session->userdata('id'))){
            $vendor_id = $this->session->userdata('id');
        }
        $aquorder = $country_userids = $whr = $post =  $where =  $other_checks = $wherein =  $subcusts = $general_array = array();
        if(!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0) ) {
            $country_userids = $this->session->userdata("country_user_ids");
        }

        $post = array();
        $post1 = $this->input->post(NULL,TRUE);
        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        }
        $searchids = array();

        if (!empty($post)) {

            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] :"";
            if (isset($post['bookingid']) && $post['bookingid'] != "") {
                $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();

            }
            $whr = $this->searchorders($post);
            $ordids = $whr['ordids'];
            unset($whr['ordids']);
            if($business_type == "Customer") {
                $userid=0;
            }

            if(!empty($custid)) {

                if($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if(count($subcusts)>0){
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = array($custid);
                    }
                } else {
                        $subcusts = array($custid);
                }
            }

            if(!empty($ad_orderstatus)){
                $status_search = $ad_orderstatus;
            }

            $general_array = ['userid' => $userid,'custid' => $custid,'business_type'=>$business_type,'country_userids'=>$country_userids,'subcusts'=>$subcusts,'searchids'=>$searchids,'vendor_id'=>$vendor_id,'ordids'=>$ordids];
            $orderdata = $this->customerdailystatusreportmodel->getorderdata($whr, $status_search, $general_array);
            if(!empty($orderdata)){
                foreach($orderdata as $res) {
                    $delivery_note = $epodp_date = $pod_status_date = "";
                    $getdnote = $this->db->select("ref_value")->get_where("tb_order_references",array('order_id'=>$res['id'],'reference_id'=>'DQ'));
                    if($getdnote->num_rows() >0) {
                        $delivery_note = $getdnote->row()->ref_value;
                    }

                    $curtz = $this->session->userdata("usr_tzone")['timezone'];

                    $shift_id = $res['shift_id'];
                    $trip_id = $res['trip_id'];
                    $bookingid = $res['order_id'];
                    $shipmentid = $res['shipmentid'];
                    $delivery_date = $pickup_date_status = $delivery_datetime = $delivery_date_status = $pod_status = $status_date = "";
                    $last_status_name = "Booked by Supplier";
                    $early_pickup = $res['pickup_datetime'];
                    $accept_date_status = $pgatein_date_status = $pickup_date_status =  $pgateout_date_status = $intransit_date_status = $dgatin_date_status = $dgatout_date_status = $delivery_date_status = $booked_status = "";
                    if (($this->session->userdata('company_code') == "VNKN") || ($this->session->userdata('company_code') == "NZPG")) {
                        $booked_status = date("Y-m-d h:i A",strtotime($res['createdon']));
                        $accept_status = $res['accept'];
                        if($accept_status != "" && $accept_status != "0000-00-00 00:00:00") {
                            $accept_date_status = date("Y-m-d h:i A",strtotime($accept_status));
                        }
                        $pgatein_status = $res['pickup_gatein'];
                        if($pgatein_status != "" && $pgatein_status != "0000-00-00 00:00:00") {
                            $pgatein_date_status = date("Y-m-d h:i A",strtotime($pgatein_status));
                        }
                        $pickup_status = $res['pickup'];
                        if($pickup_status != "" && $pickup_status != "0000-00-00 00:00:00") {
                            $pickup_date_status = date("Y-m-d h:i A",strtotime($pickup_status));
                        }
                        $pgateout_status = $res['pickup_gateout'];
                        if($pgateout_status != "" && $pgateout_status != "0000-00-00 00:00:00") {
                            $pgateout_date_status = date("Y-m-d h:i A",strtotime($pgateout_status));
                        }
                        $intransit_status = $res['intransit'];
                        if($intransit_status != "" && $intransit_status != "0000-00-00 00:00:00") {
                            $intransit_date_status = date("Y-m-d h:i A",strtotime($intransit_status));
                        }
                        $dgatin_status = $res['drop_gatin'];
                        if($dgatin_status != "" && $dgatin_status != "0000-00-00 00:00:00") {
                            $dgatin_date_status = date("Y-m-d h:i A",strtotime($dgatin_status));
                        }
                        $dgatout_status = $res['drop_gateout'];
                        if($dgatout_status != "" && $dgatout_status != "0000-00-00 00:00:00") {
                            $dgatout_date_status = date("Y-m-d h:i A",strtotime($dgatout_status));
                        }
                        $delivery_status = $res['delivery'];
                        if($delivery_status != "" && $delivery_status != "0000-00-00 00:00:00") {
                            $delivery_date_status = date("Y-m-d h:i A",strtotime($delivery_status));
                        }
                    }else{
                        $pickup_status = $res['pickup'];
                        if($pickup_status != "" && $pickup_status != "0000-00-00 00:00:00") {
                            $pickup_date_status = date("Y-m-d h:i A",strtotime($pickup_status));
                        }
                        $delivery_status = $res['delivery'];
                        if($delivery_status != "" && $delivery_status != "0000-00-00 00:00:00") {
                            $delivery_date_status = date("Y-m-d h:i A",strtotime($delivery_status));
                        }
                    }
                    $drop_poddate = $pod_status = "";
                    $drop_pod = $res['dpod_createdon'];
                    if($drop_pod != "" && $drop_pod != "0000-00-00 00:00:00") {
                        $drop_poddate = $drop_pod;
                        $pod_status .= "ePOD Available - ". date("d M,y h:i A",strtotime($drop_pod))."<br>";
                    }
                    $epodp_date =  "";
                    $pickup_pod = $res['ppod_createdon'];
                    if($pickup_pod != "" && $pickup_pod != "0000-00-00 00:00:00") {
                        $epodp_date = $pickup_pod;
                        $pod_status .= "Goods Loaded for Delivery-".date("d M,y h:i A",strtotime($pickup_pod))." ";
                    }
                    $status_date = "";
                    if($shift_id >0){
                        $ord = $res['id'];
                        $getrecentrecord = $this->customerdailystatusreportmodel->getrecentstatusfororder($shift_id,$ord);
                        $last_status_name = $getrecentrecord['last_status'];
                        if($last_status_name == ""){
                            $last_status_name = "Booked By Supplier";
                            $status_date = $res['createdon'];
                        }else{
                            $status_date = $getrecentrecord['last_date'];
                        }
                    }
                    if($status_date != ""){
                        if($epodp_date != ""){
                            if($status_date < $epodp_date){
                                $last_status_name = "Goods Loaded for Delivery";
                                $status_date = $epodp_date;
                            }
                        }
                        if($drop_poddate != ""){
                            if($status_date < $drop_poddate){
                                $last_status_name = "ePOD Available";
                                $status_date = $drop_poddate;
                            }
                        }

                    }else{
                        if($drop_poddate != "" && $epodp_date != "" ){
                            if($epodp_date < $drop_poddate){
                                $last_status_name = "ePOD Available";
                                $status_date = $drop_poddate;
                            }else{
                                $last_status_name = "Goods Loaded for Delivery";
                                $status_date = $epodp_date;
                            }
                        }
                    }
                    if($status_date != ""){
                        $status_date = date("d M,y h:i A",strtotime($status_date));
                    }
                    $pickup_address1 = $pickup_city = $pickup_country = $pickup_pincode = $delivery_address1 = $delivery_city = $delivery_country = $delivery_pincode = $pickup_address2 = $delivery_address2 = $delivery_company = $pickup_company = "";

                    $pickup_company = (!empty($res['pickup_company'])) ? $res['pickup_company'] :  "" ;

                    $delivery_company = (!empty($res['delivery_company'])) ? $res['delivery_company'] :  "" ;

                    $pickup_address1 = (!empty($res['pickup_address1'])) ? $res['pickup_address1'].' , ' :  "" ;

                    $pickup_address2 = (!empty($res['pickup_address2'])) ? $res['pickup_address2'].' , ' :  "" ;
                    $pickup_city = (!empty($res['pickup_city'])) ? $res['pickup_city'].' , ' :  "" ;
                    $pickup_country = (!empty($res['pickup_country'])) ? $res['pickup_country'].' , ' :  "" ;
                    $pickup_pincode = (!empty($res['pickup_pincode'])) ? $res['pickup_pincode'].' , ' :  "" ;
                    $delivery_address1 = (!empty($res['delivery_address1'])) ? $res['delivery_address1'].' , ' :  "" ;

                    $delivery_address2 = (!empty($res['delivery_address2'])) ? $res['delivery_address2'].' , ' :  "" ;

                    $delivery_city = (!empty($res['delivery_city'])) ? $res['delivery_city'].' , ' :  "" ;
                    $delivery_country = (!empty($res['delivery_country'])) ? $res['delivery_country'].' , ' :  "" ;
                    $delivery_pincode = (!empty($res['delivery_pincode'])) ? $res['delivery_pincode'].' , ' :  "" ;

                    $pickup_address = $pickup_address1.$pickup_city.$pickup_address2.$pickup_country.$pickup_pincode;
                    $delivery_address = $delivery_address1.$delivery_city.$delivery_address2.$delivery_country.$delivery_pincode;

                    $pickup_address = ltrim($pickup_address,' , ');
                    $pickup_address = rtrim($pickup_address,' , ');
                    $delivery_address = ltrim($delivery_address,' , ');
                    $delivery_address = rtrim($delivery_address,' , ');

                    $aquorder[] = array(
                            'order_row_id'=>$res['id'],
                            'order_id'=>$res['order_id'],
                            'product'=>$res['product'],
                            'customer_name'=>$res['customer_name'],
                            'shipper_address'=>$pickup_address,
                            'consignee_address'=>$delivery_address,
                            'pickup_date'=>$pickup_date_status,
                            'delivery_date' => $status_date,
                            'carrier'=>$res['carrier'],
                            'register_number'=>$res['register_number'],
                            'drivername'=>$res['drivername'],
                            'delivery_note' => $delivery_note,
                            'last_status_name' => $last_status_name,
                            'shift_id' => $shift_id,
                            'shipper_name'=>$pickup_company,
                            'consignee_name'=>$delivery_company,
                            'shipmentid'=>$shipmentid,
                            'delivery_date_status'=>$delivery_date_status,
                            'pod_status'=>$pod_status,
                            'booked_status'=>$booked_status,
                            'accept_date_status'=>$accept_date_status,
                            'pgatein_date_status'=>$pgatein_date_status,
                            'pgateout_date_status'=>$pgateout_date_status,
                            'intransit_date_status'=>$intransit_date_status,
                            'dgatin_date_status'=>$dgatin_date_status,
                            'dgatout_date_status'=>$dgatout_date_status,
                            'delivery_date_status'=>$delivery_date_status,
                        );
                }
            }
        }
        $data['aquorder']  = $aquorder;
        $data['custid']    = $custid;
        $data['vendor_id'] = $vendor_id;
        log_message("error","22222222222:".json_encode($data));
        //$this->newtemplate->dashboard("customerdailystatusreports/index", $data);
        $this->newtemplate->dashboard("customerdailystatusreports/indexV2", $data);
    }

    public function searchorders($post)
    {
        $whr = $searchids= $refid = $refvals = array();
        $whr['ordids'] = array();
        if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
            $aqufromdate                                      = date('Y-m-d', strtotime($post['aqufromdate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $aqufromdate;
        }

        if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['aqutodate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $post['order_id'];

        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['searchcustomer_id']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['custcode']) && $post['custcode'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['custcode']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $post['service'];

        }

        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $post['order_type'];

        }
        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $post['product'];

        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];

        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];

        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];

        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $ref_whr = array('refid'=>'DQ','refvals'=>$post['delivery_note']);
          $getordids = $this->common->getordids($ref_whr);
          if(!empty($getordids)){
            foreach ($getordids as $key => $getordid) {
               $whr['ordids'][] = $getordid['order_id'];
            }
          }
        }
         if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
          $ref_whr = array('refid'=>'PO','refvals'=>$post['purchase_order']);
          $getordids = $this->common->getordids($ref_whr);
          if(!empty($getordids)){
            foreach ($getordids as $key => $getordid) {
               $whr['ordids'][] = $getordid['order_id'];
            }
          }
        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $post['company_code'];

        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];

        }

        return $whr;
    }

    public function getbookingid()
    {
        $uid = $this->session->userdata('user_id');
        $custid="";
        $country_userids = array();
        if(!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0) ) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $business_type = $this->session->userdata('business_type');
        if(!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
            $post = array();
            $post = $this->input->post(NULL,TRUE);
        $booking_id = isset($post["booking_id"])? $post["booking_id"] : "";
        $booking_id = trim($booking_id);
        $data = $subcusts = array();
        $where = "";
        if($business_type == "Customer") {
            $uid = 0;
        }

        $bindings = ['%'. $this->db->escape_like_str($booking_id) . '%'];
        if ($uid != '0') {
            if (!empty($country_userids)) {
                $bindings[] = $country_userids;
                $where = "and user_id in ?";
          } else {
                $bindings[] = $uid;
                $where = "and user_id = ?";
          }
        }
        if (!empty($custid)) {
            if($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if(count($subcusts)>0){
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array($custid);
                }
            } else {
                    $subcusts = array($custid);
            }
        }
        if(!empty($subcusts)){
            $bindings[] = $subcusts;
            $where = "and customer_id in ?";
        }else{
            if ($custid != "") {
                $bindings[] = $custid;
                $where = "and customer_id = ?";
            }
        }
        $get_data = $this->db->query("
            SELECT order_id
            FROM tb_orders
            WHERE
                order_id LIKE ?
                $where
                AND STATUS != 0
        ", $bindings);
        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->order_id;
            }
        }
        echo json_encode($data);
    }

    public function getcustcode()
    {
        $uid = $this->session->userdata('user_id');

        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $custcode = isset($post["custcode"])? $post["custcode"] : "";
        $custcode = trim($custcode);
        $data = array();
        $company_code = $this->session->userdata('company_code');
        $get_data = $this->db->query("
            SELECT code
            FROM tb_customers
            WHERE
                code LIKE ?
                AND company_code LIKE ?
                AND status = '1'
                ORDER BY id DESC
        ", [
            '%'. $this->db->escape_like_str($custcode) . '%',
            $this->db->escape_like_str($company_code)
        ]);
        if($get_data->num_rows() > 0){
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->code;
            }
        }
        echo json_encode($data);
    }
}
