<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class CustomerdailystatusReportV2 extends CI_Controller
{
    public function __construct()
    {
      parent::__construct();
      /*if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }*/
      $this->load->model(['customerdailystatusreportmodel','Standardbookingmodel','Order']);
      $this->load->model('common');
    }

    // the below method is used to generate the where condition based on the post array parameters
    public function searchorders($post)
    {
        $whr = $searchids= $refid = $refvals = array();
        $whr['ordids'] = array();
        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
            $fromdate_search                                      = date('Y-m-d', strtotime($post['fromdate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
        }

        if (isset($post['todate_search']) && $post['todate_search'] != "") {
            $todate_search                                        = date('Y-m-d', strtotime($post['todate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate_search;
        }

        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $post['order_id'];

        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['searchcustomer_id']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['custcode']) && $post['custcode'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['custcode']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $post['service'];

        }

        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $post['order_type'];

        }
        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $post['product'];

        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];

        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];

        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];

        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $ref_whr = array('refid'=>'DQ','refvals'=>$post['delivery_note']);
          $getordids = $this->common->getordids($ref_whr);
          if(!empty($getordids)){
            foreach ($getordids as $key => $getordid) {
               $whr['ordids'][] = $getordid['order_id'];
            }
          }
        }
         if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
          $ref_whr = array('refid'=>'PO','refvals'=>$post['purchase_order']);
          $getordids = $this->common->getordids($ref_whr);
          if(!empty($getordids)){
            foreach ($getordids as $key => $getordid) {
               $whr['ordids'][] = $getordid['order_id'];
            }
          }
        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $post['company_code'];

        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];

        }

        return $whr;
    }

//ajax listing method is used for paging the report
    public function ajaxListing(){
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
        $checkVendorCondition = checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'));

        $checkPHKNCustomer = true;
        if ($this->session->userdata('company_code') == 'PHKN' && $this->session->userdata('customer_code') == '1005751990') {
            $checkPHKNCustomer = false;
        }
        $whr = $post = $searchids = array();

        $draw  = $this->input->post( 'draw',TRUE );
        $start = $this->input->post( 'start',TRUE );
        $limit =  $this->input->post('length',TRUE );
        $orderBy   =  $this->input->post('order',TRUE );
        $indexColumn   = 'o.id';
        $post              = $this->input->post( 'data',TRUE );
        
        $custid = $vendor_id = $status_search = $epodp_date = $pod_status_date = $status_date = $wherecondition="";
        
        //session data handling
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $userid = $this->session->userdata("user_id");
        if(!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        if(!empty($this->session->userdata('id'))){
            $vendor_id = $this->session->userdata('id');
        }
        $aquorder = $country_userids =  $where =  $other_checks = $wherein =  $subcusts  = array();
        if(!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0) ) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $business_type = $this->session->userdata('business_type');

        $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] :"";
        if (isset($post['bookingid']) && $post['bookingid'] != "") {
            $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
        }

        //echo "<pre>";print_r($post);exit;
        $whr = $this->searchorders($post);
        
        $lbhReport = isset($post['lbhReport']) ? $post['lbhReport'] :"No";
        //log_message("error","111:".$lbhReport);

//echo "<pre>";print_r($whr);

        $ordids = $whr['ordids'];
        unset($whr['ordids']);
        if($business_type == "Customer") {
            $userid=0;
        }

        if(!empty($custid)) {
            if($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array($custid);
                }
            } else {
                    $subcusts = array($custid);
            }
        }

        if(!empty($ad_orderstatus)){
            $status_search = $ad_orderstatus;
        }

        if(($vendor_id != "")){
	    	$userid = 0;
	    }
	    if(!empty($subcusts)){
	    	$userid =0;
	    }
	    if($custid != ""){
	    	$userid = 0;
	    }
        //where condition building starts

        $orderTableCondition=array();
        if(!empty($whr)){
            foreach($whr as $key=>$value){
                $value = $this->db->escape($value);
                if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                    $orderTableCondition[]= $key.$value;
                }else{
                    $orderTableCondition[]= $key.' = '.$value;
                }
            }
        }
       // echo "<pre>";print_r($whr);exit;
        $orderTableCondition[]='o.status!=0';

        if (isset($status_search)) {
                if ($status_search == 'PENDING') {
                    $orderTableCondition[]= "o.trip_id = 0";
                } else if ($status_search == 'ACTIVE') {
                    $orderTableCondition[]= "o.trip_id!= 0";
                    $orderTableCondition[]= "o.trip_sts= 0";
                } else if ($status_search == 'CLOSED') {
                    $orderTableCondition[]= "o.trip_id!= 0";
                    $orderTableCondition[]= "o.trip_sts= 1";
                }

        }

        $bindings = [];
        if(!empty($searchids)){
            $commaSearchIds= implode(',',$searchids);
            $commaSearchIds = trim($commaSearchIds, ',');
            if($commaSearchIds!=''){
                $bindings[] = array_filter($searchids);
                $orderTableCondition[]="  o.order_id in ($commaSearchIds)";
            }
	    }

        if($userid != '0'){
            if(!empty($country_userids) && count($country_userids) > 0){
                $commaCountryIds= implode(',',$country_userids);
                $commaCountryIds = trim($commaCountryIds, ',');
                if($commaCountryIds!=''){
                    $bindings[] = array_filter($country_userids);
                    $orderTableCondition[] = "  o.user_id in ($commaCountryIds)";
                }
            }else{
                if($userid!=''){
                    $bindings[] = $userid;
                    $orderTableCondition[] = "  o.user_id = $userid ";
                }
            }
        }

        if( isset($ordids) &&  !empty($ordids)){
            $commaSeparatedOrderIds= implode(',',$ordids);
            $commaSeparatedOrderIds = trim($commaSeparatedOrderIds, ',');
            if($commaSeparatedOrderIds!=''){
                $bindings[] = array_filter($ordids);
                $orderTableCondition[]="  o.id in ($commaSeparatedOrderIds)";
            }
	    }

        if (!empty($subcusts) && count($subcusts) > 0) {
            $commaSubcusts= implode(',',$subcusts);
            $commaSubcusts = trim($commaSubcusts, ',');
            if($commaSubcusts!=''){
                $bindings[] = array_filter($subcusts);
                $orderTableCondition[]="  o.customer_id in ($commaSubcusts)";
            }
	    } else {
	        if($custid != ""){
                $bindings[] = $custid;
                $orderTableCondition[]="  o.customer_id = ? ";
	        }
	    }
	    if ($vendor_id != "" && $vendor_id > 0) {
            $bindings[] = $vendor_id;
            $orderTableCondition[]="  o.vendor_id = ? ";
	    }



        $orderTableWhere = implode(' AND ',$orderTableCondition);
        if($orderTableWhere!=''){
            $orderTableWhere=" and $orderTableWhere ";
        }

        $orderByCondition='';
        if(isset($orderBy[0])){
            if($orderBy[0]!=''){
                $ordColIndex= $orderBy[0]['column'];
                $ordColDir= $orderBy[0]['dir'];
                if($ordColDir==''){
                    $ordColDir = 'asc';
                }
                if(isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex]!='' ){
                    $orderByCondition='  '.$dataTableSortOrdering[$ordColIndex].' '.$ordColDir.' ';
                }
            }
        }

        $compiledCount=0;
        $resultSet=$this->db->query("
            SELECT count(o.id) as count
            FROM tb_orders o
            LEFT JOIN tb_order_details d ON o.id = d.order_row_id
            WHERE o.status != 0  $orderTableWhere
        ", $bindings);

        if($resultSet->num_rows()>0){
            $resdata = $resultSet->result_array();
            if(isset($resdata[0]['count'])){
                $compiledCount=$resdata[0]['count'];
            }
        }else{
            $compiledCount=0;
        }
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $selectColumns = [
            "o.id,o.order_id,convertToClientTZ(o.pickup_datetime,'{$currentTimeZone}') as early_pickup_datetime,
        convertToClientTZ(o.pickup_endtime,'{$currentTimeZone}') as late_pickup_datetime,
        convertToClientTZ(o.delivery_datetime,'{$currentTimeZone}') as early_delivery_datetime,
        convertToClientTZ(o.drop_endtime,'{$currentTimeZone}') as late_delivery_datetime,
        o.shipment_id,o.pickup_city,o.delivery_city,o.status,o.trip_sts,
		o.trip_id, o.shipmentid,o.createdon,
		o.shift_id,o.pickup_address1,o.delivery_address1,o.pickup_country,
		o.pickup_pincode,o.delivery_country,o.delivery_pincode,o.pickup_company,o.delivery_company,
		o.pickup_address2,o.delivery_address2,ct.name as customer_name,o.product,v.name as carrier"
        ];

        $table_name='tb_orders o';
        $indexColumn='o.id';
        $groupBy='o.id';
        //$orderBy='o.id desc';
        $excludeCountQuery='Yes';

        $wherecondition = $indexColumn . "!='' " . $orderTableWhere;
        $timeZone = $curtz;
/*,
		SUM(toc.weight) as total_weight,SUM(toc.volume) as total_volume,SUM(toc.quantity) as total_quantity*/
        $joinsArray[]=array('table_name'=>'tb_order_details as d','condition'=>"o.id=d.order_row_id",'join_type'=>'left');
        //$joinsArray[]=array('table_name'=>'tb_order_cargodetails as toc','condition'=>"toc.order_id=o.id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_customers as ct','condition'=>"o.customer_id=ct.id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_vendors as v','condition'=>"o.vendor_id=v.id",'join_type'=>'left');

        foreach ($bindings as $param) {
            $wherecondition = preg_replace(
                '#\?#',
                is_array($param) ? " (" . implode(", ", array_map(function($item) {
                    return $this->db->escape($item);
                }, $param)).") " : $this->db->escape($param),
                $wherecondition,
                true
            );
        }
        $dataTableSortOrdering=array();
        $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );

        $reqData=array('id','shift_id');
        $this->db->query('SET SESSION  group_concat_max_len=10240');
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
        if(isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id']!=''){
            if (($this->session->userdata("company_code") == 'VNKN') || ($this->session->userdata('company_code') == "NZPG")) {
                $reqStatus="0420,0500,0191,1550,0192,2300,3000";
            } elseif ($this->session->userdata('company_code') == "PHKN") {
                $reqStatus="0500,2300,3000";
            } else {
                $reqStatus="0500,3000,'SV0131','SV0510'";
            }
            $formattedData = $this->DataQueryFormatter_model->getOrderStopStatusStatus($formattedData['commaSeparated']['id'],$formattedData,$reqStatus);
            $formattedData = $this->DataQueryFormatter_model->getPODUploads($formattedData['commaSeparated']['id'],$formattedData);
            if($this->session->userdata("company_code") == 'VNKN') {
                $formattedData = $this->DataQueryFormatter_model->getPUPUploads($formattedData['commaSeparated']['id'], $formattedData);
            }
            
            $refCodes = "'DQ','XSR','AWB','IV', 'TKN'";
            $formattedData = $this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$refCodes);
        }

        if(isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id']!=''){
           $driverAcceptanceArray=$this->DataQueryFormatter_model->getDriverAcceptance($formattedData['commaSeparated']['shift_id']);
           $driverVehicleArray=$this->DataQueryFormatter_model->getDriverVehicleDetails($formattedData['commaSeparated']['shift_id']);
           $genericStatusArray=$this->DataQueryFormatter_model->getStopStatusGenericAllround($formattedData['commaSeparated']['shift_id']);
        }

            if($excludeCountQuery=='Yes'){
                $totalRecords     = $compiledCount;
                $recordsFiltered  = $compiledCount;
            }else{
                $totalRecords     = $getRecordListing['recordsTotal'];
                $recordsFiltered  = $getRecordListing['recordsFiltered'];
            }

            $getRecordListing=array();
            if(isset($formattedData['orders'])){
                $getRecordListing=$formattedData['orders'];
                krsort($getRecordListing);
            }
            $recordListing    = array();
            $content          = '[';
            $i                 = 0;
            $srNumber = $start;

            if ( ! empty( $getRecordListing ) ) {
                $actionContent = ''; $orderCargo = [];
                $cntr=1;
                foreach ( $getRecordListing as $res ) {
                    $orderCargo = $this->Order->getTotalMeasurementData($res['id'], $lbhReport);
                    //log_message("error","orderCargo:".json_encode($orderCargo));
                    $quantity = $weight = $volume = $length = $width = $height = 0.0;
                    if (!empty($orderCargo) && is_array($orderCargo)) {
                    foreach ($orderCargo as $data) {
                        $quantity = (!empty($data['quantity'])) ? $data['quantity'] :  0.0 ;
                        $weight = (!empty($data['weight'])) ? $data['weight'] :  0.0 ;
                        $volume = (!empty($data['volume'])) ? $data['volume'] :  0.0 ;
                        $weightUnit = ($data['weight_unit'] != null) ? $data['weight_unit'] : '';
                        $volumeUnit = ($data['volume_unit'] != null) ? $data['volume_unit'] : '';
                        //log_message("error","weight111:".$weight);
                        $weight = $this->Order->weightConvertKgs($weightUnit, (float)($weight));
                        //log_message("error","weight:".$weight);
                        //log_message("error","volume111:".$volume);
                        $volume = $this->Order->volumeConvertCbft($volumeUnit, (float)($volume));
                        //log_message("error","volume:".$volume);
                        
                        $length = (!empty($data['length'])) ? $data['length'] :  0.0 ;
                        $width = (!empty($data['width'])) ? $data['width'] :  0.0 ;
                        $height = (!empty($data['height'])) ? $data['height'] :  0.0 ;
                        $lengthUnit = ($data['length_unit'] != null) ? $data['length_unit'] : '';
                        $widthUnit = ($data['width_unit'] != null) ? $data['width_unit'] : '';
                        $heightUnit = ($data['height_unit'] != null) ? $data['height_unit'] : '';
                        $length = $this->Order->dimensionsConvertft($lengthUnit, (float)($length));
                        $width = $this->Order->dimensionsConvertft($widthUnit, (float)($width));
                        $height = $this->Order->dimensionsConvertft($heightUnit, (float)($height));
                        
                    $delivery_note = $epodp_date = $pod_status_date = $salog_ref = $awb = $invoice = "";
                    $referenceData=$podData='';
                    if (isset($res['reference_value'])) {
                        $referenceData = $res['reference_value'];
                    }
                    if ($referenceData != '') {
                        $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                            if (isset($arrayData['DQ'])) {
                                $delivery_note = $arrayData['DQ'];
                            }
                            
                            if (isset($arrayData['AWB'])) {
                                $awb = $arrayData['AWB'];
                            }
                            
                            if (isset($arrayData['IV'])) {
                                $invoice = $arrayData['IV'];
                            }
                            
                            if (isset($arrayData['TKN'])) {
                                $tkn = $arrayData['TKN'];
                            }
                            
                            if (isset($arrayData['XSR'])) {
                                $salog_ref = $arrayData['XSR'];
                            }                           
                    }

                    if (isset($res['pod_details'])) {
                        $podData = $res['pod_details'];
                    }

                    $drop_pod = $pickup_pod = $drop_poddate = $pod_status = $epodp_date = "";
                    if( $podData!=''){
                        $podArray = $this->DataArrayFormatter_model->formatGenericParameters($podData);
                        if(!empty($podArray) && sizeof($podArray)>0){
                            foreach($podArray as $eachPod){
                                if(isset($eachPod['stop_type'])){
                                    if($eachPod['stop_type']=='P'){
                                        $pickup_pod = $eachPod['createdon'];
                                        if($pickup_pod != "" && $pickup_pod != "0000-00-00 00:00:00" && $pickup_pod != "0"){
                                            $pickup_pod_status      = getdatetimebytimezone( $curtz, $pickup_pod, DFLT_TZ );
                                            $pickup_pod = date('Y-m-d h:i A',strtotime($pickup_pod_status['datetime']));
                                        }

                                    }else if($eachPod['stop_type']=='D'){
                                        $drop_pod = $eachPod['createdon'];
                                        if($drop_pod != "" && $drop_pod != "0000-00-00 00:00:00" && $drop_pod != "0"){
                                            $drop_pod_status      = getdatetimebytimezone( $curtz, $drop_pod, DFLT_TZ );
                                            $drop_pod = date('Y-m-d h:i A',strtotime($drop_pod_status['datetime']));
                                        }
                                    }
                                }
                            }
                        }

                        if($drop_pod != "" && $drop_pod != "0000-00-00 00:00:00") {
                            $drop_poddate = $drop_pod;
                            $pod_status .= "ePOD Available - ". date("d M,y h:i A",strtotime($drop_pod))."<br>";
                        }

                        if($pickup_pod != "" && $pickup_pod != "0000-00-00 00:00:00") {
                            $epodp_date = $pickup_pod;
                            $pod_status .= "Goods Loaded for Delivery-".date("d M,y h:i A",strtotime($pickup_pod))." ";
                        }
                    }
                    $pupData='';
                    if(isset($res['pup_details'])){
                        $pupData = $res['pup_details'];
                    }
                    $pickup_pup =  $pup_status = "";
                    if( $pupData!=''){
                        $pupArray = $this->DataArrayFormatter_model->formatGenericParameters($pupData);
                        if(!empty($pupArray) && sizeof($pupArray)>0){
                            foreach($pupArray as $eachPup){
                                if(isset($eachPup['stop_type'])){
                                    if($eachPup['stop_type']=='P'){
                                        $pickup_pup = $eachPup['createdon'];
                                        if($pickup_pup != "" && $pickup_pup != "0000-00-00 00:00:00" && $pickup_pup != "0"){
                                            $pickup_pup_status      = getdatetimebytimezone( $curtz, $pickup_pup, DFLT_TZ );
                                            $pickup_pup = date('Y-m-d h:i A',strtotime($pickup_pup_status['datetime']));
                                        }

                                    }
                                }
                            }
                        }
                        if($pickup_pup != "" && $pickup_pup != "0000-00-00 00:00:00") {
                            $pup_status .= "PUP Available -".date("d M,y h:i A",strtotime($pickup_pup))." ";
                        }
                    }

                    $pickup_address1 = $pickup_city = $pickup_country = $daysDiffernce = $pickup_pincode = $delivery_address1 = $delivery_city = $delivery_country = $delivery_pincode = $pickup_address2 = $delivery_address2 = $delivery_company = $pickup_company = "";
                    
                    $earlyPickupDateTime = (!empty($res['early_pickup_datetime'])) ? $res['early_pickup_datetime'] :  "" ;
                    $latePickupDateTime = (!empty($res['late_pickup_datetime'])) ? $res['late_pickup_datetime'] :  "" ;
                    $earlyDeliveryDateTime = (!empty($res['early_delivery_datetime'])) ? $res['early_delivery_datetime'] :  "" ;
                    $lateDeliveryDateTime = (!empty($res['late_delivery_datetime'])) ? $res['late_delivery_datetime'] :  "" ;
                    $pickup_company = (!empty($res['pickup_company'])) ? $res['pickup_company'] :  "" ;
                    $delivery_company = (!empty($res['delivery_company'])) ? $res['delivery_company'] :  "" ;
                    $pickup_address1 = (!empty($res['pickup_address1'])) ? $res['pickup_address1'].' , ' :  "" ;
                    $pickup_address2 = (!empty($res['pickup_address2'])) ? $res['pickup_address2'].' , ' :  "" ;
                    $pickup_city = (!empty($res['pickup_city'])) ? $res['pickup_city'].' , ' :  "" ;
                    $pickup_country = (!empty($res['pickup_country'])) ? $res['pickup_country'].' , ' :  "" ;
                    $pickup_pincode = (!empty($res['pickup_pincode'])) ? $res['pickup_pincode'].' , ' :  "" ;

                    $delivery_address1 = (!empty($res['delivery_address1'])) ? $res['delivery_address1'].' , ' :  "" ;
                    $delivery_address2 = (!empty($res['delivery_address2'])) ? $res['delivery_address2'].' , ' :  "" ;
                    $delivery_city = (!empty($res['delivery_city'])) ? $res['delivery_city'].' , ' :  "" ;
                    $delivery_country = (!empty($res['delivery_country'])) ? $res['delivery_country'].' , ' :  "" ;
                    $delivery_pincode = (!empty($res['delivery_pincode'])) ? $res['delivery_pincode'].' , ' :  "" ;

                    $pickup_address = $pickup_address1.$pickup_city.$pickup_address2.$pickup_country.$pickup_pincode;
                    $delivery_address = $delivery_address1.$delivery_city.$delivery_address2.$delivery_country.$delivery_pincode;

                    $pickup_address = trim($pickup_address,' , ');
                    $delivery_address = trim($delivery_address,' , ');
                    
                    /*if($lbhReport == "Yes"){
                        
                    }
                    else
                    {
                        $quantity = (!empty($orderCargo['quantity'])) ? $orderCargo['quantity'] :  0.0 ;
                        $weight = (!empty($orderCargo['weight'])) ? $orderCargo['weight'] :  0.0 ;
                        $volume = (!empty($orderCargo['volumeFT'])) ? $orderCargo['volumeFT'] :  0.0 ;
                    }*/

                    $accepted_datetime=$pgatein_datetime = $pickup_datetime = $pickup_gateout_datetime =  $transit_datetime = $dgatin_datetime = $dgatout_datetime = $delivered_time = $delivery_date_status = $booked_status = "";
                    $last_status_name = "Booked by Supplier";
                    //log_message("error","res:".json_encode($res));
                    if(isset($res['stop_status_code'])){
                        if($res['stop_status_code']!=''){
                            $stopStatusArray=array( $res['stop_status_createdon'],$res['stop_status_code'] );
                            $getStopStatusArray=$this->DataArrayFormatter_model->buildGenericArray($stopStatusArray);
                            //log_message("error","Size:".sizeof($getStopStatusArray));
                           //echo "<pre>";print_r($getStopStatusArray);
                            if(!empty($getStopStatusArray) && sizeof($getStopStatusArray)>0){
                                foreach($getStopStatusArray as $eachItem){

                                    //log_message("error","StatusCode:".$eachItem['status_code']);
                                    if($eachItem['status_code']=='0420'){
                                        //pickup gate in
                                        $pgatein_status = $eachItem['createdon'];
                                        if($pgatein_status != "" && $pgatein_status != "0000-00-00 00:00:00" && $pgatein_status != "0"){
                                            $pgatein_date_status      = getdatetimebytimezone( $curtz, $pgatein_status, DFLT_TZ );
                                            $pgatein_datetime = date('Y-m-d h:i A',strtotime($pgatein_date_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='0500' || $eachItem['status_code']=='SV0131'){
                                        //Pickup
                                        $pickupdate = $eachItem['createdon'];;
                                        if($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0"){
                                            $pickup_date_status      = getdatetimebytimezone( $curtz, $pickupdate, DFLT_TZ );
                                            $pickup_datetime = date('Y-m-d h:i A',strtotime($pickup_date_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='0191'){
                                        //Pickup gateout
                                        $pickup_gateout = $eachItem['createdon'];;
                                        if($pickup_gateout != "" && $pickup_gateout != "0000-00-00 00:00:00" && $pickup_gateout != "0"){
                                            $pickup_gateout_status      = getdatetimebytimezone( $curtz, $pickup_gateout, DFLT_TZ );
                                            $pickup_gateout_datetime = date('Y-m-d h:i A',strtotime($pickup_gateout_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='1550'){
                                        //Transit time
                                        $transit = $eachItem['createdon'];;
                                        if($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0"){
                                            $transitdate      = getdatetimebytimezone( $curtz, $transit, DFLT_TZ );
                                            $transit_datetime = date('Y-m-d h:i A',strtotime($transitdate['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='0192'){
                                        //drop gatein
                                        $dgatin_status = $eachItem['createdon'];;
                                        if($dgatin_status != "" && $dgatin_status != "0000-00-00 00:00:00" && $dgatin_status != "0"){
                                            $dgatin_date_status      = getdatetimebytimezone( $curtz, $dgatin_status, DFLT_TZ );
                                            $dgatin_datetime = date('Y-m-d h:i A',strtotime($dgatin_date_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='2300'){
                                        //drop gateout
                                        $dgatout_status = $eachItem['createdon'];;
                                        if($dgatout_status != "" && $dgatout_status != "0000-00-00 00:00:00" && $dgatout_status != "0"){
                                            $dgatout_date_status      = getdatetimebytimezone( $curtz, $dgatout_status, DFLT_TZ );
                                            $dgatout_datetime = date('Y-m-d h:i A',strtotime($dgatout_date_status['datetime']));
                                        }
                                    }if($eachItem['status_code']=='3000' || $eachItem['status_code']=='SV0510'){
                                        //delivery time
                                        $delivered_time = $eachItem['createdon'];;
                                        if($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0"){
                                            $deliverydate      = getdatetimebytimezone( $curtz, $delivered_time, DFLT_TZ );
                                            $delivered_time = date('Y-m-d h:i A',strtotime($deliverydate['datetime']));
                                            $estimatedDelivery = new DateTime($lateDeliveryDateTime);
                                            $actualDelivery = new DateTime($delivered_time);
                                            $interval = $estimatedDelivery->diff($actualDelivery);
                                            if ($actualDelivery > $estimatedDelivery) {
                                                $daysDiffernce = "Delivered late by " . $interval->format('%a days, %h hours, %i minutes');
                                            } elseif ($actualDelivery < $estimatedDelivery) {
                                                $daysDiffernce = "Delivered early by " . $interval->format('%a days, %h hours, %i minutes');
                                            } else {
                                                $daysDiffernce = "Delivered on time!";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $registration_number = $drivername = $truckType = '';
                    $shipment_status=$shipment_status_code=$shipment_status_date='';

                    if(isset($res['shift_id']) && $res['shift_id']!='' &&  $res['shift_id']!=0){
                        $shiftIndex=$res['shift_id'];
                        if(isset($driverAcceptanceArray[$shiftIndex])){
                            if($driverAcceptanceArray[$shiftIndex]['driver_acceptance_date']!=''){
                                $accepted = $driverAcceptanceArray[$shiftIndex]['driver_acceptance_date'];
                                if($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0"){
                                    $acceptdate      = getdatetimebytimezone( $curtz, $accepted, DFLT_TZ );
                                    $accepted_datetime = date('Y-m-d h:i A',strtotime($acceptdate['datetime']));
                                }
                            }
                        }


                        if(isset($driverVehicleArray[$shiftIndex])){
                            if($driverVehicleArray[$shiftIndex]['register_number']!=''){
                                $registration_number=$driverVehicleArray[$shiftIndex]['register_number'];
                            }
                            if($driverVehicleArray[$shiftIndex]['drivername']!=''){
                                $drivername=$driverVehicleArray[$shiftIndex]['drivername'];
                            }
                            if($driverVehicleArray[$shiftIndex]['trucktype']!=''){
                                $truckType = $driverVehicleArray[$shiftIndex]['trucktype'];
                            }
                        }

                        if(isset($genericStatusArray[$shiftIndex])){
                            $shipment_status=$genericStatusArray[$shiftIndex]['generic_status_status_name'];
                            $shipment_status_code=$genericStatusArray[$shiftIndex]['generic_status_status_code'];
                            $shipment_status_date=$genericStatusArray[$shiftIndex]['generic_status_createdon'];

                            if($shipment_status_code=='0100'){
                                $shipment_status='Booked By Supplier';
                            }else if($shipment_status_code=='0212'){
                                $shipment_status='Accepted By Driver';
                            }else if($shipment_status_code=='0420'){
                                $shipment_status='Pickup Gate In';
                            }else if($shipment_status_code=='0500'){
                                $shipment_status='Actual Pickup';
                            }else if($shipment_status_code=='0191'){
                                $shipment_status='Gate Out';
                            }else if($shipment_status_code=='1550'){
                                $shipment_status='In-Transit';
                            }else if($shipment_status_code=='0192'){
                                $shipment_status='Delivery Gate In';
                            }else if($shipment_status_code=='3000'){
                                $shipment_status='Delivered To Consignee';
                            }else if($shipment_status_code=='2300'){
                                $shipment_status='Arrival at Delivery Point';
                            }else if($shipment_status_code=='2400' || $shipment_status_code=='0218'){
                                $shipment_status='Closed';
                            }

                            if($res['trip_sts']==1){
                                $shipment_status='Delivered To Consignee';
                            }
                        }
                    }

                    if($shipment_status==''){
                        $shipment_status_date = $res['createdon'];
                    }

                    if($shipment_status_date != "" && $shipment_status_date != "0000-00-00 00:00:00" && $shipment_status_date != "0"){
                        $shipment_status_array      = getdatetimebytimezone( $curtz, $shipment_status_date, DFLT_TZ );
                        $shipment_status_date = date('Y-m-d h:i A',strtotime($shipment_status_array['datetime']));
                    }

                    /*if($shipment_status_date != ""){
                        if($epodp_date != ""){
                            if($shipment_status_date < $epodp_date){
                                $shipment_status = "Goods Loaded for Delivery";
                                $shipment_status_date = $epodp_date;
                            }
                        }
                        if($drop_poddate != ""){
                            if($shipment_status_date < $drop_poddate){
                                $shipment_status = "ePOD Available";
                                $shipment_status_date = $drop_poddate;
                            }
                        }
                    }else{
                        if($drop_poddate != "" && $epodp_date != "" ){
                            if($epodp_date < $drop_poddate){
                                $shipment_status = "ePOD Available";
                                $shipment_status_date = $drop_poddate;
                            }else{
                                $shipment_status = "Goods Loaded for Delivery";
                                $shipment_status_date = $epodp_date;
                            }
                        }
                    }*/
                    if($shipment_status_date != ""){
                        $shipment_status_date = date("d M,y h:i A",strtotime($shipment_status_date));
                    }

                    $booked_status = $res['createdon'];
                    if($booked_status != "" && $booked_status != "0000-00-00 00:00:00" && $booked_status != "0"){
                        $booked_status_array      = getdatetimebytimezone( $curtz, $booked_status, DFLT_TZ );
                        $booked_status = date('Y-m-d h:i A',strtotime($booked_status_array['datetime']));
                    }
                    $booked_status = date("Y-m-d h:i A",strtotime($res['createdon']));



                    $empty  = "";
                    $content .= '[';
                        $j=0;
                        $recordListing[ $i ][0]  = '';
                        $recordListing[ $i ][++$j]  = $res['order_id'];
                        if ($checkPHKNCustomer) {
                            $recordListing[$i][++$j] = $res['product'];
                        }
                        $recordListing[ $i ][++$j]  = $res['customer_name'];
                        $recordListing[ $i ][++$j]  = $earlyPickupDateTime;
                        $recordListing[ $i ][++$j]  = $latePickupDateTime;
                        $recordListing[ $i ][++$j]  = $earlyDeliveryDateTime;
                        $recordListing[ $i ][++$j]  = $lateDeliveryDateTime;
                        $recordListing[ $i ][++$j]  = $pickup_address;
                        $recordListing[ $i ][++$j]  = $delivery_address;
                        $recordListing[ $i ][++$j]  = $quantity;
                        $recordListing[ $i ][++$j]  = $weight;
                        $recordListing[ $i ][++$j]  = $volume;
                        //log_message("error","lbhReport111:".$lbhReport);
                        if($lbhReport == "Yes"){
                            $recordListing[ $i ][++$j]  = $length;
                            $recordListing[ $i ][++$j]  = $width;
                            $recordListing[ $i ][++$j]  = $height;
                        }
                        
                        if (($this->session->userdata('company_code') != "VNKN") || ($this->session->userdata('company_code') != "NZPG")) {
                            $recordListing[ $i ][++$j]  = $pickup_datetime;
                            $recordListing[ $i ][++$j]  = $delivered_time;
                            $recordListing[ $i ][++$j]  = $daysDiffernce;
                        }

                        if ($business_type != 'Customer' || !$checkVendorCondition) {
                            if ($this->session->userdata('company_code') ==='PHKN') {
                                if ((int) $this->session->userdata('user_role_id') !== 4) {
                                    $recordListing[$i][++$j] = $res['carrier'];
                                }
                            } else {
                                $recordListing[$i][++$j] = $res['carrier'];
                            }
                        }

                        $recordListing[ $i ][++$j]  = $registration_number;
                        $recordListing[ $i ][++$j]  = $truckType;
                        $recordListing[ $i ][++$j]  = $drivername;

                        $recordListing[ $i ][++$j]  = $tkn ?? $delivery_note;
                        $recordListing[ $i ][++$j]  = $awb;
                        $recordListing[ $i ][++$j]  = $invoice;
                       
                    if ($checkPHKNCustomer) {
                       // $recordListing[ $i ][++$j]  = $salog_ref;
                    }
                        
                        $recordListing[ $i ][++$j]  = $res['shipmentid'];
                        $recordListing[ $i ][++$j]  = $res['pickup_company'];
                        $recordListing[ $i ][++$j]  = $res['delivery_company'];

                    if (($this->session->userdata('company_code') == "VNKN") || ($this->session->userdata('company_code') == "NZPG")) {
                        $recordListing[ $i ][++$j]  = $booked_status ;
                            $recordListing[ $i ][++$j]  = $accepted_datetime;
                            $recordListing[ $i ][++$j]  = $pgatein_datetime;
                            $recordListing[ $i ][++$j]  = $pickup_datetime;
                            $recordListing[ $i ][++$j]  = $pickup_gateout_datetime;
                            $recordListing[ $i ][++$j]  = $transit_datetime;
                            $recordListing[ $i ][++$j]  = $dgatin_datetime;
                            $recordListing[ $i ][++$j]  = $delivered_time;
                            $recordListing[ $i ][++$j]  = $dgatout_datetime;
                        }

                        $recordListing[ $i ][++$j]  = $pod_status;
                        if ($this->session->userdata('company_code') == "VNKN") {
                            $recordListing[$i][++$j] = $pup_status;
                        }
                        $recordListing[ $i ][++$j]  = $shipment_status;
                        $recordListing[ $i ][++$j]  = $shipment_status_date;


                    $i ++;
                    $cntr++;
                }
                }
                else
                {
                        $quantity = (!empty($data['quantity'])) ? $data['quantity'] :  0.0 ;
                        $weight = (!empty($data['weight'])) ? $data['weight'] :  0.0 ;
                        $volume = (!empty($data['volume'])) ? $data['volume'] :  0.0 ;
                        $weightUnit = ($data['weight_unit'] != null) ? $data['weight_unit'] : '';
                        $volumeUnit = ($data['volume_unit'] != null) ? $data['volume_unit'] : '';
                        //log_message("error","weight111:".$weight);
                        $weight = $this->Order->weightConvertKgs($weightUnit, (float)($weight));
                        //log_message("error","weight:".$weight);
                        //log_message("error","volume111:".$volume);
                        $volume = $this->Order->volumeConvertCbft($volumeUnit, (float)($volume));
                        //log_message("error","volume:".$volume);
                        
                        $length = (!empty($data['length'])) ? $data['length'] :  0.0 ;
                        $width = (!empty($data['width'])) ? $data['width'] :  0.0 ;
                        $height = (!empty($data['height'])) ? $data['height'] :  0.0 ;
                        $lengthUnit = ($data['length_unit'] != null) ? $data['length_unit'] : '';
                        $widthUnit = ($data['width_unit'] != null) ? $data['width_unit'] : '';
                        $heightUnit = ($data['height_unit'] != null) ? $data['height_unit'] : '';
                        $length = $this->Order->dimensionsConvertft($lengthUnit, (float)($length));
                        $width = $this->Order->dimensionsConvertft($widthUnit, (float)($width));
                        $height = $this->Order->dimensionsConvertft($heightUnit, (float)($height));
                        
                    $delivery_note = $awb = $invoice = $epodp_date = $pod_status_date = $salog_ref = "";
                    $referenceData=$podData='';
                    if (isset($res['reference_value'])) {
                        $referenceData = $res['reference_value'];
                    }
                    if ($referenceData != '') {
                        $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                            if (isset($arrayData['DQ'])) {
                                $delivery_note = $arrayData['DQ'];
                            }
                            
                            if (isset($arrayData['AWB'])) {
                                $awb = $arrayData['AWB'];
                            }
                            
                            if (isset($arrayData['IV'])) {
                                $invoice = $arrayData['IV'];
                            }
                            
                            if (isset($arrayData['XSR'])) {
                                $salog_ref = $arrayData['XSR'];
                            }                           
                    }

                    if (isset($res['pod_details'])) {
                        $podData = $res['pod_details'];
                    }

                    $drop_pod = $pickup_pod = $drop_poddate = $pod_status = $epodp_date = "";
                    if( $podData!=''){
                        $podArray = $this->DataArrayFormatter_model->formatGenericParameters($podData);
                        if(!empty($podArray) && sizeof($podArray)>0){
                            foreach($podArray as $eachPod){
                                if(isset($eachPod['stop_type'])){
                                    if($eachPod['stop_type']=='P'){
                                        $pickup_pod = $eachPod['createdon'];
                                        if($pickup_pod != "" && $pickup_pod != "0000-00-00 00:00:00" && $pickup_pod != "0"){
                                            $pickup_pod_status      = getdatetimebytimezone( $curtz, $pickup_pod, DFLT_TZ );
                                            $pickup_pod = date('Y-m-d h:i A',strtotime($pickup_pod_status['datetime']));
                                        }

                                    }else if($eachPod['stop_type']=='D'){
                                        $drop_pod = $eachPod['createdon'];
                                        if($drop_pod != "" && $drop_pod != "0000-00-00 00:00:00" && $drop_pod != "0"){
                                            $drop_pod_status      = getdatetimebytimezone( $curtz, $drop_pod, DFLT_TZ );
                                            $drop_pod = date('Y-m-d h:i A',strtotime($drop_pod_status['datetime']));
                                        }
                                    }
                                }
                            }
                        }

                        if($drop_pod != "" && $drop_pod != "0000-00-00 00:00:00") {
                            $drop_poddate = $drop_pod;
                            $pod_status .= "ePOD Available - ". date("d M,y h:i A",strtotime($drop_pod))."<br>";
                        }

                        if($pickup_pod != "" && $pickup_pod != "0000-00-00 00:00:00") {
                            $epodp_date = $pickup_pod;
                            $pod_status .= "Goods Loaded for Delivery-".date("d M,y h:i A",strtotime($pickup_pod))." ";
                        }
                    }
                    $pupData='';
                    if(isset($res['pup_details'])){
                        $pupData = $res['pup_details'];
                    }
                    $pickup_pup =  $pup_status = "";
                    if( $pupData!=''){
                        $pupArray = $this->DataArrayFormatter_model->formatGenericParameters($pupData);
                        if(!empty($pupArray) && sizeof($pupArray)>0){
                            foreach($pupArray as $eachPup){
                                if(isset($eachPup['stop_type'])){
                                    if($eachPup['stop_type']=='P'){
                                        $pickup_pup = $eachPup['createdon'];
                                        if($pickup_pup != "" && $pickup_pup != "0000-00-00 00:00:00" && $pickup_pup != "0"){
                                            $pickup_pup_status      = getdatetimebytimezone( $curtz, $pickup_pup, DFLT_TZ );
                                            $pickup_pup = date('Y-m-d h:i A',strtotime($pickup_pup_status['datetime']));
                                        }

                                    }
                                }
                            }
                        }
                        if($pickup_pup != "" && $pickup_pup != "0000-00-00 00:00:00") {
                            $pup_status .= "PUP Available -".date("d M,y h:i A",strtotime($pickup_pup))." ";
                        }
                    }

                    $pickup_address1 = $pickup_city = $pickup_country = $daysDiffernce = $pickup_pincode = $delivery_address1 = $delivery_city = $delivery_country = $delivery_pincode = $pickup_address2 = $delivery_address2 = $delivery_company = $pickup_company = "";
                    
                    $earlyPickupDateTime = (!empty($res['early_pickup_datetime'])) ? $res['early_pickup_datetime'] :  "" ;
                    $latePickupDateTime = (!empty($res['late_pickup_datetime'])) ? $res['late_pickup_datetime'] :  "" ;
                    $earlyDeliveryDateTime = (!empty($res['early_delivery_datetime'])) ? $res['early_delivery_datetime'] :  "" ;
                    $lateDeliveryDateTime = (!empty($res['late_delivery_datetime'])) ? $res['late_delivery_datetime'] :  "" ;
                    $pickup_company = (!empty($res['pickup_company'])) ? $res['pickup_company'] :  "" ;
                    $delivery_company = (!empty($res['delivery_company'])) ? $res['delivery_company'] :  "" ;
                    $pickup_address1 = (!empty($res['pickup_address1'])) ? $res['pickup_address1'].' , ' :  "" ;
                    $pickup_address2 = (!empty($res['pickup_address2'])) ? $res['pickup_address2'].' , ' :  "" ;
                    $pickup_city = (!empty($res['pickup_city'])) ? $res['pickup_city'].' , ' :  "" ;
                    $pickup_country = (!empty($res['pickup_country'])) ? $res['pickup_country'].' , ' :  "" ;
                    $pickup_pincode = (!empty($res['pickup_pincode'])) ? $res['pickup_pincode'].' , ' :  "" ;

                    $delivery_address1 = (!empty($res['delivery_address1'])) ? $res['delivery_address1'].' , ' :  "" ;
                    $delivery_address2 = (!empty($res['delivery_address2'])) ? $res['delivery_address2'].' , ' :  "" ;
                    $delivery_city = (!empty($res['delivery_city'])) ? $res['delivery_city'].' , ' :  "" ;
                    $delivery_country = (!empty($res['delivery_country'])) ? $res['delivery_country'].' , ' :  "" ;
                    $delivery_pincode = (!empty($res['delivery_pincode'])) ? $res['delivery_pincode'].' , ' :  "" ;

                    $pickup_address = $pickup_address1.$pickup_city.$pickup_address2.$pickup_country.$pickup_pincode;
                    $delivery_address = $delivery_address1.$delivery_city.$delivery_address2.$delivery_country.$delivery_pincode;

                    $pickup_address = trim($pickup_address,' , ');
                    $delivery_address = trim($delivery_address,' , ');
                    
                    /*if($lbhReport == "Yes"){
                        
                    }
                    else
                    {
                        $quantity = (!empty($orderCargo['quantity'])) ? $orderCargo['quantity'] :  0.0 ;
                        $weight = (!empty($orderCargo['weight'])) ? $orderCargo['weight'] :  0.0 ;
                        $volume = (!empty($orderCargo['volumeFT'])) ? $orderCargo['volumeFT'] :  0.0 ;
                    }*/

                    $accepted_datetime=$pgatein_datetime = $pickup_datetime = $pickup_gateout_datetime =  $transit_datetime = $dgatin_datetime = $dgatout_datetime = $delivered_time = $delivery_date_status = $booked_status = "";
                    $last_status_name = "Booked by Supplier";
                    //log_message("error","res:".json_encode($res));
                    if(isset($res['stop_status_code'])){
                        if($res['stop_status_code']!=''){
                            $stopStatusArray=array( $res['stop_status_createdon'],$res['stop_status_code'] );
                            $getStopStatusArray=$this->DataArrayFormatter_model->buildGenericArray($stopStatusArray);
                            //log_message("error","Size:".sizeof($getStopStatusArray));
                           //echo "<pre>";print_r($getStopStatusArray);
                            if(!empty($getStopStatusArray) && sizeof($getStopStatusArray)>0){
                                foreach($getStopStatusArray as $eachItem){

                                    //log_message("error","StatusCode:".$eachItem['status_code']);
                                    if($eachItem['status_code']=='0420'){
                                        //pickup gate in
                                        $pgatein_status = $eachItem['createdon'];
                                        if($pgatein_status != "" && $pgatein_status != "0000-00-00 00:00:00" && $pgatein_status != "0"){
                                            $pgatein_date_status      = getdatetimebytimezone( $curtz, $pgatein_status, DFLT_TZ );
                                            $pgatein_datetime = date('Y-m-d h:i A',strtotime($pgatein_date_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='0500' || $eachItem['status_code']=='SV0131'){
                                        //Pickup
                                        $pickupdate = $eachItem['createdon'];;
                                        if($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0"){
                                            $pickup_date_status      = getdatetimebytimezone( $curtz, $pickupdate, DFLT_TZ );
                                            $pickup_datetime = date('Y-m-d h:i A',strtotime($pickup_date_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='0191'){
                                        //Pickup gateout
                                        $pickup_gateout = $eachItem['createdon'];;
                                        if($pickup_gateout != "" && $pickup_gateout != "0000-00-00 00:00:00" && $pickup_gateout != "0"){
                                            $pickup_gateout_status      = getdatetimebytimezone( $curtz, $pickup_gateout, DFLT_TZ );
                                            $pickup_gateout_datetime = date('Y-m-d h:i A',strtotime($pickup_gateout_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='1550'){
                                        //Transit time
                                        $transit = $eachItem['createdon'];;
                                        if($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0"){
                                            $transitdate      = getdatetimebytimezone( $curtz, $transit, DFLT_TZ );
                                            $transit_datetime = date('Y-m-d h:i A',strtotime($transitdate['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='0192'){
                                        //drop gatein
                                        $dgatin_status = $eachItem['createdon'];;
                                        if($dgatin_status != "" && $dgatin_status != "0000-00-00 00:00:00" && $dgatin_status != "0"){
                                            $dgatin_date_status      = getdatetimebytimezone( $curtz, $dgatin_status, DFLT_TZ );
                                            $dgatin_datetime = date('Y-m-d h:i A',strtotime($dgatin_date_status['datetime']));
                                        }
                                    }else if($eachItem['status_code']=='2300'){
                                        //drop gateout
                                        $dgatout_status = $eachItem['createdon'];;
                                        if($dgatout_status != "" && $dgatout_status != "0000-00-00 00:00:00" && $dgatout_status != "0"){
                                            $dgatout_date_status      = getdatetimebytimezone( $curtz, $dgatout_status, DFLT_TZ );
                                            $dgatout_datetime = date('Y-m-d h:i A',strtotime($dgatout_date_status['datetime']));
                                        }
                                    }if($eachItem['status_code']=='3000' || $eachItem['status_code']=='SV0510'){
                                        //delivery time
                                        $delivered_time = $eachItem['createdon'];;
                                        if($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0"){
                                            $deliverydate      = getdatetimebytimezone( $curtz, $delivered_time, DFLT_TZ );
                                            $delivered_time = date('Y-m-d h:i A',strtotime($deliverydate['datetime']));
                                            $estimatedDelivery = new DateTime($lateDeliveryDateTime);
                                            $actualDelivery = new DateTime($delivered_time);
                                            $interval = $estimatedDelivery->diff($actualDelivery);
                                            if ($actualDelivery > $estimatedDelivery) {
                                                $daysDiffernce = "Delivered late by " . $interval->format('%a days, %h hours, %i minutes');
                                            } elseif ($actualDelivery < $estimatedDelivery) {
                                                $daysDiffernce = "Delivered early by " . $interval->format('%a days, %h hours, %i minutes');
                                            } else {
                                                $daysDiffernce = "Delivered on time!";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $registration_number = $drivername = $truckType = '';
                    $shipment_status=$shipment_status_code=$shipment_status_date='';

                    if(isset($res['shift_id']) && $res['shift_id']!='' &&  $res['shift_id']!=0){
                        $shiftIndex=$res['shift_id'];
                        if(isset($driverAcceptanceArray[$shiftIndex])){
                            if($driverAcceptanceArray[$shiftIndex]['driver_acceptance_date']!=''){
                                $accepted = $driverAcceptanceArray[$shiftIndex]['driver_acceptance_date'];
                                if($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0"){
                                    $acceptdate      = getdatetimebytimezone( $curtz, $accepted, DFLT_TZ );
                                    $accepted_datetime = date('Y-m-d h:i A',strtotime($acceptdate['datetime']));
                                }
                            }
                        }


                        if(isset($driverVehicleArray[$shiftIndex])){
                            if($driverVehicleArray[$shiftIndex]['register_number']!=''){
                                $registration_number=$driverVehicleArray[$shiftIndex]['register_number'];
                            }
                            if($driverVehicleArray[$shiftIndex]['drivername']!=''){
                                $drivername=$driverVehicleArray[$shiftIndex]['drivername'];
                            }
                            if($driverVehicleArray[$shiftIndex]['trucktype']!=''){
                                $truckType = $driverVehicleArray[$shiftIndex]['trucktype'];
                            }
                        }

                        if(isset($genericStatusArray[$shiftIndex])){
                            $shipment_status=$genericStatusArray[$shiftIndex]['generic_status_status_name'];
                            $shipment_status_code=$genericStatusArray[$shiftIndex]['generic_status_status_code'];
                            $shipment_status_date=$genericStatusArray[$shiftIndex]['generic_status_createdon'];

                            if($shipment_status_code=='0100'){
                                $shipment_status='Booked By Supplier';
                            }else if($shipment_status_code=='0212'){
                                $shipment_status='Accepted By Driver';
                            }else if($shipment_status_code=='0420'){
                                $shipment_status='Pickup Gate In';
                            }else if($shipment_status_code=='0500'){
                                $shipment_status='Actual Pickup';
                            }else if($shipment_status_code=='0191'){
                                $shipment_status='Gate Out';
                            }else if($shipment_status_code=='1550'){
                                $shipment_status='In-Transit';
                            }else if($shipment_status_code=='0192'){
                                $shipment_status='Delivery Gate In';
                            }else if($shipment_status_code=='3000'){
                                $shipment_status='Delivered To Consignee';
                            }else if($shipment_status_code=='2300'){
                                $shipment_status='Arrival at Delivery Point';
                            }else if($shipment_status_code=='2400' || $shipment_status_code=='0218'){
                                $shipment_status='Closed';
                            }

                            if($res['trip_sts']==1){
                                $shipment_status='Delivered To Consignee';
                            }
                        }
                    }

                    if($shipment_status==''){
                        $shipment_status_date = $res['createdon'];
                    }

                    if($shipment_status_date != "" && $shipment_status_date != "0000-00-00 00:00:00" && $shipment_status_date != "0"){
                        $shipment_status_array      = getdatetimebytimezone( $curtz, $shipment_status_date, DFLT_TZ );
                        $shipment_status_date = date('Y-m-d h:i A',strtotime($shipment_status_array['datetime']));
                    }

                    /*if($shipment_status_date != ""){
                        if($epodp_date != ""){
                            if($shipment_status_date < $epodp_date){
                                $shipment_status = "Goods Loaded for Delivery";
                                $shipment_status_date = $epodp_date;
                            }
                        }
                        if($drop_poddate != ""){
                            if($shipment_status_date < $drop_poddate){
                                $shipment_status = "ePOD Available";
                                $shipment_status_date = $drop_poddate;
                            }
                        }
                    }else{
                        if($drop_poddate != "" && $epodp_date != "" ){
                            if($epodp_date < $drop_poddate){
                                $shipment_status = "ePOD Available";
                                $shipment_status_date = $drop_poddate;
                            }else{
                                $shipment_status = "Goods Loaded for Delivery";
                                $shipment_status_date = $epodp_date;
                            }
                        }
                    }*/
                    if($shipment_status_date != ""){
                        $shipment_status_date = date("d M,y h:i A",strtotime($shipment_status_date));
                    }

                    $booked_status = $res['createdon'];
                    if($booked_status != "" && $booked_status != "0000-00-00 00:00:00" && $booked_status != "0"){
                        $booked_status_array      = getdatetimebytimezone( $curtz, $booked_status, DFLT_TZ );
                        $booked_status = date('Y-m-d h:i A',strtotime($booked_status_array['datetime']));
                    }
                    $booked_status = date("Y-m-d h:i A",strtotime($res['createdon']));



                    $empty  = "";
                    $content .= '[';
                        $j=0;
                        $recordListing[ $i ][0]  = '';
                        $recordListing[ $i ][++$j]  = $res['order_id'];
                        if ($checkPHKNCustomer) {
                            $recordListing[$i][++$j] = $res['product'];
                        }
                        $recordListing[ $i ][++$j]  = $res['customer_name'];
                        $recordListing[ $i ][++$j]  = $earlyPickupDateTime;
                        $recordListing[ $i ][++$j]  = $latePickupDateTime;
                        $recordListing[ $i ][++$j]  = $earlyDeliveryDateTime;
                        $recordListing[ $i ][++$j]  = $lateDeliveryDateTime;
                        $recordListing[ $i ][++$j]  = $pickup_address;
                        $recordListing[ $i ][++$j]  = $delivery_address;
                        $recordListing[ $i ][++$j]  = $quantity;
                        $recordListing[ $i ][++$j]  = $weight;
                        $recordListing[ $i ][++$j]  = $volume;
                        //log_message("error","lbhReport111:".$lbhReport);
                        if($lbhReport == "Yes"){
                            $recordListing[ $i ][++$j]  = $length;
                            $recordListing[ $i ][++$j]  = $width;
                            $recordListing[ $i ][++$j]  = $height;
                        }
                        
                        if (($this->session->userdata('company_code') != "VNKN") || ($this->session->userdata('company_code') != "NZPG")) {
                            $recordListing[ $i ][++$j]  = $pickup_datetime;
                            $recordListing[ $i ][++$j]  = $delivered_time;
                            $recordListing[ $i ][++$j]  = $daysDiffernce;
                        }

                        if ($business_type != 'Customer' || !$checkVendorCondition) {
                            if ($this->session->userdata('company_code') ==='PHKN') {
                                if ((int) $this->session->userdata('user_role_id') !== 4) {
                                    $recordListing[$i][++$j] = $res['carrier'];
                                }
                            } else {
                                $recordListing[$i][++$j] = $res['carrier'];
                            }
                        }

                        $recordListing[ $i ][++$j]  = $registration_number;
                        $recordListing[ $i ][++$j]  = $truckType;
                        $recordListing[ $i ][++$j]  = $drivername;

                        $recordListing[ $i ][++$j]  = $delivery_note;
                        $recordListing[ $i ][++$j]  = $awb;
                        $recordListing[ $i ][++$j]  = $invoice;
                       
                    if ($checkPHKNCustomer) {
                       // $recordListing[ $i ][++$j]  = $salog_ref;
                    }
                        
                        $recordListing[ $i ][++$j]  = $res['shipmentid'];
                        $recordListing[ $i ][++$j]  = $res['pickup_company'];
                        $recordListing[ $i ][++$j]  = $res['delivery_company'];

                    if (($this->session->userdata('company_code') == "VNKN") || ($this->session->userdata('company_code') == "NZPG")) {
                        $recordListing[ $i ][++$j]  = $booked_status ;
                            $recordListing[ $i ][++$j]  = $accepted_datetime;
                            $recordListing[ $i ][++$j]  = $pgatein_datetime;
                            $recordListing[ $i ][++$j]  = $pickup_datetime;
                            $recordListing[ $i ][++$j]  = $pickup_gateout_datetime;
                            $recordListing[ $i ][++$j]  = $transit_datetime;
                            $recordListing[ $i ][++$j]  = $dgatin_datetime;
                            $recordListing[ $i ][++$j]  = $delivered_time;
                            $recordListing[ $i ][++$j]  = $dgatout_datetime;
                        }

                        $recordListing[ $i ][++$j]  = $pod_status;
                        if ($this->session->userdata('company_code') == "VNKN") {
                            $recordListing[$i][++$j] = $pup_status;
                        }
                        $recordListing[ $i ][++$j]  = $shipment_status;
                        $recordListing[ $i ][++$j]  = $shipment_status_date;


                    $i ++;
                    $cntr++;
                }

               // echo "<pre>";print_r($recordListing);exit;

                $content    .= ']';
                $final_data = json_encode( $recordListing );
            }
            } else {
                $final_data = '[]';
            }
            echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';

    }
    
    public function runReportCron()
    {
        $to = date('Y-m-d', strtotime('-1 day'));
        $from = date('Y-m-d', strtotime('-90 days'));
        
        $cidCodes = [XP_INDIA_EATON, XP_INDIA_SIEMENS];
        
        $whereIn = "e.cid_code IN ('" . implode("','", $cidCodes) . "') AND p.status = '1'";
        $usersData = $this->common->getjointbldata(
            "tbl_party_master p",
            "email_generator_settings e",
            "p.code = e.cid_code",
            $whereIn,
            "p.user_id, p.company_code, p.branch_code, e.to_address_lists, e.cc_address_lists, e.bcc_address_lists",
            0,    
            0     
        );

        
        $userList = [];
        foreach ($usersData as $user) {
            $userList[] = [
                'user_id'       => $user['user_id'],
                'company_code'  => $user['company_code'],
                'branch_code'   => $user['branch_code'],
                'customer_name' => ucfirst(strtolower($user['branch_code'])),
                'to_address_lists'   => $user['to_address_lists'],
                'cc_address_lists'   => $user['cc_address_lists'],
                'bcc_address_lists'   => $user['bcc_address_lists'],
            ];
        }        

        if (!empty($userList)) { 
            foreach ($userList as $user) {
                // Simulate POST
                $_POST = [
                    'draw' => 1,
                    'start' => 0,
                    'length' => 1000,
                    'order' => [['column' => 0, 'dir' => 'desc']],
                    'data' => [
                        'fromdate_search' => $from,
                        'todate_search' => $to
                    ]
                ];
                
                $timeZone = $this->Standardbookingmodel->getUserTimeZone($user['user_id']);
                
                // 🔄 Set session dynamically
                $this->session->set_userdata([
                    'user_id' => $user['user_id'],
                    'company_code' => $user['company_code'],
                    'usr_tzone' => ['timezone' => $timeZone],
                ]);
        
                // Capture report output
                ob_start();
                $this->ajaxListing();
                $output = ob_get_clean();
                $decoded = json_decode($output, true);
        
                if (!is_array($decoded) || !isset($decoded['data'])) {
                    log_message('error', "Failed to decode JSON for user {$user['user_id']}: $output");
                    continue;
                }
        
                $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
                $sheet = $spreadsheet->getActiveSheet();
        
                $headers = [
                    'Booking ID', 'Product', 'Customer', 'Estimated Early Pickup', 'Estimated Late Pickup',
                    'Estimated Early Delivery', 'Estimated Late Delivery', 'PickUp Address', 'Delivery Address',
                    'Quantity', 'Weight (KG)', 'Volume (CU FT)','PickUp Status Date & Time', 'Delivery Date / Time', 'OTD', 
                    'Carrier', 'Truck Number', 'Vehicle Type', 'Driver Name', 'Delivery Note', 'AWB Number', 'Invoice Number', 'Trip ID', 'Shipper Name',
                    'Consignee Name', 'POD Status', 'Last Status', 'Last Status Date'
                ];
        
                foreach ($headers as $index => $header) {
                    $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($index + 1);
                    $sheet->setCellValue($colLetter . '1', $header);
                    $sheet->getStyle($colLetter . '1')->getFont()->setBold(true);
                    $sheet->getColumnDimension($colLetter)->setAutoSize(true);
                }
        
                $rowNum = 2;
                foreach ($decoded['data'] as $dataRow) {
                    if (empty($dataRow[0])) {
                        array_shift($dataRow);
                    }
                    foreach ($dataRow as $colIndex => $cell) {
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex + 1);
                        $value = is_array($cell) ? implode(', ', $cell) : (is_string($cell) ? trim($cell) : (string)$cell);
                        $sheet->setCellValue($colLetter . $rowNum, $value);
                    }
                    $rowNum++;
                }
        
                // Dynamic filename
                $filename = APPPATH . 'logs/' . ucfirst(strtolower($user['customer_name'])) . '_Customer_Report.xlsx';
                $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
                $writer->save($filename);
                
                $toList  = isset($user['to_address_lists']) ? array_map('trim', explode(',', $user['to_address_lists'])) : [];
                $ccList  = isset($user['cc_address_lists']) ? array_map('trim', explode(',', $user['cc_address_lists'])) : [];
                $bccList = isset($user['bcc_address_lists']) ? array_map('trim', explode(',', $user['bcc_address_lists'])) : [];

                
                $subject = $user['customer_name'] . " - Customer Daily Report";
                
                $message = "EXTERNAL EMAIL<br><br>";
                
                $message = "Hello,<br><br>";
                $message .= "Greetings ! <br>";
                $message .= "Please find attached Daily Report<br>";
                $message .= "Hope this helps you to keep track of all the consignments<br><br>";
                $message .= "This is an automatically generated Email, please do not reply <br><br>";
                $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
                
                $this->sendEmailNotification($filename, $subject, $message, $toList, $ccList, $bccList);
        
                echo "Success";
            }
        }
    }
    
    public function sendEmailNotification(string $fileName, string $subject, string $message, array $toAddresses = [], array $ccAddresses = [], array $bccAddresses = []): void
    {
        $this->load->library('PhpMailerLibrary');
        try {
            $mail = $this->phpmailerlibrary->mail;
    
            $mail->SMTPDebug = 0; 
    
            $mail->clearAllRecipients();
            $mail->clearAttachments();
            $mail->setFrom('no-reply@svkonekt.com', 'SVKonekt Support');
    
            // Add To recipients
            if (!empty($toAddresses)) {
                foreach ($toAddresses as $toEmail) {
                    if (!empty($toEmail)) {
                        $mail->addAddress(trim($toEmail));
                    }
                }
            }
    
            if (!empty($ccAddresses)) {
                foreach ($ccAddresses as $ccEmail) {
                    if (!empty($ccEmail)) {
                        $mail->addCC(trim($ccEmail));
                    }
                }
            }
    
            if (!empty($bccAddresses)) {
                foreach ($bccAddresses as $bccEmail) {
                    if (!empty($bccEmail)) {
                        $mail->addBCC(trim($bccEmail));
                    }
                }
            }
    
            $mail->Subject = $subject;
            $mail->isHTML(true);
            $mail->Body = $message;
    
            if (!empty($fileName) && file_exists($fileName)) {
                $mail->addAttachment($fileName);
            }

    
            if ($mail->send()) {
                log_message("error", "Email Sent For " . $subject);
            } else {
                log_message("error", "Email Failed For " . $subject);
            }
    
            //unlink($tmpFile);
    
        } catch (Exception $e) {
            log_message("error", "Email Failed - " . $e->getMessage());
        }
    }
    
    public function runDueDeliveryReportCron()
    {
        log_message('error', "Innn:");
        // Company/branch codes filter
        $cidCodes = [XP_INDIA_EATON, XP_INDIA_SIEMENS];
    
        $whereIn = "e.cid_code IN ('" . implode("','", $cidCodes) . "') AND p.status = '1'";
        $usersData = $this->common->getjointbldata(
            "tbl_party_master p",
            "email_generator_settings e",
            "p.code = e.cid_code",
            $whereIn,
            "p.user_id, p.company_code, p.branch_code, e.to_address_lists, e.cc_address_lists, e.bcc_address_lists",
            0,
            0
        );
        
        $userList = [];
        foreach ($usersData as $user) {
            $userList[] = [
                'user_id'          => $user['user_id'],
                'company_code'     => $user['company_code'],
                'branch_code'      => $user['branch_code'],
                'customer_name'    => ucfirst(strtolower($user['branch_code'])),
                'to_address_lists' => $user['to_address_lists'],
                'cc_address_lists' => $user['cc_address_lists'],
                'bcc_address_lists'=> $user['bcc_address_lists'],
            ];
        }
        
    
        if (empty($userList)) {
            log_message('error', "No users found for report cron");
            return;
        }
    
        foreach ($userList as $user) {
            
            $_POST = [
                'draw' => 1,
                'start' => 0,
                'length' => 1000,
                'order' => [['column' => 0, 'dir' => 'desc']],
                'data' => [
                    'fromdate_search' => $from,
                    'todate_search' => $to
                ]
            ];
            // Set users timezone and session context
            $timeZone = $this->Standardbookingmodel->getUserTimeZone($user['user_id']);
            $this->session->set_userdata([
                'user_id'     => $user['user_id'],
                'company_code'=> $user['company_code'],
                'usr_tzone'   => ['timezone' => $timeZone],
            ]);
    
            ob_start();
            $this->ajaxListing();
            $output = ob_get_clean();
            //log_message('error', "output:".json_encode($output));
            $decoded = json_decode($output, true);
            //log_message('error', "decoded:".json_encode($decoded['data']));
            if (!is_array($decoded) || !isset($decoded['data'])) {
                log_message('error', "Failed to decode JSON for user {$user['user_id']}: $output");
                continue;
            }
            
            
        
            if (!is_array($decoded) || !isset($decoded['data'])) {
                //log_message('error', "Failed to decode JSON for user {$user['user_id']}: $output");
                continue;
            }
    
            $rows = $decoded['data'] ?? [];

            // Filter for tomorrow
            $tomorrow = date('Y-m-d', strtotime('+1 day'));
            $filteredRows = array_filter($rows, function($row) use ($tomorrow) {
                $deliveryDate = isset($row[7]) ? date('Y-m-d', strtotime($row[7])) : '';

                return $deliveryDate === $tomorrow;
            });
            
            // Map display headers to numeric indexes in $row
            $columns = [
                'Booking ID'             => 1,
                'Estimated Early Pickup' => 6,
                'Estimated Late Delivery'=> 7,
                'PickUp Address'         => 8,
                'Delivery Address'       => 9,
                'Last Status'            => 25,
                'Last Status Date'       => 26
            ];
            
            // Build the spreadsheet
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            
            // Write headers
            $colIndex = 1;
            foreach ($columns as $header => $index) {
                $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
                $sheet->setCellValue($colLetter . '1', $header);
                $sheet->getStyle($colLetter . '1')->getFont()->setBold(true);
                $sheet->getColumnDimension($colLetter)->setAutoSize(true);
                $colIndex++;
            }
            
            // Write filtered rows
            $rowIndex = 2;

            if (!empty($filteredRows)) {
                foreach ($filteredRows as $row) {
                    $colIndex = 1;
                    foreach ($columns as $header => $index) {
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
                        $sheet->setCellValue($colLetter . $rowIndex, $row[$index] ?? '');
                        $colIndex++;
                    }
                    $rowIndex++;
                }
            
                // Save file
                $filename = APPPATH . 'logs/' . ucfirst(strtolower($user['customer_name'])) . '_DueDeliveryReport.xlsx';
                $writer   = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
                $writer->save($filename);
            
                // Prepare email lists
                $toList  = !empty($user['to_address_lists'])   ? array_map('trim', explode(',', $user['to_address_lists']))   : [];
                $ccList  = !empty($user['cc_address_lists'])   ? array_map('trim', explode(',', $user['cc_address_lists']))   : [];
                $bccList = !empty($user['bcc_address_lists'])  ? array_map('trim', explode(',', $user['bcc_address_lists']))  : [];
            
                $subject = $user['customer_name'] . " - Due Delivery Report";
                $message = "Hello,<br><br>"
                         . "Greetings!<br>"
                         . "Please find attached the Due Delivery Report.<br>"
                         . "This is an automatically generated email; please do not reply.<br><br>"
                         . "Thanks,<br>Support Team";
            
                $this->sendEmailNotification($filename, $subject, $message, $toList, $ccList, $bccList);
            
            } else {
                // No delayed orders  no file attachment
                $toList  = !empty($user['to_address_lists'])   ? array_map('trim', explode(',', $user['to_address_lists']))   : [];
                $ccList  = !empty($user['cc_address_lists'])   ? array_map('trim', explode(',', $user['cc_address_lists']))   : [];
                $bccList = !empty($user['bcc_address_lists'])  ? array_map('trim', explode(',', $user['bcc_address_lists']))  : [];
            
                $subject = $user['customer_name'] . " - Due Delivery Report";
                $message = "Hello,<br><br>"
                         . "Greetings!<br>"
                         . "No delayed orders for " . $user['customer_name'] . " on " . $tomorrow . ".<br>"
                         . "This is an automatically generated email; please do not reply.<br><br>"
                         . "Thanks,<br>Support Team";
            
                // Pass null as $filename since there is no attachment
                $this->sendEmailNotification(null, $subject, $message, $toList, $ccList, $bccList);
            }
    
            log_message('error', "Report generated and emailed for user {$user['user_id']}");
        }
    }

}
