<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customerpincodes extends CI_Controller
{
    
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model('common');
        $this->load->model('Uniqlomodel');
        $this->load->helper('drop_down');
        $this->load->helper('log_helper');
        if (! checkUrlAccessForUser('CUSTOMERPINCODES')) {
            redirect("Forbiddenaccess");
        }
    }

    
    public function index()
    {
        $data['page_title'] = $this->lang->line('customer_pincode');
        $data['sub_title']  = $this->lang->line('general_search');
        $company_code       = $this->session->userdata('company_code');

        $whr = $where = [];
        /*if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $where['tc.status'] = 1;
            // $origin_city = $this->input->post('origin_city');
            $origin_pin = $this->input->post('origin_pin', true);
            //  $destination_city = $this->input->post('destination_city',true);
            $destination_pin  = $this->input->post('destination_pin');
            $fdate            = $this->input->post('fromdate', true);
            $edate            = $this->input->post('todate', true);
            $searchcarrier_id = $this->input->post('searchcarrier_id', true);
            if (isset($origin_city) && $origin_city != "") {
                $whr['tc.origin_city'] = $origin_city;
            }
            if (isset($origin_pin) && $origin_pin != "") {
                $whr['tc.origin_pin'] = $origin_pin;
            }
            if (isset($destination_city) && $destination_city != "") {
                $whr['tc.destination_city'] = $destination_city;
            }
            if (isset($destination_pin) && $destination_pin != "") {
                $whr['tc.destination_pin'] = $destination_pin;
            }
            if (isset($fdate) && $fdate != "") {
                $where["DATE(tc.createdon) >="] = $fdate;
            }
            if (isset($edate) && $edate != "") {
                $where["DATE(tc.createdon) <="] = $edate;
            }
            if (isset($searchcarrier_id) && $searchcarrier_id != "") {
                $whr['tc.carrier_id'] = $searchcarrier_id;
            }
        } else*/if (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $where['tc.status'] = 1;
            $fdate            = $this->input->post('fromdate', true);
            $edate            = $this->input->post('todate', true);
            $origin_city        = $this->input->post('origin_city', true);
            $origin_pin         = $this->input->post('origin_pin', true);
            $destination_city   = $this->input->post('destination_city', true);
            $destination_pin    = $this->input->post('destination_pin', true);
            $searchcustomer_id  = $this->input->post('searchcustomer_id', true);
            $searchcarrier_id   = $this->input->post('searchcarrier_id', true);
            $destination_state  = $this->input->post('destination_state', true);
            $cust_zone          = $this->input->post('cust_zone', true);
            $carrier_zone       = $this->input->post('carrier_zone', true);
            $carrier_region     = $this->input->post('carrier_region', true);
            
            if (isset($fdate) && $fdate != "") {
                $from_date_obj = DateTime::createFromFormat('d-m-Y', $fdate);
                if ($from_date_obj !== false) {
                    $where["DATE(tc.createdon) >="] = $from_date_obj->format('Y-m-d');
                }
            }
            if (isset($edate) && $edate != "") {
                $to_date_obj = DateTime::createFromFormat('d-m-Y', $edate);
                if ($to_date_obj !== false) {
                    $where["DATE(tc.createdon) <="] = $to_date_obj->format('Y-m-d');
                }
            }

            if (isset($origin_city) && $origin_city != "") {
                $whr['tc.origin_city'] = $origin_city;
            }

            if (isset($origin_pin) && $origin_pin != "") {
                $whr['tc.origin_pin'] = $origin_pin;
            }
            if (isset($destination_city) && $destination_city != "") {
                $whr['tc.destination_city'] = $destination_city;
            }
            if (isset($destination_pin) && $destination_pin != "") {
                $whr['tc.destination_pin'] = $destination_pin;
            }
            if (isset($searchcustomer_id) && $searchcustomer_id != "") {
                $cust_id = $this->common->gettblrowdata(
                    ['code' => $searchcustomer_id],
                    'id',
                    'tb_customers',
                    0,
                    0
                );
                $whr['tc.customer_id'] = $cust_id['id'];
            }

            if (isset($searchcarrier_id) && $searchcarrier_id != "") {
                $whr['tc.carrier_id'] = $searchcarrier_id;
            }
            if (isset($destination_state) && $destination_state != "") {
                $whr['tc.destination_state'] = $destination_state;
            }

            if (isset($cust_zone) && $cust_zone != "") {
                $whr['tc.cust_zone'] = $cust_zone;
            }
            if (isset($carrier_zone) && $carrier_zone != "") {
                $whr['tc.carrier_zone'] = $carrier_zone;
            }
            if (isset($carrier_region) && $carrier_region != "") {
                $whr['tc.carrier_region'] = $carrier_region;
            }
        }

        $pincodes        = [];
        $data['vendors'] = $this->common->gettbldata(
            ['status' => '1', 'company_code' => $this->session->userdata('company_code')],
            "id,name",
            "tb_vendors",
            0,
            0
        );
        /*if (! empty($where) && ! empty($_POST)) {
            $pincodes = $this->Uniqlomodel->searchdata($where, $whr);
        }*/
        //$pincodes = $this->Uniqlomodel->searchdata($where, $whr);
        $data['pincodes'] = $pincodes;

        /*log_error(
            UNIQLO_LOG_PREFIX . "Customerpincodes outbound data for customerpincodes/index: " . json_encode($data)
        );*/

        $this->newtemplate->dashboard("customerpincodes/index", $data);
    }

    public function add()
    {
        $data['page_title'] = $this->lang->line('customer_pincode');
        $data['sub_title']  = $this->lang->line('general_add');
        $data['vendors']    = $this->common->gettbldata(
            ['status' => '1', 'company_code' => $this->session->userdata('company_code')],
            "id,name",
            "tb_vendors",
            0,
            0
        );

        log_error(
            UNIQLO_LOG_PREFIX . "Customerpincodes|add outbound data for customerpincodes/addpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("customerpincodes/addpincode", $data);
        $this->load->view("customerpincodes/addpincode", $data);
    }

    public function pincodeinsert()
    {
        $post = $this->input->post(null, true);
        extract($post);
        if ($cust_surface_tat == '') {
            $cust_surface_tat = 0;
        }
        if ($cust_return_surface_tat == '') {
            $cust_return_surface_tat = 0;
        }
        if ($carrier_surface_tat == '') {
            $carrier_surface_tat = 0;
        }
        if ($carrier_return_surface_tat == '') {
            $carrier_return_surface_tat = 0;
        }
        $cust_id = $this->common->gettblrowdata(['code' => $customer_id], 'id', 'tb_customers', 0, 0);
        $res     = [
            'origin_city'                => $origin_city,
            'origin_pin'                 => $origin_pin,
            'destination_city'           => $destination_city,
            'destination_pin'            => $destination_pin,
            'destination_state'          => $destination_state,
            'customer_id'                => $cust_id['id'],
            'cust_surface_tat'           => $cust_surface_tat,
            'cust_return_surface_tat'    => $cust_return_surface_tat,
            'carrier_surface_tat'        => $carrier_surface_tat,
            'carrier_return_surface_tat' => $carrier_return_surface_tat,
            'cust_zone'                  => $cust_zone,
            'carrier_zone'               => $carrier_zone,
            'reverse_qc'                 => $reverse_qc,
            'user_id'                    => $this->session->userdata('user_id'),
            'carrier_id'                 => $carrier_id,
            'carrier_region'             => $carrier_region,
            'cust_region'                => $cust_region,
            'createdby'                  => $this->session->userdata('user_id'),
            'createdon'                  => date('Y-m-d H:i:s'),
            'updatedby'                  => $this->session->userdata('user_id'),
            'updatedon'                  => date('Y-m-d H:i:s'),
            'user_type'                  => 0,
            'status'                     => 1,

        ];

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpincodes pincodeinsert inserted data in a tb_customer_pincodes: " . json_encode($res)
        );

        $result = $this->common->insertTableData('tb_customer_pincodes', $res);

        log_error(UNIQLO_LOG_PREFIX . "Customerpincodes pincodeinsert outbound data: " . json_encode($result));

        echo json_encode($result);
    }

    public function edit($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Customerpincodes|edit inbound data: " . $id);

        $user_id            = $this->session->userdata('user_id');
        $data['user_id']    = $user_id;
        $data['page_title'] = $this->lang->line('customer_pincode');
        $data['sub_title']  = $this->lang->line('general_edit');
        $where1             = [
            'id' => $id,
        ];

        $table1            = "tb_customer_pincodes";
        $edit_data         = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_data'] = $edit_data;
        $cust_data         = $this->common->gettblrowdata(['id' => $edit_data['customer_id']], '*', 'tb_customers', 0, 0);
        $data['cust_data'] = $cust_data;
        $data['vendors']   = $this->common->gettbldata(
            ['status' => '1', 'company_code' => $this->session->userdata('company_code')],
            "id,name",
            "tb_vendors",
            0,
            0
        );

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpincodes|edit outbound data for customerpincodes/editpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("customerpincodes/editpincode", $data);
        $this->load->view("customerpincodes/editpincode", $data);
    }

    public function pincodeupdate()
    {
        // $add = $this->input->post('save');
        $id = $this->input->post('id', true);
        if (isset($id)) {
            $user_id = $this->session->userdata('user_id');
            $post    = $this->input->post(null, true);
            extract($post);
            if ($cust_surface_tat == '') {
                $cust_surface_tat = 0;
            }
            if ($cust_return_surface_tat == '') {
                $cust_return_surface_tat = 0;
            }
            if ($carrier_surface_tat == '') {
                $carrier_surface_tat = 0;
            }
            if ($carrier_return_surface_tat == '') {
                $carrier_return_surface_tat = 0;
            }

            $cust_id = $this->common->gettblrowdata(['code' => $customer_id], 'id', 'tb_customers', 0, 0);
            $res     = [
                'origin_city'                => $origin_city,
                'origin_pin'                 => $origin_pin,
                'destination_city'           => $destination_city,
                'destination_pin'            => $destination_pin,
                'destination_state'          => $destination_state,
                'customer_id'                => $cust_id['id'],
                'cust_surface_tat'           => $cust_surface_tat,
                'cust_return_surface_tat'    => $cust_return_surface_tat,
                'carrier_surface_tat'        => $carrier_surface_tat,
                'carrier_return_surface_tat' => $carrier_return_surface_tat,
                'cust_zone'                  => $cust_zone,
                'carrier_zone'               => $carrier_zone,
                'reverse_qc'                 => $reverse_qc,
                'user_id'                    => $this->session->userdata('user_id'),
                'carrier_id'                 => $carrier_id,
                'carrier_region'             => $carrier_region,
                'cust_region'                => $cust_region,
                'updatedby'                  => $this->session->userdata('user_id'),
                'updatedon'                  => date('Y-m-d H:i:s'),

            ];

            log_error(
                UNIQLO_LOG_PREFIX .
                "pincodeupdate updated data in a tb_customer_pincodes: " . implode(', ', $res)
            );

            $table  = 'tb_customer_pincodes';
            $whr    = ['id' => $id];
            $result = $this->common->updatetbledata($table, $res, $whr);

            log_error(UNIQLO_LOG_PREFIX . "Customerpincodes pincodeupdate outbound data: " . json_encode($result));

            echo json_encode($result);
        }
    }


    public function view($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Customerpincodes|view inbound data: " . $id);

        $user_id            = $this->session->userdata('user_id');
        $data['user_id']    = $user_id;
        $data['page_title'] = $this->lang->line('customer_pincode');
        $data['sub_title']  = $this->lang->line('general_view');
        $where1             = [
            'id' => $id,
        ];

        $table1            = "tb_customer_pincodes";
        $edit_data         = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_data'] = $edit_data;
        $cust_data         = $this->common->gettblrowdata(['id' => $edit_data['customer_id']], '*', 'tb_customers', 0, 0);
        $data['cust_data'] = $cust_data;
        $data['vendor']    = $this->common->gettblrowdata(
            ['id' => $edit_data['carrier_id']],
            "id,name",
            "tb_vendors",
            0,
            0
        );

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpincodes|view outbound data for customerpincodes/viewpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("customerpincodes/viewpincode", $data);
        $this->load->view("customerpincodes/viewpincode", $data);
    }

    public function delete($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Customerpincodes|delete inbound data: " . $id);

        $table  = "tb_customer_pincodes";
        $result = $this->Uniqlomodel->delete($id, $table);
        if ($result) {
            log_error(UNIQLO_LOG_PREFIX . "Customerpincodes|delete outbound data: 1");

            echo "1";
        } else {
            log_error(UNIQLO_LOG_PREFIX . "Customerpincodes|delete outbound data: 0");

            echo "0";
        }
    }

    public function checkduplicatedata()
    {
        $post = $this->input->post(null, true);
        extract($post);
        $whr   = [];
        $where = [];
        if (isset($origin_city) && $origin_city != "") {
            $where['tc.origin_city'] = $origin_city;
        }
        if (isset($origin_pin) && $origin_pin != "") {
            $where['tc.origin_pin'] = $origin_pin;
        }
        if (isset($destination_city) && $destination_city != "") {
            $where['tc.destination_city'] = $destination_city;
        }
        if (isset($destination_pin) && $destination_pin != "") {
            $where['tc.destination_pin '] = $destination_pin;
        }
        if (isset($customer_id) && $customer_id != "") {
            $cust_id                  = $this->common->gettblrowdata(['code' => $customer_id], 'id', 'tb_customers', 0, 0);
            $where['tc.customer_id '] = $cust_id['id'];
        }
        if (isset($destination_state) && $destination_state != "") {
            $where['tc.destination_state '] = $destination_state;
        }
        if (isset($reverse_qc) && $reverse_qc != "") {
            $where['tc.reverse_qc '] = $reverse_qc;
        }

        if (isset($carrier_id) && $carrier_id != "") {
            $where['tc.carrier_id'] = $carrier_id;
        }
        if (isset($id) && $id != "") {
            $where['tc.id !='] = $id;
        }
        $table  = 'tb_customer_pincodes';
        $result = $this->Uniqlomodel->checkdupdata($where, $whr, $table);

        log_error(UNIQLO_LOG_PREFIX . "Customerpincodes checkduplicatedata outbound data: " . count($result));

        echo count($result);
    }
    public function deleteById()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $tableName = $this->input->post('table');
            $idArray   = $this->input->post('deleteids');
            $this->common->deleteStatus($idArray, $tableName);
        }
    }
    
    public function fetch_data()
    {
        // Standard DataTables POST variables

        $draw = intval($this->input->post("draw"));
        $start = intval($this->input->post("start"));
        $length = intval($this->input->post("length"));
        $searchValue = $_POST['search']['value'];

        //log_message('error', 'DataTables Params: ' . json_encode($_POST));
        // Custom form fields
        $fromdate           = isset($_POST['fromdate']) ? $_POST['fromdate'] : '';
        $todate             = isset($_POST['todate']) ? $_POST['todate'] : '';
        $origin_city        = isset($_POST['origin_city']) ? $_POST['origin_city'] : '';
        $origin_pin         = isset($_POST['origin_pin']) ? $_POST['origin_pin'] : '';
        $destination_city   = isset($_POST['destination_city']) ? $_POST['destination_city'] : '';
        $destination_pin    = isset($_POST['destination_pin']) ? $_POST['destination_pin'] : '';
        $searchcustomer_id  = isset($_POST['searchcustomer_id']) ? $_POST['searchcustomer_id'] : '';
        $searchcarrier_id   = isset($_POST['searchcarrier_id']) ? $_POST['searchcarrier_id'] : '';
        $destination_state  = isset($_POST['destination_state']) ? $_POST['destination_state'] : '';
        $carrier_region     = isset($_POST['carrier_region']) ? $_POST['carrier_region'] : '';
        $cust_zone          = isset($_POST['cust_zone']) ? $_POST['cust_zone'] : '';
        $carrier_zone       = isset($_POST['carrier_zone']) ? $_POST['carrier_zone'] : '';

        // Build where/filter arrays
        $where = [];
        $whr   = [];
        $where['tc.status'] = '1';
        $where['tc.user_id'] = $this->session->userdata('user_id');

        if ($fromdate != "") {
            $from_date_obj = DateTime::createFromFormat('d-m-Y', $fromdate);
            if ($from_date_obj !== false) {
                $where["DATE(tc.createdon) >="] = $from_date_obj->format('Y-m-d');
            }
        }
        if ($todate != "") {
            $to_date_obj = DateTime::createFromFormat('d-m-Y', $todate);
            if ($to_date_obj !== false) {
                $where["DATE(tc.createdon) <="] = $to_date_obj->format('Y-m-d');
            }
        }

        if ($origin_city != "")        $whr['tc.origin_city'] = $origin_city;
        if ($origin_pin != "")         $whr['tc.origin_pin'] = $origin_pin;
        if ($destination_city != "")   $whr['tc.destination_city'] = $destination_city;
        if ($destination_pin != "")    $whr['tc.destination_pin'] = $destination_pin;
        if ($searchcustomer_id != "") {
            $cust_id = $this->common->gettblrowdata(['code' => $searchcustomer_id], 'id', 'tb_customers', 0, 0);
            if ($cust_id) $whr['tc.customer_id'] = $cust_id['id'];
        }
        if ($searchcarrier_id != "")   $whr['tc.carrier_id'] = $searchcarrier_id;
        if ($destination_state != "")  $whr['tc.destination_state'] = $destination_state;
        if ($cust_zone != "")          $whr['tc.cust_zone'] = $cust_zone;
        if ($carrier_zone != "")       $whr['tc.carrier_zone'] = $carrier_zone;
        if ($carrier_region != "")     $whr['tc.carrier_region'] = $carrier_region;
        // Optional: handle global search
        if ($searchValue != "") {
            $whr['global_search'] = $searchValue; // implement in your model
        }

        $recordsTotal = $this->Uniqlomodel->countAll();
        $recordsFiltered = $this->Uniqlomodel->countAll($where, $whr);


        $pincodes = $this->Uniqlomodel->searchdata($where, $whr, $length, $start);
        $data = [];

        foreach ($pincodes as $pin) {
            $data[] = [
                "id" => $pin['id'],
                "origin_city" => $pin['origin_city'],
                "origin_pin" => $pin['origin_pin'],
                "destination_city" => $pin['destination_city'],
                "destination_pin" => $pin['destination_pin'],
                "code" => $pin['code'],
                "cust_zone" => $pin['cust_zone'],
                "cust_region" => $pin['cust_region'],
                "cust_surface_tat" => $pin['cust_surface_tat'],
                "cust_return_surface_tat" => $pin['cust_return_surface_tat'],
                "destination_state" => $pin['destination_state'],
                "carrier_name" => $pin['carrier_name'],
                "carrier_zone" => $pin['carrier_zone'],
                "carrier_region" => $pin['carrier_region'],
                "carrier_surface_tat" => $pin['carrier_surface_tat'],
                "carrier_return_surface_tat" => $pin['carrier_return_surface_tat'],
                "reverse_qc" => ($pin['reverse_qc'] == 1 ? 'Yes' : 'No'),
                "createdon" => $pin['createdon'],
                "status" => ($pin['status'] == 1 ? 'Active' : 'Inactive')
            ];
        }

        /*log_message('error', 'DataTables Response: ' . json_encode([
            "draw" => intval($draw),
            "recordsTotal" => intval($recordsTotal),
            "recordsFiltered" => intval($recordsFiltered),
            "data" => $data
        ]));*/
        echo json_encode([
            "draw" => intval($draw),
            "recordsTotal" => intval($recordsTotal),
            "recordsFiltered" => intval($recordsFiltered),
            "data" => $data
        ]);
    }

}
